/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.mapyrus.Argument;
import org.mapyrus.Constants;
import org.mapyrus.ContextStack;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.NumericalAnalysis;
import org.mapyrus.Preprocessor;
import org.mapyrus.function.Function;
import org.mapyrus.function.FunctionTable;

public class Expression {
    private static final int NO_OPERATION = 0;
    private static final int PLUS_OPERATION = 1;
    private static final int CONCAT_OPERATION = 2;
    private static final int MINUS_OPERATION = 3;
    private static final int MULTIPLY_OPERATION = 4;
    private static final int REPEAT_OPERATION = 5;
    private static final int DIVIDE_OPERATION = 6;
    private static final int MODULO_OPERATION = 7;
    private static final int LEXICAL_EQUALS_OPERATION = 100;
    private static final int LEXICAL_NOT_EQUALS_OPERATION = 101;
    private static final int LEXICAL_GREATER_THAN_OPERATION = 102;
    private static final int LEXICAL_LESS_THAN_OPERATION = 103;
    private static final int LEXICAL_GREATER_EQUAL_OPERATION = 104;
    private static final int LEXICAL_LESS_EQUAL_OPERATION = 105;
    private static final int NUMERIC_EQUALS_OPERATION = 200;
    private static final int NUMERIC_NOT_EQUALS_OPERATION = 201;
    private static final int NUMERIC_GREATER_THAN_OPERATION = 202;
    private static final int NUMERIC_LESS_THAN_OPERATION = 203;
    private static final int NUMERIC_GREATER_EQUAL_OPERATION = 204;
    private static final int NUMERIC_LESS_EQUAL_OPERATION = 205;
    private static final int CONDITIONAL_OPERATION = 300;
    private static final int ASSIGN_OPERATION = 400;
    private static final int PRE_INCREMENT_OPERATION = 401;
    private static final int PRE_DECREMENT_OPERATION = 402;
    private static final int POST_INCREMENT_OPERATION = 403;
    private static final int POST_DECREMENT_OPERATION = 404;
    private static final int AND_OPERATION = 500;
    private static final int OR_OPERATION = 501;
    private static final int NOT_OPERATION = 502;
    private static final int HASHMAP_REFERENCE = 600;
    ExpressionTreeNode mExprTree;

    private ExpressionTreeNode parseAssignment(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        ExpressionTreeNode expressionTreeNode;
        block3: {
            int n;
            expressionTreeNode = this.parseOrBoolean(preprocessor, hashMap);
            while ((n = preprocessor.readNonSpace()) == 61) {
                int n2 = preprocessor.read();
                preprocessor.unread(n2);
                if (n2 != 61) {
                    if (expressionTreeNode.mIsLeaf ? expressionTreeNode.mLeafArg.getType() != 3 : expressionTreeNode.mOperation != 600) {
                        throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("variableexpected"));
                    }
                    ExpressionTreeNode expressionTreeNode2 = this.parseOrBoolean(preprocessor, hashMap);
                    expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, 400, expressionTreeNode2);
                    continue;
                }
                preprocessor.unread(n);
                break block3;
            }
            preprocessor.unread(n);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseOrBoolean(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        ExpressionTreeNode expressionTreeNode;
        block2: {
            int n;
            expressionTreeNode = this.parseAndBoolean(preprocessor, hashMap);
            while ((n = preprocessor.readNonSpace()) == 111 || n == 79) {
                int n2 = preprocessor.read();
                if (n2 == 114 || n2 == 82) {
                    ExpressionTreeNode expressionTreeNode2 = this.parseAndBoolean(preprocessor, hashMap);
                    expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, 501, expressionTreeNode2);
                    continue;
                }
                preprocessor.unread(n2);
                preprocessor.unread(n);
                break block2;
            }
            preprocessor.unread(n);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseAndBoolean(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        ExpressionTreeNode expressionTreeNode;
        block4: {
            int n;
            expressionTreeNode = this.parseNotBoolean(preprocessor, hashMap);
            while ((n = preprocessor.readNonSpace()) == 97 || n == 65) {
                int n2 = preprocessor.read();
                if (n2 == 110 || n2 == 78) {
                    int n3 = preprocessor.read();
                    if (n3 == 100 || n3 == 68) {
                        ExpressionTreeNode expressionTreeNode2 = this.parseNotBoolean(preprocessor, hashMap);
                        expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, 500, expressionTreeNode2);
                        continue;
                    }
                    preprocessor.unread(n3);
                    preprocessor.unread(n2);
                    preprocessor.unread(n);
                } else {
                    preprocessor.unread(n2);
                    preprocessor.unread(n);
                }
                break block4;
            }
            preprocessor.unread(n);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseNotBoolean(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        ExpressionTreeNode expressionTreeNode = null;
        int n = preprocessor.readNonSpace();
        if (n == 110 || n == 78) {
            int n2 = preprocessor.read();
            if (n2 == 111 || n2 == 79) {
                int n3 = preprocessor.read();
                if (n3 == 116 || n3 == 84) {
                    int n4 = preprocessor.read();
                    if (!Character.isLetterOrDigit((char)n4) && n4 != 95 && n4 != 46) {
                        ExpressionTreeNode expressionTreeNode2 = this.parseNotBoolean(preprocessor, hashMap);
                        expressionTreeNode = new ExpressionTreeNode(expressionTreeNode2, 502, null);
                    } else {
                        preprocessor.unread(n4);
                        preprocessor.unread(n3);
                        preprocessor.unread(n2);
                        preprocessor.unread(n);
                    }
                } else {
                    preprocessor.unread(n3);
                    preprocessor.unread(n2);
                    preprocessor.unread(n);
                }
            } else {
                preprocessor.unread(n2);
                preprocessor.unread(n);
            }
        } else {
            preprocessor.unread(n);
        }
        if (expressionTreeNode == null) {
            expressionTreeNode = this.parseConditional(preprocessor, hashMap);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseConditional(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        int n;
        ExpressionTreeNode expressionTreeNode = this.parseComparison(preprocessor, hashMap);
        while ((n = preprocessor.readNonSpace()) == 63) {
            ExpressionTreeNode expressionTreeNode2 = this.parseAssignment(preprocessor, hashMap);
            n = preprocessor.readNonSpace();
            if (n == 58) {
                ExpressionTreeNode expressionTreeNode3 = this.parseAssignment(preprocessor, hashMap);
                expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, 300, expressionTreeNode2, expressionTreeNode3);
                continue;
            }
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidconditional"));
        }
        preprocessor.unread(n);
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseComparison(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        int n;
        ExpressionTreeNode expressionTreeNode = this.parseExpression(preprocessor, hashMap);
        while (true) {
            int n2;
            int n3 = 0;
            n = preprocessor.readNonSpace();
            if (n == 60 || n == 62 || n == 33 || n == 61) {
                n2 = preprocessor.read();
                if (n2 == 61) {
                    n3 = n == 61 ? 200 : (n == 33 ? 201 : (n == 60 ? 205 : 204));
                } else {
                    preprocessor.unread(n2);
                    if (n == 60) {
                        n3 = 203;
                    } else if (n == 62) {
                        n3 = 202;
                    }
                }
            } else if (n == 108 || n == 101 || n == 103 || n == 110) {
                n2 = preprocessor.read();
                if (n == 110 && n2 == 101) {
                    n3 = 101;
                } else if (n == 101 && n2 == 113) {
                    n3 = 100;
                } else if (n == 108 && n2 == 116) {
                    n3 = 103;
                } else if (n == 108 && n2 == 101) {
                    n3 = 105;
                } else if (n == 103 && n2 == 116) {
                    n3 = 102;
                } else if (n == 103 && n2 == 101) {
                    n3 = 104;
                } else {
                    preprocessor.unread(n2);
                }
            }
            if (n3 == 0) break;
            ExpressionTreeNode expressionTreeNode2 = this.parseExpression(preprocessor, hashMap);
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, n3, expressionTreeNode2);
        }
        preprocessor.unread(n);
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseExpression(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        int n;
        ExpressionTreeNode expressionTreeNode = this.parseTerm(preprocessor, hashMap);
        while ((n = preprocessor.readNonSpace()) == 43 || n == 45 || n == 46) {
            ExpressionTreeNode expressionTreeNode2 = this.parseTerm(preprocessor, hashMap);
            int n2 = n == 43 ? 1 : (n == 45 ? 3 : 2);
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, n2, expressionTreeNode2);
        }
        preprocessor.unread(n);
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseTerm(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        int n;
        ExpressionTreeNode expressionTreeNode = this.parseUnary(preprocessor, hashMap);
        while ((n = preprocessor.readNonSpace()) == 42 || n == 47 || n == 120 || n == 37) {
            int n2 = n == 42 ? 4 : (n == 47 ? 6 : (n == 37 ? 7 : 5));
            ExpressionTreeNode expressionTreeNode2 = this.parseUnary(preprocessor, hashMap);
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, n2, expressionTreeNode2);
        }
        preprocessor.unread(n);
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseUnary(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        int n = preprocessor.readNonSpace();
        if (n != 43 && n != 45) {
            preprocessor.unread(n);
        } else {
            int n2 = preprocessor.read();
            preprocessor.unread(n2);
            if (n2 == n) {
                preprocessor.unread(n);
                n = 32;
            }
        }
        ExpressionTreeNode expressionTreeNode = this.parsePlusPlus(preprocessor, hashMap);
        if (n == 45) {
            ExpressionTreeNode expressionTreeNode2 = new ExpressionTreeNode(Argument.numericMinusOne);
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode2, 4, expressionTreeNode);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parsePlusPlus(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        int n;
        int n2 = 0;
        int n3 = preprocessor.readNonSpace();
        if (n3 == 43 || n3 == 45) {
            n = preprocessor.read();
            if (n == n3) {
                n2 = n3 == 43 ? 401 : 402;
            } else {
                preprocessor.unread(n);
                preprocessor.unread(n3);
            }
        } else {
            preprocessor.unread(n3);
        }
        ExpressionTreeNode expressionTreeNode = this.parseHashMapReference(preprocessor, hashMap);
        n3 = preprocessor.readNonSpace();
        if (n3 == 43 || n3 == 45) {
            n = preprocessor.read();
            if (n == n3) {
                if (n2 != 0) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
                }
                n2 = n3 == 43 ? 403 : 404;
            } else {
                preprocessor.unread(n);
                preprocessor.unread(n3);
            }
        } else {
            preprocessor.unread(n3);
        }
        if (n2 != 0) {
            if (!(expressionTreeNode.mIsLeaf && expressionTreeNode.mLeafArg.getType() == 3 || expressionTreeNode.mOperation == 600)) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("variableexpected"));
            }
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, n2, null);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseHashMapReference(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        int n;
        ExpressionTreeNode expressionTreeNode = this.parseFactor(preprocessor, hashMap);
        while ((n = preprocessor.readNonSpace()) == 91) {
            ExpressionTreeNode expressionTreeNode2 = this.parseAssignment(preprocessor, hashMap);
            n = preprocessor.readNonSpace();
            if (n != 93) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": ']'");
            }
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, 600, expressionTreeNode2);
        }
        preprocessor.unread(n);
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseFactor(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        ExpressionTreeNode expressionTreeNode;
        StringBuffer stringBuffer = new StringBuffer();
        int n = preprocessor.readNonSpace();
        if (n == 39 || n == 34) {
            int n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int n3 = 0;
            int n4 = 0;
            while ((n = preprocessor.read()) != n2 || bl) {
                if (n == -1) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
                }
                if (bl2) {
                    if (Character.isDigit((char)n) && n3 < 3) {
                        n4 *= 8;
                        n4 += n - 48;
                        ++n3;
                    } else {
                        stringBuffer.append((char)n4);
                        bl2 = false;
                    }
                }
                if (bl2) continue;
                if (bl) {
                    if (n == 110) {
                        stringBuffer.append(Constants.LINE_SEPARATOR);
                    } else if (n == 116) {
                        stringBuffer.append("\t");
                    } else if (Character.isDigit((char)n)) {
                        bl2 = true;
                        n4 = n - 48;
                        n3 = 1;
                    } else if (n != 114) {
                        stringBuffer.append((char)n);
                    }
                    bl = false;
                    continue;
                }
                if (n == 92) {
                    bl = true;
                    continue;
                }
                stringBuffer.append((char)n);
            }
            if (bl2) {
                stringBuffer.append((char)n4);
            }
            return new ExpressionTreeNode(new Argument(1, stringBuffer.toString()));
        }
        if (Character.isDigit((char)n) || n == 46) {
            boolean bl = false;
            while (Character.isDigit((char)n)) {
                bl = true;
                stringBuffer.append((char)n);
                n = preprocessor.read();
            }
            if (n == 46) {
                stringBuffer.append((char)n);
                n = preprocessor.read();
            }
            while (Character.isDigit((char)n)) {
                bl = true;
                stringBuffer.append((char)n);
                n = preprocessor.read();
            }
            if (!bl) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidnumber"));
            }
            if (n == 101 || n == 69) {
                stringBuffer.append((char)n);
                n = preprocessor.read();
                if (n == 43 || n == 45) {
                    stringBuffer.append((char)n);
                    n = preprocessor.read();
                }
                if (!Character.isDigit((char)n)) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidnumber"));
                }
                while (Character.isDigit((char)n)) {
                    stringBuffer.append((char)n);
                    n = preprocessor.read();
                }
            }
            preprocessor.unread(n);
            double d = 0.0;
            try {
                d = Double.parseDouble(stringBuffer.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new ExpressionTreeNode(new Argument(d));
        }
        if (n == -1) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (n == 40) {
            expressionTreeNode = this.parseAssignment(preprocessor, hashMap);
            n = preprocessor.readNonSpace();
            if (n != 41) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unmatchedbracket"));
            }
        } else if (Character.isLetter((char)n) || n == 36) {
            stringBuffer.append((char)n);
            n = preprocessor.read();
            while (n != -1 && (n == 46 || n == 95 || n == 58 || Character.isLetterOrDigit((char)n))) {
                stringBuffer.append((char)n);
                n = preprocessor.read();
            }
            Function function = FunctionTable.getFunction(stringBuffer.toString());
            if (function == null) {
                function = (Function)hashMap.get(stringBuffer.toString());
            }
            if (function != null) {
                if (Character.isWhitespace((char)n)) {
                    n = preprocessor.readNonSpace();
                }
                if (n != 40) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": '('");
                }
                int n5 = function.getMinArgumentCount();
                int n6 = function.getMaxArgumentCount();
                ArrayList<ExpressionTreeNode> arrayList = new ArrayList<ExpressionTreeNode>(4);
                for (int i = 0; i < n6; ++i) {
                    n = preprocessor.readNonSpace();
                    if (n == 41) {
                        if (i < n5) {
                            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongfunctionvalues") + ": " + stringBuffer.toString());
                        }
                        preprocessor.unread(n);
                        break;
                    }
                    if (i == 0) {
                        preprocessor.unread(n);
                    } else if (n != 44) {
                        throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongfunctionvalues") + ": " + stringBuffer.toString());
                    }
                    ExpressionTreeNode expressionTreeNode2 = this.parseAssignment(preprocessor, hashMap);
                    arrayList.add(expressionTreeNode2);
                }
                if ((n = preprocessor.readNonSpace()) != 41) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongfunctionvalues") + ": " + stringBuffer.toString());
                }
                expressionTreeNode = new ExpressionTreeNode(function, arrayList);
            } else {
                preprocessor.unread(n);
                expressionTreeNode = new ExpressionTreeNode(new Argument(3, stringBuffer.toString()));
            }
        } else {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
        }
        return expressionTreeNode;
    }

    public Expression(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        this.mExprTree = this.parseAssignment(preprocessor, hashMap);
    }

    public Expression(double d) {
        this.mExprTree = new ExpressionTreeNode(new Argument(d));
    }

    public Expression(String string) {
        this.mExprTree = new ExpressionTreeNode(new Argument(1, string));
    }

    public Argument evaluate(ContextStack contextStack, String string) throws MapyrusException {
        return this.mExprTree.evaluate(contextStack, string);
    }

    public String getVariableName() {
        if (this.mExprTree.mIsLeaf && this.mExprTree.mLeafArg.getType() == 3) {
            return this.mExprTree.mLeafArg.getVariableName();
        }
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            ContextStack contextStack = new ContextStack();
            HashMap hashMap = new HashMap();
            contextStack.defineVariable("pi", new Argument(3.1415));
            Preprocessor preprocessor = new Preprocessor(stringArray[0]);
            Expression expression = new Expression(preprocessor, hashMap);
            preprocessor.read();
            Expression expression2 = new Expression(preprocessor, hashMap);
            Argument argument = expression.evaluate(contextStack, "test");
            Argument argument2 = expression2.evaluate(contextStack, "test");
            if (argument.getType() == 0) {
                System.out.println("a1=" + argument.getNumericValue());
            } else {
                System.out.println("a1 = " + argument.getStringValue());
            }
            if (argument2.getType() == 0) {
                System.out.println("a2=" + argument2.getNumericValue());
            } else {
                System.out.println("a2 = " + argument2.getStringValue());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (MapyrusException mapyrusException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpressionTreeNode {
        boolean mIsLeaf;
        Argument mLeafArg;
        int mOperation;
        ArrayList<ExpressionTreeNode> mBranches;
        boolean mIsFunction;
        Function mFunction;

        public ExpressionTreeNode(Argument argument) {
            this.mIsLeaf = true;
            this.mIsFunction = false;
            this.mLeafArg = argument;
        }

        public ExpressionTreeNode(ExpressionTreeNode expressionTreeNode, int n, ExpressionTreeNode expressionTreeNode2) {
            this.mIsFunction = false;
            this.mIsLeaf = false;
            this.mBranches = new ArrayList(2);
            this.mBranches.add(expressionTreeNode);
            this.mBranches.add(expressionTreeNode2);
            this.mOperation = n;
        }

        public ExpressionTreeNode(ExpressionTreeNode expressionTreeNode, int n, ExpressionTreeNode expressionTreeNode2, ExpressionTreeNode expressionTreeNode3) {
            this.mIsFunction = false;
            this.mIsLeaf = false;
            this.mBranches = new ArrayList(3);
            this.mBranches.add(expressionTreeNode);
            this.mBranches.add(expressionTreeNode2);
            this.mBranches.add(expressionTreeNode3);
            this.mOperation = n;
        }

        public ExpressionTreeNode(Function function, ArrayList<ExpressionTreeNode> arrayList) {
            this.mIsLeaf = false;
            this.mIsFunction = true;
            this.mFunction = function;
            this.mBranches = arrayList;
        }

        public Argument evaluate(ContextStack contextStack, String string) throws MapyrusException {
            return this.traverse(this, contextStack, string);
        }

        private Argument evaluateFunction(ContextStack contextStack, String string) throws MapyrusException {
            Argument argument;
            int n = this.mBranches.size();
            ArrayList<Argument> arrayList = new ArrayList<Argument>(n);
            for (int i = 0; i < n; ++i) {
                ExpressionTreeNode expressionTreeNode = this.mBranches.get(i);
                arrayList.add(this.traverse(expressionTreeNode, contextStack, string));
            }
            try {
                argument = this.mFunction.evaluate(contextStack, arrayList);
            }
            catch (MapyrusException mapyrusException) {
                throw new MapyrusException(this.mFunction.getName() + ": " + mapyrusException.getMessage());
            }
            return argument;
        }

        private Argument traverse(ExpressionTreeNode expressionTreeNode, ContextStack contextStack, String string) throws MapyrusException {
            Argument argument;
            boolean bl = false;
            double d = 0.0;
            String string2 = null;
            if (expressionTreeNode.mIsLeaf) {
                if (expressionTreeNode.mLeafArg.getType() == 3) {
                    argument = contextStack.getVariableValue(expressionTreeNode.mLeafArg.getVariableName(), string);
                    if (argument == null) {
                        argument = Argument.emptyString;
                    }
                } else {
                    argument = expressionTreeNode.mLeafArg;
                }
            } else if (expressionTreeNode.mIsFunction) {
                argument = expressionTreeNode.evaluateFunction(contextStack, string);
            } else if (expressionTreeNode.mOperation == 502) {
                double d2;
                ExpressionTreeNode expressionTreeNode2 = expressionTreeNode.mBranches.get(0);
                Argument argument2 = this.traverse(expressionTreeNode2, contextStack, string);
                argument = argument2.getType() == 0 ? (NumericalAnalysis.equals(d2 = argument2.getNumericValue(), 0.0) ? Argument.numericOne : Argument.numericZero) : (argument2.getStringValue().length() == 0 ? Argument.numericOne : Argument.numericZero);
            } else if (expressionTreeNode.mOperation == 400 || expressionTreeNode.mOperation == 401 || expressionTreeNode.mOperation == 402 || expressionTreeNode.mOperation == 403 || expressionTreeNode.mOperation == 404) {
                Object object;
                Argument argument3;
                ExpressionTreeNode expressionTreeNode3 = expressionTreeNode.mBranches.get(0);
                Argument argument4 = null;
                if (expressionTreeNode.mOperation == 401) {
                    argument3 = this.traverse(expressionTreeNode3, contextStack, string);
                    argument3 = new Argument(argument3.getNumericValue() + 1.0);
                } else if (expressionTreeNode.mOperation == 402) {
                    argument3 = this.traverse(expressionTreeNode3, contextStack, string);
                    argument3 = new Argument(argument3.getNumericValue() - 1.0);
                } else if (expressionTreeNode.mOperation == 403) {
                    argument4 = this.traverse(expressionTreeNode3, contextStack, string);
                    if (argument4 == Argument.emptyString) {
                        argument4 = Argument.numericZero;
                    }
                    argument3 = new Argument(argument4.getNumericValue() + 1.0);
                } else if (expressionTreeNode.mOperation == 404) {
                    argument4 = this.traverse(expressionTreeNode3, contextStack, string);
                    if (argument4 == Argument.emptyString) {
                        argument4 = Argument.numericZero;
                    }
                    argument3 = new Argument(argument4.getNumericValue() - 1.0);
                } else {
                    object = expressionTreeNode.mBranches.get(1);
                    argument3 = this.traverse((ExpressionTreeNode)object, contextStack, string);
                }
                if (expressionTreeNode3.mIsLeaf) {
                    object = expressionTreeNode3.mLeafArg.getVariableName();
                    contextStack.defineVariable((String)object, argument3);
                } else if (expressionTreeNode3.mOperation == 600 && expressionTreeNode3.mBranches.get((int)0).mIsLeaf) {
                    object = expressionTreeNode3.mBranches.get((int)0).mLeafArg.getVariableName();
                    if (object == null) {
                        throw new MapyrusException(MapyrusMessages.get("invalidvariable"));
                    }
                    Argument argument5 = this.traverse(expressionTreeNode3.mBranches.get(1), contextStack, string);
                    if (argument5.getType() != 0 && argument5.getType() != 1) {
                        throw new MapyrusException(MapyrusMessages.get("invalidhashmapkey"));
                    }
                    contextStack.defineHashMapEntry((String)object, argument5.getStringValue(), argument3);
                } else {
                    throw new MapyrusException(MapyrusMessages.get("invalidvariable"));
                }
                argument = expressionTreeNode.mOperation == 403 || expressionTreeNode.mOperation == 404 ? argument4 : argument3;
            } else if (expressionTreeNode.mOperation == 600) {
                Argument argument6;
                Object object;
                ExpressionTreeNode expressionTreeNode4 = expressionTreeNode.mBranches.get(0);
                ExpressionTreeNode expressionTreeNode5 = expressionTreeNode.mBranches.get(1);
                if (expressionTreeNode4.mIsLeaf && expressionTreeNode4.mLeafArg.getType() == 3) {
                    object = expressionTreeNode4.mLeafArg.getVariableName();
                    argument6 = contextStack.getVariableValue((String)object, string);
                } else if (expressionTreeNode4.mIsFunction) {
                    argument6 = this.traverse(expressionTreeNode4, contextStack, string);
                } else {
                    throw new MapyrusException(MapyrusMessages.get("variableexpected"));
                }
                object = this.traverse(expressionTreeNode5, contextStack, string);
                if (((Argument)object).getType() != 0 && ((Argument)object).getType() != 1) {
                    throw new MapyrusException(MapyrusMessages.get("invalidhashmapkey"));
                }
                argument = argument6 == null || argument6.getType() != 2 ? Argument.emptyString : argument6.getHashMapEntry(((Argument)object).getStringValue());
            } else if (expressionTreeNode.mOperation == 300) {
                ExpressionTreeNode expressionTreeNode6 = expressionTreeNode.mBranches.get(0);
                Argument argument7 = this.traverse(expressionTreeNode6, contextStack, string);
                if (argument7.getNumericValue() != 0.0) {
                    ExpressionTreeNode expressionTreeNode7 = expressionTreeNode.mBranches.get(1);
                    argument = this.traverse(expressionTreeNode7, contextStack, string);
                } else {
                    ExpressionTreeNode expressionTreeNode8 = expressionTreeNode.mBranches.get(2);
                    argument = this.traverse(expressionTreeNode8, contextStack, string);
                }
            } else {
                ExpressionTreeNode expressionTreeNode9 = expressionTreeNode.mBranches.get(0);
                ExpressionTreeNode expressionTreeNode10 = expressionTreeNode.mBranches.get(1);
                Argument argument8 = this.traverse(expressionTreeNode9, contextStack, string);
                Argument argument9 = this.traverse(expressionTreeNode10, contextStack, string);
                switch (expressionTreeNode.mOperation) {
                    case 1: {
                        d = argument8.getNumericValue() + argument9.getNumericValue();
                        bl = false;
                        break;
                    }
                    case 2: {
                        string2 = argument8.toString() + argument9.toString();
                        bl = true;
                        break;
                    }
                    case 3: {
                        d = argument8.getNumericValue() - argument9.getNumericValue();
                        bl = false;
                        break;
                    }
                    case 4: {
                        d = argument8.getNumericValue() * argument9.getNumericValue();
                        bl = false;
                        break;
                    }
                    case 5: {
                        StringBuffer stringBuffer = new StringBuffer();
                        int n = (int)Math.floor(argument9.getNumericValue());
                        for (int i = 0; i < n; ++i) {
                            stringBuffer.append(argument8.toString());
                        }
                        string2 = stringBuffer.toString();
                        bl = true;
                        break;
                    }
                    case 6: {
                        d = argument8.getNumericValue() / argument9.getNumericValue();
                        bl = false;
                        break;
                    }
                    case 7: {
                        d = NumericalAnalysis.fmod(argument8.getNumericValue(), argument9.getNumericValue());
                        bl = false;
                        break;
                    }
                    case 200: {
                        double d3 = argument8.getNumericValue();
                        double d4 = argument9.getNumericValue();
                        d = NumericalAnalysis.equals(d3, d4) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 201: {
                        double d5 = argument8.getNumericValue();
                        double d6 = argument9.getNumericValue();
                        d = NumericalAnalysis.equals(d5, d6) ? 0.0 : 1.0;
                        bl = false;
                        break;
                    }
                    case 202: {
                        double d7 = argument8.getNumericValue();
                        double d8 = argument9.getNumericValue();
                        d = d7 > d8 && !NumericalAnalysis.equals(d7, d8) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 204: {
                        double d9 = argument8.getNumericValue();
                        double d10 = argument9.getNumericValue();
                        d = d9 > d10 || NumericalAnalysis.equals(d9, d10) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 203: {
                        double d11 = argument8.getNumericValue();
                        double d12 = argument9.getNumericValue();
                        d = d11 < d12 && !NumericalAnalysis.equals(d11, d12) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 205: {
                        double d13 = argument8.getNumericValue();
                        double d14 = argument9.getNumericValue();
                        d = d13 < d14 || NumericalAnalysis.equals(d13, d14) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 500: {
                        d = argument8.getNumericValue() != 0.0 && argument9.getNumericValue() != 0.0 ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 501: {
                        d = argument8.getNumericValue() != 0.0 || argument9.getNumericValue() != 0.0 ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 100: {
                        d = argument8.toString().equals(argument9.toString()) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 101: {
                        d = argument8.toString().equals(argument9.toString()) ? 0.0 : 1.0;
                        bl = false;
                        break;
                    }
                    case 102: {
                        d = argument8.toString().compareTo(argument9.toString()) > 0 ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 104: {
                        d = argument8.toString().compareTo(argument9.toString()) >= 0 ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 103: {
                        d = argument8.toString().compareTo(argument9.toString()) < 0 ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 105: {
                        d = argument8.toString().compareTo(argument9.toString()) <= 0 ? 1.0 : 0.0;
                        bl = false;
                    }
                }
                if (!bl) {
                    if (Double.isInfinite(d) || Double.isNaN(d)) {
                        throw new MapyrusException(MapyrusMessages.get("numericoverflow"));
                    }
                    argument = d == 0.0 ? Argument.numericZero : (d == 1.0 ? Argument.numericOne : new Argument(d));
                } else {
                    argument = string2.length() == 0 ? Argument.emptyString : new Argument(1, string2);
                }
            }
            return argument;
        }

        public String toString() {
            String string;
            if (this.mIsLeaf) {
                string = this.mLeafArg.toString();
            } else {
                ExpressionTreeNode expressionTreeNode;
                String string2 = "";
                switch (this.mOperation) {
                    case 1: {
                        string2 = "+";
                        break;
                    }
                    case 2: {
                        string2 = ".";
                        break;
                    }
                    case 3: {
                        string2 = "-";
                        break;
                    }
                    case 4: {
                        string2 = "*";
                        break;
                    }
                    case 5: {
                        string2 = "x";
                        break;
                    }
                    case 6: {
                        string2 = "/";
                        break;
                    }
                    case 7: {
                        string2 = "%";
                        break;
                    }
                    case 100: {
                        string2 = "eq";
                        break;
                    }
                    case 101: {
                        string2 = "ne";
                        break;
                    }
                    case 102: {
                        string2 = "gt";
                        break;
                    }
                    case 103: {
                        string2 = "lt";
                        break;
                    }
                    case 104: {
                        string2 = "ge";
                        break;
                    }
                    case 105: {
                        string2 = "le";
                        break;
                    }
                    case 200: {
                        string2 = "==";
                        break;
                    }
                    case 201: {
                        string2 = "!=";
                        break;
                    }
                    case 202: {
                        string2 = ">";
                        break;
                    }
                    case 203: {
                        string2 = "<";
                        break;
                    }
                    case 204: {
                        string2 = ">=";
                        break;
                    }
                    case 205: {
                        string2 = "<=";
                        break;
                    }
                    case 300: {
                        string2 = "?";
                        break;
                    }
                    case 400: {
                        string2 = "=";
                        break;
                    }
                    case 401: 
                    case 403: {
                        string2 = "++";
                        break;
                    }
                    case 402: 
                    case 404: {
                        string2 = "--";
                        break;
                    }
                    case 500: {
                        string2 = "and";
                        break;
                    }
                    case 501: {
                        string2 = "or";
                        break;
                    }
                    case 502: {
                        string2 = "not";
                        break;
                    }
                    case 600: {
                        string2 = "[";
                    }
                }
                StringBuffer stringBuffer = new StringBuffer();
                ExpressionTreeNode expressionTreeNode2 = this.mBranches.get(0);
                if (this.mOperation == 401 || this.mOperation == 402) {
                    stringBuffer.append(string2);
                    string2 = "";
                }
                stringBuffer.append(expressionTreeNode2.toString());
                stringBuffer.append(' ');
                stringBuffer.append(string2);
                stringBuffer.append(' ');
                if (this.mOperation != 502 && this.mOperation != 401 && this.mOperation != 402) {
                    expressionTreeNode = this.mBranches.get(1);
                    stringBuffer.append(expressionTreeNode.toString());
                }
                if (this.mOperation == 600) {
                    stringBuffer.append(']');
                }
                if (this.mOperation == 300) {
                    expressionTreeNode = this.mBranches.get(2);
                    stringBuffer.append(" : ").append(expressionTreeNode.toString());
                }
                string = stringBuffer.toString();
            }
            return string;
        }
    }
}

