/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class Constants {
    public static final String PROGRAM_NAME = "Mapyrus";
    public static final DecimalFormatSymbols US_DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    public static final AffineTransform IDENTITY_MATRIX = new AffineTransform();
    public static final int MAX_HTTP_THREADS = 8;
    public static final int HTTP_TIMEOUT = 30000;
    public static final int HTTP_TEMPFILE_LIFESPAN = 300000;
    public static final int HTTP_SOCKET_TIMEOUT = 30000;
    public static final int MAX_HTTP_REQUEST_TIME = 600000;
    public static final int DB_CONNECTION_TIMEOUT = 30;
    public static final int DB_IDLE_TIMEOUT = 600;
    public static final int ICON_CACHE_SIZE = 64;
    public static final int POINTS_PER_INCH = 72;
    public static final double MM_PER_INCH = 25.4;
    private static int mScreenResolution;
    public static final String LINE_SEPARATOR;

    public static String getVersion() {
        return "0.807";
    }

    public static String getReleaseDate() {
        return "29-December-2008";
    }

    public static final int getScreenResolution() {
        if (mScreenResolution == 0) {
            try {
                mScreenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            catch (InternalError internalError) {
                mScreenResolution = 96;
            }
            catch (HeadlessException headlessException) {
                mScreenResolution = 96;
            }
        }
        return mScreenResolution;
    }

    public static final double getScreenWidth() {
        int n = Constants.getScreenResolution();
        double d = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        return d / (double)n * 25.4;
    }

    public static final double getScreenHeight() {
        int n = Constants.getScreenResolution();
        double d = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        return d / (double)n * 25.4;
    }

    public static String getOSName() {
        String string = System.getProperty("os.name");
        string = string == null ? "" : string.toUpperCase();
        return string;
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
    }
}

