/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class GradientFillFactory {
    private static final int IMAGE_SIZE = 300;
    private static BufferedImage mLastImage = null;
    private static Color mLastC1 = Color.BLACK;
    private static Color mLastC2 = Color.BLACK;
    private static Color mLastC3 = Color.BLACK;
    private static Color mLastC4 = Color.BLACK;
    private static Color mLastC5 = Color.BLACK;
    private static short[] c1Weightings = new short[90000];
    private static short[] c2Weightings = new short[90000];
    private static short[] c3Weightings = new short[90000];
    private static short[] c4Weightings = new short[90000];
    private static short[] c5Weightings = new short[90000];

    private static double power8(double d) {
        return d * d * d * d * d * d * d * d;
    }

    public static synchronized BufferedImage getImage(Color color, Color color2, Color color3, Color color4, Color color5) {
        if (color.equals(mLastC1) && color2.equals(mLastC2) && color3.equals(mLastC3) && color4.equals(mLastC4) && (color5 == null && mLastC5 == null || color5 != null && mLastC5 != null && color5.equals(mLastC5))) {
            BufferedImage bufferedImage = mLastImage;
        } else {
            BufferedImage bufferedImage = new BufferedImage(300, 300, 1);
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (int i = 0; i < 300; ++i) {
                for (int j = 0; j < 300; ++j) {
                    int n = i * 300 + j;
                    short s = c1Weightings[n];
                    short s2 = c2Weightings[n];
                    short s3 = c3Weightings[n];
                    short s4 = c4Weightings[n];
                    short s5 = c5Weightings[n];
                    float f4 = s + s2 + s3 + s4;
                    if (color5 != null) {
                        f = (float)s5 / (f4 += (float)s5) * (float)color5.getRed();
                        f2 = (float)s5 / f4 * (float)color5.getGreen();
                        f3 = (float)s5 / f4 * (float)color5.getBlue();
                    }
                    float f5 = (float)s / f4 * (float)color.getRed() + (float)s2 / f4 * (float)color2.getRed() + (float)s3 / f4 * (float)color3.getRed() + (float)s4 / f4 * (float)color4.getRed() + f;
                    float f6 = (float)s / f4 * (float)color.getGreen() + (float)s2 / f4 * (float)color2.getGreen() + (float)s3 / f4 * (float)color3.getGreen() + (float)s4 / f4 * (float)color4.getGreen() + f2;
                    float f7 = (float)s / f4 * (float)color.getBlue() + (float)s2 / f4 * (float)color2.getBlue() + (float)s3 / f4 * (float)color3.getBlue() + (float)s4 / f4 * (float)color4.getBlue() + f3;
                    int n2 = (int)f5 << 16 | (int)f6 << 8 | (int)f7;
                    bufferedImage.setRGB(j, i, n2);
                }
            }
            mLastImage = bufferedImage;
            mLastC1 = color;
            mLastC2 = color2;
            mLastC3 = color3;
            mLastC4 = color4;
            mLastC5 = color5;
        }
        return mLastImage;
    }

    public static void main(String[] stringArray) {
        try {
            BufferedImage bufferedImage = GradientFillFactory.getImage(Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.RED);
            ImageIO.write((RenderedImage)bufferedImage, "png", new File("/tmp/a.png"));
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        System.out.println("Finished");
    }

    static {
        int n = 180000;
        for (int i = 0; i < 300; ++i) {
            for (int j = 0; j < 300; ++j) {
                int n2 = j * j + i * i;
                int n3 = (300 - j) * (300 - j) + i * i;
                int n4 = j * j + (300 - i) * (300 - i);
                int n5 = (300 - j) * (300 - j) + (300 - i) * (300 - i);
                int n6 = (150 - j) * (150 - j) + (150 - i) * (150 - i);
                int n7 = i * 300 + j;
                GradientFillFactory.c1Weightings[n7] = (short)Math.round(32767.0 * GradientFillFactory.power8(1.0 - (double)n4 / (double)n));
                GradientFillFactory.c2Weightings[n7] = (short)Math.round(32767.0 * GradientFillFactory.power8(1.0 - (double)n5 / (double)n));
                GradientFillFactory.c3Weightings[n7] = (short)Math.round(32767.0 * GradientFillFactory.power8(1.0 - (double)n2 / (double)n));
                GradientFillFactory.c4Weightings[n7] = (short)Math.round(32767.0 * GradientFillFactory.power8(1.0 - (double)n3 / (double)n));
                GradientFillFactory.c5Weightings[n7] = (short)Math.round(32767.0 * GradientFillFactory.power8(1.0 - (double)n6 / (double)n));
            }
        }
    }
}

