/***************************************************************************

    Hitachi FD1089A/FD1089B encryption emulation

****************************************************************************

    Copyright Nicola Salmoria, Andreas Naive, and Charles MacDonald.

    All rights reserved.

***************************************************************************/

#ifndef __FD1089_H__
#define __FD1089_H__

#include "cpu/m68000/m68000.h"


//**************************************************************************
//  CONSTANTS
//**************************************************************************

// device type definition
extern const device_type FD1089A;
extern const device_type FD1089B;



//**************************************************************************
//  TYPE DEFINITIONS
//**************************************************************************

// ======================> fd1089_base_device

// base device, shared implementation between A and B variants
class fd1089_base_device : public m68000_device
{
public:
	// construction/destruction
	fd1089_base_device(const machine_config &mconfig, device_type type, const char *tag, device_t *owner, UINT32 clock, char cputype);

	// explicit decryption helpers
	void decrypt(offs_t baseaddr, UINT32 size, offs_t regionoffs, UINT16 *opcodesptr, UINT16 *dataptr) { decrypt(baseaddr, size, &m_plaintext[regionoffs/2], opcodesptr, dataptr); }

protected:
	// device overrides
	virtual void device_start();

	// internal helpers
	UINT8 rearrange_key(UINT8 table, bool opcode);
	UINT8 decode_fd1089a(UINT8 val, UINT8 key, bool opcode);
	UINT8 decode_fd1089b(UINT8 val, UINT8 key, bool opcode);
	UINT16 decrypt_one(offs_t addr, UINT16 val, const UINT8 *key, bool opcode, char cputype);
	void decrypt(offs_t baseaddr, UINT32 size, const UINT16 *srcptr, UINT16 *opcodesptr, UINT16 *dataptr);

	// internal state
	const UINT8 *			m_key;
	char					m_cputype;
	dynamic_array<UINT16>	m_plaintext;
	dynamic_array<UINT16>	m_decrypted_opcodes;

	// internal types
	struct decrypt_parameters
	{
		UINT8 xorval;
		UINT8 s7,s6,s5,s4,s3,s2,s1,s0;
	};

	// static tables
	static const UINT8 s_basetable_fd1089[0x100];
	static const decrypt_parameters s_addr_params[16];
	static const decrypt_parameters s_data_params_a[16];
};


// ======================> fd1089a_device

// FD1089A variant
class fd1089a_device : public fd1089_base_device
{
public:
	// construction/destruction
	fd1089a_device(const machine_config &mconfig, const char *tag, device_t *owner, UINT32 clock)
		: fd1089_base_device(mconfig, FD1089A, tag, owner, clock, 'A') { }
};


// ======================> fd1089b_device

// FD1089B variant
class fd1089b_device : public fd1089_base_device
{
public:
	// construction/destruction
	fd1089b_device(const machine_config &mconfig, const char *tag, device_t *owner, UINT32 clock)
		: fd1089_base_device(mconfig, FD1089B, tag, owner, clock, 'B') { }
};


#endif
