/*

    Scorpion 5

    Skeleton Driver - For note keeping.

    This system is not emulated.

    Several sets have large roms, containing strings which mention Compact Flash cards
     - These appear to be Adder 5 sets, I don't know if they're also meant to have
       regular program roms like sc5 and the Adder 4.

    Many sound roms are missing!

*/


#include "emu.h"
#include "cpu/m68000/m68000.h"
#include "includes/bfm_sc45.h"

class sc5_state : public driver_device
{
public:
	sc5_state(const machine_config &mconfig, device_type type, const char *tag)
		: driver_device(mconfig, type, tag),
		  m_maincpu(*this, "maincpu")
	{ }

protected:

	// devices
	required_device<cpu_device> m_maincpu;
public:
	DECLARE_DRIVER_INIT(sc5);
};


static ADDRESS_MAP_START( sc5_map, AS_PROGRAM, 32, sc5_state )
	AM_RANGE(0x00000000, 0x002fffff) AM_ROM
	AM_RANGE(0x01000000, 0x0100ffff) AM_RAM
	AM_RANGE(0x40000000, 0x40000fff) AM_RAM
ADDRESS_MAP_END

static INPUT_PORTS_START(  sc5 )
INPUT_PORTS_END

static INTERRUPT_GEN( sc5_fake_timer_int )
{
	// this should be coming from the Timer / SIM modules of the Coldfire
	device->machine().device("maincpu")->execute().set_input_line_and_vector(5, HOLD_LINE, 0x8c);
}

static MACHINE_CONFIG_START( sc5, sc5_state )
	MCFG_CPU_ADD("maincpu", MCF5206E, 40000000) /* MCF5206eFT */
	MCFG_CPU_PROGRAM_MAP(sc5_map)
	MCFG_CPU_PERIODIC_INT(sc5_fake_timer_int,1000)

	MCFG_SPEAKER_STANDARD_STEREO("lspeaker", "rspeaker")
	/* unknown sound */
MACHINE_CONFIG_END



ROM_START( sc5plays )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424604.lo", 0x00001, 0x080000, CRC(5246dbec) SHA1(427134776ec8301c2eaea0c998234dd439952749) )
	ROM_LOAD16_BYTE( "95424605.hi", 0x00000, 0x080000, CRC(e975cc4e) SHA1(7dc7700eefded96076cf79d6a16cbcb24c06aa9d) )
	sc_plays_others
ROM_END

ROM_START( sc5playsa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425604.lo", 0x00001, 0x080000, CRC(0b0d5566) SHA1(a8c8ba0f05bd9b17fe7ea97ff25e407b559bfe6e) )
	ROM_LOAD16_BYTE( "95425605.hi", 0x00000, 0x080000, CRC(62e1c485) SHA1(7c006b69c1748ef16e6ba4fdf8684fca58d5f1ff) )
	sc_plays_others
ROM_END



ROM_START( sc5adga )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426374.lo", 0x00001, 0x080000, CRC(e5a83baa) SHA1(893f711cc4c336d590b573a5d2be3eca71f504bb) )
	ROM_LOAD16_BYTE( "95426375.hi", 0x00000, 0x080000, CRC(584703e9) SHA1(81da9b9b69779e1d69a2e771065113f6e3d1228f) )
	sc_adga_others
ROM_END

ROM_START( sc5adgaa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427374.lo", 0x00001, 0x080000, CRC(77d2ba04) SHA1(f192edc5f0c7c487737d5a2b26b481ed37e287c7) )
	ROM_LOAD16_BYTE( "95427375.hi", 0x00000, 0x080000, CRC(35e3bc9f) SHA1(e1b5f9d8f32f10f03ea208e40a759fff663e7af8) )
	sc_adga_others
ROM_END

ROM_START( sc5adgab )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3214p13.hi", 0x00000, 0x080000, CRC(07a89d93) SHA1(ce636454372274955edf61e837b11525916cb059) )
	ROM_LOAD16_BYTE( "p3214p13.lo", 0x00001, 0x080000, CRC(6d132a98) SHA1(d3b4d7d336ab186c2962dc2da9cfc593c9dc182d) )
	sc_adga_others
ROM_END

ROM_START( sc5adgac )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3214s13.hi", 0x00000, 0x080000, CRC(0b9888e7) SHA1(92f6e42782a000163089c60e20f98930a2de0601) )
	ROM_LOAD16_BYTE( "p3214s13.lo", 0x00001, 0x080000, CRC(ab2a0599) SHA1(e0be6369c0ee4d8542f3a29ad4fc9cfe1ad73c62) )
	sc_adga_others
ROM_END



ROM_START( sc5adgtc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3214p11.hi", 0x00000, 0x080000, CRC(dff99bd2) SHA1(4108684ccdb77d723e53a8adb258eb422502b624) )
	ROM_LOAD16_BYTE( "p3214p11.lo", 0x00001, 0x080000, CRC(7bd8446b) SHA1(d0d66edf560fc518b48a3ae93aa51233837479a5) )
	sc_adgtc_others
ROM_END

ROM_START( sc5adgtca )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3214s11.hi", 0x00000, 0x080000, CRC(4869c664) SHA1(4338e941d6756b4f2f4b86a47789ebf956c10333) )
	ROM_LOAD16_BYTE( "p3214s11.lo", 0x00001, 0x080000, CRC(937fe069) SHA1(393671b649608e2f43534636bda42199b2c19f32) )
	sc_adgtc_others
ROM_END



ROM_START( sc5bjob )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95426588.lo", 0x00001, 0x080000, CRC(b56aa911) SHA1(a2d4e93fe7b5d2340c907769adb52cba176f89d1) )
	ROM_LOAD16_BYTE( "g95426589.hi", 0x00000, 0x080000, CRC(ec36a251) SHA1(c636dcfcb7cd0e306bd04ce69b21d8a8072261fe) )
	sc_bjob_others
ROM_END

ROM_START( sc5bjoba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95426620.lo", 0x00001, 0x080000, CRC(ad2605bb) SHA1(e3798ed3bb54415064ab6da7936c5fb9e9a34a23) )
	ROM_LOAD16_BYTE( "g95426621.hi", 0x00000, 0x080000, CRC(8679fcee) SHA1(4903bdca94598ba1c5b65d3ae18d5f0f90b30165) )
	sc_bjob_others
ROM_END

ROM_START( sc5bjobb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95426672.lo", 0x00001, 0x080000, CRC(4d19718f) SHA1(b03b246f23058de1a24ae805389b9901d3d070b0) )
	ROM_LOAD16_BYTE( "g95426673.hi", 0x00000, 0x080000, CRC(d50073e9) SHA1(3e7c5b2ee0d65e596329dc15d638463feed21702) )
	sc_bjob_others
ROM_END

ROM_START( sc5bjobc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95426716.lo", 0x00001, 0x080000, CRC(2acdf369) SHA1(7ee4689b8992a4b65d1a71c16bf69eee5af7f6a7) )
	ROM_LOAD16_BYTE( "g95426717.hi", 0x00000, 0x080000, CRC(2014d898) SHA1(265a112c83b9216928c6febd55da68b5fc89b84e) )
	sc_bjob_others
ROM_END

ROM_START( sc5bjobd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95426892.lo", 0x00001, 0x080000, CRC(f9496abd) SHA1(65f6e5dac4793f8723ff0d38663a74c544be33a3) )
	ROM_LOAD16_BYTE( "g95426893.hi", 0x00000, 0x080000, CRC(1ae5adac) SHA1(ed5b406e198e99feb6249df664b27bbbe098a7aa) )
	sc_bjob_others
ROM_END

ROM_START( sc5bjobe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95427588.lo", 0x00001, 0x080000, CRC(c73c53f6) SHA1(6f7e7befa27b9521817cd275c40f2110331f7bd1) )
	ROM_LOAD16_BYTE( "g95427589.hi", 0x00000, 0x080000, CRC(753bab78) SHA1(b534aaceca3c5a64780071c05cdba6319ed3abc2) )
	sc_bjob_others
ROM_END

ROM_START( sc5bjobf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95427620.lo", 0x00001, 0x080000, CRC(5ea85161) SHA1(bf18d73213e72e532da92a93f143e544f3ae8d0c) )
	ROM_LOAD16_BYTE( "g95427621.hi", 0x00000, 0x080000, CRC(15cb3c62) SHA1(3f0a44c0136ba978a994974cffcf8772cf04c461) )
	sc_bjob_others
ROM_END

ROM_START( sc5bjobg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95427672.lo", 0x00001, 0x080000, CRC(e631253c) SHA1(1222ee7b2e29f2ff52f3f1a2cf3579424400047b) )
	ROM_LOAD16_BYTE( "g95427673.hi", 0x00000, 0x080000, CRC(dd773396) SHA1(92de59a940f7d5b831e3057d159d7e66fb486ba2) )
	sc_bjob_others
ROM_END

ROM_START( sc5bjobh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95427716.lo", 0x00001, 0x080000, CRC(4d461005) SHA1(5283a50b55cd38711f5b48b8c9ed68f9396a5bad) )
	ROM_LOAD16_BYTE( "g95427717.hi", 0x00000, 0x080000, CRC(a8633e1c) SHA1(000d59182c959f44e73d24e1209cc77f2b246eee) )
	sc_bjob_others
ROM_END

ROM_START( sc5bjobi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95427892.lo", 0x00001, 0x080000, CRC(48633820) SHA1(f3d6e9ddda131e5d47116ae41ac1b4b87bbad239) )
	ROM_LOAD16_BYTE( "g95427893.hi", 0x00000, 0x080000, CRC(624dd2ef) SHA1(93818c088859a4b1190daf60907b91da8d836f0b) )
	sc_bjob_others
ROM_END



ROM_START( sc5bkngx )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416328.lo", 0x00001, 0x080000, CRC(5390798a) SHA1(4577812d04ea6ea462d6ba37ba008981e88e5af4) )
	ROM_LOAD16_BYTE( "95416329.hi", 0x00000, 0x080000, CRC(98f21c81) SHA1(822c64d045dbfbf59fdde38a8ad21be0508f4f87) )
	sc_bkngx_others
ROM_END

ROM_START( sc5bkngxa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417328.lo", 0x00001, 0x080000, CRC(817e8314) SHA1(7eb4464c29317e2d505f2b505352f184573adb81) )
	ROM_LOAD16_BYTE( "95417329.hi", 0x00000, 0x080000, CRC(cbb63a7d) SHA1(272d8cc2b7fa499c54bb0561124bcfd7e5a78c23) )
	sc_bkngx_others
ROM_END

ROM_START( sc5bucc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3216p71.hi", 0x00000, 0x080000, CRC(f1ee1a57) SHA1(afc4f9f3840afebe6ec14f5ec6eabe147a080dc1) )
	ROM_LOAD16_BYTE( "p3216p71.lo", 0x00001, 0x080000, CRC(ddc9a6b6) SHA1(4bc541990313e06e11509a7c1afe8ffc2f7a6838) )
	sc_bucc_others
ROM_END

ROM_START( sc5bucca )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3216p72.hi", 0x00000, 0x080000, CRC(9de364fd) SHA1(01c2e3764f339dac2a4b3021969ec71b988ded3b) )
	ROM_LOAD16_BYTE( "p3216p72.lo", 0x00001, 0x080000, CRC(63ab9a8f) SHA1(d74e2389eff4201fce985f280412a4e0c2c83514) )
	sc_bucc_others
ROM_END

ROM_START( sc5buccb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3216p73.hi", 0x00000, 0x080000, CRC(dec91d24) SHA1(9e0123ee969aeca4a8f13312cd58d5816ef2e2a5) )
	ROM_LOAD16_BYTE( "p3216p73.lo", 0x00001, 0x080000, CRC(9f67e4fa) SHA1(b2caac73fbe6e313070fa73c355320f1198d67f1) )
	sc_bucc_others
ROM_END

ROM_START( sc5buccc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3216s71.hi", 0x00000, 0x080000, CRC(e8763ac4) SHA1(aeb3c242ebd35b8b84a1beb0f998d550c258acfe) )
	ROM_LOAD16_BYTE( "p3216s71.lo", 0x00001, 0x080000, CRC(5c72ac7b) SHA1(b6b391fabcc0e68cb967a3c543215e595da10061) )
	sc_bucc_others
ROM_END

ROM_START( sc5buccd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3216s72.hi", 0x00000, 0x080000, CRC(f68d9ac7) SHA1(00a3075d5c85dd530b9370c4c3495e065c66461f) )
	ROM_LOAD16_BYTE( "p3216s72.lo", 0x00001, 0x080000, CRC(0edd2afb) SHA1(3ef1536beed26395b49cd7dcc6902b6b29154cc3) )
	sc_bucc_others
ROM_END

ROM_START( sc5bucce )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3216s73.hi", 0x00000, 0x080000, CRC(79fb2b1e) SHA1(76a46b039212f15869b271fa455b2a1e0fa03318) )
	ROM_LOAD16_BYTE( "p3216s73.lo", 0x00001, 0x080000, CRC(b502b6de) SHA1(db7eb916f310c7ee96cf3f3209c885b1d3a55805) )
	sc_bucc_others
ROM_END



ROM_START( sc5bpfpb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3205p71.hi", 0x00000, 0x080000, CRC(3105b47f) SHA1(379949c5fe6f678966aa28d6ba193b758c119a19) )
	ROM_LOAD16_BYTE( "p3205p71.lo", 0x00001, 0x080000, CRC(9ee5e2cd) SHA1(57dc76b76b501e22e1ee9eec6a4161884910eecc) )
	sc_bpfpb_others
ROM_END


ROM_START( sc5bpfpba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3205s71.hi", 0x00000, 0x080000, CRC(707602d4) SHA1(ff857a84aa5a1779b1ac957da457878f8f0efabd) )
	ROM_LOAD16_BYTE( "p3205s71.lo", 0x00001, 0x080000, CRC(a255a583) SHA1(04d3efe7894180d89c90db1f1fbd5f0d1e1b2764) )
	sc_bpfpb_others
ROM_END



ROM_START( sc5btiab )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1914p11.hi", 0x00000, 0x080000, CRC(be0e6e7d) SHA1(3ce2c1c116991912e875a5ee86060a87739cc61c) )
	ROM_LOAD16_BYTE( "p1914p11.lo", 0x00001, 0x080000, CRC(72ad4175) SHA1(01c7c504098159360c9ed1d6da75c9478d687e53) )
	sc_btiab_others
ROM_END



ROM_START( sc5btrip )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1744p11.hi", 0x00000, 0x080000, CRC(c4634163) SHA1(6d7ed6afcabbe38f3315140b7aa985c0acab1af5) )
	ROM_LOAD16_BYTE( "p1744p11.lo", 0x00001, 0x080000, CRC(aaeef50f) SHA1(eccdbe5951314105ec5a06724582fc021e0dbd2c) )
	PR1743_CASINO_BULLSEYE_SOUNDS11
ROM_END

ROM_START( sc5btripa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1744s11.hi", 0x00000, 0x080000, CRC(89649f68) SHA1(3e785dce35cab75d1e8eaa98b11db7af2bb08b0a) )
	ROM_LOAD16_BYTE( "p1744s11.lo", 0x00001, 0x080000, CRC(08bf00ea) SHA1(9eec569703d71db15d553b9f7a72931fa738f91a) )
	PR1743_CASINO_BULLSEYE_SOUNDS11
ROM_END



ROM_START( sc5bunny )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416270.lo", 0x00001, 0x080000, CRC(c8935320) SHA1(904d34e1fd6245367d7c7d3f5286f5c60e949030) )
	ROM_LOAD16_BYTE( "95416271.hi", 0x00000, 0x080000, CRC(61953e6a) SHA1(44da22a54a198b89e050ec88d4d0c669d09bc79e) )
	sc_bunny_others
ROM_END

ROM_START( sc5bunnya )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417270.lo", 0x00001, 0x080000, CRC(253cdfbe) SHA1(52f4adcbbbc3f0e8844181cdab32d6f4022927d5) )
	ROM_LOAD16_BYTE( "95417271.hi", 0x00000, 0x080000, CRC(3701bf9d) SHA1(fc5f1e57a4df659913aef29a37ae52599a58c1bd) )
	sc_bunny_others
ROM_END



ROM_START( sc5cbrun )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95426670.lo", 0x00001, 0x080000, CRC(6ea51f05) SHA1(bf2a408134edd32942813a4915fe2223a3d78186) )
	ROM_LOAD16_BYTE( "g95426671.hi", 0x00000, 0x080000, CRC(ab83a503) SHA1(f2a5d1083de79d8152c417ba218ad97c36744909) )
	sc_cbrun_others
ROM_END

ROM_START( sc5cbruna )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95427670.lo", 0x00001, 0x080000, CRC(e617766a) SHA1(99e2587677b51264fbb9edfbb3f9ded27b95dbac) )
	ROM_LOAD16_BYTE( "g95427671.hi", 0x00000, 0x080000, CRC(1e20b280) SHA1(feae190c21f2a5839c3bed0205c3bdf488f42c5c) )
	sc_cbrun_others
ROM_END



ROM_START( sc5cfact )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412960.lo", 0x00001, 0x080000, CRC(0d29f038) SHA1(6a75b56b3af0acae99ed214dd0edbcbed5172b6f) )
	ROM_LOAD16_BYTE( "95412961.hi", 0x00000, 0x080000, CRC(c83a672d) SHA1(0cc84da5d162312b194b130e1386cbc231d65043) )
	sc_cfact_others
ROM_END

ROM_START( sc5cfacta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "cfactor.hi", 0x00000, 0x080000, CRC(c9ce2ef5) SHA1(46cb6dc3c1a670bf1cc66c9750046735bef6e654) )
	ROM_LOAD16_BYTE( "cfactor.l0", 0x00001, 0x080000, CRC(1ce109d9) SHA1(9fb5f847a0732c7b356b45792224e81322c84472) )
	sc_cfact_others
ROM_END



ROM_START( sc5ctit )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3204p71.hi", 0x00000, 0x080000, CRC(66d0bd00) SHA1(5a613eda7baceaad1b948f494ed205b17f1f1efa) )
	ROM_LOAD16_BYTE( "p3204p71.lo", 0x00001, 0x080000, CRC(8ec228c6) SHA1(f0ea566eeba816b3ef4188843c5f0b00b4aec84d) )
	sc_ctit_others
ROM_END

ROM_START( sc5ctita )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3204s71.hi", 0x00000, 0x080000, CRC(e86b8113) SHA1(c5e7a50e3acfb444edf7b7ac5334013291b8b2c8) )
	ROM_LOAD16_BYTE( "p3204s71.lo", 0x00001, 0x080000, CRC(75cc8864) SHA1(0bea4b4ccc29c239154ea20363845eb46186e1cb) )
	sc_ctit_others
ROM_END




ROM_START( sc5craid )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420786.lo", 0x00001, 0x080000, CRC(b2ad952c) SHA1(34d4fe88f59a737b1931cf26f438f80c001fe338) )
	ROM_LOAD16_BYTE( "95420787.hi", 0x00000, 0x080000, CRC(00be96b1) SHA1(dab040328e53a793941975d8247c287a8be275a2) )
	sc_craid_others
ROM_END


ROM_START( sc5craida )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421786.lo", 0x00001, 0x080000, CRC(084a10a9) SHA1(b7cb2e9bebfb2a5d9757f553e9e08d9cf36eb45f) )
	ROM_LOAD16_BYTE( "95421787.hi", 0x00000, 0x080000, CRC(83217eba) SHA1(23d2741128e27c206180a7524688a3af3267710e) )
	sc_craid_others
ROM_END




ROM_START( sc5cvega )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412826.lo", 0x00001, 0x080000, CRC(7bc826bf) SHA1(0985a2f07dd1318cb6c16f5e557cabc685d4c220) )
	ROM_LOAD16_BYTE( "95412827.hi", 0x00000, 0x080000, CRC(76827bbe) SHA1(1aa77f9a5a5043b5f8255444d0bc210aafa256c8) )
	sc_cvega_others
ROM_END

ROM_START( sc5cvegaa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413826.lo", 0x00001, 0x080000, CRC(889a9336) SHA1(92401dfdb00f1db8803ebdf421ac32f3a20c2b1b) )
	ROM_LOAD16_BYTE( "95413827.hi", 0x00000, 0x080000, CRC(b67145ea) SHA1(5f7123d7091cfae108bae433c630f65de3d69369) )
	sc_cvega_others
ROM_END




ROM_START( sc5chopc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416272.lo", 0x00001, 0x080000, CRC(849c04ac) SHA1(c0a48ba08f1dd78fc683b74eb5b33dd976461b7a) )
	ROM_LOAD16_BYTE( "95416273.hi", 0x00000, 0x080000, CRC(1a8fab5c) SHA1(b551c2808c55e3e30a26ec81b1c522db7b6c2c53) )
	sc_chopc_others
ROM_END

ROM_START( sc5chopca )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417272.lo", 0x00001, 0x080000, CRC(d6a21098) SHA1(6d6026e5a9691694115f96a69f2443925f95818d) )
	ROM_LOAD16_BYTE( "95417273.hi", 0x00000, 0x080000, CRC(34d07425) SHA1(6a82aae33eb7cad44269dca66c7ad81fb90a232f) )
	sc_chopc_others
ROM_END



ROM_START( sc5cbar7 )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424480.lo", 0x00001, 0x080000, CRC(97e2621f) SHA1(b46712278963997e896c2ddf40a189c5f14b2c4e) )
	ROM_LOAD16_BYTE( "95424481.hi", 0x00000, 0x080000, CRC(3b728280) SHA1(5a1cd00f924d679a26be1384b71c841782c0297b) )
	sc_cbar7_others
ROM_END

ROM_START( sc5cbar7a )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425480.lo", 0x00001, 0x080000, CRC(13cf6f77) SHA1(54b76934971605f87d904b2b57c7e62f9e83e7b5) )
	ROM_LOAD16_BYTE( "95425481.hi", 0x00000, 0x080000, CRC(86911488) SHA1(64ac43ff032c574bc2c882573c4f7b14972cec48) )
	sc_cbar7_others
ROM_END



ROM_START( sc5clu70 )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424606.lo", 0x00001, 0x080000, CRC(5116899c) SHA1(d063e9e317d94d63fef93bd5b84ef28fd308ef56) )
	ROM_LOAD16_BYTE( "95424607.hi", 0x00000, 0x080000, CRC(90ff0e9f) SHA1(b319989cfd55eacb53cae0e667e18f8b923cf42d) )
	sc_clu70_others
ROM_END

ROM_START( sc5clu70a )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425606.lo", 0x00001, 0x080000, CRC(f57ff256) SHA1(60b3d61526b180cd130ffc442359c1a565049a12) )
	ROM_LOAD16_BYTE( "95425607.hi", 0x00000, 0x080000, CRC(244f3da1) SHA1(02abcf21f054cb1996f5a5856e523aa0bc9a4489) )
	sc_clu70_others
ROM_END



ROM_START( sc5clcas )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420214.lo", 0x00001, 0x080000, CRC(96e79a96) SHA1(3c5c7cb5f566fb5be2e4198a127396eb507786dc) )
	ROM_LOAD16_BYTE( "95420215.hi", 0x00000, 0x080000, CRC(f884d509) SHA1(e93ae6fd3daa77cacc8896599a17c185dbe4ef05) )
	sc_clcas_others
ROM_END

ROM_START( sc5clcasa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421214.lo", 0x00001, 0x080000, CRC(b98c0d2b) SHA1(19dab8240a6f5e76eefdd01c0f0133b1e2982212) )
	ROM_LOAD16_BYTE( "95421215.hi", 0x00000, 0x080000, CRC(8b7ecfd2) SHA1(4b322f11a08cbb1de95a5bcb3095516821c45228) )
	sc_clcas_others
ROM_END



ROM_START( sc5clnot )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3320p71.hi", 0x00000, 0x080000, CRC(e7577b95) SHA1(ae489c5b8a71bb12a03a5bec12402e8f8e307b80) )
	ROM_LOAD16_BYTE( "p3320p71.lo", 0x00001, 0x080000, CRC(3c4ba88b) SHA1(0a4dc6437767b00d103fa6fe6a92c05f7e85cb51) )
	sc_clnot_others
ROM_END

ROM_START( sc5clnota )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3320p72.hi", 0x00000, 0x080000, CRC(a834e1c1) SHA1(5acf39a842beffeb7b0af58679f9076370880e58) )
	ROM_LOAD16_BYTE( "p3320p72.lo", 0x00001, 0x080000, CRC(77e9e22a) SHA1(29a76b6a4d8598d98e07df115551b130a59c1b4a) )
	sc_clnot_others
ROM_END

ROM_START( sc5clnotb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3320p73.hi", 0x00000, 0x080000, CRC(0ac70145) SHA1(a5ede1d3550f2cf38a5bce20e6136e16909efcfb) )
	ROM_LOAD16_BYTE( "p3320p73.lo", 0x00001, 0x080000, CRC(255d9cc3) SHA1(de3d06db28e0d27fc09add57cc1bc1bdd09dfdbc) )
	sc_clnot_others
ROM_END

ROM_START( sc5clnotc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3320p74.hi", 0x00000, 0x080000, CRC(8d568fc6) SHA1(6ad6af35e6eab275e1540ef1c622c509e91593ca) )
	ROM_LOAD16_BYTE( "p3320p74.lo", 0x00001, 0x080000, CRC(dcb272df) SHA1(461241d3b58e8b6bb13918b911d952809815a2b8) )
	sc_clnot_others
ROM_END

ROM_START( sc5clnotd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3320s71.hi", 0x00000, 0x080000, CRC(05550ef4) SHA1(70f465b70a22c09a3ddf1709070cc8132d809dea) )
	ROM_LOAD16_BYTE( "p3320s71.lo", 0x00001, 0x080000, CRC(41e0158b) SHA1(f8e23402bddc64c22e4307921ca36dc6e21f58e9) )
	sc_clnot_others
ROM_END

ROM_START( sc5clnote )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3320s72.hi", 0x00000, 0x080000, CRC(d30d4f7b) SHA1(ed71344de1c17d9ae26d235fe7269ece6e7afd7d) )
	ROM_LOAD16_BYTE( "p3320s72.lo", 0x00001, 0x080000, CRC(f6464393) SHA1(ce5d5ffae4627188c1e8334d9ef9171db054d366) )
	sc_clnot_others
ROM_END

ROM_START( sc5clnotf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3320s73.hi", 0x00000, 0x080000, CRC(292cf9d2) SHA1(9cdcd35b99d86021c801e9c3cf165c41d6b95e0c) )
	ROM_LOAD16_BYTE( "p3320s73.lo", 0x00001, 0x080000, CRC(048da036) SHA1(aa4fea9b6afcd92e1145343784c8854e8dfbd5c5) )
	sc_clnot_others
ROM_END

ROM_START( sc5clnotg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3320s74.hi", 0x00000, 0x080000, CRC(1ffb7940) SHA1(f6ca07bcfb11109c3a1444c49f4ad80bd7f29455) )
	ROM_LOAD16_BYTE( "p3320s74.lo", 0x00001, 0x080000, CRC(7bddd63f) SHA1(b82d75d9a8c1b144a5ab876d067f5d9df7ca5afc) )
	sc_clnot_others
ROM_END





ROM_START( sc5clus )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420232.lo", 0x00001, 0x080000, CRC(0495a57e) SHA1(fc6861f7b1f5014e996e38735c7d65e5e3a4d4f9) )
	ROM_LOAD16_BYTE( "95420233.hi", 0x00000, 0x080000, CRC(a3268eb5) SHA1(ac430b90a0d40bbc2e421310ca686650f23e946b) )
	sc_clus_others
ROM_END

ROM_START( sc5clusa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420420.lo", 0x00001, 0x080000, CRC(f8966c71) SHA1(0303a3ff037c82bc2d60be32e5dc190fe2900809) )
	ROM_LOAD16_BYTE( "95420421.hi", 0x00000, 0x080000, CRC(40309b0a) SHA1(afc67a77aed2046b53dfacf1d1ef9bb064012eee) )
	sc_clus_others
ROM_END

ROM_START( sc5clusb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420572.lo", 0x00001, 0x080000, CRC(45b4b964) SHA1(ed9d277b06110fe5e804c679b55b884e7c8f00ed) )
	ROM_LOAD16_BYTE( "95420573.hi", 0x00000, 0x080000, CRC(3b80b863) SHA1(0609d9f0a3576bb4ffa0f8f106c094aa892227d5) )
	sc_clus_others
ROM_END

ROM_START( sc5clusc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420798.lo", 0x00001, 0x080000, CRC(f49872ab) SHA1(c9fa88f342a1099a973eb6f9c1568c9df330efe0) )
	ROM_LOAD16_BYTE( "95420799.hi", 0x00000, 0x080000, CRC(38986101) SHA1(39cd09e8448c10f3f2a25f4e451454fc24260c16) )
	sc_clus_others
ROM_END

ROM_START( sc5clusd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421232.lo", 0x00001, 0x080000, CRC(1398a93b) SHA1(3bd8c28a3ca42c3f51aa81a6147d5b03d786180e) )
	ROM_LOAD16_BYTE( "95421233.hi", 0x00000, 0x080000, CRC(f697f34c) SHA1(edb9278188451ffe5a199b6385778e77b705c513) )
	sc_clus_others
ROM_END

ROM_START( sc5cluse )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421420.lo", 0x00001, 0x080000, CRC(9ab5593b) SHA1(80a4002332406274d541900bf99e8b583fc19425) )
	ROM_LOAD16_BYTE( "95421421.hi", 0x00000, 0x080000, CRC(3c680a89) SHA1(1f4da3fe6b2210596c1cb876042977039527233e) )
	sc_clus_others
ROM_END

ROM_START( sc5clusf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421572.lo", 0x00001, 0x080000, CRC(ecb35ea6) SHA1(127077129925cb8f986bb735c361f7562900adbe) )
	ROM_LOAD16_BYTE( "95421573.hi", 0x00000, 0x080000, CRC(66c3c372) SHA1(1269772935b53a2455317bdf46aff31d41457d82) )
	sc_clus_others
ROM_END

ROM_START( sc5clusg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421798.lo", 0x00001, 0x080000, CRC(618dd281) SHA1(9dd4ada2eea9ceccb4981f69434b510accd5f1b0) )
	ROM_LOAD16_BYTE( "95421799.hi", 0x00000, 0x080000, CRC(be57bd8f) SHA1(1cda9a9d4300664afe94193710ef6fdfc9c6e59f) )
	sc_clus_others
ROM_END

ROM_START( sc5clush )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424488.lo", 0x00001, 0x080000, CRC(1262616d) SHA1(4de9f9015036dff77df13ee098de2ef8014bd5da) )
	ROM_LOAD16_BYTE( "95424489.hi", 0x00000, 0x080000, CRC(3a89646c) SHA1(1b84c2f48e746fc90e5a7ae290e9271e55d6ff65) )
	sc_clus_others
ROM_END

ROM_START( sc5clusi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424530.lo", 0x00001, 0x080000, CRC(ec75bc8a) SHA1(cd4416a8a391d9cbf5f99701dbef0efb112c6f99) )
	ROM_LOAD16_BYTE( "95424531.hi", 0x00000, 0x080000, CRC(6a71f145) SHA1(cda03395827a0c5ef9b4e8b4b7569f1827828135) )
	sc_clus_others
ROM_END

ROM_START( sc5clusj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425488.lo", 0x00001, 0x080000, CRC(16e68f76) SHA1(14f0ce9d4cf2e1c6e4122512ad0d8f63d6127f59) )
	ROM_LOAD16_BYTE( "95425489.hi", 0x00000, 0x080000, CRC(6d83d072) SHA1(a662bada38a22703567a4cdf0597f2878ef9935f) )
	sc_clus_others
ROM_END

ROM_START( sc5clusk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425530.lo", 0x00001, 0x080000, CRC(bd66367e) SHA1(33d9e3392229e9d7c0a5a44e6b1135f6135c2a97) )
	ROM_LOAD16_BYTE( "95425531.hi", 0x00000, 0x080000, CRC(a11b6d6f) SHA1(20ab31e399a6b537d014b69963e01e945e1fea35) )
	sc_clus_others
ROM_END






ROM_START( sc5colmo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3317p71.hi", 0x00000, 0x080000, CRC(6b3964f1) SHA1(4f464ca86a59e30a7f05fe1d6ed8f30f8260d186) )
	ROM_LOAD16_BYTE( "p3317p71.lo", 0x00001, 0x080000, CRC(af2a8342) SHA1(4865f3ff996b67bebf38c93aad3f7b32afcb2d7e) )
	PR3317_COLOUR_OF_MONEY_SOUNDS11
ROM_END

ROM_START( sc5colmoa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3317p73.hi", 0x00000, 0x080000, CRC(fad957ba) SHA1(56446892d5ef88488e4ee223bee489ce822a78ce) )
	ROM_LOAD16_BYTE( "p3317p73.lo", 0x00001, 0x080000, CRC(28ebb95e) SHA1(0dcde4f0fb1ffdc3f5efeadbf119fb89097da9fb) )
	PR3317_COLOUR_OF_MONEY_SOUNDS11
ROM_END

ROM_START( sc5colmob )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3317s71.hi", 0x00000, 0x080000, CRC(2883db1b) SHA1(a3cd5cc0f6e17425e4de4a81d18c710ec873da86) )
	ROM_LOAD16_BYTE( "p3317s71.lo", 0x00001, 0x080000, CRC(074f7cc2) SHA1(159071cce2a2c834e0e1b9bdd448b16b46577637) )
	PR3317_COLOUR_OF_MONEY_SOUNDS11
ROM_END

ROM_START( sc5colmoc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3317s73.hi", 0x00000, 0x080000, CRC(3a9fdba2) SHA1(6bd035186e28bff42d2fc285b07c5c9ec683db7b) )
	ROM_LOAD16_BYTE( "p3317s73.lo", 0x00001, 0x080000, CRC(6ee18188) SHA1(73b01c51d12ba5d971b9a0da94e781a08788a6fa) )
	PR3317_COLOUR_OF_MONEY_SOUNDS11
ROM_END




ROM_START( sc5newcm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426926.lo", 0x00001, 0x080000, CRC(905a15ce) SHA1(987782cd163f1a8869970912ad412e5440dacdf3) )
	ROM_LOAD16_BYTE( "95426927.hi", 0x00000, 0x080000, CRC(70fa9626) SHA1(e9a58b489665e8b540adaa220995d5237de1c820) )
	PR3502_C_OF_M_TEN_SOUNDS11
ROM_END

ROM_START( sc5newcma )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427926.lo", 0x00001, 0x080000, CRC(5897abbc) SHA1(7714218e76a1d2ebdda65c1403c4fc3f5a5263f6) )
	ROM_LOAD16_BYTE( "95427927.hi", 0x00000, 0x080000, CRC(4c44681c) SHA1(ed808ab3d06157da9dbe65b1e27925b3a3b53f91) )
	PR3502_C_OF_M_TEN_SOUNDS11
ROM_END

ROM_START( sc5newcmb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426818.lo", 0x00001, 0x080000, CRC(898b5c17) SHA1(5e090bec5d9dc303e3d6d80a4b27c095c285eb29) )
	ROM_LOAD16_BYTE( "95426819.hi", 0x00000, 0x080000, CRC(d6eeeddd) SHA1(70d11f51b257d7d565bad65a9f0b0e7bde716bf7) )
	PR3502_C_OF_M_TEN_SOUNDS11
ROM_END

ROM_START( sc5newcmc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427818.lo", 0x00001, 0x080000, CRC(f696797d) SHA1(fd1ae9bf1e248cadf547d18601a7df54f6384b91) )
	ROM_LOAD16_BYTE( "95427819.hi", 0x00000, 0x080000, CRC(ee6fadce) SHA1(47d14fcc8040f72c97e1cade26f1a62cf1ead511) )
	PR3502_C_OF_M_TEN_SOUNDS11
ROM_END

ROM_START( sc5crcpt )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426832.lo", 0x00001, 0x080000, CRC(42263084) SHA1(aa6fad35eced4b97c20edbc6fce3661e6407ac4d) )
	ROM_LOAD16_BYTE( "95426833.hi", 0x00000, 0x080000, CRC(fa9e267e) SHA1(29dcc0ff79adbb5012159ee93c1940d268f44cd2) )
	sc_crcpt_others
ROM_END

ROM_START( sc5crcpta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427832.lo", 0x00001, 0x080000, CRC(6b18f66d) SHA1(dfffe8dd763980d811f6c843226762c17525837c) )
	ROM_LOAD16_BYTE( "95427833.hi", 0x00000, 0x080000, CRC(b6a1f0d0) SHA1(051a3a5bb8baae1a18d2dc8b95202cb70398806b) )
	sc_crcpt_others
ROM_END

ROM_START( ad5crcpt )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211599.bin", 0x0000, 0x1000000, CRC(0fa50547) SHA1(95b1890851e82ad827b739a8d359309529c0b5b7) )
	ROM_LOAD( "39212599.bin", 0x0000, 0x1000000, CRC(10d4aef1) SHA1(71345ec08cecfdae7a8e0161fd0cf33b9cca5c3e) )
ROM_END

ROM_START( sc5crotr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3506p71.hi", 0x00000, 0x080000, CRC(18f6b748) SHA1(ec174b5aecdda995d1812232403188c822ba327d) )
	ROM_LOAD16_BYTE( "p3506p71.lo", 0x00001, 0x080000, CRC(f3f99f46) SHA1(7dafa1b56ed331891c1488ae57ce2bdf8d94474d) )
	sc_crotr_others
ROM_END

ROM_START( sc5crotra )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3506s71.hi", 0x00000, 0x080000, CRC(de6b2bc2) SHA1(9f78c06443d57222da677d102657a8117aa8ed88) )
	ROM_LOAD16_BYTE( "p3506s71.lo", 0x00001, 0x080000, CRC(51e69ad7) SHA1(89577f066cb39bbf667920c61fc0c6d5e734ac38) )
	sc_crotr_others
ROM_END




ROM_START( sc5crsgc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426598.lo", 0x00001, 0x080000, CRC(fe619021) SHA1(41996277f5cc77544a65217cdb4f60ca1bb6850f) )
	ROM_LOAD16_BYTE( "95426599.hi", 0x00000, 0x080000, CRC(72829ae6) SHA1(37481bc1cab53f873e01a0416043f0e1838f1e84) )
	sc_crsgc_others
ROM_END

ROM_START( sc5crsgca )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427598.lo", 0x00001, 0x080000, CRC(6d24c35c) SHA1(6840debf594b27a8a8c05a604f82bb871c128a4a) )
	ROM_LOAD16_BYTE( "95427599.hi", 0x00000, 0x080000, CRC(c355c84c) SHA1(858a88b8ab93ce033acdf24ab2b831fa734b311b) )
	sc_crsgc_others
ROM_END


ROM_START( sc5crsgcb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426606.lo", 0x00001, 0x080000, CRC(8a547a39) SHA1(d697ace6bdfd277baef9608a44c96b4f3c574e37) )
	ROM_LOAD16_BYTE( "95426607.hi", 0x00000, 0x080000, CRC(d05e09f5) SHA1(2d54fccf561ee6a141a53952f048b4eca355f4db) )
	sc_crsgc_others
ROM_END

ROM_START( sc5crsgcc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427606.lo", 0x00001, 0x080000, CRC(6d734a40) SHA1(c0ac02f515d29e6fb081f20c6871a579209e9532) )
	ROM_LOAD16_BYTE( "95427607.hi", 0x00000, 0x080000, CRC(0187e6d5) SHA1(f0fdd3154cd78b783f27a37dc0f810849a31f75d) )
	sc_crsgc_others
ROM_END




ROM_START( sc5crsgr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426584.lo", 0x00001, 0x080000, CRC(6e8a71de) SHA1(0494b00a605910b5e1f79102f629f4952896a2ff) )
	ROM_LOAD16_BYTE( "95426585.hi", 0x00000, 0x080000, CRC(1c65926f) SHA1(d5620e9af764cb6bdd8e90077bfac2f70f7d4971) )
	sc_crsgr_others
ROM_END

ROM_START( sc5crsgra )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426608.lo", 0x00001, 0x080000, CRC(33288757) SHA1(0df682d95354e1825409effbd4b3474c7891b9d9) )
	ROM_LOAD16_BYTE( "95426609.hi", 0x00000, 0x080000, CRC(1b59bf7f) SHA1(10e3db4573f47a677ceff6aa6b051593647cc136) )
	sc_crsgr_others
ROM_END

ROM_START( sc5crsgrb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427584.lo", 0x00001, 0x080000, CRC(0b00d71d) SHA1(efc169bf5aae880d99cb32067abb011e3ce52ae4) )
	ROM_LOAD16_BYTE( "95427585.hi", 0x00000, 0x080000, CRC(90d71fce) SHA1(df10ad1176fd69344fe79c12b3ac60e15c18c858) )
	sc_crsgr_others
ROM_END

ROM_START( sc5crsgrc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427608.lo", 0x00001, 0x080000, CRC(24dff702) SHA1(48249a94eff659defd1ff21187e76fac5b0c6983) )
	ROM_LOAD16_BYTE( "95427609.hi", 0x00000, 0x080000, CRC(c481cac6) SHA1(98e88aa602b5cde63d40ffd5368717a8f65bd5ba) )
	sc_crsgr_others
ROM_END




ROM_START( sc5corst )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426842.lo", 0x00001, 0x080000, CRC(4c027808) SHA1(f386534a9e2470814d29544718c0764a05c54bd9) )
	ROM_LOAD16_BYTE( "95426843.hi", 0x00000, 0x080000, CRC(0299593c) SHA1(4043d959be75c3a670a39a5b23faf0c4ee3259c6) )
	sc_corst_others
ROM_END

ROM_START( sc5corsta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427842.lo", 0x00001, 0x080000, CRC(0b519c35) SHA1(97228d8f92a25bc12b67b8f04797e9b40efe3c35) )
	ROM_LOAD16_BYTE( "95427843.hi", 0x00000, 0x080000, CRC(1d8d6aab) SHA1(1aa49c097a4aa492c6dc7d205123e1470b9d0ab5) )
	sc_corst_others
ROM_END




ROM_START( sc5cfnc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426718.lo", 0x00001, 0x080000, CRC(5cb56926) SHA1(bb8091cf480955fa8bc77f199b133f13d85fe8da) )
	ROM_LOAD16_BYTE( "95426719.hi", 0x00000, 0x080000, CRC(7d8d81a5) SHA1(8181e42af97d3b35b55020a3c109ae48d20fde55) )
	sc_cfnc_others
ROM_END

ROM_START( sc5cfnca )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427718.lo", 0x00001, 0x080000, CRC(5295be6f) SHA1(08fd1c090ac2d59e54b28098e12e705535520777) )
	ROM_LOAD16_BYTE( "95427719.hi", 0x00000, 0x080000, CRC(6e1e6fef) SHA1(647b4ccb490b25b66bf2ddb015f703c2188c3fd6) )
	sc_cfnc_others
ROM_END




ROM_START( sc5cfcp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426830.lo", 0x00001, 0x080000, CRC(c7eb6583) SHA1(3e230e30176fc249c3e3b4ded317ec3d487b0cea) )
	ROM_LOAD16_BYTE( "95426831.hi", 0x00000, 0x080000, CRC(83441be3) SHA1(01cefec8d62000bc59bd89d3ad3bdf2a4ef1a678) )
	sc_cfcp_others
ROM_END

ROM_START( sc5cfcpa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426870.lo", 0x00001, 0x080000, CRC(c6de776d) SHA1(555fa846dbe34d9c6a151e0511358069039e8332) )
	ROM_LOAD16_BYTE( "95426871.hi", 0x00000, 0x080000, CRC(0e02ad7b) SHA1(51f52469d66826e489c5b5c45f604ea5b4ede1a3) )
	sc_cfcp_others
ROM_END

ROM_START( sc5cfcpb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426922.lo", 0x00001, 0x080000, CRC(7ea0e9b1) SHA1(68bac0c7b0db0115130fd4710755bb2fe0404a86) )
	ROM_LOAD16_BYTE( "95426923.hi", 0x00000, 0x080000, CRC(2aefeb5d) SHA1(0a1f48f7a87d1af42d7bc39100d0590368b94a3e) )
	sc_cfcp_others
ROM_END

ROM_START( sc5cfcpc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427830.lo", 0x00001, 0x080000, CRC(734d7a37) SHA1(af857ec31e337a890947e9ec3da96467440aeeb0) )
	ROM_LOAD16_BYTE( "95427831.hi", 0x00000, 0x080000, CRC(e22a638e) SHA1(b5199410602e078ca51d009e42b2ad7cdaa7e006) )
	sc_cfcp_others
ROM_END

ROM_START( sc5cfcpd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427870.lo", 0x00001, 0x080000, CRC(8f2314a5) SHA1(819f51c6f4712ca9ae74be16972b1abdd890b6b2) )
	ROM_LOAD16_BYTE( "95427871.hi", 0x00000, 0x080000, CRC(6813dd1a) SHA1(003d06287cf94364f2967e2513dbca7238fe8838) )
	sc_cfcp_others
ROM_END

ROM_START( sc5cfcpe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427922.lo", 0x00001, 0x080000, CRC(19a993dd) SHA1(909880cb610e567b7f5c51d479a23561b84835aa) )
	ROM_LOAD16_BYTE( "95427923.hi", 0x00000, 0x080000, CRC(5e679b12) SHA1(385bb9fbadc0e4708b0d08859a18caaa542c609b) )
	sc_cfcp_others
ROM_END




ROM_START( sc5cfpt )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410134.lo", 0x00001, 0x080000, CRC(e133fa6d) SHA1(bc626558bbe460613eae7787f23ede75d1433acc) )
	ROM_LOAD16_BYTE( "95410135.hi", 0x00000, 0x080000, CRC(5ccdd3e0) SHA1(b0ff1d824153746fb4d4494430d511d5e9c09822) )
	sc_cfpt_others
ROM_END

ROM_START( sc5cfpta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412426.lo", 0x00001, 0x080000, CRC(a6a229da) SHA1(910e6ab809d323cb7b32bdaba008fba2199a5237) )
	ROM_LOAD16_BYTE( "95412427.hi", 0x00000, 0x080000, CRC(121fda59) SHA1(2e43fd580de33316f152e5df515ab08bd8b59f1f) )
	sc_cfpt_others
ROM_END

ROM_START( sc5cfptb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413426.lo", 0x00001, 0x080000, CRC(2592f2d2) SHA1(bd08bbd4c8df85004c65391611808f41cb271bfc) )
	ROM_LOAD16_BYTE( "95413427.hi", 0x00000, 0x080000, CRC(a696c5f3) SHA1(12659ced7c10ed3997807b74e86975a9edf39787) )
	sc_cfpt_others
ROM_END


ROM_START( sc5cfptc )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "95408564.lo", 0x00001, 0x080000, CRC(a10083eb) SHA1(c6da0a1b55e07303efa5b72864a5be9a3456539d) )
	ROM_LOAD16_BYTE( "95408565.hi", 0x00000, 0x080000, CRC(f4ce13a0) SHA1(014778d2da3ef2fea222a930e3f70b5e3c092975) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END


ROM_START( sc5cfptd )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "95408566.lo", 0x00001, 0x080000, CRC(ae80c8dc) SHA1(f300f7f706b48dc6fefeda66bdd51ed8e22705e0) )
	ROM_LOAD16_BYTE( "95408567.hi", 0x00000, 0x080000, CRC(f11a6e3e) SHA1(98374f710c3dd979515dc6280845a72a31a330d5) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END

ROM_START( sc5cfpte )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "95409564.lo", 0x00001, 0x080000, CRC(abcd12e3) SHA1(4e8652d0bbfaaf4e829708993a23c3736f0b8892) )
	ROM_LOAD16_BYTE( "95409565.hi", 0x00000, 0x080000, CRC(46c03cdd) SHA1(72d63095eaea3d7239f7603ff3382eecc2a625d0) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END


ROM_START( sc5cfptf )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "95409566.lo", 0x00001, 0x080000, CRC(f3c6493b) SHA1(0bc97c4329930164433cb22690b6bb35b6e27c4a) )
	ROM_LOAD16_BYTE( "95409567.hi", 0x00000, 0x080000, CRC(618cbc2b) SHA1(5ca7a7b0cd42f7be16be12e83ab82457a42ca1e6) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END


ROM_START( sc5cfptg )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "p1371p11.hi", 0x00000, 0x080000, CRC(8c438718) SHA1(a266fe867bddcc11216f2d3f31b222d1d5af6237) )
	ROM_LOAD16_BYTE( "p1371p11.lo", 0x00001, 0x080000, CRC(9cfe5ba9) SHA1(d2bedca469bbbbfdd2fd1584b397a26d660fea7c) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END

ROM_START( sc5cfpth )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "p1371s11.hi", 0x00000, 0x080000, CRC(24335da7) SHA1(a2f05a13a28d2910a3150abaebf980ba5f9c1130) )
	ROM_LOAD16_BYTE( "p1371s11.lo", 0x00001, 0x080000, CRC(4116abb7) SHA1(897d1043178b6d0c88d9c306fc27db2f3978c76f) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END

ROM_START( sc5cfpti )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "95411134.lo", 0x00001, 0x080000, CRC(eb9cf02e) SHA1(68a1caf92f8b2d1b73d3eb07920b98ffb93a0451) )
	ROM_LOAD16_BYTE( "95411135.hi", 0x00000, 0x080000, CRC(ae33cdbd) SHA1(691907e7867027d0e60558c2615ee8a51d0463a1) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END

ROM_START( sc5cfptj )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "95408568.lo", 0x00001, 0x080000, CRC(c091adad) SHA1(5bd2e7004af74f27192f3f425ecac47d424d41a9) )
	ROM_LOAD16_BYTE( "95408569.hi", 0x00000, 0x080000, CRC(f35e76eb) SHA1(7bc9dfc1b812c5222378c40180c4644c4aa3f058) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END

ROM_START( sc5cfptk )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "95409568.lo", 0x00001, 0x080000, CRC(005222e0) SHA1(e6b87dd98f6706e3dc61db267be7eeded07ec3fe) )
	ROM_LOAD16_BYTE( "95409569.hi", 0x00000, 0x080000, CRC(26202661) SHA1(8379ef9b769d9e6a0922a093c6327510b5c10256) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END


ROM_START( sc5cfptl )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "p1371p91.hi", 0x00000, 0x080000, CRC(8b39df7a) SHA1(b6423e36f0dda2dd1ff11189aaa4f9a567e05af8) )
	ROM_LOAD16_BYTE( "p1371p91.lo", 0x00001, 0x080000, CRC(2c357088) SHA1(5266734637e7aa9924bb5395fcf48994d407f015) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END

ROM_START( sc5cfptm )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "p1371s91.hi", 0x00000, 0x080000, CRC(22f54a59) SHA1(75cb71c453911cc5d1b5a88625d9fffa43a57f3e) )
	ROM_LOAD16_BYTE( "p1371s91.lo", 0x00001, 0x080000, CRC(55dc637c) SHA1(8340491640d8748787d2401f3f33542c8f20c7dc) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END

ROM_START( sc5cfptn )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "95410186.lo", 0x00001, 0x080000, CRC(73483953) SHA1(ec2823d2059c65367e647ac1106dd70d18e5bc89) )
	ROM_LOAD16_BYTE( "95410187.hi", 0x00000, 0x080000, CRC(ba91c41c) SHA1(ed556ea559724cdae0bcd0298fd2021a2b49e15a) )
	PR1430_CRAZY_F_SIT_D_SOUNDS11
ROM_END

ROM_START( sc5cfpto )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "95411186.lo", 0x00001, 0x080000, CRC(7e933b3c) SHA1(90410c291902b72d95f3376657e918cd1d60d8a8) )
	ROM_LOAD16_BYTE( "95411187.hi", 0x00000, 0x080000, CRC(cdc68736) SHA1(92bfe250d2b0f3030ce8541dbed73a37ac3dc8b9) )
	PR1430_CRAZY_F_SIT_D_SOUNDS11
ROM_END

ROM_START( sc5cfptp )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "p1430p42.hi", 0x00000, 0x080000, CRC(97e3926b) SHA1(c385e2ed2eb0e043a3c84f25b1b64c934bb380e1) )
	ROM_LOAD16_BYTE( "p1430p42.lo", 0x00001, 0x080000, CRC(9b33feaf) SHA1(31a53520e5b65b39ac1a54ba2eba13f5ce75ee50) )
	PR1430_CRAZY_F_SIT_D_SOUNDS11
ROM_END

ROM_START( sc5cfptq )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "p1430p52.hi", 0x00000, 0x080000, CRC(832d2241) SHA1(98c6e5e485d474b88a7e8a313b4cc469ec14b5e9) )
	ROM_LOAD16_BYTE( "p1430p52.lo", 0x00001, 0x080000, CRC(d9fb0e30) SHA1(fe337db428bf68abb770a5e06d8ac73cc4e7794e) )
	PR1430_CRAZY_F_SIT_D_SOUNDS11
ROM_END

ROM_START( sc5cfptr )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "p1430s42.hi", 0x00000, 0x080000, CRC(a5f0acf8) SHA1(01877be0da6018d067cc683a4a2dd14c4c6f7ba3) )
	ROM_LOAD16_BYTE( "p1430s42.lo", 0x00001, 0x080000, CRC(64522503) SHA1(16203ff08a0de9db92522b05669c0c92057a27c4) )
	PR1430_CRAZY_F_SIT_D_SOUNDS11
ROM_END

ROM_START( sc5cfpts )
    ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF)
	ROM_LOAD16_BYTE( "p1430s52.hi", 0x00000, 0x080000, CRC(9f7bd7f8) SHA1(b81c62398213ccefcaaca5c1d6c579c30ff67884) )
	ROM_LOAD16_BYTE( "p1430s52.lo", 0x00001, 0x080000, CRC(623fea2b) SHA1(fe38a4a9a91fa986bf4d36c7a28c8bb2c73659b7) )
	PR1430_CRAZY_F_SIT_D_SOUNDS11
ROM_END


ROM_START( sc5cknig )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426792.lo", 0x00001, 0x080000, CRC(bce4a51b) SHA1(5344198130b8d45a5d24aa2d167d6ee483f3da9c) )
	ROM_LOAD16_BYTE( "95426793.hi", 0x00000, 0x080000, CRC(a995cbfa) SHA1(1b4b9fa170aebcb2284fce7eedf7a7769285dcef) )
	sc_cknig_others
ROM_END

ROM_START( sc5ckniga )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427792.lo", 0x00001, 0x080000, CRC(42971ac1) SHA1(ec0c682c208766d14b9d9e9f788fc83c5f0f0109) )
	ROM_LOAD16_BYTE( "95427793.hi", 0x00000, 0x080000, CRC(e8d1d3fc) SHA1(cd922021f1086a5ac8410428686fb667d24537d5) )
	sc_cknig_others
ROM_END




ROM_START( sc5cpays )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412924.lo", 0x00001, 0x080000, CRC(7d2dbbd9) SHA1(330d54bb786ef9b9e12a64897b156ca38fba5e76) )
	ROM_LOAD16_BYTE( "95412925.hi", 0x00000, 0x080000, CRC(66231b51) SHA1(7a20bd591a782c785d5d7fee3b7ed9bccc90fa1c) )
	sc_cpays_others
ROM_END

ROM_START( sc5cpaysa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413924.lo", 0x00001, 0x080000, CRC(9ed3fa11) SHA1(bb4b3b42bd19a7ec4d88aa21868933a55e558c5d) )
	ROM_LOAD16_BYTE( "95413925.hi", 0x00000, 0x080000, CRC(771b42fa) SHA1(2d8a481e6d04c6796a127bbe76bbda6b06b68467) )
	sc_cpays_others
ROM_END




ROM_START( sc5dndbo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426644.lo", 0x00001, 0x080000, CRC(91fa1679) SHA1(e53b7dfb031106441ff21e8782e32f14dde1ee88) )
	ROM_LOAD16_BYTE( "95426645.hi", 0x00000, 0x080000, CRC(257d158a) SHA1(4452939c5e988b5406e1b90d952c3d34de45970e) )
	sc_dndbo_others
ROM_END

ROM_START( sc5dndboa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426682.lo", 0x00001, 0x080000, CRC(3c856cfa) SHA1(a4e0ccef01a5fd8fcb03ac783a949d5af6a1ffe6) )
	ROM_LOAD16_BYTE( "95426683.hi", 0x00000, 0x080000, CRC(db7182bd) SHA1(5280b59251276c67519aa297c380874106bf12f1) )
	sc_dndbo_others
ROM_END

ROM_START( sc5dndbob )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426826.lo", 0x00001, 0x080000, CRC(4e8e8bdd) SHA1(8f67e9ff36c77ec2f3abcdb411583d0d2473f4b8) )
	ROM_LOAD16_BYTE( "95426827.hi", 0x00000, 0x080000, CRC(9b971a80) SHA1(226c5e743f7de51a103447fe8278a002b75518d5) )
	sc_dndbo_others
ROM_END

ROM_START( sc5dndboc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426852.lo", 0x00001, 0x080000, CRC(185fc345) SHA1(475296683007b0608e2572b156a59f3a24aa15ad) )
	ROM_LOAD16_BYTE( "95426853.hi", 0x00000, 0x080000, CRC(0f7a81ad) SHA1(46fa2d40e3bf43307e70573bcc22c1d77cb7887b) )
	sc_dndbo_others
ROM_END

ROM_START( sc5dndbod )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426914.lo", 0x00001, 0x080000, CRC(d2dd5940) SHA1(7ed46231a5ff9e2e3a8d427a55967f98195c345d) )
	ROM_LOAD16_BYTE( "95426915.hi", 0x00000, 0x080000, CRC(00acb2ed) SHA1(30448843ab65e0eb16322652ddbcf576f2d88e13) )
	sc_dndbo_others
ROM_END

ROM_START( sc5dndboe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427644.lo", 0x00001, 0x080000, CRC(69ffa92c) SHA1(2d9f0545e279d4c480e4a8747a5638268d33b567) )
	ROM_LOAD16_BYTE( "95427645.hi", 0x00000, 0x080000, CRC(408a15b8) SHA1(837067032b352bc396fa2801e89a7c34387c2b6e) )
	sc_dndbo_others
ROM_END

ROM_START( sc5dndbof )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427682.lo", 0x00001, 0x080000, CRC(9ef8c027) SHA1(905c75f133a8970b39a9538af937d813775036b9) )
	ROM_LOAD16_BYTE( "95427683.hi", 0x00000, 0x080000, CRC(893dbff9) SHA1(e0426062859d3e8431b94a74b533fbf02f4ed09d) )
	sc_dndbo_others
ROM_END

ROM_START( sc5dndbog )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427826.lo", 0x00001, 0x080000, CRC(3a9fdf64) SHA1(dd2852d394c1ac74f9035346bf02e0ddf594e06d) )
	ROM_LOAD16_BYTE( "95427827.hi", 0x00000, 0x080000, CRC(d0ab32aa) SHA1(d861867702be09a0523a47bb18e2e44e9b302948) )
	sc_dndbo_others
ROM_END

ROM_START( sc5dndboh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427852.lo", 0x00001, 0x080000, CRC(1d7def08) SHA1(ca500d62a3d1fda81d8597bcffcf04721a229751) )
	ROM_LOAD16_BYTE( "95427853.hi", 0x00000, 0x080000, CRC(b926d9c4) SHA1(b3ae0ff4fd5a18b98bbabf1d938700b8510baa00) )
	sc_dndbo_others
ROM_END

ROM_START( sc5dndboi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427914.lo", 0x00001, 0x080000, CRC(c7a3b44e) SHA1(7b0b2992b8098b69c2fa6315e6c2d9e895b3959b) )
	ROM_LOAD16_BYTE( "95427915.hi", 0x00000, 0x080000, CRC(a6590c68) SHA1(aaeb8a9422fc38f044a46489c61f5a306910b4eb) )
	sc_dndbo_others
ROM_END




ROM_START( sc5dndbl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422086.lo", 0x00001, 0x080000, CRC(5deb6c03) SHA1(2ac729194d1e6b0fb71f5f248bf4918140f4ab2a) )
	ROM_LOAD16_BYTE( "95422087.hi", 0x00000, 0x080000, CRC(e194968f) SHA1(ca2a17f826671025c6cdd7b1361107b7ffe3ea07) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndbla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422148.lo", 0x00001, 0x080000, CRC(825d9ed9) SHA1(b123fd2190d10888286a5e58b3a796890b673bd6) )
	ROM_LOAD16_BYTE( "95422149.hi", 0x00000, 0x080000, CRC(b9dff341) SHA1(a27f5e7d1a2f78898c74eae1f87cb6c6b242791e) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndblb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422206.lo", 0x00001, 0x080000, CRC(b50bc3df) SHA1(29e5edddbc8f67fd5d13eef44b6dd03f714110f0) )
	ROM_LOAD16_BYTE( "95422207.hi", 0x00000, 0x080000, CRC(98a749aa) SHA1(0e3eecc9f257994dba4907e735b9371e81a25e8f) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndblc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422210.lo", 0x00001, 0x080000, CRC(ef3c7726) SHA1(7f9d2e548800c295731b8c15c5cc8119017069ba) )
	ROM_LOAD16_BYTE( "95422211.hi", 0x00000, 0x080000, CRC(07545d4c) SHA1(d3dd3ff04c1d2f485dacd13b4214f2462254a6d5) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndbld )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422246.lo", 0x00001, 0x080000, CRC(ab3326ea) SHA1(d511f252f1acf76fc59d3f343c4d1db54bb8de8a) )
	ROM_LOAD16_BYTE( "95422247.hi", 0x00000, 0x080000, CRC(b9c05994) SHA1(e6ca9c7f8e6df6aa2277a329ab211134dae684aa) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndble )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422248.lo", 0x00001, 0x080000, CRC(45192ed6) SHA1(21980888e1deb5e4d8cf140b957d10e18cd7315a) )
	ROM_LOAD16_BYTE( "95422249.hi", 0x00000, 0x080000, CRC(5b671826) SHA1(202f1b63e64c71fd7a1ef8c3159ed7a778d7d6f5) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndblf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422324.lo", 0x00001, 0x080000, CRC(681980ea) SHA1(11520621d11bc6642fa1ef6a81f36e4c2c5c2349) )
	ROM_LOAD16_BYTE( "95422325.hi", 0x00000, 0x080000, CRC(9337c3c8) SHA1(55313e2658ebd3fe314d5d2fe7fc846b54cb6b6d) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndblg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422326.lo", 0x00001, 0x080000, CRC(5f886988) SHA1(6b97194b2da2ba32b36652b0cf6f033ca364e297) )
	ROM_LOAD16_BYTE( "95422327.hi", 0x00000, 0x080000, CRC(71fdb9df) SHA1(c39ac2a70572bc4a337c1b578430e881cf5c0dc6) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndblh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423086.lo", 0x00001, 0x080000, CRC(330ad71d) SHA1(e80e38e0a7dc00271f589a35fa1666027ce7f764) )
	ROM_LOAD16_BYTE( "95423087.hi", 0x00000, 0x080000, CRC(2c028fb9) SHA1(5ba125d474f6d916967ad90bddfc8ebabcdb18aa) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndbli )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423148.lo", 0x00001, 0x080000, CRC(b2c47c77) SHA1(f788eaf4aaf8509de48d661341d5d46bee5ee1d9) )
	ROM_LOAD16_BYTE( "95423149.hi", 0x00000, 0x080000, CRC(55164612) SHA1(06d666a611a89ee0e79072a54959508a5cd55981) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndblj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423206.lo", 0x00001, 0x080000, CRC(e734b65f) SHA1(04f38218aeb61305df1dd26574a24efb1cf04a33) )
	ROM_LOAD16_BYTE( "95423207.hi", 0x00000, 0x080000, CRC(c0384d57) SHA1(c1841c1b06e47edeb760538a89b6302e67f6473d) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndblk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423210.lo", 0x00001, 0x080000, CRC(6db7b68f) SHA1(db23b755758bee7706ee1504743ef6fa84e542d0) )
	ROM_LOAD16_BYTE( "95423211.hi", 0x00000, 0x080000, CRC(fc572112) SHA1(27b3bd337ce82b8029b0e2ab9bbcc45c1d2f5244) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndbll )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423246.lo", 0x00001, 0x080000, CRC(36bdbe7a) SHA1(f8de104bafa301dc653b3aa01bbee08f57f42d33) )
	ROM_LOAD16_BYTE( "95423247.hi", 0x00000, 0x080000, CRC(7432ef89) SHA1(1c71c4fc96afd6bf1b644cce9312a77370f1e201) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndblm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423248.lo", 0x00001, 0x080000, CRC(e3fe8ce9) SHA1(503ac6f37a24e36ce268f77e13cb7ef3719abca2) )
	ROM_LOAD16_BYTE( "95423249.hi", 0x00000, 0x080000, CRC(cfc95a9e) SHA1(a9f235f3688ccd978c28c6425a4aeff68e433a75) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndbln )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423324.lo", 0x00001, 0x080000, CRC(0d2469ff) SHA1(b219ee90cefb52ab495ec976f8554e834e2c8088) )
	ROM_LOAD16_BYTE( "95423325.hi", 0x00000, 0x080000, CRC(4eabcf0c) SHA1(295b4771f64493466cd75098f71f0e118460e2f3) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndblo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423326.lo", 0x00001, 0x080000, CRC(8bfe21a2) SHA1(1fc13b53cda62531322a12f210daa0e510391ba3) )
	ROM_LOAD16_BYTE( "95423327.hi", 0x00000, 0x080000, CRC(883e7518) SHA1(8a437306751932f04a72cd532c567616e4d10315) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END





ROM_START( sc5dndbq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424268.lo", 0x00001, 0x080000, CRC(d51cf30a) SHA1(8fcaf84bea865801052a09894465bd7e9ea0f235) )
	ROM_LOAD16_BYTE( "95424269.hi", 0x00000, 0x080000, CRC(285a80ad) SHA1(36da0dbd0fd1c4a50ac7c8b5d91011f6ed039168) )
	sc_dndbq_others
ROM_END

ROM_START( sc5dndbqa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424366.lo", 0x00001, 0x080000, CRC(a529920f) SHA1(02f7e6158288eabb7d37ed19cca873db8b7d6c1a) )
	ROM_LOAD16_BYTE( "95424367.hi", 0x00000, 0x080000, CRC(01fc85be) SHA1(bf98096c7e0ddd4e9b3683896166b591372aeb24) )
	sc_dndbq_others
ROM_END

ROM_START( sc5dndbqb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424404.lo", 0x00001, 0x080000, CRC(e086dbd4) SHA1(cbc70e4fe552fbeacf8994c2a32185f4884a234b) )
	ROM_LOAD16_BYTE( "95424405.hi", 0x00000, 0x080000, CRC(3b886af7) SHA1(e5379ac5999d2be0399e182f9afce68bd60ee857) )
	sc_dndbq_others
ROM_END

ROM_START( sc5dndbqc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425268.lo", 0x00001, 0x080000, CRC(382fc268) SHA1(e884e557043322ca5a5c2b6ec31272a031e37ae4) )
	ROM_LOAD16_BYTE( "95425269.hi", 0x00000, 0x080000, CRC(57183b0e) SHA1(e8260b9a2f9b625547ef4b3a594b7a7ccc687138) )
	sc_dndbq_others
ROM_END

ROM_START( sc5dndbqd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425366.lo", 0x00001, 0x080000, CRC(9286e0c1) SHA1(6cc384725083d72a29cc59aa98849e9455ace35c) )
	ROM_LOAD16_BYTE( "95425367.hi", 0x00000, 0x080000, CRC(a3a9e3fb) SHA1(1fa5273bec77a605fd95916316a7a066e6b8d378) )
	sc_dndbq_others
ROM_END

ROM_START( sc5dndbqe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425404.lo", 0x00001, 0x080000, CRC(6891391c) SHA1(9c2da4c54ca7bfd2a7652705e5c96096dfbeed48) )
	ROM_LOAD16_BYTE( "95425405.hi", 0x00000, 0x080000, CRC(4c9566bc) SHA1(76eaa4556dc7bc69ea64f0d4ef7456241134c8af) )
	sc_dndbq_others
ROM_END

ROM_START( sc5dndcr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426820.lo", 0x00001, 0x080000, CRC(30427067) SHA1(84eb1f430a43c7938ef1c8921a962a6ddc6e8baf) )
	ROM_LOAD16_BYTE( "95426821.hi", 0x00000, 0x080000, CRC(28a3813f) SHA1(6df280c5606c96ce559084afa9f7155064b7249e) )
	sc_dndcr_others
ROM_END

ROM_START( sc5dndcra )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426912.lo", 0x00001, 0x080000, CRC(2c47dda7) SHA1(74005f1b80bb33bf087f183928573045f90c3b8c) )
	ROM_LOAD16_BYTE( "95426913.hi", 0x00000, 0x080000, CRC(22b2d228) SHA1(6966339a4e1e8fb704608833d191d2db2a073c9e) )
	sc_dndcr_others
ROM_END

ROM_START( sc5dndcrb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427820.lo", 0x00001, 0x080000, CRC(1878c967) SHA1(b156db8c67aaccd2b35c0d27116e01e2ec745c37) )
	ROM_LOAD16_BYTE( "95427821.hi", 0x00000, 0x080000, CRC(1b71bd56) SHA1(cdfa355f7abbf60a0b4473538d90a7f3c58638d8) )
	sc_dndcr_others
ROM_END

ROM_START( sc5dndcrc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427912.lo", 0x00001, 0x080000, CRC(473ff969) SHA1(3e953156ed3062aeeb9de8f9bae45c7db7209a10) )
	ROM_LOAD16_BYTE( "95427913.hi", 0x00000, 0x080000, CRC(771dd070) SHA1(838256baa0121691d15e3de333fffc9d33ea87e7) )
	sc_dndcr_others
ROM_END




ROM_START( sc5dndde )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426902.lo", 0x00001, 0x080000, CRC(cde3fda5) SHA1(667b2704f3d91590c24592f37a07604f8bb5e77a) )
	ROM_LOAD16_BYTE( "95426903.hi", 0x00000, 0x080000, CRC(ea6372ce) SHA1(f26e31bbe280d32d2ba127b404d9488924b90bd3) )
	sc_dndde_others
ROM_END

ROM_START( sc5dnddea )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427902.lo", 0x00001, 0x080000, CRC(c4041b95) SHA1(dd23bf09425b6c2cdf6422dfce3db22797f62c73) )
	ROM_LOAD16_BYTE( "95427903.hi", 0x00000, 0x080000, CRC(2f2ed99f) SHA1(157e088838fc551606546b1c660fb6a0f61cd846) )
	sc_dndde_others
ROM_END



ROM_START( sc5dnddi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426790.lo", 0x00001, 0x080000, CRC(da4e4dc9) SHA1(c86349015f8778e2666db187d784340253d66df3) )
	ROM_LOAD16_BYTE( "95426791.hi", 0x00000, 0x080000, CRC(86063fdc) SHA1(c94b13be13bb947fca82c4e042c2d0a37e3c5679) )
	sc_dnddi_others
ROM_END

ROM_START( sc5dnddia )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426824.lo", 0x00001, 0x080000, CRC(5c80b3a0) SHA1(3ad8506c4f52ebff92da0f9d623ebd8712918e8c) )
	ROM_LOAD16_BYTE( "95426825.hi", 0x00000, 0x080000, CRC(cad14f6b) SHA1(8bf99cd5a894eb80fb5e14d6648d4ed1c743a97e) )
	sc_dnddi_others
ROM_END


ROM_START( sc5dnddib )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427790.lo", 0x00001, 0x080000, CRC(5cf6f903) SHA1(96d2b527ccab605c0300dd9d8d5146680cbdb795) )
	ROM_LOAD16_BYTE( "95427791.hi", 0x00000, 0x080000, CRC(b1ecf625) SHA1(910106d49e5432cafaa0a33069c059ef8237ce9e) )
	sc_dnddi_others
ROM_END


ROM_START( sc5dnddic )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427824.lo", 0x00001, 0x080000, CRC(321b526b) SHA1(10204de33e26fbb5c48650676d673a69b79dfda3) )
	ROM_LOAD16_BYTE( "95427825.hi", 0x00000, 0x080000, CRC(0ff60803) SHA1(af10556777aabdab55538afa30b5fb25c0c6c12f) )
	sc_dnddi_others
ROM_END




ROM_START( sc5dnddt )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426578.lo", 0x00001, 0x080000, CRC(a74ca97c) SHA1(11e75209528c43d83ffa901c90b00273ebe9da1e) )
	ROM_LOAD16_BYTE( "95426579.hi", 0x00000, 0x080000, CRC(bc60373a) SHA1(c03021b4de928761c448ad3ac1fdf0455d1b9369) )
	sc_dnddt_others
ROM_END

ROM_START( sc5dnddta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426696.lo", 0x00001, 0x080000, CRC(6213b9c0) SHA1(0084c42f7f8bcf2482eac63fa5e012c42ae8854f) )
	ROM_LOAD16_BYTE( "95426697.hi", 0x00000, 0x080000, CRC(fe4bbb8c) SHA1(275b6c9c19f0b9977c48b8ce58177dded1fddf79) )
	sc_dnddt_others
ROM_END

ROM_START( sc5dnddtb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427578.lo", 0x00001, 0x080000, CRC(3074c629) SHA1(7c1f73690247324cff5229b3a55d6b56f60fc82a) )
	ROM_LOAD16_BYTE( "95427579.hi", 0x00000, 0x080000, CRC(c0176341) SHA1(e49ce2b5739fe9a48273a58eaff5d02a47de5867) )
	sc_dnddt_others
ROM_END

ROM_START( sc5dnddtc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427696.lo", 0x00001, 0x080000, CRC(08365313) SHA1(0177b939949272f807af6fff022e3557732c787e) )
	ROM_LOAD16_BYTE( "95427697.hi", 0x00000, 0x080000, CRC(f14302c1) SHA1(78a7f88eb0fd08f8a837d671341db2e6a55691e1) )
	sc_dnddt_others
ROM_END

ROM_START( sc5dnddtd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3313p71.hi", 0x00000, 0x080000, CRC(f4154827) SHA1(fbdfb6f36556082ec8cfc3beaefb22688bf0b49a) )
	ROM_LOAD16_BYTE( "p3313p71.lo", 0x00001, 0x080000, CRC(9b633600) SHA1(2de506e0d393487e7bc076c29a3eb213c1fa0444) )
	sc_dnddt_others
ROM_END

ROM_START( sc5dnddte )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3313s71.hi", 0x00000, 0x080000, CRC(45ab938e) SHA1(00c04b1b18154f5234e3d5f171935b8118cff301) )
	ROM_LOAD16_BYTE( "p3313s71.lo", 0x00001, 0x080000, CRC(1f8c90b0) SHA1(dd989f34aefcdb381b099977b54f38cd98efd5f4) )
	sc_dnddt_others
ROM_END

ROM_START( sc5dnddtf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3313s72.hi", 0x00000, 0x080000, CRC(ca3f781e) SHA1(9e0e0ba1f8f378df96ea6d8aacbb3a278115175c) )
	ROM_LOAD16_BYTE( "p3313s72.lo", 0x00001, 0x080000, CRC(aebdf2ac) SHA1(780737be28e18dbcaf93e1d3c0593c4ff77f0f95) )
	sc_dnddt_others
ROM_END




ROM_START( sc5dnddo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3316p71.hi", 0x00000, 0x080000, CRC(1a9a9a58) SHA1(c447fa98c547ce4759fe6ff5fb85035c39c7ab39) )
	ROM_LOAD16_BYTE( "p3316p71.lo", 0x00001, 0x080000, CRC(978ca869) SHA1(3ebcdf3ada31a7d0e493a93bd433293ac7405e2e) )
	sc_dnddo_others
ROM_END

ROM_START( sc5dnddoa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3316p72.hi", 0x00000, 0x080000, CRC(a9869e6d) SHA1(cfa6e0af311c2ea7b4b594803b2439f46692a5d5) )
	ROM_LOAD16_BYTE( "p3316p72.lo", 0x00001, 0x080000, CRC(842a8e3d) SHA1(ddd6b4c1abc7bd031650bfe2d79bb164066b3138) )
	sc_dnddo_others
ROM_END

ROM_START( sc5dnddob )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3316s71.hi", 0x00000, 0x080000, CRC(5ccdd8c2) SHA1(292948be4e4532509702c6de9b3e00f2c87d6e8c) )
	ROM_LOAD16_BYTE( "p3316s71.lo", 0x00001, 0x080000, CRC(b00f32c6) SHA1(c8719088f863c27a5f642ccda612d00a651a20c4) )
	sc_dnddo_others
ROM_END

ROM_START( sc5dnddoc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3316s72.hi", 0x00000, 0x080000, CRC(60b2b117) SHA1(1003dca8caa0926c7e53f61d3e248f2d4bbc6af5) )
	ROM_LOAD16_BYTE( "p3316s72.lo", 0x00001, 0x080000, CRC(702a6a1d) SHA1(30d0c0b8e8d86b2e6d290056f9d48b6485e20b32) )
	sc_dnddo_others
ROM_END




ROM_START( sc5dndfl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426676.lo", 0x00001, 0x080000, CRC(8dbcd884) SHA1(d024691be186d846fcf9635d4ac77efd9b63a4b6) )
	ROM_LOAD16_BYTE( "95426677.hi", 0x00000, 0x080000, CRC(244747b2) SHA1(429c70a19e8f56f9aa9d3bacdf75566c58d77fe7) )
	sc_dndfl_others
ROM_END

ROM_START( sc5dndfla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427676.lo", 0x00001, 0x080000, CRC(8cf59b89) SHA1(7ad62468875832ae71cf9126e1eb4964879620f3) )
	ROM_LOAD16_BYTE( "95427677.hi", 0x00000, 0x080000, CRC(4d11c889) SHA1(e66db9f2f5c2574b1a1529e626bfe4310a68bcc6) )
	sc_dndfl_others
ROM_END

ROM_START( sc5dndflb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3309p71.hi", 0x00000, 0x080000, CRC(d5d25ff9) SHA1(bc3cbb0bb4a5dee36f7bfef40f6ee4c4db63dcda) )
	ROM_LOAD16_BYTE( "p3309p71.lo", 0x00001, 0x080000, CRC(c532a4b5) SHA1(484710e74214d80ff62c43cd0dbf973a0bb37a72) )
	sc_dndfl_others
ROM_END

ROM_START( sc5dndflc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3309p72.hi", 0x00000, 0x080000, CRC(ea4eda24) SHA1(a1280073d75e09f38d71db5f71f26528423cf40e) )
	ROM_LOAD16_BYTE( "p3309p72.lo", 0x00001, 0x080000, CRC(6576a5c9) SHA1(c9bda0422f5b3a148072b8d7df3afb145b42126e) )
	sc_dndfl_others
ROM_END

ROM_START( sc5dndfld )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3309s71.hi", 0x00000, 0x080000, CRC(e104cdd5) SHA1(29259bddda6350cdadbeec937aac80391ef5d7cd) )
	ROM_LOAD16_BYTE( "p3309s71.lo", 0x00001, 0x080000, CRC(4da37d67) SHA1(747a8b9815a9222056aadec587249f0d4712d795) )
	sc_dndfl_others
ROM_END

ROM_START( sc5dndfle )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3309s72.hi", 0x00000, 0x080000, CRC(a0ebabb4) SHA1(671b5df68cb8ff9d92b6abdd157819d23602e2a1) )
	ROM_LOAD16_BYTE( "p3309s72.lo", 0x00001, 0x080000, CRC(0a02b017) SHA1(426a58c94224810af69724ed285a371d6a71a4a5) )
	sc_dndfl_others
ROM_END




ROM_START( sc5dndgo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426800.lo", 0x00001, 0x080000, CRC(39367127) SHA1(6160fea037569fff180fa0ed1c754086b31f06ad) )
	ROM_LOAD16_BYTE( "95426801.hi", 0x00000, 0x080000, CRC(c1df2a9b) SHA1(231bd993c0fe3b2a5725b37339e3ba6d911a5e00) )
	sc_dndgo_others
ROM_END

ROM_START( sc5dndgoa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427800.lo", 0x00001, 0x080000, CRC(d808fc3f) SHA1(40788064e83f73a3492241d8d0eb7a326b84bf13) )
	ROM_LOAD16_BYTE( "95427801.hi", 0x00000, 0x080000, CRC(95172f9c) SHA1(ab863a84999b338608599663cb0c5a24e4ecdb0f) )
	sc_dndgo_others
ROM_END




ROM_START( sc5dndgl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426562.lo", 0x00001, 0x080000, CRC(49336039) SHA1(5f95556647c5958bdcdcb8128c3ed1a6b375cbfb) )
	ROM_LOAD16_BYTE( "95426563.hi", 0x00000, 0x080000, CRC(c0dc0b3f) SHA1(745772d3462f627695fcb353d90316a63edb9429) )
	sc_dndgl_others
ROM_END

ROM_START( sc5dndgla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426626.lo", 0x00001, 0x080000, CRC(9e2407c3) SHA1(73e9bff320cdc87bd1347a898db1cd06c24e51ad) )
	ROM_LOAD16_BYTE( "95426627.hi", 0x00000, 0x080000, CRC(a048f32e) SHA1(ea9b705b515b5948574ebdebd84888b1cdf85eab) )
	sc_dndgl_others
ROM_END

ROM_START( sc5dndglb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426690.lo", 0x00001, 0x080000, CRC(d097ddbc) SHA1(bb08d825ebe85c6dab7944ced0557d8d496bda3b) )
	ROM_LOAD16_BYTE( "95426691.hi", 0x00000, 0x080000, CRC(64aa23cc) SHA1(00b0bf467b7c3e5f5d580b12776b2169c349ff70) )
	sc_dndgl_others
ROM_END

ROM_START( sc5dndglc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426860.lo", 0x00001, 0x080000, CRC(d44426d7) SHA1(f6eea5d092e684917df3fb45ddf100793a47ebfe) )
	ROM_LOAD16_BYTE( "95426861.hi", 0x00000, 0x080000, CRC(0edd3b08) SHA1(a52516f448b85e7d486f0bf5faea1cb460b56224) )
	sc_dndgl_others
ROM_END

ROM_START( sc5dndgld )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427562.lo", 0x00001, 0x080000, CRC(2fc1bf60) SHA1(fb527d88b8a6963ba47c8365b8a3d26f4a656346) )
	ROM_LOAD16_BYTE( "95427563.hi", 0x00000, 0x080000, CRC(1f3d8eca) SHA1(9a38b7aaa34fd773d1f5d9826474cc93a40a5d28) )
	sc_dndgl_others
ROM_END

ROM_START( sc5dndgle )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427626.lo", 0x00001, 0x080000, CRC(8a7ea029) SHA1(e330139d4c2032567702f9cfb4b692896063f931) )
	ROM_LOAD16_BYTE( "95427627.hi", 0x00000, 0x080000, CRC(af702461) SHA1(2ed8740e0726dfc4568004e838b207a74c54f20d) )
	sc_dndgl_others
ROM_END

ROM_START( sc5dndglf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427690.lo", 0x00001, 0x080000, CRC(39a0d719) SHA1(7a7c220e1e0af38d29da58bee6a2887eb38f4a28) )
	ROM_LOAD16_BYTE( "95427691.hi", 0x00000, 0x080000, CRC(154cf89d) SHA1(4edfa3162fb246fc3bcaa5c131a868d9dc84a65b) )
	sc_dndgl_others
ROM_END

ROM_START( sc5dndglg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427860.lo", 0x00001, 0x080000, CRC(90a642c5) SHA1(64afaa2ab321cf1e1b46b5c66525af100aea8f74) )
	ROM_LOAD16_BYTE( "95427861.hi", 0x00000, 0x080000, CRC(fe3bb2ce) SHA1(e04589f47436a1269ae697cb153af1b2e48a7a20) )
	sc_dndgl_others
ROM_END

ROM_START( sc5dndglh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3310p71.hi", 0x00000, 0x080000, CRC(93953596) SHA1(867f4fcca166e35f6b275c067a301c7aef12f6c0) )
	ROM_LOAD16_BYTE( "p3310p71.lo", 0x00001, 0x080000, CRC(c6daebd9) SHA1(d1c523e885ba4d729c6b74c2d32d373a1c38a3f7) )
	sc_dndgl_others
ROM_END

ROM_START( sc5dndgli )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3310p72.hi", 0x00000, 0x080000, CRC(8b56e7fd) SHA1(e628db20db2b02bc2e9ce9b195a798b355e65957) )
	ROM_LOAD16_BYTE( "p3310p72.lo", 0x00001, 0x080000, CRC(108ffb05) SHA1(fdcb95d6be5fbd0910b1c22f193752a1c870a6aa) )
	sc_dndgl_others
ROM_END

ROM_START( sc5dndglj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3310s71.hi", 0x00000, 0x080000, CRC(b3ed6b15) SHA1(6bce0dba67a7026ca025f3808978484c8259cdb3) )
	ROM_LOAD16_BYTE( "p3310s71.lo", 0x00001, 0x080000, CRC(29ac8746) SHA1(730dde7723fa42ab7526f8f768827dc8e0ff41c7) )
	sc_dndgl_others
ROM_END

ROM_START( sc5dndglk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3310s72.hi", 0x00000, 0x080000, CRC(20e3f24a) SHA1(31c346a92d20f4c486cff3938d73391dda45ad0f) )
	ROM_LOAD16_BYTE( "p3310s72.lo", 0x00001, 0x080000, CRC(ee262128) SHA1(15323bf6d5ef8ce0c126cf30fe0b9ae869bc2e1e) )
	sc_dndgl_others
ROM_END




ROM_START( sc5dndld )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426794.lo", 0x00001, 0x080000, CRC(24f1eeb3) SHA1(ed1aed751924f43b16d8cef7463167af872017f6) )
	ROM_LOAD16_BYTE( "95426795.hi", 0x00000, 0x080000, CRC(79cb1434) SHA1(fd4a9543d2b873d1c87079bd3c98dd782ea9bb34) )
	sc_dndld_others
ROM_END

ROM_START( sc5dndlda )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427794.lo", 0x00001, 0x080000, CRC(4a07d98c) SHA1(b24bddabf866601c496b3a8e5e02f75076d27f0e) )
	ROM_LOAD16_BYTE( "95427795.hi", 0x00000, 0x080000, CRC(8b90c5cd) SHA1(c9d1ffed3c2420597c1fe3b589db8485e94f3387) )
	sc_dndld_others
ROM_END




ROM_START( sc5dndmb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426694.lo", 0x00001, 0x080000, CRC(950ca36e) SHA1(7117d648dc42bcc8d222887b12c8b868c4e9a786) )
	ROM_LOAD16_BYTE( "95426695.hi", 0x00000, 0x080000, CRC(c04f8237) SHA1(8011df90e1f163feeb672b90fcf43fc0a02e1678) )
	sc_dndmb_others
ROM_END

ROM_START( sc5dndmba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426796.lo", 0x00001, 0x080000, CRC(0d56b9ee) SHA1(ea23cb9e349d501e1889736640324046eb7b7200) )
	ROM_LOAD16_BYTE( "95426797.hi", 0x00000, 0x080000, CRC(3d8a3753) SHA1(f7570f7dbf38fbafa1634ad494138e5ba1d39df7) )
	sc_dndmb_others
ROM_END

ROM_START( sc5dndmbb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426864.lo", 0x00001, 0x080000, CRC(307c66c9) SHA1(effeca62e43df66bcb71e63140c9ca178d4e368d) )
	ROM_LOAD16_BYTE( "95426865.hi", 0x00000, 0x080000, CRC(c4a063e7) SHA1(6dbceaadb05d12f7f378d40825751ff7d09f6ef0) )
	sc_dndmb_others
ROM_END

ROM_START( sc5dndmbc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426876.lo", 0x00001, 0x080000, CRC(1efa04fb) SHA1(27ed4542581b4ff45530b60fafa65a68212b73cb) )
	ROM_LOAD16_BYTE( "95426877.hi", 0x00000, 0x080000, CRC(c8211660) SHA1(4e32a4eb4e70ddcd45da279ed3dd9b239bf4353e) )
	sc_dndmb_others
ROM_END

ROM_START( sc5dndmbd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427694.lo", 0x00001, 0x080000, CRC(3ae07652) SHA1(7cd263f0a90fa7cbef8e8b781ac90f83bc1d95ad) )
	ROM_LOAD16_BYTE( "95427695.hi", 0x00000, 0x080000, CRC(0049809f) SHA1(42bee330256ed771da9703a4185a0dcbda3235ae) )
	sc_dndmb_others
ROM_END

ROM_START( sc5dndmbe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427796.lo", 0x00001, 0x080000, CRC(177cf067) SHA1(21cfd7f6e86964115180ce81db929b5f6a523c4a) )
	ROM_LOAD16_BYTE( "95427797.hi", 0x00000, 0x080000, CRC(e708e777) SHA1(9bbc8b8bd8287028257d59f1d6d2574881009277) )
	sc_dndmb_others
ROM_END

ROM_START( sc5dndmbf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427864.lo", 0x00001, 0x080000, CRC(795d29d2) SHA1(e1d27f46a11e5a85090440e3bf3b1500003d5d06) )
	ROM_LOAD16_BYTE( "95427865.hi", 0x00000, 0x080000, CRC(8b155e76) SHA1(b3bec85b913e408fe2bc62165bb360e4ec6e57b1) )
	sc_dndmb_others
ROM_END

ROM_START( sc5dndmbg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427876.lo", 0x00001, 0x080000, CRC(69c44133) SHA1(50d3a6db2f0664cb48a53e71cb62524fcda4ea18) )
	ROM_LOAD16_BYTE( "95427877.hi", 0x00000, 0x080000, CRC(87bb490e) SHA1(a7a1f232065cec58815cb11a281fb0988698b743) )
	sc_dndmb_others
ROM_END

ROM_START( sc5dndmbh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3407p11.hi", 0x00000, 0x080000, CRC(6dfec831) SHA1(819e97aecb8777323f723a9d768ee511854f3584) )
	ROM_LOAD16_BYTE( "p3407p11.lo", 0x00001, 0x080000, CRC(9a4be116) SHA1(a32b1ab39938b483129e3ec1b811eb9e1d6f4ab2) )
	sc_dndmb_others
ROM_END

ROM_START( sc5dndmbi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3407p13.hi", 0x00000, 0x080000, CRC(3fa805a3) SHA1(9a002323719d4f2d13d3645611601650e3bc902f) )
	ROM_LOAD16_BYTE( "p3407p13.lo", 0x00001, 0x080000, CRC(5ca2a0cf) SHA1(e065a3504c53b87c844aaefbfa6a1b3116951bd1) )
	sc_dndmb_others
ROM_END

ROM_START( sc5dndmbj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3407s11.hi", 0x00000, 0x080000, CRC(e2d831ff) SHA1(8c26789960d0f77c4d0e17d4f3c64212ea3c5c72) )
	ROM_LOAD16_BYTE( "p3407s11.lo", 0x00001, 0x080000, CRC(4b6fab54) SHA1(6c2014400b9d7692c8e6b345924068cd5b5b7ab8) )
	sc_dndmb_others
ROM_END

ROM_START( sc5dndmbk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3407s13.hi", 0x00000, 0x080000, CRC(cbbb0081) SHA1(17553777cfba64e9af5536e24b361d68335cbf86) )
	ROM_LOAD16_BYTE( "p3407s13.lo", 0x00001, 0x080000, CRC(c68c23c0) SHA1(837bae53f2884a8c09d9e923572448abc34711e1) )
	sc_dndmb_others
ROM_END




ROM_START( sc5dndmd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426786.lo", 0x00001, 0x080000, CRC(fb527cd3) SHA1(1e77ea5b62126dd975a0d60c238998d3bcff7fce) )
	ROM_LOAD16_BYTE( "95426787.hi", 0x00000, 0x080000, CRC(e99a0bef) SHA1(23a8dce42ac136eaf961b83c633aa219741f08d5) )
	sc_dndmd_others
ROM_END

ROM_START( sc5dndmda )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426836.lo", 0x00001, 0x080000, CRC(fccfe5ab) SHA1(817367349ddc9c138008beb19af3244c99893db7) )
	ROM_LOAD16_BYTE( "95426837.hi", 0x00000, 0x080000, CRC(ba12681d) SHA1(2cddad5e774ac472b7f8fc646d17ccac5ceeba20) )
	sc_dndmd_others
ROM_END

ROM_START( sc5dndmdb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426838.lo", 0x00001, 0x080000, CRC(d48a430a) SHA1(cfeb444cca0b374bfff4ac1f3ec8a0ef65d3ac0b) )
	ROM_LOAD16_BYTE( "95426839.hi", 0x00000, 0x080000, CRC(18a780c9) SHA1(e1cda4af84f79810305f51340d67e5f31da48cf8) )
	sc_dndmd_others
ROM_END

ROM_START( sc5dndmdc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426862.lo", 0x00001, 0x080000, CRC(74849196) SHA1(c34bd4b8f67ffa86abb42ffcc9a83aa1663fd9cc) )
	ROM_LOAD16_BYTE( "95426863.hi", 0x00000, 0x080000, CRC(a72d2f11) SHA1(0102e59b55399153a5f5d7fc248d69e30cd50da2) )
	sc_dndmd_others
ROM_END

ROM_START( sc5dndmdd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426866.lo", 0x00001, 0x080000, CRC(f0fd9206) SHA1(0dfb454870c43f428604e9717a352fc6deda9212) )
	ROM_LOAD16_BYTE( "95426867.hi", 0x00000, 0x080000, CRC(e38b6b48) SHA1(a9d815eb12b7c4651e4adb123e398030c0eb2179) )
	sc_dndmd_others
ROM_END

ROM_START( sc5dndmde )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427786.lo", 0x00001, 0x080000, CRC(b50adb65) SHA1(ff259c97c02994eb58b0012654f017119c0f538e) )
	ROM_LOAD16_BYTE( "95427787.hi", 0x00000, 0x080000, CRC(5c9d20b0) SHA1(780b86395d2678216d7e14ef4ab6138959029203) )
	sc_dndmd_others
ROM_END

ROM_START( sc5dndmdf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427836.lo", 0x00001, 0x080000, CRC(83faf417) SHA1(d8436e4a9524cc1e2e6a6b834731b67c7edef40f) )
	ROM_LOAD16_BYTE( "95427837.hi", 0x00000, 0x080000, CRC(0503486d) SHA1(4c82f58de544f6bb6349368ea5422fcfcbeb9498) )
	sc_dndmd_others
ROM_END

ROM_START( sc5dndmdg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427838.lo", 0x00001, 0x080000, CRC(e046eb60) SHA1(5bd7eb4b2d2cec81503e153ece20e2b582cd1bd4) )
	ROM_LOAD16_BYTE( "95427839.hi", 0x00000, 0x080000, CRC(a304ce00) SHA1(74aedcd8ad06b168285ce894b149fa77c9d46b9a) )
	sc_dndmd_others
ROM_END

ROM_START( sc5dndmdh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427862.lo", 0x00001, 0x080000, CRC(5704cacb) SHA1(6f8a0075fd82baaa1b0d757ab1ecc044a1f59992) )
	ROM_LOAD16_BYTE( "95427863.hi", 0x00000, 0x080000, CRC(b7398001) SHA1(f863113565c7d83b5cdfff335e3a43de3655375f) )
	sc_dndmd_others
ROM_END

ROM_START( sc5dndmdi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427866.lo", 0x00001, 0x080000, CRC(46f8244c) SHA1(59fc36323f772506d94dd2b2d96523dae823c69c) )
	ROM_LOAD16_BYTE( "95427867.hi", 0x00000, 0x080000, CRC(ee973a37) SHA1(3da42f8f6587c408c3c9e102dbd422a86195fd72) )
	sc_dndmd_others
ROM_END



ROM_START( sc5dndpa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426600.lo", 0x00001, 0x080000, CRC(0b999f25) SHA1(371e15a9182e83ef4245398f4dcf542bf0cb1471) )
	ROM_LOAD16_BYTE( "95426601.hi", 0x00000, 0x080000, CRC(8efda096) SHA1(11c8cef15b792391c62a97be35ae7f4fc7138fe6) )
	sc_dndpa_others
ROM_END

ROM_START( sc5dndpaa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426654.lo", 0x00001, 0x080000, CRC(421cbdc5) SHA1(5f6ed7e4e0624bfb95c039554809b834d330b932) )
	ROM_LOAD16_BYTE( "95426655.hi", 0x00000, 0x080000, CRC(5d2a2256) SHA1(33855ece3112bd87b79517b56e1b9bd3cf8cdf98) )
	sc_dndpa_others
ROM_END

ROM_START( sc5dndpab )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427600.lo", 0x00001, 0x080000, CRC(85d3ea06) SHA1(fecde10abf342b7f8255251276f42a2034e4cdc8) )
	ROM_LOAD16_BYTE( "95427601.hi", 0x00000, 0x080000, CRC(594a7d67) SHA1(411373ff7277c84b9cdebb766a1dce6359674bb6) )
	sc_dndpa_others
ROM_END

ROM_START( sc5dndpac )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427654.lo", 0x00001, 0x080000, CRC(1908555b) SHA1(80cfdf571a513a2d6da5c0c89b7c048d42b82bc0) )
	ROM_LOAD16_BYTE( "95427655.hi", 0x00000, 0x080000, CRC(31c5e56b) SHA1(2fab1e34e69b5d42123a4c6499d1a4b3ca6fd344) )
	sc_dndpa_others
ROM_END




ROM_START( sc5ddptg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426872.lo", 0x00001, 0x080000, CRC(d09ec5c8) SHA1(5c3c6c62b5e1f3f9e6a8f9d90e89971f5d79069a) )
	ROM_LOAD16_BYTE( "95426873.hi", 0x00000, 0x080000, CRC(e1f1b293) SHA1(f397bf2e97712c2f805dd1859073d8819f8b7fa7) )
	sc_ddptg_others
ROM_END

ROM_START( sc5ddptga )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426936.lo", 0x00001, 0x080000, CRC(99a16526) SHA1(1e95ccea0492e7fcd0475127f4c806ea31318ac1) )
	ROM_LOAD16_BYTE( "95426937.hi", 0x00000, 0x080000, CRC(02a5a5c2) SHA1(3fde8ebaf6fd123a447b08912e521ab4f83823fc) )
	sc_ddptg_others
ROM_END

ROM_START( sc5ddptgb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427872.lo", 0x00001, 0x080000, CRC(5de69791) SHA1(5d2acb1c8a8742b38b5a43dad4c25275b1f6bf9d) )
	ROM_LOAD16_BYTE( "95427873.hi", 0x00000, 0x080000, CRC(9eef10fe) SHA1(6081f4d226565165ee3dbec5eab1e09a13fff35c) )
	sc_ddptg_others
ROM_END

ROM_START( sc5ddptgc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427936.lo", 0x00001, 0x080000, CRC(3f290768) SHA1(97f9b9a38bf7409a652afb7ce7315e6a96906dc7) )
	ROM_LOAD16_BYTE( "95427937.hi", 0x00000, 0x080000, CRC(0477abf3) SHA1(df52a3ae072139c698b842896ffa3b80be48990d) )
	sc_ddptg_others
ROM_END




ROM_START( sc5ddply )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3303p11.hi", 0x00000, 0x080000, CRC(0fda3a5b) SHA1(b7d96ac0724dad8e2676d0bf281edbc077b81d5a) )
	ROM_LOAD16_BYTE( "p3303p11.lo", 0x00001, 0x080000, CRC(f9c9818f) SHA1(f7ea65e6099e94092846a36c3f7deab5553b027e) )
	sc_ddply_others
ROM_END

ROM_START( sc5ddplya )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3303s11.hi", 0x00000, 0x080000, CRC(1275867c) SHA1(6f612b9e397106a2fc050241305c7ca1661b9e96) )
	ROM_LOAD16_BYTE( "p3303s11.lo", 0x00001, 0x080000, CRC(b0e29d4d) SHA1(feed1310eba65853faa9e634472419038b7db982) )
	sc_ddply_others
ROM_END






ROM_START( sc5dndrr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426784.lo", 0x00001, 0x080000, CRC(19a3a912) SHA1(033072b3e6dd41c40cab0b7d361bea258560696c) )
	ROM_LOAD16_BYTE( "95426785.hi", 0x00000, 0x080000, CRC(f962e6f8) SHA1(bd46e3f736afaf144e5a72232bd31e7d736ca58c) )
	sc_dndrr_others
ROM_END

ROM_START( sc5dndrra )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426880.lo", 0x00001, 0x080000, CRC(ac22b48d) SHA1(f618d479dc4cab24ef7552760ff98dc000ae163f) )
	ROM_LOAD16_BYTE( "95426881.hi", 0x00000, 0x080000, CRC(ad855ae4) SHA1(bf533137ea191b7c92003661be4007afff348163) )
	sc_dndrr_others
ROM_END

ROM_START( sc5dndrrb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427784.lo", 0x00001, 0x080000, CRC(ae9b171a) SHA1(96f9824043571c682c1f72261fdad2f2f55b732e) )
	ROM_LOAD16_BYTE( "95427785.hi", 0x00000, 0x080000, CRC(f8ee4d22) SHA1(886f9c6416d08a7ac4a319b03ae47fa3365bb37a) )
	sc_dndrr_others
ROM_END

ROM_START( sc5dndrrc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427880.lo", 0x00001, 0x080000, CRC(e3d6c3ec) SHA1(89a09a5fea57b56f7a6cda644a89c63af73c9f65) )
	ROM_LOAD16_BYTE( "95427881.hi", 0x00000, 0x080000, CRC(fb419a7c) SHA1(6197f8aee36de9b2eee1b4c336817557b9d6e8f0) )
	sc_dndrr_others
ROM_END




ROM_START( sc5dndsi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3219p71.hi", 0x00000, 0x080000, CRC(998038e1) SHA1(577650c85e025bb3b56ce4a618003b77768531cd) )
	ROM_LOAD16_BYTE( "p3219p71.lo", 0x00001, 0x080000, CRC(b8e397fa) SHA1(b87349fa551317e96614b421f7167243af6381d4) )
	sc_dndsi_others
ROM_END

ROM_START( sc5dndsia )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3219p72.hi", 0x00000, 0x080000, CRC(fb10dad2) SHA1(5ba3b60285ae6019eea526c56caf362870c6dfca) )
	ROM_LOAD16_BYTE( "p3219p72.lo", 0x00001, 0x080000, CRC(47962d32) SHA1(d254b3c9ae27a7501433f84e20bb95653e9c5f9d) )
	sc_dndsi_others
ROM_END

ROM_START( sc5dndsib )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3219p73.hi", 0x00000, 0x080000, CRC(0a8153ae) SHA1(16464f7f2020f587ef9f1ffd393410d4b33d7290) )
	ROM_LOAD16_BYTE( "p3219p73.lo", 0x00001, 0x080000, CRC(83ab4f08) SHA1(c20f3186a34bba2b67b63b5e1dea3abdf8f5c4fd) )
	sc_dndsi_others
ROM_END

ROM_START( sc5dndsic )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3219s71.hi", 0x00000, 0x080000, CRC(0a8bc683) SHA1(49421a15598c6bc25fcfa2f1c754fa4a2160fc22) )
	ROM_LOAD16_BYTE( "p3219s71.lo", 0x00001, 0x080000, CRC(5370078c) SHA1(cdba77c38f3a9c1f21cbcb805f8efc643cf60095) )
	sc_dndsi_others
ROM_END

ROM_START( sc5dndsid )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3219s73.hi", 0x00000, 0x080000, CRC(ad675a6a) SHA1(8d6c94b4d804f8c6b2b4e7e395782646eba8e285) )
	ROM_LOAD16_BYTE( "p3219s73.lo", 0x00001, 0x080000, CRC(5e91a6bd) SHA1(3dd3456b2c0059d129fd85bb8e38a8995f194dc2) )
	sc_dndsi_others
ROM_END




ROM_START( sc5dndrt )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426564.lo", 0x00001, 0x080000, CRC(80576d4c) SHA1(88196fb562269827414ac10f1fcf08921b5eea50) )
	ROM_LOAD16_BYTE( "95426565.hi", 0x00000, 0x080000, CRC(f6c6a4b0) SHA1(07cd42d85ddc9760222ccce445280a5d47058cab) )
	sc_dndrt_others
ROM_END

ROM_START( sc5dndrta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426628.lo", 0x00001, 0x080000, CRC(d50998d5) SHA1(08b75ee0ac3ddaeccd5a90c043d911af2e2e5d3f) )
	ROM_LOAD16_BYTE( "95426629.hi", 0x00000, 0x080000, CRC(331eac9e) SHA1(9e8e269754d012597568ebdc6ff6d6205f37aa38) )
	sc_dndrt_others
ROM_END

ROM_START( sc5dndrtb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426856.lo", 0x00001, 0x080000, CRC(a7a83a03) SHA1(60fcc72fef47239818e124d2e6f15337a9b59847) )
	ROM_LOAD16_BYTE( "95426857.hi", 0x00000, 0x080000, CRC(75f8fe7d) SHA1(c8ec593ce18bff56bc89349f0c7a9b11ead83cbc) )
	sc_dndrt_others
ROM_END

ROM_START( sc5dndrtc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427564.lo", 0x00001, 0x080000, CRC(10254396) SHA1(0b7e526c9bacb46dfb4e81f38bfffa64ba6cb44a) )
	ROM_LOAD16_BYTE( "95427565.hi", 0x00000, 0x080000, CRC(bf1018c3) SHA1(fd52b008ac5a921c53938e3d080c3ebe1c81c3c3) )
	sc_dndrt_others
ROM_END

ROM_START( sc5dndrtd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427628.lo", 0x00001, 0x080000, CRC(419ee27c) SHA1(2d2081e5247b2da701a1c24f4227c84f8f15f034) )
	ROM_LOAD16_BYTE( "95427629.hi", 0x00000, 0x080000, CRC(a55237f6) SHA1(f59a14e5332f8fc62a97edae6319d69a8ae421cf) )
	sc_dndrt_others
ROM_END

ROM_START( sc5dndrte )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427856.lo", 0x00001, 0x080000, CRC(17522a17) SHA1(31d65822f36bedf6f2696b8ddddd3c7fc67a3277) )
	ROM_LOAD16_BYTE( "95427857.hi", 0x00000, 0x080000, CRC(1c386bba) SHA1(7a4b89788042fd6045342abbcca5ce34a67dd652) )
	sc_dndrt_others
ROM_END




ROM_START( sc5dndpd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426686.lo", 0x00001, 0x080000, CRC(d308b28a) SHA1(522fdd06185d26a328c251ba95818d318d85fe05) )
	ROM_LOAD16_BYTE( "95426687.hi", 0x00000, 0x080000, CRC(daef4474) SHA1(210955eb3bf891190a29cc7ab0234fce92567e2d) )
	sc_dndpd_others
ROM_END

ROM_START( sc5dndpda )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426850.lo", 0x00001, 0x080000, CRC(a526c153) SHA1(2380083cf6df2b76f5a842f99205434a346ac822) )
	ROM_LOAD16_BYTE( "95426851.hi", 0x00000, 0x080000, CRC(0205ab1e) SHA1(f06a28717a990f63d5ae801f298c8030681b010c) )
	sc_dndpd_others
ROM_END

ROM_START( sc5dndpdb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427686.lo", 0x00001, 0x080000, CRC(799a6b4f) SHA1(58af5a23868b225928dd73cb45b61c161aad82ec) )
	ROM_LOAD16_BYTE( "95427687.hi", 0x00000, 0x080000, CRC(1afee3e0) SHA1(e5d113043a16947f95b67716d9954c46fd5f2bfd) )
	sc_dndpd_others
ROM_END

ROM_START( sc5dndpdc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427850.lo", 0x00001, 0x080000, CRC(024a4826) SHA1(c4124526102be162ab101de25748461f26a0936f) )
	ROM_LOAD16_BYTE( "95427851.hi", 0x00000, 0x080000, CRC(b0cae8de) SHA1(1f70ea6b56407e9ac8794e524bf4375ff38a0e1c) )
	sc_dndpd_others
ROM_END



ROM_START( sc5dndpc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3303p72.hi", 0x00000, 0x080000, CRC(01399a36) SHA1(a7bacb358f0f803b3cc2118bbdf112f71b1cc770) )
	ROM_LOAD16_BYTE( "p3303p72.lo", 0x00001, 0x080000, CRC(310adb3c) SHA1(03faf72ee909c142b633ca226b28121dfd8cf525) )
	sc_dndpc_others
ROM_END


ROM_START( sc5dndpca )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3303s72.hi", 0x00000, 0x080000, CRC(8d896e95) SHA1(347c83bf914cc40fae6a89d7c27f97cf861083ae) )
	ROM_LOAD16_BYTE( "p3303s72.lo", 0x00001, 0x080000, CRC(5e793210) SHA1(bfe9fbdc3ff11bbdd42741c6d2ff66265b792f90) )
	sc_dndpc_others
ROM_END




ROM_START( sc5dndtb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426780.lo", 0x00001, 0x080000, CRC(beba0181) SHA1(228f5c8ef549b36c3d10c9eed19d98005ba86abe) )
	ROM_LOAD16_BYTE( "95426781.hi", 0x00000, 0x080000, CRC(466771cf) SHA1(5deea15eb735095aa0a0fdb6275b7a8da036ebf6) )
	sc_dndtb_others
ROM_END


ROM_START( sc5dndtba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427780.lo", 0x00001, 0x080000, CRC(5cbb0fb9) SHA1(aab95a8b64ab455723ce30aff22d88ea6825f0f9) )
	ROM_LOAD16_BYTE( "95427781.hi", 0x00000, 0x080000, CRC(41e8e286) SHA1(296f9d3fbecaa6a1bd03279d8109ce544c7e0751) )
	sc_dndtb_others
ROM_END




ROM_START( sc5devil )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420562.lo", 0x00001, 0x080000, CRC(de71acc6) SHA1(f4d7697929db6ff629764608eed6b07f5f8601b9) )
	ROM_LOAD16_BYTE( "95420563.hi", 0x00000, 0x080000, CRC(3dfd6cd8) SHA1(943df339ec339155db28c4d688b6ed835a9e1e77) )
	sc_devil_others
ROM_END

ROM_START( sc5devila )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420748.lo", 0x00001, 0x080000, CRC(49f591f3) SHA1(270a532f8be3766c6eae7632d813d5c58a5d5a68) )
	ROM_LOAD16_BYTE( "95420749.hi", 0x00000, 0x080000, CRC(3d3a9afc) SHA1(914215eee96234b2913ad33c0ff008f2d6ce42a8) )
	sc_devil_others
ROM_END

ROM_START( sc5devilb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421562.lo", 0x00001, 0x080000, CRC(12d560cf) SHA1(909fcddbfb208598ae66ed20f1e1d7bffee0914c) )
	ROM_LOAD16_BYTE( "95421563.hi", 0x00000, 0x080000, CRC(07651d3f) SHA1(1709b08f7d6e14239900b887c20c801ee94a2f85) )
	sc_devil_others
ROM_END

ROM_START( sc5devilc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421748.lo", 0x00001, 0x080000, CRC(fe23d2d7) SHA1(80f290edef39b9a92ac1be0f98f21e66c80eb9bf) )
	ROM_LOAD16_BYTE( "95421749.hi", 0x00000, 0x080000, CRC(875c5df1) SHA1(c4664c6541a17fd1d575ed1d7839a385a943e75d) )
	sc_devil_others
ROM_END



ROM_START( sc5dracp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3007p42.hi", 0x00000, 0x080000, CRC(dff8d46d) SHA1(cc5fda9909e1067d1f43ca9b1ef100652a36389a) )
	ROM_LOAD16_BYTE( "p3007p42.lo", 0x00001, 0x080000, CRC(9d030171) SHA1(514c9bb3da5c084738784e6fe5993e76e2263b71) )
	sc_dracp_others
ROM_END

ROM_START( sc5dracpa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3007s42.hi", 0x00000, 0x080000, CRC(ffadb510) SHA1(193fa0cf1cfcbdb752dcb6a357e726c3205460d4) )
	ROM_LOAD16_BYTE( "p3007s42.lo", 0x00001, 0x080000, CRC(5496cbe2) SHA1(460d0cdc38b0785dcaecb4ba8254fec1b32a9fd7) )
	sc_dracp_others
ROM_END


ROM_START( sc5fgbh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426652.lo", 0x00001, 0x080000, CRC(bd72d8ef) SHA1(c9ca907fc1f25bb12c0f0409a79fd49f350bf64c) )
	ROM_LOAD16_BYTE( "95426653.hi", 0x00000, 0x080000, CRC(0e8458f6) SHA1(e716450dad5dfa616c02bc07e6842fa90704ad3f) )
	sc_fgbh_others
ROM_END

ROM_START( sc5fgbha )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427652.lo", 0x00001, 0x080000, CRC(ef45b1b3) SHA1(ac4448d2e1f540d654785ab59224a0848d66da74) )
	ROM_LOAD16_BYTE( "95427653.hi", 0x00000, 0x080000, CRC(ac0450a1) SHA1(1e348be661ef50d39bded3386eaba627570f6c95) )
	sc_fgbh_others
ROM_END

ROM_START( sc5fgbhb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3306p71.hi", 0x00000, 0x080000, CRC(b48cf490) SHA1(51b5ad358edfc7cb7a68e9ab8784460837c9b632) )
	ROM_LOAD16_BYTE( "p3306p71.lo", 0x00001, 0x080000, CRC(8cfed5af) SHA1(800d31491391199317f290077b41ed46acb84d5c) )
	sc_fgbh_others
ROM_END

ROM_START( sc5fgbhc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3306s71.hi", 0x00000, 0x080000, CRC(84cd120a) SHA1(c6ac1867ede452c09f40c9a06fb1de1b3938e02f) )
	ROM_LOAD16_BYTE( "p3306s71.lo", 0x00001, 0x080000, CRC(308edcce) SHA1(7281f0911c83a5971e0f0f984177db2247548ceb) )
	sc_fgbh_others
ROM_END




ROM_START( sc5fggp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3301p11.hi", 0x00000, 0x080000, CRC(078596d1) SHA1(ce678b49fdab810eb595a57e237d9a91f5444bb3) )
	ROM_LOAD16_BYTE( "p3301p11.lo", 0x00001, 0x080000, CRC(8a82e48d) SHA1(b4859a388bb12bddabf89b7f10f61b64826d8f33) )
	sc_fggp_others
ROM_END

ROM_START( sc5fggpa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3301p12.hi", 0x00000, 0x080000, CRC(984a9241) SHA1(dafa3c7356a8e2df8d5bb5e4af5bca1cd9549a16) )
	ROM_LOAD16_BYTE( "p3301p12.lo", 0x00001, 0x080000, CRC(9bd6fb14) SHA1(37a74a8829fe8569b6ac76465a5c9ed1f22ed251) )
	sc_fggp_others
ROM_END

ROM_START( sc5fggpb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3301p13.hi", 0x00000, 0x080000, CRC(6d569756) SHA1(aaa7083e2e99971fcac3f1bf082b50cc4cc5a6ae) )
	ROM_LOAD16_BYTE( "p3301p13.lo", 0x00001, 0x080000, CRC(758f8920) SHA1(ccc03cce127ed07d0ef036d2025c37efa5b39341) )
	sc_fggp_others
ROM_END

ROM_START( sc5fggpc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3301p71.hi", 0x00000, 0x080000, CRC(b86c7b2a) SHA1(39ce9553dfd964ccab4c4ddc24be98ec05ad4db0) )
	ROM_LOAD16_BYTE( "p3301p71.lo", 0x00001, 0x080000, CRC(6652ccc9) SHA1(e9813e15c072faf95392e3f554bf385d8b2082f7) )
	sc_fggp_others
ROM_END

ROM_START( sc5fggpd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3301s11.hi", 0x00000, 0x080000, CRC(01605580) SHA1(095490b99801ce008d2200bf66509a3dff3823ac) )
	ROM_LOAD16_BYTE( "p3301s11.lo", 0x00001, 0x080000, CRC(eadd9941) SHA1(d63e618a2262fc4eaecdcc07338feaef6aa8fc4e) )
	sc_fggp_others
ROM_END

ROM_START( sc5fggpe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3301s12.hi", 0x00000, 0x080000, CRC(60f36d9a) SHA1(734660b1df84c8b55eae68ef6a95bf520d70e769) )
	ROM_LOAD16_BYTE( "p3301s12.lo", 0x00001, 0x080000, CRC(c1b4f4be) SHA1(c00b04d743f3ad2b4f6a88f0fe2ed818eb2d7a1c) )
	sc_fggp_others
ROM_END

ROM_START( sc5fggpf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3301s13.hi", 0x00000, 0x080000, CRC(2dbc846f) SHA1(8b01d38b1638ec29f02bf110d839803dbab79e40) )
	ROM_LOAD16_BYTE( "p3301s13.lo", 0x00001, 0x080000, CRC(55cf9abc) SHA1(f10d0053e0b6379a1d5d2300f4df10fa59519c33) )
	sc_fggp_others
ROM_END

ROM_START( sc5fggpg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3301s71.hi", 0x00000, 0x080000, CRC(1c3c0d91) SHA1(43f25296edd272eb3ba3510f861856f2b27fca0d) )
	ROM_LOAD16_BYTE( "p3301s71.lo", 0x00001, 0x080000, CRC(20828f79) SHA1(e16346a8d34f22abca67dddc0b5de8b800b848cd) )
	sc_fggp_others
ROM_END




ROM_START( sc5fast )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95414220.odd", 0x00001, 0x080000, CRC(ec6810f9) SHA1(a4eda90bc3f91e42472257f810df4d04b00d394c) )
	ROM_LOAD16_BYTE( "95414221.evn", 0x00000, 0x080000, CRC(102f5ea1) SHA1(0067d0d125d9d895defc704643e34f1252d0af60) )
	sc_fast_others
ROM_END




ROM_START( sc5fnclb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418608.lo", 0x00001, 0x080000, CRC(a3ef5746) SHA1(7e3b233d022cd79672dde69d14d94de6d1e04e01) )
	ROM_LOAD16_BYTE( "95418609.hi", 0x00000, 0x080000, CRC(e4c0ed80) SHA1(55064cc5d33c69a803d921fb3bcf5dd5ed1c9311) )
	sc_fnclb_others
ROM_END

ROM_START( sc5fnclba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418632.lo", 0x00001, 0x080000, CRC(6d999198) SHA1(3eee67c474cba80293c685bef236f60ca294859e) )
	ROM_LOAD16_BYTE( "95418633.hi", 0x00000, 0x080000, CRC(ac8e0908) SHA1(2c3f43320ac42d406aaca12abd26f7748acb929f) )
	sc_fnclb_others
ROM_END

ROM_START( sc5fnclbb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419608.lo", 0x00001, 0x080000, CRC(8a44e232) SHA1(570f972d0dab69b8c7ba0a880f5d334ae1eb7386) )
	ROM_LOAD16_BYTE( "95419609.hi", 0x00000, 0x080000, CRC(5afcf911) SHA1(e4846f7a3dedb5ed456b07eabe256d8515ca9ccd) )
	sc_fnclb_others
ROM_END

ROM_START( sc5fnclbc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419632.lo", 0x00001, 0x080000, CRC(9fea4c77) SHA1(c5c179fa398ca53977f231cb9f69bc4ca0e54f19) )
	ROM_LOAD16_BYTE( "95419633.hi", 0x00000, 0x080000, CRC(a2f69a29) SHA1(923b3ccc3dd7a6ea16484fc0230aaff3e7571cfa) )
	sc_fnclb_others
ROM_END

ROM_START( sc5fnclbd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3061p32.hi", 0x00000, 0x080000, CRC(a48c1c47) SHA1(c417a0515c04889014677928e932e9ad5cf690cc) )
	ROM_LOAD16_BYTE( "p3061p32.lo", 0x00001, 0x080000, CRC(822394b4) SHA1(c10a6542cf33cdb89784ae40c818902e61c6a36c) )
	sc_fnclb_others
ROM_END

ROM_START( sc5fnclbe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3061s32.hi", 0x00000, 0x080000, CRC(74585398) SHA1(7140755dda8444e5da4b14bdfbf00dffaba3cc72) )
	ROM_LOAD16_BYTE( "p3061s32.lo", 0x00001, 0x080000, CRC(c11d0eac) SHA1(d421d9290ca01a6a50d5c495b7ea1cf4452302e5) )
	sc_fnclb_others
ROM_END




ROM_START( sc5fdice )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1919p41.hi", 0x00000, 0x080000, CRC(bb7e7a30) SHA1(4597dd56822107c87511aeff05c1491eb9f47e0a) )
	ROM_LOAD16_BYTE( "p1919p41.lo", 0x00001, 0x080000, CRC(2b8d35c3) SHA1(fb7c90c3b7609e83f7222efcdea221a65b41a715) )
	sc_fdice_others
ROM_END

ROM_START( sc5fdicea )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1919s41.hi", 0x00000, 0x080000, CRC(1b765fd4) SHA1(c607f3d6459962d4c6003538a0e888ed200efea6) )
	ROM_LOAD16_BYTE( "p1919s41.lo", 0x00001, 0x080000, CRC(70dbb9b8) SHA1(ee5729806a381e6d025ccb521b96ee97adce5d05) )
	sc_fdice_others
ROM_END




ROM_START( sc5fires )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412418.lo", 0x00001, 0x080000, CRC(0f071b4a) SHA1(ec71255493abfb948d6188cf2cb49db8206dfe60) )
	ROM_LOAD16_BYTE( "95412419.hi", 0x00000, 0x080000, CRC(8475ba03) SHA1(f9a04208e47075ec5e693c9582944952b9a7bfdf) )
	sc_fires_others
ROM_END

ROM_START( sc5firesa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412420.lo", 0x00001, 0x080000, CRC(914100b4) SHA1(8d49cedfb769dbf4cd17dfa945402e26c1a3748d) )
	ROM_LOAD16_BYTE( "95412421.hi", 0x00000, 0x080000, CRC(032814fe) SHA1(10ee04f42b65a5b352539f5747c1ee1c2ca4a464) )
	sc_fires_others
ROM_END

ROM_START( sc5firesb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413418.lo", 0x00001, 0x080000, CRC(9f921678) SHA1(0592fd70066d042b09aeb253c2dbb9c87fb3cb99) )
	ROM_LOAD16_BYTE( "95413419.hi", 0x00000, 0x080000, CRC(b3dbd057) SHA1(df81a5eb47fc30747956a3484db761d723e037d1) )
	sc_fires_others
ROM_END

ROM_START( sc5firesc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413420.lo", 0x00001, 0x080000, CRC(01d40d86) SHA1(99cea49ec881613e6d321e924c705cb88a513404) )
	ROM_LOAD16_BYTE( "95413421.hi", 0x00000, 0x080000, CRC(34867eaa) SHA1(677dd05792fbfa73dc4a1fdad1394ab1e4cc6c2b) )
	sc_fires_others
ROM_END




ROM_START( sc5ftcas )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424426.lo", 0x00001, 0x080000, CRC(7984a6f1) SHA1(a52dd24af6da84ecd16da5c690e9e9a680624cc1) )
	ROM_LOAD16_BYTE( "95424427.hi", 0x00000, 0x080000, CRC(f5fbc8b3) SHA1(23ba3f5ffa17acddb3f4a5ce7750e1981c98b780) )
	sc_ftcas_others
ROM_END

ROM_START( sc5ftcasa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425426.lo", 0x00001, 0x080000, CRC(b650c635) SHA1(fed9ce19c70d0eb3ba8d0a6f4890c746b68cb1d5) )
	ROM_LOAD16_BYTE( "95425427.hi", 0x00000, 0x080000, CRC(2cb9dc4a) SHA1(be18cae57dce0ed199d7bbcf5a4e864349496e02) )
	sc_ftcas_others
ROM_END




ROM_START( sc5floop )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420190.lo", 0x00001, 0x080000, CRC(cec33026) SHA1(71f90edaa513268f3b48053e8ebdb22dc94840ac) )
	ROM_LOAD16_BYTE( "95420191.hi", 0x00000, 0x080000, CRC(c940d6e0) SHA1(5b60d562f66ce4873b26ce6fe00bb11638d0b29a) )
	sc_floop_others
ROM_END

ROM_START( sc5floopa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421190.lo", 0x00001, 0x080000, CRC(2f269a07) SHA1(ee30a00dbc66da8f36044f3ed3498f6fb713047c) )
	ROM_LOAD16_BYTE( "95421191.hi", 0x00000, 0x080000, CRC(3d7cba6a) SHA1(5c20dc1cf6ec1701c2caa1c0dc5ee835344be34d) )
	sc_floop_others
ROM_END




ROM_START( sc5grq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1404p12.hi", 0x00000, 0x080000, CRC(955a6dd0) SHA1(ae846239497562ded1949c810358bfe6114cf949) )
	ROM_LOAD16_BYTE( "p1404p12.lo", 0x00001, 0x080000, CRC(cbb39e3e) SHA1(81b15e03438d1ec5f06cbfe78ad5e94e6dd172d9) )
	sc_grq_others
ROM_END

ROM_START( sc5grqa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1404p13.hi", 0x00000, 0x080000, CRC(e7f5dfb6) SHA1(a37c862f55108022c2e9c20dd2ab34c16696a9a4) )
	ROM_LOAD16_BYTE( "p1404p13.lo", 0x00001, 0x080000, CRC(81093039) SHA1(90b865ae1ccf34bbdd1d98b7a4001591e8745112) )
	sc_grq_others
ROM_END

ROM_START( sc5grqb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1404s12.hi", 0x00000, 0x080000, CRC(464e2427) SHA1(bc98a4fa31be0217c57af68cdc7bc1dcba5ae78c) )
	ROM_LOAD16_BYTE( "p1404s12.lo", 0x00001, 0x080000, CRC(47165998) SHA1(e29bb219a423ea76de85aa83c78515a26a701258) )
	sc_grq_others
ROM_END

ROM_START( sc5grqc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1404s13.hi", 0x00000, 0x080000, CRC(244123f8) SHA1(36efd4a0a66324827f6414963e1c7393c50a28b7) )
	ROM_LOAD16_BYTE( "p1404s13.lo", 0x00001, 0x080000, CRC(87b48e68) SHA1(5f1a90a39a725ae373c376e81c773f0b1346b230) )
	sc_grq_others
ROM_END




ROM_START( sc5gldfv )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408450.lo", 0x00001, 0x080000, CRC(23a30f94) SHA1(55f7ddc53f1dd3e6bee58c077c80cb1af42cc218) )
	ROM_LOAD16_BYTE( "95408451.hi", 0x00000, 0x080000, CRC(814bddaa) SHA1(468586c76c6fadb5fe819caee11ea21730253238) )
	sc_gldfv_others
ROM_END

ROM_START( sc5gldfva )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408452.lo", 0x00001, 0x080000, CRC(a3171618) SHA1(ba5fa5eed6ccd73fa6867ff1dc08c01f9213f296) )
	ROM_LOAD16_BYTE( "95408453.hi", 0x00000, 0x080000, CRC(d4624de3) SHA1(08d9d0510cabb666adf55a8cb0ab43758b9226d0) )
	sc_gldfv_others
ROM_END

ROM_START( sc5gldfvb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409450.lo", 0x00001, 0x080000, CRC(d793ed74) SHA1(939202d3ccd0a01e028acc47bf160160c094a352) )
	ROM_LOAD16_BYTE( "95409451.hi", 0x00000, 0x080000, CRC(7f8ee045) SHA1(e40ad207cb9c21fcf328a31f9be3ebf1ee3f805c) )
	sc_gldfv_others
ROM_END

ROM_START( sc5gldfvc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409452.lo", 0x00001, 0x080000, CRC(5727f4f8) SHA1(500605b84c2fe3f716c8d11e26d6983af8ce356c) )
	ROM_LOAD16_BYTE( "95409453.hi", 0x00000, 0x080000, CRC(2aa7700c) SHA1(a6127052dae9ede28965a1d120096e18f234d3f3) )
	sc_gldfv_others
ROM_END

ROM_START( sc5gldfvd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1403p11.hi", 0x00000, 0x080000, CRC(c9b6dfe2) SHA1(0de51adba368ca911b6efdc1864bcb7e85247f67) )
	ROM_LOAD16_BYTE( "p1403p11.lo", 0x00001, 0x080000, CRC(d1f31d6d) SHA1(53cf1a9ac3c6179734431aeb9862da5b8543dede) )
	sc_gldfv_others
ROM_END

ROM_START( sc5gldfve )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1403p12.hi", 0x00000, 0x080000, CRC(29b634d9) SHA1(418210848f28fb3374ceba58ff331c0ebabc3cc1) )
	ROM_LOAD16_BYTE( "p1403p12.lo", 0x00001, 0x080000, CRC(c132ca11) SHA1(9ade9400ad8af0efbd280624c9dc41f933e96a56) )
	sc_gldfv_others
ROM_END

ROM_START( sc5gldfvf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1403s11.hi", 0x00000, 0x080000, CRC(bb3e472e) SHA1(bde554659ebbbea026b18a99b033896d80daa825) )
	ROM_LOAD16_BYTE( "p1403s11.lo", 0x00001, 0x080000, CRC(1a6b920b) SHA1(cbd6057cf2ff69f5fe36df5095407e6d53c5ad89) )
	sc_gldfv_others
ROM_END

ROM_START( sc5gldfvg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1403s12.hi", 0x00000, 0x080000, CRC(a8595220) SHA1(d3a0dc2793fc92cf2283c2b46a0032e1ea663b09) )
	ROM_LOAD16_BYTE( "p1403s12.lo", 0x00001, 0x080000, CRC(68cbe6cf) SHA1(d80a015f0f5de84acd853c80214b32d83f67cee3) )
	sc_gldfv_others
ROM_END



ROM_START( sc5gldgo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3410p71.hi", 0x00000, 0x080000, CRC(9a7d12fc) SHA1(8a5287d81b8a1faaa947d7f58feccafb6d0e433a) )
	ROM_LOAD16_BYTE( "p3410p71.lo", 0x00001, 0x080000, CRC(567ecb06) SHA1(2cc0407de76103beb137ff59e169a9a99584fad3) )
	sc_gldgo_others
ROM_END

ROM_START( sc5gldgoa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3410s71.hi", 0x00000, 0x080000, CRC(3da6027d) SHA1(d328263459de864e11bc41e3b51bb30c0b6fb9bf) )
	ROM_LOAD16_BYTE( "p3410s71.lo", 0x00001, 0x080000, CRC(51bf1ea1) SHA1(18f584f1e40a54e186452e08975c4c111ab7be8d) )
	sc_gldgo_others
ROM_END




ROM_START( sc5gldsp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416274.lo", 0x00001, 0x080000, CRC(e2a5590d) SHA1(5976206019bd685594d3bf79fb76bf184857faeb) )
	ROM_LOAD16_BYTE( "95416275.hi", 0x00000, 0x080000, CRC(a4d95994) SHA1(93a30575469ab4b5d5543352f937176c32a9ee2e) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldspa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416276.lo", 0x00001, 0x080000, CRC(8479c324) SHA1(da8ed080dc5a41caabfd867cb3f4f72d94b14f6c) )
	ROM_LOAD16_BYTE( "95416277.hi", 0x00000, 0x080000, CRC(53bb63b4) SHA1(3751339ea3a5385a25dba4cb76cd726eebc97384) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldspb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416478.lo", 0x00001, 0x080000, CRC(a375a742) SHA1(eceeb012bfbd187ad970e8509c99bc67748a755b) )
	ROM_LOAD16_BYTE( "95416479.hi", 0x00000, 0x080000, CRC(ec268d6d) SHA1(101a95d2e50bb33f5ce50ee31377524ec9b39695) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldspc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416496.lo", 0x00001, 0x080000, CRC(da9e23b8) SHA1(da4accb7dbf71dd20ae77843a944741876c6b54f) )
	ROM_LOAD16_BYTE( "95416497.hi", 0x00000, 0x080000, CRC(90517dcb) SHA1(38fd51b810ccec84747a2526d5236b548a16ae39) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldspd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416498.lo", 0x00001, 0x080000, CRC(4a4f972d) SHA1(8108f9e005ee18339b28ac92601446c4fb8a0ffa) )
	ROM_LOAD16_BYTE( "95416499.hi", 0x00000, 0x080000, CRC(0042bda8) SHA1(a32f3f97d5045fe7321ecc50a821b0e5cfd48eff) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldspe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416510.lo", 0x00001, 0x080000, CRC(a161e0c3) SHA1(92e5c9b642ac2c04110fd512dcd3879cf3b0e4d3) )
	ROM_LOAD16_BYTE( "95416511.hi", 0x00000, 0x080000, CRC(fc4c4f24) SHA1(7328789b96135182f138b1aff4d8a38644506c9d) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldspf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416512.lo", 0x00001, 0x080000, CRC(10d64ab1) SHA1(a6986d83b987f19481cb6703422b4f61e54f732f) )
	ROM_LOAD16_BYTE( "95416513.hi", 0x00000, 0x080000, CRC(ffdc3694) SHA1(e2fc677f1a26a1e2b72900f947b1292beb69ceb7) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldspg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416598.lo", 0x00001, 0x080000, CRC(155af599) SHA1(ad0d43b2e971d9a2335ec53bfee7aa38b763b7da) )
	ROM_LOAD16_BYTE( "95416599.hi", 0x00000, 0x080000, CRC(96e96989) SHA1(abb86f1b1ca48b10194b4136b02ee3c7a0159152) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldsph )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416600.lo", 0x00001, 0x080000, CRC(0aeacd49) SHA1(fddd947e1979c450ca8c8bd55a0e31415ac163e0) )
	ROM_LOAD16_BYTE( "95416601.hi", 0x00000, 0x080000, CRC(4984ba72) SHA1(4feb6eabb11001187bdcd2935a90ab361dca0bd5) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldspi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417178.lo", 0x00001, 0x080000, CRC(7a2848cc) SHA1(d33d2c4d3a122d9570a687c04a2877afd65d7b44) )
	ROM_LOAD16_BYTE( "95417179.hi", 0x00000, 0x080000, CRC(52d2c75d) SHA1(954127fa29b6280fec53c9b5dda243ce469752d4) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldspj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417276.lo", 0x00001, 0x080000, CRC(78f656c5) SHA1(24f17545896b9715b214c82f13ce17737b4e73c7) )
	ROM_LOAD16_BYTE( "95417277.hi", 0x00000, 0x080000, CRC(20c713be) SHA1(da71c4d462f3d5125a4bf27a889641d92ba33cc9) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldspk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417478.lo", 0x00001, 0x080000, CRC(5ffa32a3) SHA1(ab1cbe94f06cb05ae8014cd2a137a52a54a083bc) )
	ROM_LOAD16_BYTE( "95417479.hi", 0x00000, 0x080000, CRC(9f5afd67) SHA1(1b15c2846df5c919caaa860d762dd9081c8bcfd6) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldspl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417496.lo", 0x00001, 0x080000, CRC(964b9ddc) SHA1(b10a3dd9025f4019b340366b8a7d75f1980ced6c) )
	ROM_LOAD16_BYTE( "95417497.hi", 0x00000, 0x080000, CRC(53bb8e66) SHA1(9d2543867d12c929550535a2af38e6ede3c24a9b) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldspm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417510.lo", 0x00001, 0x080000, CRC(95a522dc) SHA1(0e19745ac65c4193c11c5e38fa7e9b4ceb27d4ef) )
	ROM_LOAD16_BYTE( "95417511.hi", 0x00000, 0x080000, CRC(7c83375f) SHA1(a676397b9015aedde0fe303ece1e3a681722bc2e) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldspn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417512.lo", 0x00001, 0x080000, CRC(c3fc2286) SHA1(4f0fd419315cf4454201c8cb1d453b569b4a99c6) )
	ROM_LOAD16_BYTE( "95417513.hi", 0x00000, 0x080000, CRC(666b2732) SHA1(1160c0c093043f06eadf177ead7dc28201b2da3d) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldspo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417598.lo", 0x00001, 0x080000, CRC(595b911f) SHA1(b78daf7133004da65f36c38f9490026478d8c088) )
	ROM_LOAD16_BYTE( "95417599.hi", 0x00000, 0x080000, CRC(4ab83460) SHA1(9a8400d7ca21162418bdf02a7388652ef7ef995e) )
	sc_gldsp_others
ROM_END

ROM_START( sc5gldspp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417600.lo", 0x00001, 0x080000, CRC(2930a2db) SHA1(e1b1992c4a4921fc10d8d35e9a67c40611ad2775) )
	ROM_LOAD16_BYTE( "95417601.hi", 0x00000, 0x080000, CRC(e3038952) SHA1(c4993167a3782fb09320b4498aefa823c4c50aff) )
	sc_gldsp_others
ROM_END




ROM_START( sc5gmclb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95426512.lo", 0x00001, 0x080000, CRC(f5e9e663) SHA1(45761b2c728a97f66cf9aac8fa7203cb34333588) )
	ROM_LOAD16_BYTE( "g95426513.hi", 0x00000, 0x080000, CRC(d54f139e) SHA1(0afe8d94556de6f885caffee0478acae33001790) )
	sc_gmclb_others
ROM_END

ROM_START( sc5gmclba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95426624.lo", 0x00001, 0x080000, CRC(c469ac6a) SHA1(1e2e2465a86910b574621a8a86cc41ec486847aa) )
	ROM_LOAD16_BYTE( "g95426625.hi", 0x00000, 0x080000, CRC(52ac982d) SHA1(d4c98a02ab9062fc59bbabe81294c105444e7b68) )
	sc_gmclb_others
ROM_END

ROM_START( sc5gmclbb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95427512.lo", 0x00001, 0x080000, CRC(642be142) SHA1(0d0791ee38503a7a02c4cc55b04e9ad17a24157b) )
	ROM_LOAD16_BYTE( "g95427513.hi", 0x00000, 0x080000, CRC(60f1f1b8) SHA1(19e7ea4b6f8f0600dca9727a417953252ac30fbe) )
	sc_gmclb_others
ROM_END

ROM_START( sc5gmclbc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95427624.lo", 0x00001, 0x080000, CRC(689fd215) SHA1(706359430fde0cbd8c945d441dc30e3fec4e24d9) )
	ROM_LOAD16_BYTE( "g95427625.hi", 0x00000, 0x080000, CRC(7df98b6c) SHA1(c7c7f9016d2d56decb6b3ec7a69a678652dcfd50) )
	sc_gmclb_others
ROM_END




ROM_START( sc5hirol )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416966.lo", 0x00001, 0x080000, CRC(419f71ee) SHA1(b2234a3d43861a6d1a1cb333253e856fd3391282) )
	ROM_LOAD16_BYTE( "95416967.hi", 0x00000, 0x080000, CRC(ef4c8100) SHA1(7db37ba1ec21dc48fe2514d55dbc19d547f00d16) )
	sc_hirol_others
ROM_END

ROM_START( sc5hirola )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417966.lo", 0x00001, 0x080000, CRC(86e10937) SHA1(f018062911b5ccd3fbe1776468a25d267fe1133c) )
	ROM_LOAD16_BYTE( "95417967.hi", 0x00000, 0x080000, CRC(5d340315) SHA1(010721948820e3f429b76e673e180668523b602b) )
	sc_hirol_others
ROM_END

ROM_START( sc5hirolb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420608.lo", 0x00001, 0x080000, CRC(0bdced16) SHA1(7421887db6f79314b52be10bb967f8ed6917c340) )
	ROM_LOAD16_BYTE( "95420609.hi", 0x00000, 0x080000, CRC(8ddfe3f9) SHA1(eba6467ea6c868b1b99f0a771d5be1d049f6f449) )
	sc_hirol_others
ROM_END

ROM_START( sc5hirolc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420742.lo", 0x00001, 0x080000, CRC(0bd1af11) SHA1(2d05b19dea9aa1b73a75b8e5b09bb694cb9f647f) )
	ROM_LOAD16_BYTE( "95420743.hi", 0x00000, 0x080000, CRC(84339062) SHA1(0ff89fc9b397051adcb46056cbcb33ec7d27fbc0) )
	sc_hirol_others
ROM_END

ROM_START( sc5hirold )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421608.lo", 0x00001, 0x080000, CRC(ea134ae9) SHA1(84b5274d62f724f7711734757ee562b7b4a07a60) )
	ROM_LOAD16_BYTE( "95421609.hi", 0x00000, 0x080000, CRC(990be37d) SHA1(edd18b2456628bc77b9f1e591ee17da42e51738a) )
	sc_hirol_others
ROM_END

ROM_START( sc5hirole )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421742.lo", 0x00001, 0x080000, CRC(70e329a7) SHA1(a6b85055849750dd821ca3755f7c8faa1208b42c) )
	ROM_LOAD16_BYTE( "95421743.hi", 0x00000, 0x080000, CRC(1b75a76a) SHA1(28da05855afc0a67966941dcb5e207fa74161e06) )
	sc_hirol_others
ROM_END




ROM_START( sc5hulk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408676.lo", 0x00001, 0x080000, CRC(81ce7644) SHA1(ccf48d494ac8d2ba94b9becbd9ac53d508e7d8aa) )
	ROM_LOAD16_BYTE( "95408677.hi", 0x00000, 0x080000, CRC(19d75bb8) SHA1(70d223d79ba1cc8a66650dd2df6e5c9ada283600) )
	sc_hulk_others
ROM_END

ROM_START( sc5hulka )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408678.lo", 0x00001, 0x080000, CRC(8ca8f9ff) SHA1(92b1c5479f53a7b0fbc390020b6702f969f55de3) )
	ROM_LOAD16_BYTE( "95408679.hi", 0x00000, 0x080000, CRC(50dc05a7) SHA1(e3439285eefd8ca05a5a5610b64f18d0361144e0) )
	sc_hulk_others
ROM_END

ROM_START( sc5hulkb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409676.lo", 0x00001, 0x080000, CRC(5299d009) SHA1(5836790581a3de5fd5ba3870bf91c64ee0720af4) )
	ROM_LOAD16_BYTE( "95409677.hi", 0x00000, 0x080000, CRC(fef3fa32) SHA1(f4223747190ac1bf9b738a3f637213e16fa0c3ee) )
	sc_hulk_others
ROM_END

ROM_START( sc5hulkc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409678.lo", 0x00001, 0x080000, CRC(88c7de44) SHA1(f59502eab3f0fff3ac12d6cf802d2a348390a036) )
	ROM_LOAD16_BYTE( "95409679.hi", 0x00000, 0x080000, CRC(68127cfa) SHA1(c5d016a3716c1e0876a62b2269f5763b2d59c27c) )
	sc_hulk_others
ROM_END

ROM_START( sc5hulkd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410538.lo", 0x00001, 0x080000, CRC(d18cdfd1) SHA1(99f71c1cee836fa528d2f15de666119f2a214d83) )
	ROM_LOAD16_BYTE( "95410539.hi", 0x00000, 0x080000, CRC(54adfa49) SHA1(ac5f680f97d26b31cb9c1f76f08d439def521cd4) )
	sc_hulk_others
ROM_END

ROM_START( sc5hulke )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410540.lo", 0x00001, 0x080000, CRC(6e31db7b) SHA1(aa8f28353934128142b0d8de92b282060d7ce78f) )
	ROM_LOAD16_BYTE( "95410541.hi", 0x00000, 0x080000, CRC(f2d7da51) SHA1(706bdb5fc6ecb58304892d309e6c59a2019b05b6) )
	sc_hulk_others
ROM_END

ROM_START( sc5hulkf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411538.lo", 0x00001, 0x080000, CRC(00a58cf4) SHA1(322f3f7cb4dc24aca201300ebe84c439c48e5393) )
	ROM_LOAD16_BYTE( "95411539.hi", 0x00000, 0x080000, CRC(d09bb505) SHA1(eb7f5c7e89a25ea44df2b04c84f193b82a8a135f) )
	sc_hulk_others
ROM_END

ROM_START( sc5hulkg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411540.lo", 0x00001, 0x080000, CRC(bf18885e) SHA1(371bb5ed75e9f7d0d85cca5860ce5ee409395277) )
	ROM_LOAD16_BYTE( "95411541.hi", 0x00000, 0x080000, CRC(76e1951d) SHA1(eef5ebbf647728786b92ababdadb91654a9bfd93) )
	sc_hulk_others
ROM_END

ROM_START( sc5hulkh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1405p12.hi", 0x00000, 0x080000, CRC(0ed57cdf) SHA1(6075eef121334801729839b5edf5723ca183214b) )
	ROM_LOAD16_BYTE( "p1405p12.lo", 0x00001, 0x080000, CRC(3fe9f6f9) SHA1(269944162a76b77249527d9384b5b86da7159b5f) )
	sc_hulk_others
ROM_END

ROM_START( sc5hulki )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1405s12.hi", 0x00000, 0x080000, CRC(020ef4e7) SHA1(ef2684275fcf5fd1bb7b77169965f803f19b5a73) )
	ROM_LOAD16_BYTE( "p1405s12.lo", 0x00001, 0x080000, CRC(cfd0d293) SHA1(719b06fb5e10eaf3f7a852c3fff6e403ea505241) )
	sc_hulk_others
ROM_END




ROM_START( sc5iab )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420322.lo", 0x00001, 0x080000, CRC(921741fa) SHA1(02d8b6974fe21726873381c9ce14503a3c029411) )
	ROM_LOAD16_BYTE( "95420323.hi", 0x00000, 0x080000, CRC(bc7d1388) SHA1(fedc3035cd5a43b0c878e2ca2bb320a4d23bd497) )
	sc_iab_others
ROM_END


ROM_START( sc5iaba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421322.lo", 0x00001, 0x080000, CRC(4b19cb34) SHA1(3c4127ca78cbc1b4d7bfda253b34c0a991bdca0f) )
	ROM_LOAD16_BYTE( "95421323.hi", 0x00000, 0x080000, CRC(26233a47) SHA1(6ccd7f05a7c24f638423b397d74372074061a2e2) )
	sc_iab_others
ROM_END




ROM_START( sc5ijbdo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424446.lo", 0x00001, 0x080000, CRC(49b4b792) SHA1(9ca4d6fb248b8c7fcc4cf1fe09cdafe5b6c0d41f) )
	ROM_LOAD16_BYTE( "95424447.hi", 0x00000, 0x080000, CRC(fd82fee7) SHA1(eba4ac00f22001d2c40cd426a3f34e03c6880ab1) )
	sc_ijbdo_others
ROM_END

ROM_START( sc5ijbdoa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424540.lo", 0x00001, 0x080000, CRC(d4f00854) SHA1(53c703e80264d288afc6437b8849cab746a65460) )
	ROM_LOAD16_BYTE( "95424541.hi", 0x00000, 0x080000, CRC(970dde6e) SHA1(f83e84a7179f363d946798e1b233e915faa64287) )
	sc_ijbdo_others
ROM_END

ROM_START( sc5ijbdob )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425446.lo", 0x00001, 0x080000, CRC(61b97ff3) SHA1(56a77ca7453df982d882849ecc2cfc335be1ba58) )
	ROM_LOAD16_BYTE( "95425447.hi", 0x00000, 0x080000, CRC(e4faf2fc) SHA1(ffb129ebb7211ed1116cf41ed49e1830eb5e17c9) )
	sc_ijbdo_others
ROM_END

ROM_START( sc5ijbdoc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425540.lo", 0x00001, 0x080000, CRC(70dd0ea8) SHA1(feece9475d421e02feb74ad2fa6e341e0dc3fe3c) )
	ROM_LOAD16_BYTE( "95425541.hi", 0x00000, 0x080000, CRC(f684cea2) SHA1(a53ed0d57fb6f7a90bcc66843b1351b15c47243e) )
	sc_ijbdo_others
ROM_END




ROM_START( sc5kingx )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416616.lo", 0x00001, 0x080000, CRC(dcd5b5fd) SHA1(b161f50030e71e5a57dadea3cf6980f57bbdcc27) )
	ROM_LOAD16_BYTE( "95416617.hi", 0x00000, 0x080000, CRC(fbe8024c) SHA1(7dd1741381f715d5bd6b3ee2626015033baf67bb) )
	sc_kingx_others
ROM_END

ROM_START( sc5kingxa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417616.lo", 0x00001, 0x080000, CRC(52cd059d) SHA1(4e15cfefcd37e02a5dd97b53fd687b5b0294d9ca) )
	ROM_LOAD16_BYTE( "95417617.hi", 0x00000, 0x080000, CRC(026afaf4) SHA1(902bcd07001788140a0b1b284c5b63bcc18d729b) )
	sc_kingx_others
ROM_END

ROM_START( sc5kingxb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420278.lo", 0x00001, 0x080000, CRC(b999edc6) SHA1(a3a228f93ec0fcdde6450877edb62208cc804608) )
	ROM_LOAD16_BYTE( "95420279.hi", 0x00000, 0x080000, CRC(a7853b5e) SHA1(483ca0e9df84703e17d38f5b0470ab9f88418f33) )
	sc_kingx_others
ROM_END

ROM_START( sc5kingxc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420280.lo", 0x00001, 0x080000, CRC(371f9cea) SHA1(24c7398daae3c3f63cba293e72dc5f17aaebf069) )
	ROM_LOAD16_BYTE( "95420281.hi", 0x00000, 0x080000, CRC(41a9ecff) SHA1(5874f0488007fe0514d749b2fa30d96804825c54) )
	sc_kingx_others
ROM_END

ROM_START( sc5kingxd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421278.lo", 0x00001, 0x080000, CRC(b109a07c) SHA1(529b34927afee94b38ca4bdb7baf63396f12dc1f) )
	ROM_LOAD16_BYTE( "95421279.hi", 0x00000, 0x080000, CRC(566cc152) SHA1(c2d90c35597732b566de5c7fdb2cb42889836485) )
	sc_kingx_others
ROM_END

ROM_START( sc5kingxe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421280.lo", 0x00001, 0x080000, CRC(573270d1) SHA1(cb4d14979144499455baf484e3d3e52a5bb9d3e2) )
	ROM_LOAD16_BYTE( "95421281.hi", 0x00000, 0x080000, CRC(ec960391) SHA1(5ac06e9db72da0b1817b034d9f7855e19a0992a6) )
	sc_kingx_others
ROM_END






ROM_START( sc5monky )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420550.lo", 0x00001, 0x080000, CRC(763c83de) SHA1(6a6e899536ed181ec8a87013760a3688f3f90281) )
	ROM_LOAD16_BYTE( "95420551.hi", 0x00000, 0x080000, CRC(c1e93f0c) SHA1(5e2d9a6440f996b1075f38850140c2d4fe64c18b) )
	sc_monky_others
ROM_END

ROM_START( sc5monkya )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421550.lo", 0x00001, 0x080000, CRC(7fb82da1) SHA1(c5667ec3c0c764dc2905f9588c0e5474da8405b6) )
	ROM_LOAD16_BYTE( "95421551.hi", 0x00000, 0x080000, CRC(fb6159c1) SHA1(2123db922c0b37e1863fd5ab196124d701b3bfe7) )
	sc_monky_others
ROM_END




ROM_START( sc5mobob )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426614.lo", 0x00001, 0x080000, CRC(338cfeb2) SHA1(16fbc219fba8b4667ba217167953301b4079731f) )
	ROM_LOAD16_BYTE( "95426615.hi", 0x00000, 0x080000, CRC(8b4b25f6) SHA1(bbaf7a977506f2d55a72b08f0c6fc854837552f8) )
	sc_mobob_others
ROM_END

ROM_START( sc5moboba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426630.lo", 0x00001, 0x080000, CRC(2614eff3) SHA1(74c3487dfa348d2f137100379f1ceb511570b91c) )
	ROM_LOAD16_BYTE( "95426631.hi", 0x00000, 0x080000, CRC(2e254ca7) SHA1(0722a7dc44d2839feff22ccff33f396fd1e5cba0) )
	sc_mobob_others
ROM_END

ROM_START( sc5mobobb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426658.lo", 0x00001, 0x080000, CRC(709e313b) SHA1(9730b4efd4da2ea978e49020a43f3554824c1a23) )
	ROM_LOAD16_BYTE( "95426659.hi", 0x00000, 0x080000, CRC(e0542cd2) SHA1(19730918c8ab3c5fe7a9d9fdcc4e3e491cd4046a) )
	sc_mobob_others
ROM_END

ROM_START( sc5mobobc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426812.lo", 0x00001, 0x080000, CRC(f140a579) SHA1(c0255ba637c0e5a67472c6dfa1e282078bcac92d) )
	ROM_LOAD16_BYTE( "95426813.hi", 0x00000, 0x080000, CRC(adfd1181) SHA1(013dc9ac8942170173099e51cb08290462033737) )
	sc_mobob_others
ROM_END

ROM_START( sc5mobobd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427614.lo", 0x00001, 0x080000, CRC(b090aa6c) SHA1(5cefb3e35d3e3ecff43e342f7e31de7c7c6eabf9) )
	ROM_LOAD16_BYTE( "95427615.hi", 0x00000, 0x080000, CRC(95348c58) SHA1(637fdbf6d4ebb48e754f40efa70caf0cd8367086) )
	sc_mobob_others
ROM_END

ROM_START( sc5mobobe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427630.lo", 0x00001, 0x080000, CRC(bd853224) SHA1(424836ac6dcf9cac1187361156717447f9f90fdd) )
	ROM_LOAD16_BYTE( "95427631.hi", 0x00000, 0x080000, CRC(25f09e39) SHA1(97a5f905715d63f595e1d5d95a805e33e6d54109) )
	sc_mobob_others
ROM_END

ROM_START( sc5mobobf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427658.lo", 0x00001, 0x080000, CRC(bd0d09ea) SHA1(ebe2b1ce28ef7ba6ec0dd99a92cbe3abbcf5b0ec) )
	ROM_LOAD16_BYTE( "95427659.hi", 0x00000, 0x080000, CRC(c1641c9e) SHA1(cc3f1e3a39ac88043216fd677c047201b7e1fb38) )
	sc_mobob_others
ROM_END

ROM_START( sc5mobobg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427812.lo", 0x00001, 0x080000, CRC(ad3df75c) SHA1(cd9988b2c9bd19b39efd3bf2dc5def3053094835) )
	ROM_LOAD16_BYTE( "95427813.hi", 0x00000, 0x080000, CRC(310e0cec) SHA1(533cfef424fa3e4f0182a308c826d7f35a314270) )
	sc_mobob_others
ROM_END

ROM_START( sc5mobobh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3307p71.hi", 0x00000, 0x080000, CRC(d234205a) SHA1(65d3bb4b1a3baa4eec9c89268c27b3f346bcb18e) )
	ROM_LOAD16_BYTE( "p3307p71.lo", 0x00001, 0x080000, CRC(7668f4f1) SHA1(82d78e8336fe409dd2ae3fe0637b9ba7116662a0) )
	sc_mobob_others
ROM_END

ROM_START( sc5mobobi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3307s71.hi", 0x00000, 0x080000, CRC(5a6be577) SHA1(ecae25998e9374b1b65a5f23aa7d7344eb5c3c2f) )
	ROM_LOAD16_BYTE( "p3307s71.lo", 0x00001, 0x080000, CRC(154694d5) SHA1(5f721cf84e78acccb41d41474796bc2ef49b363c) )
	sc_mobob_others
ROM_END




ROM_START( sc5mogta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3504s72.hi", 0x00000, 0x080000, CRC(684fe38d) SHA1(4fde491734acca1bd02e75f4cf2ae467ad6e62c0) )
	ROM_LOAD16_BYTE( "p3504s72.lo", 0x00001, 0x080000, CRC(2bbe91ad) SHA1(fbad244458d20dc95dc19d5fc19401adbdfd3f09) )
	sc_mogta_others
ROM_END

ROM_START( sc5mogtaa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3504p71.hi", 0x00000, 0x080000, CRC(ee41fba9) SHA1(3bb177a197155628aa356a4eb632e7e80d74c954) )
	ROM_LOAD16_BYTE( "p3504p71.lo", 0x00001, 0x080000, CRC(3d0681d4) SHA1(8e3b5ab249dd7d93ad6751ae31fbd5d89537e66e) )
	sc_mogta_others
ROM_END

ROM_START( sc5mogtab )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3504p72.hi", 0x00000, 0x080000, CRC(79828a85) SHA1(672e5b5c683746e4872d17ea61ff39e0ad591824) )
	ROM_LOAD16_BYTE( "p3504p72.lo", 0x00001, 0x080000, CRC(484ef5a4) SHA1(f8822470bbbc289e93a61622eeefa12e3ddb9fac) )
	sc_mogta_others
ROM_END

ROM_START( sc5mogtac )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3504s71.hi", 0x00000, 0x080000, CRC(3edc6b86) SHA1(d69294423623ab5fbd5c1889742bc5aa830cb8db) )
	ROM_LOAD16_BYTE( "p3504s71.lo", 0x00001, 0x080000, CRC(ec028348) SHA1(491461e59a7b5addd044ce48187e2c7e3c1e9b8d) )
	sc_mogta_others
ROM_END


ROM_START( sc5momil )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426544.lo", 0x00001, 0x080000, CRC(a6bbb93c) SHA1(57803fd6647ab5ff789c301e6d0079bb168eb0ca) )
	ROM_LOAD16_BYTE( "95426545.hi", 0x00000, 0x080000, CRC(c900531f) SHA1(e996e262c29e002420304fba903793b05bcfae75) )
	sc_momil_others
ROM_END

ROM_START( sc5momila )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426712.lo", 0x00001, 0x080000, CRC(32d5015a) SHA1(a2638aaa04abb4ec6d900af4b5a6423ec0309016) )
	ROM_LOAD16_BYTE( "95426713.hi", 0x00000, 0x080000, CRC(f2750c3f) SHA1(1383adb9940db84dbe9b607171599d26dba482b6) )
	sc_momil_others
ROM_END

ROM_START( sc5momilb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427544.lo", 0x00001, 0x080000, CRC(9d3de68b) SHA1(813e853ebe67d0a3459de1572faf8d7d6543958a) )
	ROM_LOAD16_BYTE( "95427545.hi", 0x00000, 0x080000, CRC(c8a608d8) SHA1(823fe352d7b2a50270e93f70b42faa0c634902cf) )
	sc_momil_others
ROM_END

ROM_START( sc5momilc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427712.lo", 0x00001, 0x080000, CRC(ba917e8e) SHA1(ab5f10cc4819fa7a10436cf53d19dfe22490fad3) )
	ROM_LOAD16_BYTE( "95427713.hi", 0x00000, 0x080000, CRC(4021322b) SHA1(27c9fe7133e594e901dd086c28e1346bb44d8208) )
	sc_momil_others
ROM_END

ROM_START( sc5momild )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3311p71.hi", 0x00000, 0x080000, CRC(06ed3a17) SHA1(ab7c625b03eb1c401d167a44ee6c35beef7e488d) )
	ROM_LOAD16_BYTE( "p3311p71.lo", 0x00001, 0x080000, CRC(2a7ef03f) SHA1(94c8fb7369a61ed69a95cef1904e194bcfe083c3) )
	sc_momil_others
ROM_END

ROM_START( sc5momile )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3311s71.hi", 0x00000, 0x080000, CRC(f3a892ce) SHA1(a97c20568bb65442e97ca6761aa0cd80d81f957e) )
	ROM_LOAD16_BYTE( "p3311s71.lo", 0x00001, 0x080000, CRC(e56d477a) SHA1(883d7749d2bd10e53743379eb8b2e0bac7d91098) )
	sc_momil_others
ROM_END




ROM_START( sc5mombc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418604.lo", 0x00001, 0x080000, CRC(07c5b10d) SHA1(950d9527bf7a981b36afddab5e6f24391cd55a06) )
	ROM_LOAD16_BYTE( "95418605.hi", 0x00000, 0x080000, CRC(7d64a83e) SHA1(56494f9ad62dd53c6b828a09cb5e5eee39be803f) )
	sc_mombc_others
ROM_END




ROM_START( sc5moms )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424616.lo", 0x00001, 0x080000, CRC(ae4363d4) SHA1(f1fa2832f1b2a65bcfa7640d0625e4f7f4708b7b) )
	ROM_LOAD16_BYTE( "95424617.hi", 0x00000, 0x080000, CRC(47e09bd9) SHA1(cea5735ee872a488aac73a3cb3718a06e3ab3cfb) )
	sc_moms_others
ROM_END

ROM_START( sc5momsa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424640.lo", 0x00001, 0x080000, CRC(3be74882) SHA1(8cffcdd874da49eebc766922b4b7118b79fe993e) )
	ROM_LOAD16_BYTE( "95424641.hi", 0x00000, 0x080000, CRC(bb291d3b) SHA1(7ae49b2fe2a028389ddd1054f6ee24ddfd5d922f) )
	sc_moms_others
ROM_END

ROM_START( sc5momsb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424642.lo", 0x00001, 0x080000, CRC(53d95c00) SHA1(1dedc0fd19c12b4f777b1ce5b09316e61c472e06) )
	ROM_LOAD16_BYTE( "95424643.hi", 0x00000, 0x080000, CRC(24572033) SHA1(6097cbf9de056b0d621696c0b872d8d787c5c329) )
	sc_moms_others
ROM_END

ROM_START( sc5momsc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425616.lo", 0x00001, 0x080000, CRC(63d60ce1) SHA1(b4b0af64672f79e7e002a4500cc6ccd4fd677eb7) )
	ROM_LOAD16_BYTE( "95425617.hi", 0x00000, 0x080000, CRC(a4a6129b) SHA1(338613573fc606a52bb7bd856806e28ca156e84f) )
	sc_moms_others
ROM_END

ROM_START( sc5momsd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425640.lo", 0x00001, 0x080000, CRC(a33c4242) SHA1(a5b1e7e6affe77895d6662f27690266e02becb3c) )
	ROM_LOAD16_BYTE( "95425641.hi", 0x00000, 0x080000, CRC(4f1772a4) SHA1(acaf47b3e896cf4e624f7dc7df65c10220227e1a) )
	sc_moms_others
ROM_END

ROM_START( sc5momse )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425642.lo", 0x00001, 0x080000, CRC(e5158548) SHA1(d120a09553b5d7df1b140139f4d4f999f7e773b5) )
	ROM_LOAD16_BYTE( "95425643.hi", 0x00000, 0x080000, CRC(1f307939) SHA1(b091d3cc55235aa3389d0b3fdc0ca5fa78d13285) )
	sc_moms_others
ROM_END



ROM_START( sc5mopl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3408p71.hi", 0x00000, 0x080000, CRC(cf33ba2b) SHA1(be9cfb797f3d6983e26be362f108dbefff8b6cf2) )
	ROM_LOAD16_BYTE( "p3408p71.lo", 0x00001, 0x080000, CRC(022074a5) SHA1(88d67b1294621feb1e79461fd0f20c8c6b14e547) )
	sc_mopl_others
ROM_END

ROM_START( sc5mopla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3408p72.hi", 0x00000, 0x080000, CRC(9d8b4f48) SHA1(78eed5283d20fd58f58d773ffc5bf4c709034bd0) )
	ROM_LOAD16_BYTE( "p3408p72.lo", 0x00001, 0x080000, CRC(7f318753) SHA1(99f37daee34a5b69b0245b63425012f2c991f415) )
	sc_mopl_others
ROM_END

ROM_START( sc5moplb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3408s71.hi", 0x00000, 0x080000, CRC(b630cc98) SHA1(b03b222afc4657b22f5ff0ae7c054de799d642ff) )
	ROM_LOAD16_BYTE( "p3408s71.lo", 0x00001, 0x080000, CRC(9ec19fc1) SHA1(17f90b4b8077c69c0c549b4c7a07e9eb8209200a) )
	sc_mopl_others
ROM_END

ROM_START( sc5moplc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3408s72.hi", 0x00000, 0x080000, CRC(1e0bc7d6) SHA1(9b999e9be6ecc6b1557ea755928af421046776c4) )
	ROM_LOAD16_BYTE( "p3408s72.lo", 0x00001, 0x080000, CRC(bc529040) SHA1(7262ca69f8fb1e7301d6af73eb44518dedfdb59b) )
	sc_mopl_others
ROM_END




ROM_START( sc5mor2r )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424484.lo", 0x00001, 0x080000, CRC(9e1253c8) SHA1(5d3387e21bb22e68babe2ba5ee5cd0087d9d3af7) )
	ROM_LOAD16_BYTE( "95424485.hi", 0x00000, 0x080000, CRC(535b57dc) SHA1(a505731f4fd541501da192f6df6dee1548855416) )
	sc_mor2r_others
ROM_END

ROM_START( sc5mor2ra )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425484.lo", 0x00001, 0x080000, CRC(443db88e) SHA1(d3e7702c7d588e0862c68afbc0d3ac8284b9ccbb) )
	ROM_LOAD16_BYTE( "95425485.hi", 0x00000, 0x080000, CRC(66220c17) SHA1(ffb645b0c2ecedf2a328fd3b1a1f95b538d359e1) )
	sc_mor2r_others
ROM_END




ROM_START( sc5monwa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424588.lo", 0x00001, 0x080000, CRC(55a1a299) SHA1(483d0fcaf17acc5e6911acd1410f660fddbb8f70) )
	ROM_LOAD16_BYTE( "95424589.hi", 0x00000, 0x080000, CRC(409a7d42) SHA1(599affd706d261f2d3cafd52a3701407d47dde7b) )
	sc_monwa_others
ROM_END

ROM_START( sc5monwaa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425588.lo", 0x00001, 0x080000, CRC(6f7f5a26) SHA1(8fa14415d94089d7cc1d0dc0bd20d7e766c9ec5b) )
	ROM_LOAD16_BYTE( "95425589.hi", 0x00000, 0x080000, CRC(3ebe5f6a) SHA1(e4fdd750d81e06a6cd064980d0dac840013bad4f) )
	sc_monwa_others
ROM_END




ROM_START( sc5cmcob )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424608.lo", 0x00001, 0x080000, CRC(277b6ac5) SHA1(834a18b67728774aece6595cc57fb00917f826d8) )
	ROM_LOAD16_BYTE( "95424609.hi", 0x00000, 0x080000, CRC(f4ef6f33) SHA1(4b70c86845f8761784e3703e608ff081968bb632) )
	sc_cmcob_others
ROM_END

ROM_START( sc5cmcoba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424610.lo", 0x00001, 0x080000, CRC(41fa3ebf) SHA1(2386f28741feb2c11edba5a34199ec926e63010d) )
	ROM_LOAD16_BYTE( "95424611.hi", 0x00000, 0x080000, CRC(c9a25750) SHA1(ad0c6f534b59b593a3a7ae9389d0f57f7147b7d7) )
	sc_cmcob_others
ROM_END

ROM_START( sc5cmcobb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425608.lo", 0x00001, 0x080000, CRC(26093186) SHA1(cb8343804cb5bc932dfb6f256bc80e07fabc7dd7) )
	ROM_LOAD16_BYTE( "95425609.hi", 0x00000, 0x080000, CRC(57ea57fd) SHA1(a5dae0e11f0aaa170a8e288116fe8f5440cad5af) )
	sc_cmcob_others
ROM_END

ROM_START( sc5cmcobc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425610.lo", 0x00001, 0x080000, CRC(fa6d1e11) SHA1(85449a56c05c6a14dab609a9cc3ebea5f4c2d614) )
	ROM_LOAD16_BYTE( "95425611.hi", 0x00000, 0x080000, CRC(00a16611) SHA1(8b7eb5ad71e6ab76f1ed0f6fc82dbbad76455052) )
	sc_cmcob_others
ROM_END




ROM_START( sc5nunsb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420446.lo", 0x00001, 0x080000, CRC(27a45977) SHA1(1e15a814fc99f4d749929f569b61f1e241cf8f91) )
	ROM_LOAD16_BYTE( "95420447.hi", 0x00000, 0x080000, CRC(b8a8fb4f) SHA1(e7792a60355f3b5ebb03b71ea1009b982ba4fab5) )
	sc_nunsb_others
ROM_END


ROM_START( sc5rainb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3315p71.hi", 0x00000, 0x080000, CRC(3afa32d9) SHA1(8e3005715388fceb3c1deba02d78433ddd838f0f) )
	ROM_LOAD16_BYTE( "p3315p71.lo", 0x00001, 0x080000, CRC(67d8604e) SHA1(ecdb9e296a3daf89c2309ca9544f4f0bb845b710) )
	sc_rainb_others
ROM_END

ROM_START( sc5rainba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3315p72.hi", 0x00000, 0x080000, CRC(29bed5f5) SHA1(e33cc0dd671c2dd14ac7ed639c9b4cb71b8a1906) )
	ROM_LOAD16_BYTE( "p3315p72.lo", 0x00001, 0x080000, CRC(81b3d9b0) SHA1(fde847ea6c27ce823cc04c90889a1bfa62a21e5e) )
	sc_rainb_others
ROM_END

ROM_START( sc5rainbb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3315p73.hi", 0x00000, 0x080000, CRC(f8a3f3aa) SHA1(7ef80e13ad44b01cede0d5ff347ae041a8b90db2) )
	ROM_LOAD16_BYTE( "p3315p73.lo", 0x00001, 0x080000, CRC(66e9ca49) SHA1(413c9035b9bc59c915c54ce976d78d8ccac95a39) )
	sc_rainb_others
ROM_END

ROM_START( sc5rainbc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3315s71.hi", 0x00000, 0x080000, CRC(19bc7f67) SHA1(905640b12821cfb2d367f33e1878660b1368b275) )
	ROM_LOAD16_BYTE( "p3315s71.lo", 0x00001, 0x080000, CRC(f1dd2f9e) SHA1(5b75afdcdefbd29380d320980a1cf48bb8aa3a01) )
	sc_rainb_others
ROM_END

ROM_START( sc5rainbd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3315s72.hi", 0x00000, 0x080000, CRC(9162a00e) SHA1(79965056fbb9be15a3c7cd6eaac578d41ce84d2e) )
	ROM_LOAD16_BYTE( "p3315s72.lo", 0x00001, 0x080000, CRC(ee57ffd7) SHA1(85ee352f6d116abb6cbb41c790599b2d3a0d6563) )
	sc_rainb_others
ROM_END

ROM_START( sc5rainbe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3315s73.hi", 0x00000, 0x080000, CRC(3c4d9c5d) SHA1(c71792e08a5b5acad008d7119e0f889e04ee3a2f) )
	ROM_LOAD16_BYTE( "p3315s73.lo", 0x00001, 0x080000, CRC(5e8937b6) SHA1(8f2f315dff57b35643f6d62b7ae9a106f1dbc0ca) )
	sc_rainb_others
ROM_END




ROM_START( sc5parot )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3015p71.hi", 0x00000, 0x080000, CRC(6ab7bcd2) SHA1(7ee059789b5641f6a8da47a0e29ef15a1beecd8b) )
	ROM_LOAD16_BYTE( "p3015p71.lo", 0x00001, 0x080000, CRC(d62a090c) SHA1(a9bb1fd33fd08c525998c9c0153c8078c776a079) )
	sc_parot_others
ROM_END

ROM_START( sc5parota )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3015p72.hi", 0x00000, 0x080000, CRC(a1e66876) SHA1(ec055df597b12af05d1fbb84e1c1876219e514be) )
	ROM_LOAD16_BYTE( "p3015p72.lo", 0x00001, 0x080000, CRC(aca9f8c5) SHA1(036c9ac8cead65ccb1703b6f8645d7beb4de6cff) )
	sc_parot_others
ROM_END

ROM_START( sc5parotb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3015p73.hi", 0x00000, 0x080000, CRC(375f895f) SHA1(799bd79e96ec9c06ba5724692b4d216cc2d02a02) )
	ROM_LOAD16_BYTE( "p3015p73.lo", 0x00001, 0x080000, CRC(61b727dc) SHA1(ba79d7c2654d56e7031e18397171a72663581820) )
	sc_parot_others
ROM_END

ROM_START( sc5parotc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3015p74.hi", 0x00000, 0x080000, CRC(59d0b3c1) SHA1(e730d43a9640e8aceb0938c90ba5748eaba2e8b0) )
	ROM_LOAD16_BYTE( "p3015p74.lo", 0x00001, 0x080000, CRC(8e03fbc2) SHA1(6ad244ca0c92fb526e3280b105085f080c7613bf) )
	sc_parot_others
ROM_END

ROM_START( sc5parotd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3015s71.hi", 0x00000, 0x080000, CRC(10b8b141) SHA1(a2ba6e19bc888978d4b147e1c477834e9c56380c) )
	ROM_LOAD16_BYTE( "p3015s71.lo", 0x00001, 0x080000, CRC(9fed58a3) SHA1(439b0cd9cb2ee676c826c5f33f31f26284560dc0) )
	sc_parot_others
ROM_END

ROM_START( sc5parote )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3015s72.hi", 0x00000, 0x080000, CRC(68474982) SHA1(75b31cc8e17d69e68443b4507be009c76960dead) )
	ROM_LOAD16_BYTE( "p3015s72.lo", 0x00001, 0x080000, CRC(9de37289) SHA1(c5253437707dce1cfe0b785d6340dcda006875cc) )
	sc_parot_others
ROM_END

ROM_START( sc5parotf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3015s73.hi", 0x00000, 0x080000, CRC(27695902) SHA1(f2793cbc14e742e1fa15c9dc0ab773b7d2689f57) )
	ROM_LOAD16_BYTE( "p3015s73.lo", 0x00001, 0x080000, CRC(d5a5a816) SHA1(43027cf4d341b63f345aac19b8c60258142349dd) )
	sc_parot_others
ROM_END

ROM_START( sc5parotg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3015s74.hi", 0x00000, 0x080000, CRC(1ac7be89) SHA1(e0e7d49b833438f5f168d8a600da0946c29890db) )
	ROM_LOAD16_BYTE( "p3015s74.lo", 0x00001, 0x080000, CRC(81e4fede) SHA1(2643ac419a55950d8e909888b0c856a00ecdebda) )
	sc_parot_others
ROM_END



ROM_START( sc5pilep )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424364.lo", 0x00001, 0x080000, CRC(ad9e0f59) SHA1(1d91f49b5de6a5982f1977b9fa28487b1ceaac43) )
	ROM_LOAD16_BYTE( "95424365.hi", 0x00000, 0x080000, CRC(d5bdf417) SHA1(5995cdc20678c2acec855f6281bd949c5236446d) )
	sc_pilep_others
ROM_END

ROM_START( sc5pilepa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424384.lo", 0x00001, 0x080000, CRC(abe8bb2b) SHA1(442574ec1fe73f7e24a76af349d5de5ec785e568) )
	ROM_LOAD16_BYTE( "95424385.hi", 0x00000, 0x080000, CRC(46ae0592) SHA1(9a896a1acca28cd5e877165ab96d485ed1953e7f) )
	sc_pilep_others
ROM_END

ROM_START( sc5pilepb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425364.lo", 0x00001, 0x080000, CRC(d6c32f2b) SHA1(ef5e77b543d8a61ac231902e121634bfcb46df94) )
	ROM_LOAD16_BYTE( "95425365.hi", 0x00000, 0x080000, CRC(b33b86ed) SHA1(5efa3e4ed34cbfe85b38d7b4c90221b11a719304) )
	sc_pilep_others
ROM_END

ROM_START( sc5pilepc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425384.lo", 0x00001, 0x080000, CRC(92db0e3f) SHA1(7c61beb88f615042a94fa993df6bbce4ed11db9b) )
	ROM_LOAD16_BYTE( "95425385.hi", 0x00000, 0x080000, CRC(49b9b0fe) SHA1(5adf034e4baac642d7b4f2c1fb385895ee37a185) )
	sc_pilep_others
ROM_END



ROM_START( sc5potsm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420312.lo", 0x00001, 0x080000, CRC(b33457b9) SHA1(0815848437e222348b306179401434b4769af857) )
	ROM_LOAD16_BYTE( "95420313.hi", 0x00000, 0x080000, CRC(522510fc) SHA1(778ca15b46d04bf1a0f378b554e21855a1ceaabe) )
	sc_potsm_others
ROM_END

ROM_START( sc5potsma )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421312.lo", 0x00001, 0x080000, CRC(f86d79c8) SHA1(028a9b97480e34148ceecad948dda1c21a242a8a) )
	ROM_LOAD16_BYTE( "95421313.hi", 0x00000, 0x080000, CRC(10329d84) SHA1(b0e5b34bc1b5f1a5a5462d29ef8bcb71791b737e) )
	sc_potsm_others
ROM_END




ROM_START( sc5cpen1 )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427906.lo", 0x00001, 0x080000, CRC(05e73940) SHA1(5adc5f705f444f25af450d89f8cf02c4855fe3d0) )
	ROM_LOAD16_BYTE( "95427907.hi", 0x00000, 0x080000, CRC(2b5a0958) SHA1(2aafb88fc8ef5d559926cd91d6ef50cb438646a5) )
	sc_cpen1_others
ROM_END

ROM_START( sc5cpen1a )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426906.lo", 0x00001, 0x080000, CRC(17d2a36d) SHA1(44216b05445c7b9d4298411806487168f0325668) )
	ROM_LOAD16_BYTE( "95426907.hi", 0x00000, 0x080000, CRC(2c26de1b) SHA1(3307980fca15ee2ad8756fd294d2da5bbbf3e7ae) )
	sc_cpen1_others
ROM_END




ROM_START( sc5qual )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408562.lo", 0x00001, 0x080000, CRC(511eca10) SHA1(233cd773eb2dcf4e73399b734ed69d2696eb5c85) )
	ROM_LOAD16_BYTE( "95408563.hi", 0x00000, 0x080000, CRC(12424475) SHA1(48dd42f82b399ec5eb135b7e992ec23204c82fc5) )
	sc_qual_others
ROM_END

ROM_START( sc5quala )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409562.lo", 0x00001, 0x080000, CRC(fce0df75) SHA1(41829416ebfc2d0abcf253bedd7b7034eb37ebeb) )
	ROM_LOAD16_BYTE( "95409563.hi", 0x00000, 0x080000, CRC(45e450b3) SHA1(e92daad5e0dee68b52b7689c90c10acb5165cbc5) )
	sc_qual_others
ROM_END

ROM_START( sc5qualb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410402.lo", 0x00001, 0x080000, CRC(c2fcfab1) SHA1(b063655aa025513e147928f2bb785a306069fd41) )
	ROM_LOAD16_BYTE( "95410403.hi", 0x00000, 0x080000, CRC(11653865) SHA1(9853ffd6106bec26e36cfd2ee2c9afe7f1a8c204) )
	sc_qual_others
ROM_END

ROM_START( sc5qualc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410404.lo", 0x00001, 0x080000, CRC(9b793a14) SHA1(ea8f6422bdac48c57b17c3037a0b21d48311e140) )
	ROM_LOAD16_BYTE( "95410405.hi", 0x00000, 0x080000, CRC(97aee36e) SHA1(ae3dd0fc48629de411533a59f4a29e53cf4e9c76) )
	sc_qual_others
ROM_END

ROM_START( sc5quald )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410542.lo", 0x00001, 0x080000, CRC(4e9c6cfa) SHA1(f7113cf271a8776094c7ea1a73e784f9e9023452) )
	ROM_LOAD16_BYTE( "95410543.hi", 0x00000, 0x080000, CRC(9783ea6f) SHA1(a33b169b29f10bbe315b222b0391c0acc74700d6) )
	sc_qual_others
ROM_END

ROM_START( sc5quale )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411402.lo", 0x00001, 0x080000, CRC(99fa28c9) SHA1(9b12ce7d01730dce22f2a5614dd7dfcd56618f87) )
	ROM_LOAD16_BYTE( "95411403.hi", 0x00000, 0x080000, CRC(37b6c0be) SHA1(b71b49386feb49dca2608285dd7618b5dc2a82a9) )
	sc_qual_others
ROM_END

ROM_START( sc5qualf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411404.lo", 0x00001, 0x080000, CRC(8891df54) SHA1(87c4ee731db042516a54acfa1f219d99ec0d01db) )
	ROM_LOAD16_BYTE( "95411405.hi", 0x00000, 0x080000, CRC(53902424) SHA1(6ce22049018cfd3a0fba79cba8a752852a038b65) )
	sc_qual_others
ROM_END

ROM_START( sc5qualg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411542.lo", 0x00001, 0x080000, CRC(44908000) SHA1(3c7420dbba6cc1de7ff4078c0ee12012dc7a5b59) )
	ROM_LOAD16_BYTE( "95411543.hi", 0x00000, 0x080000, CRC(29bffefe) SHA1(87f29b2c088badab9365dd57b67e8bec317c9c37) )
	sc_qual_others
ROM_END

ROM_START( sc5qualh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412482.lo", 0x00001, 0x080000, CRC(3b6c4520) SHA1(f09444ca0c2adc5f4e51de39bcc0f4d70614c537) )
	ROM_LOAD16_BYTE( "95412483.hi", 0x00000, 0x080000, CRC(485729b6) SHA1(91f6fb7b631772ee37959dcf15c851e7fab79ee4) )
	sc_qual_others
ROM_END

ROM_START( sc5quali )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412484.lo", 0x00001, 0x080000, CRC(16e6d2d9) SHA1(72132f6b5fea6c7b9ab8643555e472a882ff35fa) )
	ROM_LOAD16_BYTE( "95412485.hi", 0x00000, 0x080000, CRC(3e64b174) SHA1(7b7f3e59e1ac53c95ba482526a82ef5b1f272299) )
	sc_qual_others
ROM_END

ROM_START( sc5qualj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413482.lo", 0x00001, 0x080000, CRC(b15c836e) SHA1(3f358ce5bded3330a9fd96ec64122ce3c38acc1c) )
	ROM_LOAD16_BYTE( "95413483.hi", 0x00000, 0x080000, CRC(2ac91acc) SHA1(146caea4dc8968c60454a5f67a402409ecf8f257) )
	sc_qual_others
ROM_END

ROM_START( sc5qualk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413484.lo", 0x00001, 0x080000, CRC(fe7c4133) SHA1(bf5a7fe530ff57757dc023d6639227afa40089a8) )
	ROM_LOAD16_BYTE( "95413485.hi", 0x00000, 0x080000, CRC(7cf03220) SHA1(a69dd3cbb519259ba9b3c0b769352d0febc43473) )
	sc_qual_others
ROM_END

ROM_START( sc5quall )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1406p12.hi", 0x00000, 0x080000, CRC(8ba5ce5f) SHA1(e4b7f93e124565deab64f02c4d5c031c39421e1a) )
	ROM_LOAD16_BYTE( "p1406p12.lo", 0x00001, 0x080000, CRC(bfbe93c8) SHA1(60054b63e22e1ef90d615ceec4b0531430cb4a8e) )
	sc_qual_others
ROM_END

ROM_START( sc5qualm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1406s12.hi", 0x00000, 0x080000, CRC(ddf86cdb) SHA1(528f8276dffa667098564b1de7158991c9ca9c1c) )
	ROM_LOAD16_BYTE( "p1406s12.lo", 0x00001, 0x080000, CRC(6fb9725d) SHA1(ecef4f752a4f8e996fafb7e80d35af56abf4e1fe) )
	sc_qual_others
ROM_END




ROM_START( sc5rssh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416078.lo", 0x00001, 0x080000, CRC(497b3c48) SHA1(fb1ce70293606d7cee50c8c9f91aac46fdbf0237) )
	ROM_LOAD16_BYTE( "95416079.hi", 0x00000, 0x080000, CRC(6f6b372b) SHA1(7fc38789b8a7e26f21877e17dc3f95854162b3e9) )
	sc_rssh_others
ROM_END

ROM_START( sc5rssha )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417078.lo", 0x00001, 0x080000, CRC(1056cb40) SHA1(2fe6d90ce69353d389167a55f54c7a8d5b74b237) )
	ROM_LOAD16_BYTE( "95417079.hi", 0x00000, 0x080000, CRC(03eb412b) SHA1(913c3e8b43fddc463eb744c2a0d1be13c8c4f296) )
	sc_rssh_others
ROM_END



ROM_START( sc5hog )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426476.lo", 0x00001, 0x080000, CRC(c33a4532) SHA1(94079594092abc1be8068e9ecc336c97f754fed9) )
	ROM_LOAD16_BYTE( "95426477.hi", 0x00000, 0x080000, CRC(f26b8576) SHA1(cecdfe93b9e71719bfd4eed321ff9f355290c838) )
	sc_rhog_others
ROM_END

ROM_START( sc5hoga )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427476.lo", 0x00001, 0x080000, CRC(caae18b9) SHA1(0ff77bd30996bb2eaf5855dc03d184c0c0cd5384) )
	ROM_LOAD16_BYTE( "95427477.hi", 0x00000, 0x080000, CRC(c8737336) SHA1(189f96c1bcd2ff2ce009879ac58bb64f42b0c4a4) )
	sc_rhog_others
ROM_END





ROM_START( sc5rhclb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422816.lo", 0x00001, 0x080000, CRC(cb6dcc16) SHA1(f33692abb167847ebbf02b25f2929e15a2645a9e) )
	ROM_LOAD16_BYTE( "95422817.hi", 0x00000, 0x080000, CRC(ff60c202) SHA1(d48ee1c7d29091c0744150151c8cd16721741209) )
	sc_rhclb_others
ROM_END

ROM_START( sc5rhclba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423816.lo", 0x00001, 0x080000, CRC(f315b177) SHA1(3dcc4ee7b570bc01222734f1ed3300dce9906328) )
	ROM_LOAD16_BYTE( "95423817.hi", 0x00000, 0x080000, CRC(6f2a3ddb) SHA1(7791c3bbf6e965d383feac1a579b50b94e6bc48b) )
	sc_rhclb_others
ROM_END

ROM_START( sc5rhclbb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426430.lo", 0x00001, 0x080000, CRC(0c8f13b6) SHA1(ba3dbc142c2d5978176d3fa0b9f72a51f48e28b7) )
	ROM_LOAD16_BYTE( "95426431.hi", 0x00000, 0x080000, CRC(afb442d0) SHA1(3999c2bac3fe1de6f7efbb98186b16bd192c55b5) )
	sc_rhclb_others
ROM_END

ROM_START( sc5rhclbc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427430.lo", 0x00001, 0x080000, CRC(ac9ebd80) SHA1(d0b551eff727ef11d0c09fc0cb03aa8aee89b325) )
	ROM_LOAD16_BYTE( "95427431.hi", 0x00000, 0x080000, CRC(a88dde7b) SHA1(301e69d8c6ad1b79ff47ac970db64ab7e911e8ae) )
	sc_rhclb_others
ROM_END

ROM_START( sc5rhclbd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3208p71.hi", 0x00000, 0x080000, CRC(850c2cb1) SHA1(c5eac4024bff58e962a8920e2874b97b18dca57d) )
	ROM_LOAD16_BYTE( "p3208p71.lo", 0x00001, 0x080000, CRC(47b4f49f) SHA1(7a92345879080aad73f5f2db30206c8ab3f160f0) )
	sc_rhclb_others
ROM_END

ROM_START( sc5rhclbe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3208s71.hi", 0x00000, 0x080000, CRC(51ba60df) SHA1(3c7e604626f513b9cf8da393abadc4286c7dbb07) )
	ROM_LOAD16_BYTE( "p3208s71.lo", 0x00001, 0x080000, CRC(9f6373f2) SHA1(e5dc797b8dda3abe9ab64f5fec77f22038ae2c33) )
	sc_rhclb_others
ROM_END


ROM_START( sc5sharp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419012.lo", 0x00001, 0x080000, CRC(096c3ca8) SHA1(555933d106a8c9d1b1e1927cb62fc2f20218192a) )
	ROM_LOAD16_BYTE( "95419013.hi", 0x00000, 0x080000, CRC(3cfeea5f) SHA1(4f226d9a743e124a0fdcfa7682bfa4c697e69522) )
	sc_sharp_others
ROM_END

ROM_START( sc5sharpa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418013.hi", 0x00000, 0x080000, CRC(29514c54) SHA1(b062be5dff916965e1ac0ab2ab45bc18cf8f9c93) )
	ROM_LOAD16_BYTE( "95418012.lo", 0x00001, 0x080000, CRC(6330d3b3) SHA1(bfeb25241c8a7ca9e730eb379dcc7da0270a20a0) )
	sc_sharp_others
ROM_END




ROM_START( sc5sfts )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95424650.lo", 0x00001, 0x080000, CRC(2e9460ba) SHA1(f449701e19c254716ca9aae63c359cfc57be8b1b) )
	ROM_LOAD16_BYTE( "g95424651.hi", 0x00000, 0x080000, CRC(15fddbb7) SHA1(b48a257e3ba74b79272969e9702ecab032df6051) )
	sc_sfts_others
ROM_END

ROM_START( sc5sftsa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95424656.lo", 0x00001, 0x080000, CRC(a0b723c7) SHA1(458bfc964f300659b8497c18cb325b7803666600) )
	ROM_LOAD16_BYTE( "g95424657.hi", 0x00000, 0x080000, CRC(ea65f9de) SHA1(7695e5361d22e8f3acd5842434bd61bdeaf9948f) )
	sc_sfts_others
ROM_END

ROM_START( sc5sftsb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95425650.lo", 0x00001, 0x080000, CRC(cb99c5e3) SHA1(c0a67576693e547e5db4a52388dcbbccdd229c11) )
	ROM_LOAD16_BYTE( "g95425651.hi", 0x00000, 0x080000, CRC(8db18aa2) SHA1(87969702f4a71df394bd2ea521e5768403b91659) )
	sc_sfts_others
ROM_END

ROM_START( sc5sftsc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95425656.lo", 0x00001, 0x080000, CRC(406fa07c) SHA1(e564b331f0b409d967c4ef6ccc17bb37e633d3c8) )
	ROM_LOAD16_BYTE( "g95425657.hi", 0x00000, 0x080000, CRC(3103d2e9) SHA1(f4f5694dc1dbfbe4bd10561adfb517e768d832fb) )
	sc_sfts_others
ROM_END



ROM_START( sc5srrqp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424514.lo", 0x00001, 0x080000, CRC(3fa1e76e) SHA1(9a1ee8172f05210fbebb3823ec589a444ea24586) )
	ROM_LOAD16_BYTE( "95424515.hi", 0x00000, 0x080000, CRC(759f0ef7) SHA1(736521894808134ff43c798b9a862dfe29994e69) )
	sc_srrqp_others
ROM_END

ROM_START( sc5srrqpa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425514.lo", 0x00001, 0x080000, CRC(e61834e8) SHA1(c24e1de4010c57019fa3ee09e50e6cd7a83c4854) )
	ROM_LOAD16_BYTE( "95425515.hi", 0x00000, 0x080000, CRC(89b0bfc5) SHA1(af7c5f0ec42ad9c5899817524594a910cb1fe08a) )
	sc_srrqp_others
ROM_END




ROM_START( sc5sitwi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3203p12.hi", 0x00000, 0x080000, CRC(70665f72) SHA1(f23d975fb98a305ff5eab65d76791780d621593e) )
	ROM_LOAD16_BYTE( "p3203p12.lo", 0x00001, 0x080000, CRC(9dc27ba0) SHA1(9217892885afe5a421996567de82f82f14e791b0) )
	sc_witwi_others
ROM_END

ROM_START( sc5sitwia )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3203s12.hi", 0x00000, 0x080000, CRC(76604bb7) SHA1(04aa6fd4e4783b2e5ea7e26c1511c15b8dda68cd) )
	ROM_LOAD16_BYTE( "p3203s12.lo", 0x00001, 0x080000, CRC(d19fffc9) SHA1(253a88331214a8be0c34cdcbe305317ef4a13987) )
	sc_witwi_others
ROM_END



ROM_START( sc5spnrn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416158.lo", 0x00001, 0x080000, CRC(c422d907) SHA1(9d42e7db20c1366267dac5bf09f8746479531b40) )
	ROM_LOAD16_BYTE( "95416159.hi", 0x00000, 0x080000, CRC(24e6c208) SHA1(8f672249466475f5770e8a3d1ea69c7f82ec374b) )
	sc_spnrn_others
ROM_END

ROM_START( sc5spnrna )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417158.lo", 0x00001, 0x080000, CRC(9ef26fc7) SHA1(eea26ad28ffe51dd0d7205da6057a2bd0467cff3) )
	ROM_LOAD16_BYTE( "95417159.hi", 0x00000, 0x080000, CRC(1f4d639d) SHA1(eb20d3a92e8fb93a5a7d7c2dfd81d32aaf1559e7) )
	sc_spnrn_others
ROM_END




ROM_START( sc5srace )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418036.lo", 0x00001, 0x080000, CRC(b891ca07) SHA1(61b3b1851d8881e960b3b69ea2bc69650e9559a1) )
	ROM_LOAD16_BYTE( "95418037.hi", 0x00000, 0x080000, CRC(986ed7be) SHA1(840536cf145f08d2dab277cf529469c98e05642b) )
	sc_srace_others
ROM_END

ROM_START( sc5sracea )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419036.lo", 0x00001, 0x080000, CRC(c060d8fd) SHA1(011f8af6792e25c9510ecbae3ec93732125ecb70) )
	ROM_LOAD16_BYTE( "95419037.hi", 0x00000, 0x080000, CRC(b4a34db3) SHA1(d20f89dca7ab0ba81d89fb261170551a0bc6e0c9) )
	sc_srace_others
ROM_END




ROM_START( sc5sleut )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424064.lo", 0x00001, 0x080000, CRC(b07c1bcf) SHA1(82b8bf3cb8344e461492d03f8df70f1577be2073) )
	ROM_LOAD16_BYTE( "95424065.hi", 0x00000, 0x080000, CRC(c17d9250) SHA1(6e647f67794e2d326fcf4d97d80244f949ba6554) )
	sc_sleut_others
ROM_END

ROM_START( sc5sleuta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425064.lo", 0x00001, 0x080000, CRC(88b07e21) SHA1(4c3e9c7bd046300369fbc450fb943c680faa577b) )
	ROM_LOAD16_BYTE( "95425065.hi", 0x00000, 0x080000, CRC(1660b679) SHA1(921a5fe7300614e8889223f2d0b0a52e22db192f) )
	sc_sleut_others
ROM_END





ROM_START( sc5tsmp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1630p19.hi", 0x00000, 0x080000, CRC(0de71ba2) SHA1(2bf9f95ecfa7a3f37b93739a573cba214fefdffe) )
	ROM_LOAD16_BYTE( "p1630p19.lo", 0x00001, 0x080000, CRC(df020dcc) SHA1(2863a8b982f374fa2073f8b9d5333cc246fc6614) )
	sc_tsmp_others
ROM_END

ROM_START( sc5tsmpa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1630s19.hi", 0x00000, 0x080000, CRC(32dbdf76) SHA1(2f2aebeedf00e15c476014bea21178a31b58d5e6) )
	ROM_LOAD16_BYTE( "p1630s19.lo", 0x00001, 0x080000, CRC(c70f7f83) SHA1(c1c811830c919eeaa7f74e9d9e6116ddb9b977a8) )
	sc_tsmp_others
ROM_END



ROM_START( sc5pompa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412578.lo", 0x00001, 0x080000, CRC(c302b2ef) SHA1(7da7e4b34c23a34ed7e00ae4673b522abde52b00) )
	ROM_LOAD16_BYTE( "95412579.hi", 0x00000, 0x080000, CRC(5f8815fa) SHA1(5ce9000183da8b64545158b70ffaaf5223197155) )
	sc5pompa_others
ROM_END

ROM_START( sc5pompaa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413578.lo", 0x00001, 0x080000, CRC(bca7fa00) SHA1(908eed34e66ccb4e5a98c4ec0cdff8f29aece37d) )
	ROM_LOAD16_BYTE( "95413579.hi", 0x00000, 0x080000, CRC(c9a297e8) SHA1(1c8a99d020932964788e5ac1dfcb28dd03ebd36f) )
	sc5pompa_others
ROM_END

ROM_START( sc5pompab )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1606s41.lo", 0x00001, 0x080000, CRC(4c47bb0f) SHA1(16d2e6d7c6c6c116c2c9dd503e957e639a07ef04) )
	ROM_LOAD16_BYTE( "p1606s41.hi", 0x00000, 0x080000, NO_DUMP )
	sc5pompa_others
ROM_END



ROM_START( sc5vamp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424380.lo", 0x00001, 0x080000, CRC(46b87ded) SHA1(8bc8a06185498910424772678ae037e09090ab38) )
	ROM_LOAD16_BYTE( "95424381.hi", 0x00000, 0x080000, CRC(5b463863) SHA1(465f767aa57f5ee5f2effc1548bfd829aa4a9e9e) )
	sc_vamp_others
ROM_END

ROM_START( sc5vampa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425380.lo", 0x00001, 0x080000, CRC(c49b44bd) SHA1(174b1e51b04ede8ba19511d3f9a8d37d661747b1) )
	ROM_LOAD16_BYTE( "95425381.hi", 0x00000, 0x080000, CRC(e033bebb) SHA1(5f5679fa410d5be0f852bd61dffe152320634dee) )
	sc_vamp_others
ROM_END

ROM_START( sc5viper )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95414750.lo", 0x00001, 0x080000, CRC(38d24824) SHA1(a98d1f610f92ffb70387d57c8d0641d1ff399438) )
	ROM_LOAD16_BYTE( "95414751.hi", 0x00000, 0x080000, CRC(a2355e09) SHA1(f887915ec1f271416e17aa8ac2c22337e4a0f643) )
	sc_viper_others
ROM_END

ROM_START( sc5vipera )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95415750.lo", 0x00001, 0x080000, CRC(362920a9) SHA1(19dc0fdf2bd2623ce1215ab6d21121d04dfbf248) )
	ROM_LOAD16_BYTE( "95415751.hi", 0x00000, 0x080000, CRC(29088c30) SHA1(c09720cb0b890e51df9167f97e9c3d38161d4e75) )
	sc_viper_others
ROM_END


ROM_START( sc5viz )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424368.lo", 0x00001, 0x080000, CRC(978f755c) SHA1(8790b4f7ea0e2302a1166c93364705c2e9f25703) )
	ROM_LOAD16_BYTE( "95424369.hi", 0x00000, 0x080000, CRC(83a94061) SHA1(bb7125219c2f67601e883481d1665a0dd0614bf7) )
	sc_viz_others
ROM_END

ROM_START( sc5viza )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424562.lo", 0x00001, 0x080000, CRC(31032781) SHA1(511cd503651eb7ca078c52cec8a506f752270e70) )
	ROM_LOAD16_BYTE( "95424563.hi", 0x00000, 0x080000, CRC(b51ab196) SHA1(ff0500ce47ff04b19c7a4d4d3014de198b5ac0ae) )
	sc_viz_others
ROM_END

ROM_START( sc5vizb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425368.lo", 0x00001, 0x080000, CRC(d08cfae9) SHA1(d0ab570f6939c5c9f6f252a23f25b1a7b7ecb0f7) )
	ROM_LOAD16_BYTE( "95425369.hi", 0x00000, 0x080000, CRC(e92a4e55) SHA1(0732350de7dd5f7cb52473b3231cf7fc02d10fed) )
	sc_viz_others
ROM_END

ROM_START( sc5vizc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425562.lo", 0x00001, 0x080000, CRC(32fc1aff) SHA1(cb2a0923fa6f40caaaacaf3552c985ee0655cf63) )
	ROM_LOAD16_BYTE( "95425563.hi", 0x00000, 0x080000, CRC(1cf8e3d1) SHA1(7bf620d40d2c1dfa07321fa765aa1ea08965f633) )
	sc_viz_others
ROM_END


ROM_START( sc5wacky )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3305p71.hi", 0x00000, 0x080000, CRC(8a1c95ca) SHA1(79ca2ba01f3dbfe1226cce7572f5d4d6ffd3f527) )
	ROM_LOAD16_BYTE( "p3305p71.lo", 0x00001, 0x080000, CRC(b956a760) SHA1(14ecbda474370936fbc257364b5f98e774b85193) )
	sc_wacky_others
ROM_END

ROM_START( sc5wackya )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3305p72.hi", 0x00000, 0x080000, CRC(45b0f07d) SHA1(ca066e5ee481002c99bbcbf0f4df43f3f2b9e14a) )
	ROM_LOAD16_BYTE( "p3305p72.lo", 0x00001, 0x080000, CRC(afe37e0b) SHA1(eafc45ba58e69d809324756c0606f935d430fca2) )
	sc_wacky_others
ROM_END

ROM_START( sc5wackyb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3305s71.hi", 0x00000, 0x080000, CRC(6f52c415) SHA1(f3044d4168cf47ef2f468acbdc08d566f514e46a) )
	ROM_LOAD16_BYTE( "p3305s71.lo", 0x00001, 0x080000, CRC(f579d441) SHA1(377919555b6748f1ffd408b7200b027f7525dff3) )
	sc_wacky_others
ROM_END

ROM_START( sc5wackyc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3305s72.hi", 0x00000, 0x080000, CRC(df124698) SHA1(f019a9e739cf2852e6b90eab7bcc2f9ad47a0e9d) )
	ROM_LOAD16_BYTE( "p3305s72.lo", 0x00001, 0x080000, CRC(d1517e62) SHA1(bd13fcf0fd8c157526921ae9b321c65fbcb29cd3) )
	sc_wacky_others
ROM_END


ROM_START( sc5wild )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416410.lo", 0x00001, 0x080000, CRC(46719b6e) SHA1(fbc40168becb125ef1d2019b1a42c90275cc93c6) )
	ROM_LOAD16_BYTE( "95416411.hi", 0x00000, 0x080000, CRC(dd8dd80f) SHA1(e5422de00df5d88ff1260fb8c03845754bf6eb65) )
	sc_wild_others
ROM_END

ROM_START( sc5wilda )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417410.lo", 0x00001, 0x080000, CRC(077fe968) SHA1(92c32dc8929f0905f7f2371d417cebab1359a15b) )
	ROM_LOAD16_BYTE( "95417411.hi", 0x00000, 0x080000, CRC(69475b32) SHA1(402af3e0b86261f6621f75f7d747803f4295ea10) )
	sc_wild_others
ROM_END


ROM_START( sc5wca )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416066.odd", 0x00001, 0x080000, CRC(f07af4e1) SHA1(d6c2372cdaeb4033dcf2a7a8df787a69f4eb5362) )
	ROM_LOAD16_BYTE( "95416067.evn", 0x00000, 0x080000, CRC(194f0267) SHA1(07500aad418e80118974f22f4761204013980a13) )
	sc_wca_others
ROM_END

ROM_START( sc5wcaa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416094.odd", 0x00001, 0x080000, CRC(795ea9dd) SHA1(b4d3cac0ef50732174ebcc349c7a0855587ff7bd) )
	ROM_LOAD16_BYTE( "95416095.evn", 0x00000, 0x080000, CRC(60f1cd18) SHA1(212288329f5e347a40aa5dc9e102f37224f36011) )
	sc_wca_others
ROM_END

ROM_START( sc5wcab )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416170.odd", 0x00001, 0x080000, CRC(b1ff0caf) SHA1(036bbd709454604365b6a15100b5926bbe8594d9) )
	ROM_LOAD16_BYTE( "95416171.evn", 0x00000, 0x080000, CRC(0ab724d5) SHA1(ab17f1fe4f6579022d8fb80399f270ed64ec7612) )
	sc_wca_others
ROM_END

ROM_START( sc5wcac )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416172.odd", 0x00001, 0x080000, CRC(a927b15a) SHA1(ca9b5a87e89feeffb99fbb23fe390a424e27675f) )
	ROM_LOAD16_BYTE( "95416173.evn", 0x00000, 0x080000, CRC(815e89a3) SHA1(0cbea4613c6f7ce69b76c0d7d443e85163373f73) )
	sc_wca_others
ROM_END

ROM_START( sc5wcad )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416398.odd", 0x00001, 0x080000, CRC(3b283b54) SHA1(530812228b7ad96b4c40e33edb9d54632c2b33f5) )
	ROM_LOAD16_BYTE( "95416399.evn", 0x00000, 0x080000, CRC(a0ac5a0d) SHA1(12a8e4a09cdbfd87ad287e6aa1e4d114c1e4b6c3) )
	sc_wca_others
ROM_END

ROM_START( sc5wcae )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416400.odd", 0x00001, 0x080000, CRC(c4e6949f) SHA1(b17ded78ea23f18b47bbb48cfb462d013881abd4) )
	ROM_LOAD16_BYTE( "95416401.evn", 0x00000, 0x080000, CRC(cc482fb8) SHA1(ff912ea928f9c1ad4f6249aaf70dc62292503cd4) )
	sc_wca_others
ROM_END

ROM_START( sc5wcaf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416402.odd", 0x00001, 0x080000, CRC(b7f71001) SHA1(b959840ac4fbd0f4d076e163bcebb840152f6652) )
	ROM_LOAD16_BYTE( "95416403.evn", 0x00000, 0x080000, CRC(13b30567) SHA1(5c5d3d9db53439f58faed4858333885d4f117c73) )
	sc_wca_others
ROM_END

ROM_START( sc5wcag )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416404.odd", 0x00001, 0x080000, CRC(fc2105b0) SHA1(04fb1e3b14cae3132818901c1efd49a362334ca1) )
	ROM_LOAD16_BYTE( "95416405.evn", 0x00000, 0x080000, CRC(df9f1d8a) SHA1(2ba998a7092b623023b47690332f018369e3631c) )
	sc_wca_others
ROM_END

ROM_START( sc5wcah )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417066.odd", 0x00001, 0x080000, CRC(f0a528d7) SHA1(6df30a806b2be5f2a909357d2b6dbd35a5073261) )
	ROM_LOAD16_BYTE( "95417067.evn", 0x00000, 0x080000, CRC(0209e0e0) SHA1(d73b6ce5b1a9f7b2ebad2d077fa0c80dad10da3d) )
	sc_wca_others
ROM_END

ROM_START( sc5wcai )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417094.odd", 0x00001, 0x080000, CRC(f9546e54) SHA1(adbd5f07ea5e029bf4b3f748ffb646872a358730) )
	ROM_LOAD16_BYTE( "95417095.evn", 0x00000, 0x080000, CRC(7e7d655e) SHA1(ea59d192de08917c19a02ce1ce4bff5acf8df0fd) )
	sc_wca_others
ROM_END

ROM_START( sc5wcaj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417170.odd", 0x00001, 0x080000, CRC(4e59642a) SHA1(dad89cc76dd375cf7db1abcddefdb782b317a587) )
	ROM_LOAD16_BYTE( "95417171.evn", 0x00000, 0x080000, CRC(ce9b4edf) SHA1(0624a82d535bc15619263dc730e61121bed494eb) )
	sc_wca_others
ROM_END

ROM_START( sc5wcak )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417172.odd", 0x00001, 0x080000, CRC(8602fb1a) SHA1(5e1e599f607af9b745f722873f2577a54572266d) )
	ROM_LOAD16_BYTE( "95417173.evn", 0x00000, 0x080000, CRC(5cb9d48d) SHA1(b098147757248f37578fcce3693cf9ea6dd1064f) )
	sc_wca_others
ROM_END

ROM_START( sc5wcal )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417398.odd", 0x00001, 0x080000, CRC(9a0a1a0a) SHA1(6093fd9ccf74119a121dc5f9af70e68baf183dfe) )
	ROM_LOAD16_BYTE( "95417399.evn", 0x00000, 0x080000, CRC(f3956efb) SHA1(1913ef5c3896eabcc34018d3aa4bc6c30f4b27b7) )
	sc_wca_others
ROM_END

ROM_START( sc5wcam )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417400.odd", 0x00001, 0x080000, CRC(d449fd36) SHA1(58eb42cbb4edaf0d3b050a042331dcc5f854294f) )
	ROM_LOAD16_BYTE( "95417401.evn", 0x00000, 0x080000, CRC(f6f510f0) SHA1(1d43ab933a9fcb8720babda5d8a1ebeae7f7bf73) )
	sc_wca_others
ROM_END

ROM_START( sc5wcan )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417402.odd", 0x00001, 0x080000, CRC(10b4f7b1) SHA1(9db139bb360f3e220b552affc9598f499e318658) )
	ROM_LOAD16_BYTE( "95417403.evn", 0x00000, 0x080000, CRC(56453ab0) SHA1(98fab945a48ee009cb03ed427660b3bd20da2e8a) )
	sc_wca_others
ROM_END

ROM_START( sc5wcao )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417404.odd", 0x00001, 0x080000, CRC(7321174d) SHA1(95f8426f1a3f31b285c2bb448756fb79050cc1bb) )
	ROM_LOAD16_BYTE( "95417405.evn", 0x00000, 0x080000, CRC(b8522473) SHA1(b89f5ce736e32f380eb7b8249d54499eda8f95dc) )
	sc_wca_others
ROM_END




ROM_START( sc5rhr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416688.lo", 0x00001, 0x080000, CRC(a6eca55c) SHA1(f7a2386053ed6076242c1bf276ae2f8d3611491b) )
	ROM_LOAD16_BYTE( "95416689.hi", 0x00000, 0x080000, CRC(4899c647) SHA1(ea44672d797c406a8d5fb829f43257eaa2f661fd) )
	sc_rhr
ROM_END

ROM_START( sc5rhra )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416690.lo", 0x00001, 0x080000, CRC(4632a223) SHA1(0e1d998f03bbe9d0292500383a1444ae53e91f4d) )
	ROM_LOAD16_BYTE( "95416691.hi", 0x00000, 0x080000, CRC(f2aa4607) SHA1(1c0491b3094d9407724e63757c7e667155408778) )
	sc_rhr
ROM_END

ROM_START( sc5rhrb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417688.lo", 0x00001, 0x080000, CRC(9dc8eb48) SHA1(7c32d52686e7b154540d0c8717b4dea2b35b95b2) )
	ROM_LOAD16_BYTE( "95417689.hi", 0x00000, 0x080000, CRC(d9a00561) SHA1(446ec41e9364e2606d704d36a8779e538d407100) )
	sc_rhr
ROM_END

ROM_START( sc5rhrc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417690.lo", 0x00001, 0x080000, CRC(53cba141) SHA1(5f02cad66703bda185b36f59bc46bf583e3afd03) )
	ROM_LOAD16_BYTE( "95417691.hi", 0x00000, 0x080000, CRC(7bdb4c8c) SHA1(95034cb6f401368be6e6cb4013bcadaacc805a17) )
	sc_rhr
ROM_END

ROM_START( sc5rhrd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416606.lo", 0x00001, 0x080000, CRC(f8698061) SHA1(ffa9cdd15a76f4185538abdd9fa208d79887bba3) )
	ROM_LOAD16_BYTE( "95416607.hi", 0x00000, 0x080000, CRC(9cb25cd4) SHA1(ea5e35e5e7a78b786442810785b83e6b7993984a) )
	sc_rhr
ROM_END


ROM_START( sc5rhre )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417606.lo", 0x00001, 0x080000, CRC(aed7276a) SHA1(36ce9bda535d3eae76d8d86e74c9afc09b37ef04) )
	ROM_LOAD16_BYTE( "95417607.hi", 0x00000, 0x080000, CRC(f29bec42) SHA1(d29fa197c8bb17ca5a6632c19c0850416c2c9f57) )
	sc_rhr
ROM_END



ROM_START( sc5wotw )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416514.lo", 0x00001, 0x080000, CRC(ec4081ce) SHA1(333dd386c6fa09cecf10dfabc757fece98310e6d) )
	ROM_LOAD16_BYTE( "95416515.hi", 0x00000, 0x080000, CRC(2790e4b4) SHA1(f0c644596ec7229f3b539c100b8613e7ea66559e) )
	sc_wotw_others
ROM_END

ROM_START( sc5wotwa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417514.lo", 0x00001, 0x080000, CRC(505c1fa3) SHA1(26f73bc53390597f685368b8a94b6f853f5caed0) )
	ROM_LOAD16_BYTE( "95417515.hi", 0x00000, 0x080000, CRC(802d1030) SHA1(1887eba0c5ad74d6127c5a504c4cab309d326f8d) )
	sc_wotw_others
ROM_END


ROM_START( sc5wok )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3218p11.hi", 0x00000, 0x080000, CRC(351f4f4b) SHA1(81e7c2f7475f9af6e0006bcd189954931a3438ef) )
	ROM_LOAD16_BYTE( "p3218p11.lo", 0x00001, 0x080000, CRC(8e3238c0) SHA1(cfcb2318ce00f427ffe67a5b4bbbd43685e1e0ff) )
	sc_wok_others
ROM_END

ROM_START( sc5woka )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3218s11.hi", 0x00000, 0x080000, CRC(0fb2b822) SHA1(b05cb0f5598c4ad11da9afd35ecb1cdb123589fd) )
	ROM_LOAD16_BYTE( "p3218s11.lo", 0x00001, 0x080000, CRC(21e8ff34) SHA1(4abaa43f72031053e6724bd78ea25b4f1f1ded6c) )
	sc_wok_others
ROM_END

ROM_START( sc5srrcl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424580.lo", 0x00001, 0x080000, CRC(79e66ea0) SHA1(33a02a83c56089b88cdb17ecbe1036fe9d5037af) )
	ROM_LOAD16_BYTE( "95424581.hi", 0x00000, 0x080000, CRC(f542d47b) SHA1(a30e5ee2d28832cc0fd99065702cd8a9503ef0ab) )
	sc_srrcl_others
ROM_END

ROM_START( sc5srrcla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424592.lo", 0x00001, 0x080000, CRC(61e05d2c) SHA1(e55365b128fa1e87c18985199df8d3c67f5241af) )
	ROM_LOAD16_BYTE( "95424593.hi", 0x00000, 0x080000, CRC(44bf9a57) SHA1(36cb644726d25b1265093765913206625feb4954) )
	sc_srrcl_others
ROM_END

ROM_START( sc5srrclb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425580.lo", 0x00001, 0x080000, CRC(aeecddaf) SHA1(7b9eb93f220fec610c3585c16284d00a385f3757) )
	ROM_LOAD16_BYTE( "95425581.hi", 0x00000, 0x080000, CRC(61d04727) SHA1(09d695db3c2e65f94424cda0585854265b353e66) )
	sc_srrcl_others
ROM_END

ROM_START( sc5srrclc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425592.lo", 0x00001, 0x080000, CRC(c9482297) SHA1(7d1f5496a4c0941c58b0453ee4ca4a37104183b5) )
	ROM_LOAD16_BYTE( "95425593.hi", 0x00000, 0x080000, CRC(71b4bbca) SHA1(9295b7070dc458ec9c3db5a7d3a848829c8232c7) )
	sc_srrcl_others
ROM_END

ROM_START( sc5pircl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426804.lo", 0x00001, 0x080000, CRC(e4c540db) SHA1(9d0227887abf9408cb36f47349cdec28a0520d18) )
	ROM_LOAD16_BYTE( "95426805.hi", 0x00000, 0x080000, CRC(34dbe319) SHA1(4541b6dcde089682806ab733c693e0f8afed2687) )
	sc_pircl_others
ROM_END

ROM_START( sc5pircla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426874.lo", 0x00001, 0x080000, CRC(f247e544) SHA1(e970ed7050a5a7190e895b0777ed14aff3bd252c) )
	ROM_LOAD16_BYTE( "95426875.hi", 0x00000, 0x080000, CRC(90e8fbeb) SHA1(a5ba9f97e1713eb5c4a01a2f9a9743fb4d7aea51) )
	sc_pircl_others
ROM_END

ROM_START( sc5pirclb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427804.lo", 0x00001, 0x080000, CRC(5f11f3b9) SHA1(51aaa4f9b847895c2c632e958511d16d44b90590) )
	ROM_LOAD16_BYTE( "95427805.hi", 0x00000, 0x080000, CRC(5fa7e6ad) SHA1(4432ccc19b210bf11ae1b6ce355a56dd315ad1e9) )
	sc_pircl_others
ROM_END

ROM_START( sc5pirclc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427874.lo", 0x00001, 0x080000, CRC(81cf3df9) SHA1(6884eba96eca6bf3b9c2b7afdd00c910fb1ff15e) )
	ROM_LOAD16_BYTE( "95427875.hi", 0x00000, 0x080000, CRC(ffe1f743) SHA1(e05e54bfe4070419ad9ce4b63cbd877778b37ccf) )
	sc_pircl_others
ROM_END


ROM_START( sc5mrrcl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424586.lo", 0x00001, 0x080000, CRC(6f4da0cf) SHA1(4a671f62de1a1af48cd3754b7a1d60c005ce9dfb) )
	ROM_LOAD16_BYTE( "95424587.hi", 0x00000, 0x080000, CRC(89e2b659) SHA1(c7f1e6cb5b04aff30bb5997cef50fa7a621334f7) )
	sc_mrrcl_others
ROM_END

ROM_START( sc5mrrcla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425586.lo", 0x00001, 0x080000, CRC(03bfa76e) SHA1(ca73d02dddf5e5091f1b26cb6b3f9c5db8ea071d) )
	ROM_LOAD16_BYTE( "95425587.hi", 0x00000, 0x080000, CRC(0c204d84) SHA1(31a4f5021b2b12bdf930ed13268c52961aab3cbf) )
	sc_mrrcl_others
ROM_END

ROM_START( sc5mrrclb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "99990558.lo", 0x00001, 0x080000, CRC(ae3f79e9) SHA1(0b086425f1091d01a71bcfaa33627f9b8b66632a) )
	ROM_LOAD16_BYTE( "99990559.hi", 0x00000, 0x080000, CRC(e9c6849d) SHA1(e3b846b5ec06f7048cde44ca1ae45c235476695a) )
	sc_mrrcl_others
ROM_END


ROM_START( sc5mrrclc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "99991558.lo", 0x00001, 0x080000, CRC(b78a36ad) SHA1(a6728544e10e7578cc6b2c6a06d031fe1e30980e) )
	ROM_LOAD16_BYTE( "99991559.hi", 0x00000, 0x080000, CRC(c87db6c9) SHA1(6f100cbfd4a94f8f01fba7996bc59fdfc3b20ce5) )
	sc_mrrcl_others
ROM_END



/* Adder 5 */

// sets which only contain larger roms (almost certainly adder 5)



ROM_START( ad5bpfpm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211339.bin", 0x0000, 0xa91458, CRC(e653ce23) SHA1(8cf3ad73974d97f3ed1d715c607e7888cf0992b1) )
	ROM_LOAD( "39211344.bin", 0x0000, 0x4d2ac4, CRC(2c20765f) SHA1(0856649f6ebef51e1159fdf6a146136a50cf5325) )
	ROM_LOAD( "39212339.bin", 0x0000, 0xa91458, CRC(73ed1ef5) SHA1(a8132e47d4b5644a2da26d512fa68c9078fb2bc1) )
	ROM_LOAD( "39212344.bin", 0x0000, 0x4d2ac4, CRC(01c3c686) SHA1(1c5bb9da7f7ffbf3d2086de3c2a22fa0240187b3) )
	ROM_LOAD( "39211337.bin", 0x0000, 0xa9136a, CRC(4e984598) SHA1(8e5af7faeb7fb650f7bd44e5e7b3c1162514d15f) )
	ROM_REGION( 0x5000, "pics", 0 )
	ROM_LOAD( "95890492.bin", 0x0000, 0x5000, CRC(5bddee9e) SHA1(7c2af91793f1f8c3c7f12535874c032129af7c8c) )
	ROM_LOAD( "95890494.bin", 0x0000, 0x5000, CRC(84513cb2) SHA1(8d45cff91953263c4aa8e7cb4a437c27371bd8a1) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95008987.bin", 0x0000, 0x0fe101, CRC(798c9559) SHA1(4afb21a78be73353741b5903099d3c48e44fcebb) )
	ROM_LOAD( "95008994.bin", 0x0000, 0x0fb8bc, CRC(2c7a4446) SHA1(b1e327747043c795e179643e8bd485f51f838021) )
ROM_END






ROM_START( ad5btc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "p1758p53.bin", 0x0000, 0x1000000, CRC(0323a676) SHA1(26f5d1c6bc4cd2d8405a95714f0dee6c26c21539) )
	ROM_LOAD( "p1758p82.bin", 0x0000, 0x1000000, CRC(5f5e5869) SHA1(37b471340c42c1776e8e6312f3b8db6eab9441e5) )
	ROM_LOAD( "p1758s82.bin", 0x0000, 0x1000000, CRC(55761c4a) SHA1(56531c4df469e5dc4f7df7dcc49c97656ed1183c) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END



ROM_START( ad5cmons )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211009.bin", 0x0000, 0x8ba10c, CRC(3883c4ea) SHA1(ac5876d252ef9900bbd86a43c73b2e3ba08f4e04) )
	ROM_LOAD( "39212009.bin", 0x00000, 0x8ba10c, CRC(40328a9d) SHA1(0923f4dfffd4eca3aa9f67dbb972dd47b78aa0ab) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95008434.bin", 0x0000, 0x100000, CRC(2d35e8ab) SHA1(a2e39beb891416bc5fae3d17125d146fe3ec3a12) )
ROM_END






ROM_START( ad5dndpl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211495.bin", 0x0000, 0x1000000, CRC(d87cda50) SHA1(215776dfe2b9393f8c58bdb0e14cf21505d01ae3) )
	ROM_LOAD( "39212495.bin", 0x0000, 0x1000000, CRC(67c829da) SHA1(c30353c432389e5648ffb14f9ff14821e11fcf38) )
	ROM_LOAD( "p3314p71.bin", 0x0000, 0x1000000, CRC(56b9fa95) SHA1(d33d04089b95116da09700278a732d66eb06cf8c) )
	ROM_LOAD( "p3314s71.bin", 0x0000, 0x1000000, CRC(a6285e1d) SHA1(c790c12150c152e08b541521ed2e80ed2203e639) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95009108.bin", 0x0000, 0x100000, CRC(113b7f60) SHA1(62a8ca9dd9fc663971037936ddbd634273c3055f) )
	ROM_LOAD( "95009109.bin", 0x0000, 0x100000, CRC(edf5a701) SHA1(3514b4a46dd921446c74c5b87a3a4b272e7b0fdb) )
ROM_END






ROM_START( ad5eyes )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211248.bin", 0x0000, 0x4d88b4, CRC(a2b799c9) SHA1(9088de779c31d33d9f1eb83e46ec28c30181a0fc) )
	ROM_LOAD( "39211256.bin", 0x0000, 0x4d8648, CRC(de99153a) SHA1(42e00c847effc60130451e19328cd36cfba1cc76) )
	ROM_LOAD( "39211264.bin", 0x0000, 0x4d546c, CRC(73602540) SHA1(2418628a565504281d7a50879fc8ed6bcec73f8b) )
	ROM_LOAD( "39212246.bin", 0x0000, 0x4d858a, CRC(028d59c7) SHA1(75b0643ec51dc02c678cf3aa034dd1be88fea67f) )
	ROM_LOAD( "39212248.bin", 0x0000, 0x4d88b4, CRC(25c68cad) SHA1(f80b0ee24187e8c55c4aa66687ba378f3f7d24ea) )
	ROM_LOAD( "39212256.bin", 0x0000, 0x4d8648, CRC(94150812) SHA1(b3839e90e99bfa7ed4e3a1401db99e42d4f58642) )
	ROM_LOAD( "39212264.bin", 0x0000, 0x4d546c, CRC(a6ec1842) SHA1(e4ce5d53d140a00e2d620eece6d182b201662b61) )
	ROM_REGION( 0x5000, "pics", 0 )
	ROM_LOAD( "95890303.bin", 0x0000, 0x5000, CRC(dd0d9672) SHA1(5cf162e77b2b395138e02aca3ac9327ffb08e3e4) )
	ROM_LOAD( "95890304.bin", 0x0000, 0x5000, CRC(c1db66ce) SHA1(e45846411d347cad74135a1392b7ce3df2407b07) )
	ROM_LOAD( "95890305.bin", 0x0000, 0x5000, CRC(0281445e) SHA1(b93460a79c906fb0f33bd898054f4c7aaea8fe12) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95008933.bin", 0x0000, 0x03fc55, CRC(5f01c246) SHA1(b5e2b79f780d48935b8eb158b3292ab26340ba7f) )
	ROM_LOAD( "95008959.bin", 0x0000, 0x07daf0, CRC(61e7fb11) SHA1(039efe731866314770800224e2b8536822252193) )
ROM_END







ROM_START( ad5gldmn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211462.bin", 0x0000, 0x1000000, CRC(811a32ab) SHA1(d37238fd6b4a5d13594cc80da48a6b45f44e7c4b) )
	ROM_LOAD( "39211498.bin", 0x0000, 0x1000000, CRC(56624b52) SHA1(181c8b1a4cd039ea7332b1eb71158a424848eea5) )
	ROM_LOAD( "39211567.bin", 0x0000, 0x1000000, CRC(fe309726) SHA1(f7ae2a2c48ce06845df6ce2b2f57ef754f7b4816) )
	ROM_LOAD( "39212462.bin", 0x0000, 0x1000000, CRC(0bdc0f2d) SHA1(53e6a207fbdfae024337bb68ff68797d08485737) )
	ROM_LOAD( "39212498.bin", 0x0000, 0x1000000, CRC(e7d9b5ce) SHA1(c59adf6ed279af1ff655467036f83b63c45a3f66) )
	ROM_LOAD( "39212567.bin", 0x0000, 0x1000000, CRC(8f807849) SHA1(e1e9eeb08db67c94828db832ebab5d96db747fb0) )
	ROM_LOAD( "p3217p71.bin", 0x0000, 0x1000000, CRC(ad0004ea) SHA1(7af464e25adcbbc08d00ed375d460408a3cd1a65) )
	ROM_LOAD( "p3217p72.bin", 0x0000, 0x1000000, CRC(0e721af2) SHA1(89bfdff03b6d197f34320a14c2f8f7b19b2a91ab) )
	ROM_LOAD( "p3217p73.bin", 0x0000, 0x1000000, CRC(ee580fdb) SHA1(0ce8f29f59b7a482eeab00241ca148ae35ea3873) )
	ROM_LOAD( "p3217s71.bin", 0x0000, 0x1000000, CRC(0f09c1da) SHA1(1cbdf80c631ba571a12cb0ea1ceb51b9ccfe63f4) )
	ROM_LOAD( "p3217s72.bin", 0x0000, 0x1000000, CRC(d588b225) SHA1(d74201f8347accc64fa4d8b07adaafb9a2b305bb) )
	ROM_LOAD( "p3217s73.bin", 0x0000, 0x1000000, CRC(4818d397) SHA1(3a96f90cd424deb1242df1443732d3eae8707ac5) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95008808.bin", 0x0000, 0x100000, CRC(0982179a) SHA1(ea962cc30d191c8e581bb1672a201d6f56a29b22) )
	ROM_LOAD( "95008809.bin", 0x0000, 0x100000, CRC(fcd6f506) SHA1(3d2b8768d9b168f06c01568ed248ee9f687a56b5) )
ROM_END




ROM_START( ad5gldwn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211347.bin", 0x0000, 0x1000000, CRC(9db14fec) SHA1(ade5ae1764eb1889624b11ccc5a1faea093fc3ef) )
	ROM_LOAD( "39212347.bin", 0x0000, 0x1000000, CRC(a951e5b9) SHA1(adb004cdfc76a8b753a89018f45cee0ab8551a2f) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95008945.bin", 0x0000, 0x0ff168, CRC(a467d802) SHA1(4120b3a21598f1c3642f0ce05a3c35c15bf6d811) )
ROM_END



ROM_START( ad5hir )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "p3401p71.bin", 0x0000, 0x1000000, CRC(02dfd5d1) SHA1(cddab71cbd9061390183b773fa9a965812c34087) )
	ROM_LOAD( "p3401p72.bin", 0x0000, 0x1000000, CRC(f7a52510) SHA1(e6d494346b6b72a8b68dce24c95b35faee52a0a9) )
	ROM_LOAD( "p3401s71.bin", 0x0000, 0x1000000, CRC(247754f6) SHA1(78a1caaa613d9033b8f870e916df023f724adb95) )
	ROM_LOAD( "p3401s72.bin", 0x0000, 0x1000000, CRC(f7f13885) SHA1(b9d334fdc3e57f0ebaa32b9da6c0951784b87a65) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95008555.bin", 0x0000, 0x100000, CRC(51d07478) SHA1(1e678b61d594d4884601e92485ab22206dc425d4) )
	ROM_LOAD( "95009143.bin", 0x0000, 0x100000, CRC(e8bab23e) SHA1(dc8e5173fcb301ee4abedc76d42ebf4d58d07af1) )
	ROM_LOAD( "95009144.bin", 0x0000, 0x100000, CRC(73b81f14) SHA1(0a8d7949a290dce2b9cd6c4ec42a64ac8f18836d) )
ROM_END




ROM_START( ad5hircl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211098.bin", 0x0000, 0x1000000, CRC(0f40863e) SHA1(30c15f42c6f293b3210dbc91f6fe55fc51069ab6) )
	ROM_LOAD( "39212098.bin", 0x0000, 0x1000000, CRC(32da0bbe) SHA1(117bc8496ae44ea641188b7a9e0952f9378520aa) )
	ROM_LOAD( "39212099.bin", 0x0000, 0x1000000, CRC(92661240) SHA1(670c733c73621a561c01cd50d2e0064a12ef615f) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END




ROM_START( ad5jckmo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211254.bin", 0x0000, 0x432c2c, CRC(66a52091) SHA1(03fd4c1ba2ea7a2ce09dd6200985a2d882e3160e) )
	ROM_LOAD( "39211261.bin", 0x0000, 0x4279d8, CRC(8ee6e967) SHA1(f5c37717cf7905a479a80604c622261669f504a1) )
	ROM_LOAD( "39211266.bin", 0x0000, 0x427514, CRC(6fad3371) SHA1(5a9d3da46980a24907a0fa131f2f77a65b72cde5) )
	ROM_LOAD( "39211294.bin", 0x0000, 0x4284c0, CRC(8fed15d4) SHA1(cc072ee7736f31fb10ad6d293b4ab59cc1a00542) )
	ROM_LOAD( "39212254.bin", 0x0000, 0x432c2c, CRC(f9eeb730) SHA1(602fccdd05c621d3707e42f9571bb515af1c7f9b) )
	ROM_LOAD( "39212261.bin", 0x0000, 0x4279d8, CRC(3641bfe6) SHA1(5a34ada0e3c70c0d05d552be2f5fee50055b1dd4) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END




ROM_START( ad5mcob )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211513.bin", 0x0000, 0x9ad06f, CRC(195c3690) SHA1(0fe72c20fb80c8c1430ddb6aac056be77af9ec24) )
	ROM_LOAD( "39211516.bin", 0x0000, 0x9af0eb, CRC(ef35489e) SHA1(c5d71130ddd8bdb86b45b075bd929ec2eaebeded) )
	ROM_LOAD( "39212513.bin", 0x0000, 0x9ad06f, CRC(0f25723f) SHA1(10cb91accac8a7e5da55e4511e6cffe4164f5314) )
	ROM_LOAD( "39212516.bin", 0x0000, 0x9af0eb, CRC(0b6faf76) SHA1(e9a1158911b8a474acf3b0abe4856aaa406800ca) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95009011.bin", 0x0000, 0x0ff73b, CRC(9f6e0643) SHA1(d0f76b8a45aef2dd42939f1fca7b010637aaabe1) )
ROM_END




ROM_START( ad5ppbtb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211324.bin", 0x0000, 0x565596, CRC(0d58ec3b) SHA1(3cbbd08fc182ec425e51f73a1434591a56ce514b) )
	ROM_LOAD( "39211327.bin", 0x0000, 0x5651c6, CRC(535d29fd) SHA1(a9f1822a8b3ac5eb501dbe957c354f5d29361d4b) )
	ROM_LOAD( "39212324.bin", 0x0000, 0x565426, CRC(3891535d) SHA1(54b1ae18da66a4c91f3c40f9819dc6d93ddd3177) )
	ROM_LOAD( "39212327.bin", 0x0000, 0x5651c6, CRC(3091ec62) SHA1(a14fe3bafc3b3a716209f18860f76e2d2d0a3a0e) )
	ROM_REGION( 0x5000, "pics", 0 )
	ROM_LOAD( "95890416.bin", 0x0000, 0x5000, CRC(2becd79f) SHA1(e87c668c651adf55c234aaa2f9d8a0ed66792356) )
	ROM_LOAD( "95890417.bin", 0x0000, 0x5000, CRC(373a2723) SHA1(61795c8e22e97903f0a4388b3aff6db3ca3af981) )
	ROM_LOAD( "95890418.bin", 0x0000, 0x5000, CRC(f46005b3) SHA1(58b6369c0a9414f8ccf16ccbe05adfa47c188e1b) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END




ROM_START( ad5pking )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211031.bin", 0x0000, 0x1000000, CRC(ec68ef4b) SHA1(2f00afa1ac3b6776f9e8cb44e861d572025c72b2) )
//  ROM_LOAD( "39211031.txt", 0x0000, 0x0000d0, CRC(05e5443e) SHA1(2cbfa749b976c733195ddfc1afd715d0e97963fa) )
	ROM_LOAD( "39212031.bin", 0x0000, 0x1000000, CRC(08811e4d) SHA1(983c39b09ad3d33546a9873e1d77dd6be50b9b2e) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95008495.bin", 0x0000, 0x080000, CRC(dac8c4a8) SHA1(0192e1d2b9558a789753a5e58d97503cc09dfa27) )
ROM_END





ROM_START( ad5rsnw )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211205.bin", 0x0000, 0x6a39e0, CRC(bb426781) SHA1(b1e21abd85589a7ca0e77b123f18b61c16e47971) )
	ROM_LOAD( "39211241.bin", 0x0000, 0x6c2cea, CRC(ec610e0d) SHA1(946a0c400745fae967ad4f6f5ddb589a93de13f6) )
	ROM_LOAD( "39212205.bin", 0x0000, 0x6a39e0, CRC(20c43fd3) SHA1(38b3489f3e966c94ef87cc8566c8df02b7b9aee8) )
	ROM_LOAD( "39212241.bin", 0x0000, 0x6c2cea, CRC(2b433106) SHA1(8e430097ec993549684f34dc9bac64ff88346b24) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END




ROM_START( ad5rspin )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211388.bin", 0x0000, 0x1000000, CRC(56fca244) SHA1(56890695c230a62b50c9dc2ecb4e8d6c123ed8dc) )
	ROM_LOAD( "39212387.bin", 0x0000, 0x1000000, CRC(7affbe1b) SHA1(9fced7102afe267f426ada6e7840b877b185ca57) )
	ROM_LOAD( "39212388.bin", 0x0000, 0x1000000, CRC(9ed7ae4f) SHA1(ff55640fd2538e9ed9b17b4387d1430401b22e69) )

	ROM_LOAD( "39212612.bin", 0x0000, 0x1000000, CRC(dec693eb) SHA1(69256d4cc47715ea826eb0ca838c09a9d9e4d1e2) ) // hot spinner?



	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95008549.bin", 0x0000, 0x100000, CRC(dd7399cf) SHA1(1d4f475dde67048c6a425623a696a06e49231308) )
ROM_END




ROM_START( ad5rsclb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211057.bin", 0x0000, 0x1000000, CRC(6bd542ce) SHA1(635a829461555f86da7e5d19e8f4e198d63f5400) )
	ROM_LOAD( "39211096.bin", 0x0000, 0x1000000, CRC(e34160e1) SHA1(92308c870c7782a8025ccbe97e7c17773dcbd3f4) )
	ROM_LOAD( "39211097.bin", 0x0000, 0x1000000, CRC(b9c0409b) SHA1(8cef9887f2b89cca2e8a28187db2d3a6828a285e) )
	ROM_LOAD( "39211169.bin", 0x0000, 0x1000000, CRC(45b44bdb) SHA1(2b5a01c9beaa7fa50688ddd50b9f8e5eb135f3fc) )
	ROM_LOAD( "39211170.bin", 0x0000, 0x1000000, CRC(d9e85ee5) SHA1(5da29c3203a9a8ad91c556eb5fb085ee38e1b920) )
	ROM_LOAD( "39211187.bin", 0x0000, 0x1000000, CRC(2f9c7191) SHA1(32c815cab7475fcfe50cba94a25740c37ae8d04f) )
	ROM_LOAD( "39212057.bin", 0x0000, 0x1000000, CRC(85555f52) SHA1(52464e934b28f637ea8f2577ae270ddd0353bf7c) )
	ROM_LOAD( "39212096.bin", 0x0000, 0x1000000, CRC(8df5a794) SHA1(ca005e560a1772da525435728ace0aff53e95640) )
	ROM_LOAD( "39212097.bin", 0x0000, 0x1000000, CRC(9e774d32) SHA1(1d8d97539953d5d33703b39eba39a62dfbf5849a) )
	ROM_LOAD( "39212169.bin", 0x0000, 0x1000000, CRC(1f149fc4) SHA1(808ccaa893f9be2680f8b33e882ab0f3e8b36488) )
	ROM_LOAD( "39212170.bin", 0x0000, 0x1000000, CRC(fedcf3a1) SHA1(c46fd797d81edca5a751e89045c18d6787a43500) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95008546.bin", 0x0000, 0x100000, CRC(3d97132f) SHA1(b611617b21b6b7afafa300604ec09e0a84bde8ba) )
ROM_END




ROM_START( ad5rwclb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
//  ROM_LOAD( "39211073.txt", 0x0000, 0x0000d1, CRC(7e897cdf) SHA1(9444d6b08d3c61e878512dc761e669d0f7b93717) )
	ROM_LOAD( "39211073.bin", 0x0000, 0x1000000, CRC(bd3e0d73) SHA1(063058051dd5d774e2755f3fd0fb3f83277221db) )
	ROM_LOAD( "39211074.bin", 0x0000, 0x1000000, CRC(917dbae6) SHA1(87c664beba60054c0349861f4bd19393cf993bf1) )
	ROM_LOAD( "39212073.bin", 0x0000, 0x1000000, CRC(64d98913) SHA1(b207d411a007079ac2a46df3d801f933635fc55f) )
	ROM_LOAD( "39212074.bin", 0x0000, 0x1000000, CRC(972b5457) SHA1(83a0cbc3875027e91224cff6e60b9da696ff9c8e) )
	ROM_LOAD( "p1757p11.bin", 0x0000, 0x1000000, CRC(34de65e7) SHA1(c5d449f4eeb596e9d8874c1a80dd77dccc75d1b8) )
	ROM_LOAD( "p1757s11.bin", 0x0000, 0x1000000, CRC(36f2efbc) SHA1(9431a1ae738f24370a785b69c50ce34dd260dc8c) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END




ROM_START( ad5rapid )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211120.bin", 0x0000, 0x1000000, CRC(7de15e7d) SHA1(02ee9bf3d670f9ec7f4428c5b9c1d40a1e68df17) )
	ROM_LOAD( "39212120.bin", 0x0000, 0x1000000, CRC(16f91987) SHA1(1ad0b3b3c58f0566fc1a23904c7bc0e8693d99d4) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95008570.bin", 0x0000, 0x080000, CRC(edd2bff6) SHA1(213b16eb091f96633dec5ec8df5084062dd68ba0) )
ROM_END




ROM_START( ad5rcash )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211273.bin", 0x0000, 0x80ceaa, CRC(2577ad05) SHA1(9f9d003331821a79d3bb0901dd91af8c19bbbc49) )
	ROM_LOAD( "39212273.bin", 0x0000, 0x80ceaa, CRC(7459b4a7) SHA1(d78fe6ffddd97a7ba81a053712b0d5be9cefe33a) )
	ROM_REGION( 0x400000, "pics", ROMREGION_ERASEFF )
	ROM_LOAD( "95890390.bin", 0x0000, 0x5000, CRC(f973db95) SHA1(f91b206e1a1fb5125654ad081d666ae2bfd2036f) )
	ROM_LOAD( "95890391.bin", 0x0000, 0x5000, CRC(e5a52b29) SHA1(ac408585a14060b81651e14f0cae6a77edee1985) )
	ROM_LOAD( "95890392.bin", 0x0000, 0x5000, CRC(26ff09b9) SHA1(236d0808126d517e4a1c86bebad3c877252de4d8) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95008946.bin", 0x0000, 0x0f7b10, CRC(9a70fd7b) SHA1(692908750bea92af5f06d7151b15aec294aaf686) )
ROM_END



ROM_START( ad5rroul )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211342.bin", 0x0000, 0xfc273a, CRC(50b63c2f) SHA1(2670f41b05cabf40d1ce1fb03d1c936207a50afa) )
	ROM_LOAD( "39211345.bin", 0x0000, 0x643110, CRC(c3838739) SHA1(1260e2348bc41a1d364b3bbd3914724ea2c6153a) )
	ROM_LOAD( "39212342.bin", 0x0000, 0xfc273a, CRC(81491291) SHA1(a32687e3e4d535540fcc78cea5f432b5bd4e01b9) )
	ROM_LOAD( "39212345.bin", 0x0000, 0x643110, CRC(216efed6) SHA1(8c5b66bac3bde410577d2c8b6f8d352404a36695) )
	ROM_REGION( 0x400000, "pics", ROMREGION_ERASEFF )
	ROM_LOAD( "95890489.bin", 0x0000, 0x5000, CRC(8f41d119) SHA1(83f276c02a0fe404c397cf708552674fb3bb15c4) )
	ROM_LOAD( "95890490.bin", 0x0000, 0x5000, CRC(939721a5) SHA1(be0a9c2af853ab8c28e63aa6dcff350d4e69e437) )
	ROM_LOAD( "95890491.bin", 0x0000, 0x5000, CRC(50cd0335) SHA1(db2bcf0e2be67eb8c657ab3536a5056bb66649b8) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95008986.bin", 0x0000, 0x0c18ab, CRC(f69f04b5) SHA1(b1095592120c3f4f3bac8963362611def14f7233) )
	ROM_LOAD( "95008996.bin", 0x0000, 0x0ce354, CRC(a462a168) SHA1(6598605123407bb2206928e82a903f9a41ba524c) )
ROM_END





ROM_START( ad5rsrm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "p3302p71.bin", 0x0000, 0x1000000, CRC(09aa5633) SHA1(1733dc5430f1277ff32c6b8abcbee7a274b1c9de) )
	ROM_LOAD( "p3302s71.bin", 0x0000, 0x1000000, CRC(9f4c34ad) SHA1(81493e5f957d0e705d5fe9111f46e119b871b6b0) )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_END




ROM_START( ad5rsrr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95008828.bin", 0x0000, 0x100000, CRC(35a1b9aa) SHA1(a6d03645994b36a9e506b950f752a6c1c899e110) )
	ROM_LOAD( "95008829.bin", 0x0000, 0x100000, CRC(3745f572) SHA1(ffc9e67ed92552e7b2790433ea4838df10712f4d) )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "p3302p12.bin", 0x0000, 0x1000000, CRC(92294235) SHA1(1ff971f24a1de18d29e009800e6c7aa2830962f5) )
	ROM_LOAD( "p3302s12.bin", 0x0000, 0x1000000, CRC(ca95d6e0) SHA1(4fdb2e136251ffc8aa475b6c1ccbc0d6a8afe0d2) )
ROM_END





ROM_START( ad5tornc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95008564.bin", 0x0000, 0x100000, CRC(55d0d855) SHA1(343cfe935c34c8f95a638eccb1397238fa7698e4) )

	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASE00 )
	ROM_LOAD( "39211114.bin", 0x0000, 0x1000000, CRC(f218d87b) SHA1(230038ee52d47dde9669a6fd3a363264f222f1f8) )
	ROM_LOAD( "39211115.bin", 0x0000, 0x1000000, CRC(867ad45b) SHA1(90b9c256ffb99ecae912771aa8eb1605651f2a68) )
	ROM_LOAD( "39212114.bin", 0x0000, 0x1000000, CRC(5f80e76b) SHA1(a8aeef603a815b34ba61963532b4c6699cb3c27d) )
	ROM_LOAD( "39212115.bin", 0x0000, 0x1000000, CRC(2be2eb4b) SHA1(c70e27938e60c701cb41060536cc68c69a2df50b) )
	ROM_LOAD( "p1627p12.bin", 0x0000, 0x1000000, CRC(71b881b6) SHA1(a18455c2ce769d9ea135f887c83594be319ac8ce) )
	ROM_LOAD( "p1627s12.bin", 0x0000, 0x1000000, CRC(0cd2ca21) SHA1(fa2dfdd73540d3446ac5c33f72e93d1c4b520d73) )
ROM_END






ROM_START( ad5vpa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95008722.bin", 0x0000, 0x080000, CRC(0643d71d) SHA1(027e096a82d5c13a98ef773548c8f5e16257e863) )

	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASE00 )
	ROM_LOAD( "p3073p71.bin", 0x0000, 0x1000000, CRC(75320ec0) SHA1(833a44c62a132d06de63995780769966efeff5c3) )
	ROM_LOAD( "p3073p72.bin", 0x0000, 0x1000000, CRC(cdd49281) SHA1(1771504c3b335744a195c93858b1418099599e19) )
	ROM_LOAD( "p3073s71.bin", 0x0000, 0x1000000, CRC(0adee992) SHA1(fba11f05c762bc456adbcd3d682fceb3b19a851b) )
	ROM_LOAD( "p3073s72.bin", 0x0000, 0x1000000, CRC(b048298e) SHA1(0f55563b80d00c743f75d71500e3493087abcfc0) )
ROM_END






ROM_START( ad5vlv )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	ROM_LOAD( "95009055.bin", 0x0000, 0x100000, CRC(6fa39bdb) SHA1(a78b02d4b7d38da529db590b32d5d22ed7b46870) )
	ROM_LOAD( "95009056.bin", 0x0000, 0x100000, CRC(d530f185) SHA1(a3a8ac81ce7d9a8e8e005cfaab3f9ae82804cbd9) )

	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASE00 )
	ROM_LOAD( "39211605.bin", 0x0000, 0x1000000, CRC(b8fab0a2) SHA1(68ad9810549d9d01934182cb578e17af05ffa3c2) )
	ROM_LOAD( "39211606.bin", 0x0000, 0x1000000, CRC(fa465b43) SHA1(8be39ffbee06a5b662a40b447276f95aa3b9bbe2) )
	ROM_LOAD( "39212605.bin", 0x0000, 0x1000000, CRC(e5deb9fd) SHA1(9490d506080e729a43daf73710d4077c5d33d47b) )

	ROM_LOAD( "39211630.bin", 0x0000, 0x1000000, CRC(2b246fc9) SHA1(ce1140c4f36a362f8c864ebc6aa3af00a173d913) )
	ROM_LOAD( "39212630.bin", 0x0000, 0x1000000, CRC(b50bed01) SHA1(16a1e861baee8a54b1f7227744401351ed3355f7) )
    ROM_LOAD( "39211615.bin", 0x00000, 0x1000000, CRC(d8308232) SHA1(11ddcb313b299a4704dbd24dd78c7303bf17a48a) )
    ROM_LOAD( "39212615.bin", 0x00000, 0x1000000, CRC(b4299ca1) SHA1(d97e7f9d8a3729702d7f5076c10a4afc29333886) )

ROM_END











ROM_START( sc5adjb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422204.lo", 0x00001, 0x080000, CRC(330a0bc8) SHA1(046079ee90d3e75c39615a786879c7e9d5ef40aa) )
	ROM_LOAD16_BYTE( "95422205.hi", 0x00000, 0x080000, CRC(73cb56fd) SHA1(0fcb444be12cc24720bb3a84ac5e4ffe1582c0e7) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422346.lo", 0x00001, 0x080000, CRC(614bc81e) SHA1(433da3c2ff9f41b92f4e52bb37ed39b28732afe4) )
	ROM_LOAD16_BYTE( "95422347.hi", 0x00000, 0x080000, CRC(98cecb00) SHA1(ed02da4896eeab76ea31d4ef79a75d4ea5b4d884) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422612.lo", 0x00001, 0x080000, CRC(0230fef6) SHA1(a1c7fad70bf8ac54255761e61c41415a044dcacf) )
	ROM_LOAD16_BYTE( "95422613.hi", 0x00000, 0x080000, CRC(dba8b822) SHA1(07ebb8f9d69dcde96d1e5cf9b70ef6597d5d163a) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422616.lo", 0x00001, 0x080000, CRC(1a517468) SHA1(d562120c96eb8b7511b19a594400f39b17911519) )
	ROM_LOAD16_BYTE( "95422617.hi", 0x00000, 0x080000, CRC(57f76ea6) SHA1(865487238f5eabb08895f6800eef767213d50e0b) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422844.lo", 0x00001, 0x080000, CRC(f41e2053) SHA1(bcb33f317a7f1afb00ea5e66d0f0909c0b7ad7b4) )
	ROM_LOAD16_BYTE( "95422845.hi", 0x00000, 0x080000, CRC(6fcbea84) SHA1(876a43c3aa07604c4dc29aaede18dc04f7bd7de2) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423204.lo", 0x00001, 0x080000, CRC(9d830a8f) SHA1(381f93a8890f2b9e409760078dff4046e1ed2060) )
	ROM_LOAD16_BYTE( "95423205.hi", 0x00000, 0x080000, CRC(31b3451e) SHA1(659672722886959b7953ea505adc971b14ac14f4) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423346.lo", 0x00001, 0x080000, CRC(da4698f7) SHA1(2a257089e6fdf6d9b028c2d5b98670cb886b2753) )
	ROM_LOAD16_BYTE( "95423347.hi", 0x00000, 0x080000, CRC(2d8abca5) SHA1(ae52093d2869c8deff560b0995e6de57e63d383e) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423612.lo", 0x00001, 0x080000, CRC(d5f79dc8) SHA1(bc7a37b44c60a5d3b116f96961687c0e5c4aef16) )
	ROM_LOAD16_BYTE( "95423613.hi", 0x00000, 0x080000, CRC(271befb0) SHA1(5d2a9d78a4995788aeb03c8053da60c47ba5ec55) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423616.lo", 0x00001, 0x080000, CRC(bac8efd2) SHA1(3be18e085844c683e84e4ae16d39b985d3a42bf7) )
	ROM_LOAD16_BYTE( "95423617.hi", 0x00000, 0x080000, CRC(f00e7e40) SHA1(289cbd6909040e542b82e567148732e13fe9358c) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426156.lo", 0x00001, 0x080000, CRC(9f149b4c) SHA1(9c40e575ca1bcd8848f2f2132be299d881f7b744) )
	ROM_LOAD16_BYTE( "95426157.hi", 0x00000, 0x080000, CRC(63762f8a) SHA1(cb347a79b475f24d2ea251288e201c5333149e4f) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426286.lo", 0x00001, 0x080000, CRC(c7ac0270) SHA1(18b6f8502e512758a2a4753a9f20ea73b1f6c1f8) )
	ROM_LOAD16_BYTE( "95426287.hi", 0x00000, 0x080000, CRC(535606de) SHA1(d174a4a209d35cdcdc13657f598c861b3d5e446a) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427156.lo", 0x00001, 0x080000, CRC(6bea4916) SHA1(697305893467ea2074bc89a332c95dd4f4044438) )
	ROM_LOAD16_BYTE( "95427157.hi", 0x00000, 0x080000, CRC(211c1bdb) SHA1(0fe2c4cd8c74f9e38f7da774ac3b08a2d013b51e) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427286.lo", 0x00001, 0x080000, CRC(26ebaf2c) SHA1(c3e5ca75def57d09e1c2973d87733b19ff2c213f) )
	ROM_LOAD16_BYTE( "95427287.hi", 0x00000, 0x080000, CRC(5857ae6e) SHA1(a594044b5c0a9b4cdb988c578c7a383b44694400) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3009p41.hi", 0x00000, 0x080000, CRC(fcdca441) SHA1(75b95121e8fc9cb3a822e9984240278eb87e58dd) )
	ROM_LOAD16_BYTE( "p3009p41.lo", 0x00001, 0x080000, CRC(944c7e39) SHA1(f6fb1f525ae870f6aac4ba85a14c14acf39e9d88) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3009p71.hi", 0x00000, 0x080000, CRC(53f0ba31) SHA1(9a88e22578074063b5332172fcd652fae4b1ee37) )
	ROM_LOAD16_BYTE( "p3009p71.lo", 0x00001, 0x080000, CRC(ed313688) SHA1(0a9c03f9cce3b5d1d8949b256e688e7ae3c646be) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3009p72.hi", 0x00000, 0x080000, CRC(83501640) SHA1(adf13bc188da7ebbfac119a9bbadc65c390846da) )
	ROM_LOAD16_BYTE( "p3009p72.lo", 0x00001, 0x080000, CRC(d45399a8) SHA1(baa7f674d73dfbc1bd7afa8cfcc7ec5c3fce7ff0) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3009s41.hi", 0x00000, 0x080000, CRC(722ecc98) SHA1(8704898bfc63e901532b8fe4b044dc283b57d260) )
	ROM_LOAD16_BYTE( "p3009s41.lo", 0x00001, 0x080000, CRC(efac5e35) SHA1(4de590d3158fc722104af92bb8d83e6d1c0d7224) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3009s71.hi", 0x00000, 0x080000, CRC(34602c55) SHA1(4447731f8f27e702bc4f44253eae44a5db1deea8) )
	ROM_LOAD16_BYTE( "p3009s71.lo", 0x00001, 0x080000, CRC(2c5afcdd) SHA1(524c9c8e7a9726cdff00e749a94978612b6f7c9e) )
	sc_adjb_others
ROM_END

ROM_START( sc5adjbr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3009s72.hi", 0x00000, 0x080000, CRC(31e26340) SHA1(571cf698d75240cb5c2f9403c1136e44d0509181) )
	ROM_LOAD16_BYTE( "p3009s72.lo", 0x00001, 0x080000, CRC(b4d0dcc9) SHA1(6c51e3bac949e6a906edacb24cf12ba1dae4760a) )
	sc_adjb_others
ROM_END



ROM_START( sc5adwta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1920p44.hi", 0x00000, 0x080000, CRC(50b71a6e) SHA1(a7e387253be2e3b400d8738dc7547b15e39a74ea) )
	ROM_LOAD16_BYTE( "p1920p44.lo", 0x00001, 0x080000, CRC(7b0cac6c) SHA1(45542f7b600da049a69954537cfd83b93471b3e8) )
	sc_adwta_others
ROM_END

ROM_START( sc5adwtaa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1920s44.hi", 0x00000, 0x080000, CRC(3aad0ff3) SHA1(76455165581553ad292db2fdc200f391a2a9a2da) )
	ROM_LOAD16_BYTE( "p1920s44.lo", 0x00001, 0x080000, CRC(d3e80b27) SHA1(1f6c1489b6d0696f49a2f7edb4e7a73aaadc0bea) )
	sc_adwta_others
ROM_END




ROM_START( sc5a40 )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95414940.lo", 0x00001, 0x080000, CRC(4a069351) SHA1(b6ab6f955519de814da3345c63a62b5d7bfd2d97) )
	ROM_LOAD16_BYTE( "95414941.hi", 0x00000, 0x080000, CRC(786f601b) SHA1(5d327fd9851034d5c51165164ca0a02cd9724900) )
	sc_a40_others
ROM_END

ROM_START( sc5a40a )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95415940.lo", 0x00001, 0x080000, CRC(6f5cbce8) SHA1(24385d37d801b8f631d000fb8cb21a46c25a06d4) )
	ROM_LOAD16_BYTE( "95415941.hi", 0x00000, 0x080000, CRC(c0f48a14) SHA1(8a97e38661d34a2d9ed1347dbe0976d5d0328d0e) )
	sc_a40_others
ROM_END



ROM_START( sc5bantm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416818.lo", 0x00001, 0x080000, CRC(2b180a7f) SHA1(9945452c202d849da2fbde0ddcb02d504667ccde) )
	ROM_LOAD16_BYTE( "95416819.hi", 0x00000, 0x080000, CRC(55eaabbf) SHA1(e41f90cd79c68bf90bf710604fa6079ebd68fad9) )
	sc_bantm_others
ROM_END

ROM_START( sc5bantma )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417818.lo", 0x00001, 0x080000, CRC(bc82d375) SHA1(729f4ef4fe39ad2fcf5adada4444581e7fcfdbf8) )
	ROM_LOAD16_BYTE( "95417819.hi", 0x00000, 0x080000, CRC(ec449e02) SHA1(5ab4989c7306ba33f6b85ab0d9b205cb08bcf6f0) )
	sc_bantm_others
ROM_END





ROM_START( sc5bar7 )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412716.lo", 0x00001, 0x080000, CRC(9b1fe8a2) SHA1(9d813b3001d9577faa26a44cfffbc2496ac64af8) )
	ROM_LOAD16_BYTE( "95412717.hi", 0x00000, 0x080000, CRC(84e6009f) SHA1(f0ce4ca874d30d3cf3d365f4fe569ab7f710294c) )
	PR1492_CAS_BAR_SEVENS_SOUNDS11
ROM_END

ROM_START( sc5bar7a )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413716.lo", 0x00001, 0x080000, CRC(2bb811f4) SHA1(4b12168b4fc9a79d8495ac5e8948546c8ba0a942) )
	ROM_LOAD16_BYTE( "95413717.hi", 0x00000, 0x080000, CRC(9bb208dd) SHA1(08e09486a622e17e5cc0c3f948770e9656fa9096) )
	PR1492_CAS_BAR_SEVENS_SOUNDS11
ROM_END

ROM_START( sc5bar7b )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418798.lo", 0x00001, 0x080000, CRC(9811b2cf) SHA1(15b7d94cdf4654fe0da53eb6cb166d3495e521c0) )
	ROM_LOAD16_BYTE( "95418799.hi", 0x00000, 0x080000, CRC(4ca310f4) SHA1(3fdba98bcdd78ee073cb7b973f5d5994b2203e84) )
	sc_bar7_others
ROM_END

ROM_START( sc5bar7c )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418836.lo", 0x00001, 0x080000, CRC(ab16028f) SHA1(62c2f7800640e414f3e9cde4296683e41c61366f) )
	ROM_LOAD16_BYTE( "95418837.hi", 0x00000, 0x080000, CRC(a6f7ba18) SHA1(53709568cf9adc5c5218d13de85c5cff1a2e79f7) )
	sc_bar7_others
ROM_END

ROM_START( sc5bar7d )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419798.lo", 0x00001, 0x080000, CRC(66a2e7e3) SHA1(6a914e448bee58aaa5c6f17ef13f5bf7e7fc0576) )
	ROM_LOAD16_BYTE( "95419799.hi", 0x00000, 0x080000, CRC(202366f4) SHA1(0aef5696016aada29b03ccff324290063a0b3fd6) )
	sc_bar7_others
ROM_END

ROM_START( sc5bar7e )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419836.lo", 0x00001, 0x080000, CRC(0ed80c54) SHA1(9f6b3f12b327537cb9bd6f8f2e50746e279d8ac5) )
	ROM_LOAD16_BYTE( "95419837.hi", 0x00000, 0x080000, CRC(a52b18b0) SHA1(ad7a0f2af97c44e5d50393b542c3cc12ef522b2f) )
	sc_bar7_others
ROM_END

ROM_START( sc5bar7f )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3064p11.hi", 0x00000, 0x080000, CRC(c85b105b) SHA1(f29e64f45df751a978c64dffdd4919a99bae4d55) )
	ROM_LOAD16_BYTE( "p3064p11.lo", 0x00001, 0x080000, CRC(637fd529) SHA1(8ba3a1f83e88b2bd91d23c63c648e3fa5a7b7804) )
	sc_bar7_others
ROM_END

ROM_START( sc5bar7g )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3064s11.hi", 0x00000, 0x080000, CRC(600bed57) SHA1(f0d1d167bddaa4b38aaff9a3191495b6a3e25492) )
	ROM_LOAD16_BYTE( "p3064s11.lo", 0x00001, 0x080000, CRC(b65e219c) SHA1(872e3ce4cfe1f4b2f98ed32639d972ca9fce44a8) )
	sc_bar7_others
ROM_END



ROM_START( sc5batl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412976.lo", 0x00001, 0x080000, CRC(b0bcfe61) SHA1(3d84df125744a884199a759b580c2e5b8f08e4f0) )
	ROM_LOAD16_BYTE( "95412977.hi", 0x00000, 0x080000, CRC(d2ba126f) SHA1(f8c1dd94e97dab14bbaefb708afc0f212b5cd765) )
	sc_batl_others
ROM_END

ROM_START( sc5batla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413976.lo", 0x00001, 0x080000, CRC(7385453f) SHA1(cbfaf78d9cb1bf4968dc65b013b3acef7b2c1d5c) )
	ROM_LOAD16_BYTE( "95413977.hi", 0x00000, 0x080000, CRC(5011ccad) SHA1(a1622d4ce94a61d862228c2b60c1a1d8a6fb0d15) )
	sc_batl_others
ROM_END



ROM_START( sc5bob )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416240.lo", 0x00001, 0x080000, CRC(d34a7edf) SHA1(f8de8f16cdfc8fb5bc1b48e8eadb809c2391f590) )
	ROM_LOAD16_BYTE( "95416241.hi", 0x00000, 0x080000, CRC(458613d6) SHA1(888e14b794a788423088d753ee59f4f353818094) )
	sc_bob_others
ROM_END

ROM_START( sc5boba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417240.lo", 0x00001, 0x080000, CRC(c179312d) SHA1(3d09204fb594f2580752b02afb77f34299a111db) )
	ROM_LOAD16_BYTE( "95417241.hi", 0x00000, 0x080000, CRC(68c1e0d8) SHA1(0e674306e0692f1a13fb5c3b9cf1cb326b5c2042) )
	sc_bob_others
ROM_END

ROM_START( sc5bobb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420294.lo", 0x00001, 0x080000, CRC(e065a8b6) SHA1(b6f7edcee40bd54aaef994713c97390c7b92fb8d) )
	ROM_LOAD16_BYTE( "95420295.hi", 0x00000, 0x080000, CRC(40aa6a80) SHA1(b0515a8328caec1c537edca64bb21b82fd476ee7) )
	sc_bob_others
ROM_END

ROM_START( sc5bobc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421294.lo", 0x00001, 0x080000, CRC(e7eb72e8) SHA1(820e780c3d70600dacf9b633fc5e0c358873c7bd) )
	ROM_LOAD16_BYTE( "95421295.hi", 0x00000, 0x080000, CRC(40ec7987) SHA1(b0bdb684cec649c0337078b58e8c86d037b9b157) )
	sc_bob_others
ROM_END


ROM_START( sc5bull )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412888.lo", 0x00001, 0x080000, CRC(ea4916cc) SHA1(6c073331b44049e8ea7ac3081dbb5ec7f33f6866) )
	ROM_LOAD16_BYTE( "95412889.hi", 0x00000, 0x080000, CRC(611a3bd6) SHA1(05c199b673824936c140289b9c302c0b946979b1) )
	sc_bull_others
ROM_END

ROM_START( sc5bulla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413888.lo", 0x00001, 0x080000, CRC(0a8ff0a7) SHA1(f1dc9393ed81a90bca24360d6dbf26bf7177d14f) )
	ROM_LOAD16_BYTE( "95413889.hi", 0x00000, 0x080000, CRC(cadbc132) SHA1(44a49071ceba94f05ee94bfd30827b0cee14a62c) )
	sc_bull_others
ROM_END

ROM_START( sc5sbull )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1719p11.hi", 0x00000, 0x080000, CRC(9647d67b) SHA1(944299d64953c472dee486e1a8c479aa275d5ef9) )
	ROM_LOAD16_BYTE( "p1719p11.lo", 0x00001, 0x080000, CRC(c7473a2b) SHA1(4fe8120ce5e39bb2ac33f9659f5bb35a79e5da86) )
	sc_bull_others
ROM_END

ROM_START( sc5sbulla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1719s11.hi", 0x00000, 0x080000, CRC(6e478e1b) SHA1(148d4dad7466836c1e8f835e0c344a42b128f982) )
	ROM_LOAD16_BYTE( "p1719s11.lo", 0x00001, 0x080000, CRC(8ac0cd1a) SHA1(7e40fd0f1dedfeb2a83e439249edc016cb65c154) )
	sc_bull_others
ROM_END

ROM_START( sc5bull5 )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3318p71.hi", 0x00000, 0x080000, CRC(eb94716e) SHA1(f9ed42da57519b68eb7d9be48115aaf8607d6c93) )
	ROM_LOAD16_BYTE( "p3318p71.lo", 0x00001, 0x080000, CRC(c55f25a4) SHA1(2554e8d1c3547f0e93e1fc5f7e6b42c43c7654b3) )
	PR3318_BULLSEYE_SOUNDS11
ROM_END

ROM_START( sc5bull5a )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3318p72.hi", 0x00000, 0x080000, CRC(a8693b6b) SHA1(380fdf5dd8518995d915583e547e94562a4c0f7b) )
	ROM_LOAD16_BYTE( "p3318p72.lo", 0x00001, 0x080000, CRC(657bba1e) SHA1(f8fa202c4057d3e37540d32c15965368bb73accd) )
	PR3318_BULLSEYE_SOUNDS11
ROM_END

ROM_START( sc5bull5b )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3318s71.hi", 0x00000, 0x080000, CRC(7481c408) SHA1(13b12c77c66973df75ee32d151ce5be072b0b02e) )
	ROM_LOAD16_BYTE( "p3318s71.lo", 0x00001, 0x080000, CRC(32bf3031) SHA1(e1c1b2207c988d3d4c8bbba386518760dc6c5245) )
	PR3318_BULLSEYE_SOUNDS11
ROM_END

ROM_START( sc5bull5c )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3318s72.hi", 0x00000, 0x080000, CRC(20c23a5e) SHA1(c6aa64a99b04fdf87cb56d1f2a15f16f3d3d075b) )
	ROM_LOAD16_BYTE( "p3318s72.lo", 0x00001, 0x080000, CRC(03203e08) SHA1(70566d3d011b0d09dad6edf0812c6c2a6f4a68a6) )
	PR3318_BULLSEYE_SOUNDS11
ROM_END

ROM_START( ad5bull ) // we only seem to have the sounds of the adder unit for this?
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "program.bin", 0x00000, 0x1000000, NO_DUMP )
	PR1758_BULLSEYE_TRIPLE_SOUNDS11
ROM_END

ROM_START( sc5butch )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418334.lo", 0x00001, 0x080000, CRC(eafed6e2) SHA1(a38b551ee7ba1d486ef2465c506be710f6300146) )
	ROM_LOAD16_BYTE( "95418335.hi", 0x00000, 0x080000, CRC(aaa386cb) SHA1(003ca24635510f1e92eb269d028b951abdaea7ef) )
	sc_butch_others
ROM_END

ROM_START( sc5butcha )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418816.lo", 0x00001, 0x080000, CRC(f9f97eed) SHA1(dfb568189cd0f79c9930171b2b21ed6f641c85db) )
	ROM_LOAD16_BYTE( "95418817.hi", 0x00000, 0x080000, CRC(a371016c) SHA1(b8d324592d688247b2f5b1ed8ed709f19abe518b) )
	sc_butch_others
ROM_END

ROM_START( sc5butchb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418874.lo", 0x00001, 0x080000, CRC(a0ba18ad) SHA1(4499a64bc23b002c632198f61970db810d7d2d9c) )
	ROM_LOAD16_BYTE( "95418875.hi", 0x00000, 0x080000, CRC(4184a7e2) SHA1(d3a2a45c2b29d3e0b6c4eba57f442673b87fa649) )
	sc_butch_others
ROM_END

ROM_START( sc5butchc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419334.lo", 0x00001, 0x080000, CRC(94825977) SHA1(0a7f5a7ee929f88fd7f3902e93b08c47bd2de7e2) )
	ROM_LOAD16_BYTE( "95419335.hi", 0x00000, 0x080000, CRC(df899d01) SHA1(02c97f953376cdf76d3321b3daac1cb4ca28f07a) )
	sc_butch_others
ROM_END

ROM_START( sc5butchd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419816.lo", 0x00001, 0x080000, CRC(d7fc4130) SHA1(99f7b40cc226c1d4c017f9ba08fdfec7024b313b) )
	ROM_LOAD16_BYTE( "95419817.hi", 0x00000, 0x080000, CRC(ecce1743) SHA1(d4552bc518ac2c24fb0f41acd3a123b2a952796b) )
	sc_butch_others
ROM_END

ROM_START( sc5butche )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419874.lo", 0x00001, 0x080000, CRC(266f617a) SHA1(abb6c88c81fa3135702fa88e8c40b89aa004f365) )
	ROM_LOAD16_BYTE( "95419875.hi", 0x00000, 0x080000, CRC(79f3a4df) SHA1(0f01fc4c2a1e5c8fea163ae64a76949b9f665c75) )
	sc_butch_others
ROM_END



ROM_START( sc5cabin )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416198.lo", 0x00001, 0x080000, CRC(acd3688e) SHA1(b27d39d8e1fbfd2a20d06773e0397b96af9c1a11) )
	ROM_LOAD16_BYTE( "95416199.hi", 0x00000, 0x080000, CRC(9419cdf9) SHA1(00a3a236dd8f712ffcdb9e5df413563054598c76) )
	sc_cabin_others
ROM_END

ROM_START( sc5cabina )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417198.lo", 0x00001, 0x080000, CRC(8b7549c5) SHA1(6948483265b601904134d3cee265c560062b13cc) )
	ROM_LOAD16_BYTE( "95417199.hi", 0x00000, 0x080000, CRC(7616fdd5) SHA1(fe37395bc9188931b1beac28ef2886cb2384976b) )
	sc_cabin_others
ROM_END

ROM_START( sc5cabinb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420574.lo", 0x00001, 0x080000, CRC(56fb3a4b) SHA1(075d2fb9d1b260b5161c4d3f6f584c3a1aa742ca) )
	ROM_LOAD16_BYTE( "95420575.hi", 0x00000, 0x080000, CRC(4f91bad2) SHA1(69524ea2a902987775e59e352ce91e3de3e9b1b8) )
	sc_cabin_others
ROM_END

ROM_START( sc5cabinc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421574.lo", 0x00001, 0x080000, CRC(7d259244) SHA1(04cd0b33d58f3ae8da8c55d1ebf7966f4723f305) )
	ROM_LOAD16_BYTE( "95421575.hi", 0x00000, 0x080000, CRC(5910850d) SHA1(d1218443133c23cbdb8f13161b9631be70fb9eae) )
	sc_cabin_others
ROM_END



ROM_START( sc5cari )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420262.lo", 0x00001, 0x080000, CRC(db05dbbd) SHA1(172964a3f64ae1f7ef21bebbe80f7b7f608c2952) )
	ROM_LOAD16_BYTE( "95420263.hi", 0x00000, 0x080000, CRC(7fe167eb) SHA1(7bcfe5daa91f29fd5d25f0189524c496dd8213d7) )
	sc_cari_others
ROM_END

ROM_START( sc5caria )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420610.lo", 0x00001, 0x080000, CRC(732fe359) SHA1(3c035fa7692e9d0d317ded726425129a51a2bddb) )
	ROM_LOAD16_BYTE( "95420611.hi", 0x00000, 0x080000, CRC(be4c7191) SHA1(863cadada0b14dfd57dd3817c525b1603ac1206d) )
	sc_cari_others
ROM_END

ROM_START( sc5carib )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420646.lo", 0x00001, 0x080000, CRC(8cfdafbf) SHA1(97c883cd6bd6335a9c55075851278dc38889a24f) )
	ROM_LOAD16_BYTE( "95420647.hi", 0x00000, 0x080000, CRC(df5b5576) SHA1(254062ddf6c190efd528abb5ea4f5fb972856e71) )
	sc_cari_others
ROM_END

ROM_START( sc5caric )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420736.lo", 0x00001, 0x080000, CRC(0b1f4f5f) SHA1(cf77e0752ae70eb4b70601568a97f0cea9f7d803) )
	ROM_LOAD16_BYTE( "95420737.hi", 0x00000, 0x080000, CRC(fd6ad5f0) SHA1(0a62b4221beb681cb7c0eec24a26e42cc3401ae7) )
	sc_cari_others
ROM_END

ROM_START( sc5carid )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421262.lo", 0x00001, 0x080000, CRC(e262396e) SHA1(575897863f0840b8a1437fe8b4d03b45c604116a) )
	ROM_LOAD16_BYTE( "95421263.hi", 0x00000, 0x080000, CRC(2c1615e8) SHA1(92c9e5cc8adf5cc2a35b513ef2ee24511761e662) )
	sc_cari_others
ROM_END

ROM_START( sc5carie )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421610.lo", 0x00001, 0x080000, CRC(83237c7d) SHA1(2ddc94fbe67f983a1401ec9904d42167455fd750) )
	ROM_LOAD16_BYTE( "95421611.hi", 0x00000, 0x080000, CRC(6307c3e8) SHA1(53a00bbc8b32f7ee320470001c2034f6743836ed) )
	sc_cari_others
ROM_END

ROM_START( sc5carif )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421646.lo", 0x00001, 0x080000, CRC(5bc76dd4) SHA1(565c73f3083a2ba3df2d7ba8111472dd1f00e1a2) )
	ROM_LOAD16_BYTE( "95421647.hi", 0x00000, 0x080000, CRC(ea39887b) SHA1(ef79e55b4729ba8bcc5636e7098554dce4567521) )
	sc_cari_others
ROM_END

ROM_START( sc5carig )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421736.lo", 0x00001, 0x080000, CRC(aa99f3ed) SHA1(496a6cd1a451f63bdfa8ebe9b1c849e0a73dd655) )
	ROM_LOAD16_BYTE( "95421737.hi", 0x00000, 0x080000, CRC(620df42a) SHA1(0e3ad649562e3b2919747c78c97d042b23a27d65) )
	sc_cari_others
ROM_END


ROM_START( sc5cblas )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418026.lo", 0x00001, 0x080000, CRC(a283feca) SHA1(0c94cd66f82c05d723b1b3515c650c1f08a5bf5f) )
	ROM_LOAD16_BYTE( "95418027.hi", 0x00000, 0x080000, CRC(e3143638) SHA1(7bc6484aed013f25045b34fd8e422dc0ac9a8097) )
	sc_cblas_others
ROM_END

ROM_START( sc5cblasa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419026.lo", 0x00001, 0x080000, CRC(3ccf4515) SHA1(893c38ea2d35f0cf480da637ece301633ffb792c) )
	ROM_LOAD16_BYTE( "95419027.hi", 0x00000, 0x080000, CRC(55931f20) SHA1(ba42d054d884b86f967f6157a66563c5e0d92c7f) )
	sc_cblas_others
ROM_END



ROM_START( sc5casxt )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420712.lo", 0x00001, 0x080000, CRC(76058d49) SHA1(0c05d7dc4f69b62d0ccafaa2fb0f5f95ed196230) )
	ROM_LOAD16_BYTE( "95420713.hi", 0x00000, 0x080000, CRC(ffb7d958) SHA1(054062991db12dd4e5cb05aefe31f165ffb2863d) )
	sc_casxt_others
ROM_END


ROM_START( sc5casxta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421712.lo", 0x00001, 0x080000, CRC(3c95e568) SHA1(7308b20b962a1e006db14df9375f0376ab360400) )
	ROM_LOAD16_BYTE( "95421713.hi", 0x00000, 0x080000, CRC(031ccbca) SHA1(7046385ec98c296ed993df06ff081b2dbde8b42e) )
	sc_casxt_others
ROM_END




ROM_START( sc5chavi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418090.lo", 0x00001, 0x080000, CRC(e453684f) SHA1(42d0d223f559fab560310e1333d1c7f6e6e82282) )
	ROM_LOAD16_BYTE( "95418091.hi", 0x00000, 0x080000, CRC(8771b305) SHA1(988d40dc2ce2cb68fdb371a67197112e0305c4cd) )
	sc_chavi_others
ROM_END

ROM_START( sc5chavia )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418824.lo", 0x00001, 0x080000, CRC(37967162) SHA1(8eef719d8a22fd4ad059ec30ca7e9d73d6682e5d) )
	ROM_LOAD16_BYTE( "95418825.hi", 0x00000, 0x080000, CRC(bd26bfa6) SHA1(8fc483dd18121c6f07ef3059d4bca29d0ac65c64) )
	sc_chavi_others
ROM_END

ROM_START( sc5chavib )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418898.lo", 0x00001, 0x080000, CRC(fce959fc) SHA1(94bdb62892d46f51a70f2b35718724f3e2de070d) )
	ROM_LOAD16_BYTE( "95418899.hi", 0x00000, 0x080000, CRC(40418dbf) SHA1(192ba131b2da9accf05c09ff899a302862d24c39) )
	sc_chavi_others
ROM_END

ROM_START( sc5chavic )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419090.lo", 0x00001, 0x080000, CRC(a393dca3) SHA1(6f0f9cfb3b5aa6ac6ae02d1987fb4c5e1a5a9d63) )
	ROM_LOAD16_BYTE( "95419091.hi", 0x00000, 0x080000, CRC(9f143def) SHA1(377bc77a8f792526d2f9b391b9e28627b1bee55b) )
	sc_chavi_others
ROM_END

ROM_START( sc5chavid )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419824.lo", 0x00001, 0x080000, CRC(e3c25c14) SHA1(90c511378dfa48f24fcac9818efa4c0cccc15620) )
	ROM_LOAD16_BYTE( "95419825.hi", 0x00000, 0x080000, CRC(90614ca8) SHA1(84038b4e0a516d33c6abc9eee75964215bb569fa) )
	sc_chavi_others
ROM_END

ROM_START( sc5chavie )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419898.lo", 0x00001, 0x080000, CRC(04c42bf4) SHA1(5d40fb2bf1e7e0ea29f21aef83c86835726e78e0) )
	ROM_LOAD16_BYTE( "95419899.hi", 0x00000, 0x080000, CRC(7bea2c2a) SHA1(3cbeb27a22f910014ba1eea0ddd53b48bf071e9c) )
	sc_chavi_others
ROM_END


ROM_START( sc5chavy )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416842.lo", 0x00001, 0x080000, CRC(be85c187) SHA1(d2743eefe9576270d291b1978737817892af9772) )
	ROM_LOAD16_BYTE( "95416843.hi", 0x00000, 0x080000, CRC(6eaeeb76) SHA1(5bfd47cb2cd2c6bd46a36c527fa018c449d6a710) )
	sc_chavy_others
ROM_END

ROM_START( sc5chavya )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417842.lo", 0x00001, 0x080000, CRC(eb9fa79e) SHA1(b7830534490417d04638019275da633846b54f41) )
	ROM_LOAD16_BYTE( "95417843.hi", 0x00000, 0x080000, CRC(7ee0cbf0) SHA1(1669ac40c06f65d75a00ddce965cccc6276ade8f) )
	sc_chavy_others
ROM_END

ROM_START( sc5chavyb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420334.lo", 0x00001, 0x080000, CRC(356c3a41) SHA1(e66f97a4145d5161711f31a14ae9fde5318e95c6) )
	ROM_LOAD16_BYTE( "95420335.hi", 0x00000, 0x080000, CRC(2b8ebf58) SHA1(caf40ca340e48d4ddbc44f80d1afdbcd8a88855a) )
	sc_chavy_others
ROM_END

ROM_START( sc5chavyc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421334.lo", 0x00001, 0x080000, CRC(e8dd78da) SHA1(a578bae1a56e849a908939291a848aa5aa31d5d7) )
	ROM_LOAD16_BYTE( "95421335.hi", 0x00000, 0x080000, CRC(98270994) SHA1(3ba637fa297a329532d35cb56e801fd65d86ede6) )
	sc_chavy_others
ROM_END


ROM_START( sc5clue )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416562.lo", 0x00001, 0x080000, CRC(c4b78c45) SHA1(5894b0a63418c30ee2b580acf4b1ddb2ad56296a) )
	ROM_LOAD16_BYTE( "95416563.hi", 0x00000, 0x080000, CRC(b98e38f1) SHA1(9f477028d66c816305a04d307b7c1cd90ce22406) )
	sc_clue_others
ROM_END

ROM_START( sc5cluea )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417562.lo", 0x00001, 0x080000, CRC(915e332e) SHA1(8bebc060a81477dbc863e91dfcac96735276c386) )
	ROM_LOAD16_BYTE( "95417563.hi", 0x00000, 0x080000, CRC(f016e591) SHA1(e40b91b2d6ccfafc97be91b6f5a18ebbfdea6a36) )
	sc_clue_others
ROM_END

ROM_START( sc5clueb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420376.lo", 0x00001, 0x080000, CRC(7b39a031) SHA1(2b5041fa2ae37dc62e18a0fb264e478808d6aa55) )
	ROM_LOAD16_BYTE( "95420377.hi", 0x00000, 0x080000, CRC(fef0e282) SHA1(ab59343b614dc389022b6225219907177770eda3) )
	sc_clue_others
ROM_END

ROM_START( sc5cluec )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421376.lo", 0x00001, 0x080000, CRC(799ec958) SHA1(2d90a9a8079676b2260e94a02f83225b8fc766ab) )
	ROM_LOAD16_BYTE( "95421377.hi", 0x00000, 0x080000, CRC(c963fea2) SHA1(c4e9515d7066c9318cec77da9423f93996d45050) )
	sc_clue_others
ROM_END



ROM_START( sc5cmani )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408022.lo", 0x00001, 0x080000, CRC(e874cb2f) SHA1(4a93d26b6d3f64f850130dc00600ce722c5296bc) )
	ROM_LOAD16_BYTE( "95408023.hi", 0x00000, 0x080000, CRC(627ae9d9) SHA1(1096527a6e2f973cfa8d21aa2ec28102275664da) )
	sc_cmani_others
ROM_END

ROM_START( sc5cmania )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408072.lo", 0x00001, 0x080000, CRC(edf065dd) SHA1(2755c0eb52e881b9d5836cd8a4cbac44ee78c0ed) )
	ROM_LOAD16_BYTE( "95408073.hi", 0x00000, 0x080000, CRC(7cd3526a) SHA1(ff6fbcff771da4dcbd2bdae59cdc4821c2169489) )
	sc_cmani_others
ROM_END

ROM_START( sc5cmanib )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409022.lo", 0x00001, 0x080000, CRC(771ba795) SHA1(453a3ed1b70ab108682795ebb94757aca2f83029) )
	ROM_LOAD16_BYTE( "95409023.hi", 0x00000, 0x080000, CRC(4e9ce09f) SHA1(9bfde67c5492eabd464bc3e44e01ea2b1d702153) )
	sc_cmani_others
ROM_END

ROM_START( sc5cmanic )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409072.lo", 0x00001, 0x080000, CRC(ad1b4196) SHA1(d19d19469cd8f8180c150b7e816442683fb11f14) )
	ROM_LOAD16_BYTE( "95409073.hi", 0x00000, 0x080000, CRC(4034921c) SHA1(a4dee8366390496ad48c89e9ebfba3a706c874cb) )
	sc_cmani_others
ROM_END




ROM_START( sc5cj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410980.lo", 0x00001, 0x080000, CRC(211d86aa) SHA1(629a8430ffb34ffdcce320fb97e2cc90f150832a) )
	ROM_LOAD16_BYTE( "95410981.hi", 0x00000, 0x080000, CRC(63f665e0) SHA1(7b853d38e92f1d1cd3a892077062b34053b9f104) )
	sc_cj_others
ROM_END

ROM_START( sc5cja )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410982.lo", 0x00001, 0x080000, CRC(0ee53044) SHA1(62e56ad2251f2908bc8587b126d0f3cff49951cd) )
	ROM_LOAD16_BYTE( "95410983.hi", 0x00000, 0x080000, CRC(86234e04) SHA1(b09ec3987df8a61936539e8f69fbfdc0bea79e08) )
	sc_cj_others
ROM_END

ROM_START( sc5cjb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411980.lo", 0x00001, 0x080000, CRC(9aba66d1) SHA1(1d22e85f999d3199fe25fd673dce3edd212162bc) )
	ROM_LOAD16_BYTE( "95411981.hi", 0x00000, 0x080000, CRC(0e5d2198) SHA1(30e82d04e7ea15cc237056aa5c482de44e182dbf) )
	sc_cj_others
ROM_END

ROM_START( sc5cjc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411982.lo", 0x00001, 0x080000, CRC(6cdefe57) SHA1(506f779cc253d74060c6b3e920609f08abbbc884) )
	ROM_LOAD16_BYTE( "95411983.hi", 0x00000, 0x080000, CRC(b8313675) SHA1(e6add1fcd81b2cab99ea9a5d4284a8a5d8ec33ea) )
	sc_cj_others
ROM_END

ROM_START( sc5cjd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412560.lo", 0x00001, 0x080000, CRC(319aef1e) SHA1(774d00e3f01836a79c530dd6e556f416eca35c92) )
	ROM_LOAD16_BYTE( "95412561.hi", 0x00000, 0x080000, CRC(8970b675) SHA1(ae8877cce1d6be05e154511200301a1daeeb9597) )
	sc_cj_others
ROM_END

ROM_START( sc5cje )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413560.lo", 0x00001, 0x080000, CRC(291fdd53) SHA1(92af62de2a411566c16461f124d5f6fa969d84a6) )
	ROM_LOAD16_BYTE( "95413561.hi", 0x00000, 0x080000, CRC(e5e6b17f) SHA1(eeaf1a8553d0c507c689c8d216da79e1570a06d8) )
	sc_cj_others
ROM_END


ROM_START( sc5ctl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1340p12.hi", 0x00000, 0x080000, CRC(2dc7259d) SHA1(35f3f9227b6bea85983de3fab0b6553817310a40) )
	ROM_LOAD16_BYTE( "p1340p12.lo", 0x00001, 0x080000, CRC(a77e56ec) SHA1(943bf649ee0bd72bef177dfee12497f3ccc54eab) )
	sc_ctl_others
ROM_END

ROM_START( sc5ctla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1340p13.hi", 0x00000, 0x080000, CRC(5a0f6848) SHA1(edd3cab79508923d1017b55a392a6d1ea488e733) )
	ROM_LOAD16_BYTE( "p1340p13.lo", 0x00001, 0x080000, CRC(b553c20d) SHA1(93a27c225dedbfa73c0af6f5cfa1a5cb4c91b3a9) )
	sc_ctl_others
ROM_END

ROM_START( sc5ctlb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1340s12.hi", 0x00000, 0x080000, CRC(e48974d9) SHA1(ea1020e8898763999f514135186f3b5dde4b4bc5) )
	ROM_LOAD16_BYTE( "p1340s12.lo", 0x00001, 0x080000, CRC(5a076aa3) SHA1(0ff7dbf7c72e8da6dcbe7e2747aa372bf18120b5) )
	sc_ctl_others
ROM_END

ROM_START( sc5ctlc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1340s13.hi", 0x00000, 0x080000, CRC(3c409fe7) SHA1(4d42b999c090c8b82b7c39ca25aa2d930b15e9d0) )
	ROM_LOAD16_BYTE( "p1340s13.lo", 0x00001, 0x080000, CRC(3d0b5934) SHA1(46aaedf7db345e490412278d5308c03866be7ee5) )
	sc_ctl_others
ROM_END



ROM_START( sc5crsc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422118.lo", 0x00001, 0x080000, CRC(61ab2086) SHA1(717c1b3e96f9a2f413e6d2b935c976bff730578b) )
	ROM_LOAD16_BYTE( "95422119.hi", 0x00000, 0x080000, CRC(4a6c626c) SHA1(6b8e0d1398d1ecfd26709a68641809fc95f4de0d) )
	sc_crsc_others
ROM_END

ROM_START( sc5crsca )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422316.lo", 0x00001, 0x080000, CRC(3e71d049) SHA1(90a1b015803e933d94892e244304a430b5e7943e) )
	ROM_LOAD16_BYTE( "95422317.hi", 0x00000, 0x080000, CRC(6723b3df) SHA1(95868c8864624acfc4dc9b68b0417318552b97b7) )
	sc_crsc_others
ROM_END

ROM_START( sc5crscb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422510.lo", 0x00001, 0x080000, CRC(08c19d5c) SHA1(f6ef98e305e78ee34a5f2475ebcc7c667d6dd22b) )
	ROM_LOAD16_BYTE( "95422511.hi", 0x00000, 0x080000, CRC(9bccff45) SHA1(826285c960f4424590abe3dffb8fbf98ec0035f1) )
	sc_crsc_others
ROM_END

ROM_START( sc5crscc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422840.lo", 0x00001, 0x080000, CRC(68ecba68) SHA1(376005c2c75a6e02c4a34ab5fe9697fc2f3d1f50) )
	ROM_LOAD16_BYTE( "95422841.hi", 0x00000, 0x080000, CRC(c36b5e60) SHA1(380b619b7a96a9cc0e75ce14621fa5c457186786) )
	sc_crsc_others
ROM_END

ROM_START( sc5crscd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423118.lo", 0x00001, 0x080000, CRC(dfbd0942) SHA1(5c7294d61b4f57d41dd9d4f8e0a0764fb4589160) )
	ROM_LOAD16_BYTE( "95423119.hi", 0x00000, 0x080000, CRC(19eb125a) SHA1(706aa0fb1de731322f3ffb04e09584bf3305fe4d) )
	sc_crsc_others
ROM_END

ROM_START( sc5crsce )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423316.lo", 0x00001, 0x080000, CRC(131cca2e) SHA1(4870a14efff4378e8b406b1c9a0602ab80ed2349) )
	ROM_LOAD16_BYTE( "95423317.hi", 0x00000, 0x080000, CRC(13827a58) SHA1(c774f1df710fb88db8b86d74d265ffeb17c142d2) )
	sc_crsc_others
ROM_END

ROM_START( sc5crscf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423510.lo", 0x00001, 0x080000, CRC(afd1761c) SHA1(ce9da48e350c9965a6a1b79123e116c72684e37f) )
	ROM_LOAD16_BYTE( "95423511.hi", 0x00000, 0x080000, CRC(d6c85c03) SHA1(072e712af5409a91af33260218c80b194a45b801) )
	sc_crsc_others
ROM_END

ROM_START( sc5crscg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423840.lo", 0x00001, 0x080000, CRC(b6c225d8) SHA1(f9d3cc542c7e7127f74cc58b7b09ba99c0132525) )
	ROM_LOAD16_BYTE( "95423841.hi", 0x00000, 0x080000, CRC(0499c31a) SHA1(4c7d2bb3c2f4268070ca681833cdbbe51162bfc6) )
	sc_crsc_others
ROM_END

ROM_START( sc5crsch )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426114.lo", 0x00001, 0x080000, CRC(af70f5b8) SHA1(82ce9daf626d990b8ca550be52a1dc3e6109cf5e) )
	ROM_LOAD16_BYTE( "95426115.hi", 0x00000, 0x080000, CRC(37b3f49f) SHA1(8f7f72bb7017052249ca309165d923f1c2ccd9e0) )
	sc_crsc_others
ROM_END

ROM_START( sc5crsci )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426164.lo", 0x00001, 0x080000, CRC(31dfd609) SHA1(542bd37903d36318e04b2749e938aa40f530d703) )
	ROM_LOAD16_BYTE( "95426165.hi", 0x00000, 0x080000, CRC(676f0391) SHA1(c5cabdd3696a76d72566f2b56b57f1244d665ca9) )
	sc_crsc_others
ROM_END

ROM_START( sc5crscj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426292.lo", 0x00001, 0x080000, CRC(101c0006) SHA1(2c92086a791078a6a3dae40f4029e18d092bd8f9) )
	ROM_LOAD16_BYTE( "95426293.hi", 0x00000, 0x080000, CRC(fbcf7149) SHA1(0e34753cd75124af1305099d5abd57e03d2ba6a8) )
	sc_crsc_others
ROM_END

ROM_START( sc5crsck )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427114.lo", 0x00001, 0x080000, CRC(ac0beaa0) SHA1(b0aa5af084785ccd64132d3c8a9a438d04224400) )
	ROM_LOAD16_BYTE( "95427115.hi", 0x00000, 0x080000, CRC(3177e176) SHA1(0195d3a81f604e74f8f8033f8a411ee535fb93ac) )
	sc_crsc_others
ROM_END

ROM_START( sc5crscl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427164.lo", 0x00001, 0x080000, CRC(6c2c5331) SHA1(6dc17f34f2eec2d4cf3287b9062e6eb2e0f7156d) )
	ROM_LOAD16_BYTE( "95427165.hi", 0x00000, 0x080000, CRC(1f37b5dc) SHA1(cc3a3e58317930bfcbf563958692c1d23a0dcf65) )
	sc_crsc_others
ROM_END

ROM_START( sc5crscm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427292.lo", 0x00001, 0x080000, CRC(8e01c277) SHA1(4ef88a3e142083810d1b25da79f892a2be9fa42d) )
	ROM_LOAD16_BYTE( "95427293.hi", 0x00000, 0x080000, CRC(14450bab) SHA1(88888bb85edca3fc26607e63bd57dcf2ce8183a7) )
	sc_crsc_others
ROM_END

ROM_START( sc5crscn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3005p01.hi", 0x00000, 0x080000, CRC(fee3d425) SHA1(c8c7773c96567cad9c553f4e35f39b9a26569f4b) )
	ROM_LOAD16_BYTE( "p3005p01.lo", 0x00001, 0x080000, CRC(e3328108) SHA1(61b17d67abf793f05821afd1cb1032e55b2382e5) )
	sc_crsc_others
ROM_END

ROM_START( sc5crsco )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3005p41.hi", 0x00000, 0x080000, CRC(2ce1f7b7) SHA1(506675ee2d5859c6c29152bbb7fdda83b2b3b90a) )
	ROM_LOAD16_BYTE( "p3005p41.lo", 0x00001, 0x080000, CRC(91464b75) SHA1(8d663507cedc18deec52c11e15bfaf49e75a3560) )
	sc_crsc_others
ROM_END

ROM_START( sc5crscp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3005p42.hi", 0x00000, 0x080000, CRC(cfc76b53) SHA1(6f380aa861498091a3a7060b399a505b3d6e3efc) )
	ROM_LOAD16_BYTE( "p3005p42.lo", 0x00001, 0x080000, CRC(7a860115) SHA1(ace6181f9ae468434b32999054b0e5b86d40a5dd) )
	sc_crsc_others
ROM_END

ROM_START( sc5crscq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3005p43.hi", 0x00000, 0x080000, CRC(fcdb8416) SHA1(4afce0424b7d821b7d71872e5e9c535b5d06bcd3) )
	ROM_LOAD16_BYTE( "p3005p43.lo", 0x00001, 0x080000, CRC(bdc918ad) SHA1(b45f8652161b5feef7cf1990e6923c67bc6a41bc) )
	sc_crsc_others
ROM_END

ROM_START( sc5crscr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3005s01.hi", 0x00000, 0x080000, CRC(d2ac11c0) SHA1(948eb7d43d3109d099b4d89e16efdc947815ee47) )
	ROM_LOAD16_BYTE( "p3005s01.lo", 0x00001, 0x080000, CRC(ece251d2) SHA1(ed6f8e7ba379cefbff093b5fffb6b0764f284a9e) )
	sc_crsc_others
ROM_END

ROM_START( sc5crscs )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3005s41.hi", 0x00000, 0x080000, CRC(e036f445) SHA1(42781749d714e81a4ae48bbffbfe14c58d35906b) )
	ROM_LOAD16_BYTE( "p3005s41.lo", 0x00001, 0x080000, CRC(adde9f0c) SHA1(3292d987b179b4ea72aa3c13a3dca4ad74e038d9) )
	sc_crsc_others
ROM_END

ROM_START( sc5crsct )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3005s42.hi", 0x00000, 0x080000, CRC(eb3907d5) SHA1(3f6922c5e3938bb091194d6917bf896a66e73986) )
	ROM_LOAD16_BYTE( "p3005s42.lo", 0x00001, 0x080000, CRC(7dce5601) SHA1(f3dc52dafb104656014c743ba9ecf8e5917ca0a3) )
	sc_crsc_others
ROM_END

ROM_START( sc5crscu )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3005s43.hi", 0x00000, 0x080000, CRC(a29f5fe9) SHA1(78bb8e1699640d885634b53f2952ea77329da40b) )
	ROM_LOAD16_BYTE( "p3005s43.lo", 0x00001, 0x080000, CRC(93ee0022) SHA1(ee58ad5a04e1ecd89b5cc3236e986135fa422f12) )
	sc_crsc_others
ROM_END

ROM_START( ad5crsc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )

	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASE00 )
	ROM_LOAD( "39211581.bin", 0x0000, 0x1000000, CRC(4d451612) SHA1(ec892276b1bfa3d9e9d9d39a722e931c9ab55ec8) ) // PR2476 COPSNROB3
	ROM_LOAD( "39211616.bin", 0x0000, 0x1000000, CRC(181d4298) SHA1(c2b3f9123782d6315bb84be0cd51c3dbbc0da728) ) // PR2476 COPSNROB3
	ROM_LOAD( "39212581.bin", 0x0000, 0x1000000, CRC(8996b649) SHA1(e10b82bc7e1fcebe9742755e3a33c9abe75ba1fa) ) // PR2476 COPSNROB3
	ROM_LOAD( "39212616.bin", 0x0000, 0x1000000, CRC(d091476a) SHA1(db4f2f1a0bbd22f554265ce5330666f3b1a44862) ) // PR2476 COPSNROB3

	ROM_LOAD( "39211582.bin", 0x0000, 0x1000000, CRC(d208a456) SHA1(f53b77299cb85c5b0564b907b2ceb66de8206627) ) // PR2495 COPSNROB
	ROM_LOAD( "39211596.bin", 0x0000, 0x1000000, CRC(9814b1b7) SHA1(e6dc1a516f7f73acb1a78502c4baa6fe9589801d) ) // PR2495 COPSNROB
	ROM_LOAD( "39212582.bin", 0x0000, 0x1000000, CRC(599f5d55) SHA1(c4941d754b87ddbd58b19dd4edec2af3a5ddd821) ) // PR2495 COPSNROB
	ROM_LOAD( "39212596.bin", 0x0000, 0x1000000, CRC(1152f65c) SHA1(1406667c41e0ed8c07b65df95eb34ca6fe5a2708) ) // PR2495 COPSNROB

	ROM_LOAD( "39212606.bin", 0x0000, 0x1000000, CRC(7cfdeb40) SHA1(76e3583dc60464f6b8d503eb0c32d0bf81bc70d6) ) // PR2628 COPSNROB
ROM_END


ROM_START( sc5coro )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416526.lo", 0x00001, 0x080000, CRC(f3fedcd0) SHA1(6e76e41dcb2ec9a03947631b439e9dfb3b4959a1) )
	ROM_LOAD16_BYTE( "95416527.hi", 0x00000, 0x080000, CRC(254c9c7b) SHA1(7bcc8ad1e7755362b6873ad0ce84bf0ce8a64a09) )
	sc_coro_others
ROM_END

ROM_START( sc5coroa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416656.lo", 0x00001, 0x080000, CRC(ae8afdc5) SHA1(cec76e7c58533b573b06538558f3705a73793046) )
	ROM_LOAD16_BYTE( "95416657.hi", 0x00000, 0x080000, CRC(4a99a20a) SHA1(5c1aa9a114f0ff13ef4323ab7b4baf882b1c43da) )
	sc_coro_others
ROM_END

ROM_START( sc5corob )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416676.lo", 0x00001, 0x080000, CRC(93188ca9) SHA1(09298ed5c43329d539e96e44f01451eb6f9de62f) )
	ROM_LOAD16_BYTE( "95416677.hi", 0x00000, 0x080000, CRC(a1c79ca4) SHA1(dc0dab3bed7dff7746bf643748376fab145c62ff) )
	sc_coro_others
ROM_END

ROM_START( sc5coroc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416730.lo", 0x00001, 0x080000, CRC(526fffc9) SHA1(17daa8e30029f831835dcece9f5643669ce724f5) )
	ROM_LOAD16_BYTE( "95416731.hi", 0x00000, 0x080000, CRC(a6a3953f) SHA1(7405c27c31a2383330f59b4ec408ddcbe4d070ef) )
	sc_coro_others
ROM_END

ROM_START( sc5corod )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416738.lo", 0x00001, 0x080000, CRC(f6ba008f) SHA1(4acb808ea192354b1c7610f8e144a9e3e9da6699) )
	ROM_LOAD16_BYTE( "95416739.hi", 0x00000, 0x080000, CRC(ef9458d5) SHA1(816b4d02b657e9804b225fd13f4718f061d381a9) )
	sc_coro_others
ROM_END

ROM_START( sc5coroe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416758.lo", 0x00001, 0x080000, CRC(6c373887) SHA1(637a2013de57d269afb13648799a02ba2c4a8082) )
	ROM_LOAD16_BYTE( "95416759.hi", 0x00000, 0x080000, CRC(724b9d8a) SHA1(8310626686aa8aa61874812a8b9e8ab19445d428) )
	sc_coro_others
ROM_END

ROM_START( sc5corof )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416760.lo", 0x00001, 0x080000, CRC(66c192ae) SHA1(6da0ca25c6f7a1fd434d85ec905e65bbd9f427ce) )
	ROM_LOAD16_BYTE( "95416761.hi", 0x00000, 0x080000, CRC(bdcb5413) SHA1(9f481f3bb39497ae780f8c33f6eba0d36277b705) )
	sc_coro_others
ROM_END

ROM_START( sc5corog )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416810.lo", 0x00001, 0x080000, CRC(4c6f6ed6) SHA1(a3642a0ab1ce196ff9495c2a64dcb3c0ada90ee6) )
	ROM_LOAD16_BYTE( "95416811.hi", 0x00000, 0x080000, CRC(748ebac9) SHA1(a2b7447afe0e0e27a2e895ba17623d9d550b90af) )
	sc_coro_others
ROM_END

ROM_START( sc5coroh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416812.lo", 0x00001, 0x080000, CRC(eb2d17a6) SHA1(5c35d558213f0e41e401721ec23a8e1fd816ba85) )
	ROM_LOAD16_BYTE( "95416813.hi", 0x00000, 0x080000, CRC(f942c2ad) SHA1(26672aa648cd37af4565da2df07e52ca1cddae2b) )
	sc_coro_others
ROM_END

ROM_START( sc5coroi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416814.lo", 0x00001, 0x080000, CRC(c6d9f9f5) SHA1(13c9d0e59f3134d1334d04275991368f14befd4c) )
	ROM_LOAD16_BYTE( "95416815.hi", 0x00000, 0x080000, CRC(1f6f83cc) SHA1(6bd058c650c515d6a4611cbfba15e7a4e4f0083f) )
	sc_coro_others
ROM_END

ROM_START( sc5coroj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416816.lo", 0x00001, 0x080000, CRC(c124af64) SHA1(94b010a771bf5927547a271ef8e0adc9c22c7a30) )
	ROM_LOAD16_BYTE( "95416817.hi", 0x00000, 0x080000, CRC(862d2f44) SHA1(f5cf99aa8dc6bd28cf658e4f91bdd30b8987d2c0) )
	sc_coro_others
ROM_END

ROM_START( sc5corok )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416936.lo", 0x00001, 0x080000, CRC(e373dd40) SHA1(c4013c5257188defd2aee5d6e4735ad15bb2fe3e) )
	ROM_LOAD16_BYTE( "95416937.hi", 0x00000, 0x080000, CRC(7a35f640) SHA1(5a02a5a1757af08432051f4d0e3a50720e86961d) )
	sc_coro_others
ROM_END

ROM_START( sc5corol )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416938.lo", 0x00001, 0x080000, CRC(0d4c3a8b) SHA1(12feb437793964f91d7f7429f6ce4127452f5866) )
	ROM_LOAD16_BYTE( "95416939.hi", 0x00000, 0x080000, CRC(2c5c2f2f) SHA1(454d7ffc9a9f55a5395e1d863800897f2e2aaa6e) )
	sc_coro_others
ROM_END

ROM_START( sc5corom )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417526.lo", 0x00001, 0x080000, CRC(269dd109) SHA1(07b2850cdc31900c1201f06cdbd84094a6703026) )
	ROM_LOAD16_BYTE( "95417527.hi", 0x00000, 0x080000, CRC(9c854630) SHA1(b4960dca60d15f1622deb2b4cc8f62a8ab726f16) )
	sc_coro_others
ROM_END

ROM_START( sc5coron )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417676.lo", 0x00001, 0x080000, CRC(787c6632) SHA1(6a0a340747e11f6b3616e232c6ee9dba963d9692) )
	ROM_LOAD16_BYTE( "95417677.hi", 0x00000, 0x080000, CRC(6a1ec675) SHA1(e043b12f08ad8e9894cc5ee715a95571a3866b26) )
	sc_coro_others
ROM_END

ROM_START( sc5coroo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417730.lo", 0x00001, 0x080000, CRC(18b31ec3) SHA1(6137bef65eee9d0c7fced36ebf78bd0f73b79847) )
	ROM_LOAD16_BYTE( "95417731.hi", 0x00000, 0x080000, CRC(8715a2a4) SHA1(a3bdcdccc72a2e0ff5a0fab374b0de8fabf03c4e) )
	sc_coro_others
ROM_END

ROM_START( sc5corop )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417738.lo", 0x00001, 0x080000, CRC(c549318e) SHA1(5dec93f36a78aca538677c70d8ba5dab6959cd0f) )
	ROM_LOAD16_BYTE( "95417739.hi", 0x00000, 0x080000, CRC(05ab362d) SHA1(af3a39a05960d97d66f63eb8e671a38d14747e60) )
	sc_coro_others
ROM_END

ROM_START( sc5coroq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417758.lo", 0x00001, 0x080000, CRC(08f4c168) SHA1(3a03d712d8562022a506f81783d8ad7a5b8c55e2) )
	ROM_LOAD16_BYTE( "95417759.hi", 0x00000, 0x080000, CRC(b8c6280b) SHA1(e38227eca891af521e21e936df638e6e64edc0e1) )
	sc_coro_others
ROM_END

ROM_START( sc5coror )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417760.lo", 0x00001, 0x080000, CRC(be25eba1) SHA1(9173498cecafd6358e085197dc078a4844b276b4) )
	ROM_LOAD16_BYTE( "95417761.hi", 0x00000, 0x080000, CRC(515d9a6a) SHA1(4bd863d4314a925f63b72a97104c8e44d82d6414) )
	sc_coro_others
ROM_END

ROM_START( sc5coros )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417810.lo", 0x00001, 0x080000, CRC(18505dc2) SHA1(32ad173c0499763e0713a7b1ba5a006e3ddc3404) )
	ROM_LOAD16_BYTE( "95417811.hi", 0x00000, 0x080000, CRC(1af74a2a) SHA1(3a8662ca3f23df59475adb8110be7bee034a56e0) )
	sc_coro_others
ROM_END

ROM_START( sc5corot )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417812.lo", 0x00001, 0x080000, CRC(66b63a1e) SHA1(10f87531b2e6483340cd2ac08b9987279c4af491) )
	ROM_LOAD16_BYTE( "95417813.hi", 0x00000, 0x080000, CRC(8f704da7) SHA1(cac038ba2b9029af44ca3cdebe19ef3890a60147) )
	sc_coro_others
ROM_END

ROM_START( sc5corou )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417814.lo", 0x00001, 0x080000, CRC(132c0444) SHA1(15aab0ed9a72799c1004c91444e655d4df528c2d) )
	ROM_LOAD16_BYTE( "95417815.hi", 0x00000, 0x080000, CRC(8cf8d353) SHA1(a5da98401a0b06537c1656d09a3fce27b56d5870) )
	sc_coro_others
ROM_END

ROM_START( sc5corov )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417816.lo", 0x00001, 0x080000, CRC(230cefc3) SHA1(7b2c0c5617243a58fe3f53647f062aa0f573c935) )
	ROM_LOAD16_BYTE( "95417817.hi", 0x00000, 0x080000, CRC(18cdfe08) SHA1(7ae92e7429d0cd0c197a1fead8cce222cf00b83a) )
	sc_coro_others
ROM_END

ROM_START( sc5corow )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417936.lo", 0x00001, 0x080000, CRC(d3d45e47) SHA1(3dede274c492941c8ca7e0898e262d2b99ec912b) )
	ROM_LOAD16_BYTE( "95417937.hi", 0x00000, 0x080000, CRC(4b0bef9d) SHA1(b9f388ad48b8697ac1c362ddab2b6e314c46e784) )
	sc_coro_others
ROM_END

ROM_START( sc5corox )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417938.lo", 0x00001, 0x080000, CRC(26e3bdad) SHA1(2715535a0f0c2f876c3c1d3d7840d50bf1cb7248) )
	ROM_LOAD16_BYTE( "95417939.hi", 0x00000, 0x080000, CRC(417671ed) SHA1(571f57ad2438257cbe517fc618fa12b2de1c808c) )
	sc_coro_others
ROM_END

ROM_START( sc5coroy )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420088.lo", 0x00001, 0x080000, CRC(652cd122) SHA1(b0d30d6cfc400acbca7b3bafffd899bb82d0b45d) )
	ROM_LOAD16_BYTE( "95420089.hi", 0x00000, 0x080000, CRC(46020943) SHA1(1cd98dfea87128ecdbaaa014c5136c86ee26980c) )
	sc_coro_others
ROM_END

ROM_START( sc5coroz )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420196.lo", 0x00001, 0x080000, CRC(2d71befb) SHA1(a2f83f4a03d8a16d50a7036daca00ffd4e788b93) )
	ROM_LOAD16_BYTE( "95420197.hi", 0x00000, 0x080000, CRC(68fe0186) SHA1(e3b429f3511adb2b75db42193ba67b39dcc30210) )
	sc_coro_others
ROM_END

ROM_START( sc5coro0 )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421088.lo", 0x00001, 0x080000, CRC(28594ba6) SHA1(6d7edd190b16e6097ceee416af06ea285bf15ae8) )
	ROM_LOAD16_BYTE( "95421089.hi", 0x00000, 0x080000, CRC(c39b593e) SHA1(3af0074084576fba592676c897089dfce9838e37) )
	sc_coro_others
ROM_END

ROM_START( sc5coro1 )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421196.lo", 0x00001, 0x080000, CRC(41474b13) SHA1(d6508367555aa2bb8213d6cb1855299356d6233b) )
	ROM_LOAD16_BYTE( "95421197.hi", 0x00000, 0x080000, CRC(8b175da8) SHA1(ab7503a44edbbe84113bf8411d9c8742cedf8d27) )
	sc_coro_others
ROM_END




ROM_START( sc5count )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1909p13.hi", 0x00000, 0x080000, CRC(bf5b9f9d) SHA1(d9d32838a58440da9921da4b48cff02e76efbf5b) )
	ROM_LOAD16_BYTE( "p1909p13.lo", 0x00001, 0x080000, CRC(3386377d) SHA1(3ae1fdac56cea2dd42038992c0f8dfc33f7a730d) )
	sc_count_others
ROM_END

ROM_START( sc5counta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1909s13.hi", 0x00000, 0x080000, CRC(93f8e60c) SHA1(96b0125de0145eceaf077e96b5d1cc4b91f4af72) )
	ROM_LOAD16_BYTE( "p1909s13.lo", 0x00001, 0x080000, CRC(bd50fdf2) SHA1(6d144adf57d48bef29dda5b6f8ecd18011f7febf) )
	sc_count_others
ROM_END



ROM_START( sc5czfr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424544.lo", 0x00001, 0x080000, CRC(287d95b9) SHA1(c820b9913d35171ecda22baf77d85ab8ecd8cf7a) )
	ROM_LOAD16_BYTE( "95424545.hi", 0x00000, 0x080000, CRC(2b66c83f) SHA1(f47f4b1b9241d1dbc2f5d20d283ed0891484e494) )
	sc_czfr_others
ROM_END

ROM_START( sc5frcrza )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424546.lo", 0x00001, 0x080000, CRC(57d3e455) SHA1(f0ee335a9d56364aa5c64b2c20dcdef06aa0f5a5) )
	ROM_LOAD16_BYTE( "95424547.hi", 0x00000, 0x080000, CRC(b9aa92e1) SHA1(3364253fd3e1c5b61a66080ce9a2e21047fb6d8b) )
	sc_czfr_others
ROM_END

ROM_START( sc5frcrz )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425546.lo", 0x00001, 0x080000, CRC(b503d236) SHA1(643cf63185ad796a2c5c3ca6900b2105d00c4f00) )
	ROM_LOAD16_BYTE( "95425547.hi", 0x00000, 0x080000, CRC(4261825a) SHA1(41842a1416ff1b1603881c166904df5ef2ebeedd) )
	sc_czfr_others
ROM_END



ROM_START( sc5crnjw )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412722.lo", 0x00001, 0x080000, CRC(3a6af4a3) SHA1(ca49bb59a3f6ae748dcbfcf1a9b5802647cdef06) )
	ROM_LOAD16_BYTE( "95412723.hi", 0x00000, 0x080000, CRC(29959756) SHA1(2197c2b81777ec3053a314c491effce064c4ce29) )
	sc_crnjw_others
ROM_END

ROM_START( sc5crnjwa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413722.lo", 0x00001, 0x080000, CRC(1fb92642) SHA1(9cb3a432841fcdd5e863a5c77a431299c2a534f8) )
	ROM_LOAD16_BYTE( "95413723.hi", 0x00000, 0x080000, CRC(e3bd347d) SHA1(02a996e7f2e81f12b0d05810370763ea02c7bf6c) )
	sc_crnjw_others
ROM_END

ROM_START( sc5crnjwb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "c_jewels.hi", 0x00000, 0x080000, CRC(b1ddedd3) SHA1(e5eb9f25a4e385e17c97c1fd67cba991c5f832bd) )
	ROM_LOAD16_BYTE( "c_jewels.lo", 0x00001, 0x080000, CRC(3e8812bc) SHA1(66ad13ef56a6d95a82565e3de53b199f0426a156) )
	sc_crnjw_others
ROM_END

ROM_START( sc5cjqps )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95426714.lo", 0x00001, 0x080000, CRC(c2d3f6d6) SHA1(fb5532a9f23c7f9740d55eb411f543b75e3b8ae6) )
	ROM_LOAD16_BYTE( "g95426715.hi", 0x00000, 0x080000, CRC(bd812886) SHA1(2452499bc7c6ca51e8f6ed53c182a756e90bf9a0) )
	PR000055_CJEWELS
ROM_END

ROM_START( sc5cjqpsa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95426894.lo", 0x00001, 0x080000, CRC(cc1d8324) SHA1(aae871fb7400e661f60f174491f4f2192dd12ebd) )
	ROM_LOAD16_BYTE( "g95426895.hi", 0x00000, 0x080000, CRC(40820ce7) SHA1(e65c939563acd9ebe2d342116f884418b5562279) )
	PR000055_CJEWELS
ROM_END

ROM_START( sc5cjqpsb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95427714.lo", 0x00001, 0x080000, CRC(1866575e) SHA1(7f772562a7a2d961777c5df55e4a62931934522e) )
	ROM_LOAD16_BYTE( "g95427715.hi", 0x00000, 0x080000, CRC(db62827f) SHA1(96086d1976e443d026fc9534d861f3117b2d901a) )
	PR000055_CJEWELS
ROM_END

ROM_START( sc5cjqpsc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95427894.lo", 0x00001, 0x080000, CRC(f18d39dd) SHA1(9633a857faa91cde927978bc3d06c2b1840d65ec) )
	ROM_LOAD16_BYTE( "g95427895.hi", 0x00000, 0x080000, CRC(961802c6) SHA1(ae8da626d508e4a7697ef1911c2183da97b0f0cc) )
	PR000055_CJEWELS
ROM_END



ROM_START( sc5dnd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418428.lo", 0x00001, 0x080000, CRC(e3402379) SHA1(54eb1c75e174083fb6e913c231706fd192ca8b22) )
	ROM_LOAD16_BYTE( "95418429.hi", 0x00000, 0x080000, CRC(a7c8a115) SHA1(987485c9db6b9e05b6fc60307535533a931db7f2) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndcs )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418446.lo", 0x00001, 0x080000, CRC(bb3df08e) SHA1(d1ae172cff3776b008d1b08772e2589dcc06f75e) )
	ROM_LOAD16_BYTE( "95418447.hi", 0x00000, 0x080000, CRC(03ade18d) SHA1(c74f431245c1854577232c1c10b3a9868e59d38f) )
	PR1954_CASINO_DOND_R_SOUNDS11
ROM_END

ROM_START( sc5dndcsa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418582.lo", 0x00001, 0x080000, CRC(e77addb2) SHA1(37655aba352008d468b0b155a8178addf1f1bb85) )
	ROM_LOAD16_BYTE( "95418583.hi", 0x00000, 0x080000, CRC(01c82328) SHA1(367ae0f2b4b08d194c567ea48f4576f68c921dde) )
	PR1954_CASINO_DOND_R_SOUNDS11
ROM_END

ROM_START( sc5dndcsb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418610.lo", 0x00001, 0x080000, CRC(6b25fe94) SHA1(f926758df4fceb8422fb6165497d5353cb51355b) )
	ROM_LOAD16_BYTE( "95418611.hi", 0x00000, 0x080000, CRC(b1dd987d) SHA1(46e8e8015da8cdee87c202fbdfaf5b5ab157fcef) )
	PR1954_CASINO_DOND_R_SOUNDS11
ROM_END


ROM_START( sc5dndcsc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418740.lo", 0x00001, 0x080000, CRC(d1cc7151) SHA1(c350c2a61e6dc927fdde3f57dadf07ffb7a74172) )
	ROM_LOAD16_BYTE( "95418741.hi", 0x00000, 0x080000, CRC(369f411b) SHA1(e24e60c2707a99e664b049bb2bace837423871ab) )
	PR1954_CASINO_DOND_R_SOUNDS11
ROM_END

ROM_START( sc5dndcsd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419446.lo", 0x00001, 0x080000, CRC(7f5dc09c) SHA1(022d368063398c3ec206c5576fff54e20ffc73c3) )
	ROM_LOAD16_BYTE( "95419447.hi", 0x00000, 0x080000, CRC(dd8b1ee5) SHA1(8d59e3f762dd4338706017d1717d06a7a718fbd9) )
	PR1954_CASINO_DOND_R_SOUNDS11
ROM_END

ROM_START( sc5dndcse )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419582.lo", 0x00001, 0x080000, CRC(43e7545f) SHA1(53356002ab07f5e9e1df13eef1f1b65c44a9b7b7) )
	ROM_LOAD16_BYTE( "95419583.hi", 0x00000, 0x080000, CRC(39bf2015) SHA1(1884f7f79c5e6cc6b78929d7f4e743dd02fceddc) )
	PR1954_CASINO_DOND_R_SOUNDS11
ROM_END

ROM_START( sc5dndcsf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419610.lo", 0x00001, 0x080000, CRC(cfb87779) SHA1(c8df9cce5f3bc58fad35702f653f1ea5613f3cac) )
	ROM_LOAD16_BYTE( "95419611.hi", 0x00000, 0x080000, CRC(89aa9b40) SHA1(1369d2c92b41ecbf930c67adc1ca1ff74896d85c) )
	PR1954_CASINO_DOND_R_SOUNDS11
ROM_END

ROM_START( sc5dndcsg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419740.lo", 0x00001, 0x080000, CRC(be5583a6) SHA1(62889d112060f7876fee9d88315a6f6082ac3a81) )
	ROM_LOAD16_BYTE( "95419741.hi", 0x00000, 0x080000, CRC(d051eb76) SHA1(7fb107cfdd628f2196e15b98b38eb90540883ddf) )
	PR1954_CASINO_DOND_R_SOUNDS11
ROM_END

ROM_START( sc5dndcsh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423940.lo", 0x00001, 0x080000, CRC(845e82af) SHA1(7ebbe59e8eafc3517806e72fd759a61da282e5fc) )
	ROM_LOAD16_BYTE( "95423941.hi", 0x00000, 0x080000, CRC(2aef2c9a) SHA1(8a940c6f6f3fe4ee6625012cf61bde7b78260ddd) )
	PR1954_CASINO_DOND_R_SOUNDS11
ROM_END

ROM_START( sc5dndcsi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426464.lo", 0x00001, 0x080000, CRC(6dbb8ceb) SHA1(f79bc7f047ab5fca012d1d92672d34309ec159dc) )
	ROM_LOAD16_BYTE( "95426465.hi", 0x00000, 0x080000, CRC(89e9b45c) SHA1(246e69129bc80ec0263be7cd6dd02f859f550606) )
	PR1954_CASINO_DOND_R_SOUNDS11
ROM_END

ROM_START( sc5dndcsj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427464.lo", 0x00001, 0x080000, CRC(ab9bc5f4) SHA1(c36f5b6acdce0432c0227832618cb0ab8fec3dd2) )
	ROM_LOAD16_BYTE( "95427465.hi", 0x00000, 0x080000, CRC(a744775e) SHA1(78591fa7a4c733a456d442903003e4dc3ab7ba8d) )
	PR1954_CASINO_DOND_R_SOUNDS11
ROM_END

ROM_START( sc5dndc3 )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418624.lo", 0x00001, 0x080000, CRC(d92cc819) SHA1(dbb5879b5290d3c217b237bd4c59865cf57e154c) )
	ROM_LOAD16_BYTE( "95418625.hi", 0x00000, 0x080000, CRC(52f037cf) SHA1(0a4b8b2937577b103cf1e4eb47234687aae643c3) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dnda )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418626.lo", 0x00001, 0x080000, CRC(8825bac7) SHA1(b732499056718e0002e69ad92fd1a0dc1ddecfee) )
	ROM_LOAD16_BYTE( "95418627.hi", 0x00000, 0x080000, CRC(38dde058) SHA1(74c729a4f7597a38ed645a638d1f09ab13b1fa93) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndc3a )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418708.lo", 0x00001, 0x080000, CRC(30a98bc2) SHA1(5caf982d2853ce39294445ab89474906e2e41981) )
	ROM_LOAD16_BYTE( "95418709.hi", 0x00000, 0x080000, CRC(9c657c50) SHA1(e72296e193693c3a9ff33632fb0db9c64fe75a97) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END


ROM_START( sc5dndb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419428.lo", 0x00001, 0x080000, CRC(72a46f10) SHA1(933a5990fbe1ede6f3527315d8ea111e2814fa83) )
	ROM_LOAD16_BYTE( "95419429.hi", 0x00000, 0x080000, CRC(7aadaaed) SHA1(19c452644db9da1ed5741173473b23a95e2133f5) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END


ROM_START( sc5dndc3b )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419624.lo", 0x00001, 0x080000, CRC(ac6733b8) SHA1(7f67cdf1b3b8d3ac5d2424aadd9c81fe8340f613) )
	ROM_LOAD16_BYTE( "95419625.hi", 0x00000, 0x080000, CRC(a3733571) SHA1(3bbf7087b8446120f2f3e8d664efef5196ce9b0d) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419626.lo", 0x00001, 0x080000, CRC(17b5d2ad) SHA1(7068b73fb1ec4a56d7121be4e548674ad2bb7ef6) )
	ROM_LOAD16_BYTE( "95419627.hi", 0x00000, 0x080000, CRC(39e34c28) SHA1(b75456e108c8acf363cd83f80be294b6bfecce90) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndc3c )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419708.lo", 0x00001, 0x080000, CRC(2c553048) SHA1(6c550e359226386612163f0a018ce20c66af530a) )
	ROM_LOAD16_BYTE( "95419709.hi", 0x00000, 0x080000, CRC(872d1f42) SHA1(bb249b3aadfb8448d144f36bbda7397ff7464057) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END


ROM_START( sc5dndd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422024.lo", 0x00001, 0x080000, CRC(b5481bbb) SHA1(43e6e81e0ddcf6f2bf6bf301348cf17f37ec7d6c) )
	ROM_LOAD16_BYTE( "95422025.hi", 0x00000, 0x080000, CRC(8a28b1a4) SHA1(bc895c4e3061f95c3136437df30a5d88df794146) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END


ROM_START( sc5dnde )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422564.lo", 0x00001, 0x080000, CRC(1f63b69b) SHA1(733cb1959e4f63b7a45ba39e93375d49271cc2ba) )
	ROM_LOAD16_BYTE( "95422565.hi", 0x00000, 0x080000, CRC(dbf27ae1) SHA1(4bd2be6f2fccf050bbbd2ea4d0a5b4246ca9da2c) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422568.lo", 0x00001, 0x080000, CRC(2999d09e) SHA1(806275be7850b48332fdb85f4d78e616a16c12ab) )
	ROM_LOAD16_BYTE( "95422569.hi", 0x00000, 0x080000, CRC(273c2338) SHA1(b44e176fa97b40975825cdb6b3f8dfa753535162) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422832.lo", 0x00001, 0x080000, CRC(44fbc398) SHA1(dc84091f82a718401c967c25ffe756ae1186a38d) )
	ROM_LOAD16_BYTE( "95422833.hi", 0x00000, 0x080000, CRC(80729e3f) SHA1(6d5fd934548c6254ed2ec9c9c77ffcce1eca039b) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422862.lo", 0x00001, 0x080000, CRC(41f7ba62) SHA1(a7ad0dfdc477194e09df97331b75309c7aa976ea) )
	ROM_LOAD16_BYTE( "95422863.hi", 0x00000, 0x080000, CRC(a7883de1) SHA1(812b17621f3ac4b0252b44ec32b81145b4212637) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422886.lo", 0x00001, 0x080000, CRC(1b926605) SHA1(f97b91c73dd330f1848a879faf949085c23d53b6) )
	ROM_LOAD16_BYTE( "95422887.hi", 0x00000, 0x080000, CRC(5f37e87a) SHA1(f1b86a3fb968be14787fb508d1fccb464cec2c4d) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423024.lo", 0x00001, 0x080000, CRC(a825a790) SHA1(5bb676900881c93ef885e72c07a29b001a911a09) )
	ROM_LOAD16_BYTE( "95423025.hi", 0x00000, 0x080000, CRC(a98a0ead) SHA1(e1624b73b4f058edcdc3aa49f6ea55afd642938c) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END



ROM_START( sc5dndk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423564.lo", 0x00001, 0x080000, CRC(13a2bc2d) SHA1(646dd4abff1c2a7f08aabcde1aa7850505f0893f) )
	ROM_LOAD16_BYTE( "95423565.hi", 0x00000, 0x080000, CRC(aa269dbc) SHA1(7b91147ebbc48d1ff6a79d16b381989db829add8) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423832.lo", 0x00001, 0x080000, CRC(62329f06) SHA1(7d531a7afaa0e7a04969afb4f1ef765f8552af3d) )
	ROM_LOAD16_BYTE( "95423833.hi", 0x00000, 0x080000, CRC(ae915afa) SHA1(20938b42fa53c04ea4ac0eb563615bd1ce6f0725) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423862.lo", 0x00001, 0x080000, CRC(758f1697) SHA1(ca40ee7d8f9d32745e1fb26f1d08fc3d7f9857f4) )
	ROM_LOAD16_BYTE( "95423863.hi", 0x00000, 0x080000, CRC(9ce6e813) SHA1(55ab2bba5b2bb356807e9b0182d5260b1b6efa10) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423886.lo", 0x00001, 0x080000, CRC(6e0b8c7e) SHA1(cac697895f0a8a7d3a31389b7719a54eb300f465) )
	ROM_LOAD16_BYTE( "95423887.hi", 0x00000, 0x080000, CRC(8b04bb99) SHA1(fea2cd96a2cc0f7bf5439020a2fbc35ee26cc558) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END


ROM_START( sc5dndo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426152.lo", 0x00001, 0x080000, CRC(b304710b) SHA1(443568b0acc8381992a1a8bfe77c9bed714fb05c) )
	ROM_LOAD16_BYTE( "95426153.hi", 0x00000, 0x080000, CRC(f02a1df7) SHA1(9fc0fc6ecc5287012cf9ad2e01c4781f91b9541c) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426168.lo", 0x00001, 0x080000, CRC(be51f52d) SHA1(e61b385c52ea1f2dca2c615518f9a419075d1a4e) )
	ROM_LOAD16_BYTE( "95426169.hi", 0x00000, 0x080000, CRC(c4c30953) SHA1(33645e956be7c5367dfab4704a7c8fbdd79f4126) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427152.lo", 0x00001, 0x080000, CRC(58da107f) SHA1(297916acc353ac2c70218b84a5ed870513d649f1) )
	ROM_LOAD16_BYTE( "95427153.hi", 0x00000, 0x080000, CRC(6f0b8161) SHA1(41f2454b05fb226720a813626b387b8f29a7e203) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427168.lo", 0x00001, 0x080000, CRC(3f2659e2) SHA1(37db9a4c54fb790a5d4bc7b335c4b92e1d88261e) )
	ROM_LOAD16_BYTE( "95427169.hi", 0x00000, 0x080000, CRC(af31b846) SHA1(ac168ce36c09f1770520a2a9d3f4ace88f97c463) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dnds )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422028.lo", 0x00001, 0x080000, CRC(55ecfc66) SHA1(ba6b8befe37318ecec9cce1ea3029afa701f1cff) )
	ROM_LOAD16_BYTE( "95422029.hi", 0x00000, 0x080000, CRC(d53e86be) SHA1(72f1b6b21f284b27bd63fcea90826a88c6b16bef) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END

ROM_START( sc5dndt )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423028.lo", 0x00001, 0x080000, CRC(6a81fb48) SHA1(9e75c7601efd70aa91f9306b0ffd8d0a515912f6) )
	ROM_LOAD16_BYTE( "95423029.hi", 0x00000, 0x080000, CRC(29828640) SHA1(a90ae840318f4ea3d662645735a352d0e7382b6b) )
	PR1907_DEAL_OR_NO_DEAL_SOUNDS11
ROM_END


ROM_START( sc5dndc2 )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422440.lo", 0x00001, 0x080000, CRC(a4c27e23) SHA1(1de762b8e78da0249c36316f3af25c5c2ee1c68f) )
	ROM_LOAD16_BYTE( "95422441.hi", 0x00000, 0x080000, CRC(7a8e9785) SHA1(4510a86664d6c50c1b62d63c679fde203bfb31ef) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2e )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422442.lo", 0x00001, 0x080000, CRC(77d044a9) SHA1(e13af74b1aa5a35e0a041607ea4fd9a3e472c173) )
	ROM_LOAD16_BYTE( "95422443.hi", 0x00000, 0x080000, CRC(1b40f9e2) SHA1(1bdeeb429e4669964d805d3cb0f22038427dd567) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2f )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422450.lo", 0x00001, 0x080000, CRC(d300fe2c) SHA1(f2a5770d5c51a316fdbe31fa588eaccf94cb6639) )
	ROM_LOAD16_BYTE( "95422451.hi", 0x00000, 0x080000, CRC(af1e0a64) SHA1(e494bb57cb26100ce31b9ef2b9ab1963d434973d) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2a )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423440.lo", 0x00001, 0x080000, CRC(214d9f3a) SHA1(bf693dd08db022b51123dc0fdb07d16315444be0) )
	ROM_LOAD16_BYTE( "95423441.hi", 0x00000, 0x080000, CRC(4558b059) SHA1(cd37a546499b7314614edffb3e9f311cbcf8b510) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2g )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423442.lo", 0x00001, 0x080000, CRC(a3b28d50) SHA1(42646bc8b3f8d36e9450f74fa7f77a67e60f82cc) )
	ROM_LOAD16_BYTE( "95423443.hi", 0x00000, 0x080000, CRC(0fb14bef) SHA1(3c80f62f86e0e248e8cc9cefc94e4d12c9cf63ca) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2h )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423450.lo", 0x00001, 0x080000, CRC(6c884748) SHA1(72b458ef784c380d06074c3c5ae3dcbadd896307) )
	ROM_LOAD16_BYTE( "95423451.hi", 0x00000, 0x080000, CRC(f25bf41d) SHA1(47324b8c747405d68b193ca376929b3e49225037) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2i )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964p01.hi", 0x00000, 0x080000, CRC(b99ee66e) SHA1(3f0a046661070b29604e85e29c233b31e5de1c83) )
	ROM_LOAD16_BYTE( "p1964p01.lo", 0x00001, 0x080000, CRC(50480af0) SHA1(fbd5dd20e7e23700d4e039a1a9b17e8d83b86421) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2q )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964p12.hi", 0x00000, 0x080000, CRC(44c95076) SHA1(aa0bd2dff04e5d1c8973612fb57c88095eb2b40e) )
	ROM_LOAD16_BYTE( "p1964p12.lo", 0x00001, 0x080000, CRC(fcf337ed) SHA1(fc4bf9d1564e54f23f4d9c216c1ec2587c846c47) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2r )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964p13.hi", 0x00000, 0x080000, CRC(84e732e0) SHA1(80bb7f1046791f94f895fa14b4c5fc7b768e81db) )
	ROM_LOAD16_BYTE( "p1964p13.lo", 0x00001, 0x080000, CRC(6028bc0d) SHA1(f060e2bd4ad362a6e99ccc44b965fc1d5389e137) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2b )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964p14.hi", 0x00000, 0x080000, CRC(7af2660b) SHA1(692532287053cc899bcf94bebb5526fda5e094b4) )
	ROM_LOAD16_BYTE( "p1964p14.lo", 0x00001, 0x080000, CRC(f2786267) SHA1(a7fcfe231284c142a8bdb6a4361b5bcff9cf168b) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2u )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964p21.hi", 0x00000, 0x080000, CRC(a32b78aa) SHA1(1acd470d7023dfce9a88f74cf28cce939dac4d5b) )
	ROM_LOAD16_BYTE( "p1964p21.lo", 0x00001, 0x080000, CRC(e8dc4915) SHA1(d1ba8c081cf2ea3fd95e7a8d296239e18fde9908) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2c )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964pa2.hi", 0x00000, 0x080000, CRC(039d2202) SHA1(74dff4553a67cde468655b849f67c08f9bbeba00) )
	ROM_LOAD16_BYTE( "p1964pa2.lo", 0x00001, 0x080000, CRC(d59725a5) SHA1(50babe37853e776c88e2be9b44a4422e3391f2dc) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2n )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964pa3.hi", 0x00000, 0x080000, CRC(a1dab479) SHA1(2be3549906ac681842a5269e6014e78cc95715e4) )
	ROM_LOAD16_BYTE( "p1964pa3.lo", 0x00001, 0x080000, CRC(24cb5334) SHA1(e0c1d3ad6ca14a9ab66531dabf70f2cc4c7d2166) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2j )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964pa5.hi", 0x00000, 0x080000, CRC(d3a4858d) SHA1(bb818752ae761c7ff379df4903eb2771b05d059f) )
	ROM_LOAD16_BYTE( "p1964pa5.lo", 0x00001, 0x080000, CRC(dc8a4f2b) SHA1(18883c15fb9ed19a3ee7b436fa8327be942fdd29) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2p )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964pb1.hi", 0x00000, 0x080000, CRC(658e3793) SHA1(4b142c79031d053a614c62c964e02645bb6d28dd) )
	ROM_LOAD16_BYTE( "p1964pb1.lo", 0x00001, 0x080000, CRC(04eface9) SHA1(7a3f93c63d6cfa5b7814d76fd875f704ec617df4) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2k )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964s01.hi", 0x00000, 0x080000, CRC(d0fcdf89) SHA1(00ff2b7131ec0f3d87f58aa843f9a1aad2c33f61) )
	ROM_LOAD16_BYTE( "p1964s01.lo", 0x00001, 0x080000, CRC(549c0843) SHA1(f706cbc7be60a1261304398d876ef10ad695ad5d) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2s )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964s12.hi", 0x00000, 0x080000, CRC(f4d29330) SHA1(b86e601fb176ed963d6ef68e76f4d306b595e911) )
	ROM_LOAD16_BYTE( "p1964s12.lo", 0x00001, 0x080000, CRC(6efc8f49) SHA1(b13bd8f7f740f27a79c583d51c398c481081ea81) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2t )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964s13.hi", 0x00000, 0x080000, CRC(45935f32) SHA1(25d5411d8d247075ee3421f65e2d2a6c51451848) )
	ROM_LOAD16_BYTE( "p1964s13.lo", 0x00001, 0x080000, CRC(1ae19e19) SHA1(05e0ee034e7185b51f0e1b6ef77ae8670b020cbf) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2w )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964s14.hi", 0x00000, 0x080000, CRC(14319187) SHA1(9f678b14287c96dc586259d1a6ecda91cc62e434) )
	ROM_LOAD16_BYTE( "p1964s14.lo", 0x00001, 0x080000, CRC(24e13c44) SHA1(53e0c49e510245615bb6cd5acf6bf5b8cc8de173) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2v )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964s21.hi", 0x00000, 0x080000, CRC(0a12b6c4) SHA1(4a5ff6647d3e63aaf917d9d21dabe270dab179d1) )
	ROM_LOAD16_BYTE( "p1964s21.lo", 0x00001, 0x080000, CRC(e77a2694) SHA1(1cdcf91b5a7d6ec252af19930c9533798e1679a6) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2d )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964sa2.hi", 0x00000, 0x080000, CRC(361beeff) SHA1(cbd6aa20247df7b9e540b38b7e9199e557f62be7) )
	ROM_LOAD16_BYTE( "p1964sa2.lo", 0x00001, 0x080000, CRC(491d0137) SHA1(e5ad054adc7bbbb89bf7112d564f51b3c1924afa) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2m )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964sa3.hi", 0x00000, 0x080000, CRC(fcf198da) SHA1(60280812fd7148edfe52eb07f2c81b77384641a9) )
	ROM_LOAD16_BYTE( "p1964sa3.lo", 0x00001, 0x080000, CRC(be729a5a) SHA1(34d29c9d041b97a008112f6c18a194767f1839ca) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2l )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964sa5.hi", 0x00000, 0x080000, CRC(6e97cb56) SHA1(a6335601c8163430be430cff6d075562cc49200b) )
	ROM_LOAD16_BYTE( "p1964sa5.lo", 0x00001, 0x080000, CRC(80d9d806) SHA1(ae089e2618e80dac8afbb5b97b9c75512974488a) )
	PR1964_DND
ROM_END

ROM_START( sc5dndc2o )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1964sb1.hi", 0x00000, 0x080000, CRC(03c6811c) SHA1(32ea6379932589076dec0bbdf5c9255c374ec334) )
	ROM_LOAD16_BYTE( "p1964sb1.lo", 0x00001, 0x080000, CRC(7254d4b6) SHA1(7f4ef8e05fddc1d03c3073ae7b3cb5894200a039) )
	PR1964_DND
ROM_END


ROM_START( ad5dnd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )

	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASE00 )
	ROM_LOAD( "39211141.bin", 0x0000, 0x1000000, CRC(ef885c23) SHA1(bf874a7d5df40bc89a77aeaf6e9fb849360efbb5) ) // PR1965 CASINO TRIPLE
	ROM_LOAD( "39211152.bin", 0x0000, 0x1000000, CRC(2d9c8289) SHA1(c983a0ea439cd3281c6e9f39292ac9597055b385) )
	ROM_LOAD( "39211161.bin", 0x0000, 0x1000000, CRC(2c3e8205) SHA1(dd55563acf8390d4b75672c2aa91e373b27ac841) )
	ROM_LOAD( "39211162.bin", 0x0000, 0x1000000, CRC(6ec309e4) SHA1(5e3bd4b7c3bd4714ac642642fbe918b0a12e2fff) )
	ROM_LOAD( "39212141.bin", 0x0000, 0x1000000, CRC(cd2b9a5c) SHA1(ce616657c0caec5b7a4418acd6c7af008e04fd9d) )
	ROM_LOAD( "39212152.bin", 0x0000, 0x1000000, CRC(ddc8ec20) SHA1(b009420fd3ba202b9cf1782b44e682de0c706cb8) )
	ROM_LOAD( "39212153.bin", 0x0000, 0x1000000, CRC(7dee1072) SHA1(03f28c90a594b909255d8fb4bf2cdaba2f70c60b) )
	ROM_LOAD( "39212161.bin", 0x0000, 0x1000000, CRC(5e5d63f4) SHA1(116a90f124700d434d0b7291451ee8759b3ca0d0) )
	ROM_LOAD( "39212162.bin", 0x0000, 0x1000000, CRC(b55998b9) SHA1(925a311954b1c0daf9f38eaaac33d861eb6259df) )
	ROM_LOAD( "p1965p01.bin", 0x0000, 0x1000000, CRC(2f0777f1) SHA1(30d6b3f4a38114fcb51203f86b2784e67b9f7d52) )
	ROM_LOAD( "p1965p12.bin", 0x0000, 0x1000000, CRC(3a5e9a27) SHA1(73decbe70f15329844c78b81052657523302fcbc) )
	ROM_LOAD( "p1965s01.bin", 0x0000, 0x1000000, CRC(1d9c2051) SHA1(e70c414e95995fcbce800e2a16049d3550ae6d1c) )
	ROM_LOAD( "p1965s12.bin", 0x0000, 0x1000000, CRC(c4f520a3) SHA1(ed2655cf024f6c1d2579701cc24b606ca7be05ae) )

	ROM_LOAD( "p1945p41.bin", 0x0000, 0x1000000, CRC(f8fbf79e) SHA1(1c1c351443373a1cf95c9ec3fe95f4b84645ece9) ) // PR1945 VIDEO CASINO DOND
	ROM_LOAD( "p1945p42.bin", 0x0000, 0x1000000, CRC(7a95bf89) SHA1(274feb54f50a59a8dc1352cee27e4330b58431dd) )
	ROM_LOAD( "p1945p43.bin", 0x0000, 0x1000000, CRC(a0fc0903) SHA1(c51fda41eb3effd1f7052050a1104fc7fa9bfcbf) )
	ROM_LOAD( "p1945s41.bin", 0x0000, 0x1000000, CRC(f2767208) SHA1(7efcfc2456843c20c64185e4aed13067383e3f7a) )
	ROM_LOAD( "p1945s42.bin", 0x0000, 0x1000000, CRC(40f970c4) SHA1(59edf22b239686184a6170766969e0c6ec4f5a0e) )
	ROM_LOAD( "p1945s43.bin", 0x0000, 0x1000000, CRC(8c6dcf0e) SHA1(6503c58453f589077316d8bf3c5d07777fea0fdd) )

	ROM_LOAD( "39211171.bin", 0x0000, 0x1000000, CRC(a80f967a) SHA1(bc8dc5c2d30ec38a9119d577114f5e5813f38749) ) // PR3078 DOND
	ROM_LOAD( "39212171.bin", 0x0000, 0x1000000, CRC(666fe2b4) SHA1(8baf5f8682f3937b4b49f8db93f3a21e8764c990) )

	ROM_LOAD( "p1945p12.bin", 0x00000, 0x1000000, CRC(31ea70d9) SHA1(8e165132ecd48b5ea178e9b806944cc2fcd36f28) )
    ROM_LOAD( "p1945s12.bin", 0x00000, 0x1000000, CRC(08235fa0) SHA1(b9482c6e65ad602f01f881156e83a5a475745642) )

	ROM_REGION( 0x1000000, "ymz", ROMREGION_ERASE00 )
	PR1945_CASINO_D_O_N_D_SOUNDS11
	PR1945_CASINO_DOND_R_SOUNDS12
ROM_END

ROM_START( sc5dndbb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422662.lo", 0x00001, 0x080000, CRC(11343f00) SHA1(65664a87d704cfb14088080d8be1e3f66ecc3f4a) )
	ROM_LOAD16_BYTE( "95422663.hi", 0x00000, 0x080000, CRC(211f19ea) SHA1(d5ec234083472160100c51b19b32a490d4aa0c6c) )
	sc_dndbb_others
ROM_END

ROM_START( sc5dndbba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423662.lo", 0x00001, 0x080000, CRC(789d483a) SHA1(665af3ff6bd5fe8f392932d7dcd4b978255bcf80) )
	ROM_LOAD16_BYTE( "95423663.hi", 0x00000, 0x080000, CRC(67bf5bfe) SHA1(e76e8ffb350c71f643f3e599201bc3d00faca51f) )
	sc_dndbb_others
ROM_END

ROM_START( sc5dndbbb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426048.lo", 0x00001, 0x080000, CRC(e5ec350e) SHA1(8726e7aa69db463c739cdfbbd092a489bfcc8466) )
	ROM_LOAD16_BYTE( "95426049.hi", 0x00000, 0x080000, CRC(9bf0ea8f) SHA1(5333a23a1b067b4836f6dbe7c34868802078c217) )
	sc_dndbb_others
ROM_END

ROM_START( sc5dndbbc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426392.lo", 0x00001, 0x080000, CRC(6708a3ef) SHA1(f8838e9dc0d6cad1178632574a99eb423a69a6a0) )
	ROM_LOAD16_BYTE( "95426393.hi", 0x00000, 0x080000, CRC(8a857a9b) SHA1(7cf7802a0aa985b7278098264c950f7a75e8661b) )
	sc_dndbb_others
ROM_END

ROM_START( sc5dndbbd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427048.lo", 0x00001, 0x080000, CRC(3b362075) SHA1(b7f1c480b790a5e2495ec32d32528e2c5c5c8693) )
	ROM_LOAD16_BYTE( "95427049.hi", 0x00000, 0x080000, CRC(f6552779) SHA1(e70cfd6882ae11ea3cf91a76e9bb6ac2df3e3869) )
	sc_dndbb_others
ROM_END

ROM_START( sc5dndbbe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427392.lo", 0x00001, 0x080000, CRC(b03acc5a) SHA1(26b9a8a002dcd6fbc016e5f7b1097c6c77fbb849) )
	ROM_LOAD16_BYTE( "95427393.hi", 0x00000, 0x080000, CRC(0a0785c3) SHA1(63dca03f9146d55287c95ce199705e1ab8a5af31) )
	sc_dndbb_others
ROM_END

ROM_START( sc5dndbbf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3209p11.hi", 0x00000, 0x080000, CRC(ad8b4195) SHA1(78ee9b45aae3515c5a0d5cbde3c776fcad71036f) )
	ROM_LOAD16_BYTE( "p3209p11.lo", 0x00001, 0x080000, CRC(73e5f820) SHA1(d19ce0b2a1b696e3838f89e60d0c380a15e0e036) )
	sc_dndbb_others
ROM_END

ROM_START( sc5dndbbg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3209s11.hi", 0x00000, 0x080000, CRC(9415d4e3) SHA1(b56f192eca0e540c6a84aaa04fe711e46afdbb7e) )
	ROM_LOAD16_BYTE( "p3209s11.lo", 0x00001, 0x080000, CRC(59ce4bb8) SHA1(2e60656b151f00501b040f99cd42dd6126cedde1) )
	sc_dndbb_others
ROM_END



ROM_START( sc5dndcl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418892.lo", 0x00001, 0x080000, CRC(2368bbb6) SHA1(61a13578ac2516c9821ba875691c1f8009785b03) )
	ROM_LOAD16_BYTE( "95418893.hi", 0x00000, 0x080000, CRC(1c2d5159) SHA1(3bafb9c60a9f4237f89519fa07158f53000c08a8) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndcla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419892.lo", 0x00001, 0x080000, CRC(6fb61650) SHA1(2a89170ddca11fb86edb5072ed4841260c7b1501) )
	ROM_LOAD16_BYTE( "95419893.hi", 0x00000, 0x080000, CRC(ec0fa9af) SHA1(880aebf71e327ea4275c4ddc0756143e807ee98a) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( ad5dndcl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASE00 )
	ROM_LOAD( "39211185.bin", 0x0000, 0x1000000, CRC(c29804d6) SHA1(6586056c1cbbf8089c72a3e3e433beeaa8e9c882) ) // R3078 DOND
	ROM_LOAD( "39211194.bin", 0x0000, 0x1000000, CRC(2526cdfc) SHA1(6383ed07096b9c6438d957474a30d4f274e1db0c) )
	ROM_LOAD( "39211379.bin", 0x0000, 0x1000000, CRC(3b497e7c) SHA1(f8fc3cd4e03e8510146649b22e343284a480d349) )
	ROM_LOAD( "39212185.bin", 0x0000, 0x1000000, CRC(78a5adeb) SHA1(9b4fe8462a9ba8376a7543a7f7409593861465d0) )
	ROM_LOAD( "39212194.bin", 0x0000, 0x1000000, CRC(ebbad166) SHA1(8d1ddad198cd5c5ec40d75ea9ee97792eef5e32e) )
	ROM_LOAD( "39212379.bin", 0x0000, 0x1000000, CRC(d90dc869) SHA1(c85e857b965dba5675f8c3db4347b182949ce3a2) )

	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	// twin
	ROM_LOAD( "95008727.bin", 0x0000, 0x100000, CRC(b4c343a0) SHA1(d67faa1bcac1547cdc68874a411624f5c025cdbd) ) // R3078 TWIN
ROM_END

ROM_START( sc5dnddd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426256.lo", 0x00001, 0x080000, CRC(7a478879) SHA1(72c990648462280b1fceacaa1c417a3017b013e2) )
	ROM_LOAD16_BYTE( "95426257.hi", 0x00000, 0x080000, CRC(48b86836) SHA1(12497dd1a32f2dda146a53b89be56894499227e8) )
	sc_dnddd_others
ROM_END

ROM_START( sc5dnddda )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426384.lo", 0x00001, 0x080000, CRC(259fd056) SHA1(d725d41f3f6e5238b576a7b5d61bd1710b9979f6) )
	ROM_LOAD16_BYTE( "95426385.hi", 0x00000, 0x080000, CRC(15528f92) SHA1(a6ba5c7af907f558f9c09abf6bd43384fb4b96bd) )
	sc_dnddd_others
ROM_END

ROM_START( sc5dndddb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426454.lo", 0x00001, 0x080000, CRC(77ecf5c3) SHA1(3b82c434db1f26ebf690f74b80df4af2242b4f2f) )
	ROM_LOAD16_BYTE( "95426455.hi", 0x00000, 0x080000, CRC(14caae1a) SHA1(c26517d21db7b86c2677a97284149da5b4eaee7f) )
	sc_dnddd_others
ROM_END

ROM_START( sc5dndddc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427256.lo", 0x00001, 0x080000, CRC(77950394) SHA1(ef3d07516215ea24c07da596b986c27b36d3ca3e) )
	ROM_LOAD16_BYTE( "95427257.hi", 0x00000, 0x080000, CRC(ecf383d4) SHA1(f32dc4c571a545db23115931a0ded717e8a51ccd) )
	sc_dnddd_others
ROM_END

ROM_START( sc5dndddd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427384.lo", 0x00001, 0x080000, CRC(40f8448c) SHA1(56cd82ae2a119fa4c83309584cbb2cfd7e6f0212) )
	ROM_LOAD16_BYTE( "95427385.hi", 0x00000, 0x080000, CRC(ce033842) SHA1(ce63003cfd563f1e310fd536a683c676266c7250) )
	sc_dnddd_others
ROM_END

ROM_START( sc5dnddde )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427454.lo", 0x00001, 0x080000, CRC(964cffa6) SHA1(bf22daf259a71e9294b14e935c97646b2a003210) )
	ROM_LOAD16_BYTE( "95427455.hi", 0x00000, 0x080000, CRC(fdc1d8a1) SHA1(0979e031bb479a75cf077a641b66d39f42496d13) )
	sc_dnddd_others
ROM_END

ROM_START( sc5dndddf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3215p71.hi", 0x00000, 0x080000, CRC(8d22a123) SHA1(1756b2d49de3d50eacb6b0db3d2aeacac05bc6fd) )
	ROM_LOAD16_BYTE( "p3215p71.lo", 0x00001, 0x080000, CRC(ad0c35f0) SHA1(f9e391626206008d7465e003f595ece0ffd81863) )
	sc_dnddd_others
ROM_END

ROM_START( sc5dndddg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3215s71.hi", 0x00000, 0x080000, CRC(34f2676c) SHA1(1d70e41f612fdcacb1325430f2270dfe038178fa) )
	ROM_LOAD16_BYTE( "p3215s71.lo", 0x00001, 0x080000, CRC(7b1c7113) SHA1(4f4937b08adf121eb741b0ccb0bc8223a74c619c) )
	sc_dnddd_others
ROM_END


ROM_START( ad5dnddd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASE00 )
	ROM_LOAD( "39211494.bin", 0x0000, 0x1000000, CRC(64424b51) SHA1(604fc08e4754f23f54496693c95c050dccf810b2) ) // 3402 DOUBLE DELUXE
	ROM_LOAD( "39212494.bin", 0x0000, 0x1000000, CRC(3d5d3877) SHA1(cee45ac7c11a6fa729233b65ae0dddf12eb18276) ) // 3402 DOUBLE DELUXE

	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
	// double deluxe
	ROM_LOAD( "95009137.bin", 0x0000, 0x100000, CRC(1d1fe8df) SHA1(d3aebec1a956d563de96069b587ebd2d40123497) ) // 3402 DOUBLE DELUXE
	ROM_LOAD( "95009138.bin", 0x0000, 0x100000, CRC(c16971e0) SHA1(45df220ffe61db6a5319f495ff36efa793d428a4) )
ROM_END



ROM_START( sc5dndhf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422100.lo", 0x00001, 0x080000, CRC(ef20047c) SHA1(a15ee86dcef409def327a93c1c9370d1a3bf65d3) )
	ROM_LOAD16_BYTE( "95422101.hi", 0x00000, 0x080000, CRC(70f84961) SHA1(e1686922aa1dfa865ce50a2b272b93b4e508a9d6) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422228.lo", 0x00001, 0x080000, CRC(82f78314) SHA1(8f361b4beeb56be44305739c24c937dd0185f154) )
	ROM_LOAD16_BYTE( "95422229.hi", 0x00000, 0x080000, CRC(d756da26) SHA1(dc92e197a487f808e83b04407a5c065f713ca90b) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422308.lo", 0x00001, 0x080000, CRC(e657d78c) SHA1(458686ff094da445f5cb9af0ad808b83700c8544) )
	ROM_LOAD16_BYTE( "95422309.hi", 0x00000, 0x080000, CRC(eead5e54) SHA1(28ac82a045905b3609e7266a373610f49973fad6) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422596.lo", 0x00001, 0x080000, CRC(ff7962f7) SHA1(9b8e5b33c8e1775acc1a6d577db8e46e1856fa91) )
	ROM_LOAD16_BYTE( "95422597.hi", 0x00000, 0x080000, CRC(7650faf1) SHA1(1510258c89e69015c017f9296edb8ff1ea75eb8e) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422600.lo", 0x00001, 0x080000, CRC(56020991) SHA1(499c54789b00b49fbac93ce24381747ba0577087) )
	ROM_LOAD16_BYTE( "95422601.hi", 0x00000, 0x080000, CRC(554d6021) SHA1(2f529bf2e04f57fe398046feb05c19fc307e9a95) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422836.lo", 0x00001, 0x080000, CRC(f7fc9434) SHA1(b54fced671375c2483667bc7c94d9671ab6b7165) )
	ROM_LOAD16_BYTE( "95422837.hi", 0x00000, 0x080000, CRC(14f361d4) SHA1(713014d42bb1cfb7a6301ca04dd84063d3adbaf1) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhff )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423100.lo", 0x00001, 0x080000, CRC(9bad6823) SHA1(5c8f6e504150fa96098bc94e0c6148e33abe1b85) )
	ROM_LOAD16_BYTE( "95423101.hi", 0x00000, 0x080000, CRC(946d24ac) SHA1(5dd17f88a46a13bbff91affb444281e2eec7e2e9) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423228.lo", 0x00001, 0x080000, CRC(9ca8837d) SHA1(79ce2af1d545ca0cdd7766469c13633b6683d7d1) )
	ROM_LOAD16_BYTE( "95423229.hi", 0x00000, 0x080000, CRC(199933c7) SHA1(5f0d5c6a8e3d7b6ed6130b64e5d3ec699e643384) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423308.lo", 0x00001, 0x080000, CRC(450e2862) SHA1(ca71471c51a64645d291dc94ae48e8cee34d0ae0) )
	ROM_LOAD16_BYTE( "95423309.hi", 0x00000, 0x080000, CRC(40ee947e) SHA1(1dd35d4d1de3a4c65bc626297225f06005ca1c9f) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423596.lo", 0x00001, 0x080000, CRC(d3f68f15) SHA1(20144d6dc67e961b15b8caf39e93ca2978954104) )
	ROM_LOAD16_BYTE( "95423597.hi", 0x00000, 0x080000, CRC(c0eb6227) SHA1(511ca5bffe9d98896bb3130c80d2078e2a544a5d) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423600.lo", 0x00001, 0x080000, CRC(df07ffcf) SHA1(71ea3c48c73f571052900d03cff94038825260d5) )
	ROM_LOAD16_BYTE( "95423601.hi", 0x00000, 0x080000, CRC(bb49fe58) SHA1(c147521b25e55a13258a178f247be07843c4941c) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423836.lo", 0x00001, 0x080000, CRC(949a7f5c) SHA1(09e7c6ee6d3c3f04ae6d0233cf9bbb88d63fc864) )
	ROM_LOAD16_BYTE( "95423837.hi", 0x00000, 0x080000, CRC(a0dc9c07) SHA1(40829266eac6eef4bf7bd261ac8d40dc8e2b51e1) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426110.lo", 0x00001, 0x080000, CRC(fb34d047) SHA1(0af2dc94aff2f8962f0c59a80fbea695b047d093) )
	ROM_LOAD16_BYTE( "95426111.hi", 0x00000, 0x080000, CRC(f631827b) SHA1(5958c68537435b5550b061f1d6c950e03a9c5e5f) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426158.lo", 0x00001, 0x080000, CRC(563a6a0a) SHA1(ae6a95179f8ef9afd72cdd7182f6988570dc7ce9) )
	ROM_LOAD16_BYTE( "95426159.hi", 0x00000, 0x080000, CRC(7730beba) SHA1(f8471d9f69b0a29af65a9186dda1410c6bc9c886) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426294.lo", 0x00001, 0x080000, CRC(beffedcc) SHA1(dad489454cc48c9c0c735dbcadd7d1353a1850b7) )
	ROM_LOAD16_BYTE( "95426295.hi", 0x00000, 0x080000, CRC(02ad5e2c) SHA1(5cbd7dcd37676c5253429e59c92620318ecd8ebc) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427110.lo", 0x00001, 0x080000, CRC(ae499e60) SHA1(cf1a5e618cca77466b70061c829a8fa9dd9b96d3) )
	ROM_LOAD16_BYTE( "95427111.hi", 0x00000, 0x080000, CRC(4d8c41a6) SHA1(5baa34496a653ed311333ae4b921fecd5ae8b383) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427158.lo", 0x00001, 0x080000, CRC(add49a6e) SHA1(c57824b411a879fa0b2889c94a5e2c9f34848844) )
	ROM_LOAD16_BYTE( "95427159.hi", 0x00000, 0x080000, CRC(7f91c4a2) SHA1(d010de737e9ebedc52ba691057045a68474bc9d3) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427294.lo", 0x00001, 0x080000, CRC(c85cc648) SHA1(073dc34789e23258dfe128d5eadf8e3317c07cd2) )
	ROM_LOAD16_BYTE( "95427295.hi", 0x00000, 0x080000, CRC(d85e3b26) SHA1(26cdbca382441785038199a12a0dea8d9f09f7c7) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3008p01.hi", 0x00000, 0x080000, CRC(543fc78b) SHA1(e1aff6d3bca1fba509855c8cd83f6cd8160dbbc3) )
	ROM_LOAD16_BYTE( "p3008p01.lo", 0x00001, 0x080000, CRC(50b9424c) SHA1(819de4fa51ca8d520a5dbce1d204daaf44b62b94) )
	sc_dndhf_others
ROM_END

ROM_START( sc5dndhfs )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3008s01.hi", 0x00000, 0x080000, CRC(4a2e02e4) SHA1(be028657c2cfc5d3caafaea4664f37d24a584f2a) )
	ROM_LOAD16_BYTE( "p3008s01.lo", 0x00001, 0x080000, CRC(3f455777) SHA1(b0182a0b2981d9cbc914c30438a23f13c271cffa) )
	sc_dndhf_others
ROM_END





ROM_START( sc5dndys )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423674.lo", 0x00001, 0x080000, CRC(1fb53dcb) SHA1(d1b99b29d95f1dd2b2ce1d7c846387112c7cceed) )
	ROM_LOAD16_BYTE( "95423675.hi", 0x00000, 0x080000, CRC(61cd5b49) SHA1(7d3dbc05655b48af9edf84e95e0ffe6ff62068fa) )
	sc_dndys_others
ROM_END

ROM_START( sc5dndysa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426268.lo", 0x00001, 0x080000, CRC(ab252eb0) SHA1(d2964cc5f5d3e6fbad512931bd18b186697ade8e) )
	ROM_LOAD16_BYTE( "95426269.hi", 0x00000, 0x080000, CRC(0741454a) SHA1(34b17cd7a4dbffd45ec0d939dce41e708852d892) )
	sc_dndys_others
ROM_END

ROM_START( sc5dndysb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426394.lo", 0x00001, 0x080000, CRC(94a2f378) SHA1(27281ac1c17cbfd21fec4a049b7907d87addeb14) )
	ROM_LOAD16_BYTE( "95426395.hi", 0x00000, 0x080000, CRC(59304a7d) SHA1(7110fb450b0f04e28bab5f7d5eee997dc5f4f761) )
	sc_dndys_others
ROM_END

ROM_START( sc5dndysc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427064.lo", 0x00001, 0x080000, CRC(febb3430) SHA1(2214a6377030622fc08917ef57338934cd207077) )
	ROM_LOAD16_BYTE( "95427065.hi", 0x00000, 0x080000, CRC(1ac94731) SHA1(96ca407b2b0199b679d8feb568dcfa267c3afaf0) )
	sc_dndys_others
ROM_END

ROM_START( sc5dndysd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427268.lo", 0x00001, 0x080000, CRC(7c318a2d) SHA1(c664d8343d1138facb33505869c8ec18e40e50fe) )
	ROM_LOAD16_BYTE( "95427269.hi", 0x00000, 0x080000, CRC(3e6f9575) SHA1(3d09e122f4c7c7f253ccf24b7ca9390b28e5f4f4) )
	sc_dndys_others
ROM_END

ROM_START( sc5dndyse )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427394.lo", 0x00001, 0x080000, CRC(ce683a22) SHA1(2876748fcb6952d2817a6df5ba7900206a6a457c) )
	ROM_LOAD16_BYTE( "95427395.hi", 0x00000, 0x080000, CRC(8a514a3d) SHA1(18e40ec25715a01c839751d0d73aad2e38ea54ed) )
	sc_dndys_others
ROM_END

ROM_START( sc5dndysf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3207p01.hi", 0x00000, 0x080000, CRC(9a91557f) SHA1(bc53eb7a7bfd2857cf6b323bd3f45ea6c1ddbf0c) )
	ROM_LOAD16_BYTE( "p3207p01.lo", 0x00001, 0x080000, CRC(f3196c98) SHA1(1e4d5435b37e0198285041adf0fb7c86e6059d5e) )
	sc_dndys_others
ROM_END

ROM_START( sc5dndysg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3207s01.hi", 0x00000, 0x080000, CRC(47f5b397) SHA1(45ce9945ac9131abf5590d34b2aa1ac103f249c6) )
	ROM_LOAD16_BYTE( "p3207s01.lo", 0x00001, 0x080000, CRC(e3f70ec2) SHA1(fd97662eb5efa0aa1c2a501e741405a6067c8e69) )
	sc_dndys_others
ROM_END


ROM_START( sc5dndlp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426298.lo", 0x00001, 0x080000, CRC(e75e8a81) SHA1(441904c2f1cd72ed269a1bd7157076cf54b325e9) )
	ROM_LOAD16_BYTE( "95426299.hi", 0x00000, 0x080000, CRC(9c167e80) SHA1(97d642a81efc3261388b8d2a1c6747ea61497715) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426368.lo", 0x00001, 0x080000, CRC(94435433) SHA1(edc64f6cefb9022b07eedd1b7c4cfcdc40e0a4e9) )
	ROM_LOAD16_BYTE( "95426369.hi", 0x00000, 0x080000, CRC(df0e9933) SHA1(b4d5329366bcc74e284a05f3b71a50267f65c05b) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426406.lo", 0x00001, 0x080000, CRC(833d04fa) SHA1(3485c1ff0d5267af9fb888c35b56330c79733d1a) )
	ROM_LOAD16_BYTE( "95426407.hi", 0x00000, 0x080000, CRC(dbb5ff57) SHA1(126bacb47fccbfd4ebcddf841490a15676d5da6a) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426444.lo", 0x00001, 0x080000, CRC(641db9da) SHA1(b11d3f4cb28ba4252b29b558372f3562ea8191f0) )
	ROM_LOAD16_BYTE( "95426445.hi", 0x00000, 0x080000, CRC(f52f60d9) SHA1(1d4f1002dc8a4bd84d92cdba1e9b5547166c01d8) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426538.lo", 0x00001, 0x080000, CRC(7e1d4da1) SHA1(014e03e18dfd09bda9926f4ec554d6c6e90301f2) )
	ROM_LOAD16_BYTE( "95426539.hi", 0x00000, 0x080000, CRC(8bbf4c0d) SHA1(95a1174aaa48b736c6e338aea7f811b2e83a9d83) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426668.lo", 0x00001, 0x080000, CRC(8203c055) SHA1(8ed86a63272181a61fee273a31d1295f787e7c6c) )
	ROM_LOAD16_BYTE( "95426669.hi", 0x00000, 0x080000, CRC(d2ef1fb3) SHA1(28969bf1a4e71c1ccfca9202de905c12abaeed47) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426708.lo", 0x00001, 0x080000, CRC(250aaa63) SHA1(62fa96fc8ccd90b02efda13fa488bf1c6e1ca3b8) )
	ROM_LOAD16_BYTE( "95426709.hi", 0x00000, 0x080000, CRC(e3b860b0) SHA1(901812e4bbed6f13ec94268ef542950695979ae7) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427298.lo", 0x00001, 0x080000, CRC(96b21b18) SHA1(4941f3ec390938af36ed273a47c1a8df8af01d67) )
	ROM_LOAD16_BYTE( "95427299.hi", 0x00000, 0x080000, CRC(57fe8998) SHA1(3af7aa8df889456b3fd938ffaea03fe034be6534) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlph )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427368.lo", 0x00001, 0x080000, CRC(dac70842) SHA1(9edf10b7fd58f9208e67705ba5f3df8930e3dc41) )
	ROM_LOAD16_BYTE( "95427369.hi", 0x00000, 0x080000, CRC(f1afd79d) SHA1(f0f6d842648d6c9e3ce24a7dbf7b780fdc5ced10) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427406.lo", 0x00001, 0x080000, CRC(d491c686) SHA1(6647edf5cc5888e0a9bd3bee9130c8c443c2fbd1) )
	ROM_LOAD16_BYTE( "95427407.hi", 0x00000, 0x080000, CRC(a83719fa) SHA1(eccd97caafde4ef9d65c8a9e424e1962dd16f7ad) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427444.lo", 0x00001, 0x080000, CRC(55a609c4) SHA1(7636216e2c93ea59936ed43fd7d5fb7048643518) )
	ROM_LOAD16_BYTE( "95427445.hi", 0x00000, 0x080000, CRC(b4590c35) SHA1(49207ada280d6bb565f005e2e7964d26f0937e49) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427538.lo", 0x00001, 0x080000, CRC(abc79346) SHA1(7dc2b5dea36d1c746ac03caa2f96e46039e2eb0d) )
	ROM_LOAD16_BYTE( "95427539.hi", 0x00000, 0x080000, CRC(9a6529bb) SHA1(f8c409f994a848ad6748db317fa2acb52977f59d) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427668.lo", 0x00001, 0x080000, CRC(57a902c6) SHA1(e6aff87c9eca5c433b155a856c1ed6ccb45318fc) )
	ROM_LOAD16_BYTE( "95427669.hi", 0x00000, 0x080000, CRC(a05ed29b) SHA1(2e7538e2399d16694b85e46ceff54c34335b7f9a) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427708.lo", 0x00001, 0x080000, CRC(f1817ebb) SHA1(00459c5d268a62ee3f612079a1860c1b67729dce) )
	ROM_LOAD16_BYTE( "95427709.hi", 0x00000, 0x080000, CRC(a4342102) SHA1(99c83845556085be69937025c26d998c2d60727d) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3212p11.hi", 0x00000, 0x080000, CRC(818659ee) SHA1(66bee5b92cce62b4caccc59decec5d808e89ee18) )
	ROM_LOAD16_BYTE( "p3212p11.lo", 0x00001, 0x080000, CRC(c6104c88) SHA1(9f1a400cae00c5587d16e9073447c2a38c8f36a3) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3212p12.hi", 0x00000, 0x080000, CRC(3e1dcc7d) SHA1(8d6eb4e7d5cfbc67e5cf922a853ca9c642aa32aa) )
	ROM_LOAD16_BYTE( "p3212p12.lo", 0x00001, 0x080000, CRC(4baac8d0) SHA1(ed68fc2b234fed44ad4e2fde0cfc1c9c6845ed97) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3212p13.hi", 0x00000, 0x080000, CRC(c25b0254) SHA1(d4f1f80f30c18dc67a802dfc0d651e4d3a2c3c97) )
	ROM_LOAD16_BYTE( "p3212p13.lo", 0x00001, 0x080000, CRC(959ee1e3) SHA1(328347a9fe86678aed76d669f92ad76b0bfa9ce5) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3212p14.hi", 0x00000, 0x080000, CRC(226cfe89) SHA1(c7755878e2dc0f5062b0c0329fef342262469173) )
	ROM_LOAD16_BYTE( "p3212p14.lo", 0x00001, 0x080000, CRC(7f4dc672) SHA1(2550879c400ce07fb8dfa612f4c0f0c342db2545) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3212s11.hi", 0x00000, 0x080000, CRC(12740b8e) SHA1(a9a1d0f38811c75295ded490adb8492812ef6efa) )
	ROM_LOAD16_BYTE( "p3212s11.lo", 0x00001, 0x080000, CRC(02820c15) SHA1(c57e780119519dfeac905da27edb9de717be2340) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlps )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3212s12.hi", 0x00000, 0x080000, CRC(8ca399b2) SHA1(a2f75b8c88d40c0e75fa3612cf077d15d29a97bf) )
	ROM_LOAD16_BYTE( "p3212s12.lo", 0x00001, 0x080000, CRC(c2f778e1) SHA1(89c7204728acced07210fec01f5c370b20468bd4) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpt )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3212s13.hi", 0x00000, 0x080000, CRC(646a4ea7) SHA1(9b8455179e1129db5d72a3c79ee176214107042d) )
	ROM_LOAD16_BYTE( "p3212s13.lo", 0x00001, 0x080000, CRC(6e6885e3) SHA1(3edc678bf20b05cd52217442bcf93e9255a624a2) )
	sc_dndlp_others
ROM_END

ROM_START( sc5dndlpu )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3212s14.hi", 0x00000, 0x080000, CRC(895101c7) SHA1(f9b61d57a028c5fc365d00db9c9a4661335a7cbe) )
	ROM_LOAD16_BYTE( "p3212s14.lo", 0x00001, 0x080000, CRC(7d504257) SHA1(78c2d95d96905a983a218024b6ea01d0c2cded8c) )
	sc_dndlp_others
ROM_END



ROM_START( sc5dndra )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422486.lo", 0x00001, 0x080000, CRC(bc7d0e20) SHA1(fba43a73629d563de1e8fb19b5d0f584a444c5e1) )
	ROM_LOAD16_BYTE( "95422487.hi", 0x00000, 0x080000, CRC(60d7aa64) SHA1(28c51f574706c1a96079f9ff8b5e280c0a8e3e8e) )
	sc_dndra_others
ROM_END

ROM_START( sc5dndraa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423486.lo", 0x00001, 0x080000, CRC(d5325d3f) SHA1(b18245474a7785a94460b7ab3b58f073be78c832) )
	ROM_LOAD16_BYTE( "95423487.hi", 0x00000, 0x080000, CRC(552e5c5f) SHA1(2424b0bb3cc9280cf9fd88c1651aa4db093b15b0) )
	sc_dndra_others
ROM_END

ROM_START( sc5dndrab )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426080.lo", 0x00001, 0x080000, CRC(80a7760d) SHA1(2bd48037ed2ddb9720f62854b0eba24ee2e85bd4) )
	ROM_LOAD16_BYTE( "95426081.hi", 0x00000, 0x080000, CRC(183ce976) SHA1(34bdbb5da232ae44f16deff8026d3155e5f7527e) )
	sc_dndra_others
ROM_END

ROM_START( sc5dndrac )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426396.lo", 0x00001, 0x080000, CRC(54a61a29) SHA1(ac715c7c0f208de1e4522f8a28ca4b7ee7ac9033) )
	ROM_LOAD16_BYTE( "95426397.hi", 0x00000, 0x080000, CRC(2183f67d) SHA1(51054ff5c26e9ea5ddc64630f4db1dfa08950111) )
	sc_dndra_others
ROM_END

ROM_START( sc5dndrad )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427080.lo", 0x00001, 0x080000, CRC(957fbbf1) SHA1(df90ec57ca6a2d9f595ac43e7bbdf26d1d862cfe) )
	ROM_LOAD16_BYTE( "95427081.hi", 0x00000, 0x080000, CRC(d24bc15b) SHA1(3bdf96d7e91d9d252861a81176b6c20f14e27021) )
	sc_dndra_others
ROM_END

ROM_START( sc5dndrae )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427396.lo", 0x00001, 0x080000, CRC(64b0cfab) SHA1(89a958774b1d1d9d1b326a45ccb04fa68677bbb1) )
	ROM_LOAD16_BYTE( "95427397.hi", 0x00000, 0x080000, CRC(03786a87) SHA1(1b5756c1cb77ffd9935f94fd1bb54eef0f37ea12) )
	sc_dndra_others
ROM_END

ROM_START( sc5dndraf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3201p71.hi", 0x00000, 0x080000, CRC(27086da6) SHA1(4a8e10fa47f6467f6d14611e81c25e79a1ee1173) )
	ROM_LOAD16_BYTE( "p3201p71.lo", 0x00001, 0x080000, CRC(e0cb8eac) SHA1(e8b6fbb7f4d19d5c9fb8891c23f3293d37067946) )
	sc_dndra_others
ROM_END

ROM_START( sc5dndrag )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3201p72.hi", 0x00000, 0x080000, CRC(2536bc62) SHA1(c3a84a78311c63358f69003c1540f2560249e318) )
	ROM_LOAD16_BYTE( "p3201p72.lo", 0x00001, 0x080000, CRC(560988a7) SHA1(1f0e01f88803c98affbba3e7cf720282866e8d72) )
	sc_dndra_others
ROM_END

ROM_START( sc5dndrah )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3201p73.hi", 0x00000, 0x080000, CRC(dff3a0b4) SHA1(98b8e5538d5a80f9cc67d7f9a9d1cfe0f72bf2fc) )
	ROM_LOAD16_BYTE( "p3201p73.lo", 0x00001, 0x080000, CRC(614476cb) SHA1(df1eab8ce8083c74f9168fe1ae5d0af17ef46e8a) )
	sc_dndra_others
ROM_END

ROM_START( sc5dndrai )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3201s71.hi", 0x00000, 0x080000, CRC(239e71e0) SHA1(69de5f6663eb3d74bbcee5c8f8461204c38ac6e7) )
	ROM_LOAD16_BYTE( "p3201s71.lo", 0x00001, 0x080000, CRC(254f4647) SHA1(3b8667633ad1558e35ff6742fbfbb97bf6058bf8) )
	sc_dndra_others
ROM_END

ROM_START( sc5dndraj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3201s72.hi", 0x00000, 0x080000, CRC(bf6e0a69) SHA1(21b958a8995a7adaf240991c1815527d0b51dcb3) )
	ROM_LOAD16_BYTE( "p3201s72.lo", 0x00001, 0x080000, CRC(828d9065) SHA1(bfdf0f310e8d1b87dbb3e60722241dbfa407d7dd) )
	sc_dndra_others
ROM_END

ROM_START( sc5dndrak )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3201s73.hi", 0x00000, 0x080000, CRC(cf22263f) SHA1(37d34ccd6a2cc7ee7858885f56226aa59cb8d40a) )
	ROM_LOAD16_BYTE( "p3201s73.lo", 0x00001, 0x080000, CRC(5ee67237) SHA1(f4b1d6281fa5c406e7f76e1397963539070df6ab) )
	sc_dndra_others
ROM_END




ROM_START( sc5dndbd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422894.lo", 0x00001, 0x080000, CRC(56e5027f) SHA1(af8afab10f309ecb40d7c7861dcccb397f92dccc) )
	ROM_LOAD16_BYTE( "95422895.hi", 0x00000, 0x080000, CRC(04b08719) SHA1(64355b5711b069b9328bdc98fdc6815bceb08504) )
	sc_dndbd_others
ROM_END

ROM_START( sc5dndbda )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423894.lo", 0x00001, 0x080000, CRC(5ee4a59e) SHA1(e64ab0fb59d9013da76bd88c548000322c9955be) )
	ROM_LOAD16_BYTE( "95423895.hi", 0x00000, 0x080000, CRC(320046fc) SHA1(0c7c76b22ff1ccccfc27dde25236da6fb834e027) )
	sc_dndbd_others
ROM_END

ROM_START( sc5dndbdb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426370.lo", 0x00001, 0x080000, CRC(201fbd94) SHA1(6c5b819e20d9dc7237d99320953fc33d6357faf8) )
	ROM_LOAD16_BYTE( "95426371.hi", 0x00000, 0x080000, CRC(cbc533ad) SHA1(03daec7b71e5cc7168dfb86199e45ec4553dae77) )
	sc_dndbd_others
ROM_END

ROM_START( sc5dndbdc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426386.lo", 0x00001, 0x080000, CRC(cf6cb721) SHA1(961a63d1173e5784853a0fad4d8e94859144023a) )
	ROM_LOAD16_BYTE( "95426387.hi", 0x00000, 0x080000, CRC(20e8fc23) SHA1(71477bd6a1d482751b0cc0158d0d5d963fe63703) )
	sc_dndbd_others
ROM_END

ROM_START( sc5dndbdd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427370.lo", 0x00001, 0x080000, CRC(154f9a59) SHA1(10464571fd505813f472d1ef0f153b93e167e03d) )
	ROM_LOAD16_BYTE( "95427371.hi", 0x00000, 0x080000, CRC(b47b7d87) SHA1(0ecac57740f6f82d11a6fa38c2dce3a101b52772) )
	sc_dndbd_others
ROM_END

ROM_START( sc5dndbde )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427386.lo", 0x00001, 0x080000, CRC(4ceadcfc) SHA1(37fca1d7ade327c6f54845a2f67133f5122e59d5) )
	ROM_LOAD16_BYTE( "95427387.hi", 0x00000, 0x080000, CRC(c8774dc7) SHA1(c2f5d75676b1af3e84d21310bd3d3a472a92b8aa) )
	sc_dndbd_others
ROM_END

ROM_START( sc5dndbdf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3210p71.hi", 0x00000, 0x080000, CRC(cfd11c31) SHA1(6826fd6b46793a42b7bc446a34effe981a893ee3) )
	ROM_LOAD16_BYTE( "p3210p71.lo", 0x00001, 0x080000, CRC(2f48b987) SHA1(7ac930e1c58dcf62e9b613ec4cc444ad6303a33d) )
	sc_dndbd_others
ROM_END

ROM_START( sc5dndbdg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3210p73.hi", 0x00000, 0x080000, CRC(ec47b51c) SHA1(36fe889b2961fcef2f0b1790d18b379bcbfcb182) )
	ROM_LOAD16_BYTE( "p3210p73.lo", 0x00001, 0x080000, CRC(ce0ee1c9) SHA1(4d29a6158714c67172a5e6a86db48635f78b0cfe) )
	sc_dndbd_others
ROM_END

ROM_START( sc5dndbdh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3210s71.hi", 0x00000, 0x080000, CRC(a3361b74) SHA1(79710fd876f493dadef5d6f7c02e36e12fe0033c) )
	ROM_LOAD16_BYTE( "p3210s71.lo", 0x00001, 0x080000, CRC(2fce4f8a) SHA1(d03bcae4f1731aacad907ca6bd752e19f7e5ece7) )
	sc_dndbd_others
ROM_END

ROM_START( sc5dndbdi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3210s73.hi", 0x00000, 0x080000, CRC(ede2599c) SHA1(eb49189e4db10d3c20951035d796faba8aa6f238) )
	ROM_LOAD16_BYTE( "p3210s73.lo", 0x00001, 0x080000, CRC(3ae378c2) SHA1(3c57abb05099c47dde00942cee4925cb75357f2a) )
	sc_dndbd_others
ROM_END




ROM_START( sc5dndbr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422150.lo", 0x00001, 0x080000, CRC(10b1d71f) SHA1(442ce4e98fd7ab7678339ca520353fc7f98e353e) )
	ROM_LOAD16_BYTE( "95422151.hi", 0x00000, 0x080000, CRC(c07dd832) SHA1(076eef9b1b4f527b866634e2522c0fc06eb2b582) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbra )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422298.lo", 0x00001, 0x080000, CRC(1925aed8) SHA1(a8e9f69c80270efd5e8587f54ed4259e306a6e90) )
	ROM_LOAD16_BYTE( "95422299.hi", 0x00000, 0x080000, CRC(8130eaa3) SHA1(7c7621ae5bca158fe83b5596da0bd2f9a027e127) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422430.lo", 0x00001, 0x080000, CRC(12a6c08e) SHA1(4c003012110187799841df7e85dfe8874afaf878) )
	ROM_LOAD16_BYTE( "95422431.hi", 0x00000, 0x080000, CRC(d7a1080e) SHA1(64a537e37980a6f918a3c43a391aea003a8b5a2d) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422462.lo", 0x00001, 0x080000, CRC(bfc9a904) SHA1(1bcb566fdcbaeab46ef0958b4270248edfb459cc) )
	ROM_LOAD16_BYTE( "95422463.hi", 0x00000, 0x080000, CRC(d9fdf257) SHA1(4982e1652c481fb494c481b34b8affb009c835fa) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422504.lo", 0x00001, 0x080000, CRC(4a0f3dca) SHA1(0e36042e969c8d049c0ac8dc027cc0b8699570d0) )
	ROM_LOAD16_BYTE( "95422505.hi", 0x00000, 0x080000, CRC(c6b55463) SHA1(429d3d191f3e3a814c12daa0fa1eefe03c25b218) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbre )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422802.lo", 0x00001, 0x080000, CRC(9c9868f7) SHA1(72a2162568032775ca5cb8283d3437314a453a45) )
	ROM_LOAD16_BYTE( "95422803.hi", 0x00000, 0x080000, CRC(4d2f0f6c) SHA1(95fe69b8bafd6780ac32e76d1c43f449c941ecc4) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423150.lo", 0x00001, 0x080000, CRC(b0a8336a) SHA1(c4f2a1cae19858ec136f85d3624100be6f3c044f) )
	ROM_LOAD16_BYTE( "95423151.hi", 0x00000, 0x080000, CRC(527c2a60) SHA1(ef1c057582d7ef2a6d7bdc4e9658326f0536a69d) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423298.lo", 0x00001, 0x080000, CRC(499229f5) SHA1(398f4276c86133b17f95871e399f0195ae7aaa04) )
	ROM_LOAD16_BYTE( "95423299.hi", 0x00000, 0x080000, CRC(3d855dd0) SHA1(351bb1191bedb5d22b289fd0b3ae8f5c5c9ebf94) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423430.lo", 0x00001, 0x080000, CRC(d95f3e3a) SHA1(6805a7eb1ea84b10721ebe863de09608e5d3643d) )
	ROM_LOAD16_BYTE( "95423431.hi", 0x00000, 0x080000, CRC(242bd27b) SHA1(7183fc705a9a60e2e7cd38d7dc2ee99231df6ccb) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbri )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423462.lo", 0x00001, 0x080000, CRC(43b8cd87) SHA1(724d60e39d1b69b3766eb3f86e5f56ffc227d13f) )
	ROM_LOAD16_BYTE( "95423463.hi", 0x00000, 0x080000, CRC(ecca1f40) SHA1(a49396bfe41ff18e4bc44051e9dbfccf9604d738) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423504.lo", 0x00001, 0x080000, CRC(92e3a59d) SHA1(52c5c48f3d8feceb64bb3ea544db2461b9bcd2f0) )
	ROM_LOAD16_BYTE( "95423505.hi", 0x00000, 0x080000, CRC(2c806756) SHA1(8e9e44e8a1ad527ae3f90f6bf25734b5648f87bb) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423802.lo", 0x00001, 0x080000, CRC(07f38e50) SHA1(0975fc113086c39f3970dee8d3bbed42c4ba853c) )
	ROM_LOAD16_BYTE( "95423803.hi", 0x00000, 0x080000, CRC(f7efe16f) SHA1(52a990f39cf99af51787b6749ff78a98151957de) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426056.lo", 0x00001, 0x080000, CRC(c9a92cd3) SHA1(d2364fbc976c9aa67a8410c5754f957b60c86f16) )
	ROM_LOAD16_BYTE( "95426057.hi", 0x00000, 0x080000, CRC(8b730a59) SHA1(d016748e68b89057fe3df57bdccdd84fbdc309a9) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426288.lo", 0x00001, 0x080000, CRC(0414dea3) SHA1(cd8bf53eb3cc970c47d1b4235d5e2e0b56a8e1fb) )
	ROM_LOAD16_BYTE( "95426289.hi", 0x00000, 0x080000, CRC(cdf8fabe) SHA1(7deaaab4bdf93e4caddba11bd2876560e26f4758) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427056.lo", 0x00001, 0x080000, CRC(e0712d84) SHA1(13c32179c7f78c6d020ea613ede92bee8396e32c) )
	ROM_LOAD16_BYTE( "95427057.hi", 0x00000, 0x080000, CRC(1a097df2) SHA1(3fba0d7d1289c0fdd79da3b548bfc94b7fe617ef) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbro )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427288.lo", 0x00001, 0x080000, CRC(82f456e6) SHA1(6f3a282bcbf80c1e948d50227fee93c1cc6d6053) )
	ROM_LOAD16_BYTE( "95427289.hi", 0x00000, 0x080000, CRC(65c8444c) SHA1(42ce3791ea3384f4704725a296e99912d7758c55) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3011p01.hi", 0x00000, 0x080000, CRC(668c910c) SHA1(765c45d37f1a1f1f35709c7c6de74ddf081cf275) )
	ROM_LOAD16_BYTE( "p3011p01.lo", 0x00001, 0x080000, CRC(eaab8c27) SHA1(939975e613aa421d5e23a1d620f07cd49cd20d81) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3011p41.hi", 0x00000, 0x080000, CRC(5018bf9b) SHA1(e9fa0178b9c866648c955f9d0afce55dc3c8e01c) )
	ROM_LOAD16_BYTE( "p3011p41.lo", 0x00001, 0x080000, CRC(d7d4d793) SHA1(77db3549607f112d307bff1e8cc41be670915967) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3011p72.hi", 0x00000, 0x080000, CRC(de759c0b) SHA1(b9ccc2e7ac3e87f65b8921fabe59b23d1f1f0cf6) )
	ROM_LOAD16_BYTE( "p3011p72.lo", 0x00001, 0x080000, CRC(5dbf7b6f) SHA1(39a5642af03d20c07a7b9781259ed3d1d3a91e97) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrs )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3011pe1.hi", 0x00000, 0x080000, CRC(421d83b8) SHA1(29eda16c7bc3cdf145090e7dfbf3c6b1a8fd81b4) )
	ROM_LOAD16_BYTE( "p3011pe1.lo", 0x00001, 0x080000, CRC(109caf89) SHA1(f3fe4a8f70c86f55ca5378056f4e6d61bc88b7da) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrt )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3011s01.hi", 0x00000, 0x080000, CRC(46cfec27) SHA1(23862773a4682a18c1082082831a1ed5a27460d5) )
	ROM_LOAD16_BYTE( "p3011s01.lo", 0x00001, 0x080000, CRC(70e74304) SHA1(a39edc2431a6cdfb10bbb676acec7c0c0243f5e1) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbru )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3011s41.hi", 0x00000, 0x080000, CRC(8fde35ce) SHA1(1dfa0e260779aaed8e9207c39c9e1776ec468058) )
	ROM_LOAD16_BYTE( "p3011s41.lo", 0x00001, 0x080000, CRC(3c8f3e91) SHA1(2d6b0643940c283c304a3f15381b1093323e4b1c) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrv )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3011s72.hi", 0x00000, 0x080000, CRC(8523c4d7) SHA1(f365a3b9a24b686afa1866382cef3cf6ee88de19) )
	ROM_LOAD16_BYTE( "p3011s72.lo", 0x00001, 0x080000, CRC(32aa2e4e) SHA1(7fb19c72d021780672871ee2ea27074cbe4af233) )
	sc_dndbr_others
ROM_END

ROM_START( sc5dndbrw )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3011se1.hi", 0x00000, 0x080000, CRC(6e547687) SHA1(ea1a56a5afb179437c9b9f5ee52cade531aa2dca) )
	ROM_LOAD16_BYTE( "p3011se1.lo", 0x00001, 0x080000, CRC(03467347) SHA1(4675bd87d61dc811a2f4525d00a220d11c7eb258) )
	sc_dndbr_others
ROM_END


ROM_START( sc5dndcc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422390.lo", 0x00001, 0x080000, CRC(6bf4e3e6) SHA1(dc4add26d606053a1003ef54c54321fef38966be) )
	ROM_LOAD16_BYTE( "95422391.hi", 0x00000, 0x080000, CRC(84aa4dd6) SHA1(b63d4eca7841017e4e1ca9b3abb973dc9273027c) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndcca )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422500.lo", 0x00001, 0x080000, CRC(d349ecbf) SHA1(d438db7f2e1647bd87b416721ca8d9f53d196a84) )
	ROM_LOAD16_BYTE( "95422501.hi", 0x00000, 0x080000, CRC(4da063fd) SHA1(1332fb94f6cc3e959488cd514469a2dd3c1be9c6) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndccb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423390.lo", 0x00001, 0x080000, CRC(9a0c32bb) SHA1(7325dbcc5b448803314f0e299f832081f1db9a5f) )
	ROM_LOAD16_BYTE( "95423391.hi", 0x00000, 0x080000, CRC(7c7efdf0) SHA1(b94190d5ee1bc4b82fb2ab500f9cf2253c47a7d4) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndccc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423500.lo", 0x00001, 0x080000, CRC(128b7b26) SHA1(d229562614c159e515b520273e4802f1bdf6da27) )
	ROM_LOAD16_BYTE( "95423501.hi", 0x00000, 0x080000, CRC(9283b144) SHA1(91303b655a7ea8fb3837b2c8b520c067e2950af5) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndccd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423804.lo", 0x00001, 0x080000, CRC(c9c507b7) SHA1(8814b353a072c1cc0f3f35256ea89d7a67558f6d) )
	ROM_LOAD16_BYTE( "95423805.hi", 0x00000, 0x080000, CRC(d5f71e0e) SHA1(d1c96c12140d189ca2a4ea56e6279bb32eb0194b) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndcce )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426052.lo", 0x00001, 0x080000, CRC(a98e6967) SHA1(40cf2aac490dfbb1aa28eb3af7325d831f22460e) )
	ROM_LOAD16_BYTE( "95426053.hi", 0x00000, 0x080000, CRC(135f0688) SHA1(bde939e11eae1342eb32495e88d67f507bb841ad) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndccf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426400.lo", 0x00001, 0x080000, CRC(d41f2cf8) SHA1(5c41dafdeedb4ff0dc988de1367f26f2ddf0e412) )
	ROM_LOAD16_BYTE( "95426401.hi", 0x00000, 0x080000, CRC(dfb30753) SHA1(8f41e2c1976cefcab122bdc48437e02a0d3539c0) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndccg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427052.lo", 0x00001, 0x080000, CRC(bb2f094a) SHA1(b90f35be18e39b003590635152f864be67567997) )
	ROM_LOAD16_BYTE( "95427053.hi", 0x00000, 0x080000, CRC(818a702c) SHA1(cf0633cd1c4836a4947063b42a0fd0360879349d) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndcch )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427400.lo", 0x00001, 0x080000, CRC(e9eab94b) SHA1(c856f5632b3e14232e3f2c47ad03eda7b9b983eb) )
	ROM_LOAD16_BYTE( "95427401.hi", 0x00000, 0x080000, CRC(045202fa) SHA1(6a183f17c023ef43416572860c5261271e701cf0) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndcci )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3017p71.hi", 0x00000, 0x080000, CRC(2cbfa80a) SHA1(d31d57360700e2b22569168fbbd769570e0e257e) )
	ROM_LOAD16_BYTE( "p3017p71.lo", 0x00001, 0x080000, CRC(e80f176a) SHA1(f66e4165209396646442fb640b90f7fe48fc884e) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndccj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3017pf1.hi", 0x00000, 0x080000, CRC(dccfc4e7) SHA1(7caed83dffa0fd6bccdc80acdc6b0a619d2d4045) )
	ROM_LOAD16_BYTE( "p3017pf1.lo", 0x00001, 0x080000, CRC(58d2c26b) SHA1(e9bc7afb62550842949fda472f3cae83377a3a84) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndcck )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3017pf2.hi", 0x00000, 0x080000, CRC(d1a87204) SHA1(3e9ef9c8d00be9970b6f3def0d2b977cb8899a27) )
	ROM_LOAD16_BYTE( "p3017pf2.lo", 0x00001, 0x080000, CRC(a3697ce1) SHA1(57b0cc7cd75c746033b9ca490574a4925f6d39a1) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndccl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3017pg1.hi", 0x00000, 0x080000, CRC(0fd1ef51) SHA1(bfabe358d647e46f3c24e716422d201f910b9d81) )
	ROM_LOAD16_BYTE( "p3017pg1.lo", 0x00001, 0x080000, CRC(d006fe79) SHA1(920566666d184ab8f57bd92159a3bb6c35052fc2) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndccm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3017pg2.hi", 0x00000, 0x080000, CRC(acb4e681) SHA1(966a83967bdfed941abea200b25fe1a06440016d) )
	ROM_LOAD16_BYTE( "p3017pg2.lo", 0x00001, 0x080000, CRC(8d4b0e8e) SHA1(c48d3aa33911e13ff9af0aca06afe05a72adf3f9) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndccn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3017s71.hi", 0x00000, 0x080000, CRC(df5bd3b0) SHA1(b70190082947a7a1c2aea4bceb12cc032e35b59d) )
	ROM_LOAD16_BYTE( "p3017s71.lo", 0x00001, 0x080000, CRC(2639b43d) SHA1(6b06b122239093cc47af360d4eee7d9cc850dc8f) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndcco )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3017sf1.hi", 0x00000, 0x080000, CRC(3fd02a1b) SHA1(0eb81600349b1a745f24f662fe054148688ba966) )
	ROM_LOAD16_BYTE( "p3017sf1.lo", 0x00001, 0x080000, CRC(d2e45159) SHA1(f4557ba7f97016fba81e6b977981444a3d797a14) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndccp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3017sf2.hi", 0x00000, 0x080000, CRC(47651875) SHA1(f7c48a0e56bd9b748ede58916529aeec8240304f) )
	ROM_LOAD16_BYTE( "p3017sf2.lo", 0x00001, 0x080000, CRC(f7f4333d) SHA1(9e651b1a6422935776dc6eb4276016ea45a21297) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndccq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3017sg1.hi", 0x00000, 0x080000, CRC(2db61930) SHA1(7516dd7ef4ae78afe0fb2a12412e5c9912928aeb) )
	ROM_LOAD16_BYTE( "p3017sg1.lo", 0x00001, 0x080000, CRC(142ed198) SHA1(b4d28917502a2c4f147db115ff637c321dacaa9e) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndccr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3017sg2.hi", 0x00000, 0x080000, CRC(43dd9130) SHA1(c137f3de719c7d41f99e0725bba5be3394af57d6) )
	ROM_LOAD16_BYTE( "p3017sg2.lo", 0x00001, 0x080000, CRC(086f50be) SHA1(082c6469c5611a1e8f9dbcd80339f38657ddc2b4) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndca )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3250p11.hi", 0x00000, 0x080000, CRC(cdd8e6fd) SHA1(c125f8af8193eeec3b143fae185100b490251dae) )
	ROM_LOAD16_BYTE( "p3250p11.lo", 0x00001, 0x080000, CRC(0303361b) SHA1(aafa4a680dd919afccba269affde34599164d9d2) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndcaa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3250p12.hi", 0x00000, 0x080000, CRC(c91b43c1) SHA1(a3337f0880d2d7b4e6cb0ea3e2824d0661eb6004) )
	ROM_LOAD16_BYTE( "p3250p12.lo", 0x00001, 0x080000, CRC(38e01a0a) SHA1(178b31725aca4a2676c50466f3d4b61fa831d7e3) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndcab )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3250s11.hi", 0x00000, 0x080000, CRC(f985e611) SHA1(b0436688b83a0900e41fb61a1c09438f9f8663ac) )
	ROM_LOAD16_BYTE( "p3250s11.lo", 0x00001, 0x080000, CRC(11dec07e) SHA1(171345b38f07a5bc1f09d98fe0802a353bafa7c6) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndcac )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3250s12.hi", 0x00000, 0x080000, CRC(7c3de312) SHA1(eaa216152f5e59b029fdb034baebd8c4fbd29794) )
	ROM_LOAD16_BYTE( "p3250s12.lo", 0x00001, 0x080000, CRC(fd2d6f53) SHA1(be1b3ac89b6cece9f34498bd4f1a0541da689df5) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndcad )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3362p71.hi", 0x00000, 0x080000, CRC(a6fe0aef) SHA1(10a17944dbca7624ed451d7187edc89c582ecb8b) )
	ROM_LOAD16_BYTE( "p3362p71.lo", 0x00001, 0x080000, CRC(a8cf3b5c) SHA1(d802560eb43c51571f39389011ec3e5bae68659f) )
	sc_dndcc_others
ROM_END

ROM_START( sc5dndcae )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3362s71.hi", 0x00000, 0x080000, CRC(2f609ab3) SHA1(2e0cf0b2dc91f4bc3bb9c6dcc2716491eef01c99) )
	ROM_LOAD16_BYTE( "p3362s71.lo", 0x00001, 0x080000, CRC(2af6741f) SHA1(62e396cfc3a8198e6b62b3d07d9894ed9d8e5f89) )
	sc_dndcc_others
ROM_END


ROM_START( sc5dnddw )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422472.lo", 0x00001, 0x080000, CRC(f97160be) SHA1(76f495ed1ec7901a4529f7106b081864345308c4) )
	ROM_LOAD16_BYTE( "95422473.hi", 0x00000, 0x080000, CRC(adde9c8c) SHA1(b5cc059af817ba49087fc68001c52bc0be3ac974) )
	sc_dnddw_others
ROM_END


ROM_START( sc5dnddwa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423472.lo", 0x00001, 0x080000, CRC(12151eae) SHA1(0dc319849c03b9525844f3097201f4b5811dd84d) )
	ROM_LOAD16_BYTE( "95423473.hi", 0x00000, 0x080000, CRC(bcbfca3c) SHA1(8ac07a77d128f166c681f9528b08654cd7d4f304) )
	sc_dnddw_others
ROM_END


ROM_START( sc5dnddwb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426174.lo", 0x00001, 0x080000, CRC(c78e421b) SHA1(54b065ffae73e39ef7d410d7488f7df7fd6923c1) )
	ROM_LOAD16_BYTE( "95426175.hi", 0x00000, 0x080000, CRC(11e52921) SHA1(14c792918b0b09b6903b2506baa0ef3b67787c29) )
	sc_dnddw_others
ROM_END


ROM_START( sc5dnddwc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426272.lo", 0x00001, 0x080000, CRC(b55f8e84) SHA1(722a7568dab93c6e6717787f98c3ac1c4f0dfc52) )
	ROM_LOAD16_BYTE( "95426273.hi", 0x00000, 0x080000, CRC(d6c652e2) SHA1(51f21b2c8d6ba814f3a8fd880fc4c0a088e4a0fc) )
	sc_dnddw_others
ROM_END

ROM_START( sc5dnddwd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427174.lo", 0x00001, 0x080000, CRC(d796a1bd) SHA1(a4e8e2142b852f1aa67cac9bb12b490d9c72f6a5) )
	ROM_LOAD16_BYTE( "95427175.hi", 0x00000, 0x080000, CRC(c8fd8e4e) SHA1(2837297b745dd44388067df3d905413f05e02d10) )
	sc_dnddw_others
ROM_END

ROM_START( sc5dnddwe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427272.lo", 0x00001, 0x080000, CRC(c16a327e) SHA1(aa125f3e4ae640050ca117ab79d2e212125da540) )
	ROM_LOAD16_BYTE( "95427273.hi", 0x00000, 0x080000, CRC(e4fefd0f) SHA1(5fb8700e4b8cf7493de64f5c6c24c98386256727) )
	sc_dnddw_others
ROM_END

ROM_START( sc5dnddwf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3202p01.hi", 0x00000, 0x080000, CRC(c4dbbc10) SHA1(eaf716c867db96001cd4011bdf34088ef7b63c23) )
	ROM_LOAD16_BYTE( "p3202p01.lo", 0x00001, 0x080000, CRC(9ce75b13) SHA1(3981602a789ce0e435fd35143edb1b39cfd5a101) )
	sc_dnddw_others
ROM_END

ROM_START( sc5dnddwg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3202s01.hi", 0x00000, 0x080000, CRC(104f2021) SHA1(889a347fa799b00bff196bd3fd8a1257ce07bb2f) )
	ROM_LOAD16_BYTE( "p3202s01.lo", 0x00001, 0x080000, CRC(6c490f0f) SHA1(661bfc67aaea82e34de2d606a1779f4102ded05a) )
	sc_dnddw_others
ROM_END

ROM_START( sc5dnddwh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423666.lo", 0x00001, 0x080000, CRC(b324f0bc) SHA1(6e2dcec5ec0e7415064c4855401429ff13b3d320) )
	ROM_LOAD16_BYTE( "95423667.hi", 0x00000, 0x080000, CRC(4673fd1b) SHA1(523256163119d48751698dff864bc4dbceb9fbe2) )
	sc_dnddw_others
ROM_END

ROM_START( sc5dnddwi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422666.lo", 0x00001, 0x080000, CRC(6da9be2f) SHA1(c4aa54797d5407c80ae980bf2820292bf90fbfbf) )
	ROM_LOAD16_BYTE( "95422667.hi", 0x00000, 0x080000, CRC(c7981c1e) SHA1(01589186cf63a0e03dfd1ed96898717dcb2c3dcc) )
	sc_dnddw_others
ROM_END


ROM_START( sc5dnddf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422284.lo", 0x00001, 0x080000, CRC(eb0f6493) SHA1(fe3efe77d8686cbe24562ba617a9fdc6a0b966cc) )
	ROM_LOAD16_BYTE( "95422285.hi", 0x00000, 0x080000, CRC(a6d37a4d) SHA1(4f9bb99f70af06fc0a010aa03916780f8358357f) )
	sc_dnddf_others
ROM_END

ROM_START( sc5dnddfa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422456.lo", 0x00001, 0x080000, CRC(3bcd2b48) SHA1(6d60fcd8d7d6f4585954f77c4d29d08787727f53) )
	ROM_LOAD16_BYTE( "95422457.hi", 0x00000, 0x080000, CRC(cbfb2069) SHA1(016f64a65787f2d0752502334b898a4a198b2385) )
	sc_dnddf_others
ROM_END

ROM_START( sc5dnddfb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422502.lo", 0x00001, 0x080000, CRC(75f83e37) SHA1(fadaec98363926cedd4529c5737bb012f0f6612a) )
	ROM_LOAD16_BYTE( "95422503.hi", 0x00000, 0x080000, CRC(d4130535) SHA1(213905095265db0c430b5216861d60f5ae9b0780) )
	sc_dnddf_others
ROM_END

ROM_START( sc5dnddfc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422682.lo", 0x00001, 0x080000, CRC(616cf372) SHA1(09c494c31c4e4387879924c61e40472854b0698f) )
	ROM_LOAD16_BYTE( "95422683.hi", 0x00000, 0x080000, CRC(a5306717) SHA1(8665d2cfec7e3b6eb370b9bd14532aa91e6b363a) )
	sc_dnddf_others
ROM_END

ROM_START( sc5dnddfd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423284.lo", 0x00001, 0x080000, CRC(1b5d3e9f) SHA1(c6d0284df73e6b10b5f74cd2de3b948869b8d1d7) )
	ROM_LOAD16_BYTE( "95423285.hi", 0x00000, 0x080000, CRC(01086558) SHA1(257ec02fd1d00076a0fa710cd0443a2ade32dd7b) )
	sc_dnddf_others
ROM_END

ROM_START( sc5dnddfe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423456.lo", 0x00001, 0x080000, CRC(9efff5a9) SHA1(58613b6b0a2bff824e7a5cbc1b80cecbe3ad3e17) )
	ROM_LOAD16_BYTE( "95423457.hi", 0x00000, 0x080000, CRC(9bcb67c7) SHA1(db791d68fd72131d51f119a7e8f6914e3d7038a0) )
	sc_dnddf_others
ROM_END

ROM_START( sc5dnddff )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423502.lo", 0x00001, 0x080000, CRC(fbadd21c) SHA1(ec3f6f468624063d108ac8b02f6d371e1789d555) )
	ROM_LOAD16_BYTE( "95423503.hi", 0x00000, 0x080000, CRC(e4a3f201) SHA1(469247460df805751c8a489f0154469a1f67fc2d) )
	sc_dnddf_others
ROM_END

ROM_START( sc5dnddfg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426060.lo", 0x00001, 0x080000, CRC(f3b08078) SHA1(c8bb1b5d2fa7e49b09e17cc2980faf0cd9ff01a5) )
	ROM_LOAD16_BYTE( "95426061.hi", 0x00000, 0x080000, CRC(ddde776b) SHA1(8e103a619fdc976d5d2784c65c46cb3278c12748) )
	sc_dnddf_others
ROM_END

ROM_START( sc5dnddfh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426284.lo", 0x00001, 0x080000, CRC(fb462241) SHA1(c28db0b4a0fd637ffefc8eba79e4f2eb47923832) )
	ROM_LOAD16_BYTE( "95426285.hi", 0x00000, 0x080000, CRC(9c0711ce) SHA1(60cb6de9fdbac5e034ef0af11546df28546434e5) )
	sc_dnddf_others
ROM_END

ROM_START( sc5dnddfi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427060.lo", 0x00001, 0x080000, CRC(318432f1) SHA1(65ad45a682e771aae7caac824891ccc66d3bd203) )
	ROM_LOAD16_BYTE( "95427061.hi", 0x00000, 0x080000, CRC(5d733694) SHA1(0ae447411ecc6bf0d8cceb42a3da2684b9488b66) )
	sc_dnddf_others
ROM_END

ROM_START( sc5dnddfj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427284.lo", 0x00001, 0x080000, CRC(5f07e80d) SHA1(23fbbf203e95ce13df929fb776d764438131600f) )
	ROM_LOAD16_BYTE( "95427285.hi", 0x00000, 0x080000, CRC(30c3c90d) SHA1(3a2940a3619147c7cd948e7dee0a6d1924892c98) )
	sc_dnddf_others
ROM_END

ROM_START( sc5dnddfk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3014p71.hi", 0x00000, 0x080000, CRC(2e401da4) SHA1(35dfaeecd8a7986e79f2e9f68b30911fc70d477c) )
	ROM_LOAD16_BYTE( "p3014p71.lo", 0x00001, 0x080000, CRC(403ea361) SHA1(5f63e5eb36f9479533abc54c85fe64d90cd82655) )
	sc_dnddf_others
ROM_END

ROM_START( sc5dnddfl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3014p72.hi", 0x00000, 0x080000, CRC(7948f231) SHA1(f118990d671d906b31b8853acbbf314986aa9447) )
	ROM_LOAD16_BYTE( "p3014p72.lo", 0x00001, 0x080000, CRC(75bfcdbb) SHA1(8c7167d5fa3e085012ab733704c9947c253828ba) )
	sc_dnddf_others
ROM_END

ROM_START( sc5dnddfm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3014s71.hi", 0x00000, 0x080000, CRC(c1752c29) SHA1(07a873407c27158fc8975df7dd966adf04bd454c) )
	ROM_LOAD16_BYTE( "p3014s71.lo", 0x00001, 0x080000, CRC(ea5dca3e) SHA1(0b9a7f88f5d50798e1f3c18607b74603f15d7cee) )
	sc_dnddf_others
ROM_END

ROM_START( sc5dnddfn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3014s72.hi", 0x00000, 0x080000, CRC(04a3ace6) SHA1(bf7ad6bbace77fb4871a3e70d3b55ea4c8be14e1) )
	ROM_LOAD16_BYTE( "p3014s72.lo", 0x00001, 0x080000, CRC(7e9ae598) SHA1(c3ac01dabbcff1b33ea204db882e330713ffb84a) )
	sc_dnddf_others
ROM_END


ROM_START( sc5dndpg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426232.lo", 0x00001, 0x080000, CRC(fa9c8cc7) SHA1(2190f76cfa94c69fcc153cadb360f84b306203cb) )
	ROM_LOAD16_BYTE( "95426233.hi", 0x00000, 0x080000, CRC(44af356d) SHA1(b162527e089e39baab1fbd35927c926676c50e63) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpga )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426366.lo", 0x00001, 0x080000, CRC(fe9c0d28) SHA1(178c7f2cdfc28079c5a4b507095a032ecd2ee7a9) )
	ROM_LOAD16_BYTE( "95426367.hi", 0x00000, 0x080000, CRC(ee8fb979) SHA1(14b138a7c9c6358dda8331ca55cd1223883a8222) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426380.lo", 0x00001, 0x080000, CRC(70b248f1) SHA1(ad608dc7f58411275480f3f916775ba0000706b1) )
	ROM_LOAD16_BYTE( "95426381.hi", 0x00000, 0x080000, CRC(f9646a03) SHA1(b40466a0f4ef5ee097dd049384cea04a60654e11) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426404.lo", 0x00001, 0x080000, CRC(d76543dc) SHA1(9a31cafccdc3c0f8f8598cefe42be658f2e577f1) )
	ROM_LOAD16_BYTE( "95426405.hi", 0x00000, 0x080000, CRC(782b119b) SHA1(7c08e01f85aa0cca5332b51ff52c1e36aee6fc94) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426426.lo", 0x00001, 0x080000, CRC(e31ce5cc) SHA1(ea447fd1518f2c426733dbc733eadd9a84d55c3f) )
	ROM_LOAD16_BYTE( "95426427.hi", 0x00000, 0x080000, CRC(3e58dec4) SHA1(3a0dbaab826296fa59a83da2c524512442e185f5) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpge )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426446.lo", 0x00001, 0x080000, CRC(ddd0c767) SHA1(f5b1ed561a39de2bc08fb5648a2a3788d91db271) )
	ROM_LOAD16_BYTE( "95426447.hi", 0x00000, 0x080000, CRC(9c7c988a) SHA1(0de04d25fb9dc316820f3f7a0c306531ee7380fc) )
	sc_dndpg_others
ROM_END


ROM_START( sc5dndpgf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426666.lo", 0x00001, 0x080000, CRC(128c14fa) SHA1(b942d78ba79469b71387ffa47d5884b7730823dc) )
	ROM_LOAD16_BYTE( "95426667.hi", 0x00000, 0x080000, CRC(de2697ce) SHA1(6b5cf49f4d3baae0a05d2325b871b4a63f1ffb9e) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426702.lo", 0x00001, 0x080000, CRC(01cfd953) SHA1(e75b3d21b8491e39a047aa0e5eb7cabe1ea53d87) )
	ROM_LOAD16_BYTE( "95426703.hi", 0x00000, 0x080000, CRC(d7d22dfb) SHA1(c8b767a535aaf82ae684959701b99c173b3b1191) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426810.lo", 0x00001, 0x080000, CRC(4a137784) SHA1(7b4f70192ea8e1d4f2cd2fa56bc464d8031d5236) )
	ROM_LOAD16_BYTE( "95426811.hi", 0x00000, 0x080000, CRC(598477f3) SHA1(614c84cb83d394cf372384f24046e84e3e13a25b) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427232.lo", 0x00001, 0x080000, CRC(6693042f) SHA1(6d06160a6964ed0047b3526a34f8e3890518e63a) )
	ROM_LOAD16_BYTE( "95427233.hi", 0x00000, 0x080000, CRC(1e98badb) SHA1(5c02735ce82518b8008dc656e0d1bb3d4946aa83) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427366.lo", 0x00001, 0x080000, CRC(728301da) SHA1(b457d1ab5e58ab86918e74721f7163bc7857525d) )
	ROM_LOAD16_BYTE( "95427367.hi", 0x00000, 0x080000, CRC(eda3fb25) SHA1(94482e87f2516adee23dc6745ca80aac23433e83) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427380.lo", 0x00001, 0x080000, CRC(90ab59fe) SHA1(a6c04779e12952e633d12790cb92efe6f773246a) )
	ROM_LOAD16_BYTE( "95427381.hi", 0x00000, 0x080000, CRC(41978897) SHA1(431a84d2bb41d788b5528ce5ecbfede4ce4d4927) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427404.lo", 0x00001, 0x080000, CRC(adca905e) SHA1(0643bfc4b64df6ace3bfb399ec4a13f518bc5add) )
	ROM_LOAD16_BYTE( "95427405.hi", 0x00000, 0x080000, CRC(d4886745) SHA1(b1d0786d5cfcbfd0b6670de70000f6d6e6500c37) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427426.lo", 0x00001, 0x080000, CRC(5144c846) SHA1(6c346d0ad497de903fe35c2c076696076585670e) )
	ROM_LOAD16_BYTE( "95427427.hi", 0x00000, 0x080000, CRC(d8f6433b) SHA1(4cc8f2a1fd1a916804a2de9e6668521489d776f5) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427446.lo", 0x00001, 0x080000, CRC(2578e7a7) SHA1(417230f706b0a1e1a32b0f0a39752e9a9bef2a57) )
	ROM_LOAD16_BYTE( "95427447.hi", 0x00000, 0x080000, CRC(da7bd1d8) SHA1(7f6e1a8b990f54374fda2162edd6bac85367e0e3) )
	sc_dndpg_others
ROM_END


ROM_START( sc5dndpgo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427666.lo", 0x00001, 0x080000, CRC(3624bdaa) SHA1(17d9918476ff23400a55ce72f4b038545ece6668) )
	ROM_LOAD16_BYTE( "95427667.hi", 0x00000, 0x080000, CRC(35166051) SHA1(57d6758794597414883426b0112cb984513faf86) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427702.lo", 0x00001, 0x080000, CRC(57bf542e) SHA1(bf1dc998d3472ebfd35e8778dfe5a561c6728d12) )
	ROM_LOAD16_BYTE( "95427703.hi", 0x00000, 0x080000, CRC(98693c7d) SHA1(88fd28dfc5bc9d3bd00c18d7c3d248770a35e883) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427810.lo", 0x00001, 0x080000, CRC(da6d842e) SHA1(434db0bfac4293fc826890d39af541fb0685425d) )
	ROM_LOAD16_BYTE( "95427811.hi", 0x00000, 0x080000, CRC(c7be037f) SHA1(22faa06d1a7bfda44a731403f13c4b28a4cdfd92) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3220p11.hi", 0x00000, 0x080000, CRC(5ebe8890) SHA1(9acac09d17582bc0c2b51005b0d17a371e5a2415) )
	ROM_LOAD16_BYTE( "p3220p11.lo", 0x00001, 0x080000, CRC(f68cfed0) SHA1(be6f5abea8a3595212caefc6f2d91da41ea6ffaf) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgs )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3220p12.hi", 0x00000, 0x080000, CRC(ab9c4e42) SHA1(2faa0863a281920d35c9ff31be8bf5daa689fb6f) )
	ROM_LOAD16_BYTE( "p3220p12.lo", 0x00001, 0x080000, CRC(801d9e1e) SHA1(b406a17dd0973984e7be67cd38509495e20ccf10) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgt )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3220s11.hi", 0x00000, 0x080000, CRC(0de2519f) SHA1(99d17ae50aee2eaf7cf26d8b5e65512fe6358b23) )
	ROM_LOAD16_BYTE( "p3220s11.lo", 0x00001, 0x080000, CRC(6f022e6c) SHA1(99c52203962df4fec88fe1fc96593b9dd5bcabbe) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpgu )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3220s12.hi", 0x00000, 0x080000, CRC(b2f62e15) SHA1(8eac8db5009e23dfda03fbae126e17568e410da7) )
	ROM_LOAD16_BYTE( "p3220s12.lo", 0x00001, 0x080000, CRC(0fc2da88) SHA1(55b3214f37e50e1630704f11d218949c7d1c8fca) )
	sc_dndpg_others
ROM_END


ROM_START( sc5dndpl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426570.lo", 0x00001, 0x080000, CRC(e0b4620b) SHA1(663ae8b6f0acc3dbe3ba5e7371c82fd694182a7b) )
	ROM_LOAD16_BYTE( "95426571.hi", 0x00000, 0x080000, CRC(b4d87788) SHA1(ab722de9fd11757def819bfe50f3755e4f788e24) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndpla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426596.lo", 0x00001, 0x080000, CRC(cdef5990) SHA1(2dfb32351fd8e6eff337a927a6c6a36364489fa9) )
	ROM_LOAD16_BYTE( "95426597.hi", 0x00000, 0x080000, CRC(78594563) SHA1(14b6c2b9e04eb9c4ae84542ebbe21341da74fca5) )
	sc_dndpg_others
ROM_END


ROM_START( sc5dndplb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427570.lo", 0x00001, 0x080000, CRC(4ef77665) SHA1(3b8795744bb825bead456acdc15ca5a9063ca02e) )
	ROM_LOAD16_BYTE( "95427571.hi", 0x00000, 0x080000, CRC(93e43f00) SHA1(d8f8cc577b5e570d3c0ed21b272f5a0c2498ccad) )
	sc_dndpg_others
ROM_END

ROM_START( sc5dndplc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427596.lo", 0x00001, 0x080000, CRC(159ec691) SHA1(423d07ff54e9e7bc9376141168df497f1d60ad43) )
	ROM_LOAD16_BYTE( "95427597.hi", 0x00000, 0x080000, CRC(ea465981) SHA1(edff2ec9e273e07aed73792cf8624c58075cf847) )
	sc_dndpg_others
ROM_END

ROM_START( ad5dndpg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASE00 )
	ROM_LOAD( "39211613.bin", 0x0000, 0x1000000, CRC(98495946) SHA1(4c3d5d0731dfdaad37cee317a5d862ff46665ebd) )
	ROM_LOAD( "39212613.bin", 0x0000, 0x1000000, CRC(1b0deb8f) SHA1(e27aafa91f5a9ca9064e6e89af5f86c305715efc) )
    ROM_LOAD( "39211620.bin", 0x00000, 0x1000000, CRC(4b2fb445) SHA1(b50d57500d58199013f7ee4dee535578b63ddb7e) )
	ROM_LOAD( "39212620.bin", 0x00000, 0x1000000, CRC(7f1f31a1) SHA1(9a8a826e73e91decce7b7315816b2c74bb37fcd9) )
ROM_END



ROM_START( sc5dndtp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418704.lo", 0x00001, 0x080000, CRC(95f494e1) SHA1(f4f8aa5974e335c907fa03ba88ebf7fdf69dbb2a) )
	ROM_LOAD16_BYTE( "95418705.hi", 0x00000, 0x080000, CRC(ab485cec) SHA1(59524b6f03649b93cc7b0832790c9151a2710787) )
	sc_dndtp_others
ROM_END

ROM_START( sc5dndtpa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418728.lo", 0x00001, 0x080000, CRC(7e29bd08) SHA1(01715e41e1b057a5db050b6c24a7ada11125d9b3) )
	ROM_LOAD16_BYTE( "95418729.hi", 0x00000, 0x080000, CRC(28e38bfb) SHA1(9166e3555f97a6c4882e42c4d2f4ec6d67341f01) )
	sc_dndtp_others
ROM_END

ROM_START( sc5dndtpb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418786.lo", 0x00001, 0x080000, CRC(0d7db391) SHA1(38fddfafd801ad32e6ac6352fdb292cd42c01e94) )
	ROM_LOAD16_BYTE( "95418787.hi", 0x00000, 0x080000, CRC(7e07e449) SHA1(3233cd3db92b56b85ad3a61682786bfada48e616) )
	sc_dndtp_others
ROM_END

ROM_START( sc5dndtpc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419704.lo", 0x00001, 0x080000, CRC(400835ac) SHA1(f521c2f79ab1f19370ee0c903a6e136f09828d63) )
	ROM_LOAD16_BYTE( "95419705.hi", 0x00000, 0x080000, CRC(f325b428) SHA1(c014d6433b2144d12c521bb7ff9468b4fe9b582a) )
	sc_dndtp_others
ROM_END

ROM_START( sc5dndtpd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419728.lo", 0x00001, 0x080000, CRC(534b968e) SHA1(83e5267022ad8aa57335b5d4b136bd478c417f18) )
	ROM_LOAD16_BYTE( "95419729.hi", 0x00000, 0x080000, CRC(bb986c64) SHA1(6e0e3560866c718e7968e2241bafa348b544af62) )
	sc_dndtp_others
ROM_END


ROM_START( sc5dndtpe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419786.lo", 0x00001, 0x080000, CRC(799dd38a) SHA1(f8b0c5734b698e453b496b94db42b2de30da0fc5) )
	ROM_LOAD16_BYTE( "95419787.hi", 0x00000, 0x080000, CRC(cf7dcf89) SHA1(83be5f970028115eb3fc1bb0b37278a18a5d8ee2) )
	sc_dndtp_others
ROM_END

ROM_START( sc5dndtpf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422004.lo", 0x00001, 0x080000, CRC(419bd389) SHA1(ff8dcc4413a669c7f32155f98bab93e168d8e926) )
	ROM_LOAD16_BYTE( "95422005.hi", 0x00000, 0x080000, CRC(779b8aeb) SHA1(8510615e5adaf78f03a6fdf4862cec2f9f6eb002) )
	sc_dndtp_others
ROM_END


ROM_START( sc5dndtpg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422104.lo", 0x00001, 0x080000, CRC(8beebb7f) SHA1(5c7c9b53852ed1b53a7ab2bdd659ccfd1027ee7b) )
	ROM_LOAD16_BYTE( "95422105.hi", 0x00000, 0x080000, CRC(b890efee) SHA1(f4a04f7ab3289795a0441aeda04420c0a94e3713) )
	sc_dndtp_others
ROM_END



ROM_START( sc5dndtph )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422560.lo", 0x00001, 0x080000, CRC(7ea0fcf7) SHA1(f35cf6614b0d0e4b622886a52f2af289ad5e42a1) )
	ROM_LOAD16_BYTE( "95422561.hi", 0x00000, 0x080000, CRC(4a96c226) SHA1(394293f4a04c0d55920f3629f395aaa0a7e6c863) )
	sc_dndtp_others
ROM_END


ROM_START( sc5dndtpi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422854.lo", 0x00001, 0x080000, CRC(803e9182) SHA1(79e31359916aab21d73942d0cf73fc393bd5fad2) )
	ROM_LOAD16_BYTE( "95422855.hi", 0x00000, 0x080000, CRC(bc307337) SHA1(0486fdc75b057fec7916b55b0e942902fc09117c) )
	sc_dndtp_others
ROM_END


ROM_START( sc5dndtpj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423004.lo", 0x00001, 0x080000, CRC(a6074967) SHA1(318ab8e2387190571dd530a233de04d6740ccb2f) )
	ROM_LOAD16_BYTE( "95423005.hi", 0x00000, 0x080000, CRC(7189a970) SHA1(b5f9ce0011d18dd300068d39dd3e80261552634c) )
	sc_dndtp_others
ROM_END


ROM_START( sc5dndtpk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423104.lo", 0x00001, 0x080000, CRC(f589546e) SHA1(5589f70ded14169625a7d0d0c20570b6331f4c4e) )
	ROM_LOAD16_BYTE( "95423105.hi", 0x00000, 0x080000, CRC(7f19996b) SHA1(026c5c9ec9e3fffba22f3b41342624bf939a792b) )
	sc_dndtp_others
ROM_END


ROM_START( sc5dndtpl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423560.lo", 0x00001, 0x080000, CRC(dd45b408) SHA1(6164f8fb344a6ae3eca05dd287469397d1ce28ab) )
	ROM_LOAD16_BYTE( "95423561.hi", 0x00000, 0x080000, CRC(d91f1c00) SHA1(8f51a52335c1dccf6a3ca7f4979fccbef5126cf9) )
	sc_dndtp_others
ROM_END


ROM_START( sc5dndtpm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423854.lo", 0x00001, 0x080000, CRC(e69e8798) SHA1(2f2b0a18cc951919e31cb3cef9ad0e18cf95608b) )
	ROM_LOAD16_BYTE( "95423855.hi", 0x00000, 0x080000, CRC(4b41bd66) SHA1(23ef72f41e533b3b840f81264f39591f0d7c4bb4) )
	sc_dndtp_others
ROM_END


ROM_START( sc5dndtpn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426140.lo", 0x00001, 0x080000, CRC(8add007d) SHA1(d83b5b9d22c99e81d9af2b52840e29d6363b1132) )
	ROM_LOAD16_BYTE( "95426141.hi", 0x00000, 0x080000, CRC(b9b0d254) SHA1(3ea53e041cab25dd7d8dba951461320f58556d6d) )
	sc_dndtp_others
ROM_END


ROM_START( sc5dndtpo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427140.lo", 0x00001, 0x080000, CRC(ed5abd3b) SHA1(ea6ec8646d7250f36f1fde34d07907d3b2322d29) )
	ROM_LOAD16_BYTE( "95427141.hi", 0x00000, 0x080000, CRC(8013d590) SHA1(43fbce8ab63873e8b875b9f35d7a8d777ae2b4db) )
	sc_dndtp_others
ROM_END


ROM_START( sc5dndtpp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3003p42.hi", 0x00000, 0x080000, CRC(6884132e) SHA1(0a864012b36887de2dc1290bb93d533e45f7e85a) )
	ROM_LOAD16_BYTE( "p3003p42.lo", 0x00001, 0x080000, CRC(46fd164a) SHA1(c7c70773a1327200fa58818f3d23cabb48ab4ba5) )
	sc_dndtp_others
ROM_END


ROM_START( sc5dndtpq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3003p43.hi", 0x00000, 0x080000, CRC(81ff5970) SHA1(8e3d6dfcfd3fa69bdb0ee391ad3257813fd88349) )
	ROM_LOAD16_BYTE( "p3003p43.lo", 0x00001, 0x080000, CRC(00720267) SHA1(98b30f4bea5e284ab15f230794982d754b3221f0) )
	sc_dndtp_others
ROM_END


ROM_START( sc5dndtpr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3003s42.hi", 0x00000, 0x080000, CRC(f04b7cd3) SHA1(b3b2c77d6458d901da4aa7057f2c4a9bf67df759) )
	ROM_LOAD16_BYTE( "p3003s42.lo", 0x00001, 0x080000, CRC(71d96983) SHA1(e896334a9ea517bbc20eb06eb8682b7a884b37e6) )
	sc_dndtp_others
ROM_END


ROM_START( sc5dndtps )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3003s43.hi", 0x00000, 0x080000, CRC(7935ef60) SHA1(6bc427dc8a313e767240154158ba6eb729d38626) )
	ROM_LOAD16_BYTE( "p3003s43.lo", 0x00001, 0x080000, CRC(1d6aa120) SHA1(edefc11b1bb35fb44c416b34f6f1da20502728ad) )
	sc_dndtp_others
ROM_END

ROM_START( sc5dndtpt )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422010.lo", 0x00001, 0x080000, CRC(aa27467d) SHA1(28e834b798ce2778cec8001fa553a9d82094ef73) )
	ROM_LOAD16_BYTE( "95422011.hi", 0x00000, 0x080000, CRC(3fd5debb) SHA1(d511226c039f2b41c3122863a9764adc4a9330bf) )
	sc_dndtp_others
ROM_END

ROM_START( sc5dndtpu )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423010.lo", 0x00001, 0x080000, CRC(62f9f024) SHA1(46bfb758ed6508b4e01779038a5a94da22e7b3b7) )
	ROM_LOAD16_BYTE( "95423011.hi", 0x00000, 0x080000, CRC(a27f40db) SHA1(78c8eff3c6066005b5b044c95aef0bb0fb53ac18) )
	sc_dndtp_others
ROM_END



ROM_START( sc5dndtr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426372.lo", 0x00001, 0x080000, CRC(772e3c92) SHA1(6eb73c4663c2820b2d111baf8c9756bb808b8e21) )
	ROM_LOAD16_BYTE( "95426373.hi", 0x00000, 0x080000, CRC(373381d3) SHA1(c3ed6b7c0bffd6817a72dc2a58abe1242732e1d7) )
	sc_dndtr_others
ROM_END

ROM_START( sc5dndtra )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426420.lo", 0x00001, 0x080000, CRC(31604ce1) SHA1(222b278ad7469e8db8bc9a48739688fe1f6d1a4a) )
	ROM_LOAD16_BYTE( "95426421.hi", 0x00000, 0x080000, CRC(80b5b150) SHA1(6225e47c4411569a0337c5e5f602e83d27185715) )
	sc_dndtr_others
ROM_END

ROM_START( sc5dndtrb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426466.lo", 0x00001, 0x080000, CRC(7e941269) SHA1(3a000a18f6fbc3bdcd33dee6b334e25973a7336d) )
	ROM_LOAD16_BYTE( "95426467.hi", 0x00000, 0x080000, CRC(f76217ec) SHA1(103a751c876ed804e6dddf02fcc9d08e808750ae) )
	sc_dndtr_others
ROM_END

ROM_START( sc5dndtrc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426664.lo", 0x00001, 0x080000, CRC(41cd4608) SHA1(8cc3568fc83d5d66a00808857a08d0e0bbbc363d) )
	ROM_LOAD16_BYTE( "95426665.hi", 0x00000, 0x080000, CRC(3cacdecb) SHA1(2775e20f9a69077130c9c55b55140bc0b0dbf79a) )
	sc_dndtr_others
ROM_END

ROM_START( sc5dndtrd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426700.lo", 0x00001, 0x080000, CRC(11d5772c) SHA1(c0128c1b6d8f8f1efa334e7a75ef16be85895b2e) )
	ROM_LOAD16_BYTE( "95426701.hi", 0x00000, 0x080000, CRC(9f6a98ca) SHA1(af1f454261b3ca6fd6cfdbd5748de9fa6d67503b) )
	sc_dndtr_others
ROM_END

ROM_START( sc5dndtre )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427372.lo", 0x00001, 0x080000, CRC(83fd5056) SHA1(cf8b233bae2aee18b39847f022037a9a0e54663c) )
	ROM_LOAD16_BYTE( "95427373.hi", 0x00000, 0x080000, CRC(bd6fe15e) SHA1(716d0ba7768d8819a3dbad15911f15608b92a9e4) )
	sc_dndtr_others
ROM_END

ROM_START( sc5dndtrf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427420.lo", 0x00001, 0x080000, CRC(42c84630) SHA1(0f1385adccbe167e8d68ae3aa1fe4f1ad6eda32d) )
	ROM_LOAD16_BYTE( "95427421.hi", 0x00000, 0x080000, CRC(afe268f7) SHA1(2ba6d9c4d902c843e2c2785f3cf817521a221759) )
	sc_dndtr_others
ROM_END

ROM_START( sc5dndtrg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427466.lo", 0x00001, 0x080000, CRC(42aab7e2) SHA1(fa1f63233b32675e6e637ab4ae10a6fce5dcd76a) )
	ROM_LOAD16_BYTE( "95427467.hi", 0x00000, 0x080000, CRC(d79e07ba) SHA1(f5a1f67beff046922e11c4676ecc17bfeca3df91) )
	sc_dndtr_others
ROM_END

ROM_START( sc5dndtrh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427664.lo", 0x00001, 0x080000, CRC(42daf573) SHA1(6a75b010bc5e45cc1b258f4a8c335158d55fb8af) )
	ROM_LOAD16_BYTE( "95427665.hi", 0x00000, 0x080000, CRC(76d228d2) SHA1(7ffbfe6220a4a4ee716f3cc1ca320c158db0d1a6) )
	sc_dndtr_others
ROM_END

ROM_START( sc5dndtri )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427700.lo", 0x00001, 0x080000, CRC(03b1f74b) SHA1(a645df6f5e008e97ed69d11945b2e64c89a3c63d) )
	ROM_LOAD16_BYTE( "95427701.hi", 0x00000, 0x080000, CRC(1ff5b8e1) SHA1(ee20c9f18342a2f021d7624ee15f2d667a5ee8c6) )
	sc_dndtr_others
ROM_END

ROM_START( sc5dndtrj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3304p71.hi", 0x00000, 0x080000, CRC(7a637d7b) SHA1(f887f24dd79118d2ff20d957b95ed6dfac0d34b7) )
	ROM_LOAD16_BYTE( "p3304p71.lo", 0x00001, 0x080000, CRC(8b1373c5) SHA1(cf750a549ec2f96f2c237e44a0767fdd7765b953) )
	sc_dndtr_others
ROM_END

ROM_START( sc5dndtrk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3304s71.hi", 0x00000, 0x080000, CRC(f11527af) SHA1(f2c2ce48716d961e1df31dd391205381d7df1e4e) )
	ROM_LOAD16_BYTE( "p3304s71.lo", 0x00001, 0x080000, CRC(6a5f17cf) SHA1(e7d2f7a9a1b4071b2f33de3dfb1ca211f9ee07f8) )
	sc_dndtr_others
ROM_END


ROM_START( sc5dndcb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418992.lo", 0x00001, 0x080000, CRC(2bddf06e) SHA1(59e2c78e8da681fa842605b4834eb2e1440f9ad7) )
	ROM_LOAD16_BYTE( "95418993.hi", 0x00000, 0x080000, CRC(27a65baf) SHA1(506b20c825698210ea07096c6b0892fd0ce7ee42) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END

ROM_START( sc5dndcba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419992.lo", 0x00001, 0x080000, CRC(79d9ebe5) SHA1(cc0e75af683a742407de65d2854644a9be9937df) )
	ROM_LOAD16_BYTE( "95419993.hi", 0x00000, 0x080000, CRC(e546a0e7) SHA1(070677430430c35ab5ca616f7688e700b72e9e5f) )
	PR3068_BEAT_THE_BANKER_SOUNDS11
ROM_END


ROM_START( sc5dndww )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418860.lo", 0x00001, 0x080000, CRC(955480f9) SHA1(a35484c215cc966bfd3309054ef9e00c470e6644) )
	ROM_LOAD16_BYTE( "95418861.hi", 0x00000, 0x080000, CRC(87ce7115) SHA1(953ccb59b8002c7d3b1c09097a49999a4fe74167) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwwa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418990.lo", 0x00001, 0x080000, CRC(d40b5d13) SHA1(12a6d2f628a46fa0c27d61636afa05291756f301) )
	ROM_LOAD16_BYTE( "95418991.hi", 0x00000, 0x080000, CRC(94612065) SHA1(562faef92e2f7d44e06a8cc9d11f7ad041f0ef49) )
	sc_dndww_others
ROM_END




ROM_START( sc5dndwwb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419860.lo", 0x00001, 0x080000, CRC(68f7a054) SHA1(eaaab4e7d5dac40e50f098df2edf1109ac5f6d1c) )
	ROM_LOAD16_BYTE( "95419861.hi", 0x00000, 0x080000, CRC(a8f4dafb) SHA1(663b08bda6a708ca502ed194aa2682d4d3d9867f) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwwc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419990.lo", 0x00001, 0x080000, CRC(5225460f) SHA1(5868d1f79e1741debf68d8f022b5f937b5a9ca8f) )
	ROM_LOAD16_BYTE( "95419991.hi", 0x00000, 0x080000, CRC(69ba0af5) SHA1(2468d881695f9fba308a72f1d4ea202d43b3da9b) )
	sc_dndww_others
ROM_END


ROM_START( sc5dndwwd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422000.lo", 0x00001, 0x080000, CRC(7bb6d900) SHA1(05203cad5e0d61da1188efec23fee7014a03588f) ) // was in here
	ROM_LOAD16_BYTE( "95422001.hi", 0x00000, 0x080000, CRC(ecc2de87) SHA1(92f58870eddece79645651aa325595a130233194) ) // was in dndtp DND The Power
	sc_dndww_others
ROM_END

ROM_START( sc5dndwwe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422068.lo", 0x00001, 0x080000, CRC(0cc6467c) SHA1(097713378eb7091323837754ae3ebd5e2a2d423b) )
	ROM_LOAD16_BYTE( "95422069.hi", 0x00000, 0x080000, CRC(6297e0ef) SHA1(88c97ff6d8f085a07c10298f2568eacb83ac4fbd) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwwf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422106.lo", 0x00001, 0x080000, CRC(47fdf423) SHA1(9d43b04057729f278d10cf791b5f0674e445aaca) )
	ROM_LOAD16_BYTE( "95422107.hi", 0x00000, 0x080000, CRC(fb5e2d1d) SHA1(d33f67ee35b99ff11b3960ac82eac8fe09df00b9) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422254.lo", 0x00001, 0x080000, CRC(c9297465) SHA1(deb6900bb4fc8b811ff65b7926423f69dabb5124) )
	ROM_LOAD16_BYTE( "95422255.hi", 0x00000, 0x080000, CRC(7f3109e4) SHA1(6575865929caca6b8b4657dddb6734aea599d5e9) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwca )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422296.lo", 0x00001, 0x080000, CRC(7f59b663) SHA1(d094f5dfb74ff2fe8933b7f09035c120997d3d13) )
	ROM_LOAD16_BYTE( "95422297.hi", 0x00000, 0x080000, CRC(744b489a) SHA1(95dfd61b860fb148e41414cfc98793f614dfd40a) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwwg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422512.lo", 0x00001, 0x080000, CRC(6fefd208) SHA1(fb0109ce3398e02181e4f3aef8f6a968fcaf426a) )
	ROM_LOAD16_BYTE( "95422513.hi", 0x00000, 0x080000, CRC(cf951b24) SHA1(2ab79ae80a427659cd3b2d03ebd93bbeaabc215a) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwcb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422514.lo", 0x00001, 0x080000, CRC(53454e22) SHA1(f5fb64197e5e4ea24ed8e6a7155bef83f7d6d301) )
	ROM_LOAD16_BYTE( "95422515.hi", 0x00000, 0x080000, CRC(2dd854e0) SHA1(bbbf0c2c0420494a6853c93df40813e375896ebf) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwwh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422552.lo", 0x00001, 0x080000, CRC(af6f5c75) SHA1(a88216152ce5d47dfc3e354fc0667f370acc0769) )
	ROM_LOAD16_BYTE( "95422553.hi", 0x00000, 0x080000, CRC(cc278af5) SHA1(79aeed9de0930add4d83557ac9a13909bb38738c) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwcc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422772.lo", 0x00001, 0x080000, CRC(69d8ff83) SHA1(c2eb2b9d01ec8f2a3d01bd7b5656abbd4b532edd) )
	ROM_LOAD16_BYTE( "95422773.hi", 0x00000, 0x080000, CRC(a7db59d9) SHA1(2938874327538110cb7fb3881f07f11820704587) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwwi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423000.lo", 0x00001, 0x080000, CRC(c8e6d149) SHA1(07414881aeb787563cb122cce5121889816ba348) ) // was in here
	ROM_LOAD16_BYTE( "95423001.hi", 0x00000, 0x080000, CRC(e26228e7) SHA1(e2cffbf1ef5fd5bb126917599efb40c2195f5a9b) ) // was in dndtp DND The Power
	sc_dndww_others
ROM_END

ROM_START( sc5dndwwj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423068.lo", 0x00001, 0x080000, CRC(75f3254a) SHA1(5eb72ee3bac51b46c3108c4b559016fbe33cad22) )
	ROM_LOAD16_BYTE( "95423069.hi", 0x00000, 0x080000, CRC(9c0dc2c3) SHA1(97a56d9ddbf2198bc9e175784bf22de7a61ed04e) )
	sc_dndww_others
ROM_END


ROM_START( sc5dndwwk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423106.lo", 0x00001, 0x080000, CRC(487342c5) SHA1(bf1fa98544e2e40ff7034c168778c85355c277f8) )
	ROM_LOAD16_BYTE( "95423107.hi", 0x00000, 0x080000, CRC(a4dfbfea) SHA1(ea60a20f75472a4849915b7c7e101accf3673a66) )
	sc_dndww_others
ROM_END


ROM_START( sc5dndwcd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423254.lo", 0x00001, 0x080000, CRC(cbbee6c6) SHA1(b5da1b079f64d3b85dd07ceff1ec3d7dc4f271f0) )
	ROM_LOAD16_BYTE( "95423255.hi", 0x00000, 0x080000, CRC(e246e6bc) SHA1(6bb0f7ac3e455aed48b9e95f8ded6bc81e8f2e3b) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwce )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423296.lo", 0x00001, 0x080000, CRC(6d0e4dd2) SHA1(461c1a1caed4ce32b2cc88cc9efdbb05ede763c5) )
	ROM_LOAD16_BYTE( "95423297.hi", 0x00000, 0x080000, CRC(a4821da7) SHA1(7305e3bcea0cb21ee632321ecb4204922bbdf116) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwwl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423512.lo", 0x00001, 0x080000, CRC(d65ae210) SHA1(39cb429d530dfad61bb9019a3f5719a7c85ecea8) )
	ROM_LOAD16_BYTE( "95423513.hi", 0x00000, 0x080000, CRC(6c20c600) SHA1(b3fb9d68f1551e59440fa09ff4d9ea23728ad1af) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwcf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423514.lo", 0x00001, 0x080000, CRC(15b0accb) SHA1(4c39f84bdb234216429e8d2b0b0719b8ca0c3c93) )
	ROM_LOAD16_BYTE( "95423515.hi", 0x00000, 0x080000, CRC(8822010e) SHA1(b536e302958aa95ec2d64e0405b5836202dd7b66) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwwm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423552.lo", 0x00001, 0x080000, CRC(867f9c98) SHA1(7974c0915326c88b201e3b8c354906e105d14ac0) )
	ROM_LOAD16_BYTE( "95423553.hi", 0x00000, 0x080000, CRC(a0be983d) SHA1(0f6ed13532465c9ecfddc73351b00425a62a26fa) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwcg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423772.lo", 0x00001, 0x080000, CRC(1a08c512) SHA1(a72a8999c42c1c0a4fed8fe2b59ec52332c8dd35) )
	ROM_LOAD16_BYTE( "95423773.hi", 0x00000, 0x080000, CRC(78311fed) SHA1(c422a46f085504f26e4bb2702816890a721daa06) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwwn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426136.lo", 0x00001, 0x080000, CRC(259a5a75) SHA1(c8ce7566105ef2e4f46c96ce703f90328080932e) )
	ROM_LOAD16_BYTE( "95426137.hi", 0x00000, 0x080000, CRC(265940e0) SHA1(d5bcc9f44e6d288fcdeec4b39a768a76abb25b6f) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwwo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427136.lo", 0x00001, 0x080000, CRC(6da2c608) SHA1(a23bf30b7ade522ff128bdb26a6c544269950991) )
	ROM_LOAD16_BYTE( "95427137.hi", 0x00000, 0x080000, CRC(cb455c65) SHA1(6bbfa5b0119b4c5765f03f5c322df5e1817974d0) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwwp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3006p41.hi", 0x00000, 0x080000, CRC(0fdaa9e0) SHA1(0aa5c92d61fd1b434a094d75a9177425524542f0) )
	ROM_LOAD16_BYTE( "p3006p41.lo", 0x00001, 0x080000, CRC(50a78738) SHA1(4e27e491a1f21800b3e70eecfa6ff61e7e472ffa) )
	sc_dndww_others
ROM_END

ROM_START( sc5dndwwq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3006s41.hi", 0x00000, 0x080000, CRC(a7bbe3ff) SHA1(386cac772b78bb6948f787c6f1f50077d6dd0303) )
	ROM_LOAD16_BYTE( "p3006s41.lo", 0x00001, 0x080000, CRC(a100e18b) SHA1(2dce17ac4f823dda62da7a8589ef488b9e8dee3d) )
	sc_dndww_others
ROM_END


ROM_START( sc5dndwb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418588.lo", 0x00001, 0x080000, CRC(6f9a6192) SHA1(bf283b077387f9cf14e948375ed84736594bf5b9) )
	ROM_LOAD16_BYTE( "95418589.hi", 0x00000, 0x080000, CRC(e3e6c4c8) SHA1(51d755ee8633e406e6cb81993155531b856e51e3) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419588.lo", 0x00001, 0x080000, CRC(87d638b7) SHA1(5d48f65bd2a98452bb5a3a73c49aa6ba8c0c201e) )
	ROM_LOAD16_BYTE( "95419589.hi", 0x00000, 0x080000, CRC(982b1a1b) SHA1(4dabb83cdb2efa80a56375626ff45d5a4133970f) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422012.lo", 0x00001, 0x080000, CRC(ac5e4e54) SHA1(498a97153c1e8a552ace97b8f8e2d15f1ee39752) )
	ROM_LOAD16_BYTE( "95422013.hi", 0x00000, 0x080000, CRC(8a511e54) SHA1(c377ee713618348ba2a9983c7556c9f3adba9e92) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422102.lo", 0x00001, 0x080000, CRC(f87ae97d) SHA1(3971c6fdf8fc15cb9a140827e41a05a11667dd9c) )
	ROM_LOAD16_BYTE( "95422103.hi", 0x00000, 0x080000, CRC(4ad8550b) SHA1(7f56c66f19144073db04a133191d84903f47d681) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422134.lo", 0x00001, 0x080000, CRC(38b550a2) SHA1(93a370c191f85e43e06f2f5b203e5dfdca235651) )
	ROM_LOAD16_BYTE( "95422135.hi", 0x00000, 0x080000, CRC(f260b959) SHA1(74107a5dfcef94aa8ca39f2de6cea26c12d856ad) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422556.lo", 0x00001, 0x080000, CRC(afce35e7) SHA1(518f29c042858608e010caa38dd90287cebbb1ad) )
	ROM_LOAD16_BYTE( "95422557.hi", 0x00000, 0x080000, CRC(6698379b) SHA1(248213bc007c86a656b2ceb32b711ec195ae415d) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422720.lo", 0x00001, 0x080000, CRC(ef9f7e88) SHA1(de887513092db4b7ca5682c7a8e4d0ba607b6bad) )
	ROM_LOAD16_BYTE( "95422721.hi", 0x00000, 0x080000, CRC(1571e4e2) SHA1(ed45392b451d919058ed5de61b05573cbef14fb7) )
	sc_dndwb_others
ROM_END


ROM_START( sc5dndwbg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423012.lo", 0x00001, 0x080000, CRC(5cc9b4fa) SHA1(055ee6e8d72f547fb6ec0b23893a06f3ede70474) )
	ROM_LOAD16_BYTE( "95423013.hi", 0x00000, 0x080000, CRC(6ffa0b3f) SHA1(c66684d0e22be90d4300786a2163b85a7a50ba63) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423102.lo", 0x00001, 0x080000, CRC(c1bb8676) SHA1(a8b2985c6d5d6263824342119ccd33151e132a94) )
	ROM_LOAD16_BYTE( "95423103.hi", 0x00000, 0x080000, CRC(cf20c129) SHA1(5e114a9d6aa77c47d6547e8ed3f5b2c9af8af496) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423134.lo", 0x00001, 0x080000, CRC(0844e446) SHA1(cc0438e07219cbca1d82ece5c26932d21996da74) )
	ROM_LOAD16_BYTE( "95423135.hi", 0x00000, 0x080000, CRC(7bfb1e3e) SHA1(37a5788c901e64c9ca0962fd41aabd27f3b99942) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423556.lo", 0x00001, 0x080000, CRC(4fac2a67) SHA1(8661c3a6d6dba5df0cb6535774dcc8aff822255f) )
	ROM_LOAD16_BYTE( "95423557.hi", 0x00000, 0x080000, CRC(dd0a03bb) SHA1(d84c0123d348df3eb3b7a896de6b48ce86c0ff48) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423720.lo", 0x00001, 0x080000, CRC(e5569acb) SHA1(66cf3ac740df77126c6046e5aebf5472d3945449) )
	ROM_LOAD16_BYTE( "95423721.hi", 0x00000, 0x080000, CRC(51fc5e13) SHA1(6ecd147cd4334171902056b7673c1d876a9db1d3) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426144.lo", 0x00001, 0x080000, CRC(b926b107) SHA1(063cc4439353a8453156831828f19ac7f9f0d641) )
	ROM_LOAD16_BYTE( "95426145.hi", 0x00000, 0x080000, CRC(3e4887ac) SHA1(87b4784a282f7b4290f053ed403034e3956a5f64) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426518.lo", 0x00001, 0x080000, CRC(e8933cf4) SHA1(5ceef82c04a2b3ed7f95cb741b6b41389c7cfee6) )
	ROM_LOAD16_BYTE( "95426519.hi", 0x00000, 0x080000, CRC(0f66c859) SHA1(45737070d10bd4157dd155e5998172ebd9dfed51) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427144.lo", 0x00001, 0x080000, CRC(6096d317) SHA1(b1ca489719930a25392be879880a449c4d6364c0) )
	ROM_LOAD16_BYTE( "95427145.hi", 0x00000, 0x080000, CRC(8792ca0f) SHA1(2b6994c13e0c4ef15134cda8fa33f87c890e5994) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427518.lo", 0x00001, 0x080000, CRC(ce0d637c) SHA1(3cf4862eb6fd02afe9edde7a528a1fb0222d67e4) )
	ROM_LOAD16_BYTE( "95427519.hi", 0x00000, 0x080000, CRC(4d5a88b8) SHA1(d540644356ef9822bb8b620a629c81cc76b9c5e3) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1962p31.hi", 0x00000, 0x080000, CRC(79243d5a) SHA1(8a79bc44c9fddf73dfe17ab37879695cca744a0b) )
	ROM_LOAD16_BYTE( "p1962p31.lo", 0x00001, 0x080000, CRC(7bbf2cd1) SHA1(2144693a40cf6f4b01b73fc87443ce65d5af2599) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1962pa1.hi", 0x00000, 0x080000, CRC(1f9d9036) SHA1(af06ebf8588461c4610120d3017f690fbcf0e3d9) )
	ROM_LOAD16_BYTE( "p1962pa1.lo", 0x00001, 0x080000, CRC(590f9bca) SHA1(fee28ce0bf673089466e95b7b801b06877a2a120) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1962s31.hi", 0x00000, 0x080000, CRC(054c01d4) SHA1(3a23032086099e57c2f49e279f07a79db2327721) )
	ROM_LOAD16_BYTE( "p1962s31.lo", 0x00001, 0x080000, CRC(ef171906) SHA1(d032fad147d99e128e7ffa51f7e1f7411b846b7c) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwbs )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1962sa1.hi", 0x00000, 0x080000, CRC(7e21a4a0) SHA1(beefb35266ea84c01e8c0771a79ea7d8571f79d5) )
	ROM_LOAD16_BYTE( "p1962sa1.lo", 0x00001, 0x080000, CRC(0a4cc805) SHA1(4b7dab1a6d1d4f2a970c185623bfd146e966d14c) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3071p41.hi", 0x00000, 0x080000, CRC(fb849f6e) SHA1(1886dd42d66babf23f476c81c1f2508a52a1c8e4) )
	ROM_LOAD16_BYTE( "p3071p41.lo", 0x00001, 0x080000, CRC(0c52446d) SHA1(e9f18ec19893a733faac70f361c6d91fe314482a) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwia )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3071p71.hi", 0x00000, 0x080000, CRC(7418e4bc) SHA1(606db0530f58399f0760dd5d677b38238d9ddd0c) )
	ROM_LOAD16_BYTE( "p3071p71.lo", 0x00001, 0x080000, CRC(59a8f426) SHA1(96e673663f4085d8c90089da0f386ab553f8cfee) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwib )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3071p72.hi", 0x00000, 0x080000, CRC(a11cfd09) SHA1(313ccca5353a25f6d7f31138ad6e1b62db1fdc48) )
	ROM_LOAD16_BYTE( "p3071p72.lo", 0x00001, 0x080000, CRC(5cdf3447) SHA1(86ec21741eb1f5c54e6307f439fe689aba7e9e4d) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwic )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3071p73.hi", 0x00000, 0x080000, CRC(55bae06a) SHA1(379e588ea8ac7c06edded33d47df211fc1b5bbab) )
	ROM_LOAD16_BYTE( "p3071p73.lo", 0x00001, 0x080000, CRC(b587e08a) SHA1(43ee1d8057f4d200b1fd4e195931b43ec45771d9) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwid )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3071s41.hi", 0x00000, 0x080000, CRC(ff8e8267) SHA1(6a188fd90a94cb071dbfb4a7ab4ff28724149c9d) )
	ROM_LOAD16_BYTE( "p3071s41.lo", 0x00001, 0x080000, CRC(3c9534a7) SHA1(398d6af0f29ed6eff776ee31c56a6899f83a5ce8) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwie )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3071s71.hi", 0x00000, 0x080000, CRC(48c9062c) SHA1(17266340e250dac5b255e936853b4f6c3fd41149) )
	ROM_LOAD16_BYTE( "p3071s71.lo", 0x00001, 0x080000, CRC(52e410a8) SHA1(6fdaadfb9275891e1ef4c157019859b644c5b77d) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwif )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3071s72.hi", 0x00000, 0x080000, CRC(9a93ab2d) SHA1(e8153cfb73b3026f6a16b7d1c9368d4ca0a22003) )
	ROM_LOAD16_BYTE( "p3071s72.lo", 0x00001, 0x080000, CRC(dfc1d11f) SHA1(2cd30fc1d520d7315142bdcf4ef6ca061b037fa8) )
	sc_dndwb_others
ROM_END

ROM_START( sc5dndwig )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3071s73.hi", 0x00000, 0x080000, CRC(35c40c93) SHA1(4b790b4858f5df39c62dbb67907db29b014655da) )
	ROM_LOAD16_BYTE( "p3071s73.lo", 0x00001, 0x080000, CRC(7b44a5b8) SHA1(6cbd0e8668771277bf9187f063e45f8dd30cb780) )
	sc_dndwb_others
ROM_END




ROM_START( sc5dmine )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95406942.lo", 0x00001, 0x080000, CRC(bad861e1) SHA1(9328640b6eebcc9f92f8364454e004a9b6be63cc) )
	ROM_LOAD16_BYTE( "95406943.hi", 0x00000, 0x080000, CRC(d4779226) SHA1(15f4c742bad6992f0ee105f86e06c53286088616) )
	sc_dmine_others
ROM_END

ROM_START( sc5dminea )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95407942.lo", 0x00001, 0x080000, CRC(6250fc4a) SHA1(a133ab1c8d4d35145bf94e73856da4603e8e6579) )
	ROM_LOAD16_BYTE( "95407943.hi", 0x00000, 0x080000, CRC(f5aafcd1) SHA1(afcec150a7229dc28dbdf61addc80efcecc460df) )
	sc_dmine_others
ROM_END

ROM_START( sc5dmineb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408012.lo", 0x00001, 0x080000, CRC(41a21296) SHA1(3351baaadd1b6431e9e2d75586d6912e28e372e5) )
	ROM_LOAD16_BYTE( "95408013.hi", 0x00000, 0x080000, CRC(32399a20) SHA1(516413c5e7420d56f99a1e4353524dce8225c624) )
	sc_dmine_others
ROM_END

ROM_START( sc5dminec )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408098.lo", 0x00001, 0x080000, CRC(1728a865) SHA1(8ba012714248dd704fd9beff5cbd1d44b8efcff1) )
	ROM_LOAD16_BYTE( "95408099.hi", 0x00000, 0x080000, CRC(dba2489b) SHA1(e6cc050c6009e7c36884192fed9e4a032444f007) )
	sc_dmine_others
ROM_END

ROM_START( sc5dmined )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408140.lo", 0x00001, 0x080000, CRC(24ac1211) SHA1(3d08e4bd48772d991f9aad151166ad5c3f5d1880) )
	ROM_LOAD16_BYTE( "95408141.hi", 0x00000, 0x080000, CRC(da5c88f0) SHA1(fadd11a79dbd9c875d77e350699701db13546e50) )
	sc_dmine_others
ROM_END

ROM_START( sc5dminee )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408940.lo", 0x00001, 0x080000, CRC(6f1cf5ca) SHA1(f80dc758b1c001ff6f4cf9638483a5ecd20ad125) )
	ROM_LOAD16_BYTE( "95408941.hi", 0x00000, 0x080000, CRC(fe62569a) SHA1(94ec8b29344407df85dd8e0c83a59e7030ec7f60) )
	sc_dmine_others
ROM_END

ROM_START( sc5dminef )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409012.lo", 0x00001, 0x080000, CRC(69abd3b2) SHA1(b4dd5228b83b165939cb192bfd38b1a84c6191c0) )
	ROM_LOAD16_BYTE( "95409013.hi", 0x00000, 0x080000, CRC(881ec829) SHA1(5762a9049b0361691b199b2c4e7d471a7b4a8811) )
	sc_dmine_others
ROM_END

ROM_START( sc5dmineg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409098.lo", 0x00001, 0x080000, CRC(81d32a7a) SHA1(6dbafd421790d877fc5b5699475e02e75092c441) )
	ROM_LOAD16_BYTE( "95409099.hi", 0x00000, 0x080000, CRC(db912573) SHA1(bc21c43349cafdaebc4de69828fd6e18d1722fb9) )
	sc_dmine_others
ROM_END

ROM_START( sc5dmineh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409140.lo", 0x00001, 0x080000, CRC(f89e4577) SHA1(297b242f24b7c3c8727a122915ab447544700455) )
	ROM_LOAD16_BYTE( "95409141.hi", 0x00000, 0x080000, CRC(30b5f293) SHA1(15649fa022517ec9f129fd59aa720314bb099c1d) )
	sc_dmine_others
ROM_END

ROM_START( sc5dminei )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409940.lo", 0x00001, 0x080000, CRC(83657234) SHA1(14502246599dc4fbe00202e4cad6a191c861fc3b) )
	ROM_LOAD16_BYTE( "95409941.hi", 0x00000, 0x080000, CRC(974f9fb2) SHA1(5b0c48e908041d5d8df71de3a65af5ccb28ab469) )
	sc_dmine_others
ROM_END

ROM_START( sc5dminej )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410944.lo", 0x00001, 0x080000, CRC(1fae3ff3) SHA1(a7676c29002c4be1086510284f8bf495ec6ca86c) )
	ROM_LOAD16_BYTE( "95410945.hi", 0x00000, 0x080000, CRC(a1825e26) SHA1(c3ceca1859f02350f888acc5c03052f3575bc57f) )
	sc_dmine_others
ROM_END

ROM_START( sc5dminek )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411944.lo", 0x00001, 0x080000, CRC(28f9cf69) SHA1(b3f058c6cf54406047ddd302fce0244c82ec6bc3) )
	ROM_LOAD16_BYTE( "95411945.hi", 0x00000, 0x080000, CRC(4688d69f) SHA1(106c5c913797acd4e47c8187bbb5f3ded28b9c27) )
	sc_dmine_others
ROM_END

ROM_START( sc5dminel )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411946.lo", 0x00001, 0x080000, CRC(57ef124d) SHA1(a821ba0d06b958a76314a9fc1b58c6591d81a957) )
	ROM_LOAD16_BYTE( "95411947.hi", 0x00000, 0x080000, CRC(b7460c04) SHA1(a2588fe81e55a886a46f324cb9945272447b4eb1) )
	sc_dmine_others
ROM_END


ROM_START( sc5ddosh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408058.lo", 0x00001, 0x080000, CRC(953fc9c3) SHA1(d2f9a9875126ea0a9807abdad73f48c146617763) )
	ROM_LOAD16_BYTE( "95408059.hi", 0x00000, 0x080000, CRC(4ac58478) SHA1(b452af3db3e91d659eaa641ae589a603c9d3e595) )
	sc_ddosh_others
ROM_END

ROM_START( sc5ddosha )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409058.lo", 0x00001, 0x080000, CRC(44b55b53) SHA1(b60cd2e5b9ca4bb529739f3d66adc32131c7c5a0) )
	ROM_LOAD16_BYTE( "95409059.hi", 0x00000, 0x080000, CRC(53f0bf8a) SHA1(5bedb9d9436dab53560aea6ce940802451debcf6) )
	sc_ddosh_others
ROM_END


ROM_START( sc5dhh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418304.lo", 0x00001, 0x080000, CRC(d3f9fc98) SHA1(979bea6f5b9930f3e9475366143bde53b93374af) )
	ROM_LOAD16_BYTE( "95418305.hi", 0x00000, 0x080000, CRC(8fcad8a5) SHA1(a704dccc5e0283e25c75a99933b2b8c8947c1b84) )
	sc_dhh_others
ROM_END

ROM_START( sc5dhha )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418492.lo", 0x00001, 0x080000, CRC(45d0a32d) SHA1(607648b6333365d21d712b87c857339566fdd99b) )
	ROM_LOAD16_BYTE( "95418493.hi", 0x00000, 0x080000, CRC(6e727d28) SHA1(07cc1f223252fa3dbc122b3bac9b4502f23aaf79) )
	sc_dhh_others
ROM_END

ROM_START( sc5dhhb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419304.lo", 0x00001, 0x080000, CRC(4e774459) SHA1(949aaecc5ea01b1761e029da4f42dbc915903259) )
	ROM_LOAD16_BYTE( "95419305.hi", 0x00000, 0x080000, CRC(1b28a792) SHA1(2f0f7cb6404d35d07fbc9c35036301d92644ca37) )
	sc_dhh_others
ROM_END

ROM_START( sc5dhhc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419492.lo", 0x00001, 0x080000, CRC(05f2625e) SHA1(d77517420fbbe198213ee4f0634252c259f8b8c8) )
	ROM_LOAD16_BYTE( "95419493.hi", 0x00000, 0x080000, CRC(59dc177c) SHA1(cb1eb80a71bf2745881e6b073ba6aeb009b6a850) )
	sc_dhh_others
ROM_END

ROM_START( sc5dhhd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422966.lo", 0x00001, 0x080000, CRC(a0a41d59) SHA1(995b501fa6516b7b7b48cf87c437a9873552b504) )
	ROM_LOAD16_BYTE( "95422967.hi", 0x00000, 0x080000, CRC(81c24fe4) SHA1(6694b5f9a32d45db5d110083b3e9808ab4554506) )
	sc_dhh_others
ROM_END

ROM_START( sc5dhhe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423966.lo", 0x00001, 0x080000, CRC(28ebaa72) SHA1(0e0ec5ebff3f2860d7aadb6200fce07aad2361c2) )
	ROM_LOAD16_BYTE( "95423967.hi", 0x00000, 0x080000, CRC(ecd590c4) SHA1(c406792454714f564e1460efe396ea37d30ac01d) )
	sc_dhh_others
ROM_END

ROM_START( sc5dhhf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426236.lo", 0x00001, 0x080000, CRC(7d73f0ae) SHA1(446f2cdb76fa353ede0e53fa9873237e9def78e1) )
	ROM_LOAD16_BYTE( "95426237.hi", 0x00000, 0x080000, CRC(b215f36d) SHA1(669829c2f86a8262ee4b0c8a76d52241deeff2d6) )
	sc_dhh_others
ROM_END

ROM_START( sc5dhhg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427236.lo", 0x00001, 0x080000, CRC(3fa0f89d) SHA1(ac14fd39924f959cc9d89a214c47c3ee85f43eea) )
	ROM_LOAD16_BYTE( "95427237.hi", 0x00000, 0x080000, NO_DUMP)
	sc_dhh_others
ROM_END




ROM_START( sc5dough )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418046.lo", 0x00001, 0x080000, CRC(1358dc76) SHA1(d09cf2473cf5c786f6a9c61c44d792227b444536) )
	ROM_LOAD16_BYTE( "95418047.hi", 0x00000, 0x080000, CRC(163416eb) SHA1(837bd735d54228e471e34d65ba05508d7d2e85da) )
	sc_dough_others
ROM_END


ROM_START( sc5dougha )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419046.lo", 0x00001, 0x080000, CRC(857e5267) SHA1(218770e60423af3dc6b20f0bf1f87173213f95ca) )
	ROM_LOAD16_BYTE( "95419047.hi", 0x00000, 0x080000, CRC(acb97317) SHA1(1da2955b336140121c48d30958761dd3e3cccd43) )
	sc_dough_others
ROM_END


ROM_START( sc5ducks )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417440.lo", 0x00001, 0x080000, CRC(c28ddc31) SHA1(e32e2cdf19a4ae432bc570765580c4cceb888ba8) )
	ROM_LOAD16_BYTE( "95417441.hi", 0x00000, 0x080000, CRC(00921b61) SHA1(88b9a9d1820ccfe73707b12dc3aef9c044e9c41b) )
	sc_ducks_others
ROM_END


ROM_START( sc5emmer )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420128.lo", 0x00001, 0x080000, CRC(73505beb) SHA1(f59b0369688867a68983ee2437ca98bc6ecab6a7) )
	ROM_LOAD16_BYTE( "95420129.hi", 0x00000, 0x080000, CRC(a13583a1) SHA1(f546a457e7103314c9b78ec471297b1744d0f108) )
	sc_emmer_others
ROM_END

ROM_START( sc5emmera )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421128.lo", 0x00001, 0x080000, CRC(c7431807) SHA1(78bf3727f99f70c660d39fdb8b7dd91902c510db) )
	ROM_LOAD16_BYTE( "95421129.hi", 0x00000, 0x080000, CRC(cd008039) SHA1(7233658bddc7dfd4de2ba4fdc5da946dcfb116c6) )
	sc_emmer_others
ROM_END



ROM_START( ad5evol )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASE00 )
	ROM_LOAD( "39211246.bin", 0x0000, 0x4d858a, CRC(edabdb3d) SHA1(cdda311e94cdb22432a4b37edb411717a391720e) )
ROM_END

ROM_START( sc5fguy )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426014.lo", 0x00001, 0x080000, CRC(409ed279) SHA1(173e285a8515e06239bb4755b007ab81878212f3) )
	ROM_LOAD16_BYTE( "95426015.hi", 0x00000, 0x080000, CRC(37ce818c) SHA1(91457fd347d76ce380dfd73c3ca5cc0dcba65907) )
	sc_fguy_others
ROM_END

ROM_START( sc5fguya )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426388.lo", 0x00001, 0x080000, CRC(6a769ec1) SHA1(42d8b4d31feae3070eaabc74d84ee731c8075a97) )
	ROM_LOAD16_BYTE( "95426389.hi", 0x00000, 0x080000, CRC(19b625c4) SHA1(609b6f63db423ac46f953bf8934137ea176a9147) )
	sc_fguy_others
ROM_END

ROM_START( sc5fguyb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427014.lo", 0x00001, 0x080000, CRC(6890caf2) SHA1(87998eb35701f9e9f4737db611a807a87ef3be2a) )
	ROM_LOAD16_BYTE( "95427015.hi", 0x00000, 0x080000, CRC(4b02d014) SHA1(e94ce848c979e60ab7718439bcf60a59103cc01a) )
	sc_fguy_others
ROM_END

ROM_START( sc5fguyc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427388.lo", 0x00001, 0x080000, CRC(e1776d0a) SHA1(efb4af41c8c795d6e14cf7b0a6cac51021dd9dfd) )
	ROM_LOAD16_BYTE( "95427389.hi", 0x00000, 0x080000, CRC(c838eeee) SHA1(718776e5086b00278f70452a0141e07cbbdae3d4) )
	sc_fguy_others
ROM_END

ROM_START( sc5fguyd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3213p11.hi", 0x00000, 0x080000, CRC(d7776670) SHA1(13002e513bd6c17a5755ac30b2b6a5a462ace5d9) )
	ROM_LOAD16_BYTE( "p3213p11.lo", 0x00001, 0x080000, CRC(c65fff31) SHA1(b2200b68673d6ef2427965484c23ac5cf2343986) )
	sc_fguy_others
ROM_END

ROM_START( sc5fguye )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3213s11.hi", 0x00000, 0x080000, CRC(1ab8b3c5) SHA1(c0d901ae3b3ea00073d731e3a10efba60ebbf020) )
	ROM_LOAD16_BYTE( "p3213s11.lo", 0x00001, 0x080000, CRC(314b0288) SHA1(6a24fce8aa9bcf67014ceae4b7a11be0de4ed7c4) )
	sc_fguy_others
ROM_END


ROM_START( sc5fbspn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418100.lo", 0x00001, 0x080000, CRC(dd69a98d) SHA1(399a8fa0ff3b533bbd03e3e5cfd0779dcd476c94) )
	ROM_LOAD16_BYTE( "95418101.hi", 0x00000, 0x080000, CRC(98f20476) SHA1(8267752f6d5bae080c20ab61a326f16eba8a1084) )
	sc_fbspn_others
ROM_END

ROM_START( sc5fbspna )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419100.lo", 0x00001, 0x080000, CRC(6b0ff803) SHA1(a90aadf711dcdd16d3550039a447f0d2b5f3a8c3) )
	ROM_LOAD16_BYTE( "95419101.hi", 0x00000, 0x080000, CRC(114938bd) SHA1(e4d7ac26d3dcec7fa28e6e7d8934c9a7e0f2ee0a) )
	sc_fbspn_others
ROM_END





ROM_START( sc5fmj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420152.lo", 0x00001, 0x080000, CRC(9de7051b) SHA1(9969cd08aa9afeffd670910f3dbbf0f83e919db3) )
	ROM_LOAD16_BYTE( "95420153.hi", 0x00000, 0x080000, CRC(b26f0d81) SHA1(65e6e8a680374f263a07d886e695bcb5a413189e) )
	sc_fmj_others
ROM_END


ROM_START( sc5fmja )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421152.lo", 0x00001, 0x080000, CRC(ddd9560c) SHA1(ba3dcd145aa94764c0e476c1eddc7f3d7ab2b119) )
	ROM_LOAD16_BYTE( "95421153.hi", 0x00000, 0x080000, CRC(4a21afe7) SHA1(2b50914dc66e04c4fedeefd2795c3668529ce2eb) )
	sc_fmj_others
ROM_END



ROM_START( sc5glad )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416666.lo", 0x00001, 0x080000, CRC(f7cc7b09) SHA1(1901d800342420dafbe4a17563dbf891fa3bc77b) )
	ROM_LOAD16_BYTE( "95416667.hi", 0x00000, 0x080000, CRC(832e48d0) SHA1(78efa50cec3b64346a67b03e60e2fb2f2879059d) )
	sc_glad_others
ROM_END

ROM_START( sc5glada )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417666.lo", 0x00001, 0x080000, CRC(eab5fb98) SHA1(a64a9d3ed989d15508c3b9bb6d07f4f821297ad3) )
	ROM_LOAD16_BYTE( "95417667.hi", 0x00000, 0x080000, CRC(fed19dd2) SHA1(24c0f6a411fd44a42ebbcc861a27edc8c2897768) )
	sc_glad_others
ROM_END

ROM_START( sc5gladb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420106.lo", 0x00001, 0x080000, CRC(4f9aa405) SHA1(9433f5c668cd5178bde8fb0d47aa662d20f257d5) )
	ROM_LOAD16_BYTE( "95420107.hi", 0x00000, 0x080000, CRC(22a53136) SHA1(fc89ea546420328cd13bc0cce2b242c824488395) )
	sc_glad_others
ROM_END

ROM_START( sc5gladc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421106.lo", 0x00001, 0x080000, CRC(92160b66) SHA1(828f85794e6b658fba0efe9bcb77dcf01a0cd91e) )
	ROM_LOAD16_BYTE( "95421107.hi", 0x00000, 0x080000, CRC(8407f80a) SHA1(c5e6ad8bfb2a1fa02f85e92ac62c7799c8904931) )
	sc_glad_others
ROM_END

ROM_START( sc5gd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3509p71.hi", 0x00000, 0x080000, CRC(01fa71eb) SHA1(0ccf5f994e995d1ba772561fa168714ed89543df) )
	ROM_LOAD16_BYTE( "p3509p71.lo", 0x00001, 0x080000, CRC(9f2ab639) SHA1(02c940c783820c08ac533543809a2fb87e7f563d) )
	sc_gd_others
ROM_END

ROM_START( sc5gda )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3509s71.hi", 0x00000, 0x080000, CRC(b7743603) SHA1(d87301810af34e0946d2713e26f9a4d0e17d6d29) )
	ROM_LOAD16_BYTE( "p3509s71.lo", 0x00001, 0x080000, CRC(4374588e) SHA1(59814e287386414e446fbbc1414499b5a17723cb) )
	sc_gd_others
ROM_END


ROM_START( sc5gdmz )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420134.lo", 0x00001, 0x080000, CRC(86537cdd) SHA1(e026961508de73921368986a5fdc19e586ea9909) )
	ROM_LOAD16_BYTE( "95420135.hi", 0x00000, 0x080000, CRC(5f4fc0ca) SHA1(ce425ee451a83157e5da0d7a2747c7d5b653b67c) )
	sc_gdmz_others
ROM_END

ROM_START( sc5gdmza )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421134.lo", 0x00001, 0x080000, CRC(603a0237) SHA1(94b5ab8e850634e800072680ceab3c12c3d2be26) )
	ROM_LOAD16_BYTE( "95421135.hi", 0x00000, 0x080000, CRC(cfa548a4) SHA1(032fe4d1da5d49c1226ae198621676093678d5db) )
	sc_gdmz_others
ROM_END

ROM_START( sc5gdclb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426422.lo", 0x00001, 0x080000, CRC(2f0675eb) SHA1(287bb87e372bc0fca568cb63c62bcc81e448935a) )
	ROM_LOAD16_BYTE( "95426423.hi", 0x00000, 0x080000, CRC(69ca79cd) SHA1(15c59d0ec009cbc73b40767b9194b9cd8220d336) )
	sc_gdclb_others
ROM_END

ROM_START( sc5gdclba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426450.lo", 0x00001, 0x080000, CRC(5229a543) SHA1(0d523a0bedfc19fa62702f6472f1112d26e2356a) )
	ROM_LOAD16_BYTE( "95426451.hi", 0x00000, 0x080000, CRC(cd6288f8) SHA1(530e53e3e66965872217224947423a097cf960ca) )
	sc_gdclb_others
ROM_END

ROM_START( sc5gdclbb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426498.lo", 0x00001, 0x080000, CRC(1239da8f) SHA1(436763e75c1729aa37bee74981c53ebec139fe41) )
	ROM_LOAD16_BYTE( "95426499.hi", 0x00000, 0x080000, CRC(ace06244) SHA1(94b6be0b30976525743ff97f62c465c52bdc3aab) )
	sc_gdclb_others
ROM_END

ROM_START( sc5gdclbc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427422.lo", 0x00001, 0x080000, CRC(a940f61f) SHA1(b66099d74a5a2bc3d639ff7dee1e6871e5464c66) )
	ROM_LOAD16_BYTE( "95427423.hi", 0x00000, 0x080000, CRC(fc57ca0f) SHA1(9b2de50e5ef010edae5f112a13416074e685f2a5) )
	sc_gdclb_others
ROM_END

ROM_START( sc5gdclbd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427450.lo", 0x00001, 0x080000, CRC(229112f2) SHA1(93567719f3facd9da6cf076a5e95c6c6482c8e31) )
	ROM_LOAD16_BYTE( "95427451.hi", 0x00000, 0x080000, CRC(bca120fa) SHA1(8abb14bbb1d29872457fc24bc2311309e17c79eb) )
	sc_gdclb_others
ROM_END

ROM_START( sc5gdclbe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427498.lo", 0x00001, 0x080000, CRC(8c1c667c) SHA1(d3f5e92fa347e2c207a9c7e4d1d5a6fac20a8937) )
	ROM_LOAD16_BYTE( "95427499.hi", 0x00000, 0x080000, CRC(00744041) SHA1(6fb9db03bfcac3ca2687117c056970a62b3ea034) )
	sc_gdclb_others
ROM_END



ROM_START( sc5gball )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412498.lo", 0x00001, 0x080000, CRC(68f12b56) SHA1(13a0520ce2a6e4df14e88e5564d3691e58e4cef1) )
	ROM_LOAD16_BYTE( "95412499.hi", 0x00000, 0x080000, CRC(2359aa3d) SHA1(d054e96d3f969c54b77a634d3ab6f4b3458855cf) )
	sc_gball_pthers
ROM_END

ROM_START( sc5gballa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412614.lo", 0x00001, 0x080000, CRC(3a9207e8) SHA1(87dc40b8c6ea8d40fb899fd1bb7550fc5d65ece0) )
	ROM_LOAD16_BYTE( "95412615.hi", 0x00000, 0x080000, CRC(1ef5def8) SHA1(97614ccc4cd62b49492dd065d0a9b7920846e71e) )
	sc_gball_pthers
ROM_END

ROM_START( sc5gballb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413498.lo", 0x00001, 0x080000, CRC(8db258f8) SHA1(a9bcc6fa2537c05fbe9292188935086f3e89b0f3) )
	ROM_LOAD16_BYTE( "95413499.hi", 0x00000, 0x080000, CRC(6ff98900) SHA1(ea30390fa74f852d9dfcd5e933149a37089b9005) )
	sc_gball_pthers
ROM_END

ROM_START( sc5gballc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413614.lo", 0x00001, 0x080000, CRC(235a0b49) SHA1(2f9dd0b8daf069f9e3b00dca8e54f505748dae09) )
	ROM_LOAD16_BYTE( "95413615.hi", 0x00000, 0x080000, CRC(c1a82ebd) SHA1(f50e649f5544a5f5c2facb13dc2bfbc7cf12212d) )
	sc_gball_pthers
ROM_END


ROM_START( sc5ggame )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416124.lo", 0x00001, 0x080000, CRC(537e86dc) SHA1(592661deadf3cdbbbe7506fc3e362b5de72d9282) )
	ROM_LOAD16_BYTE( "95416125.hi", 0x00000, 0x080000, CRC(15c575ac) SHA1(6fec7d27b19f2c1b84c4ce83613d5d6af3df0053) )
	sc_ggame_others
ROM_END

ROM_START( sc5ggamea )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416132.lo", 0x00001, 0x080000, CRC(7e24c13f) SHA1(7d23880df34163322935f0e8cf4dd5cd37b3fcb5) )
	ROM_LOAD16_BYTE( "95416133.hi", 0x00000, 0x080000, CRC(8014fa57) SHA1(e356ff476da0cfd4cc6c7194bf83c21067c66870) )
	sc_ggame_others
ROM_END

ROM_START( sc5ggameb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417124.lo", 0x00001, 0x080000, CRC(a7bcf290) SHA1(56669bfd91f42863526987fc2e1b98dc8cc12d6d) )
	ROM_LOAD16_BYTE( "95417125.hi", 0x00000, 0x080000, CRC(f7373810) SHA1(56b3b6a2d9fb8a291f9edb023c47c24fd5c05d23) )
	sc_ggame_others
ROM_END

ROM_START( sc5ggamec )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417126.lo", 0x00001, 0x080000, CRC(b8184d23) SHA1(d6bfa2fe512f5a26e1beaa728837a06ae110f560) )
	ROM_LOAD16_BYTE( "95417127.hi", 0x00000, 0x080000, CRC(ec1f3c3a) SHA1(214b91ffc2743c04d3030ed1bf005f1ebc124e1a) )
	sc_ggame_others
ROM_END

ROM_START( sc5ggamed )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417132.lo", 0x00001, 0x080000, CRC(5e6d4f71) SHA1(7aa3bae2651d51a5f46606a43d708484b05ee887) )
	ROM_LOAD16_BYTE( "95417133.hi", 0x00000, 0x080000, CRC(87c015a5) SHA1(5e031909b746e0051da218fc396a8b1b71a45674) )
	sc_ggame_others
ROM_END


ROM_START( sc5ggg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420722.lo", 0x00001, 0x080000, CRC(7f7dbf95) SHA1(b02ababb851518e2f9d79f8c5b7bab828d5cd8ba) )
	ROM_LOAD16_BYTE( "95420723.hi", 0x00000, 0x080000, CRC(997a3b21) SHA1(5b4524848e8c4ad47f2b72d29791e32d67c88d0e) )
	sc_ggg_others
ROM_END

ROM_START( sc5ggga )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421722.lo", 0x00001, 0x080000, CRC(2c7ad6b5) SHA1(6b922ab897da233074813cf5e32960974a46f27c) )
	ROM_LOAD16_BYTE( "95421723.hi", 0x00000, 0x080000, CRC(bda8844f) SHA1(ed7c5575cb23dc359b868b65744e1bf6bfd92c85) )
	sc_ggg_others
ROM_END

ROM_START( sc5gggb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420782.lo", 0x00001, 0x080000, CRC(13b65d83) SHA1(c2065db6d4b978148a49750af368b51d9438ddbc) )
	ROM_LOAD16_BYTE( "95420783.hi", 0x00000, 0x080000, CRC(e6bd569b) SHA1(b668b661e7afd1c951fa50bfce564e24b712a723) )
	sc_ggg_others
ROM_END

ROM_START( sc5gggc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421782.lo", 0x00001, 0x080000, CRC(623c7d94) SHA1(eb757679cdbf9a8657a8c4012ba39d7256e7af16) )
	ROM_LOAD16_BYTE( "95421783.hi", 0x00000, 0x080000, CRC(dc5cf5b8) SHA1(abf35663582034ad4d62624b4814006de2d194bf) )
	sc_ggg_others
ROM_END


ROM_START( sc5gunp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422360.lo", 0x00001, 0x080000, CRC(ff22816b) SHA1(29cdd9fe245f62e9455ec3bf2ebff069b2ac182d) )
	ROM_LOAD16_BYTE( "95422361.hi", 0x00000, 0x080000, CRC(80a12c2e) SHA1(c92a69e4b849e73d42c045ce10a7f9f2d2ea3a9c) )
	sc_gunp_others
ROM_END

ROM_START( sc5gunpa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422592.lo", 0x00001, 0x080000, CRC(b546b3bf) SHA1(ce84f806b2648ebb3582a6a68797f347b41d5e17) )
	ROM_LOAD16_BYTE( "95422593.hi", 0x00000, 0x080000, CRC(74c6b5d2) SHA1(a46a8ee5a77b8310492fd272320db481c30c79f8) )
	sc_gunp_others
ROM_END

ROM_START( sc5gunpb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422752.lo", 0x00001, 0x080000, CRC(82368f14) SHA1(d5d2fe0b9c31bd9dede3953ceeebc533c5102cac) )
	ROM_LOAD16_BYTE( "95422753.hi", 0x00000, 0x080000, CRC(4ba46041) SHA1(ce076fc1027f09f0ab201abf2ec26116df077f93) )
	sc_gunp_others
ROM_END

ROM_START( sc5gunpc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423360.lo", 0x00001, 0x080000, CRC(66be2471) SHA1(98932c263ed59dc76a8879e5f95ea37a573b0006) )
	ROM_LOAD16_BYTE( "95423361.hi", 0x00000, 0x080000, CRC(15227d9d) SHA1(206e95c4c4158ed3421a0eb287a8d777cf0578bc) )
	sc_gunp_others
ROM_END

ROM_START( sc5gunpd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423592.lo", 0x00001, 0x080000, CRC(5860325d) SHA1(69cab9605953ca7e93fe2dd58c1bbdf74eb79ff6) )
	ROM_LOAD16_BYTE( "95423593.hi", 0x00000, 0x080000, CRC(eb8aa03a) SHA1(574683035f635cd2edcadab6b40a9b8f34850fe8) )
	sc_gunp_others
ROM_END

ROM_START( sc5gunpe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426118.lo", 0x00001, 0x080000, CRC(697b7c27) SHA1(257b4cd5132a336217bf3ff1eabba8ff460ccbae) )
	ROM_LOAD16_BYTE( "95426119.hi", 0x00000, 0x080000, CRC(fcee9f17) SHA1(87934f4d8c0cc55cea87dc6027f656ab4587914e) )
	sc_gunp_others
ROM_END

ROM_START( sc5gunpf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426276.lo", 0x00001, 0x080000, CRC(1437f193) SHA1(516e745335ebb27c91e033292b946605a0ea3898) )
	ROM_LOAD16_BYTE( "95426277.hi", 0x00000, 0x080000, CRC(88bc027d) SHA1(d4cdb691131889071e583c91eeb594fa22dc489e) )
	sc_gunp_others
ROM_END

ROM_START( sc5gunpg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426398.lo", 0x00001, 0x080000, CRC(abc5b4e3) SHA1(bd2996273328b04e22d65e7737901479b3f2dc59) )
	ROM_LOAD16_BYTE( "95426399.hi", 0x00000, 0x080000, CRC(d9f8d9ca) SHA1(c634146ade7fdca71c6b2fbc6f7149639a4d4677) )
	sc_gunp_others
ROM_END

ROM_START( sc5gunph )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427118.lo", 0x00001, 0x080000, CRC(f453ade4) SHA1(49274318d5d31c2fd63b912994870024400405f1) )
	ROM_LOAD16_BYTE( "95427119.hi", 0x00000, 0x080000, CRC(ccf9ede7) SHA1(32fe6022b2da290a41521f47ce91b5048c7b91cc) )
	sc_gunp_others
ROM_END

ROM_START( sc5gunpi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427276.lo", 0x00001, 0x080000, CRC(bce351c9) SHA1(58b93bedcccb79cef1b23f61cf0308331299c034) )
	ROM_LOAD16_BYTE( "95427277.hi", 0x00000, 0x080000, CRC(39db7e38) SHA1(27dc16145711576962dbe943eac5c9f2ef9c0c70) )
	sc_gunp_others
ROM_END

ROM_START( sc5gunpj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427398.lo", 0x00001, 0x080000, CRC(94520a24) SHA1(692fbd63481fec92391dda6dfcb99308eb9d4658) )
	ROM_LOAD16_BYTE( "95427399.hi", 0x00000, 0x080000, CRC(b2d2f327) SHA1(bbaac6bce520ee957b30a3fe42fa9686ffe135e5) )
	sc_gunp_others
ROM_END

ROM_START( sc5gunpk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3016p71.hi", 0x00000, 0x080000, CRC(1dc4ab56) SHA1(1f47429af60d55547f5f14235c29cb1a343778cd) )
	ROM_LOAD16_BYTE( "p3016p71.lo", 0x00001, 0x080000, CRC(23a21435) SHA1(935875e89860017d4672397f32aff605af37db4c) )
	sc_gunp_others
ROM_END

ROM_START( sc5gunpl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3016s71.hi", 0x00000, 0x080000, CRC(a8c8fb0b) SHA1(d79717de7a2577fa0a67271b68671c7ae752bcfc) )
	ROM_LOAD16_BYTE( "p3016s71.lo", 0x00001, 0x080000, CRC(63dde41b) SHA1(b858eda07805c7149e296657bbf98c9e343209e8) )
	sc_gunp_others
ROM_END



ROM_START( sc5hapnt )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408046.lo", 0x00001, 0x080000, CRC(85555e8d) SHA1(3ab297896829794b3aa48924431fc1a9239946f4) )
	ROM_LOAD16_BYTE( "95408047.hi", 0x00000, 0x080000, CRC(d1003e56) SHA1(e51c8871d8bc93c16507a7cd06f8499fdc93d6af) )
	sc_hapnt_others
ROM_END

ROM_START( sc5hapnta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408100.lo", 0x00001, 0x080000, CRC(4aef5042) SHA1(a8e1e83bd1baf3432f775ff6b1acc5b03ccda697) )
	ROM_LOAD16_BYTE( "95408101.hi", 0x00000, 0x080000, CRC(aa3b70e2) SHA1(86f38715d820717f69c08d8ca52828305f071461) )
	sc_hapnt_others
ROM_END

ROM_START( sc5hapntb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408230.lo", 0x00001, 0x080000, CRC(238710bf) SHA1(827593474d179524b7c2a25c264a5b9e99e6e153) )
	ROM_LOAD16_BYTE( "95408231.hi", 0x00000, 0x080000, CRC(35081642) SHA1(61dbcf6ff57fe0ec3742831e8a13a03450f3cd63) )
	sc_hapnt_others
ROM_END

ROM_START( sc5hapntc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408502.lo", 0x00001, 0x080000, CRC(591041d3) SHA1(d9522f4131727b2a9ae5884039bc1c265817fa46) )
	ROM_LOAD16_BYTE( "95408503.hi", 0x00000, 0x080000, CRC(c35d692f) SHA1(bfec485ba52c7a5a6c2565b02e1e9477d7fef55d) )
	sc_hapnt_others
ROM_END

ROM_START( sc5hapntd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409046.lo", 0x00001, 0x080000, CRC(a099171c) SHA1(5487abb941d53c96fb5139438ba5258dc168dc40) )
	ROM_LOAD16_BYTE( "95409047.hi", 0x00000, 0x080000, CRC(9f1ed231) SHA1(a95440f3225f3428309816e08852bf07f313395e) )
	sc_hapnt_others
ROM_END

ROM_START( sc5hapnte )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409100.lo", 0x00001, 0x080000, CRC(12f704dc) SHA1(fd1add5cfef1c24fc15cb7d623b1e4903d092f82) )
	ROM_LOAD16_BYTE( "95409101.hi", 0x00000, 0x080000, CRC(2a9b4c44) SHA1(7be9b24007935ece47d73d2cfb2ba5693e50bc58) )
	sc_hapnt_others
ROM_END

ROM_START( sc5hapntf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409230.lo", 0x00001, 0x080000, CRC(b16303a5) SHA1(549b64d3ec0460fa45ff0b98b4271eb2ae272e17) )
	ROM_LOAD16_BYTE( "95409231.hi", 0x00000, 0x080000, CRC(5149f6c5) SHA1(4a31d7fa699f0deb04fb50d0fe0347b6a4d01c57) )
	sc_hapnt_others
ROM_END

ROM_START( sc5hapntg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409502.lo", 0x00001, 0x080000, CRC(26d6f19c) SHA1(1d88a105db4c2cec181a143bded5c1aaf5a32731) )
	ROM_LOAD16_BYTE( "95409503.hi", 0x00000, 0x080000, CRC(2fbf988f) SHA1(04a3bda0266e2d1430ae5223499f326972ee951c) )
	sc_hapnt_others
ROM_END



ROM_START( sc5hellb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1402p12.hi", 0x00000, 0x080000, CRC(42548acf) SHA1(cc36dbe058a8296f65b123d5e1d21a58ac53252a) )
	ROM_LOAD16_BYTE( "p1402p12.lo", 0x00001, 0x080000, CRC(d34211b0) SHA1(ae316d09872dab241222269231ffc9a7a5f50b83) )
	sc_hellb_others
ROM_END

ROM_START( sc5hellba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1402s12.hi", 0x00000, 0x080000, CRC(3ecd9836) SHA1(c4a367d7efcde4b71e65b551aa830f881beb9cd7) )
	ROM_LOAD16_BYTE( "p1402s12.lo", 0x00001, 0x080000, CRC(49778505) SHA1(4cf60e9844e30216a64a1a45fadeba780614a180) )
	sc_hellb_others
ROM_END





ROM_START( sc5hill )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412954.lo", 0x00001, 0x080000, CRC(0349a398) SHA1(209c6f8282a3ef95a20ce92db85b9b7e8e179bfd) )
	ROM_LOAD16_BYTE( "95412955.hi", 0x00000, 0x080000, CRC(336302b6) SHA1(560a71c9de9e11d0a82e048f49ab4bfe4e112ea8) )
	sc_hill_others
ROM_END

ROM_START( sc5hilla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413954.lo", 0x00001, 0x080000, CRC(f71a75d2) SHA1(1f1c88513e4aeae694bab21d0b566a5c566771b1) )
	ROM_LOAD16_BYTE( "95413955.hi", 0x00000, 0x080000, CRC(490e56e2) SHA1(c27b01c773e00aa18084b25df2d145f4948a696f) )
	sc_hill_others
ROM_END

ROM_START( sc5hillb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "hillbill.p1", 0x00001, 0x080000, CRC(997165fa) SHA1(12ffd1b841fcf9b2cd88abb35f540ef2731cbc5e) )
	ROM_LOAD16_BYTE( "hillbill.p2", 0x00000, 0x080000, CRC(2572af4d) SHA1(9ad6e90a751b483d04189a3f03d76439bc04856b) )
	sc_hill_others
ROM_END


ROM_START( sc5hiss )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416268.odd", 0x00001, 0x080000, CRC(193027b5) SHA1(95a6a11dea8609048e4f00b6c2bc2e48a8174263) )
	ROM_LOAD16_BYTE( "95416269.evn", 0x00000, 0x080000, CRC(f4782903) SHA1(870340d75d19a876aeb71449424dc41b03a0a6ce) )
	sc_hiss_others
ROM_END

ROM_START( sc5hissa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417268.odd", 0x00001, 0x080000, CRC(f6424b2d) SHA1(2ad4e9ed0f5f89e4fa0e758cb74c17ae0a956b15) )
	ROM_LOAD16_BYTE( "95417269.evn", 0x00000, 0x080000, CRC(709c9253) SHA1(a1075c726ba0d4ad1a4288ce7da9e890773d0393) )
	sc_hiss_others
ROM_END

ROM_START( sc5hissb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420752.lo", 0x00001, 0x080000, CRC(06e74bfb) SHA1(240a62a3855925345296ce0fc4e8f47b97a33d3d) )
	ROM_LOAD16_BYTE( "95420753.hi", 0x00000, 0x080000, CRC(931c2306) SHA1(ba182abda4e4a91d4132223c16686e3d54206f7f) )
	sc_hiss_others
ROM_END

ROM_START( sc5hissc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421752.lo", 0x00001, 0x080000, CRC(5addeeae) SHA1(49e13faf64b8e8f895af32b1cbbef083a72ad185) )
	ROM_LOAD16_BYTE( "95421753.hi", 0x00000, 0x080000, CRC(7c733653) SHA1(f47d960bd2fad92486d80182be68d0187a3c0ce2) )
	sc_hiss_others
ROM_END


ROM_START( sc5hotdg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1916p12.hi", 0x00000, 0x080000, CRC(0cae3d8f) SHA1(a8599ba8bb48934f4717695e9f54d5f086a30f54) )
	ROM_LOAD16_BYTE( "p1916p12.lo", 0x00001, 0x080000, CRC(aad6a266) SHA1(98d42dcdd93c800a9b4a93636f3b7dc85137248e) )
	sc_hotdg_others
ROM_END

ROM_START( sc5hotdga )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1916p42.hi", 0x00000, 0x080000, CRC(24002fad) SHA1(a7d240726de1a78ccd032019cdd2c1a528f68ee4) )
	ROM_LOAD16_BYTE( "p1916p42.lo", 0x00001, 0x080000, CRC(2e33fc1a) SHA1(a0d9d0935e2c2bb3eb4b5a6c2d34e21d124b8376) )
	sc_hotdg_others
ROM_END

ROM_START( sc5hotdgb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1916p43.hi", 0x00000, 0x080000, CRC(7ddda754) SHA1(347d0586b054f463a3572b78c38237da4e9f46b9) )
	ROM_LOAD16_BYTE( "p1916p43.lo", 0x00001, 0x080000, CRC(63edfe15) SHA1(986bf6845a084d2a06ffc94765b1e56d3dd0a5a4) )
	sc_hotdg_others
ROM_END

ROM_START( sc5hotdgc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1916s12.hi", 0x00000, 0x080000, CRC(53ead733) SHA1(2f7ddca4662078fd1f221274cf420f0bc2fce714) )
	ROM_LOAD16_BYTE( "p1916s12.lo", 0x00001, 0x080000, CRC(2e6a0755) SHA1(62db870df95deb645e22925f6ce234598bbbefeb) )
	sc_hotdg_others
ROM_END

ROM_START( sc5hotdgd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1916s42.hi", 0x00000, 0x080000, CRC(0f72d194) SHA1(52dd33c58d720dfb97d008715dda2965786db129) )
	ROM_LOAD16_BYTE( "p1916s42.lo", 0x00001, 0x080000, CRC(266d2ce7) SHA1(dbd4d5892e6efdcbf72928be7595336d5c04f035) )
	sc_hotdg_others
ROM_END

ROM_START( sc5hotdge )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1916s43.hi", 0x00000, 0x080000, CRC(5cdb8043) SHA1(4ccce12a13ca65a25aa5936cc81445a93734c2d7) )
	ROM_LOAD16_BYTE( "p1916s43.lo", 0x00001, 0x080000, CRC(09cf7a39) SHA1(099441349ec9b9cc1fb0c43172623cc2c1ca90af) )
	sc_hotdg_others
ROM_END


ROM_START( sc5hotrd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418236.lo", 0x00001, 0x080000, CRC(5d269eef) SHA1(cb5771b2e7d59b94140db9fc534b9ea468e32297) )
	ROM_LOAD16_BYTE( "95418237.hi", 0x00000, 0x080000, CRC(d47fe059) SHA1(8eb3a2cde00c8db17daaad945705e718a7f47930) )
	sc_hotrd_others
ROM_END

ROM_START( sc5hotrda )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419236.lo", 0x00001, 0x080000, CRC(3497d99f) SHA1(7d97d826e48714ace13cfe683f40338004744bf1) )
	ROM_LOAD16_BYTE( "95419237.hi", 0x00000, 0x080000, CRC(a982f4ad) SHA1(7e37822ebd9e1373c9aa259a3c30dc29b1077bb8) )
	sc_hotrd_others
ROM_END

ROM_START( sc5hotsh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426378.lo", 0x00001, 0x080000, CRC(b2becc3e) SHA1(d4caf998396ef2c05e28d4420f79f92e9e8d6587) )
	ROM_LOAD16_BYTE( "95426379.hi", 0x00000, 0x080000, CRC(8eac9f24) SHA1(33796e805f62fdf5a06b9f9039b3ba4f26e42c69) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotsha )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426432.lo", 0x00001, 0x080000, CRC(8fe78f1a) SHA1(08914988aa4b2cdead5d703e3fc4d72a22e57424) )
	ROM_LOAD16_BYTE( "95426433.hi", 0x00000, 0x080000, CRC(33ab3fb0) SHA1(a2e9f93595259ad43fd22f4447f524d3a5a9b4f8) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotshb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426492.lo", 0x00001, 0x080000, CRC(7748a9e4) SHA1(e7c05ffd0818806a14e85d877a930d8a29d3772f) )
	ROM_LOAD16_BYTE( "95426493.hi", 0x00000, 0x080000, CRC(eb082ebb) SHA1(a12db425c4f574d243d9efc92bb7aee5e9c52bb1) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotshc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426662.lo", 0x00001, 0x080000, CRC(7a1da6e9) SHA1(7d5105a552581bc6e9c51efa6a0133db764bb450) )
	ROM_LOAD16_BYTE( "95426663.hi", 0x00000, 0x080000, CRC(f91c2a59) SHA1(2465b73fa5f0f307dff5dddc5b731a88b68d2758) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotshd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426706.lo", 0x00001, 0x080000, CRC(fee0a9cb) SHA1(577c61d3592a8a9312f3a93954cf74ea34f62900) )
	ROM_LOAD16_BYTE( "95426707.hi", 0x00000, 0x080000, CRC(95e2c0f0) SHA1(a82831233060522e92018ad578ae7720498ec19f) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotshe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426806.lo", 0x00001, 0x080000, CRC(31c2e00c) SHA1(f6e891326b43373f0c76256838c2bae0abaa9c6e) )
	ROM_LOAD16_BYTE( "95426807.hi", 0x00000, 0x080000, CRC(fbcded97) SHA1(5b633c0c84bb75ac3a477d7653df6480246041ec) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotshf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427378.lo", 0x00001, 0x080000, CRC(6e791528) SHA1(9041d2b3b32586f07ebd063d9546ae4ab0a01211) )
	ROM_LOAD16_BYTE( "95427379.hi", 0x00000, 0x080000, CRC(7a72e8dd) SHA1(eea65ad5357a91f6566bba7dd080f70e3787d500) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotshg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427432.lo", 0x00001, 0x080000, CRC(ea984167) SHA1(114e62c31287eb5eabaf55ab2366bc11d723da54) )
	ROM_LOAD16_BYTE( "95427433.hi", 0x00000, 0x080000, CRC(ac23eb84) SHA1(4a6279bcf2506f818c65d673caf667f97f7bd7ed) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotshh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427492.lo", 0x00001, 0x080000, CRC(c4f6b00f) SHA1(cdc30c397b70f81ac71af1a9412318204e45a45d) )
	ROM_LOAD16_BYTE( "95427493.hi", 0x00000, 0x080000, CRC(65addb38) SHA1(c503b49ee656e192e602b78b4128e35e1b70a045) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotshi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427662.lo", 0x00001, 0x080000, CRC(46e7e3ec) SHA1(31101380d68273461dd8c4a0165412b9c27c01d5) )
	ROM_LOAD16_BYTE( "95427663.hi", 0x00000, 0x080000, CRC(72e5da79) SHA1(76ad619f8de621b238a597d484a05cf5dc96b500) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotshj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427706.lo", 0x00001, 0x080000, CRC(80203185) SHA1(b79b2674cd024ffe34a66bdd75702e80e35ee291) )
	ROM_LOAD16_BYTE( "95427707.hi", 0x00000, 0x080000, CRC(217834e6) SHA1(3d83e7dc6e9469bc9d84046a3ee50eb9b3e36f22) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotshk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427806.lo", 0x00001, 0x080000, CRC(9e99b3d3) SHA1(7a33d7722be6be998f98a4d0ad20ee11247191f3) )
	ROM_LOAD16_BYTE( "95427807.hi", 0x00000, 0x080000, CRC(2ba65e5e) SHA1(387ff5b15602033d3a96551ae5e167680c2545c4) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotshl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3211p11.hi", 0x00000, 0x080000, CRC(0b6a1b71) SHA1(d3275c100884f89593747d904f519eb562103954) )
	ROM_LOAD16_BYTE( "p3211p11.lo", 0x00001, 0x080000, CRC(2942b947) SHA1(e43b95175d3a0410a03c57a1f31971058db8e461) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotshm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3211p12.hi", 0x00000, 0x080000, CRC(3e8bd55d) SHA1(f6df6572d05f078b1c1c06504b470043a1cab575) )
	ROM_LOAD16_BYTE( "p3211p12.lo", 0x00001, 0x080000, CRC(4ab31d56) SHA1(76013ec461909b0e0e9ac1230d997fe52c31d697) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotshn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3211p14.hi", 0x00000, 0x080000, CRC(5b338215) SHA1(0773e07fef62eb20f8e2534a87cba1f47328dd48) )
	ROM_LOAD16_BYTE( "p3211p14.lo", 0x00001, 0x080000, CRC(5b0c156c) SHA1(bbec0bb77e5b2049b7a659db8879bdb484cb31eb) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotsho )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3211s11.hi", 0x00000, 0x080000, CRC(c7e65025) SHA1(71701b719e4f41788baf61ff02ccce695098e9f0) )
	ROM_LOAD16_BYTE( "p3211s11.lo", 0x00001, 0x080000, CRC(1a7ffa79) SHA1(7460053653cf7faf401058cdf10e18166b539188) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotshp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3211s12.hi", 0x00000, 0x080000, CRC(e2140ecf) SHA1(149e7e82a425c49a707606853625fe18e5b472c4) )
	ROM_LOAD16_BYTE( "p3211s12.lo", 0x00001, 0x080000, CRC(63f95c98) SHA1(66e7eca7627fd7920ea9bf99b9edd474c4f8078f) )
	sc_hotsh_others
ROM_END

ROM_START( sc5hotshq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3211s14.hi", 0x00000, 0x080000, CRC(dda94558) SHA1(3477387ae0f3d10e0c8008e7408ab5a09854d878) )
	ROM_LOAD16_BYTE( "p3211s14.lo", 0x00001, 0x080000, CRC(af9d682e) SHA1(0a3a5c2b6374e9d0692ec88698e9ef7a59dd4b48) )
	sc_hotsh_others
ROM_END


ROM_START( sc5hotwd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1311p11.hi", 0x00000, 0x080000, CRC(0cffb3d1) SHA1(15f11f612f2fc7d5b1b418c2c55cb14ca8b023a2) )
	ROM_LOAD16_BYTE( "p1311p11.lo", 0x00001, 0x080000, CRC(f5584b61) SHA1(f2a4bab089a574a93ca26571cda82e4c1275663a) )
	sc_hotwd_others
ROM_END

ROM_START( sc5hotwda )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1311p12.hi", 0x00000, 0x080000, CRC(a8d989c9) SHA1(38fa0909c4572c67e67d48afa51312a654669fbe) )
	ROM_LOAD16_BYTE( "p1311p12.lo", 0x00001, 0x080000, CRC(75f723ef) SHA1(40eb02aa77e6d515883def4346d825e8f3a85e6f) )
	sc_hotwd_others
ROM_END

ROM_START( sc5hotwdb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1311p13.hi", 0x00000, 0x080000, CRC(b1da1f1f) SHA1(8f042f4a2c8442bbbeacbf6aae6b95a36e8c09c4) )
	ROM_LOAD16_BYTE( "p1311p13.lo", 0x00001, 0x080000, CRC(c76afc6f) SHA1(43e2999c46d0e2e157660dc0e2729393e5fa1f03) )
	sc_hotwd_others
ROM_END

ROM_START( sc5hotwdc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1311p15.hi", 0x00000, 0x080000, CRC(1a01e95b) SHA1(9382b739f7e364e252dfeef28fb4b88e99bc8923) )
	ROM_LOAD16_BYTE( "p1311p15.lo", 0x00001, 0x080000, CRC(a1e5d6ca) SHA1(b670904a7e12c7686b72598e16f1b23683a1f94f) )
	sc_hotwd_others
ROM_END

ROM_START( sc5hotwdd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1311s11.hi", 0x00000, 0x080000, CRC(f527759d) SHA1(4f9ccaf11ce0a0a9691aa2c304d92152cb4048f0) )
	ROM_LOAD16_BYTE( "p1311s11.lo", 0x00001, 0x080000, CRC(77fb5395) SHA1(88f417d2ee5884dd6ceb1fb9ee5b91b81f6b8c30) )
	sc_hotwd_others
ROM_END

ROM_START( sc5hotwde )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1311s12.hi", 0x00000, 0x080000, CRC(c364eeca) SHA1(e2a6ebbd23329ab517dcedc57ad9df911bff6d4c) )
	ROM_LOAD16_BYTE( "p1311s12.lo", 0x00001, 0x080000, CRC(ac7674bd) SHA1(f45f83c044bb6761b5c466662d946eb3bccff02c) )
	sc_hotwd_others
ROM_END

ROM_START( sc5hotwdf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1311s13.hi", 0x00000, 0x080000, CRC(592ae4bd) SHA1(42d0d6240dd590867b9f5d56797f98d45313a9a0) )
	ROM_LOAD16_BYTE( "p1311s13.lo", 0x00001, 0x080000, CRC(be15bbb3) SHA1(477bd708c1a6953ecae4d54ba3bb826e1e7a7d13) )
	sc_hotwd_others
ROM_END

ROM_START( sc5hotwdg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1311s15.hi", 0x00000, 0x080000, CRC(a5c375e3) SHA1(3eb1ab2b99ced4d6ad411491d30afd4242830c72) )
	ROM_LOAD16_BYTE( "p1311s15.lo", 0x00001, 0x080000, CRC(a71d1ce2) SHA1(cd3a34f130c83e29640e3f02983eda76169b5611) )
	sc_hotwd_others
ROM_END



ROM_START( sc5celeb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412424.lo", 0x00001, 0x080000, CRC(391bf7c3) SHA1(02c316aa45dd404d9ddb46120ec206ec8830f211) )
	ROM_LOAD16_BYTE( "95412425.hi", 0x00000, 0x080000, CRC(62784b29) SHA1(ceb750d2a053073d62e4935a94ff4ddbba1a20ec) )
	sc_celeb_others
ROM_END

ROM_START( sc5celeba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412568.lo", 0x00001, 0x080000, CRC(2fc69a9d) SHA1(df7a49bc9da5292189adf8b72acfeb8b0c2abebc) )
	ROM_LOAD16_BYTE( "95412569.hi", 0x00000, 0x080000, CRC(893c2f30) SHA1(84575fd6e815f4978e6fbacf3c5b27313636e98b) )
	sc_celeb_others
ROM_END

ROM_START( sc5celebb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413424.lo", 0x00001, 0x080000, CRC(0a399355) SHA1(9402446df85a74515cdc48c693d3feca70946c03) )
	ROM_LOAD16_BYTE( "95413425.hi", 0x00000, 0x080000, CRC(0381d540) SHA1(55fc831b4ad4a10728de34c813de08e0565d3952) )
	sc_celeb_others
ROM_END

ROM_START( sc5celebc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413568.lo", 0x00001, 0x080000, CRC(591c333d) SHA1(d7ee1da41f2ff761d6b354cae887ad5ec1e480a4) )
	ROM_LOAD16_BYTE( "95413569.hi", 0x00000, 0x080000, CRC(fc6be370) SHA1(8459c6c029d65d5313a6086f44f5c990dfbf4ed4) )
	sc_celeb_others
ROM_END

ROM_START( sc5celebd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "celebs5.lo",  0x00001, 0x080000, CRC(4b13ea1e) SHA1(40cfb21c296531f7cbc97f34b26efe65df03e3a8) )
	ROM_LOAD16_BYTE( "celebs5.hi",  0x00000, 0x080000, CRC(2db750d2) SHA1(b16e38f82e5661c654f0a82f64b00e840042ec05) )
	sc_celeb_others
ROM_END



ROM_START( sc5inspn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416702.lo", 0x00001, 0x080000, CRC(043ede54) SHA1(479fd31d1eedbf7ac45422f0a5299ad4beb9eadc) )
	ROM_LOAD16_BYTE( "95416703.hi", 0x00000, 0x080000, CRC(7fa5e2ff) SHA1(92aa510ad144cbe884d5f7b82e3ebbbb05b2eec3) )
	sc_inspn_others
ROM_END

ROM_START( sc5inspna )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417702.lo", 0x00001, 0x080000, CRC(e6088c2e) SHA1(471ca3116ce3554cc80bd945a113af650a54a81b) )
	ROM_LOAD16_BYTE( "95417703.hi", 0x00000, 0x080000, CRC(c8ecffdc) SHA1(26730d51e437f6b1701a73dacb34d25c6edbe536) )
	sc_inspn_others
ROM_END




ROM_START( sc5ijob )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422376.lo", 0x00001, 0x080000, CRC(c1e81dba) SHA1(146ffbbe4c5da6bbfd73250a09d355ed91498539) )
	ROM_LOAD16_BYTE( "95422377.hi", 0x00000, 0x080000, CRC(ba0bd975) SHA1(0948ca47ffc906e10a9ebc1105e9aafc1d325d24) )
	sc_ijob_others
ROM_END

ROM_START( sc5ijoba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422586.lo", 0x00001, 0x080000, CRC(9d5f65d3) SHA1(208344ff0fa960802261d974c53b9e016d6b71b7) )
	ROM_LOAD16_BYTE( "95422587.hi", 0x00000, 0x080000, CRC(f1931c78) SHA1(9aed7e12edb415dbe3e78ab81ec0775c168b31d2) )
	sc_ijob_others
ROM_END

ROM_START( sc5ijobb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423376.lo", 0x00001, 0x080000, CRC(cdd90a5c) SHA1(785dafbac3db909c3d69ce80e14154fac58f614d) )
	ROM_LOAD16_BYTE( "95423377.hi", 0x00000, 0x080000, CRC(b3813d77) SHA1(ee5fbdd623abbf88a362881f30cc645ea75e8d83) )
	sc_ijob_others
ROM_END

ROM_START( sc5ijobc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423586.lo", 0x00001, 0x080000, CRC(1737cf65) SHA1(e29ffc76e4dec2ea77aaf345ab035ef03983ad17) )
	ROM_LOAD16_BYTE( "95423587.hi", 0x00000, 0x080000, CRC(ecf4da0a) SHA1(f4e6b83a74e32d4c59f0c67564e6969458aaab46) )
	sc_ijob_others
ROM_END

ROM_START( sc5ijobd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426076.lo", 0x00001, 0x080000, CRC(9aca7761) SHA1(6998382d3f5867802a429f755875f1e12a6f1dd5) )
	ROM_LOAD16_BYTE( "95426077.hi", 0x00000, 0x080000, CRC(8d979dec) SHA1(6beeae68a6a2af27ce37366f8ccaeea0dd37f2d9) )
	sc_ijob_others
ROM_END

ROM_START( sc5ijobe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426274.lo", 0x00001, 0x080000, CRC(3ec8d159) SHA1(ca7ec3e05f34fdafa270e2850bbcb1873e298f27) )
	ROM_LOAD16_BYTE( "95426275.hi", 0x00000, 0x080000, CRC(5c2a2eea) SHA1(1e3f7ee4ac09c0edaeed81a49e9e5d112bd65643) )
	sc_ijob_others
ROM_END

ROM_START( sc5ijobf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426460.lo", 0x00001, 0x080000, CRC(3d738a1e) SHA1(f1f7e24f95e284b31633bad4673b41e8e9bd4f5a) )
	ROM_LOAD16_BYTE( "95426461.hi", 0x00000, 0x080000, CRC(eec70c63) SHA1(557bb62d9dd9eec978278b5954861546cf3f1523) )
	sc_ijob_others
ROM_END

ROM_START( sc5ijobg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427076.lo", 0x00001, 0x080000, CRC(06a0d769) SHA1(58cb11b2eb0e1166d9f3e121aedf85cff692ecdf) )
	ROM_LOAD16_BYTE( "95427077.hi", 0x00000, 0x080000, CRC(e235e8e5) SHA1(7a6601649dcb3897390aa11a35286f254045cbf9) )
	sc_ijob_others
ROM_END

ROM_START( sc5ijobh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427274.lo", 0x00001, 0x080000, CRC(30efe63b) SHA1(6842d7c36a75a64abaccf3bed1c657e26868e5d2) )
	ROM_LOAD16_BYTE( "95427275.hi", 0x00000, 0x080000, CRC(39a1266b) SHA1(c87e04d20ae87fb528c1668ea4a7f2e0c5df5e62) )
	sc_ijob_others
ROM_END

ROM_START( sc5ijobi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427460.lo", 0x00001, 0x080000, CRC(020fd6d7) SHA1(fe1a4c8196359fc18fb89d5b52d73b2df95c97b8) )
	ROM_LOAD16_BYTE( "95427461.hi", 0x00000, 0x080000, CRC(167ad51d) SHA1(be27d3c14376f232306dc261810842ec031a7399) )
	sc_ijob_others
ROM_END


ROM_START( sc5jjok )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412588.lo", 0x00001, 0x080000, CRC(c1bd880f) SHA1(985b162876f8d2971b4630a6001da020cd2785a2) )
	ROM_LOAD16_BYTE( "95412589.hi", 0x00000, 0x080000, CRC(1f083bd2) SHA1(300656a971b6172f2bbf6e5156af58f5589b2e8a) )
	sc_jjok_others
ROM_END

ROM_START( sc5jjoka )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413588.lo", 0x00001, 0x080000, CRC(dbc1e95d) SHA1(30af0b19422cc35201fbbd533db358d1f7881cf8) )
	ROM_LOAD16_BYTE( "95413589.hi", 0x00000, 0x080000, CRC(ce90b42f) SHA1(0da6f8e1579cee0b7a1bb2d2828470971da85afb) )
	sc_jjok_others
ROM_END


ROM_START( sc5ldvl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420972.lo", 0x00001, 0x080000, CRC(92a3c6ab) SHA1(dbfe3c6e9b751dad14993a9ed18a966f7587569b) )
	ROM_LOAD16_BYTE( "95420973.hi", 0x00000, 0x080000, CRC(eabf2e76) SHA1(9a14afd1a5f8fcd02c43172038323cea53512ac4) )
	sc_ldvl_others
ROM_END

ROM_START( sc5ldvla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421972.lo", 0x00001, 0x080000, CRC(14c9318b) SHA1(69a0c1ad26488402cdf8b9e1904ce6ba159f448d) )
	ROM_LOAD16_BYTE( "95421973.hi", 0x00000, 0x080000, CRC(392e6b98) SHA1(f1600ab27c587cd5b141e721e740c73a08fd563e) )
	sc_ldvl_others
ROM_END

ROM_START( sc5ldvlb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424494.lo", 0x00001, 0x080000, CRC(ad821007) SHA1(0498b98222806344d5b29d1866922e705f4bd861) )
	ROM_LOAD16_BYTE( "95424495.hi", 0x00000, 0x080000, CRC(e5934cc5) SHA1(8641f90f0e1d47bee9d01e75552d94c368f50c87) )
	sc_ldvl_others
ROM_END

ROM_START( sc5ldvlc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424534.lo", 0x00001, 0x080000, CRC(40d2de6a) SHA1(9e6e91d68976e9316f3c001cead6f7419bc4c2e0) )
	ROM_LOAD16_BYTE( "95424535.hi", 0x00000, 0x080000, CRC(6f67a83f) SHA1(37355719a6660f2c8bf2d30fe44c44f99828d6af) )
	sc_ldvl_others
ROM_END

ROM_START( sc5ldvld )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425494.lo", 0x00001, 0x080000, CRC(8532bb68) SHA1(c090a7150297ac76dcbd86ce2b42c30f37746935) )
	ROM_LOAD16_BYTE( "95425495.hi", 0x00000, 0x080000, CRC(e72f6e48) SHA1(79570758a8211a1f9d22ae521ba1a84c7d3eb3b5) )
	sc_ldvl_others
ROM_END

ROM_START( sc5ldvle )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425534.lo", 0x00001, 0x080000, CRC(5171fa1e) SHA1(b465747669956087e2ded1ddcc113cb20b9c3500) )
	ROM_LOAD16_BYTE( "95425535.hi", 0x00000, 0x080000, CRC(e6a44159) SHA1(64855a21c320d41450c6d5737f1c876493a0e5a3) )
	sc_ldvl_others
ROM_END


ROM_START( sc5lotrr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410394.lo", 0x00001, 0x080000, CRC(d557f534) SHA1(9efd379e6197a94ec14642871a24c94f71e9a24b) )
	ROM_LOAD16_BYTE( "95410395.hi", 0x00000, 0x080000, CRC(10314cd5) SHA1(c784bb54c73d959f0e3f35a1e8bb18b139df4eb5) )
	sc_lotrr_others
ROM_END

ROM_START( sc5lotrra )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410396.lo", 0x00001, 0x080000, CRC(2a3a7527) SHA1(26460b7bf3b7b0908bc3c2dcd6ee28b1980f5e24) )
	ROM_LOAD16_BYTE( "95410397.hi", 0x00000, 0x080000, CRC(0ec51414) SHA1(8703d411222f88b46316d0bb435fff93c092fef2) )
	sc_lotrr_others
ROM_END

ROM_START( sc5lotrrb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410626.lo", 0x00001, 0x080000, CRC(dd2020ce) SHA1(02926072b4c2450eb5f5220a92d008acbc2eae33) )
	ROM_LOAD16_BYTE( "95410627.hi", 0x00000, 0x080000, CRC(e82db72a) SHA1(697350b6694c3cc1d1a2a56a2757e40892dcd194) )
	sc_lotrr_others
ROM_END

ROM_START( sc5lotrrc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410628.lo", 0x00001, 0x080000, CRC(dcd4fb17) SHA1(5b799d1781985295d096e6531c8889adac93c32e) )
	ROM_LOAD16_BYTE( "95410629.hi", 0x00000, 0x080000, CRC(3092caa2) SHA1(aa271b2deeed72c0683838c360fd95839071f89d) )
	sc_lotrr_others
ROM_END

ROM_START( sc5lotrrd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411394.lo", 0x00001, 0x080000, CRC(b5b840e9) SHA1(c30b0a0b2b5783ad6948a72cf81cba75f17a0c22) )
	ROM_LOAD16_BYTE( "95411395.hi", 0x00000, 0x080000, CRC(6658a38f) SHA1(5827af96fd9a8ff1dc0ad7a166303eee083b66ec) )
	sc_lotrr_others
ROM_END

ROM_START( sc5lotrre )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411626.lo", 0x00001, 0x080000, CRC(c6c96d4d) SHA1(c03172ae532a8a4f925aab57134e6662a349c3a7) )
	ROM_LOAD16_BYTE( "95411627.hi", 0x00000, 0x080000, CRC(4dc69691) SHA1(19fe57968e0a1f905b3c5bcdcc728c29ecab9048) )
	sc_lotrr_others
ROM_END

ROM_START( sc5lotrrf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411628.lo", 0x00001, 0x080000, CRC(c73db694) SHA1(0974f02f6b033448dbe5853128402aaa3a74ff65) )
	ROM_LOAD16_BYTE( "95411629.hi", 0x00000, 0x080000, CRC(9579eb19) SHA1(1544a6a1511f2b81286a8903bb5bba50833f86e2) )
	sc_lotrr_others
ROM_END

ROM_START( sc5lotrrg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412576.lo", 0x00001, 0x080000, CRC(074e4d44) SHA1(051dfe059170cb03f921b7f3a2d5352edd86cbe1) )
	ROM_LOAD16_BYTE( "95412577.hi", 0x00000, 0x080000, CRC(979476d8) SHA1(b4be828f6c37039234438f0dc0b73c17bcbceebe) )
	sc_lotrr_others
ROM_END

ROM_START( sc5lotrrh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411396.lo", 0x00001, 0x080000, CRC(4ad5c0fa) SHA1(8b881cd9ee1440b48644bf9cdf93637b74c75cb2) )
	ROM_LOAD16_BYTE( "95411397.hi", 0x00000, 0x080000, CRC(78acfb4e) SHA1(1d9b251a73bfd8452c1842c0a96c020c1d123906) )
	sc_lotrr_others
ROM_END

ROM_START( sc5lotrri )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413576.lo", 0x00001, 0x080000, CRC(367be3bb) SHA1(0cc3829fab1b7e9472ec8012b95720444252ed33) )
	ROM_LOAD16_BYTE( "95413577.hi", 0x00000, 0x080000, CRC(d24a64d8) SHA1(ce1f8ec91926bd22be929dadd3e974354ad930d1) )
	sc_lotrr_others
ROM_END


ROM_START( sc5manic )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418954.lo", 0x00001, 0x080000, CRC(3758a20f) SHA1(870bd48a697ef4bf28675a12c9dc00da27693ea2) )
	ROM_LOAD16_BYTE( "95418955.hi", 0x00000, 0x080000, CRC(ee9bbdd7) SHA1(65ea3d6e74c0b44659ba121dc32f05b2f4df101e) )
	sc_manic_others
ROM_END

ROM_START( sc5manica )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419954.lo", 0x00001, 0x080000, CRC(e4935b60) SHA1(226dc89b4046f315c01edcd222ed1676687c7b1e) )
	ROM_LOAD16_BYTE( "95419955.hi", 0x00000, 0x080000, CRC(e4c66930) SHA1(e32c4f1cd0f8db0723d0dd42016d8a4a1b075bc2) )
	sc_manic_others
ROM_END

ROM_START( sc5manicb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422040.lo", 0x00001, 0x080000, CRC(3c6cbcac) SHA1(102776c47d924d1c027217095aa33ef09e935bea) )
	ROM_LOAD16_BYTE( "95422041.hi", 0x00000, 0x080000, CRC(9d3177e6) SHA1(ec939b5b2508c7d420e34efc4d06bb71070e699e) )
	sc_manic_others
ROM_END

ROM_START( sc5manicc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422064.lo", 0x00001, 0x080000, CRC(82b62da6) SHA1(8c7f9bab82027dcdba3c3587d607a3deabeb5e47) )
	ROM_LOAD16_BYTE( "95422065.hi", 0x00000, 0x080000, CRC(b3444633) SHA1(c0c7473475fb8f06731aaa0aac73d914f087a1ee) )
	sc_manic_others
ROM_END

ROM_START( sc5manicd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422130.lo", 0x00001, 0x080000, CRC(7c591231) SHA1(b2e23a0c9887fcdea2a9cae0dc7d0569725f7430) )
	ROM_LOAD16_BYTE( "95422131.hi", 0x00000, 0x080000, CRC(70c795a4) SHA1(830246c935328ae6ed2212df1fd0ebaf7b50922c) )
	sc_manic_others
ROM_END

ROM_START( sc5manice )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422220.lo", 0x00001, 0x080000, CRC(7f46c357) SHA1(6b5cf3b6c6bae254c4194b4e9c378179e3b954fd) )
	ROM_LOAD16_BYTE( "95422221.hi", 0x00000, 0x080000, CRC(d465b976) SHA1(29c7ac7cf03bb4bd79b75a4cf7862175ffa58cfc) )
	sc_manic_others
ROM_END

ROM_START( sc5manicf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422602.lo", 0x00001, 0x080000, CRC(3b418150) SHA1(82124b1a3baa711bdd0883d06d8c58fb19755230) )
	ROM_LOAD16_BYTE( "95422603.hi", 0x00000, 0x080000, CRC(6f6a87ad) SHA1(736f386546fd849133fd389d1d06d67eccfd2951) )
	sc_manic_others
ROM_END

ROM_START( sc5manicg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422606.lo", 0x00001, 0x080000, CRC(9a280f93) SHA1(a7b5d01dc60457e34ceb2ebca868c2c2b6051b67) )
	ROM_LOAD16_BYTE( "95422607.hi", 0x00000, 0x080000, CRC(f940ab5b) SHA1(bc61e1b9a11a235f90231e1d68659b2a0435adea) )
	sc_manic_others
ROM_END

ROM_START( sc5manich )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422848.lo", 0x00001, 0x080000, CRC(fbe5a0c2) SHA1(4e537a9d92ce074faec6ef05410260aceefb1102) )
	ROM_LOAD16_BYTE( "95422849.hi", 0x00000, 0x080000, CRC(6c713bf1) SHA1(844bc26a49cb84697dbc33990ff79b31a83f6e1c) )
	sc_manic_others
ROM_END

ROM_START( sc5manici )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423040.lo", 0x00001, 0x080000, CRC(8d9478a2) SHA1(a4e4ea0444bc6b449e388194a4637940b7f083c8) )
	ROM_LOAD16_BYTE( "95423041.hi", 0x00000, 0x080000, CRC(104ec1d5) SHA1(36c6516cde84cdd75f8e83469756c17b8d7bdd6e) )
	sc_manic_others
ROM_END

ROM_START( sc5manicj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423064.lo", 0x00001, 0x080000, CRC(2b38fff9) SHA1(1fa95721790787c9199b7b2f05d591c233c6af05) )
	ROM_LOAD16_BYTE( "95423065.hi", 0x00000, 0x080000, CRC(c9a9b34f) SHA1(14630d4343fd509e1f6312ce539eeaf7e95f8869) )
	sc_manic_others
ROM_END

ROM_START( sc5manick )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423130.lo", 0x00001, 0x080000, CRC(3adbe9d3) SHA1(ff798442dd3d9613653c27aed4e584be9955c77f) )
	ROM_LOAD16_BYTE( "95423131.hi", 0x00000, 0x080000, CRC(ec9fe351) SHA1(1db66081159e45f66935bfe626e1f8dc0d0a28fb) )
	sc_manic_others
ROM_END

ROM_START( sc5manicl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423220.lo", 0x00001, 0x080000, CRC(69c473bb) SHA1(21573b9122994a936791d90c3b2ab43147a8e671) )
	ROM_LOAD16_BYTE( "95423221.hi", 0x00000, 0x080000, CRC(3dcadd66) SHA1(9c62d85f455ff5cf0c14c0afc22e895b335ce1be) )
	sc_manic_others
ROM_END

ROM_START( sc5manicm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423602.lo", 0x00001, 0x080000, CRC(d274e0aa) SHA1(bd582efc40256c9c41a2c388645ee572d43bd022) )
	ROM_LOAD16_BYTE( "95423603.hi", 0x00000, 0x080000, CRC(97ac122a) SHA1(a0d5ab34c3761dadd068ec2c62a859a4382630fa) )
	sc_manic_others
ROM_END

ROM_START( sc5manicn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423606.lo", 0x00001, 0x080000, CRC(24d8c137) SHA1(7af4e6a5d60cbab11dcf8db6d6b4016485ffbbb1) )
	ROM_LOAD16_BYTE( "95423607.hi", 0x00000, 0x080000, CRC(56a4fd89) SHA1(9d86f3a36fd69480aeaeef5c307ecd348ab2bb39) )
	sc_manic_others
ROM_END

ROM_START( sc5manico )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423848.lo", 0x00001, 0x080000, CRC(7cc1b546) SHA1(a244749c02fb571b2c9ec58a850d2956d00825dc) )
	ROM_LOAD16_BYTE( "95423849.hi", 0x00000, 0x080000, CRC(5d1b2ec1) SHA1(58a373d7aeb51ae9decac196e2a4093c0d296409) )
	sc_manic_others
ROM_END

ROM_START( sc5manicp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426160.lo", 0x00001, 0x080000, CRC(24fd7f44) SHA1(4631c7e8a7a7e4284bcddb7d678d027e11811961) )
	ROM_LOAD16_BYTE( "95426161.hi", 0x00000, 0x080000, CRC(8c9d61ed) SHA1(06133837c46d701ee235b6fc49dcf6e5506e3ba7) )
	sc_manic_others
ROM_END

ROM_START( sc5manicq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427160.lo", 0x00001, 0x080000, CRC(862c8680) SHA1(80e065396cc29ebec3ba657ba4777da634bec80c) )
	ROM_LOAD16_BYTE( "95427161.hi", 0x00000, 0x080000, CRC(8d0b8065) SHA1(3aeae265d5e65cdf57d105fa80058868378cd053) )
	sc_manic_others
ROM_END

ROM_START( sc5manicr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3004p41.hi", 0x00000, 0x080000, CRC(40e95a09) SHA1(83dc70405ec508cce10b4740c10b14e3563306bd) )
	ROM_LOAD16_BYTE( "p3004p41.lo", 0x00001, 0x080000, CRC(8db63e76) SHA1(eef45761e39ee007a694ac3971c97b1e8b046d25) )
	sc_manic_others
ROM_END

ROM_START( sc5manics )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3004p43.hi", 0x00000, 0x080000, CRC(5b3e487e) SHA1(86b3a3cdb5988a4eaef031fc03c605af968f721b) )
	ROM_LOAD16_BYTE( "p3004p43.lo", 0x00001, 0x080000, CRC(cdcf44b6) SHA1(16d1672c6e35659cda22c11357bcb0b3b197e3e0) )
	sc_manic_others
ROM_END

ROM_START( sc5manict )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3004p44.hi", 0x00000, 0x080000, CRC(150b1ffc) SHA1(23433e39127a6aef4770aaba6f18b44beb5887eb) )
	ROM_LOAD16_BYTE( "p3004p44.lo", 0x00001, 0x080000, CRC(5e9eaa65) SHA1(d680b621370e332735bf1a3f48c1deff810053e1) )
	sc_manic_others
ROM_END

ROM_START( sc5manicu )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3004s41.hi", 0x00000, 0x080000, CRC(2ead5734) SHA1(8b5677a38300178edc5afc8e903714a0d7f79c90) )
	ROM_LOAD16_BYTE( "p3004s41.lo", 0x00001, 0x080000, CRC(cd8b7fa6) SHA1(df3392dc4f5a970ecc2a6a37966507cfa2c5481a) )
	sc_manic_others
ROM_END

ROM_START( sc5manicv )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3004s43.hi", 0x00000, 0x080000, CRC(befacc80) SHA1(41dcacb2f6e6e6bd2f5dd7ee0f78d9bb06d91197) )
	ROM_LOAD16_BYTE( "p3004s43.lo", 0x00001, 0x080000, CRC(4e42a679) SHA1(2f23f70c93bc81b0667ae78b2ffdcc50cfc2735d) )
	sc_manic_others
ROM_END

ROM_START( sc5manicw )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3004s44.hi", 0x00000, 0x080000, CRC(a9b34b7c) SHA1(9fd57ca197fc4309b943fc2b0731c5af4db1d7f5) )
	ROM_LOAD16_BYTE( "p3004s44.lo", 0x00001, 0x080000, CRC(419e18dd) SHA1(491b029eaf05ac6c08a26141f36c32b22d9955e8) )
	sc_manic_others
ROM_END


ROM_START( sc5mmm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416792.lo", 0x00001, 0x080000, CRC(4b1ae1cd) SHA1(2b3523032995517dfd46835c2f3483b4da9f4eef) )
	ROM_LOAD16_BYTE( "95416793.hi", 0x00000, 0x080000, CRC(4d02586f) SHA1(7543b55d0aa1a83e5061d4456006a8412579ece7) )
	sc_mmm_others
ROM_END

ROM_START( sc5mmma )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417792.lo", 0x00001, 0x080000, CRC(b4145441) SHA1(c468b712077d58943195f1ceac7b6015f8f80286) )
	ROM_LOAD16_BYTE( "95417793.hi", 0x00000, 0x080000, CRC(e4335ab0) SHA1(2d521a5a4ce726deaf697635d212e4886fecb878) )
	sc_mmm_others
ROM_END

ROM_START( sc5mmmb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420198.lo", 0x00001, 0x080000, CRC(e807d9b2) SHA1(f39c9538e4b1d5c58e05a9d5f8175e7b01e87e95) )
	ROM_LOAD16_BYTE( "95420199.hi", 0x00000, 0x080000, CRC(0d32d35d) SHA1(743ab7d17c6bf71655c932dee2ec588db05fdf4f) )
	sc_mmm_others
ROM_END

ROM_START( sc5mmmc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421198.lo", 0x00001, 0x080000, CRC(af505287) SHA1(297c86c15a5ef29a4c40535e64ee7d96e778d4b1) )
	ROM_LOAD16_BYTE( "95421199.hi", 0x00000, 0x080000, CRC(2281800b) SHA1(3fd26e5f63ac03331e291a852187c5cfea3338d0) )
	sc_mmm_others
ROM_END


ROM_START( sc5mmad )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416292.lo", 0x00001, 0x080000, CRC(6085bc70) SHA1(1232ca906257e281fb7dbe7b8e8bd1a5dfeee3c0) )
	ROM_LOAD16_BYTE( "95416293.hi", 0x00000, 0x080000, CRC(a3f1a116) SHA1(a3647d6091c00f785bde930543869173bb21b45d) )
	sc_mmad_others
ROM_END

ROM_START( sc5mmada )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417292.lo", 0x00001, 0x080000, CRC(e8fd792a) SHA1(b1f826c0f1dd4a6b84a67a3f2e50a9517f91ef74) )
	ROM_LOAD16_BYTE( "95417293.hi", 0x00000, 0x080000, CRC(c272846e) SHA1(645c1e7d7452de44319d70722d51c5e192fe8230) )
	sc_mmad_others
ROM_END

ROM_START( sc5mmadb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420440.lo", 0x00001, 0x080000, CRC(40a0c5b7) SHA1(11ccb76c795e5d80a82d217bb7321c8e39cb33ee) )
	ROM_LOAD16_BYTE( "95420441.hi", 0x00000, 0x080000, CRC(31a5b3e1) SHA1(b4cd4f15579c8b5036554da07c06e16c4c4dc731) )
	sc_mmad_others
ROM_END

ROM_START( sc5mmadc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421440.lo", 0x00001, 0x080000, CRC(f3a57e0d) SHA1(a04ec2967029e8cef6621add046ceff63ab85896) )
	ROM_LOAD16_BYTE( "95421441.hi", 0x00000, 0x080000, CRC(794bacd7) SHA1(d292b87abd417c94f9643a50c9b2c2dd12bcfda1) )
	sc_mmad_others
ROM_END



ROM_START( sc5monsp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424496.lo", 0x00001, 0x080000, CRC(707f0a4d) SHA1(49bf6cae5e614b0976ae01577c31ef362c4820b6) )
	ROM_LOAD16_BYTE( "95424497.hi", 0x00000, 0x080000, CRC(8e00f6bb) SHA1(fea7d48bfe1c40efd54b1fe851930b3bf2bd1cf2) )
	sc_monsp_others
ROM_END

ROM_START( sc5monspa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425496.lo", 0x00001, 0x080000, CRC(3f968c3c) SHA1(9ee5665bbd73e76dd887b2e3982bb57c74b98a42) )
	ROM_LOAD16_BYTE( "95425497.hi", 0x00000, 0x080000, CRC(a44aaa2e) SHA1(ea03a114ad222093556ed44fbad14c67a4cc4aaf) )
	sc_monsp_others
ROM_END


ROM_START( sc5monop )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420488.lo", 0x00001, 0x080000, CRC(33d94d81) SHA1(2d7274636e99ea6b78bdb85676f04fc10d37f973) )
	ROM_LOAD16_BYTE( "95420489.hi", 0x00000, 0x080000, NO_DUMP )
	sc_monop_others
ROM_END

ROM_START( ad5monop )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASE00 )
	ROM_LOAD( "39211239.bin", 0x0000, 0x6a78e0, CRC(024795a6) SHA1(aba82d4a61efaa4c48750fc62e6a369aa2a8df9d) )
	ROM_LOAD( "39211250.bin", 0x0000, 0x6a791a, CRC(21909cb4) SHA1(28c028469e899659cbcca007f59ee3509d8b0f7a) )
	ROM_LOAD( "39211251.bin", 0x0000, 0x6a7a5e, CRC(ebbf403c) SHA1(ea993d78c41a71677ec3eacb6d11260037aeaac8) )
	ROM_LOAD( "39211260.bin", 0x0000, 0x6a839a, CRC(fa8e2b2a) SHA1(1749fbd7515574b77b083c5dc81c2071a089c52d) )
	ROM_LOAD( "39211262.bin", 0x0000, 0x6a6792, CRC(994ac3ab) SHA1(1b56fa251d32f20210ec695a789a4bd8c7bfe8ed) )
	ROM_LOAD( "39211263.bin", 0x0000, 0x6a664e, CRC(dc1c15f5) SHA1(a844b41e6c5a96b3165dfc000e525c35a34455ab) )
	ROM_LOAD( "39212239.bin", 0x0000, 0x6a78e0, CRC(838be734) SHA1(2a44c212cd6c2ba66661aa635ddb726fa9636d3c) )
	ROM_LOAD( "39212250.bin", 0x0000, 0x6a791a, CRC(a5ceface) SHA1(7fc03517b81e999e26c7ac55ffa6a4afa86e5717) )
	ROM_LOAD( "39212251.bin", 0x0000, 0x6a7a5e, CRC(abc6ee9c) SHA1(480db09f6a06d542347cbae6aa7192c5bfccbd48) )
	ROM_LOAD( "39212260.bin", 0x0000, 0x6a839a, CRC(c041863e) SHA1(afec88e97b65a3ed1d57085407abd4167007ed72) )
	ROM_LOAD( "39212262.bin", 0x0000, 0x6a6792, CRC(b8a7d34c) SHA1(e36964250a6e247030546ca4f181c9a70a89f61d) )
	ROM_LOAD( "39212263.bin", 0x0000, 0x6a664e, CRC(3bde8adb) SHA1(0ac2d4619cf2ca637fbdea867662b38de2661e1a) )
ROM_END

ROM_START( sc5mcas )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420718.lo", 0x00001, 0x080000, CRC(8ec09243) SHA1(1008e28918926c0198d19bc1a90c59fc8a75efaf) )
	ROM_LOAD16_BYTE( "95420719.hi", 0x00000, 0x080000, CRC(19b843c2) SHA1(d133fdcba113dbb9c596c14bc7be15fdd08763c7) )
	sc_mcas_others
ROM_END

ROM_START( sc5mcasb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420780.lo", 0x00001, 0x080000, CRC(37465003) SHA1(42488e61bd48d06659f5954626046ac2ca48b315) )
	ROM_LOAD16_BYTE( "95420781.hi", 0x00000, 0x080000, CRC(6e824600) SHA1(fb2254aeec9848d4c56b9ef8ca214db3ed0cadfb) )
	sc_mcas_others
ROM_END

ROM_START( sc5mcasa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421718.lo", 0x00001, 0x080000, CRC(9103b282) SHA1(2d247067c10840cc21bb7c84e8b587538c66f1fd) )
	ROM_LOAD16_BYTE( "95421719.hi", 0x00000, 0x080000, CRC(73f21b2a) SHA1(0f876862771fefb33909f4667b8f740fdd1a56af) )
	sc_mcas_others
ROM_END

ROM_START( sc5mcasc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421780.lo", 0x00001, 0x080000, CRC(84543a44) SHA1(db5998172cbad9cfab939dc028e49889d2bec83f) )
	ROM_LOAD16_BYTE( "95421781.hi", 0x00000, 0x080000, CRC(2fbd7aaa) SHA1(c7e76a7fb74c49c207496c47c90403f027eda33b) )
	sc_mcas_others
ROM_END


ROM_START( sc5mdm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426660.lo", 0x00001, 0x080000, CRC(b533a2ae) SHA1(21671734a5f0d442bc25d0e946e91f7a790f36f0) )
	ROM_LOAD16_BYTE( "95426661.hi", 0x00000, 0x080000, CRC(59b4d908) SHA1(82ef3bf1fa6d6ae641bcbc5748ec585c73436b9e) )
	sc_mdm_others
ROM_END

ROM_START( sc5mdma )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426698.lo", 0x00001, 0x080000, CRC(8a8eef91) SHA1(357926a4af0fa52291d3b2df2d2a5255efa00477) )
	ROM_LOAD16_BYTE( "95426699.hi", 0x00000, 0x080000, CRC(e1afee66) SHA1(0219cc8c54f53c13a36afa4a5de227e1e6aa197e) )
	sc_mdm_others
ROM_END

ROM_START( sc5mdmb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427660.lo", 0x00001, 0x080000, CRC(9778aca2) SHA1(f0b2158012d93f1dd3bdd9af45ff72ee34799f2b) )
	ROM_LOAD16_BYTE( "95427661.hi", 0x00000, 0x080000, CRC(bacfd623) SHA1(bf7a9841b1a6dce97091965bf0594b85690d0487) )
	sc_mdm_others
ROM_END

ROM_START( sc5mdmc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427698.lo", 0x00001, 0x080000, CRC(73292c8c) SHA1(7b55bc288e00c2862949a5f610735e56e13a1a70) )
	ROM_LOAD16_BYTE( "95427699.hi", 0x00000, 0x080000, CRC(735b72ac) SHA1(432cd5941e072a84b070c9fb136ec670ab013f76) )
	sc_mdm_others
ROM_END



ROM_START( sc5mhn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420796.lo", 0x00001, 0x080000, CRC(556c7064) SHA1(3dd303fc26102093306fb371d700b4864fb7c035) )
	ROM_LOAD16_BYTE( "95420797.hi", 0x00000, 0x080000, CRC(28e3d8a8) SHA1(0b2427c55e0181d01ec743afe1264cf661e1698e) )
	sc_mhn_others
ROM_END

ROM_START( sc5mhna )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421796.lo", 0x00001, 0x080000, CRC(69363a0d) SHA1(82dfc0bac3310b00169b2594b4c42ad154c7a7a7) )
	ROM_LOAD16_BYTE( "95421797.hi", 0x00000, 0x080000, CRC(dfc0b777) SHA1(439455b72493d6fb56a32452fafe34a72d543689) )
	sc_mhn_others
ROM_END

ROM_START( sc5mhnb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424492.lo", 0x00001, 0x080000, CRC(33207db3) SHA1(b2af1a29eee50f0e965bcf5804fa8c26f721a410) )
	ROM_LOAD16_BYTE( "95424493.hi", 0x00000, 0x080000, CRC(449e66fe) SHA1(05350ebbadfe92d42f11d80d52afcb43c1efffd9) )
	sc_mhn_others
ROM_END

ROM_START( sc5mhnc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424532.lo", 0x00001, 0x080000, CRC(38669184) SHA1(4d0a27d155b63fdaeb75746e0ba904663ceba209) )
	ROM_LOAD16_BYTE( "95424533.hi", 0x00000, 0x080000, CRC(e47900a7) SHA1(28839a52130b0a484870a8750a47b3eee8298b9e) )
	sc_mhn_others
ROM_END

ROM_START( sc5mhnd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425492.lo", 0x00001, 0x080000, CRC(6e62911d) SHA1(99c6b45e81372f8a6f95f199b6bbf35a1900aa05) )
	ROM_LOAD16_BYTE( "95425493.hi", 0x00000, 0x080000, CRC(ddb2ca2a) SHA1(bcdf63ffb4192c28fe4752279549d3e6d01ce5a3) )
	sc_mhn_others
ROM_END

ROM_START( sc5mhne )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425532.lo", 0x00001, 0x080000, CRC(e402011f) SHA1(99391e096e6d3d422a0dc97259d9879b49d02326) )
	ROM_LOAD16_BYTE( "95425533.hi", 0x00000, 0x080000, CRC(c6951851) SHA1(66212e50c31c05a3ac0900d2180790055f672664) )
	sc_mhn_others
ROM_END


ROM_START( sc5mhp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422108.lo", 0x00001, 0x080000, CRC(3bf85c25) SHA1(0d73f8280c60aeaa2cb21729d4f1b449e07b7ae5) )
	ROM_LOAD16_BYTE( "95422109.hi", 0x00000, 0x080000, CRC(b695e6fc) SHA1(7988d0a1566021b49b0cb0ef980b975407c34a7c) )
	sc_mhp_others
ROM_END

ROM_START( sc5mhpa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422350.lo", 0x00001, 0x080000, CRC(a802eef0) SHA1(bc0911bdfad7e7ed47add4cf24e85a40eb827f71) )
	ROM_LOAD16_BYTE( "95422351.hi", 0x00000, 0x080000, CRC(fd5a96a9) SHA1(6ced84eca2a33dda51378835b1b01edc57d25d95) )
	sc_mhp_others
ROM_END

ROM_START( sc5mhpb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422578.lo", 0x00001, 0x080000, CRC(73d1951c) SHA1(6c72397c733dd2a440897c65b6e0523967cdad01) )
	ROM_LOAD16_BYTE( "95422579.hi", 0x00000, 0x080000, CRC(d62c27bf) SHA1(fc0df223e08893df7d5bd37bf7d4724621325e8c) )
	sc_mhp_others
ROM_END

ROM_START( sc5mhpc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423108.lo", 0x00001, 0x080000, CRC(68ae1dd9) SHA1(7d2965922a8c4a9b6585bb25b53e68f3fa0d3d75) )
	ROM_LOAD16_BYTE( "95423109.hi", 0x00000, 0x080000, CRC(f0900f32) SHA1(66937c9b588cc4fca77855ac2583f951944822d8) )
	sc_mhp_others
ROM_END

ROM_START( sc5mhpd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423350.lo", 0x00001, 0x080000, CRC(7fecf279) SHA1(c0addf49a032986ec61213fe2fefcfa0bbac828f) )
	ROM_LOAD16_BYTE( "95423351.hi", 0x00000, 0x080000, CRC(4e9325b5) SHA1(3726e0989648744226b389dde4e8689eb288b1b8) )
	sc_mhp_others
ROM_END

ROM_START( sc5mhpe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423578.lo", 0x00001, 0x080000, CRC(ff734c1a) SHA1(0773decf2aa97d33f8096421c9cc2d31fbf35ccf) )
	ROM_LOAD16_BYTE( "95423579.hi", 0x00000, 0x080000, CRC(73dd2448) SHA1(96e5c1352f3676ec9269c561ad72a59a7ca35b43) )
	sc_mhp_others
ROM_END

ROM_START( sc5mhpf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426290.lo", 0x00001, 0x080000, CRC(fd6af641) SHA1(78f08c7361cb0658548519af6703263e729b36c0) )
	ROM_LOAD16_BYTE( "95426291.hi", 0x00000, 0x080000, CRC(e519cae8) SHA1(2fcf46fe46300fd37a288abbcf3933c2087d6f4d) )
	sc_mhp_others
ROM_END

ROM_START( sc5mhpg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426504.lo", 0x00001, 0x080000, CRC(24f24564) SHA1(81c1ca3ac5968cf446119b8c6fd00881f7d3e2e3) )
	ROM_LOAD16_BYTE( "95426505.hi", 0x00000, 0x080000, CRC(14fd13b3) SHA1(7eb6e86f3b03255542a9b42ae07a4157ca0c65f2) )
	sc_mhp_others
ROM_END

ROM_START( sc5mhph )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427290.lo", 0x00001, 0x080000, CRC(5cca2853) SHA1(92f8e7ae7ffe8aacf733804cf8117ec3544dbc24) )
	ROM_LOAD16_BYTE( "95427291.hi", 0x00000, 0x080000, CRC(15e2297e) SHA1(0b588bd3fea05ab59f6af539d43d1ccb536ffa3e) )
	sc_mhp_others
ROM_END

ROM_START( sc5mhpi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427504.lo", 0x00001, 0x080000, CRC(4f8abdf7) SHA1(f9e8f96153eb14be481e0a3c9121cf0c9d49bd1a) )
	ROM_LOAD16_BYTE( "95427505.hi", 0x00000, 0x080000, CRC(94e1925c) SHA1(d7227cf4d5839cfba949cf97f024a38e922b3a03) )
	sc_mhp_others
ROM_END




ROM_START( sc5mmb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426674.lo", 0x00001, 0x080000, CRC(4e009780) SHA1(8cf7d95da7c6a22427ad5ebe1b9c23bfa6f95cc3) )
	ROM_LOAD16_BYTE( "95426675.hi", 0x00000, 0x080000, CRC(ee7f46d1) SHA1(2d48bf0f94cb0c82b68e524e3a1ce2f6e0003e63) )
	sc_mmb_others
ROM_END

ROM_START( sc5mmba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426858.lo", 0x00001, 0x080000, CRC(9dcce7dc) SHA1(aada98497549dd6ed09b40d40cf159774b7c5f1d) )
	ROM_LOAD16_BYTE( "95426859.hi", 0x00000, 0x080000, CRC(6c0b7245) SHA1(769f4a58d5c255542a80e22029b53afd1563c523) )
	sc_mmb_others
ROM_END

ROM_START( sc5mmbb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427674.lo", 0x00001, 0x080000, CRC(eeb9b80c) SHA1(bac65da1a18503bfb7c4bac6b4494cd87a80f516) )
	ROM_LOAD16_BYTE( "95427675.hi", 0x00000, 0x080000, CRC(86c56bd8) SHA1(6de0ba751777e2a9a40d3a2eaf853a8db98da001) )
	sc_mmb_others
ROM_END

ROM_START( sc5mmbc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427858.lo", 0x00001, 0x080000, CRC(9b17bdfe) SHA1(91a97ca373f404dc20580ed0f5568589e38fb5a9) )
	ROM_LOAD16_BYTE( "95427859.hi", 0x00000, 0x080000, CRC(b534464c) SHA1(0c68a25020a5dfd37e85db629540096e7ee0dd5d) )
	sc_mmb_others
ROM_END

ROM_START( sc5mmbd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1911p11.hi", 0x00000, 0x080000, CRC(2478cc2f) SHA1(218219e503f3299f83b3a09f6e947cf912f23184) )
	ROM_LOAD16_BYTE( "p1911p11.lo", 0x00001, 0x080000, CRC(e19055a0) SHA1(e4f4116bb634e6960cdf6553f5bccb017839b931) )
	sc_mmb_others
ROM_END

ROM_START( sc5mmbe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1911s11.hi", 0x00000, 0x080000, CRC(e4c6844e) SHA1(4243f9989d3d7565802ccb50c43004aaf4d40b7a) )
	ROM_LOAD16_BYTE( "p1911s11.lo", 0x00001, 0x080000, CRC(5c51fde3) SHA1(825d0bbab81f9add9850362d5779c941ec779c7e) )
	sc_mmb_others
ROM_END



ROM_START( sc5mrh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420714.lo", 0x00001, 0x080000, CRC(5c33260c) SHA1(a030666dab276bbaaa4c3c00b89d111b09fdbba4) )
	ROM_LOAD16_BYTE( "95420715.hi", 0x00000, 0x080000, CRC(5484b193) SHA1(36b5ab84e28a7978bb5f83169decce5abc0a0f00) )
	sc_mrh_others
ROM_END

ROM_START( sc5mrha )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421714.lo", 0x00001, 0x080000, CRC(ba991634) SHA1(b465109375f795a88582007d89b9c7e99e9aa17e) )
	ROM_LOAD16_BYTE( "95421715.hi", 0x00000, 0x080000, CRC(234f15a2) SHA1(a1cee0ad3ad7ae89b11edd54f3524e6852e916ab) )
	sc_mrh_others
ROM_END


ROM_START( sc5mr2r )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420770.lo", 0x00001, 0x080000, CRC(8fa276c7) SHA1(d77dc0a50646bf23c6f495f836fde6c1861ddc54) )
	ROM_LOAD16_BYTE( "95420771.hi", 0x00000, 0x080000, CRC(96c42c86) SHA1(e672b3db0f8a39d214f7cca23cca257fe962afd6) )
	sc_mr2r_others
ROM_END

ROM_START( sc5mr2ra )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421770.lo", 0x00001, 0x080000, CRC(4a98a8e2) SHA1(72f476ce32b6157db54da84a684b96ff0d6f180a) )
	ROM_LOAD16_BYTE( "95421771.hi", 0x00000, 0x080000, CRC(9b2ce058) SHA1(a724bbaf757953f3ce452bf53025dd875c33e016) )
	sc_mr2r_others
ROM_END

ROM_START( sc5mr2rb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424570.lo", 0x00001, 0x080000, CRC(b21d4863) SHA1(cb2daf306d17fe2508ab45a5b7d8f94af7343e71) )
	ROM_LOAD16_BYTE( "95424571.hi", 0x00000, 0x080000, CRC(757f8d60) SHA1(1d0918a5c34528d905e7ecf62abb1412d28b40d9) )
	sc_mr2r_others
ROM_END

ROM_START( ad5mr2r )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASE00 )
	ROM_LOAD( "39211501.bin", 0x0000, 0x6bb25b, CRC(94f73ba5) SHA1(1979b6cfd7968ad4d0c117742fafbb8b55a4e89e) )
	ROM_LOAD( "39211506.bin", 0x0000, 0x94ee0b, CRC(dee9ea83) SHA1(f66e5b63e10e0759ebb33a84d21d24d0f9452293) )
	ROM_LOAD( "39211510.bin", 0x0000, 0x94ee43, CRC(3f0124ff) SHA1(f44d4688472d8c46ce449033d7e2f1a57ea05574) )
	ROM_LOAD( "39211511.bin", 0x0000, 0x94ef97, CRC(051b150b) SHA1(6b1371d7157b69b7fdffaba6e9fa6c41912179b3) )
	ROM_LOAD( "39212506.bin", 0x0000, 0x94ee0b, CRC(aef402bb) SHA1(4d0d58339a9c51ab5a33eebf9443ac43efced01d) )
	ROM_LOAD( "39212510.bin", 0x0000, 0x94ee43, CRC(cec862b6) SHA1(b9b433218cef13d63e672f9e90649f44cf6aca72) )
	ROM_LOAD( "39212511.bin", 0x0000, 0x94ef97, CRC(5a84f20f) SHA1(62d2ea8b462b53acf9b47cf3589cbdd455b5a5ad) )
    ROM_LOAD( "39211617.bin", 0x00000, 0x1000000, CRC(89d687e8) SHA1(7086f43fdaa417e9bb54feb859af22f501c6ca52) )
	ROM_LOAD( "39212617.bin", 0x00000, 0x1000000, CRC(2191cc09) SHA1(593b6b16380821553adb377f3f4b5af28e73b2c0) )

 ROM_END


ROM_START( sc5mww )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416102.lo", 0x00001, 0x080000, CRC(c319cc0c) SHA1(e23b06c2d17b38d1d382dbfb042c5ad6ecdb26ed) )
	ROM_LOAD16_BYTE( "95416103.hi", 0x00000, 0x080000, CRC(6f550690) SHA1(d789c49de952d49153c7dd8da6f22b89fa1e0f6b) )
	sc_mww_others
ROM_END

ROM_START( sc5mwwa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416104.lo", 0x00001, 0x080000, CRC(e6ec72cd) SHA1(9f12723de1b55c7df8dfc7910c9e904f7c0a801a) )
	ROM_LOAD16_BYTE( "95416105.hi", 0x00000, 0x080000, CRC(dff1c3a7) SHA1(b2adae2cfd1b6000eb12d28def081b9327dcce97) )
	sc_mww_others
ROM_END

ROM_START( sc5mwwb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417102.lo", 0x00001, 0x080000, CRC(831cdf78) SHA1(53ad6afa40fcc4772dd494524f3b21540ccc9686) )
	ROM_LOAD16_BYTE( "95417103.hi", 0x00000, 0x080000, CRC(82b4c266) SHA1(f266dddff4bde4de1947f478c3995fa5ba5ae713) )
	sc_mww_others
ROM_END

ROM_START( sc5mwwc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417104.lo", 0x00001, 0x080000, CRC(0be18ced) SHA1(07dacb30aa629f100b7514ed4c46a0287345a324) )
	ROM_LOAD16_BYTE( "95417105.hi", 0x00000, 0x080000, CRC(bc5c665f) SHA1(a8807b90ec3b0f79bd34663d676802e48ca6491e) )
	sc_mww_others
ROM_END

ROM_START( ad5mww )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASE00 )
	ROM_LOAD( "39211269.bin", 0x0000, 0x7a0866, CRC(0fae0667) SHA1(5356149061413c71b662371aa08f616a28ddbafb) )
	ROM_LOAD( "39211270.bin", 0x0000, 0x7a097a, CRC(13cb2a2a) SHA1(f00bf3647abf0593eb0708aee103dfd42e623bef) )
ROM_END


ROM_START( sc5nmare )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3002p41.hi", 0x00000, 0x080000, CRC(89b45502) SHA1(c5e8e23f639a8f2aa6845381025b91a5a5055eba) )
	ROM_LOAD16_BYTE( "p3002p41.lo", 0x00001, 0x080000, CRC(46a9ba39) SHA1(5cb404da937fd68febf311d9e2f3f5011dc476f5) )
	sc_nmare_others
ROM_END

ROM_START( sc5nmarea )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3002p42.hi", 0x00000, 0x080000, CRC(61ba58db) SHA1(6994b71b580c1797dc297cb12e5748913973c7f3) )
	ROM_LOAD16_BYTE( "p3002p42.lo", 0x00001, 0x080000, CRC(2e0c5ada) SHA1(11c1f77ab61adec2341cdc88da1636cf7539e64c) )
	sc_nmare_others
ROM_END

ROM_START( sc5nmareb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3002s41.hi", 0x00000, 0x080000, CRC(6f3dc856) SHA1(b4d3f7d3ac58b2935a9a35e6f963b307e6747af7) )
	ROM_LOAD16_BYTE( "p3002s41.lo", 0x00001, 0x080000, CRC(0d5939f3) SHA1(344d309405d5356c7f3acbffc4ea0605b9b566b3) )
	sc_nmare_others
ROM_END

ROM_START( sc5nmarec )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3002s42.hi", 0x00000, 0x080000, CRC(fe60eb5c) SHA1(5e882ffcc7fde96ad6a680fe8c09f828d8a007fc) )
	ROM_LOAD16_BYTE( "p3002s42.lo", 0x00001, 0x080000, CRC(31ad3c43) SHA1(83d6c998142b64ee10fff7d6560af11b060fe525) )
	sc_nmare_others
ROM_END



ROM_START( sc5potp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412720.lo", 0x00001, 0x080000, CRC(d51f9f14) SHA1(2ef9e9458a9030a2c3bc172b6bc6bbf343e702c9) )
	ROM_LOAD16_BYTE( "95412721.hi", 0x00000, 0x080000, CRC(d67679f5) SHA1(0f723214a5c53227a7a0e2de85c01d9f1f54c8a0) )
	sc_potp_others
ROM_END

ROM_START( sc5potpa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413720.lo", 0x00001, 0x080000, CRC(7f47c7cd) SHA1(1f133bcf13f3cf4ce8d7916f44e72af107cd7b11) )
	ROM_LOAD16_BYTE( "95413721.hi", 0x00000, 0x080000, CRC(e93f0aef) SHA1(0ddcc3a7e748c1b162dbd683c40b62bd8baa28c3) )
	sc_potp_others
ROM_END


ROM_START( sc5pp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416520.lo", 0x00001, 0x080000, CRC(82217da7) SHA1(1df7dcd4f15ef32cdaba3fa13fc9c46682de9bb5) )
	ROM_LOAD16_BYTE( "95416521.hi", 0x00000, 0x080000, CRC(d8ddcaed) SHA1(c10339a165b540ae4cecaf3d88965242ed5fddfa) )
	sc_pp_others
ROM_END

ROM_START( sc5ppa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420094.lo", 0x00001, 0x080000, CRC(12c9c9ef) SHA1(ef62abad003f1f037f096213c1f216e0f1b06e13) )
	ROM_LOAD16_BYTE( "95420095.hi", 0x00000, 0x080000, CRC(71137836) SHA1(438d5e7bb1ae21a99086e95fda441329ef785f19) )
	sc_pp_others
ROM_END

ROM_START( sc5ppb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420098.lo", 0x00001, 0x080000, CRC(b5803419) SHA1(68f1752d8fc4b99e9c9f81212f9a374a8bc08531) )
	ROM_LOAD16_BYTE( "95420099.hi", 0x00000, 0x080000, CRC(fd8a979c) SHA1(e922886fac70f4af1c31161a61b7164d4ec31a68) )
	sc_pp_others
ROM_END

ROM_START( sc5ppc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420180.lo", 0x00001, 0x080000, CRC(519fd41a) SHA1(288261243c0350290f01225c29ecf405b6c50f5f) )
	ROM_LOAD16_BYTE( "95420181.hi", 0x00000, 0x080000, CRC(9888d297) SHA1(abeef73fbd887b5b001de016a003f5b8c71ebc34) )
	sc_pp_others
ROM_END

ROM_START( sc5ppd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421094.lo", 0x00001, 0x080000, CRC(92c46cb0) SHA1(accd8976632386f3dbf779cf90f57e6c340a147d) )
	ROM_LOAD16_BYTE( "95421095.hi", 0x00000, 0x080000, CRC(13edda42) SHA1(fb82700f46802356b884768dd2f3fa1b3e2b2718) )
	sc_pp_others
ROM_END

ROM_START( sc5ppe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421096.lo", 0x00001, 0x080000, CRC(6c6a7030) SHA1(cf197e300a16d7e22fceb56440efcc32c6b234bd) )
	ROM_LOAD16_BYTE( "95421097.hi", 0x00000, 0x080000, CRC(9e64dd46) SHA1(82b719066d430b2c2249db11f909504165a5462f) )
	sc_pp_others
ROM_END

ROM_START( sc5ppf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421098.lo", 0x00001, 0x080000, CRC(db67d892) SHA1(f09ad9f53af922dedceba30e293e2350d770d3e8) )
	ROM_LOAD16_BYTE( "95421099.hi", 0x00000, 0x080000, CRC(2c5d0216) SHA1(f3948ff75e55ea72a3ee949ffcbc0914342099e0) )
	sc_pp_others
ROM_END

ROM_START( sc5ppg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421180.lo", 0x00001, 0x080000, CRC(3f783891) SHA1(cfcf1c4c0a7a1e8f1d49cabb8ffd9c6a901d5789) )
	ROM_LOAD16_BYTE( "95421181.hi", 0x00000, 0x080000, CRC(495f471d) SHA1(cc3e320986eda11d41d8932e63a4c90331c51984) )
	sc_pp_others
ROM_END


ROM_START( ad5pp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASE00 )
	ROM_LOAD( "39211267.bin", 0x0000, 0xb071f3, CRC(51d49618) SHA1(0053ecf1b2d2ad20444f05daf80138d4c8c0c885) )
	ROM_LOAD( "39211268.bin", 0x0000, 0xb08064, CRC(9d8248f4) SHA1(b20b682fa0e058e39608e4b54ced3eec56c4ec08) )
	ROM_LOAD( "39211279.bin", 0x0000, 0xc0da36, CRC(dfa112e8) SHA1(1097e0bf7a49b75ebe04a92d2c3794993ec73c41) )
	ROM_LOAD( "39211280.bin", 0x0000, 0xc0e902, CRC(7c52816b) SHA1(1a5552893dcd91a1928d0526ce5ecaaac0f7f29b) )
	ROM_LOAD( "39211281.bin", 0x0000, 0x43a386, CRC(a429eb90) SHA1(2374ebff3fc5ab1780a82454bcb4856c97492781) )
	ROM_LOAD( "39211321.bin", 0x0000, 0x43a9d4, CRC(6e1b8538) SHA1(04504ceff81f2350cc090eabfd2f53a70b4d647f) )
	ROM_LOAD( "39212267.bin", 0x0000, 0xb071f3, CRC(fcfaac08) SHA1(08aab0b6525ca3f30c3fe849641f5afe9dfa3db3) )
	ROM_LOAD( "39212268.bin", 0x0000, 0xb08064, CRC(9882907c) SHA1(5ab2fa1b999f6e5d27207e64a9445476df7582cf) )
	ROM_LOAD( "39212280.bin", 0x0000, 0xc0e902, CRC(f10abe2b) SHA1(9af09874f16e957906bef69d5377c0c744d337de) )
	ROM_LOAD( "39212281.bin", 0x0000, 0x43a386, CRC(9b460cee) SHA1(54b561e9afc3cf325c82f9c105698d026daa769c) )
	ROM_LOAD( "39212321.bin", 0x0000, 0x43a9d4, CRC(7bdfaeea) SHA1(652cb88ba6f2ecc1bcc98a2581aa3e4c65ba757b) )
ROM_END


ROM_START( sc5ppcr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416698.lo", 0x00001, 0x080000, CRC(9fd536c7) SHA1(fb778f1a92656aca4061a40cb427db1d6c66d7e7) )
	ROM_LOAD16_BYTE( "95416699.hi", 0x00000, 0x080000, CRC(247da932) SHA1(0955ffed8ed1caed6cfa67905244ef2ac312ba60) )
	sc_ppcr_others
ROM_END

ROM_START( sc5ppcra )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416700.lo", 0x00001, 0x080000, CRC(4fb2c37a) SHA1(963fe4116504a1bd6c1f95526a26050d9b66744f) )
	ROM_LOAD16_BYTE( "95416701.hi", 0x00000, 0x080000, CRC(aca4c3c5) SHA1(eec31ce0a1ddec520dcfca9af1f8eeeabc94bde4) )
	sc_ppcr_others
ROM_END

ROM_START( sc5ppcrb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416724.lo", 0x00001, 0x080000, CRC(65cd7765) SHA1(8f97eeefabdfdbc8106202a7bbbe2bf3f7ce888c) )
	ROM_LOAD16_BYTE( "95416725.hi", 0x00000, 0x080000, CRC(852a0886) SHA1(c1292aff6cbb1a56ae6594f44920fc2d8af0a044) )
	sc_ppcr_others
ROM_END

ROM_START( sc5ppcrc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417698.lo", 0x00001, 0x080000, CRC(7848b042) SHA1(bc3afbc7891b19b450116a55f417897c2d6e8a18) )
	ROM_LOAD16_BYTE( "95417699.hi", 0x00000, 0x080000, CRC(3e0979b1) SHA1(c541961d41d0289a6650363a5d8939d8d7c6ca88) )
	sc_ppcr_others
ROM_END

ROM_START( sc5ppcrd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417724.lo", 0x00001, 0x080000, CRC(40ba241d) SHA1(960dc1058b828f02a7fc07acf63be987c9497cbc) )
	ROM_LOAD16_BYTE( "95417725.hi", 0x00000, 0x080000, CRC(f8525222) SHA1(ab795042a46f84cad59e9f454ee145c0d49418df) )
	sc_ppcr_others
ROM_END



ROM_START( sc5ppctc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422464.lo", 0x00001, 0x080000, CRC(0ba5370e) SHA1(37b54888de5a966f03f6656ca7b49fd8dd019e26) )
	ROM_LOAD16_BYTE( "95422465.hi", 0x00000, 0x080000, CRC(f17bd040) SHA1(2c2db2f50530fe8f31f763f53a1b324ad1dffce5) )
	sc_ppctc_others
ROM_END

ROM_START( sc5ppctca )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422690.lo", 0x00001, 0x080000, CRC(4d2fb15d) SHA1(bf0a5a2148ab22427721473748115c2eab62778b) )
	ROM_LOAD16_BYTE( "95422691.hi", 0x00000, 0x080000, CRC(bf0ca534) SHA1(640a462b40429e67eb4f91b929709a5b5189841b) )
	sc_ppctc_others
ROM_END

ROM_START( sc5ppctcb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423464.lo", 0x00001, 0x080000, CRC(a8a14b06) SHA1(4bb2579e92ed2a5ed8457d63ac64236201076dd1) )
	ROM_LOAD16_BYTE( "95423465.hi", 0x00000, 0x080000, CRC(2c6a4641) SHA1(94d5e7629b5dc35258983538933e1353eb374673) )
	sc_ppctc_others
ROM_END

ROM_START( sc5ppctcc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426126.lo", 0x00001, 0x080000, CRC(e9fc5d74) SHA1(73f4f8ca4cd0bfa75d6b8220de6dabe94ecc3ce5) )
	ROM_LOAD16_BYTE( "95426127.hi", 0x00000, 0x080000, CRC(60fd3c5b) SHA1(dd983b8b562cac1fd985e8024a7c468488c907a2) )
	sc_ppctc_others
ROM_END

ROM_START( sc5ppctcd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426266.lo", 0x00001, 0x080000, CRC(16ea49d3) SHA1(ebd48cecaf1ed697290b11a3b57c152e1c77b75d) )
	ROM_LOAD16_BYTE( "95426267.hi", 0x00000, 0x080000, CRC(d299bd7c) SHA1(2b5900391478628b4b479d44e877f0d164089116) )
	sc_ppctc_others
ROM_END

ROM_START( sc5ppctce )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426434.lo", 0x00001, 0x080000, CRC(37352ee1) SHA1(3e238ca82bbcf6fb75d5f3bc94f9d2c623076ee1) )
	ROM_LOAD16_BYTE( "95426435.hi", 0x00000, 0x080000, CRC(810defdc) SHA1(5e7b2cfaebba7042ec2937a899c64f17ab599a2b) )
	sc_ppctc_others
ROM_END

ROM_START( sc5ppctcf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427126.lo", 0x00001, 0x080000, CRC(6663ebf4) SHA1(fae1c2eee4da774fbc9dd5ffc3e724e8af735810) )
	ROM_LOAD16_BYTE( "95427127.hi", 0x00000, 0x080000, CRC(dfe36f86) SHA1(86c1df753344826fa54249e6810765a12dd8e2ff) )
	sc_ppctc_others
ROM_END

ROM_START( sc5ppctcg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427266.lo", 0x00001, 0x080000, CRC(4b5f4373) SHA1(77523f5cd56842616e1283a26af3c4201b338eed) )
	ROM_LOAD16_BYTE( "95427267.hi", 0x00000, 0x080000, CRC(3cc3d99c) SHA1(c28fb51cb3f254c3f8c78b57b923d5a34368ef13) )
	sc_ppctc_others
ROM_END

ROM_START( sc5ppctch )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427434.lo", 0x00001, 0x080000, CRC(1345ed9f) SHA1(482578d3ae071700d74b795ecb7d4c07f2f19992) )
	ROM_LOAD16_BYTE( "95427435.hi", 0x00000, 0x080000, CRC(025eef01) SHA1(186fe5136d787cbab233c515cae905a0a50c3d61) )
	sc_ppctc_others
ROM_END




ROM_START( sc5ppdym )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420184.lo", 0x00001, 0x080000, CRC(4fabac48) SHA1(726375dfcd6ae398cc8f0e881397eb0725cd9dfe) )
	ROM_LOAD16_BYTE( "95420185.hi", 0x00000, 0x080000, CRC(9b633133) SHA1(98407648c17234d618b7043dbd98c8366c68ac01) )
	sc_ppdym_others
ROM_END

ROM_START( sc5ppdyma )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421184.lo", 0x00001, 0x080000, CRC(d7534170) SHA1(a7f85af72642070f113f1d54cc67dc25ab15f882) )
	ROM_LOAD16_BYTE( "95421185.hi", 0x00000, 0x080000, CRC(fd29bd92) SHA1(3ce5999dddc3492402d5d1f45a4f020dbbc8645c) )
	sc_ppdym_others
ROM_END



ROM_START( sc5ppsag )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416850.lo", 0x00001, 0x080000, CRC(aae094f5) SHA1(cc52856f2e4e408efa87512eb2d6e48a3d73bf18) )
	ROM_LOAD16_BYTE( "95416851.hi", 0x00000, 0x080000, CRC(e2e5b214) SHA1(ee0944deb1b6a4157d79b78432af562147dbab45) )
	sc_ppsag_others
ROM_END

ROM_START( sc5ppsaga )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417850.lo", 0x00001, 0x080000, CRC(e35588b6) SHA1(c8aaa985046c8b3ade60eabc829a93526574385d) )
	ROM_LOAD16_BYTE( "95417851.hi", 0x00000, 0x080000, CRC(2fc88c61) SHA1(03474d91ae0f8e1ce5ef2ec18c82c84c7df32cb0) )
	sc_ppsag_others
ROM_END

ROM_START( sc5ppsagb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420650.lo", 0x00001, 0x080000, CRC(f9909656) SHA1(f1ba1eb0e4bd9dd2c78989d4af4ad5a14f205fd3) )
	ROM_LOAD16_BYTE( "95420651.hi", 0x00000, 0x080000, CRC(0027e675) SHA1(c0adc5d429b5585419d5c73dbca341358873c52a) )
	sc_ppsag_others
ROM_END

ROM_START( sc5ppsagc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420656.lo", 0x00001, 0x080000, CRC(a9f86751) SHA1(342ac92cde5655d4c542022629c7800bc81b1d7d) )
	ROM_LOAD16_BYTE( "95420657.hi", 0x00000, 0x080000, CRC(672112b3) SHA1(7e829e730eef6fdff56231186207b45802f23718) )
	sc_ppsag_others
ROM_END

ROM_START( sc5ppsagd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421650.lo", 0x00001, 0x080000, CRC(0ff59c56) SHA1(96b39ae9c10f15c3a43f03c7f12a4ac500ea0fdd) )
	ROM_LOAD16_BYTE( "95421651.hi", 0x00000, 0x080000, CRC(9247e99e) SHA1(c14b23d56baec2e1732d7d2c9017e206dd672bb0) )
	sc_ppsag_others
ROM_END

ROM_START( sc5ppsage )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421656.lo", 0x00001, 0x080000, CRC(45398da6) SHA1(af6952b9a5d3227b7a0a4cbffb28300bf1382b70) )
	ROM_LOAD16_BYTE( "95421657.hi", 0x00000, 0x080000, CRC(1d6c679b) SHA1(3e472ec667b5be18d2c9a60bcd7332b07ab36804) )
	sc_ppsag_others
ROM_END



ROM_START( sc5pony )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410818.lo", 0x00001, 0x080000, CRC(f32862a6) SHA1(25014beb93fc8fa71a060d1a1147e3633ae7a975) )
	ROM_LOAD16_BYTE( "95410819.hi", 0x00000, 0x080000, CRC(0a181038) SHA1(616ec4ae6b6371b39e443ac14a98c3ed432b85cc) )
	sc_pony_others
ROM_END

ROM_START( sc5ponya )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410820.lo", 0x00001, 0x080000, CRC(717559ad) SHA1(4748ab9dd5b48b24abf906cf3a66621ba9da9a70) )
	ROM_LOAD16_BYTE( "95410821.hi", 0x00000, 0x080000, CRC(64f25da0) SHA1(5472714e8caafb743e84d3e4bfd6050fe84dcbed) )
	sc_pony_others
ROM_END

ROM_START( sc5ponyb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411818.lo", 0x00001, 0x080000, CRC(1216e85c) SHA1(e75b0ff8c77c83fc4d554a83421c2e5abaf8231b) )
	ROM_LOAD16_BYTE( "95411819.hi", 0x00000, 0x080000, CRC(93f39632) SHA1(18e1fe98a5a1300f161606683e63562d30d4be1c) )
	sc_pony_others
ROM_END

ROM_START( sc5ponyc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412572.lo", 0x00001, 0x080000, CRC(b73917fc) SHA1(215e1b312bd31daf9b5240263749d2a9ad10b397) )
	ROM_LOAD16_BYTE( "95412573.hi", 0x00000, 0x080000, CRC(e05230c7) SHA1(d5b7687f3c8cf854fd882db3f7dee6085503e092) )
	sc_pony_others
ROM_END

ROM_START( sc5ponyd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413572.lo", 0x00001, 0x080000, CRC(ab9b41f7) SHA1(7d5af49807722755be5dbc7bad6e39094157bf65) )
	ROM_LOAD16_BYTE( "95413573.hi", 0x00000, 0x080000, CRC(e8197256) SHA1(e61b601a4969aa29a6fc9e1099a3293bfa5f1741) )
	sc_pony_others
ROM_END


ROM_START( sc5popey )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422942.lo", 0x00001, 0x080000, CRC(7a6e1be3) SHA1(d57281ca12ca9ff1b7bb3c6fa10d2f42bef93ffd) )
	ROM_LOAD16_BYTE( "95422943.hi", 0x00000, 0x080000, CRC(ca6a8fa6) SHA1(2d0ca03086fadb467f7886ab9a1ab4c240f18bf7) )
	sc_popey_others
ROM_END

ROM_START( sc5popeya )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423942.lo", 0x00001, 0x080000, CRC(0ec64fe9) SHA1(450f5deb83968b3a02ea65f919c767eb9e66346a) )
	ROM_LOAD16_BYTE( "95423943.hi", 0x00000, 0x080000, CRC(2af8755b) SHA1(d0ae0805cadf28c75dbad9e352c3d0c0189b2b2e) )
	sc_popey_others
ROM_END

ROM_START( sc5popeyb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426390.lo", 0x00001, 0x080000, CRC(8f002e83) SHA1(7d20c51ffcb0cfb98109e85aee77dd55c9ede039) )
	ROM_LOAD16_BYTE( "95426391.hi", 0x00000, 0x080000, CRC(280060b2) SHA1(7b602b482e5ba0d567a632653223cc7ce2ca05d5) )
	sc_popey_others
ROM_END

ROM_START( sc5popeyc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427390.lo", 0x00001, 0x080000, CRC(feb87ed6) SHA1(214c5f6e488cd428ca39c548affb339a31b85998) )
	ROM_LOAD16_BYTE( "95427391.hi", 0x00000, 0x080000, CRC(e9b15649) SHA1(48475a6547d33d876abfd10794850c313e8e7f27) )
	sc_popey_others
ROM_END



ROM_START( sc5pog )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418746.lo", 0x00001, 0x080000, CRC(6ec2f94f) SHA1(6ea688cc7c69c0a50ba59cd1e3c55a67f4b8b980) )
	ROM_LOAD16_BYTE( "95418747.hi", 0x00000, 0x080000, CRC(899d9f95) SHA1(170803aec2875223424a09326d74a335b2a1efa6) )
	PR1918_POTS_OF_GOLD_SOUNDS11
ROM_END

ROM_START( sc5poga )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419746.lo", 0x00001, 0x080000, CRC(fde32cb2) SHA1(2627f19e787cd9f88d53e3dab6cfd5809912e39c) )
	ROM_LOAD16_BYTE( "95419747.hi", 0x00000, 0x080000, CRC(2dd74466) SHA1(023af3659bbb31856364e33de1b3a03579248310) )
	PR1918_POTS_OF_GOLD_SOUNDS11
ROM_END

ROM_START( sc5pogb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422096.lo", 0x00001, 0x080000, CRC(634b915f) SHA1(a64fa41d97d209774e403650e75f02039c714050) )
	ROM_LOAD16_BYTE( "95422097.hi", 0x00000, 0x080000, CRC(393eeb18) SHA1(a73ddeaad545fc72e7bb970cc5884837df991412) )
	PR1918_POTS_OF_GOLD_SOUNDS11
ROM_END

ROM_START( sc5pogc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423096.lo", 0x00000, 0x080000, NO_DUMP )
	ROM_LOAD16_BYTE( "95423097.hi", 0x00000, 0x080000, CRC(6c02b85d) SHA1(be8c898788cc826812a16eece855ce3f21cb1740) )
	PR1918_POTS_OF_GOLD_SOUNDS11
ROM_END

ROM_START( sc5pogd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1918p42.hi", 0x00000, 0x080000, CRC(9e0c7ebc) SHA1(e81fd6dbb13a25afde4849e54b0f71c0f6a83ad7) )
	ROM_LOAD16_BYTE( "p1918p42.lo", 0x00001, 0x080000, CRC(330226ed) SHA1(001953a954c73d380d772a3779f104c1dd277505) )
	PR1918_POTS_OF_GOLD_SOUNDS11
ROM_END

ROM_START( sc5poge )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1918s42.hi", 0x00000, 0x080000, CRC(30780d72) SHA1(6731996c6f2addf70d9abae828853dde85df4585) )
	ROM_LOAD16_BYTE( "p1918s42.lo", 0x00001, 0x080000, CRC(b9829456) SHA1(5c5f250857cc2f96f8e1761402bd46e05df0b549) )
	PR1918_POTS_OF_GOLD_SOUNDS11
ROM_END


ROM_START( sc5potog )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426442.lo", 0x00001, 0x080000, CRC(021dbcd3) SHA1(129c49001c9fb87277b1da0fe997822cd68d6833) )
	ROM_LOAD16_BYTE( "95426443.hi", 0x00000, 0x080000, CRC(974f325d) SHA1(790efeff7b7a3f72a1cf1235771a7757cf844676) )
	PR000050_POTOFGLD_1
ROM_END

ROM_START( sc5potoga )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427442.lo", 0x00001, 0x080000, CRC(a461d588) SHA1(93fb5c6b145e5b4291ef3720fad5d527d27ebbda) )
	ROM_LOAD16_BYTE( "95427443.hi", 0x00000, 0x080000, CRC(f3bcb341) SHA1(0bbfb2d661c99a9dbc5547e73c775b6e1a7cb8b5) )
	PR000050_POTOFGLD_1
ROM_END

ROM_START( sc5potogb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95426376.lo", 0x00001, 0x080000, CRC(9f6b3222) SHA1(044065bfa7f68474351f08c9e1535bd4a590d258) )
	ROM_LOAD16_BYTE( "g95426377.hi", 0x00000, 0x080000, CRC(02d55db3) SHA1(20e23360cebef9bc93ee2cc21d5851ffddf97e22) )
	PR000050_POTOFGLD_1
ROM_END

ROM_START( sc5potogc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95426574.lo", 0x00001, 0x080000, CRC(2713029a) SHA1(255162dff74f9a68c91b5e3f08423d27b078ebcd) )
	ROM_LOAD16_BYTE( "g95426575.hi", 0x00000, 0x080000, CRC(3e12bf73) SHA1(00419f72131e341a350056f06e12eddfa3a93dca) )
	PR000050_POTOFGLD_1
ROM_END

ROM_START( sc5potogd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95426622.lo", 0x00001, 0x080000, CRC(fbc0286a) SHA1(0b9b1fef673fac90357799c54aa9b51a0bb97086) )
	ROM_LOAD16_BYTE( "g95426623.hi", 0x00000, 0x080000, CRC(778fbd39) SHA1(b7087cba148d8b1f700a765f6556c48d08c00a4e) )
	PR000050_POTOFGLD_1
ROM_END

ROM_START( sc5potoge )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95427376.lo", 0x00001, 0x080000, CRC(932ba997) SHA1(07247a44c79e7afbe9de887c29051fbbf0a34ed3) )
	ROM_LOAD16_BYTE( "g95427377.hi", 0x00000, 0x080000, CRC(154e6413) SHA1(2e3d73ffe1f080ce7e223ed31c11242cdb48c5a5) )
	PR000050_POTOFGLD_1
ROM_END

ROM_START( sc5potogf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95427574.lo", 0x00001, 0x080000, CRC(8c1b9871) SHA1(2e2e02c911e45f71a363ffe85f05d76058cc7049) )
	ROM_LOAD16_BYTE( "g95427575.hi", 0x00000, 0x080000, CRC(e0929b71) SHA1(85d0c52e53e5a414426da91b1d6496a750e519c1) )
	PR000050_POTOFGLD_1
ROM_END

ROM_START( sc5potogg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "g95427622.lo", 0x00001, 0x080000, CRC(c0629d24) SHA1(8077566d177a5b77d591fca916d7a860854e21f0) )
	ROM_LOAD16_BYTE( "g95427623.hi", 0x00000, 0x080000, CRC(993cea6e) SHA1(94030b5062e31c32a08421ce0420af11227a9bd8) )
	PR000050_POTOFGLD_1
ROM_END




ROM_START( sc5pwrpl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416764.lo", 0x00001, 0x080000, CRC(2565da29) SHA1(a12f7479f112fcdbccf9814ba403ac2382fd2010) )
	ROM_LOAD16_BYTE( "95416765.hi", 0x00000, 0x080000, CRC(bcf9b9af) SHA1(dd442f37c1e76de90eac23539f300465054e7f60) )
	sc_pwrpl_others
ROM_END

ROM_START( sc5pwrpla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417764.lo", 0x00001, 0x080000, CRC(0a527024) SHA1(9870841fc4c6d8ad236cc721d0a04853a9626a6a) )
	ROM_LOAD16_BYTE( "95417765.hi", 0x00000, 0x080000, CRC(e5de2f39) SHA1(9420ee35da44bebdf14a1d62e22a0e66f71449f8) )
	sc_pwrpl_others
ROM_END


ROM_START( sc5pwrbl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412926.lo", 0x00001, 0x080000, CRC(4edb4645) SHA1(a2eeab7c922e855ac570da59ff1c14946a9dd2b5) )
	ROM_LOAD16_BYTE( "95412927.hi", 0x00000, 0x080000, CRC(fca5a985) SHA1(0631df75cd07a328a255e012159b9330930bc031) )
	sc_pwrbl_others
ROM_END


ROM_START( sc5pwrbla )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413926.lo", 0x00001, 0x080000, CRC(391f3610) SHA1(ef73ccd1fcd15284aa721bb3bbba40d8d3fcf64b) )
	ROM_LOAD16_BYTE( "95413927.hi", 0x00000, 0x080000, CRC(b476f6f1) SHA1(b5d4eab67e61d551b7b6fa5dc12e4fadb25db1f2) )
	sc_pwrbl_others
ROM_END


ROM_START( sc5quidv )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420788.lo", 0x00001, 0x080000, CRC(fdfb704b) SHA1(19e71d2650e824e16c2d42bb0c68a98b7bd81d2e) )
	ROM_LOAD16_BYTE( "95420789.hi", 0x00000, 0x080000, CRC(f325013c) SHA1(ea601e27f5c61110b8cf669e206db289b4731521) )
	sc_quidv_others
ROM_END

ROM_START( sc5quidva )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421788.lo", 0x00001, 0x080000, CRC(64610205) SHA1(bd9ce6e6e6060db22ec049a042354a986eb9cdfc) )
	ROM_LOAD16_BYTE( "95421789.hi", 0x00000, 0x080000, CRC(ae1900b6) SHA1(6c868810ea0510d7de40fe0129c72f1d7e42aff9) )
	sc_quidv_others
ROM_END

ROM_START( sc5quidvb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424490.lo", 0x00001, 0x080000, CRC(6f94b7de) SHA1(3dafcd2046b12e4c74bbb281c860476f01ed90c8) )
	ROM_LOAD16_BYTE( "95424491.hi", 0x00000, 0x080000, CRC(8f5507f7) SHA1(41678c4346784b3e4badb05eabcaa5a0561a7e6f) )
	sc_quidv_others
ROM_END

ROM_START( sc5quidvc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424564.lo", 0x00001, 0x080000, CRC(7d26ebca) SHA1(c63ba51e924cf61bf81a52fe3fa403ff681a6259) )
	ROM_LOAD16_BYTE( "95424565.hi", 0x00000, 0x080000, CRC(52436e90) SHA1(a37e3b956bacff1e7c2a4688904202f34c120929) )
	sc_quidv_others
ROM_END

ROM_START( sc5quidvd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95424652.lo", 0x00001, 0x080000, CRC(6ca57650) SHA1(29e183d47fe80f9e051049189a294c217b93f78e) )
	ROM_LOAD16_BYTE( "95424653.hi", 0x00000, 0x080000, CRC(01518c58) SHA1(531e3b689b87b1f0eb888e2224d58b91ed266e07) )
	sc_quidv_others
ROM_END

ROM_START( sc5quidve )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425490.lo", 0x00001, 0x080000, CRC(83c0c0c7) SHA1(30d03ab7e1c893ab96b6ddc3153141803e4193dc) )
	ROM_LOAD16_BYTE( "95425491.hi", 0x00000, 0x080000, CRC(d2497dc6) SHA1(787ca5debf6f823234862c68e1685e8f2ef74ac2) )
	sc_quidv_others
ROM_END

ROM_START( sc5quidvf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425564.lo", 0x00001, 0x080000, CRC(53eb62d1) SHA1(a619211efadcbec74db9751ca3d0f10254ebc2a6) )
	ROM_LOAD16_BYTE( "95425565.hi", 0x00000, 0x080000, CRC(f37b0c31) SHA1(c1a3f7841f226180c6743b03904139a9dd250a1d) )
	sc_quidv_others
ROM_END

ROM_START( sc5quidvg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95425652.lo", 0x00001, 0x080000, CRC(a99e0bed) SHA1(8082362471da6890d1b3f47006e1fe9e1bc10270) )
	ROM_LOAD16_BYTE( "95425653.hi", 0x00000, 0x080000, CRC(760f55cf) SHA1(d72c60ac5d2cc3dcd611509b2003c54cb33782bc) )
	sc_quidv_others
ROM_END

ROM_START( sc5rhx )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408654.lo", 0x00001, 0x080000, CRC(99972de1) SHA1(ae30fd6b32ef13542fa6e3bc3f565ce5395877de) )
	ROM_LOAD16_BYTE( "95408655.hi", 0x00000, 0x080000, CRC(dc5bd5fb) SHA1(f7e994a2416b01304e75f25609c75e164b347620) )
	sc_rhx_others
ROM_END

ROM_START( sc5rhxa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410078.lo", 0x00001, 0x080000, CRC(0c148324) SHA1(7110b5467601aac4551188ec0a1c9caee1c97692) )
	ROM_LOAD16_BYTE( "95410079.hi", 0x00000, 0x080000, CRC(1cb3de28) SHA1(fe0b9fb4db18b3e98480b46b14ca37b7dae013c6) )
	sc_rhx_others
ROM_END

ROM_START( sc5rhxb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410126.lo", 0x00001, 0x080000, CRC(1ddc4a15) SHA1(6391efb041dba04fa5eb8f0474cc9b90dd5e52e4) )
	ROM_LOAD16_BYTE( "95410127.hi", 0x00000, 0x080000, CRC(4bb4ea72) SHA1(de5ca8394ce36ae4866da67cbc37ea91df4fbe6c) )
	sc_rhx_others
ROM_END

ROM_START( sc5rhxc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411078.lo", 0x00001, 0x080000, CRC(1b8a607f) SHA1(977353289c673470203e6bdd2623a597eb6018e4) )
	ROM_LOAD16_BYTE( "95411079.hi", 0x00000, 0x080000, CRC(ce90ea81) SHA1(39a6f733d93fe19a829424d68e087f89c10e6c2d) )
	sc_rhx_others
ROM_END

ROM_START( sc5rhxd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411082.lo", 0x00001, 0x080000, CRC(81e37de1) SHA1(a7332a4ce1156a2aaf6c100268607e94fce524fa) )
	ROM_LOAD16_BYTE( "95411083.hi", 0x00000, 0x080000, CRC(8e51bd5e) SHA1(3f91ea8b6140c83cda41a5ccedd2b5398737a41c) )
	sc_rhx_others
ROM_END

ROM_START( sc5rhxe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411084.lo", 0x00001, 0x080000, CRC(9357b033) SHA1(db9dd0391422ea1bf57e03b9a95d2333cccc1b50) )
	ROM_LOAD16_BYTE( "95411085.hi", 0x00000, 0x080000, CRC(41a7f320) SHA1(2d3b3adf880ac01dd99b155d12287f162168225b) )
	sc_rhx_others
ROM_END

ROM_START( sc5rhxf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411126.lo", 0x00001, 0x080000, CRC(516cb51a) SHA1(609e62dd2d896ca979e3d29b0f1e9a762e6d3464) )
	ROM_LOAD16_BYTE( "95411127.hi", 0x00000, 0x080000, CRC(f517a8db) SHA1(c01460d8bc427b963310ef9c877c882556ad7aef) )
	sc_rhx_others
ROM_END


ROM_START( sc5rhxcs )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420716.lo", 0x00001, 0x080000, CRC(a713a289) SHA1(327b2e3e0313582743061685638d70846ccf711a) )
	ROM_LOAD16_BYTE( "95420717.hi", 0x00000, 0x080000, CRC(a3c88ba3) SHA1(af5c4931f133dccebd8d2ec9be6e74eba707f3ee) )
	sc_rhxcs_others
ROM_END

ROM_START( sc5rhxcsa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421716.lo", 0x00001, 0x080000, CRC(302719b9) SHA1(3e9df6d227a901c4f19028cd8e4b6fa640209ac5) )
	ROM_LOAD16_BYTE( "95421717.hi", 0x00000, 0x080000, CRC(3b022f78) SHA1(bb1798468fe99c269712bc06bff8613ae03c81e7) )
	sc_rhxcs_others
ROM_END


ROM_START( sc5redsq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416590.lo", 0x00001, 0x080000, CRC(4d08d688) SHA1(fe9e65553d9e8df7231c9a959b4a7c9f05de1e01) )
	ROM_LOAD16_BYTE( "95416591.hi", 0x00000, 0x080000, CRC(0d4d40fc) SHA1(1e671db1f035117a57f96b5c8343f602501f5ba9) )
	sc_redsq_others
ROM_END

ROM_START( sc5redsqa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417590.lo", 0x00001, 0x080000, CRC(2c7c829c) SHA1(d540309dfea5240316c0d10e410d5cf7f9e0b9c5) )
	ROM_LOAD16_BYTE( "95417591.hi", 0x00000, 0x080000, CRC(52b4ca1d) SHA1(0a86824ebde3d9b33a2cd58a81b9232bde76bfd4) )
	sc_redsq_others
ROM_END


ROM_START( sc5rosts )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426024.lo", 0x00001, 0x080000, CRC(344ae121) SHA1(3b6b24492ba0e7d22adb9a8b152ebc61b433af17) )
	ROM_LOAD16_BYTE( "95426025.hi", 0x00000, 0x080000, CRC(543eb055) SHA1(8468395c2a805751cfd8d67f9a124ede4bca269e) )
	sc_rosts_others
ROM_END

ROM_START( sc5rostsa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426242.lo", 0x00001, 0x080000, CRC(8e98e510) SHA1(2f122ff8b329542376153c43d1cabc2d5a221edf) )
	ROM_LOAD16_BYTE( "95426243.hi", 0x00000, 0x080000, CRC(652dd45c) SHA1(3618fe3f2dc28d05b24a40ee75409a114833f07b) )
	sc_rosts_others
ROM_END

ROM_START( sc5rostsb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426480.lo", 0x00001, 0x080000, CRC(f9b6864d) SHA1(cc9e91391e7aea6c11e7d5a544030ccc7fbbafbe) )
	ROM_LOAD16_BYTE( "95426481.hi", 0x00000, 0x080000, CRC(2f8f519a) SHA1(d8b3c255e1dc490ae7edd0add77b3d752591c39b) )
	sc_rosts_others
ROM_END

ROM_START( sc5rostsc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427024.lo", 0x00001, 0x080000, CRC(01da3740) SHA1(b765683f2944351217a61c2aacfb09f959e5ad00) )
	ROM_LOAD16_BYTE( "95427025.hi", 0x00000, 0x080000, CRC(8956a0e0) SHA1(c8d070fce0336f63df05d18dd860337cba9dda1a) )
	sc_rosts_others
ROM_END

ROM_START( sc5rostsd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427242.lo", 0x00001, 0x080000, CRC(11826e47) SHA1(712dffaafc5c1c9dbae430187dd53ed711fe016c) )
	ROM_LOAD16_BYTE( "95427243.hi", 0x00000, 0x080000, CRC(2e6e312e) SHA1(2abd8fafe1bb21bcaddc39f70c23eb9d457ab311) )
	sc_rosts_others
ROM_END

ROM_START( sc5rostse )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427480.lo", 0x00001, 0x080000, CRC(ce66e59b) SHA1(2ec6cf2f9cdda4cc3c259506d3f7fb089eef6afa) )
	ROM_LOAD16_BYTE( "95427481.hi", 0x00000, 0x080000, CRC(a9ec2b1f) SHA1(14e815cc451316aa6ff3456e0c1d881236dbe6af) )
	sc_rosts_others
ROM_END

ROM_START( sc5rovrt )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416804.lo", 0x00001, 0x080000, CRC(4753f2ea) SHA1(6c0e7a890d89fe98cf1ad19bb1d6658be92c0233) )
	ROM_LOAD16_BYTE( "95416805.hi", 0x00000, 0x080000, CRC(db3bf6ce) SHA1(ad10d7d0df5d63cecf41d111545fc64313d9db88) )
	sc_rovrt_others
ROM_END

ROM_START( sc5rovrta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417804.lo", 0x00001, 0x080000, CRC(40098300) SHA1(de7d3966c46ba58d49efcea568ba8d52fc53a1bc) )
	ROM_LOAD16_BYTE( "95417805.hi", 0x00000, 0x080000, CRC(c39f21d0) SHA1(585ac468849a788b47e3dbf9f41dbc618e67405a) )
	sc_rovrt_others
ROM_END

ROM_START( sc5rovrtb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420208.lo", 0x00001, 0x080000, CRC(69c11c3d) SHA1(5269060fa78a929e379fa46d993d630534307cdc) )
	ROM_LOAD16_BYTE( "95420209.hi", 0x00000, 0x080000, CRC(614b3dd1) SHA1(a04fb9c173afd2d54948dbbd1ab7979cceeb1c31) )
	sc_rovrt_others
ROM_END

ROM_START( sc5rovrtc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421208.lo", 0x00001, 0x080000, CRC(f982c649) SHA1(45c6e7460fe5ae11e972ff117b1af6ddc8acb3cc) )
	ROM_LOAD16_BYTE( "95421209.hi", 0x00000, 0x080000, CRC(1b4df6b3) SHA1(ab1e94315f3841f4abc3f2729152d85dc42bfc9a) )
	sc_rovrt_others
ROM_END

ROM_START( sc5smtm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416774.lo", 0x00001, 0x080000, CRC(69c428c1) SHA1(820ee15cd362c59b045b7c8367d090bb0cba8b52) )
	ROM_LOAD16_BYTE( "95416775.hi", 0x00000, 0x080000, CRC(fe319548) SHA1(d5c4ea5a0e5eb11bebcba5df00932b38d562a83d) )
	sc_smtm_others
ROM_END

ROM_START( sc5smtma )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417774.lo", 0x00001, 0x080000, CRC(c7c3a41f) SHA1(0af495f5d387b53c3d8640ecccaeac3152b26ee5) )
	ROM_LOAD16_BYTE( "95417775.hi", 0x00000, 0x080000, CRC(776b8acb) SHA1(cf9f92a548caf101815094e32e5b1f2e3e6e85cb) )
	sc_smtm_others
ROM_END


ROM_START( sc5showt )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422250.lo", 0x00001, 0x080000, CRC(f5ccf736) SHA1(515020f2caeaa17da5c24cec7dd7591cd1bd1c9f) )
	ROM_LOAD16_BYTE( "95422251.hi", 0x00000, 0x080000, CRC(353cc294) SHA1(182dd862b0827ac843531ac471b28a1e0dba8452) )
	sc_showt_others
ROM_END

ROM_START( sc5showta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422264.lo", 0x00001, 0x080000, CRC(60f0aaa4) SHA1(5959317094e03e520d2fa09912bba317f09bb18d) )
	ROM_LOAD16_BYTE( "95422265.hi", 0x00000, 0x080000, CRC(250e5f22) SHA1(21c57910c4e998287dcd7de2c09e6f2393e34561) )
	sc_showt_others
ROM_END

ROM_START( sc5showtb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422266.lo", 0x00001, 0x080000, CRC(cd90c3a6) SHA1(7e87d8972bddaeecd370ea90cfe401b31e45cf3a) )
	ROM_LOAD16_BYTE( "95422267.hi", 0x00000, 0x080000, CRC(94408414) SHA1(a6e093020f8eef4390fe9de8314bf7ef7e4a3fdd) )
	sc_showt_others
ROM_END

ROM_START( sc5showtc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422282.lo", 0x00001, 0x080000, CRC(8dd2c938) SHA1(c4f51b27e51dc0a37ccf65731029497d9078b093) )
	ROM_LOAD16_BYTE( "95422283.hi", 0x00000, 0x080000, CRC(c4562c9b) SHA1(39355f1a9ffcfcc9da8fb650cc2bcdca298a4013) )
	sc_showt_others
ROM_END

ROM_START( sc5showtd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422508.lo", 0x00001, 0x080000, CRC(2331b6d8) SHA1(925f62a8b899210dd5b9fad84978757c581423b7) )
	ROM_LOAD16_BYTE( "95422509.hi", 0x00000, 0x080000, CRC(8b039dca) SHA1(3c881ad34e1406749cd80d71754febe618c13fea) )
	sc_showt_others
ROM_END

ROM_START( sc5showte )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422760.lo", 0x00001, 0x080000, CRC(1375e194) SHA1(05292e05c469890eebdfa125a293a7a27b41d77d) )
	ROM_LOAD16_BYTE( "95422761.hi", 0x00000, 0x080000, CRC(e0aec359) SHA1(75a241a6e170f691eea7552bbb8dc97e40b723d3) )
	sc_showt_others
ROM_END

ROM_START( sc5showtf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423250.lo", 0x00001, 0x080000, CRC(3245a8a6) SHA1(9341ff47bb9a2d22f49c114234daec283ad7e879) )
	ROM_LOAD16_BYTE( "95423251.hi", 0x00000, 0x080000, CRC(40a0ec3a) SHA1(3e32e96f0484cb15ec24e659218c815732905277) )
	sc_showt_others
ROM_END

ROM_START( sc5showtg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423264.lo", 0x00001, 0x080000, CRC(72a1d258) SHA1(4e2989f1a5826907200ed2b90c96d68bf4b2f272) )
	ROM_LOAD16_BYTE( "95423265.hi", 0x00000, 0x080000, CRC(f45d4470) SHA1(d5598c079bc69bab8e205a0713b7f04b7f2a1645) )
	sc_showt_others
ROM_END

ROM_START( sc5showth )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423266.lo", 0x00001, 0x080000, CRC(d57d3dc9) SHA1(388ef7d70e39b1cf7c490b5728a41d56c13e89bb) )
	ROM_LOAD16_BYTE( "95423267.hi", 0x00000, 0x080000, CRC(1a0dc2a4) SHA1(93b17f39436078245df3e3ada3525b397372717d) )
	sc_showt_others
ROM_END

ROM_START( sc5showti )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423282.lo", 0x00001, 0x080000, CRC(0f797a89) SHA1(d877282a0fc6a8e8324df461c16c50da9c58f586) )
	ROM_LOAD16_BYTE( "95423283.hi", 0x00000, 0x080000, CRC(7a6f6a99) SHA1(1863e215a03c0e97c6aea97d8cc23d219bffb1cd) )
	sc_showt_others
ROM_END

ROM_START( sc5showtj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423508.lo", 0x00001, 0x080000, CRC(f6c86a6d) SHA1(feb7bc7d0014a4030ed0582412f31f9fa0ca2452) )
	ROM_LOAD16_BYTE( "95423509.hi", 0x00000, 0x080000, CRC(d305bd12) SHA1(9cab958cbd54b16344356768c2b910e972740290) )
	sc_showt_others
ROM_END

ROM_START( sc5showtk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423760.lo", 0x00001, 0x080000, CRC(27e3af32) SHA1(d441367f254304c1b7e2f4a40384f222080fbdfb) )
	ROM_LOAD16_BYTE( "95423761.hi", 0x00000, 0x080000, CRC(e522bc87) SHA1(1c8e8ad395696e9dad4e1b7bbd7ff4fff772771b) )
	sc_showt_others
ROM_END

ROM_START( sc5showtl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426280.lo", 0x00001, 0x080000, CRC(df58a77a) SHA1(4873fb57d1f7305638655e662290382ec8f71d83) )
	ROM_LOAD16_BYTE( "95426281.hi", 0x00000, 0x080000, CRC(fc06f41f) SHA1(23543ed0bd3f3d19254b13b025f3bb7d72069074) )
	sc_showt_others
ROM_END

ROM_START( sc5showtm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427280.lo", 0x00001, 0x080000, CRC(9f6eb87a) SHA1(8ec853dcfc2ab70aa9b354a7d53830fb98372b72) )
	ROM_LOAD16_BYTE( "95427281.hi", 0x00000, 0x080000, CRC(dffa8c35) SHA1(d73cb184593d1f2c1d60c9e71c130317f5302624) )
	sc_showt_others
ROM_END

ROM_START( sc5showtn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3013p72.hi", 0x00000, 0x080000, CRC(4a2bb3f4) SHA1(c83e20f1481fd6be86f9b8bc3bbc075b984602d0) )
	ROM_LOAD16_BYTE( "p3013p72.lo", 0x00001, 0x080000, CRC(0c356331) SHA1(b1539d2f191ea00265674b13ca8098f91462f545) )
	sc_showt_others
ROM_END

ROM_START( sc5showto )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3013p73.hi", 0x00000, 0x080000, CRC(33584a9f) SHA1(9c4fb053feb1be7e80466d83e04190a045ba0739) )
	ROM_LOAD16_BYTE( "p3013p73.lo", 0x00001, 0x080000, CRC(04a0ef49) SHA1(9d08c72b4c243892ea21e82bf6daf21f218c1b60) )
	sc_showt_others
ROM_END

ROM_START( sc5showtp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3013s72.hi", 0x00000, 0x080000, CRC(a7fa33b6) SHA1(fdbbb4ad615570a80b8e96a2cda64655ae079e39) )
	ROM_LOAD16_BYTE( "p3013s72.lo", 0x00001, 0x080000, CRC(44921322) SHA1(ffd0d5ff9a0d013f43c031e60b7db9208d98d5bc) )
	sc_showt_others
ROM_END

ROM_START( sc5showtq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3013s73.hi", 0x00000, 0x080000, CRC(a7e54de1) SHA1(72ac11cbc9c75da11a3064e1b48533db60d3ba8f) )
	ROM_LOAD16_BYTE( "p3013s73.lo", 0x00001, 0x080000, CRC(9a696a93) SHA1(c051803e47d73ab33abb539e58e83630940e1d77) )
	sc_showt_others
ROM_END

ROM_START( sc5slad )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408992.lo", 0x00001, 0x080000, CRC(52b25a9c) SHA1(a886bbb06fc446551d03b7fccdc51b0c7426f554) )
	ROM_LOAD16_BYTE( "95408993.hi", 0x00000, 0x080000, CRC(34232091) SHA1(aff81aefc6816df5fbe121a365597b1efd255b91) )
	sc_slad_others
ROM_END

ROM_START( sc5slada )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95408994.lo", 0x00001, 0x080000, CRC(7952dd9b) SHA1(b314dfc941594b379c0bf3ac8a215f9da8fce5ad) )
	ROM_LOAD16_BYTE( "95408995.hi", 0x00000, 0x080000, CRC(1fa6cbc9) SHA1(4602ee52f7c3cdc4ea6624cf9269c934e45026ec) )
	sc_slad_others
ROM_END

ROM_START( sc5sladb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409992.lo", 0x00001, 0x080000, CRC(4c8a4ac5) SHA1(4587a6f9b5224fd3001f70902b6dcbf6b10133a1) )
	ROM_LOAD16_BYTE( "95409993.hi", 0x00000, 0x080000, CRC(8a1f3400) SHA1(d4e94be6c8738ced82bf6399b7ab12c95a91d92f) )
	sc_slad_others
ROM_END

ROM_START( sc5sladc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95409994.lo", 0x00001, 0x080000, CRC(676acdc2) SHA1(60bed4e1ce0bcb95cd4d47dfa17dfc0312715a60) )
	ROM_LOAD16_BYTE( "95409995.hi", 0x00000, 0x080000, CRC(a19adf58) SHA1(783f91b89ab95523803d2ebf547ab37a9f864ebe) )
	sc_slad_others
ROM_END

ROM_START( sc5sladd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410836.lo", 0x00001, 0x080000, CRC(b50072a5) SHA1(5c4603576a9a2efe2a03d3ad98026124ec57f1fb) )
	ROM_LOAD16_BYTE( "95410837.hi", 0x00000, 0x080000, CRC(1b9c675f) SHA1(2e62c9149d7f8fc4af63bcb8399259197cb4108e) )
	sc_slad_others
ROM_END

ROM_START( sc5slade )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410838.lo", 0x00001, 0x080000, CRC(f4925ba2) SHA1(d606b1e3e936d1f4c924484cc36ee99146b5b41b) )
	ROM_LOAD16_BYTE( "95410839.hi", 0x00000, 0x080000, CRC(04e4bf17) SHA1(98ab9f35ff9e5cfdd62fefb1ca5c09b41a821eb4) )
	sc_slad_others
ROM_END

ROM_START( sc5sladf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411836.lo", 0x00001, 0x080000, CRC(19607aa0) SHA1(3818ea45d13f5c510b9aa68a91d1042382112d2c) )
	ROM_LOAD16_BYTE( "95411837.hi", 0x00000, 0x080000, CRC(9f357e2b) SHA1(ba4dfa42f5b9b56f0d0fc0b9a5a6f3f4a9d320ec) )
	sc_slad_others
ROM_END

ROM_START( sc5sladg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411838.lo", 0x00001, 0x080000, CRC(58f253a7) SHA1(45372be7175a6dfd7f53f81d4b605b4c462d1962) )
	ROM_LOAD16_BYTE( "95411839.hi", 0x00000, 0x080000, CRC(804da663) SHA1(f5fbf8d701a907cdddf0f0adced4485444ba9cad) )
	sc_slad_others
ROM_END



ROM_START( sc5spice )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418376.lo", 0x00001, 0x080000, CRC(f5d1d605) SHA1(83cbbedd35260fc4a66d0dba935ee61cf1939ed0) )
	ROM_LOAD16_BYTE( "95418377.hi", 0x00000, 0x080000, CRC(4fce1d68) SHA1(36c81646d76e0bc89146fcbbfbad661c2320b4c8) )
	sc_spice_others
ROM_END

ROM_START( sc5spicea )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418488.lo", 0x00001, 0x080000, CRC(f8de81a8) SHA1(2cede8dc509bab58e7613611ca9a7aec4713acf5) )
	ROM_LOAD16_BYTE( "95418489.hi", 0x00000, 0x080000, CRC(170454a4) SHA1(3c5dc1a19a58bf72a90d74d1ba9f970dc11833fb) )
	sc_spice_others
ROM_END

ROM_START( sc5spiceb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419376.lo", 0x00001, 0x080000, CRC(5f66dde4) SHA1(62318dda642830b829636efa02b2051824ffe1f7) )
	ROM_LOAD16_BYTE( "95419377.hi", 0x00000, 0x080000, CRC(3ae406a2) SHA1(d042cb577229e30f31735e8c461821b3d7c8ed59) )
	sc_spice_others
ROM_END

ROM_START( sc5spicec )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419488.lo", 0x00001, 0x080000, CRC(c17394ee) SHA1(384ecc4450d161459cadff6c6b8b05cd2c50562a) )
	ROM_LOAD16_BYTE( "95419489.hi", 0x00000, 0x080000, CRC(9e962a61) SHA1(2a5984ff26e0ae4c24b0efa1cc3321a609db93f9) )
	sc_spice_others
ROM_END

ROM_START( sc5spiced )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422968.lo", 0x00001, 0x080000, CRC(1be00ec6) SHA1(805769692fce2ad70ee71c3a82f63f90e58186d4) )
	ROM_LOAD16_BYTE( "95422969.hi", 0x00000, 0x080000, CRC(b3c7d7f3) SHA1(0d66b1930e765c4cc91e8028584b4632ba00bb44) )
	sc_spice_others
ROM_END

ROM_START( sc5spicee )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423968.lo", 0x00001, 0x080000, CRC(a96eda7e) SHA1(7ec117adb50821f99fda5def3f7851ed880fcf15) )
	ROM_LOAD16_BYTE( "95423969.hi", 0x00000, 0x080000, CRC(dff7d5ef) SHA1(f8c8630bad47d9dfb1e4f3d2b090cdb66a51195c) )
	sc_spice_others
ROM_END

ROM_START( sc5swywm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416370.lo", 0x00001, 0x080000, CRC(c318c638) SHA1(f9e9bc1dabd51901bd6bd5fda7d9b808cd323c21) )
	ROM_LOAD16_BYTE( "95416371.hi", 0x00000, 0x080000, CRC(3c583cc6) SHA1(9cd0e6010e3e8d13acb6efba5a962c3db2daa65a) )
	sc_swywm_others
ROM_END

ROM_START( sc5swywma )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417370.lo", 0x00001, 0x080000, CRC(32232445) SHA1(4ccef584781987e73cecef8932620bcec6e1efe7) )
	ROM_LOAD16_BYTE( "95417371.hi", 0x00000, 0x080000, CRC(e647d430) SHA1(5ae9258149dace4999e62fa6369aa78064739575) )
	sc_swywm_others
ROM_END

ROM_START( sc5swywmb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420306.lo", 0x00001, 0x080000, CRC(14f6e069) SHA1(c3af8f51b17c078e9293d514cb2bbe4045bfb66a) )
	ROM_LOAD16_BYTE( "95420307.hi", 0x00000, 0x080000, CRC(f6dedbc3) SHA1(23a433453cd518b3d17770e4d5638877eaecb5ae) )
	sc_swywm_others
ROM_END

ROM_START( sc5swywmc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421306.lo", 0x00001, 0x080000, CRC(36527439) SHA1(7d1b8d18b8689992bc16106fed655fd930f682a9) )
	ROM_LOAD16_BYTE( "95421307.hi", 0x00000, 0x080000, CRC(ee60c6dc) SHA1(ed74e4a4833c4a01f0ec3be456fb48269520e725) )
	sc_swywm_others
ROM_END

ROM_START( sc5sumit )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416732.lo", 0x00001, 0x080000, CRC(78bb861e) SHA1(ba80e658f04d8d24676155df0f89b478df9ddc11) )
	ROM_LOAD16_BYTE( "95416733.hi", 0x00000, 0x080000, CRC(a4a347d0) SHA1(7e9c0679fdaff59a7fe56c6a7ceedda2e0b56786) )
	sc_sus_others
ROM_END

ROM_START( sc5sus )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416798.lo", 0x00001, 0x080000, CRC(b0fe16d2) SHA1(fa10b63dba55c834a5facb0d624b1015fbe04c2e) )
	ROM_LOAD16_BYTE( "95416799.hi", 0x00000, 0x080000, CRC(eeb20d9c) SHA1(acc3ba10a2c9858f862ceca3ebe00512f2ce0088) )
	sc_sus_others
ROM_END

ROM_START( sc5sumita )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417732.lo", 0x00001, 0x080000, CRC(b279d17c) SHA1(4f44ec13fde326ccc61a75827245267d82ea64e3) )
	ROM_LOAD16_BYTE( "95417733.hi", 0x00000, 0x080000, CRC(938e7b0d) SHA1(0b62020e57a972c54b2b5f204178089b3870daef) )
	sc_sus_others
ROM_END

ROM_START( sc5susa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417798.lo", 0x00001, 0x080000, CRC(013e9bb0) SHA1(002e444df92b1d9859510ad15e3b19780c18a147) )
	ROM_LOAD16_BYTE( "95417799.hi", 0x00000, 0x080000, CRC(74ac42ff) SHA1(af5242a5e44d77cedf8972212548781206ccf9e9) )
	sc_sus_others
ROM_END

ROM_START( sc5susb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420126.lo", 0x00001, 0x080000, CRC(e3b01116) SHA1(35d793963a3f22319ee368cee7c5b9403ecba5a1) )
	ROM_LOAD16_BYTE( "95420127.hi", 0x00000, 0x080000, CRC(b0ba53e3) SHA1(968bb739443c4d4145c1f5dc9ce75bdf2a54c670) )
	sc_sus_others
ROM_END

ROM_START( sc5susc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421126.lo", 0x00001, 0x080000, CRC(491c57d9) SHA1(c97c4866dead95064ac5a13ab61b279c67474d5d) )
	ROM_LOAD16_BYTE( "95421127.hi", 0x00000, 0x080000, CRC(7920ee8d) SHA1(2470c468973ed814c1114e88b45d950e82716767) )
	sc_sus_others
ROM_END


ROM_START( ad5sslam )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )

	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASE00 )
	ROM_LOAD( "39211387.bin", 0x0000, 0x1000000, CRC(315c9b47) SHA1(75659d9888fdbc83cd2559e88d4c47c90309956f) )
	ROM_LOAD( "p3084p12.bin", 0x0000, 0x1000000, CRC(f08e517d) SHA1(dc6f622d025fabad8302735188757a6f645ad2e3) )
	ROM_LOAD( "p3084s11.bin", 0x0000, 0x1000000, CRC(d51a0816) SHA1(6ff1b486f29395d7f7fbe726c6c8bc185f145f93) )
	ROM_LOAD( "p3084s12.bin", 0x0000, 0x1000000, CRC(7d33e52d) SHA1(6591834c60103f71211449355c592473180c33d9) )
	ROM_LOAD( "39211386.bin", 0x00000, 0x1000000, CRC(05d2c75b) SHA1(7c82d48e74997b4fe2c12e56a96a7c7ca57628cb) )
	ROM_LOAD( "39212386.bin", 0x00000, 0x1000000, CRC(4b47f4fc) SHA1(4a72df0c60968bdedac967f1989e3a4bcd7b974d) )

	sc_sslam_others
ROM_END


ROM_START( sc5swbak )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416584.lo", 0x00001, 0x080000, CRC(6a391e3e) SHA1(2356f172565c73f9ee48b174831e39401770eabe) )
	ROM_LOAD16_BYTE( "95416585.hi", 0x00000, 0x080000, CRC(485bec6b) SHA1(1f591352d4d6a5a668ad69e49131e58d507edac3) )
	sc_swbak_others
ROM_END

ROM_START( sc5swbaka )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417584.lo", 0x00001, 0x080000, CRC(7f77c234) SHA1(74f438838747e874fe5e5c568431c936cad6cf6c) )
	ROM_LOAD16_BYTE( "95417585.hi", 0x00000, 0x080000, CRC(ac32e805) SHA1(aed5dd9c7ce77686d8908b5d39f2527e8b037792) )
	sc_swbak_others
ROM_END


ROM_START( sc5ttpie )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418282.lo", 0x00001, 0x080000, CRC(e88a7afe) SHA1(c478af44d2980e48c9642c3e98354141a596e617) )
	ROM_LOAD16_BYTE( "95418283.hi", 0x00000, 0x080000, CRC(31f34712) SHA1(0f3c0660957adf4f304f027c85b27005c259ffb1) )
	sc_ttpie_others
ROM_END

ROM_START( sc5ttpiea )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418484.lo", 0x00001, 0x080000, CRC(55001073) SHA1(cf81787d83004eecec27a4543fbc0b8f20d28fd8) )
	ROM_LOAD16_BYTE( "95418485.hi", 0x00000, 0x080000, CRC(943aee32) SHA1(d07d05a0b4a6a8688428a83174b9def2db96095e) )
	sc_ttpie_others
ROM_END

ROM_START( sc5ttpieb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418670.lo", 0x00001, 0x080000, CRC(8ca1c291) SHA1(2f9ad8a5f4533327c828eb441f408a98ad86794d) )
	ROM_LOAD16_BYTE( "95418671.hi", 0x00000, 0x080000, CRC(bab3dbde) SHA1(da3a589c45d529eb328ba051f8fcf92bbae01023) )
	sc_ttpie_others
ROM_END

ROM_START( sc5ttpiec )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419282.lo", 0x00001, 0x080000, CRC(558d912f) SHA1(c5e6fed235ac7616e56f6fb4a161148943569a61) )
	ROM_LOAD16_BYTE( "95419283.hi", 0x00000, 0x080000, CRC(e7835704) SHA1(fa2769cb248df57b60f3849261c91e4cd7fc9cf5) )
	sc_ttpie_others
ROM_END

ROM_START( sc5ttpied )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419484.lo", 0x00001, 0x080000, CRC(912fed2e) SHA1(c7efc626e19cd0253c4dc7117a3346e36b6de8f9) )
	ROM_LOAD16_BYTE( "95419485.hi", 0x00000, 0x080000, CRC(8e4c2150) SHA1(72ee84d6d6a01475d29ab8b1380d7a7d2272b609) )
	sc_ttpie_others
ROM_END

ROM_START( sc5ttpiee )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419670.lo", 0x00001, 0x080000, CRC(c38bf8c9) SHA1(bc3125e754208e90578433ca6c6982443c98482d) )
	ROM_LOAD16_BYTE( "95419671.hi", 0x00000, 0x080000, CRC(6890ef77) SHA1(2e7d13a2e511f991faa1c1a34913927f7e64df50) )
	sc_ttpie_others
ROM_END

ROM_START( sc5ttpief )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422032.lo", 0x00001, 0x080000, CRC(c5ae746d) SHA1(c66d5ed13934953507a8fed1d733b5062fc77b98) )
	ROM_LOAD16_BYTE( "95422033.hi", 0x00000, 0x080000, CRC(24ca3563) SHA1(8b1c822c44fb65186bdd5004b9de7e98a048f13f) )
	sc_ttpie_others
ROM_END

ROM_START( sc5ttpieg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422970.lo", 0x00001, 0x080000, CRC(32b28b53) SHA1(ad9999f28239296a470d1120335415ac3d8e84d3) )
	ROM_LOAD16_BYTE( "95422971.hi", 0x00000, 0x080000, CRC(b8a184f6) SHA1(122443d162f287dbc4da893f370a9cbffba00280) )
	sc_ttpie_others
ROM_END

ROM_START( sc5ttpieh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423032.lo", 0x00001, 0x080000, CRC(58f16ef9) SHA1(2e50650c3863c11eb606869c0b402192e8e412b4) )
	ROM_LOAD16_BYTE( "95423033.hi", 0x00000, 0x080000, CRC(fe9c70dc) SHA1(98cc409fc0753be3ab23c2986e92a96413471dd1) )
	sc_ttpie_others
ROM_END

ROM_START( sc5ttpiei )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423970.lo", 0x00001, 0x080000, CRC(522a5e74) SHA1(7365f414f1c907f71322649474d77a69e211413f) )
	ROM_LOAD16_BYTE( "95423971.hi", 0x00000, 0x080000, CRC(0db07610) SHA1(9ef0e66301a63c756bc212daabb49718fdbf3c3a) )
	sc_ttpie_others
ROM_END


ROM_START( sc5typ )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3001p41.hi", 0x00000, 0x080000, CRC(e2748f7f) SHA1(895f441cc3019fa52a226e428e449f78d2bf78b8) )
	ROM_LOAD16_BYTE( "p3001p41.lo", 0x00001, 0x080000, CRC(bb208986) SHA1(44f98d8c37ef2d7a22f93ed5a62ac7c3cbe9c258) )
	sc_typ_others
ROM_END

ROM_START( sc5typa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3001p42.hi", 0x00000, 0x080000, CRC(8b3e94f4) SHA1(4bfc1b5179af439aa1370ba202eb7eb2bb9375e7) )
	ROM_LOAD16_BYTE( "p3001p42.lo", 0x00001, 0x080000, CRC(8fb76c4c) SHA1(f5486b934d83460787075973281a23beb83f101b) )
	sc_typ_others
ROM_END

ROM_START( sc5typb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3001s41.hi", 0x00000, 0x080000, CRC(791a5b14) SHA1(8fd9da104ae6b95e4c651bd164f3b421f85c4050) )
	ROM_LOAD16_BYTE( "p3001s41.lo", 0x00001, 0x080000, CRC(0d6eabd8) SHA1(83773fb597bc994a442fc5317bd81a0565816a7d) )
	sc_typ_others
ROM_END

ROM_START( sc5typc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3001s42.hi", 0x00000, 0x080000, CRC(7314531f) SHA1(6d5f9becd5e0ca11cd37b018ccac4ec196c0cfb5) )
	ROM_LOAD16_BYTE( "p3001s42.lo", 0x00001, 0x080000, CRC(16ad6b11) SHA1(f24ac0fe97ea1f6f36a6ca75e602d819e50489ab) )
	sc_typ_others
ROM_END


ROM_START( sc5tbox )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95414778.lo", 0x00001, 0x080000, CRC(487c5cc4) SHA1(a9145aba9402d86ab70c46f09c85f6f3d46fd205) )
	ROM_LOAD16_BYTE( "95414779.hi", 0x00000, 0x080000, CRC(2873e6b2) SHA1(81c9a4505367402924793720a753e035972e38ce) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95414828.lo", 0x00001, 0x080000, CRC(498fd1c1) SHA1(12827f2538b6affb095ffa5b5f6350490664a332) )
	ROM_LOAD16_BYTE( "95414829.hi", 0x00000, 0x080000, CRC(b8935360) SHA1(2f9b9ea2ba3041a7372b138dc2bfdd98813ca0ad) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95414926.lo", 0x00001, 0x080000, CRC(ee169b9c) SHA1(f9cc88955e2647530571aff5c7384b018415a042) )
	ROM_LOAD16_BYTE( "95414927.hi", 0x00000, 0x080000, CRC(8a602459) SHA1(2aea959105938abe734f823f10babec29d7c3425) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95414942.lo", 0x00001, 0x080000, CRC(19c6636a) SHA1(da21ad5208544a24f9e3dad23ee20318b5bb64af) )
	ROM_LOAD16_BYTE( "95414943.hi", 0x00000, 0x080000, CRC(21c68cb2) SHA1(e0ea75ef06fe9e91138371cb415797a84bbc49ce) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95415774.lo", 0x00001, 0x080000, CRC(0d4016bf) SHA1(b82058a82b8d06604dd960b506fdfe836ede769c) )
	ROM_LOAD16_BYTE( "95415775.hi", 0x00000, 0x080000, CRC(3e889448) SHA1(6729784afc2d968bcf2dcfa5b6051efbf3fab7f9) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95415776.lo", 0x00001, 0x080000, CRC(ef75f453) SHA1(16d6a5ab415026108187fc55dfd0b1a3a9efc3e9) )
	ROM_LOAD16_BYTE( "95415777.hi", 0x00000, 0x080000, CRC(af76919b) SHA1(c344de9eafd22383c05ad972c8e71898e01d6310) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95415778.lo", 0x00001, 0x080000, CRC(e5377604) SHA1(58d2fb3683477e104f064120bd974873977517da) )
	ROM_LOAD16_BYTE( "95415779.hi", 0x00000, 0x080000, CRC(d56a79f5) SHA1(52ae9a2179cd69cf56c96e946ed7d3b8eb977c31) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95415828.lo", 0x00001, 0x080000, CRC(e4c4fb01) SHA1(4e5fbf06a994ec8c08ba592305346df61300ab3d) )
	ROM_LOAD16_BYTE( "95415829.hi", 0x00000, 0x080000, CRC(458acc27) SHA1(ee1037070fa799479db203a4f73aa76faaa58885) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95415926.lo", 0x00001, 0x080000, CRC(cf6706dd) SHA1(8430d2528f6390b3bbb7882d6388b1d996e30cbd) )
	ROM_LOAD16_BYTE( "95415927.hi", 0x00000, 0x080000, CRC(8b5e8829) SHA1(386ead851e3ff7546d071c09a6882d89f7c9b765) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95415942.lo", 0x00001, 0x080000, CRC(8efebd16) SHA1(bd6e043f2346006769f44fecb375219a3f7c2868) )
	ROM_LOAD16_BYTE( "95415943.hi", 0x00000, 0x080000, CRC(4dd9ac8a) SHA1(d22ac1c4710888b9d103325a3f6aa6a5a2d92b6b) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416098.lo", 0x00001, 0x080000, CRC(40e7887c) SHA1(9ff0c5895b8453da276a888863ef97386c95de97) )
	ROM_LOAD16_BYTE( "95416099.hi", 0x00000, 0x080000, CRC(e3697e0b) SHA1(badcc5d35f95c568fb21f22b39f25b65a337f15a) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416142.lo", 0x00001, 0x080000, CRC(be042d98) SHA1(bafb71c0d4579b73e2b04e4834220e6be5928fba) )
	ROM_LOAD16_BYTE( "95416143.hi", 0x00000, 0x080000, CRC(a4ac3bdf) SHA1(c3e82fe7fb62d0128fca1b9aa9cbcfb3b12217b5) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416176.lo", 0x00001, 0x080000, CRC(835ec17f) SHA1(a7db233111112e7fed5dbe8490d02b8bc9d16cbd) )
	ROM_LOAD16_BYTE( "95416177.hi", 0x00000, 0x080000, CRC(f1919ea4) SHA1(2b8bef90b66b7682ef2ca6a6face929d73239551) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416572.lo", 0x00001, 0x080000, CRC(70489d47) SHA1(18127558ba138db015f5219001e05082ccc695b6) )
	ROM_LOAD16_BYTE( "95416573.hi", 0x00000, 0x080000, CRC(681f1467) SHA1(04ac5e5f809d3f4b7240c4326080e67815557245) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417098.lo", 0x00001, 0x080000, CRC(d13c9710) SHA1(12a4906254127fa623289ae1fffbb0cbb5d24c95) )
	ROM_LOAD16_BYTE( "95417099.hi", 0x00000, 0x080000, CRC(61f4177d) SHA1(eb125e0062030fdc98828f8c48d130516b62d978) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417142.lo", 0x00001, 0x080000, CRC(e51d2ea6) SHA1(7270cd90ea1c95675102bc7cb75e819a9c4b51c5) )
	ROM_LOAD16_BYTE( "95417143.hi", 0x00000, 0x080000, CRC(0204eef4) SHA1(6a240c108f5e196aff7b0e2caf81cd9b366d12dd) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417176.lo", 0x00001, 0x080000, CRC(5668faa3) SHA1(2b1e64ddb59bbd99df123caec5fe22911101b126) )
	ROM_LOAD16_BYTE( "95417177.hi", 0x00000, 0x080000, CRC(beb1deb3) SHA1(a222890d80fa97e6b8f4bd0d12dee1b7adce022a) )
	sc_tbox_others
ROM_END

ROM_START( sc5tboxq )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417572.lo", 0x00001, 0x080000, CRC(b016031d) SHA1(e81aaadaccc72fabbb3c4b75a7dd4e069bdcb87c) )
	ROM_LOAD16_BYTE( "95417573.hi", 0x00000, 0x080000, CRC(067d6cbf) SHA1(5b152efd5977a2b5a5428db79a1d7261e332fb0e) )
	sc_tbox_others
ROM_END


ROM_START( sc5tpsht )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416320.lo", 0x00001, 0x080000, CRC(a43419b2) SHA1(e26d4225b922868ca341c50a8e739b8b63ccb866) )
	ROM_LOAD16_BYTE( "95416321.hi", 0x00000, 0x080000, CRC(1dcc98e0) SHA1(4eea0f246bd53728ef068e3ee4754acc5e3aeffb) )
	sc_tpsht_others
ROM_END

ROM_START( sc5tpshta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417320.lo", 0x00001, 0x080000, CRC(58058edf) SHA1(f92a0350d82b77c740ada7cb4670f05486a1d115) )
	ROM_LOAD16_BYTE( "95417321.hi", 0x00000, 0x080000, CRC(38fd30b5) SHA1(d52b9c9f4da11984af5c16ea42c0b462c4f6bf87) )
	sc_tpsht_others
ROM_END

ROM_START( sc5tpshtb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420100.lo", 0x00001, 0x080000, CRC(9a84928c) SHA1(9c360110f2b35320222a4dab942ff70cf39f9888) )
	ROM_LOAD16_BYTE( "95420101.hi", 0x00000, 0x080000, CRC(e403add7) SHA1(56cf7c4fb4dee8878662afcfea2e5682c4a2f586) )
	sc_tpsht_others
ROM_END

ROM_START( sc5tpshtc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421100.lo", 0x00001, 0x080000, CRC(0574029a) SHA1(8cecd1e4a39a66d9737c6d08b0631fb18ab0e114) )
	ROM_LOAD16_BYTE( "95421101.hi", 0x00000, 0x080000, CRC(6d895bf8) SHA1(79663c2f61bbdcffeb91d6e0a131551438c3296c) )
	sc_tpsht_others
ROM_END

ROM_START( sc5tpshtd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "t0p0f_th.l0", 0x00001, 0x080000, CRC(396cd52d) SHA1(0f8493510f0ad057f0327fd066a8ce46e1452adf) )
	ROM_LOAD16_BYTE( "t0pof_th.hi", 0x00000, 0x080000, CRC(e73ac578) SHA1(7ece9f95d88598664cee3a8482169a6f02f28523) )
	sc_tpsht_others
ROM_END


ROM_START( sc5trail )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95414888.lo", 0x00001, 0x080000, CRC(72c1bb74) SHA1(cc98cc984a5d99afcbc5641e72a0fa20fca4420e) )
	ROM_LOAD16_BYTE( "95414889.hi", 0x00000, 0x080000, CRC(8a946127) SHA1(044f4ec93b161aa72665c363213448de8bc0f43a) )
	sc_trail_others
ROM_END

ROM_START( sc5traila )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95415888.lo", 0x00001, 0x080000, CRC(91825b39) SHA1(d1833f404be2f473ee01c373b0396a9f17eef1b2) )
	ROM_LOAD16_BYTE( "95415889.hi", 0x00000, 0x080000, CRC(7577b260) SHA1(9137ddb1c04e7ec44a6e9213effa3ffd56706b50) )
	sc_trail_others
ROM_END

ROM_START( sc5vivam )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3010p41.hi", 0x00000, 0x080000, CRC(25ded37d) SHA1(3a24cae18d80e7f77975157d37483cecd3ed0e55) )
	ROM_LOAD16_BYTE( "p3010p41.lo", 0x00001, 0x080000, CRC(4cfc8f4d) SHA1(ecc7bb4ce72de9f7cbdaaf4ff5182bc9d1325f45) )
	PR3010_VIVA_MEXICO_SOUNDS11
ROM_END

ROM_START( sc5vivama )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3010s41.hi", 0x00000, 0x080000, CRC(1003cf54) SHA1(34e47911517a77dfd113af14bae4f335207f30be) )
	ROM_LOAD16_BYTE( "p3010s41.lo", 0x00001, 0x080000, CRC(89c37841) SHA1(9b2d313c2498a1d05903490adbf9b0157a14e65f) )
	PR3010_VIVA_MEXICO_SOUNDS11
ROM_END

ROM_START( sc5wldjk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420552.lo", 0x00001, 0x080000, CRC(27c67626) SHA1(8ec95b1bed40c710f1ce67f722009c7fd886fdf4) )
	ROM_LOAD16_BYTE( "95420553.hi", 0x00000, 0x080000, CRC(e058b60d) SHA1(ba6fe8e6fbb0d1bf8064e6c8dd5eedbaa2afff16) )
	sc_wldjk_others
ROM_END

ROM_START( sc5wldjka )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421552.lo", 0x00001, 0x080000, CRC(7dd4a966) SHA1(792679ba64495bbfefdd7a4d4db8981d83ad4a0e) )
	ROM_LOAD16_BYTE( "95421553.hi", 0x00000, 0x080000, CRC(f9826f0f) SHA1(c62e820fe9ac6a2c7691a9c1b2d43158c006c9ec) )
	sc_wldjk_others
ROM_END

ROM_START( sc5adsnt )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412702.lo", 0x00001, 0x080000, CRC(3993a885) SHA1(5672c8c617d14f0898726a22bc4fbb52ef570c1e) )
	ROM_LOAD16_BYTE( "95412703.hi", 0x00000, 0x080000, CRC(0e16a5e5) SHA1(fa86fba7eeb68a3d36c8e68e67abdd9e5a3e9cd2) )
	sc_adsnt_others
ROM_END


ROM_START( sc5adsnta )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413702.lo", 0x00001, 0x080000, CRC(4fed4b97) SHA1(e902467882026dc48423b9fee95cae97bbb12e84) )
	ROM_LOAD16_BYTE( "95413703.hi", 0x00000, 0x080000, CRC(3e5a472c) SHA1(f7395f63ab59492d0684734d95c63893e4a2b438) )
	sc_adsnt_others
ROM_END






ROM_START( sc5bpb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418022.lo", 0x00001, 0x080000, CRC(c6a84731) SHA1(65b7d1fef892644c5e07aa203e703a9400cd7049) )
	ROM_LOAD16_BYTE( "95418023.hi", 0x00000, 0x080000, CRC(b8a33eae) SHA1(8fbabac58b287130db49b5c37aca4e674ae89906) )
	sc_bpb_others
ROM_END

ROM_START( sc5bpba )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418818.lo", 0x00001, 0x080000, CRC(17103948) SHA1(d27f15629f03630ea38c388ea17ce71cf3dd9a4f) )
	ROM_LOAD16_BYTE( "95418819.hi", 0x00000, 0x080000, CRC(cf0029af) SHA1(f0b230a70edb057c1e0b3a2add846e08968c0ed5) )
	sc_bpb_others
ROM_END

ROM_START( sc5bpbb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419022.lo", 0x00001, 0x080000, CRC(ab8f24e8) SHA1(d2730c78bdc6e7e50781a74e8f80a2fa807736f1) )
	ROM_LOAD16_BYTE( "95419023.hi", 0x00000, 0x080000, CRC(0492566f) SHA1(7d026bcf43000ad696a3c800743904aaf8475331) )
	sc_bpb_others
ROM_END

ROM_START( sc5bpbc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419818.lo", 0x00001, 0x080000, CRC(71f668c4) SHA1(82c960547acbcead07c4efe8673731e3ba573961) )
	ROM_LOAD16_BYTE( "95419819.hi", 0x00000, 0x080000, CRC(982bfe3a) SHA1(008f1f2c756237d3a8333301170e8dbcc13b9743) )
	sc_bpb_others
ROM_END

ROM_START( sc5bpbd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1708p11.hi", 0x00000, 0x080000, CRC(d529391a) SHA1(1d095a8f665b5d67c51a05c6cd77fdbbe494d941) )
	ROM_LOAD16_BYTE( "p1708p11.lo", 0x00001, 0x080000, CRC(27f50f01) SHA1(bb71c6e44f0ad30716f4b39caeb982bd49a4b393) )
	sc_bpb_others
ROM_END

ROM_START( sc5bpbe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1708s11.hi", 0x00000, 0x080000, CRC(45dc3169) SHA1(d06fccc34a2ce7e76132e7789d3161487e7033ea) )
	ROM_LOAD16_BYTE( "p1708s11.lo", 0x00001, 0x080000, CRC(3f9363bc) SHA1(632a870193b71cb6518c1e58366d636a484188a9) )
	sc_bpb_others
ROM_END



ROM_START( sc5bsp )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422224.lo", 0x00001, 0x080000, CRC(4aa91225) SHA1(18be588d87bfa4953c943bc2dc2629d3105ae81b) )
	ROM_LOAD16_BYTE( "95422225.hi", 0x00000, 0x080000, CRC(cf857a93) SHA1(a5a25b773c146b14d98be271053a09fc14ea1ca9) )
	sc_bsp_others
ROM_END

ROM_START( sc5bspa )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422348.lo", 0x00001, 0x080000, CRC(d2c9d70c) SHA1(aaf01d423a8e74bab1551df3a4cf58d67b1081d1) )
	ROM_LOAD16_BYTE( "95422349.hi", 0x00000, 0x080000, CRC(b93691cc) SHA1(c3a17fdc39cff7fd4fcf34af9aa59876e06bd95c) )
	sc_bsp_others
ROM_END

ROM_START( sc5bspb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422372.lo", 0x00001, 0x080000, CRC(d4b9ca13) SHA1(b960f9b72650b59e1cbaa4ac67582c31065bf789) )
	ROM_LOAD16_BYTE( "95422373.hi", 0x00000, 0x080000, CRC(108a56af) SHA1(04e062c425845d309ddef7c1d1d1b228ba230eb8) )
	sc_bsp_others
ROM_END

ROM_START( sc5bspc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422506.lo", 0x00001, 0x080000, CRC(72df1cd5) SHA1(8f3ec5242a0e666d33245321073dcd090092cbc2) )
	ROM_LOAD16_BYTE( "95422507.hi", 0x00000, 0x080000, CRC(068ec97f) SHA1(2dbe3133a6e0db31472074dc9d9c060d905da70f) )
	sc_bsp_others
ROM_END

ROM_START( sc5bspd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422710.lo", 0x00001, 0x080000, CRC(92191d36) SHA1(081b21df2817ed73fb7406532f7ab6e0f79968df) )
	ROM_LOAD16_BYTE( "95422711.hi", 0x00000, 0x080000, CRC(4ff402f5) SHA1(c9781e41ef769bba90d625ad1296c19f2bdbef42) )
	sc_bsp_others
ROM_END

ROM_START( sc5bspe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423224.lo", 0x00001, 0x080000, CRC(12032bda) SHA1(abceef649a6fa7f46cf097eb4541391d66d42d7b) )
	ROM_LOAD16_BYTE( "95423225.hi", 0x00000, 0x080000, CRC(9f372c59) SHA1(f5265bd5c5f17a08b8312575b2e133debfea6914) )
	sc_bsp_others
ROM_END

ROM_START( sc5bspf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423348.lo", 0x00001, 0x080000, CRC(2373e487) SHA1(de47d3728e3ba067085c4e5962012e39ae94ba9a) )
	ROM_LOAD16_BYTE( "95423349.hi", 0x00000, 0x080000, CRC(ccf27b49) SHA1(d8c6f8862073db392394319666d15b6ee314066d) )
	sc_bsp_others
ROM_END

ROM_START( sc5bspg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423372.lo", 0x00001, 0x080000, CRC(21b01d1f) SHA1(436736fc5f158c9e250a167f7cc34c9f505cc0e5) )
	ROM_LOAD16_BYTE( "95423373.hi", 0x00000, 0x080000, CRC(73c08edb) SHA1(0529f59496b1a495f48978d8dff5fe3419a11349) )
	sc_bsp_others
ROM_END

ROM_START( sc5bsph )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423506.lo", 0x00001, 0x080000, CRC(dc8b85dd) SHA1(497634c277b3779dd4f57a5929c5101e079fb296) )
	ROM_LOAD16_BYTE( "95423507.hi", 0x00000, 0x080000, CRC(08cca11d) SHA1(e17cef5cff10cb592bbe8d2d173832f5d28f42f2) )
	sc_bsp_others
ROM_END

ROM_START( sc5bspi )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423710.lo", 0x00001, 0x080000, CRC(659f3613) SHA1(99ad4158c87dd83242be7b14fccf7120b533dc15) )
	ROM_LOAD16_BYTE( "95423711.hi", 0x00000, 0x080000, CRC(c001f60b) SHA1(9f540ee0f131578207edf1769e2c3de759cf5438) )
	sc_bsp_others
ROM_END


ROM_START( sc5bspj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426402.lo", 0x00001, 0x080000, CRC(9b82ca7f) SHA1(64d1de521357b014feeb924f680ebddaa0844fe2) )
	ROM_LOAD16_BYTE( "95426403.hi", 0x00000, 0x080000, CRC(352f353e) SHA1(b56f35c75d292c1cca8c7d7728f55a85d9f3e747) )
	sc_bsp_others
ROM_END

ROM_START( sc5bspk )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427402.lo", 0x00001, 0x080000, CRC(2d14361a) SHA1(ac555e45bfffdfb2d1b42bfdf195aef80558f441) )
	ROM_LOAD16_BYTE( "95427403.hi", 0x00000, 0x080000, CRC(fe0684d4) SHA1(9d11d455e3ef5d9b7b3f5b40ab10fb11f0e4d0d8) )
	sc_bsp_others
ROM_END

ROM_START( sc5bspl )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3012p71.hi", 0x00000, 0x080000, CRC(0f2d1056) SHA1(ef69dc75ce581a2b58df71f5fe8615a83d586680) )
	ROM_LOAD16_BYTE( "p3012p71.lo", 0x00001, 0x080000, CRC(e59265f1) SHA1(4a7fc13383076d7f2b2999f994c5b2064eec18e8) )
	sc_bsp_others
ROM_END

ROM_START( sc5bspm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3012p73.hi", 0x00000, 0x080000, CRC(660c709c) SHA1(a020b16ede3d160d8a9715cc0aec9e21caf389e2) )
	ROM_LOAD16_BYTE( "p3012p73.lo", 0x00001, 0x080000, CRC(3ada5001) SHA1(5056ce3056c2d7defc31100ba2a9b53401ae962b) )
	sc_bsp_others
ROM_END

ROM_START( sc5bspn )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3012s71.hi", 0x00000, 0x080000, CRC(1c3e5a08) SHA1(0cea2fc9e9ed0f00414c697bcc88815771968bca) )
	ROM_LOAD16_BYTE( "p3012s71.lo", 0x00001, 0x080000, CRC(7ab0cd4d) SHA1(030e166abfc19fc4597b2c2fca80c0775ff11d7f) )
	sc_bsp_others
ROM_END

ROM_START( sc5bspo )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3012s73.hi", 0x00000, 0x080000, CRC(1fe675ca) SHA1(8309d76925d4a2e62f42da0bb7ebc31e68d2e2a7) )
	ROM_LOAD16_BYTE( "p3012s73.lo", 0x00001, 0x080000, CRC(e1c6d034) SHA1(9d07da9f7fd38bae44ad88a291bdcce8641d46b7) )
	sc_bsp_others
ROM_END



ROM_START( sc5chain )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1312p13.hi", 0x00000, 0x080000, CRC(6ce6a39b) SHA1(329cde7eed857a1a772974725027db3531857ccd) )
	ROM_LOAD16_BYTE( "p1312p13.lo", 0x00001, 0x080000, CRC(e258be41) SHA1(b4012c5d2d08971a09bc1bac6ff78686aa38db30) )
	sc_chain_others
ROM_END

ROM_START( sc5chaina )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1312p23.hi", 0x00000, 0x080000, CRC(e7b27d08) SHA1(07171c023f6382513d2671ba838d59bfdb8a6f4f) )
	ROM_LOAD16_BYTE( "p1312p23.lo", 0x00001, 0x080000, CRC(07643205) SHA1(5ddffad4b6034b1d600854aa2e2f9f3489c32775) )
	sc_chain_others
ROM_END

ROM_START( sc5chainb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1312p24.hi", 0x00000, 0x080000, CRC(0628e1e9) SHA1(32c5063ed218998a0732c480acc6fce34ff42451) )
	ROM_LOAD16_BYTE( "p1312p24.lo", 0x00001, 0x080000, CRC(ba87c653) SHA1(d88cd779bc6088ae4bf231970b5cfddd99a43c73) )
	sc_chain_others
ROM_END

ROM_START( sc5chainc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1312s13.hi", 0x00000, 0x080000, CRC(f5e38577) SHA1(d921bb4520547f85c0e190875305d0562fa36cc6) )
	ROM_LOAD16_BYTE( "p1312s13.lo", 0x00001, 0x080000, CRC(55b7a061) SHA1(01b7c564f21570feee2c2c01c4717b786784cc8f) )
	sc_chain_others
ROM_END

ROM_START( sc5chaind )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1312s23.hi", 0x00000, 0x080000, CRC(66aacd7a) SHA1(45f5ecb35cc6a2d88fe5bdb7d70f719b1ab0ce4a) )
	ROM_LOAD16_BYTE( "p1312s23.lo", 0x00001, 0x080000, CRC(2124ed53) SHA1(4ae362fd6a7e6116873ddba3f52e1b4195b3a34c) )
	sc_chain_others
ROM_END

ROM_START( sc5chaine )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p1312s24.hi", 0x00000, 0x080000, CRC(6bbf0b47) SHA1(a4955efb886a57b2840fe9a97288555c7d937fae) )
	ROM_LOAD16_BYTE( "p1312s24.lo", 0x00001, 0x080000, CRC(17b60464) SHA1(e1857fd5b17e6c9fd62d49a68ada38d2b73ed81c) )
	sc_chain_others
ROM_END




ROM_START( sc5clown )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418182.lo", 0x00001, 0x080000, CRC(f6e960f7) SHA1(c3f94e0b90f2bfb13111f933107926f4dbe1e1da) )
	ROM_LOAD16_BYTE( "95418183.hi", 0x00000, 0x080000, CRC(8593167c) SHA1(cbac923e69ad43c75027cca66917bc41fa30ac0c) )
	sc_clown_others
ROM_END

ROM_START( sc5clowna )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418820.lo", 0x00001, 0x080000, CRC(ccb31a88) SHA1(7f30cccf58bb1bf044f515bbd7d9b2817d283757) )
	ROM_LOAD16_BYTE( "95418821.hi", 0x00000, 0x080000, CRC(867c31f5) SHA1(9f47ca053e7aab09561c61e6c1886c753b089dfe) )
	sc_clown_others
ROM_END

ROM_START( sc5clownb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419182.lo", 0x00001, 0x080000, CRC(7f1ba659) SHA1(60e160259512555b9a86a886967ca9c6cd8c4c6f) )
	ROM_LOAD16_BYTE( "95419183.hi", 0x00000, 0x080000, CRC(3830ef7c) SHA1(fc093adfd9776d9975572c56c22e4c53e5586788) )
	sc_clown_others
ROM_END

ROM_START( sc5clownc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419820.lo", 0x00001, 0x080000, CRC(8967e729) SHA1(c717512b1d965d89019e0cbc4713c0f8900921ae) )
	ROM_LOAD16_BYTE( "95419821.hi", 0x00000, 0x080000, CRC(56225dbc) SHA1(83102dec281b99eea75f14422217f78db27c0012) )
	sc_clown_others
ROM_END






ROM_START( sc5copsr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410312.lo", 0x00001, 0x080000, CRC(969fb1ab) SHA1(6224309662e012e432698b0c760bd25586aa2b7f) )
	ROM_LOAD16_BYTE( "95410313.hi", 0x00000, 0x080000, CRC(c5eed678) SHA1(1b139bb296b0843192715016cc500354027cf1a1) )
	sc_copsr_others
ROM_END

ROM_START( sc5copsra )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410314.lo", 0x00001, 0x080000, CRC(46e40095) SHA1(eab1f9c0ebbcd0a11fa8e6abc34ea3681cc2fffb) )
	ROM_LOAD16_BYTE( "95410315.hi", 0x00000, 0x080000, CRC(2d321463) SHA1(071ab915f8ff3c9fbce1ca0f9c0885d45a09a306) )
	sc_copsr_others
ROM_END

ROM_START( sc5copsrb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410608.lo", 0x00001, 0x080000, CRC(658c5b6d) SHA1(0586fe753e16f0d044e65e9cbb9c1cff61c5f84e) )
	ROM_LOAD16_BYTE( "95410609.hi", 0x00000, 0x080000, CRC(20674963) SHA1(28d0364be5def1a172962ba2a132b266e35c50f7) )
	sc_copsr_others
ROM_END

ROM_START( sc5copsrc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95410610.lo", 0x00001, 0x080000, CRC(f72522c7) SHA1(2120710195120c5f398b7ffb7dc2fed6fe88a79b) )
	ROM_LOAD16_BYTE( "95410611.hi", 0x00000, 0x080000, CRC(cbe9cf90) SHA1(ecc8644aab30f017537191c37c4de6c98f6662e9) )
	sc_copsr_others
ROM_END

ROM_START( sc5copsrd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411312.lo", 0x00001, 0x080000, CRC(497d25fd) SHA1(66c325eb6c5f0a1deb761914d6f804fad412900e) )
	ROM_LOAD16_BYTE( "95411313.hi", 0x00000, 0x080000, CRC(a4813889) SHA1(abc2642c11f17bcf995e493c1bfbd488192a0eb6) )
	sc_copsr_others
ROM_END

ROM_START( sc5copsre )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411314.lo", 0x00001, 0x080000, CRC(b44ee169) SHA1(37ea84ed8a0b8697d08d609d98bc35c05c246da6) )
	ROM_LOAD16_BYTE( "95411315.hi", 0x00000, 0x080000, CRC(7939ff32) SHA1(468e43634f33f02823c3d8f878ecf9c71d2b6be5) )
	sc_copsr_others
ROM_END

ROM_START( sc5copsrf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411608.lo", 0x00001, 0x080000, CRC(8279a3c2) SHA1(73ff7c9c5e8589759d24ede74c035065a8e7863b) )
	ROM_LOAD16_BYTE( "95411609.hi", 0x00000, 0x080000, CRC(4fa4cbf3) SHA1(444a8a2657cadfa143e70b1878991fa3903bb86b) )
	sc_copsr_others
ROM_END

ROM_START( sc5copsrg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95411610.lo", 0x00001, 0x080000, CRC(10d0da68) SHA1(36a45b25f9003362b6daad98080c9beb6db49371) )
	ROM_LOAD16_BYTE( "95411611.hi", 0x00000, 0x080000, CRC(a42a4d00) SHA1(6a74c226b15b4a0282300f53ad8868cea5deaaa9) )
	sc_copsr_others
ROM_END

ROM_START( sc5copsrh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95412564.lo", 0x00001, 0x080000, CRC(3eaebc41) SHA1(867887d1d06126dc989c530999aea1a0944b969e) )
	ROM_LOAD16_BYTE( "95412565.hi", 0x00000, 0x080000, CRC(079d1921) SHA1(d6f8cea3b211c8fd86adca84e24748a23f48bfb4) )
	sc_copsr_others
ROM_END

ROM_START( sc5copsri )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95413564.lo", 0x00001, 0x080000, CRC(f6f9caea) SHA1(e23f5553be66d293428932b06bcf057833ea30e4) )
	ROM_LOAD16_BYTE( "95413565.hi", 0x00000, 0x080000, CRC(26ee9922) SHA1(5906557c201ecc1b84092803c3e848471aca5bd9) )
	sc_copsr_others
ROM_END


ROM_START( ad5copsr )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211436.bin", 0x0000, 0x1000000, CRC(9bc4cc3a) SHA1(6726d43281b1c7c9630fa8b5854b4f036e12b19b) )
	ROM_LOAD( "39211451.bin", 0x0000, 0x1000000, CRC(76ebb736) SHA1(10e3e349dde9941d900d900dc98e3f9a922bb116) )
	ROM_LOAD( "39211453.bin", 0x0000, 0x1000000, CRC(0fad8171) SHA1(c636774a53bd34e42e70b3ef09feecbb7e868154) )
	ROM_LOAD( "39211461.bin", 0x0000, 0x1000000, CRC(03f714e1) SHA1(ed4278471dc415c92a7076039307b87381d90882) )
	ROM_LOAD( "39211464.bin", 0x0000, 0x1000000, CRC(3f4a00bd) SHA1(1b48da1e9b6fee7fe1451de5cae8206cc9f8d778) )
	ROM_LOAD( "39211465.bin", 0x0000, 0x1000000, CRC(8b6c393d) SHA1(fb3546f94d8ab387078f934f651f3b8be9c3802e) )
	ROM_LOAD( "39211466.bin", 0x0000, 0x1000000, CRC(76d0bc51) SHA1(cbcc85c88d558d4720f99ef43ab9de72ed0a30a0) )
	ROM_LOAD( "39211483.bin", 0x0000, 0x1000000, CRC(5c7ea8ba) SHA1(0beb1575d9daa9b46af45fb9164b6508bd411f38) )
	ROM_LOAD( "39211546.bin", 0x0000, 0x1000000, CRC(2c7349a3) SHA1(83dc0595888b4b1afa79deb2713130418c8e9d30) )
	ROM_LOAD( "39211547.bin", 0x0000, 0x1000000, CRC(8384d64f) SHA1(c4127b666250a164ed02c415e7b2003293cd2863) )
	ROM_LOAD( "39211548.bin", 0x0000, 0x1000000, CRC(7b103e0b) SHA1(4dc8f5f197f68cba5104cea792f486b31f41a6ea) )
	ROM_LOAD( "39212436.bin", 0x0000, 0x1000000, CRC(ec543259) SHA1(272396189296f6989c35d3d8a0cec744b14da463) )
	ROM_LOAD( "39212451.bin", 0x0000, 0x1000000, CRC(ac5f5f27) SHA1(3adc50085a1d6fc2f63a63c112e75552d9a1f772) )
	ROM_LOAD( "39212453.bin", 0x0000, 0x1000000, CRC(e282bc72) SHA1(4326c656c779e48e8080ef332af7539a5d889140) )
	ROM_LOAD( "39212461.bin", 0x0000, 0x1000000, CRC(2017b8b7) SHA1(32baabdcf929ae9dc12d98dd91d6733961940d40) )
	ROM_LOAD( "39212464.bin", 0x0000, 0x1000000, CRC(33dce15c) SHA1(0b5ffef40f455a4beebbbd830940170207a73f23) )
	ROM_LOAD( "39212465.bin", 0x0000, 0x1000000, CRC(778fccce) SHA1(b4eeccec2b9255ff2810abb0f4d2cb3430acb177) )
	ROM_LOAD( "39212466.bin", 0x0000, 0x1000000, CRC(7d5c2d9d) SHA1(3d72b4ab137a24abdceec0ed7db8eb3a32ddb468) )
	ROM_LOAD( "39212483.bin", 0x0000, 0x1000000, CRC(156a328a) SHA1(e0e8300a536b18cbf687f2673fbf91771d92ad51) )
	ROM_LOAD( "39212546.bin", 0x0000, 0x1000000, CRC(22144763) SHA1(e376c74992c14f5f7787351fcf8c72b3da2fbae5) )
	ROM_LOAD( "39212547.bin", 0x0000, 0x1000000, CRC(b0c8a8d6) SHA1(d52c15a5f51d64232a40976fb1bd630a53396879) )
	ROM_LOAD( "39212548.bin", 0x0000, 0x1000000, CRC(fcd6f179) SHA1(77214ddfd452311e1631dafad3e7bc682a8ae7bd) )
	ROM_LOAD( "p3206p11.bin", 0x0000, 0x1000000, CRC(8b583dc6) SHA1(69ca467c509319d577b27b2945ab7265cdbe572c) )
	ROM_LOAD( "p3206s11.bin", 0x0000, 0x1000000, CRC(944b7cb9) SHA1(7a7c6e5d14371ef2131a1bf40a5e4972a6518a0a) )
	ROM_LOAD( "p3255p01.bin", 0x0000, 0x1000000, CRC(4855b7e3) SHA1(b69f9782c171a38f1f44f3eeab449d68d37ca996) )
	ROM_LOAD( "p3255s01.bin", 0x0000, 0x1000000, CRC(e971e090) SHA1(df201580ee6189f5fabab0e6f955aac90d82f9a6) )

	ROM_LOAD( "39211578.bin", 0x0000, 0x1000000, CRC(2d8a6d1b) SHA1(cc28c96d33468209192285e3b0d0690e189e4945) )
	ROM_LOAD( "39211621.bin", 0x0000, 0x1000000, CRC(e0469d8d) SHA1(0a519c5721133f07e313d50b2199165b1f516027) )
	ROM_LOAD( "39212578.bin", 0x0000, 0x1000000, CRC(15731e4b) SHA1(20ba14f87456a9610eb7f255fa1beae75800f3c6) )
	ROM_LOAD( "39212621.bin", 0x0000, 0x1000000, CRC(f19c6714) SHA1(16d9c63f36be622a11036aefd39b55c6fbf162b4) )
    ROM_LOAD( "39211622.bin", 0x00000, 0x1000000, CRC(6cd72899) SHA1(2f0d2af88276a8d45aac303a81a124ab7b743b6d) )
    ROM_LOAD( "39211623.bin", 0x00000, 0x1000000, CRC(b65943f4) SHA1(8f281bd1b04709085254e3e352b47f187a7b5b47) )
    ROM_LOAD( "39212622.bin", 0x00000, 0x1000000, CRC(055e639d) SHA1(b0a9427f0e8038d26b2a24425644dbda964cfa2c) )
    ROM_LOAD( "39212623.bin", 0x00000, 0x1000000, CRC(13b1e404) SHA1(ee170ffbd8fcd552c374e550e58a455da76af5fe) )




ROM_END




ROM_START( sc5dndbe )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418408.lo", 0x00001, 0x080000, CRC(cfed16c5) SHA1(fdec6bb6865c258af8ebfd5db529ef0e1c54fe35) )
	ROM_LOAD16_BYTE( "95418409.hi", 0x00000, 0x080000, CRC(a7fa99e7) SHA1(ff098a9adf00dce6d975d20c66734ac789f4d82d) )
	sc_dndbe_others
ROM_END


ROM_START( sc5dndbea )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418562.lo", 0x00001, 0x080000, CRC(71ddd3aa) SHA1(8e48d21e41454e1fc1845638baeee17da8f99a3e) )
	ROM_LOAD16_BYTE( "95418563.hi", 0x00000, 0x080000, CRC(4e4baee8) SHA1(064c7e05bee768f6240d766000f8480a08d59738) )
	sc_dndbe_others
ROM_END


ROM_START( sc5dndbeb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419408.lo", 0x00001, 0x080000, CRC(948adf45) SHA1(9faf9eaaae60994c7653c35c8886e329eb6cef56) )
	ROM_LOAD16_BYTE( "95419409.hi", 0x00000, 0x080000, CRC(79dc668f) SHA1(263fb10f42a6586283a0b6dbdeb401c639a837e8) )
	sc_dndbe_others
ROM_END


ROM_START( sc5dndbec )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419562.lo", 0x00001, 0x080000, CRC(c6a73fc8) SHA1(d33694a4b67581d450835d89709d859fda3bdb09) )
	ROM_LOAD16_BYTE( "95419563.hi", 0x00000, 0x080000, CRC(a521350c) SHA1(45dddd7791b0ac76ed6d39450624c8e2140fed3f) )
	sc_dndbe_others
ROM_END


ROM_START( sc5ddbbc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422008.lo", 0x00001, 0x080000, CRC(1071a6bf) SHA1(1ccd638a4899707f024575bf30db2ffd17b63d3c) ) // check these belong here, the pairings were broken
	ROM_LOAD16_BYTE( "95422009.hi", 0x00000, 0x080000, CRC(4360ee22) SHA1(98b08fdcf3efdb9d056f7c2f213a3e5d650686a7) ) // from  sc_dndtp   Deal Or No Deal The Power (Bellfruit)
	sc_dndbe_others
ROM_END


ROM_START( sc5ddbbca )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422094.lo", 0x00001, 0x080000, CRC(4b3cce67) SHA1(1e85f125308ffcbdc1564d2b00ce07db83a7b5ba) )
	ROM_LOAD16_BYTE( "95422095.hi", 0x00000, 0x080000, CRC(e4fa031f) SHA1(7438d213055bd5f26ac6c2e3798a0db1a11c1dc5) )
	sc_dndbe_others
ROM_END


ROM_START( sc5dndbed )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422138.lo", 0x00001, 0x080000, CRC(14830e37) SHA1(728e7b3c71d69c71e20daa1d766d238b2167dd0d) )
	ROM_LOAD16_BYTE( "95422139.hi", 0x00000, 0x080000, CRC(63172b46) SHA1(0ca1032a31f2a75840ca2689167054bf9dd48718) )
	sc_dndbe_others
ROM_END


ROM_START( sc5dndbee )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422536.lo", 0x00001, 0x080000, CRC(bb212e12) SHA1(31022880984eaebc5a9164ff9116f85ffa6ac7af) )
	ROM_LOAD16_BYTE( "95422537.hi", 0x00000, 0x080000, CRC(1094f140) SHA1(a17824ec68d7d0ee2ea10090807974e41b202e00) )
	sc_dndbe_others
ROM_END


ROM_START( sc5dndbef )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422716.lo", 0x00001, 0x080000, CRC(9012dfb9) SHA1(58fa79aa00ab91d60ed222ab5e7befd89544c488) )
	ROM_LOAD16_BYTE( "95422717.hi", 0x00000, 0x080000, CRC(fec7aa06) SHA1(50f11ca1073d546cc3e6fdf40c0e004e0c8a65b2) )
	sc_dndbe_others
ROM_END

ROM_START( sc5dndbeg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422864.lo", 0x00001, 0x080000, CRC(f969e95d) SHA1(c4dc12d745ad4e4e1a37cbf696875c65d0e33349) )
	ROM_LOAD16_BYTE( "95422865.hi", 0x00000, 0x080000, CRC(76abce7e) SHA1(737bdf6c3fa3820b8e114d61acc072a493fe7b26) )
	sc_dndbe_others
ROM_END


ROM_START( sc5dndbeh )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95422888.lo", 0x00001, 0x080000, CRC(75df9f2a) SHA1(6b0356a37a4cf5b9d687e22ff767a44cd4acda74) )
	ROM_LOAD16_BYTE( "95422889.hi", 0x00000, 0x080000, CRC(b1c5800f) SHA1(23da01d0095b741960182f8f2e336cbd74ddf87b) )
	sc_dndbe_others
ROM_END


ROM_START( sc5ddbbcb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423008.lo", 0x00001, 0x080000, CRC(90b98909) SHA1(e37f728fbd3aabeef4109778daf992314a2884a6) ) // check these belong here, the pairings were broken
	ROM_LOAD16_BYTE( "95423009.hi", 0x00000, 0x080000, CRC(38a4e959) SHA1(dd0c9c07a0eab6d77a09cae3ed78a3e034289398) ) // from  sc_dndtp   Deal Or No Deal The Power (Bellfruit)
	sc_dndbe_others
ROM_END


ROM_START( sc5ddbbcc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423094.lo", 0x00001, 0x080000, CRC(69bd6da4) SHA1(96cdc3f4a05eca4fc4f650fc1dbf9b2c20247916) )
	ROM_LOAD16_BYTE( "95423095.hi", 0x00000, 0x080000, CRC(f117c581) SHA1(cc4404b587f30e77e73860b57156ef8e57baab58) )
	sc_dndbe_others
ROM_END


ROM_START( sc5dndbei )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423138.lo", 0x00001, 0x080000, CRC(8ed1cc62) SHA1(c80dad36e8b742b9577fada6642cf76fc87ae838) )
	ROM_LOAD16_BYTE( "95423139.hi", 0x00000, 0x080000, CRC(10ddb941) SHA1(d41c6382f699a7ed7551027e62be387347a8b7b8) )
	sc_dndbe_others
ROM_END


ROM_START( sc5dndbej )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423536.lo", 0x00001, 0x080000, CRC(dadf5809) SHA1(fddb333a725ca655cbb510652f99111d57f2a0c0) )
	ROM_LOAD16_BYTE( "95423537.hi", 0x00000, 0x080000, CRC(64e96cf9) SHA1(5606fa6dc0c12aba697da8f0184c9a474d890f96) )
	sc_dndbe_others
ROM_END


ROM_START( sc5dndbek )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423864.lo", 0x00001, 0x080000, CRC(06e43774) SHA1(d01802ed4a2da78dd5c1b99890b32fb582ba745e) )
	ROM_LOAD16_BYTE( "95423865.hi", 0x00000, 0x080000, CRC(18f40e09) SHA1(8e3be8b84ed0833c9306e17d14bc3784babc1153) )
	sc_dndbe_others
ROM_END


ROM_START( sc5dndbel )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95423888.lo", 0x00001, 0x080000, CRC(45dbf280) SHA1(6e6226984c7ad4cee3021cd50c7d853fee51d1cd) )
	ROM_LOAD16_BYTE( "95423889.hi", 0x00000, 0x080000, CRC(2184fc7d) SHA1(6b08cd6b3d8e860c3d73181a8ced7b26ecad4243) )
	sc_dndbe_others
ROM_END


ROM_START( sc5dndbem )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426148.lo", 0x00001, 0x080000, CRC(b064f517) SHA1(170b5671407f6c65c3ad41d07fa0fb616da1fb99) )
	ROM_LOAD16_BYTE( "95426149.hi", 0x00000, 0x080000, CRC(4bfc2d8d) SHA1(2333ebf2cdb9322fcd41d5d07ebbd9ecd178d8ff) )
	sc_dndbe_others
ROM_END


ROM_START( sc5dndben )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427148.lo", 0x00001, 0x080000, CRC(e28fc33c) SHA1(1658f809021e8a7993025ad0884444f1cd5aac1d) )
	ROM_LOAD16_BYTE( "95427149.hi", 0x00000, 0x080000, CRC(f01bf5b2) SHA1(e7c9a50c64210cc790cb1d14cdba785d84f9252f) )
	sc_dndbe_others
ROM_END


ROM_START( sc5ddbbcd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3063p41.hi", 0x00000, 0x080000, CRC(0b458c4a) SHA1(6983b9509136b6534c4ddd2bae171018142e8c5c) )
	ROM_LOAD16_BYTE( "p3063p41.lo", 0x00001, 0x080000, CRC(ade6c7a2) SHA1(8b7a42cf616fb7b7f93584acaecc0b405b47d020) )
	sc_dndbe_others
ROM_END


ROM_START( sc5ddbbce )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3063p51.hi", 0x00000, 0x080000, CRC(959e73df) SHA1(866dfcf64958ae2e36ba5180aa8f045d624fa817) )
	ROM_LOAD16_BYTE( "p3063p51.lo", 0x00001, 0x080000, CRC(9b4f1dd8) SHA1(4c55dd6a8e899a072d4537c78e3d1f1d4e00384f) )
	sc_dndbe_others
ROM_END


ROM_START( sc5ddbbcf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3063s41.hi", 0x00000, 0x080000, CRC(1aace185) SHA1(7b5e14dd79bd911890c1269d8400cdd1171a1011) )
	ROM_LOAD16_BYTE( "p3063s41.lo", 0x00001, 0x080000, CRC(5afa2568) SHA1(b7a5b7899f5b8464539f9a3153ab7848f5e6be8f) )
	sc_dndbe_others
ROM_END


ROM_START( sc5ddbbcg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3063s51.hi", 0x00000, 0x080000, CRC(2b55719c) SHA1(5fc9af53e2ca6fa0735d30723433e793db61fdcb) )
	ROM_LOAD16_BYTE( "p3063s51.lo", 0x00001, 0x080000, CRC(4a339c8b) SHA1(710e1ff391517dcb6122026de85ba79948d5de1f) )
	sc_dndbe_others
ROM_END






ROM_START( sc5dndbc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426508.lo", 0x00001, 0x080000, CRC(17e3bc31) SHA1(a26066e4cb4e3c0109c6bdf6fd2d0b539688b71a) )
	ROM_LOAD16_BYTE( "95426509.hi", 0x00000, 0x080000, CRC(c8c97bca) SHA1(c246af21a048beecd73739d314f76f1a50c88138) )
	sc_dndbc_others
ROM_END

ROM_START( sc5dndbca )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426656.lo", 0x00001, 0x080000, CRC(94a14d32) SHA1(3d78e7ccf70665e0668b3459655877525e3d2e29) )
	ROM_LOAD16_BYTE( "95426657.hi", 0x00000, 0x080000, CRC(35c7b6b0) SHA1(37639fc41dcf1632a76b80e404ee35fe95f23a4e) )
	sc_dndbc_others
ROM_END

ROM_START( sc5dndbcb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426704.lo", 0x00001, 0x080000, CRC(71e48612) SHA1(d64fb9b27ad705bcaef2e4ce4ae7aa35403a6c25) )
	ROM_LOAD16_BYTE( "95426705.hi", 0x00000, 0x080000, CRC(76c0a661) SHA1(78cf4b37c8e216dad1c0c67725a1181a75e51878) )
	sc_dndbc_others
ROM_END

ROM_START( sc5dndbcc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95426808.lo", 0x00001, 0x080000, CRC(bad06e32) SHA1(6a63c93ca7f9b970ee44a1314c5637c0f3f6ec6c) )
	ROM_LOAD16_BYTE( "95426809.hi", 0x00000, 0x080000, CRC(1c2f66e7) SHA1(1acffa960e5badd60021417632a0d904dd6e11c5) )
	sc_dndbc_others
ROM_END

ROM_START( sc5dndbcd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427508.lo", 0x00001, 0x080000, CRC(f06cf1c8) SHA1(745af8c14e0ed424bd124b8b12ace26e716fa36c) )
	ROM_LOAD16_BYTE( "95427509.hi", 0x00000, 0x080000, CRC(9459fce4) SHA1(4c02457468771e027b2447b4d78a2306ac975057) )
	sc_dndbc_others
ROM_END

ROM_START( sc5dndbce )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427656.lo", 0x00001, 0x080000, CRC(a4411416) SHA1(8724e8613ad00fc829e7a97a11c3a654a8c6e0a9) )
	ROM_LOAD16_BYTE( "95427657.hi", 0x00000, 0x080000, CRC(26fdcc94) SHA1(c2ac19a0fd94dd32ece5113613e51888ba3b39be) )
	sc_dndbc_others
ROM_END

ROM_START( sc5dndbcf )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427704.lo", 0x00001, 0x080000, CRC(fe58add2) SHA1(3a33665a53661e57459c5e3d75b24e87c946bd2a) )
	ROM_LOAD16_BYTE( "95427705.hi", 0x00000, 0x080000, CRC(efb27e44) SHA1(c6918bcf8bff48e935b6f4000ac7505a9381e3d9) )
	sc_dndbc_others
ROM_END

ROM_START( sc5dndbcg )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95427808.lo", 0x00001, 0x080000, CRC(c16fe4dd) SHA1(8eae8e1c26b050f195b8161edf36644cf2fc7a3a) )
	ROM_LOAD16_BYTE( "95427809.hi", 0x00000, 0x080000, CRC(88e7cb95) SHA1(35b3dfd80aedb75b997338d212ca6a5e8af5e3ed) )
	sc_dndbc_others
ROM_END

ROM_START( sc5dndbch )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3312p01.hi", 0x00000, 0x080000, CRC(f15c7ec4) SHA1(b73ac27e894cd1749f331363f94bdf5ddb2e73d5) )
	ROM_LOAD16_BYTE( "p3312p01.lo", 0x00001, 0x080000, CRC(6f6baaf4) SHA1(b2d6d2c6bda0f7d11ee70c2e3c57991de21fa5c0) )
	sc_dndbc_others
ROM_END

ROM_START( sc5dndbci )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3312p71.hi", 0x00000, 0x080000, CRC(0fa9bdcd) SHA1(cd302c1c297cae17c41b4d187169a86764f23ccf) )
	ROM_LOAD16_BYTE( "p3312p71.lo", 0x00001, 0x080000, CRC(9fd10bf5) SHA1(f1689e55469c04736ed095d7b95d8327ea179333) )
	sc_dndbc_others
ROM_END

ROM_START( sc5dndbcj )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3312s01.hi", 0x00000, 0x080000, CRC(2468a800) SHA1(3edd7645cd320f57ec92a023b97716984b8b99cf) )
	ROM_LOAD16_BYTE( "p3312s01.lo", 0x00001, 0x080000, CRC(8bbd30d7) SHA1(62ba1668e78385c1d3f595ede9debbe65711d556) )
	sc_dndbc_others
ROM_END

ROM_START( sc5dndbck )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "p3312s71.hi", 0x00000, 0x080000, CRC(9d2f60c1) SHA1(b0300c779cd0e86621ad0d04da948662c074822a) )
	ROM_LOAD16_BYTE( "p3312s71.lo", 0x00001, 0x080000, CRC(5de05c8c) SHA1(520ec4c7d9bc1d93e7a60396c1aa3b9697a57689) )
	sc_dndbc_others
ROM_END



ROM_START( sc5mowow )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95418076.lo", 0x00001, 0x080000, CRC(3a1340cd) SHA1(5567323e42a0e87abeae9a2f4433d9b64af145e9) )
	ROM_LOAD16_BYTE( "95418077.hi", 0x00000, 0x080000, CRC(73abe57d) SHA1(82deeb7a88346ad8e16e52feeb9ac81e7650b569) )
	sc_mowow_others
ROM_END

ROM_START( sc5mowowb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95419076.lo", 0x00001, 0x080000, CRC(117f4e3e) SHA1(dd712361d05ad34d58b892a3fe98e057adf14a23) )
	ROM_LOAD16_BYTE( "95419077.hi", 0x00000, 0x080000, CRC(c67ba8dd) SHA1(bd14783c59f745f2be929fa9b217563916d8a585) )
	sc_mowow_others
ROM_END


ROM_START( ad5mowow )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_REGION( 0x1000000, "adder5", ROMREGION_ERASEFF )
	ROM_LOAD( "39211346.bin", 0x0000, 0x511188, CRC(2dc41c91) SHA1(36fe572860e8bba1b8f9e0245ab6fb93ff75d3ad) )
	ROM_LOAD( "39211350.bin", 0x0000, 0x4a746f, CRC(55e3d72e) SHA1(ca793fc2fb603e12feed0869dbb53d6e2a820a76) )
	ROM_LOAD( "39211356.bin", 0x0000, 0x4a74b7, CRC(8d5b75ab) SHA1(17740100c5df334bc69a690faea39c3a97afc623) )
	ROM_LOAD( "39211508.bin", 0x0000, 0x646fd1, CRC(9e405c5a) SHA1(19598d11756fece575785bb75dd620e333b6877b) )
	ROM_LOAD( "39211509.bin", 0x0000, 0x646781, CRC(669da0d0) SHA1(e34bcd6cbb21e07e42e274c30126dd536ead908d) )
	ROM_LOAD( "39212346.bin", 0x0000, 0x511188, CRC(40e92995) SHA1(9911761b89a73156b592567385ef61f609ac40dd) )
	ROM_LOAD( "39212350.bin", 0x0000, 0x4a746f, CRC(8dd8926d) SHA1(5beee9809c4c7292c8edb410eb748b43550c19d9) )
	ROM_LOAD( "39212356.bin", 0x0000, 0x4a74b7, CRC(15a8bb77) SHA1(4a8a2f50d832ce6d3230e76e4164a0bde041ccd4) )
	ROM_LOAD( "39212508.bin", 0x0000, 0x646fcd, CRC(811c9e4c) SHA1(34b59d319d80f45c238aca9f3ec536047427cfb3) )
	ROM_LOAD( "39212509.bin", 0x0000, 0x646781, CRC(637a930a) SHA1(4ad90e242701b3beef5209e967795d632c5d39a4) )

    ROM_LOAD( "39211172.bin", 0x00000, 0x1000000, CRC(8342c383) SHA1(cc92f7ebab0a55d2a6023ca194e81ef6154563a1) ) // video casino wow
	ROM_LOAD( "39212172.bin", 0x00000, 0x1000000, CRC(3aed8e3a) SHA1(de5a3fc0d77bf4044a17f17f41ab5c953b500e81) ) // video casino wow

	ROM_LOAD( "39211351.bin", 0x00000, 0x511189, CRC(8dd8fc7d) SHA1(54a5e2887e0df095d12beb7fbe7e5fe766c116a4) )
    ROM_LOAD( "39212351.bin", 0x00000, 0x511189, CRC(38c7be05) SHA1(9d0057863fcd02b5d68717b3bbd5762131b15ed7) )

	sc_mowow_others
ROM_END


ROM_START( sc5nunsm )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416074.lo", 0x00001, 0x080000, CRC(4da36836) SHA1(1a14c21e67047714817cd8f7c2050b3f018b4deb) )
	ROM_LOAD16_BYTE( "95416075.hi", 0x00000, 0x080000, CRC(d84cb53c) SHA1(f90d71bedb95450c5eea37dc64775d5b93ae7ab2) )
	sc_nunsm_others
ROM_END

ROM_START( sc5nunsma )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417074.lo", 0x00001, 0x080000, CRC(9688de66) SHA1(e53a5225a37e0c22872be7f4613caafce752019e) )
	ROM_LOAD16_BYTE( "95417075.hi", 0x00000, 0x080000, CRC(69ae75e2) SHA1(506231981495cb432320373a81855843272cfe18) )
	sc_nunsm_others
ROM_END

ROM_START( sc5nunsmb )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95416682.lo", 0x00001, 0x080000, CRC(bc930119) SHA1(208ea184e634c054c67a03d7644539a1d59462e5) )
	ROM_LOAD16_BYTE( "95416683.hi", 0x00000, 0x080000, CRC(efb0ccf4) SHA1(2ff450b788050bb22e874b833903e09fb88aedf3) )
	sc_nunsm_others
ROM_END

ROM_START( sc5nunsmc )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95417682.lo", 0x00001, 0x080000, CRC(6f3e9dd3) SHA1(ac97685f0c964f888c7a457e8cab50282283f2eb) )
	ROM_LOAD16_BYTE( "95417683.hi", 0x00000, 0x080000, CRC(948156dc) SHA1(76db7472c8e86a8f682a2954b3e54e7b487d12b9) )
	sc_nunsm_others
ROM_END

ROM_START( sc5nunsmd )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95420446.lo", 0x00001, 0x080000, CRC(27a45977) SHA1(1e15a814fc99f4d749929f569b61f1e241cf8f91) )
	ROM_LOAD16_BYTE( "95420447.hi", 0x00000, 0x080000, CRC(b8a8fb4f) SHA1(e7792a60355f3b5ebb03b71ea1009b982ba4fab5) )
	sc_nunsm_others
ROM_END

ROM_START( sc5nunsme )
	ROM_REGION( 0x400000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD16_BYTE( "95421446.lo", 0x00001, 0x080000, CRC(73d6847d) SHA1(5886ee6c2154173a9fa0e62bbae70af2c885f56d) )
	ROM_LOAD16_BYTE( "95421447.hi", 0x00000, 0x080000, CRC(a24ee8d9) SHA1(cdef31a0a0a284bc2d6ccc44d88714ba0702bf17) )
	sc_nunsm_others
ROM_END

extern int find_project_string(running_machine &machine, int addrxor, int mode);


DRIVER_INIT_MEMBER(sc5_state,sc5)
{
	// sc5 roms always start with SC5
	UINT8 *src = machine().root_device().memregion( "maincpu" )->base();
//  printf("%02x %02x %02x %02x\n", src[0], src[1], src[2], src[3]);
	if (((src[0] == 0x20) && (src[2] == 0x43)) || ((src[1] == 0x35) && (src[3] == 0x53)))
	{
		printf("Confirmed SC5 ROM\n");
	}
	else
	{
		printf("NOT AN SC5 ROM!!!!!\n");
	}


	// there is usually a string in the rom with identification info, often also saying which sound rom should be used!
	// find it.
	int found = find_project_string(machine(), 3, 0);
	if (!found)
		printf("Normal rom pair string not found, checking mismatched / missing rom string\n");

	// help identify roms where one of the pair is missing too
	if (!found)
	{
		 found = find_project_string(machine(), 3, 1);
		 found = find_project_string(machine(), 3, 2);
	}

	if (!found)
		printf("No suitable string found\n");

}

// PR2437 28 PLAYS LATER         TEDL SOUNDS         NITH
GAME( 200?, sc5plays	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","28 Plays Later (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5playsa	,sc5plays,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","28 Plays Later (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3214 AWP ANT N DECS SNT GRAB THE ADS S5         PR3214 SNT GRAB THE ADS SOUNDS11  GRAB THE ADS  S.SITE
GAME( 200?, sc5adga		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Grab The Ads (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adgaa	,sc5adga,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Grab The Ads (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adgab	,sc5adga,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Grab The Ads (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adgac	,sc5adga,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Grab The Ads (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3214 AWP ANT N DECS GRAB THE CASH S5         PR3214 GRAB THE CASH SOUNDS11     GRAB THE CASH S.SITE
GAME( 200?, sc5adgtc	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Grab The Cash (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adgtca	,sc5adgtc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Grab The Cash (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// Z053 BANKJOB         PR000053 BANKJOB 1         BANKJOB AWP   (this numbering looks more like QPS)
GAME( 200?, sc5bjob		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bank Job (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bjoba	,sc5bjob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bank Job (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bjobb	,sc5bjob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bank Job (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bjobc	,sc5bjob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bank Job (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bjobd	,sc5bjob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bank Job (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bjobe	,sc5bjob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bank Job (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bjobf	,sc5bjob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bank Job (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bjobg	,sc5bjob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bank Job (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bjobh	,sc5bjob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bank Job (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bjobi	,sc5bjob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bank Job (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )

// PR2077KING X         KING X  MAZ BARKX SOUNDS         KING X
GAME( 200?, sc5bkngx	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Bar King X (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bkngxa	,sc5bkngx,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Bar King X (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3216 AWP BUCKANEERS SCORP5         PR3216 BUCKANEERS SOUNDS11        BUCKANEERS  S.SITE
GAME( 200?, sc5bucc		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Buccaneers (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bucca	,sc5bucc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Buccaneers (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5buccb	,sc5bucc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Buccaneers (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5buccc	,sc5bucc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Buccaneers (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5buccd	,sc5bucc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Buccaneers (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bucce	,sc5bucc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Buccaneers (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR3205 AWP BULLSEYE POUNDS FOR POINTS S5         PR3205 BULLYS PNDSFPTS SOUNDS11   POUNDS FOR POINT  S.SITE
GAME( 200?, sc5bpfpb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bullseye Pounds For Points (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bpfpba	,sc5bpfpb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bullseye Pounds For Points (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1914 AWP THREE IN A BED BULLSEYE SCORP5         PR1914 THREE I A BED B SOUNDS11   3IAB BULLSEYE S.SITE
GAME( 200?, sc5btiab	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bullseye Three In A Bed (Bellfruit) (Scorpion 5)", GAME_IS_SKELETON_MECHANICAL )

// PR1744 BULLSEYE TRIPLE         BULLSEYE TRIPLE ARCADE  PR1743 CASINO BULLSEYE SOUNDS11
GAME( 200?, sc5btrip	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bullseye Triple (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5btripa	,sc5btrip,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bullseye Triple (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2197 BUNNY MONEY         BUNNY MONEY BUNN SOUNDS         BUNNY MONEY
GAME( 200?, sc5bunny	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Bunny Money (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bunnya	,sc5bunny,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Bunny Money (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// Z054 CANNON         PR000054 CANNON 1         CANNON  AWP   (looks more like a QPS header)
GAME( 200?, sc5cbrun	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cannonball Run (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cbruna	,sc5cbrun,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cannonball Run (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1681 181104 CASH FACTOR         PR1681 CASH FACTOR 1         CASH FACTOR AWP
GAME( 200?, sc5cfact	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cash Factor (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfacta	,sc5cfact,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cash Factor (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )


// PR3204 AWP CASH OF THE TITANS S5         PR3204 CASH TITANS SOUNDS11       CASH OF TITANS  S.SITE
GAME( 200?, sc5ctit		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cash Of The Titans (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ctita	,sc5ctit,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cash Of The Titans (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2343 CASH RAIDER         RAID SOUNDS         NITH
GAME( 200?, sc5craid	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cash Raider (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5craida	,sc5craid,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cash Raider (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1610 AWP CASH VEGAS         PR1610 CASH VEGAS SOUNDS11        CASH VEGAS  S.SITE
GAME( 200?, sc5cvega	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cash Vegas (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cvegaa	,sc5cvega,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cash Vegas (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2210 CHOP 'N' CHANGE         CHOP SOUNDS                  CHOP 'N' CHANGE
GAME( 200?, sc5chopc	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Chop 'n' Change (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5chopca	,sc5chopc,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Chop 'n' Change (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2422 BINGO BAR7 S5         PR1433 BAR SEVENS SOUNDS11        BAR7  S.SITE
GAME( 200?, sc5cbar7	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Classic Bar 7 (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cbar7a	,sc5cbar7,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Classic Bar 7 (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2495 CLUEDO         CLUEDO SOUNDS         CLUEDO
GAME( 200?, sc5clu70	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Cluedo 70 (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clu70a	,sc5clu70,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Cluedo 70 (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2339 CLUEDO CASINO         CLUEDO CASINO MAZ CCLU SOUNDS            GET A CLUE
GAME( 200?, sc5clcas	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo Casino (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clcasa	,sc5clcas,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo Casino (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3320 AWP CLUEDO NOTORIOUS S5         PR3320 CLUEDO SOUNDS11         CLUEDO NOTORIOUS  S.SITE
GAME( 200?, sc5clnot	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cluedo Notorious (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clnota	,sc5clnot,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cluedo Notorious (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clnotb	,sc5clnot,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cluedo Notorious (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clnotc	,sc5clnot,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cluedo Notorious (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clnotd	,sc5clnot,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cluedo Notorious (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clnote	,sc5clnot,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cluedo Notorious (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clnotf	,sc5clnot,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cluedo Notorious (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clnotg	,sc5clnot,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cluedo Notorious (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )

// PR2332 CLUEDO THE USUAL SUSPECTS         CTUS SOUNDS         CLUEDO CTUL
GAME( 200?, sc5clus		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo The Usual Suspects (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clusa	,sc5clus,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo The Usual Suspects (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clusb	,sc5clus,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo The Usual Suspects (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clusc	,sc5clus,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo The Usual Suspects (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clusd	,sc5clus,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo The Usual Suspects (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cluse	,sc5clus,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo The Usual Suspects (Mazooma) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clusf	,sc5clus,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo The Usual Suspects (Mazooma) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clusg	,sc5clus,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo The Usual Suspects (Mazooma) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clush	,sc5clus,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo The Usual Suspects (Mazooma) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clusi	,sc5clus,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo The Usual Suspects (Mazooma) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clusj	,sc5clus,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo The Usual Suspects (Mazooma) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clusk	,sc5clus,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo The Usual Suspects (Mazooma) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )



// PR3317 AWP THE COLOUR OF MONEY S5         PR3317 COLOUR OF MONEY SOUNDS11   COLOUR OF MONEY S.SITE
GAME( 200?, sc5colmo	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Colour Of Money (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5colmoa	,sc5colmo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Colour Of Money (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5colmob	,sc5colmo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Colour Of Money (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5colmoc	,sc5colmo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Colour Of Money (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

//  PR3502 AWP THE COLOUR OF MONEY NEW S5         PR3502 C OF M TEN SOUNDS11        COLOUR OF MONEY2  S.SITE
GAME( 200?, sc5newcm	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Colour Of Money New, The (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5newcma	,sc5newcm,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Colour Of Money New, The (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5newcmb	,sc5newcm,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Colour Of Money New, The (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5newcmc	,sc5newcm,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Colour Of Money New, The (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3506 AWP COPS AND ROBBERS ON THE RUN S5         PR3506 C & R ON T RUN SOUNDS11    ON THE RUN  S.SITE
GAME( 200?, sc5crotr	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers On The Run (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crotra	,sc5crotr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers On The Run (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3427 CLUB COPS N ROBBERS SMASH N GRAB SCORP5         PR3421 CNR_SNG SOUNDS11         SMASH N GRAB  CLUB
GAME( 200?, sc5crsgc	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Smash 'n' Grab Club (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crsgca	,sc5crsgc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Smash 'n' Grab Club (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
// PR3421 CLUB COPS N ROBBERS SMASH N GRAB SCORP5         PR3421 CNR_SNG SOUNDS11         SMASH N GRAB  CLUB
GAME( 200?, sc5crsgcb	,sc5crsgc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Smash 'n' Grab Club (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crsgcc	,sc5crsgc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Smash 'n' Grab Club (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

//  PR3421 CLUB COPS N ROBBERS SMASH N GRAB SCORP5         PR3421 CNR_SNG SOUNDS11         SMASH N GRAB  CLUB  (same ident as some of the sc5crsgc sets..)
GAME( 200?, sc5crsgr	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Smash 'n' Grab (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crsgra	,sc5crsgr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Smash 'n' Grab (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crsgrb	,sc5crsgr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Smash 'n' Grab (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crsgrc	,sc5crsgr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Smash 'n' Grab (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3521 AWP CORONATION STREET SCORP5         PR3521 CORRONATION ST SOUNDS11    CORONATION ST S.SITE
GAME( 200?, sc5corst	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Coronation Street (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5corsta	,sc5corst,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Coronation Street (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3417 AWP CRAZYFRUIT AND NUTCASE SCORP5         PR3417 CF NUTCASE SOUNDS11        CF& NUTCASE S.SITE
GAME( 200?, sc5cfnc		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruit & Nutcase (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfnca	,sc5cfnc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruit & Nutcase (Bellfruit) (Scorpion 5) (set 2", GAME_IS_SKELETON_MECHANICAL )

//  PR3436 CRAZY FRUITS COMMUNITY PARTY         CRAZY FRUITS CP ARCADE  PR3436 CF COMMUNITY P SOUNDS11
GAME( 200?, sc5cfcp		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Community Party (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfcpa	,sc5cfcp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Community Party (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfcpb	,sc5cfcp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Community Party (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfcpc	,sc5cfcp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Community Party (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfcpd	,sc5cfcp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Community Party (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfcpe	,sc5cfcp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Community Party (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR1359 CASINO CRAZY FRUITS PARTY         PR1359 CRAZY F PARTY SOUNDS11
GAME( 200?, sc5cfpt		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfpta	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfptb	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfptc	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfptd	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfpte	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfptf	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfptg	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfpth	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfpti	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
// PR1359 CASINO CRAZY FRUITS PARTY         PR1359 TB CRAZY F P SOUNDS11
GAME( 200?, sc5cfptj	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfptk	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfptl	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfptm	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
// PR1430 CASINO CRAZY FRUITS SIT DOWN         PR1430 CRAZY F SIT D SOUNDS11
GAME( 200?, sc5cfptn	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfpto	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfptp	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfptq	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfptr	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 19)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cfpts	,sc5cfpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Fruits Casino Party Time (Bellfruit) (Scorpion 5) (set 20)", GAME_IS_SKELETON_MECHANICAL )




// PR3418 AWP CRAZY KNIGHTS SCORP5         PR3418 CRAZY KNIGHTS SOUNDS11     CRAZY KNIGHTS S.SITE
GAME( 200?, sc5cknig	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Knights (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ckniga	,sc5cknig,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Knights (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1741 CRAZY PAYS SCORP5         PR1741 CRAZY PAYS SOUNDS11        CRAZY PAYS  S.SITE
GAME( 200?, sc5cpays	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Pays (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cpaysa	,sc5cpays,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Pays (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3409 AWP DEAL OR NO DEAL BANKERS BONUS S5         PR3409 BANKERS BONUS SOUNDS11     BANKERS BONUS S.SITE
GAME( 200?, sc5dndbo	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Banker's Bonus (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndboa	,sc5dndbo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Banker's Bonus (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbob	,sc5dndbo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Banker's Bonus (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndboc	,sc5dndbo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Banker's Bonus (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbod	,sc5dndbo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Banker's Bonus (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndboe	,sc5dndbo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Banker's Bonus (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbof	,sc5dndbo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Banker's Bonus (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbog	,sc5dndbo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Banker's Bonus (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndboh	,sc5dndbo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Banker's Bonus (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndboi	,sc5dndbo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Banker's Bonus (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )

// PR3068 CLUB BEAT THE BANKER         BEAT THE BANKER CLUB  PR3068 BEAT THE BANKER SOUNDS11
GAME( 200?, sc5dndbl	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbla	,sc5dndbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndblb	,sc5dndbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndblc	,sc5dndbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbld	,sc5dndbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndble	,sc5dndbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndblf	,sc5dndbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndblg	,sc5dndbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndblh	,sc5dndbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbli	,sc5dndbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndblj	,sc5dndbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndblk	,sc5dndbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbll	,sc5dndbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndblm	,sc5dndbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbln	,sc5dndbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndblo	,sc5dndbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Club (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )

// these contain no 'PROJECT NUMBER' ident string.
GAME( 200?, sc5dndbq	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Deal Or No Deal Beat The Banker (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbqa	,sc5dndbq,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Deal Or No Deal Beat The Banker (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbqb	,sc5dndbq,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Deal Or No Deal Beat The Banker (Qps) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbqc	,sc5dndbq,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Deal Or No Deal Beat The Banker (Qps) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbqd	,sc5dndbq,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Deal Or No Deal Beat The Banker (Qps) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbqe	,sc5dndbq,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Deal Or No Deal Beat The Banker (Qps) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR3503 AWP DEAL OR NO DEAL COPS AND ROBBERS S5         PR3503 DOND CNR SOUNDS11         DOND COPS S.SITE
GAME( 200?, sc5dndcr	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Cops 'n' Robbers (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcra	,sc5dndcr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Cops 'n' Robbers (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcrb	,sc5dndcr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Cops 'n' Robbers (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcrc	,sc5dndcr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Cops 'n' Robbers (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3545 AWP DESERT ISLAND DEAL S5         PR3545 DOND D I D SOUNDS11        DESERT ISLAND DL  S.SITE
GAME( 200?, sc5dndde	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Desert Island Deal (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddea	,sc5dndde,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Desert Island Deal (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3420 AWP DIAMOND DOND S5         PR3420 DIAMOND DOND SOUNDS11      DIAMOND DOND  S.SITE
GAME( 200?, sc5dnddi	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Diamond (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddia	,sc5dnddi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Diamond (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddib	,sc5dnddi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Diamond (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddic	,sc5dnddi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Diamond (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3313 AWP DEAL OR NO DEAL DOUBLE TAKE S5         PR3313 DOUBLE TAKE SOUNDS11       DOUBLE TAKE S.SITE
GAME( 200?, sc5dnddt	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Take (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddta	,sc5dnddt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Take (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddtb	,sc5dnddt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Take (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddtc	,sc5dnddt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Take (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddtd	,sc5dnddt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Take (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddte	,sc5dnddt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Take (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddtf	,sc5dnddt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Take (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )

// PR3316 AWP DOND DREAM OFFER S5         PR3316 DREAM OFFER SOUNDS11       DREAM OFFER S.SITE
GAME( 200?, sc5dnddo	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Dream Offer (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddoa	,sc5dnddo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Dream Offer (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddob	,sc5dnddo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Dream Offer (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddoc	,sc5dnddo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Dream Offer (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )


// PR3432 AWP DEAL OR NO DEAL FEELING LUCKY SCORP5         PR3309 FEELING LUCKY SOUNDS11     FEELING LUCKY S.SITE
GAME( 200?, sc5dndfl	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Feeling Lucky (PR3432) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndfla	,sc5dndfl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Feeling Lucky (PR3432) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
// PR3309 AWP DEAL OR NO DEAL FEELING LUCKY SCORP5         PR3309 FEELING LUCKY SOUNDS11     FEELING LUCKY S.SITE
GAME( 200?, sc5dndflb	,sc5dndfl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Feeling Lucky (PR3309) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndflc	,sc5dndfl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Feeling Lucky (PR3309) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndfld	,sc5dndfl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Feeling Lucky (PR3309) (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndfle	,sc5dndfl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Feeling Lucky (PR3309) (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3501 AWP DEAL OR NO DEAL GAME ON SCORP5         PR3501 DOND GAME ON SOUNDS11      DOND GAME ON  S.SITE
GAME( 200?, sc5dndgo	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Game On (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndgoa	,sc5dndgo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Game On (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3310 AWP DEAL OR NO DEAL GOLD S5         PR3310 DOND GOLD SOUNDS11         DOND GOLD S.SITE
GAME( 200?, sc5dndgl	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Gold (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndgla	,sc5dndgl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Gold (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndglb	,sc5dndgl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Gold (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndglc	,sc5dndgl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Gold (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndgld	,sc5dndgl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Gold (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndgle	,sc5dndgl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Gold (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndglf	,sc5dndgl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Gold (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndglg	,sc5dndgl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Gold (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndglh	,sc5dndgl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Gold (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndgli	,sc5dndgl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Gold (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndglj	,sc5dndgl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Gold (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndglk	,sc5dndgl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Gold (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )

// PR3415 AWP DEAL OR NO DEAL LIVE THE DREAM S5         PR3415 LIVE THE DREAM SOUNDS11    LIVE THE DREAM  S.SITE
GAME( 200?, sc5dndld	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Live The Dream (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlda	,sc5dndld,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Live The Dream (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3407 AWP DEAL OR NO DEAL MAKE OR BREAK S5         PR3407 MAKE OR BREAK SOUNDS11     MAKE OR BREAK S.SITE
GAME( 200?, sc5dndmb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Make Or Break (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmba	,sc5dndmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Make Or Break (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmbb	,sc5dndmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Make Or Break (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmbc	,sc5dndmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Make Or Break (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmbd	,sc5dndmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Make Or Break (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmbe	,sc5dndmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Make Or Break (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmbf	,sc5dndmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Make Or Break (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmbg	,sc5dndmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Make Or Break (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmbh	,sc5dndmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Make Or Break (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmbi	,sc5dndmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Make Or Break (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmbj	,sc5dndmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Make Or Break (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmbk	,sc5dndmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Make Or Break (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )

// PR3411 AWP MEGA DEAL OR NO DEAL S5         PR3411 MEGA DOND SOUNDS11         MEGA DOND S.SITE
GAME( 200?, sc5dndmd	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Mega Deal Or No Deal (PR3411) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmda	,sc5dndmd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Mega Deal Or No Deal (PR3411) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmdd	,sc5dndmd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Mega Deal Or No Deal (PR3411) (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmde	,sc5dndmd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Mega Deal Or No Deal (PR3411) (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmdf	,sc5dndmd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Mega Deal Or No Deal (PR3411) (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmdi	,sc5dndmd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Mega Deal Or No Deal (PR3411) (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
// PR3496 AWP MEGA DEAL OR NO DEAL S5         PR3411 MEGA DOND SOUNDS11         MEGA DOND S.SITE
GAME( 200?, sc5dndmdb	,sc5dndmd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Mega Deal Or No Deal (PR3496) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmdc	,sc5dndmd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Mega Deal Or No Deal (PR3496) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmdg	,sc5dndmd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Mega Deal Or No Deal (PR3496) (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndmdh	,sc5dndmd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Mega Deal Or No Deal (PR3496) (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )


// PR3404 AWP DEAL OR NO DEAL PLAY IT AGAIN SCORP5         PR3404 PLAY IT AGAIN SOUNDS11     PLAY IT AGAIN S.SITE
GAME( 200?, sc5dndpa	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Play It Again (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpaa	,sc5dndpa,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Play It Again (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpab	,sc5dndpa,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Play It Again (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpac	,sc5dndpa,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Play It Again (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )


// PR3505 AWP DEAL OR NO DEAL PLAY THE GAME S5         PR3505 PLAY THE GAME SOUNDS11     PLAY THE GAME S.SITE
GAME( 200?, sc5ddptg	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Play The Game (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ddptga	,sc5ddptg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Play The Game (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ddptgb	,sc5ddptg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Play The Game (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ddptgc	,sc5ddptg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Play The Game (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3303 AWP DEAL OR NO DEAL THE PLAYERS CHOICE SCORP5         PR3303 PLAYERS CHOICE SOUNDS11    PLAYERS CHOICE  S.SITE
GAME( 200?, sc5ddply	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Player's Choice (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ddplya	,sc5ddply,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Player's Choice (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3419 AWP DOND ROAD TO RICHES SCORP5         PR3419 ROAD TO RICHES SOUNDS11    ROAD TO RICHES  S.SITE
GAME( 200?, sc5dndrr	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Road To Riches (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrra	,sc5dndrr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Road To Riches (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrrb	,sc5dndrr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Road To Riches (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrrc	,sc5dndrr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Road To Riches (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3239 AWP SIMPLY DEAL OR NO DEAL SCORP5         PR3219 SIMPLY DOND SOUNDS11       SIMPLY DOND S.SITE
GAME( 200?, sc5dndsi	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Simply Deal Or No Deal (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndsia	,sc5dndsi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Simply Deal Or No Deal (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndsib	,sc5dndsi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Simply Deal Or No Deal (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndsic	,sc5dndsi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Simply Deal Or No Deal (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndsid	,sc5dndsi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Simply Deal Or No Deal (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )

// PR3405 AWP DEAL OR NO DEAL THE BANKER RINGS TWICE S5         PR3405 DOND BANKER SOUNDS11       DOND THE BANKER S.SITE
GAME( 200?, sc5dndrt	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Banker Rings Twice (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrta	,sc5dndrt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Banker Rings Twice (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrtb	,sc5dndrt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Banker Rings Twice (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrtc	,sc5dndrt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Banker Rings Twice (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrtd	,sc5dndrt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Banker Rings Twice (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrte	,sc5dndrt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Banker Rings Twice (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR3412 AWP DEAL OR NO DEAL THE PERFECT DEAL SCORP5         PR3412 PERFECT DEAL SOUNDS11      THE PERFECT DEAL  S.SITE
GAME( 200?, sc5dndpd	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Deal (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpda	,sc5dndpd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Deal (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpdb	,sc5dndpd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Deal (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpdc	,sc5dndpd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Deal (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3303 AWP DEAL OR NO DEAL THE PLAYERS CHOICE SCORP5         PR3303 PLAYERS CHOICE SOUNDS11    PLAYERS CHOICE  S.SITE
GAME( 200?, sc5dndpc	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Players Choice (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpca	,sc5dndpc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Players Choice (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3416 AWP DEAL OR NO DEAL THINK BIG SCORP5         PR3416 DOND THINK BIG SOUNDS11    DOND THINK BIG  S.SITE
GAME( 200?, sc5dndtb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Think Big (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtba	,sc5dndtb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Think Big (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2323 DEVIL OF A DEAL         DOAD SOUNDS         DEVIL OF A DEAL S.SITE
GAME( 200?, sc5devil	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Devil Of A Deal (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5devila	,sc5devil,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Devil Of A Deal (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5devilb	,sc5devil,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Devil Of A Deal (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5devilc	,sc5devil,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Devil Of A Deal (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3007 AWP DRAC PACK SCORP5         PR3007 DRACPACK SOUNDS11         DRAC PACK S.SITE
GAME( 200?, sc5dracp	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Drac Pack (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dracpa	,sc5dracp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Drac Pack (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3306 AWP FAMILY GUY BOOZE HOUND SCORP5         PR3306 BOOZE HOUND SOUNDS11       BOOZE HOUND S.SITE
GAME( 200?, sc5fgbh		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy Booze Hound (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fgbha	,sc5fgbh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy Booze Hound (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fgbhb	,sc5fgbh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy Booze Hound (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fgbhc	,sc5fgbh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy Booze Hound (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3301 AWP FAMILY GUY GRIFFIN PLUMBING S5         PR3301 GRIFFIN PLUMB SOUNDS11     GRIFFIN PLUMBING  S.SITE
GAME( 200?, sc5fggp		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy Griffin Plumbing (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fggpa	,sc5fggp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy Griffin Plumbing (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fggpb	,sc5fggp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy Griffin Plumbing (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fggpc	,sc5fggp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy Griffin Plumbing (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fggpd	,sc5fggp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy Griffin Plumbing (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fggpe	,sc5fggp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy Griffin Plumbing (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fggpf	,sc5fggp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy Griffin Plumbing (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fggpg	,sc5fggp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy Griffin Plumbing (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )

// PR IT FAST CASH         FASTCASHSOUND         FAST CASH
GAME( 200?, sc5fast		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Fast Cash (Qps) (Scorpion 5)", GAME_IS_SKELETON_MECHANICAL )

// PR3061 CLUB FIGHT NIGHT         FIGHT NIGHT CLUB  PR3061 CLUB FIGHT NIGHT SOUNDS11    CLUB FIGHT NIGHT
GAME( 200?, sc5fnclb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Fight Night Club (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fnclba	,sc5fnclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Fight Night Club (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fnclbb	,sc5fnclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Fight Night Club (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fnclbc	,sc5fnclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Fight Night Club (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fnclbd	,sc5fnclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Fight Night Club (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fnclbe	,sc5fnclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Fight Night Club (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR1939 FIRE N DICE         PR1919 FIRE N DICE SOUNDS11       FIRE N DICE S.SITE
GAME( 200?, sc5fdice	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Fire 'n' Dice (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fdicea	,sc5fdice,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Fire 'n' Dice (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1602 AWP FIRESTARTER SCORP5         PR1602 FIRESTARTER SOUNDS11       FIRESTARTER S.SITE
GAME( 200?, sc5fires	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Firestarter (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5firesa	,sc5fires,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Firestarter (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5firesb	,sc5fires,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Firestarter (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5firesc	,sc5fires,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Firestarter (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2418 FLASH THE CASH         FLASHCASH SOUNDS         FLASHTHECASH
GAME( 200?, sc5ftcas	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Flash The Cash (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ftcasa	,sc5ftcas,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Flash The Cash (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2319 FRUIT LOOP         FLOOP SOUNDS          FRUIT LOOP
GAME( 200?, sc5floop	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Fruit Loops (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5floopa	,sc5floop,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Fruit Loops (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1404 GET RICH QUICK         PR1404 GET RICH QUICK SOUNDS11
GAME( 200?, sc5grq		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Get Rich Quick (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5grqa		,sc5grq,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Get Rich Quick (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5grqb		,sc5grq,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Get Rich Quick (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5grqc		,sc5grq,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Get Rich Quick (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR1403 GOLD FEVER         PR1403 GOLD FEVER SOUNDS11
GAME( 200?, sc5gldfv	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Fever (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldfva	,sc5gldfv,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Fever (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldfvb	,sc5gldfv,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Fever (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldfvc	,sc5gldfv,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Fever (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldfvd	,sc5gldfv,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Fever (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldfve	,sc5gldfv,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Fever (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldfvf	,sc5gldfv,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Fever (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldfvg	,sc5gldfv,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Fever (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )


// PR3410 AWP GOLDEN GOALS SCORP5         PR3410 GOLDEN GOALS SOUNDS11      GOLDEN GOALS  S.SITE
GAME( 200?, sc5gldgo	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Golden Goals (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldgoa	,sc5gldgo,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Golden Goals (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2203 GOLDEN SPINNER         GSPINSND   (top box?)
GAME( 200?, sc5gldsp	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner (PR2203) (Mazooma) (Scorpion 5)", GAME_IS_SKELETON_MECHANICAL )
// PR2546 GOLDEN SPINNER Bingo Version 011         GSPINSND          GOLDEN SPINNER
GAME( 200?, sc5gldspa	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Bingo (011) (PR2546) (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldspb	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Bingo (011) (PR2546) (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldspc	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Bingo (011) (PR2546) (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldspe	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Bingo (011) (PR2546) (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldspg	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Bingo (011) (PR2546) (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldspi	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Bingo (011) (PR2546) (Mazooma) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldspj	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Bingo (011) (PR2546) (Mazooma) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldspk	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Bingo (011) (PR2546) (Mazooma) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldspl	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Bingo (011) (PR2546) (Mazooma) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldspm	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Bingo (011) (PR2546) (Mazooma) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldspo	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Bingo (011) (PR2546) (Mazooma) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )

// PR2546 GOLDEN SPINNER Arcade Version 061         GSPINSND          GOLDEN SPINNER
GAME( 200?, sc5gldspd	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Arcade (061) (PR2546) (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldspf	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Arcade (061) (PR2546) (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldsph	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Arcade (061) (PR2546) (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldspn	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Arcade (061) (PR2546) (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gldspp	,sc5gldsp,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Spinner Arcade (061) (PR2546) (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )


//  Z052 GRANDMASTER         PR000052 GRANDMASTER 1         GRANDMASTER AWP  (looks like a QPS header)
GAME( 200?, sc5gmclb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Grand Master Cash (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gmclba	,sc5gmclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Grand Master Cash (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gmclbb	,sc5gmclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Grand Master Cash (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gmclbc	,sc5gmclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Grand Master Cash (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2318 HI ROLLER         HIROLL SOUNDS         HIGH  ROLLER
GAME( 200?, sc5hirol	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","High Roller (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hirola	,sc5hirol,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","High Roller (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hirolb	,sc5hirol,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","High Roller (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hirolc	,sc5hirol,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","High Roller (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hirold	,sc5hirol,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","High Roller (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hirole	,sc5hirol,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","High Roller (Mazooma) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )


// PR1405 THE HULK         PR1405 THE HULK SOUNDS11
GAME( 200?, sc5hulk		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hulk, The (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hulka	,sc5hulk,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hulk, The (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hulkb	,sc5hulk,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hulk, The (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hulkc	,sc5hulk,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hulk, The (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hulkd	,sc5hulk,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hulk, The (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hulke	,sc5hulk,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hulk, The (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hulkf	,sc5hulk,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hulk, The (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hulkg	,sc5hulk,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hulk, The (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hulkh	,sc5hulk,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hulk, The (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hulki	,sc5hulk,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hulk, The (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )

// PR2316 IT'S A BULLSEYE         ITSBULLSEYE SOUNDS         IT'S A BULLSEYE
GAME( 200?, sc5iab		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","It's A Bullseye (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5iaba		,sc5iab,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","It's A Bullseye (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2450 ITALIAN JOB BTDO         ITLY SOUNDS         NITH
GAME( 200?, sc5ijbdo	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Italian Job - Blow The Doors Off (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ijbdoa	,sc5ijbdo,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Italian Job - Blow The Doors Off (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ijbdob	,sc5ijbdo,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Italian Job - Blow The Doors Off (Qps) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ijbdoc	,sc5ijbdo,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Italian Job - Blow The Doors Off (Qps) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2077KING X         KING X  MAZ BARKX SOUNDS         KING X      3
GAME( 200?, sc5kingx	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","King X (PR2077) (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5kingxa	,sc5kingx,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","King X (PR2077) (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
// PR2336KING X         KING X  MAZ BARKX SOUNDS         KING X 3P
GAME( 200?, sc5kingxc	,sc5kingx,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","King X 3P (PR2336) (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5kingxe	,sc5kingx,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","King X 3P (PR2336) (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
// PR2279 KING X TRIPLE         BARKX SOUNDS         +   +
GAME( 200?, sc5kingxb	,sc5kingx,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","King X Triple (PR2279) (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5kingxd	,sc5kingx,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","King X Triple (PR2279) (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

//  PR2344 TOSSTHEMONKEY         TOSTM SOUNDS          TOSS THE MONKEY
GAME( 200?, sc5monky	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monkey Business / Toss The Monkey (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5monkya	,sc5monky,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monkey Business / Toss The Monkey (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3431 AWP MONOPOLY BOOM OR BUST CLASSIC S5         PR3307 MPOLY BOOM OR B SOUNDS11   BOOM OR BUST  S.SITE
GAME( 200?, sc5mobob	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Boom Or Bust Classic (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5moboba	,sc5mobob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Boom Or Bust Classic (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mobobd	,sc5mobob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Boom Or Bust Classic (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mobobe	,sc5mobob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Boom Or Bust Classic (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
// PR3307 AWP MONOPOLY BOOM OR BUST S5         PR3307 MPOLY BOOM OR B SOUNDS11   BOOM OR BUST  S.SITE
GAME( 200?, sc5mobobb	,sc5mobob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Boom Or Bust (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mobobc	,sc5mobob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Boom Or Bust (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mobobf	,sc5mobob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Boom Or Bust (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mobobg	,sc5mobob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Boom Or Bust (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mobobh	,sc5mobob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Boom Or Bust (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mobobi	,sc5mobob,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Boom Or Bust (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR3504 AWP MONOPOLY AUCTION SCORP5         PR3504 MPOLY AUCTION SOUNDS11     MONO AUCTION  S.SITE
GAME( 200?, sc5mogta	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Go To Auction (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mogtaa	,sc5mogta,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Go To Auction (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mogtab	,sc5mogta,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Go To Auction (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mogtac	,sc5mogta,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Go To Auction (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3311 AWP MONOPOLY MILLIONAIRE SCORP5         PR3311 MPOLY MILL SOUNDS11        MILLIONAIRE S.SITE
GAME( 200?, sc5momil	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Millionaire (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5momila	,sc5momil,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Millionaire (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5momilb	,sc5momil,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Millionaire (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5momilc	,sc5momil,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Millionaire (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5momild	,sc5momil,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Millionaire (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5momile	,sc5momil,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Millionaire (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR1945 CLUB MONEYBAGS         MONEY BAGS  CLUB  PR1955 C M MONEYBAGS SOUNDS11       DEAL OR NO DEAL
GAME( 200?, sc5mombc	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Money Bags Club (PR1945) (Deal or No Deal?) (Mazooma) (Scorpion 5)", GAME_IS_SKELETON_MECHANICAL )

// PR2496 MONOPOLY MONEY SPINNER         MONY SOUNDS         NITH
GAME( 200?, sc5moms		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Monopoly Money Spinner (PR2496) (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5momsa	,sc5moms,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Monopoly Money Spinner (PR2496) (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5momsc	,sc5moms,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Monopoly Money Spinner (PR2496) (Qps) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5momsd	,sc5moms,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Monopoly Money Spinner (PR2496) (Qps) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
// PR2395 MONEY SPINNER         MONY SOUNDS         NITH     (== sc5monsp code?)
GAME( 200?, sc5momsb	,sc5moms,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Money Spinner (PR2395) (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5momse	,sc5moms,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Money Spinner (PR2395) (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3408 AWP MONOPOLY PROPERTY LADDER S5         PR3408 MPOLY PROP LAD SOUNDS11    PROPERTY LADDER S.SITE
GAME( 200?, sc5mopl		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Property Ladder (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mopla	,sc5mopl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Property Ladder (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5moplb	,sc5mopl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Property Ladder (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5moplc	,sc5mopl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Property Ladder (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2457 ROADTORICHES         CLUBROADTORICHES  CLUB  CRTR SOUNDS         CLUB ROAD TO RICHES
GAME( 200?, sc5mor2r	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Monopoly Road To Riches (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mor2ra	,sc5mor2r,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Monopoly Road To Riches (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2449 PR2449,MONOPOLY WA         MONOPOLY WA MAZ
GAME( 200?, sc5monwa	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Monopoly Win Again (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5monwaa	,sc5monwa,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Monopoly Win Again (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2485 CLUB MONTE CARLO OR BUST         CLUB MONTE CARLO  CLUB  CLUB MONTE SOUNDS         CLUB MONTE CARLO
GAME( 200?, sc5cmcob	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Monte Carlo Or Bust Club (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cmcoba	,sc5cmcob,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Monte Carlo Or Bust Club (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cmcobb	,sc5cmcob,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Monte Carlo Or Bust Club (Qps) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cmcobc	,sc5cmcob,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Monte Carlo Or Bust Club (Qps) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2166 NUN N ROSES          NANR SOUNDS         NUNS N ROSES
GAME( 200?, sc5nunsb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Nuns 'n' Roses (Bellfruit) (Scorpion 5)", GAME_IS_SKELETON_MECHANICAL )

// PR3315 AWP OVER THE RAINBOW SCORP5         PR3315 OV THE RAINBOW SOUNDS11    OVER THE RAINBOW  S.SITE
GAME( 200?, sc5rainb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Over The Rainbow (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rainba	,sc5rainb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Over The Rainbow (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rainbb	,sc5rainb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Over The Rainbow (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rainbc	,sc5rainb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Over The Rainbow (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rainbd	,sc5rainb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Over The Rainbow (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rainbe	,sc5rainb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Over The Rainbow (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )


// PR3015 AWP PARROTS OF THE CARIBBEAN SCORP5         PR3015 P CARIBBEAN SOUNDS11       PARROT CARIBBEAN  S.SITE
GAME( 200?, sc5parot	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Parrots Of The Caribbean (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5parota	,sc5parot,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Parrots Of The Caribbean (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5parotb	,sc5parot,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Parrots Of The Caribbean (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5parotc	,sc5parot,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Parrots Of The Caribbean (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5parotd	,sc5parot,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Parrots Of The Caribbean (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5parote	,sc5parot,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Parrots Of The Caribbean (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5parotf	,sc5parot,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Parrots Of The Caribbean (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5parotg	,sc5parot,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Parrots Of The Caribbean (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )


// PR2411 PILEONTHEPOUNDS         PILE SOUNDS          PILE
GAME( 200?, sc5pilep	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Pile On The Pounds (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5pilepa	,sc5pilep,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Pile On The Pounds (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5pilepb	,sc5pilep,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Pile On The Pounds (Qps) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5pilepc	,sc5pilep,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Pile On The Pounds (Qps) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )


// PR2306 POTS OF LUCK         POTSOFLUCKSOUNDS          POTS  OF  LUCK
GAME( 200?, sc5potsm	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pots Of Luck (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5potsma	,sc5potsm,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pots Of Luck (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3528 CLUB PUBLIC ENEMY S5         PR3528 PUBLIC ENEMY SOUNDS11      PUBLIC ENEMY  S.SITE
GAME( 200?, sc5cpen1	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Public Enemy No1 Club (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cpen1a	,sc5cpen1,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Public Enemy No1 Club (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1406 QUALITY STREAK         PR1406 QUALITY STREAK SOUNDS11
GAME( 200?, sc5qual		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Quality Streak (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5quala	,sc5qual,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Quality Streak (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5qualb	,sc5qual,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Quality Streak (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5qualc	,sc5qual,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Quality Streak (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5quald	,sc5qual,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Quality Streak (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5quale	,sc5qual,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Quality Streak (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5qualf	,sc5qual,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Quality Streak (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5qualg	,sc5qual,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Quality Streak (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5qualh	,sc5qual,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Quality Streak (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5quali	,sc5qual,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Quality Streak (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5qualj	,sc5qual,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Quality Streak (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5qualk	,sc5qual,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Quality Streak (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5quall	,sc5qual,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Quality Streak (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5qualm	,sc5qual,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Quality Streak (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )

//  PR2169 REEL SPIN SHADY         TRSS SOUNDS                  REEL SPIN SHADY
GAME( 200?, sc5rssh		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Reel Spin Shady (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rssha	,sc5rssh,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Reel Spin Shady (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )


// PR3208 AWP ROAD HOG S5         PR3208 ROAD HOG SOUNDS11         ROAD HOG  S.SITE
GAME( 200?, sc5hog		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Road Hog (PR3208) (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hoga		,sc5hog,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Road Hog (PR3208) (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3248 ROAD HOG SCORP5         ROAD HOG  CLUB  PR3248 ROAD HOG SOUNDS11             ROAD HOG
GAME( 200?, sc5rhclb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Road Hog Club (PR3248) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhclba	,sc5rhclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Road Hog Club (PR3248) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhclbb	,sc5rhclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Road Hog Club (PR3248) (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhclbc	,sc5rhclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Road Hog Club (PR3248) (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhclbd	,sc5rhclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Road Hog Club (PR3248) (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhclbe	,sc5rhclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Road Hog Club (PR3248) (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR1774 181104 SHARP SHOOTER         PR1774 SHARP SHOOTER 1         SHARP SHOOTER AWP
GAME( 200?, sc5sharp	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Voodoo","Sharp Shooter (Voodoo) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5sharpa	,sc5sharp,	sc5, sc5, sc5_state, sc5, ROT0, "Voodoo","Sharp Shooter (Voodoo) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// Z056 SHOOTSTARS         PR000056 SHOOTSTARS 1         SHOOTSTARS  AWP  (Qps header?)
GAME( 200?, sc5sfts		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Shoot For The Stars (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5sftsa	,sc5sfts,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Shoot For The Stars (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5sftsb	,sc5sfts,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Shoot For The Stars (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5sftsc	,sc5sfts,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Shoot For The Stars (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2466 SNAKE RATTLE AND ROLL         SNAKERR SOUNDS         SNAKE R AND ROLL
GAME( 200?, sc5srrqp	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Snake Rattle & Roll (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5srrqpa	,sc5srrqp,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Snake Rattle & Roll (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3223 AWP SPINIT TO WINIT S5         PR3203 SPIN IT TO W IT SOUNDS11   SPINIT TO WINIT S.SITE
GAME( 200?, sc5sitwi	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Spin It To Win It (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5sitwia	,sc5sitwi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Spin It To Win It (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2205 SPINNING AROUND         SPIN SOUNDS                 SPINNING AROUND
GAME( 200?, sc5spnrn	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Spinning Around (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5spnrna	,sc5spnrn,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Spinning Around (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR0003 RACE02
GAME( 200?, sc5srace	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Streak Racer (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5sracea	,sc5srace,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Streak Racer (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2355 SUPER SLEUTH         SSLEUTH SOUNDS         SUPER SLEUTH
GAME( 200?, sc5sleut	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Super Sleuth (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5sleuta	,sc5sleut,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Super Sleuth (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1630 TRICK SHOT MULTI PLAYER         TRICK SHOT MULTI  ARCADE  PR1630 TRICKSHOTMULT SOUNDS11
GAME( 200?, sc5tsmp		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Trick Shot Multi Player (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tsmpa	,sc5tsmp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Trick Shot Multi Player (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1606 UP POMPAY         PR1636 UP POMPAY SOUNDS11         UP POMPAY S.SITE
GAME( 200?, sc5pompa	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Up Pompay (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5pompaa	,sc5pompa,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Up Pompay (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5pompab	,sc5pompa,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Up Pompay (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL ) // incomplete pairing

// PR2402 VAMPIREPAYER         VAMP SOUNDS          VAMP
GAME( 200?, sc5vamp		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Vampire Payer (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5vampa	,sc5vamp,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Vampire Payer (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2176 VIPER ACTIVE         VIPA SOUNDS         VIPER ACTIVE
GAME( 200?, sc5viper	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Viper Active (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5vipera	,sc5viper,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Viper Active (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2358 VIZ         VIZ SOUNDS          VIZ
GAME( 200?, sc5viz		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Viz (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5viza		,sc5viz,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Viz (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5vizb		,sc5viz,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Viz (Qps) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5vizc		,sc5viz,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Viz (Qps) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3305 AWP WACKY RACES SCORP5         PR3330 WACKY RACES SOUNDS11       WACKY RACES S.SITE
GAME( 200?, sc5wacky	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Wacky Racers (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wackya	,sc5wacky,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Wacky Racers (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wackyb	,sc5wacky,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Wacky Racers (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wackyc	,sc5wacky,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Wacky Racers (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2213 WAR OF THE WORLDS         WADS SOUNDS
GAME( 200?, sc5wotw		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","War Of The Wads (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wotwa	,sc5wotw,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","War Of The Wads (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2196  WILD REELS         WILD REELS  MAZ WIDR SOUNDS         WILD REELS
GAME( 200?, sc5wild		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Wild Reels (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wilda	,sc5wild,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Wild Reels (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2552 WIN CAN ALLEY         WINCANALLEYSND          WIN CAN ALLEY
GAME( 200?, sc5wca		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wcaa		,sc5wca,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wcad		,sc5wca,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (Qps) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wcaf		,sc5wca,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (Qps) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wcah		,sc5wca,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (Qps) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wcai		,sc5wca,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (Qps) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wcal		,sc5wca,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (Qps) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wcan		,sc5wca,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (Qps) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
// PR2552 WIN CAN ALLEY 5 pound 10p Version         WINCANALLEYSND          WIN CAN ALLEY
GAME( 200?, sc5wcab		,sc5wca,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (5 pound 10p version) (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wcae		,sc5wca,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (5 pound 10p version) (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wcaj		,sc5wca,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (5 pound 10p version) (Qps) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wcam		,sc5wca,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (5 pound 10p version) (Qps) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
// PR2552 WIN CAN ALLEY 5 pound 10p Arcade Version          WINCANALLEYSND
GAME( 200?, sc5wcac		,sc5wca,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (5 pound 10p Arcade version) (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wcag		,sc5wca,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (5 pound 10p Arcade version) (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wcak		,sc5wca,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (5 pound 10p Arcade version) (Qps) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wcao		,sc5wca,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Win Can Alley (5 pound 10p Arcade version) (Qps) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3218 AWP WOK N ROLL S5         PR3218 WOK N ROLL SOUNDS11        WOK N ROLL  S.SITE
GAME( 200?, sc5wok		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Wok n' Roll (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5woka		,sc5wok,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Wok n' Roll (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2556 RED HOT REELS         RHRL SOUNDS          RED HOT REELS
GAME( 200?, sc5rhr		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Red Hot Reels (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhra		,sc5rhr,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Red Hot Reels (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhrb		,sc5rhr,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Red Hot Reels (Qps) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhrc		,sc5rhr,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Red Hot Reels (Qps) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhrd		,sc5rhr,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Red Hot Reels (Qps) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhre		,sc5rhr,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Red Hot Reels (Qps) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR2458 CLUB SNAKE RATTLE AND ROLL         CLUB SRAR CLUB  CLUB SRAR SND         CLUB SNAKE RATTLE AND ROLL
GAME( 200?, sc5srrcl	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Snake Rattle 'n' Roll Club (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5srrcla	,sc5srrcl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Snake Rattle 'n' Roll Club (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5srrclb	,sc5srrcl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Snake Rattle 'n' Roll Club (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5srrclc	,sc5srrcl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Snake Rattle 'n' Roll Club (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3422 CLUB THE PRIZE IS RIGHT S5         PR3422 PRIZE IS RIGHT SOUNDS11    THE PRIZE IS RIGHT  S.SITE
GAME( 200?, sc5pircl	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","The Prize Is Right Club (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5pircla	,sc5pircl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","The Prize Is Right Club (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5pirclb	,sc5pircl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","The Prize Is Right Club (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5pirclc	,sc5pircl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","The Prize Is Right Club (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2457 ROADTORICHES         CLUBROADTORICHES  CLUB  CRTR SOUNDS         CLUB ROAD TO RICHES
GAME( 200?, sc5mrrcl	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Road To Riches Club (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mrrcla	,sc5mrrcl,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Road To Riches Club (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mrrclb	,sc5mrrcl,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Road To Riches Club (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mrrclc	,sc5mrrcl,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Road To Riches Club (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )



// BFGP1234..............G95427832.RAZY_.PR3436 CF COMMUNITY P SOUNDS11.   (non-standard header, seems to indicate that these are actually Crazy Fruits Community Parts?)
GAME( 200?, sc5crcpt	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Community Party (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crcpta	,sc5crcpt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Community Party (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3009 AWP ANT N DECS JIGGY BANK S5         PR3009 JIGGY BANK SOUNDS11        JIGGY BANK  S.SITE
GAME( 200?, sc5adjb		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjba	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbb	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbc	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbd	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbe	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbf	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbg	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbh	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbi	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbj	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbk	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbl	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbm	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbn	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbo	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbp	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbq	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adjbr	,sc5adjb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Jiggy Bank (Bellfruit) (Scorpion 5) (set 19)", GAME_IS_SKELETON_MECHANICAL )

// PR1920 AWP ANT N DECS WTAD S5         PR1940 ADSNT SHOWTIME SOUNDS11    ANTNDECSWTAD  S.SITE
GAME( 200?, sc5adwta	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Saturday Night Takeaway Win The Ads (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adwtaa	,sc5adwta,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Saturday Night Takeaway Win The Ads (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

//  PR2200 AROUND THE BOARD         AROU SOUNDS         AROUND THE BOARD
GAME( 200?, sc5a40		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Around The Board In 40 Days (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5a40a		,sc5a40,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Around The Board In 40 Days (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2301 BANTAM OF THE OPERA         BANTAM SOUNDS         BANTAMOFTHEOPERA
GAME( 200?, sc5bantm	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Bantam Of The Opera (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bantma	,sc5bantm,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Bantam Of The Opera (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1447 BAR7S         PR1492 CAS BAR SEVENS SOUNDS11    BAR 7S  M.SITE
GAME( 200?, sc5bar7		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bar 7's (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bar7a	,sc5bar7,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bar 7's (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3064 BINGO BAR7 S5         PR1433 BAR SEVENS SOUNDS11        BAR7  S.SITE
GAME( 200?, sc5bar7b	,sc5bar7,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bar 7's Bingo (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bar7c	,sc5bar7,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bar 7's Bingo (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bar7d	,sc5bar7,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bar 7's Bingo (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bar7e	,sc5bar7,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bar 7's Bingo (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bar7f	,sc5bar7,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bar 7's Bingo (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bar7g	,sc5bar7,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bar 7's Bingo (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR1704 AWP BATTLESHIPS AND CRUISERS         PR1704 B AND C SOUNDS11         BATTLESHIPSCRUIS  S.SITE
GAME( 200?, sc5batl		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Battleships & Cruisers (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5batla	,sc5batl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Battleships & Cruisers (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2170 BOBBY DAZZLER         BOBD SOUNDS                 BOBBY  DAZZLER
GAME( 200?, sc5bob		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Bobby Dazzler (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5boba		,sc5bob,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Bobby Dazzler (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bobb		,sc5bob,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Bobby Dazzler (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bobc		,sc5bob,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Bobby Dazzler (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )



// PR1702 AWP BULLSEYE SCORP5         PR1702 BULLSEYE SOUNDS11         BULLSEYE  S.SITE
GAME( 200?, sc5bull		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bullseye (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bulla	,sc5bull,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bullseye (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1719 AWP SUPER BULLSEYE SCORP5         PR1702 BULLSEYE SOUNDS11         SUPER BULLSEYE  S.SITE
GAME( 200?, sc5sbull	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Super Bullseye (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5sbulla	,sc5sbull,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Super Bullseye (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3318 AWP BULLSEYE 5 REELS S5         PR3318 BULLSEYE SOUNDS11         BULLSEYE  S.SITE
GAME( 200?, sc5bull5	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bullseye 5 Reels (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bull5a	,sc5bull5,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bullseye 5 Reels (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bull5b	,sc5bull5,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bullseye 5 Reels (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bull5c	,sc5bull5,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bullseye 5 Reels (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR1910 AWP BUTCH CASHIDY AND THE SUNDANCE QUID S5         PR1910 B C AND THE S Q SOUNDS11   BUTCH N SUNDANCE  S.SITE
GAME( 200?, sc5butch	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Butch Cashidy & The Sundance Quid (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5butcha	,sc5butch,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Butch Cashidy & The Sundance Quid (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5butchb	,sc5butch,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Butch Cashidy & The Sundance Quid (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5butchc	,sc5butch,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Butch Cashidy & The Sundance Quid (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5butchd	,sc5butch,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Butch Cashidy & The Sundance Quid (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5butche	,sc5butch,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Butch Cashidy & The Sundance Quid (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR2209 CABIN FEVER         CABF SOUNDS         CABIN FEVER
GAME( 200?, sc5cabin	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cabin Fever (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cabina	,sc5cabin,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cabin Fever (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cabinb	,sc5cabin,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cabin Fever (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cabinc	,sc5cabin,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cabin Fever (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2326 CARIBBEAN CASH         CABC SOUNDS         CARIBBEAN CASH
GAME( 200?, sc5cari		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Caribbean Cash (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5caria	,sc5cari,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Caribbean Cash (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5carib	,sc5cari,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Caribbean Cash (Qps) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5caric	,sc5cari,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Caribbean Cash (Qps) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5carid	,sc5cari,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Caribbean Cash (Qps) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5carie	,sc5cari,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Caribbean Cash (Qps) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5carif	,sc5cari,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Caribbean Cash (Qps) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5carig	,sc5cari,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Caribbean Cash (Qps) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )

// PR1683 BLAS14
GAME( 200?, sc5cblas	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cash Blast (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cblasa	,sc5cblas,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cash Blast (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2338 XTRAVAGANZA         XTRV SOUNDS         XTRAVAGANZA
GAME( 200?, sc5casxt	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Casino Xtravaganza  (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5casxta	,sc5casxt,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Casino Xtravaganza  (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1711 AWP CHAV IT SCORP5         PR1711 CHAV IT SOUNDS11         CHAV IT S.SITE
GAME( 200?, sc5chavi	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Chav It (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5chavia	,sc5chavi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Chav It (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5chavib	,sc5chavi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Chav It (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5chavic	,sc5chavi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Chav It (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5chavid	,sc5chavi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Chav It (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5chavie	,sc5chavi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Chav It (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR2305 CHAVVY CHASE         CHVY SOUNDS
GAME( 200?, sc5chavy	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Chavy Chase (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5chavya	,sc5chavy,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Chavy Chase (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5chavyb	,sc5chavy,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Chavy Chase (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5chavyc	,sc5chavy,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Chavy Chase (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2230 CLUEDO         CLUE SOUNDS              CLUEDO
GAME( 200?, sc5clue		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cluea	,sc5clue,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clueb	,sc5clue,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cluec	,sc5clue,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Cluedo (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR1308 COLOUR MANIA         PR1308 COLOUR MAN SOUNDS11
GAME( 200?, sc5cmani	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Colour Mania (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cmania	,sc5cmani,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Colour Mania (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cmanib	,sc5cmani,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Colour Mania (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cmanic	,sc5cmani,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Colour Mania (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR1416 COOL JEWELS         PR1416 COOL JEWELS SOUNDS11       COOL JEWELS S.SITE
GAME( 200?, sc5cj		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cool Jewels (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cja		,sc5cj,		sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cool Jewels (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cjb		,sc5cj,		sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cool Jewels (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cjc		,sc5cj,		sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cool Jewels (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cjd		,sc5cj,		sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cool Jewels (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cje		,sc5cj,		sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cool Jewels (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR1109 AWP COP THE LOT         PR1109 CTLOT SOUNDS11
GAME( 200?, sc5ctl		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cop The Lot (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ctla		,sc5ctl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cop The Lot (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ctlb		,sc5ctl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cop The Lot (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ctlc		,sc5ctl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cop The Lot (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3005 AWP COPS AND ROBBERS SAFE CRACKER S5         PR3005 SAFE CRACKER SOUNDS11      SAFE CRACKER  S.SITE
GAME( 200?, sc5crsc		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crsca	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crscb	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crscc	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crscd	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crsce	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crscf	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crscg	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crsch	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crsci	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crscj	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crsck	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crscl	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crscm	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crscn	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crsco	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crscp	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crscq	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crscr	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 19)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crscs	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 20)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crsct	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 21)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5crscu	,sc5crsc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Scorpion 5) (set 22)", GAME_IS_SKELETON_MECHANICAL )


// PROJECT NUMBER PR2252 CORONATION  ST         CORRY SOUNDS                 CORONATION  ST
GAME( 200?, sc5coro		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street (PR2252) (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5corom	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street (PR2252) (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5coroy	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street (PR2252) (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5coro0	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street (PR2252) (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
// PR2552 CORONATION ST         COROST_SINGLE         CORONATION ST
GAME( 200?, sc5coroe	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Single (PR2252) (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5corof	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Single (PR2252) (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5corog	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Single (PR2252) (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5coroh	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Single (PR2252) (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5coroq	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Single (PR2252) (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5coror	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Single (PR2252) (Mazooma) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5coros	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Single (PR2252) (Mazooma) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5corot	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Single (PR2252) (Mazooma) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
// PR2249  CORONATION ST TRIPLE          COROST SOUNDS   (top box maybe?)
GAME( 200?, sc5coroa	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple (PR2249) (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
// PR2249 CORONATION STREET         CORS  MAZ COROST_TRIPLE SOUNDS
GAME( 200?, sc5corok	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple (PR2249) (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5corol	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple (PR2249) (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5corow	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple (PR2249) (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5corox	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple (PR2249) (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
// PR2249 CORONATION STREET Arcade Version 061         COROST_TRIPLE SOUNDS          CORONATION  ST
GAME( 200?, sc5corob	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple Arcade (V061) (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5coron	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple Arcade (V061) (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
// PR2249 CORONATION STREET Arcade Version 063         COROST_TRIPLE SOUNDS          CORONATION  ST
GAME( 200?, sc5coroj	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple Arcade (V063) (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5corov	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple Arcade (V063) (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
// PR2249 CORONATION STREET Bingo Version 012         COROST_TRIPLE SOUNDS          CORONATION  ST
GAME( 200?, sc5coroc	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple Bingo (V012) (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5corod	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple Bingo (V012) (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5coroi	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple Bingo (V012) (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5coroo	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple Bingo (V012) (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5corop	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple Bingo (V012) (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5corou	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple Bingo (V012) (Mazooma) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
// PR2249 CORONATION STREET Bingo Version 013         COROST_TRIPLE SOUNDS          CORONATION  ST
GAME( 200?, sc5coroz	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple Bingo (V013) (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5coro1	,sc5coro,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Coronation Street Triple Bingo (V013) (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )




// PR1909 AWP COUNTDOWN S5         PR1909 COUNTDOWN SOUNDS11         COUNTDOWN S.SITE
GAME( 200?, sc5count	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Countdown (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5counta	,sc5count,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Countdown (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2387. T FRUIT CRAZY           T FRUIT CRAZY QPS   GOLD X TRIPLE (but contains Crazy Keys strings as well?)
GAME( 200?, sc5czfr		,0,			sc5, sc5, sc5_state, sc5, ROT0, "QPS","Fruit Crazy Triple / Crazy Keys (QPS) (Scorpion 5)", GAME_IS_SKELETON_MECHANICAL )

// PR2388 FRUIT CRAZY SINGLE FRUIT CRAZY CRZ SOUNDS      PR2388 FRUIT CRAZY FRUIT CRAZY MAZ (not a standard header)
GAME( 200?, sc5frcrz	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Fruit Crazy (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5frcrza	,sc5czfr,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Fruit Crazy (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1608 AWP CROWN JEWELS         PR1608 CROWN JEWELS SOUNDS11      CROWN JEWELS  S.SITE
GAME( 2004, sc5crnjw	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crown Jewels (PR1608) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 2004, sc5crnjwa	,sc5crnjw,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crown Jewels (PR1608) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 2004, sc5crnjwb	,sc5crnjw,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crown Jewels (PR1608) (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )

// Z055 CJEWELS         PR000055 CJEWELS 1         CJEWELS AWP
GAME( 200?, sc5cjqps	,sc5crnjw,	sc5, sc5, sc5_state, sc5, ROT0, "QPS","Crown Jewels (Z055) (QPS) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cjqpsa	,sc5crnjw,	sc5, sc5, sc5_state, sc5, ROT0, "QPS","Crown Jewels (Z055) (QPS) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cjqpsb	,sc5crnjw,	sc5, sc5, sc5_state, sc5, ROT0, "QPS","Crown Jewels (Z055) (QPS) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5cjqpsc	,sc5crnjw,	sc5, sc5, sc5_state, sc5, ROT0, "QPS","Crown Jewels (Z055) (QPS) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR1907 AWP DEAL OR NO DEAL S5         PR1907 DEAL OR NO DEAL SOUNDS11   DEALORNODEAL  S.SITE
GAME( 200?, sc5dnd		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnda		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndb		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndc		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndd		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnde		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndf		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndg		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndh		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndi		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndj		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndk		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndl		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndm		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndn		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndo		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndp		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndq		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndr		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 19)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnds		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 20)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndt		,sc5dnd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Scorpion 5) (set 21)", GAME_IS_SKELETON_MECHANICAL )


// PR1954 CASINO DOND REELS         CASINO DOND ARCADE  PR1954 CASINO DOND R SOUNDS11
GAME( 200?, sc5dndcs	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1954) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcsa	,sc5dndcs,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1954) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcsb	,sc5dndcs,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1954) (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcsc	,sc5dndcs,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1954) (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcsd	,sc5dndcs,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1954) (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcse	,sc5dndcs,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1954) (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcsf	,sc5dndcs,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1954) (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcsg	,sc5dndcs,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1954) (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcsh	,sc5dndcs,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1954) (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcsi	,sc5dndcs,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1954) (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcsj	,sc5dndcs,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1954) (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )

GAME( 200?, sc5dndc2	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL ) // PR1964 CASINO DOND MULTI         DOND MULTIPLAYER  ARCADE
GAME( 200?, sc5dndc2a	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL ) // ^^
GAME( 200?, sc5dndc2b	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL ) // ^^

GAME( 200?, sc5dndc2c	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL ) // PR1964 CASINO DOND TOP         DOND TOPBOX ARCADE  PR1964 CASINO DOND R SOUNDS11
GAME( 200?, sc5dndc2d	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL ) // ^^

GAME( 200?, sc5dndc2e	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL ) // PR1964 CASINO DOND TOP S5         DOND TOPBOX ARCADE
GAME( 200?, sc5dndc2f	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL ) // ^^
GAME( 200?, sc5dndc2g	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL ) // ^^
GAME( 200?, sc5dndc2h	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL ) // ^^
GAME( 200?, sc5dndc2i	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )// ^^
GAME( 200?, sc5dndc2j	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )// ^^
GAME( 200?, sc5dndc2k	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )// ^^
GAME( 200?, sc5dndc2l	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )// ^^
GAME( 200?, sc5dndc2m	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )// PR1964 CASINO DOND TOP S5         DOND TOPBOX ARCADE  PR1964 CASINO DOND R SOUNDS11
GAME( 200?, sc5dndc2n	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )// ^^
GAME( 200?, sc5dndc2o	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )// PR1964 CASINO DOND TOP S5         DOND TOPBOX ARCADE  PR1964 CASINO DOND SOUNDS12
GAME( 200?, sc5dndc2p	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )// ^^

GAME( 200?, sc5dndc2q	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )// PR1964 CASINO DOND MULTI         DOND MULTIPLAYER  ARCADE  PR1964 CASINO DOND R SOUNDS11
GAME( 200?, sc5dndc2r	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 19)", GAME_IS_SKELETON_MECHANICAL )// ^^
GAME( 200?, sc5dndc2s	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 20)", GAME_IS_SKELETON_MECHANICAL )// ^^
GAME( 200?, sc5dndc2t	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 21)", GAME_IS_SKELETON_MECHANICAL )// ^^
GAME( 200?, sc5dndc2u	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 22)", GAME_IS_SKELETON_MECHANICAL )// PR1964 CASINO DOND MULTI         DOND MULTIPLAYER  ARCADE  PR1964 CASINO DOND SOUNDS12
GAME( 200?, sc5dndc2v	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 23)", GAME_IS_SKELETON_MECHANICAL )// ^^
GAME( 200?, sc5dndc2w	,sc5dndc2,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1964) (Bellfruit) (Scorpion 5) (set 24)", GAME_IS_SKELETON_MECHANICAL )// PR1964 CASINO DOND MULTI         DOND MULTIPLAYER  ARCADE

GAME( 200?, sc5dndc3	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1965) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL ) // PR1965 CASINO DOND TOPBOX         CASINO DOND ARCADE  PR1965 CASINO DOND R SOUNDS11
GAME( 200?, sc5dndc3a	,sc5dndc3,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1965) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL ) // ^^
GAME( 200?, sc5dndc3b	,sc5dndc3,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1965) (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL ) // ^^
GAME( 200?, sc5dndc3c	,sc5dndc3,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Casino (PR1965) (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL ) // ^^


// PR3209 AWP DEAL OR NO DEAL BREAK THE BANK SCORP5         PR3209 BREAK THE BANK SOUNDS11    BREAK THE BANK  S.SITE
GAME( 200?, sc5dndbb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Break The Bank (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbba	,sc5dndbb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Break The Bank (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbbb	,sc5dndbb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Break The Bank (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbbc	,sc5dndbb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Break The Bank (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbbd	,sc5dndbb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Break The Bank (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbbe	,sc5dndbb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Break The Bank (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbbf	,sc5dndbb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Break The Bank (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbbg	,sc5dndbb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Break The Bank (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )

// PR???? CLUB DEAL OR NO DEAL         DEAL OR NO DEAL CLUB  PR3068 BEAT THE BANKER SOUNDS11     DEAL OR NO DEAL
GAME( 200?, sc5dndcl	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Club (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcla	,sc5dndcl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Club (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR???? CLUB DEAL OR NO DEAL         BEAT THE BANKER CLUB  PR3068 BEAT THE BANKER SOUNDS11 (there were in the Walk of Wealth sets)
GAME( 200?, sc5dndcb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Club Beat The Banker (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcba	,sc5dndcb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Club Beat The Banker (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )


// PR3215 AWP DEAL OR NO DEAL DOUBLE S5         PR3215 DOND DOUBLE SOUNDS11       DOUBLE DOND S.SITE
GAME( 200?, sc5dnddd	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Deal Or No Deal (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddda	,sc5dnddd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Deal Or No Deal (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndddb	,sc5dnddd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Deal Or No Deal (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndddc	,sc5dnddd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Deal Or No Deal (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndddd	,sc5dnddd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Deal Or No Deal (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddde	,sc5dnddd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Deal Or No Deal (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndddf	,sc5dnddd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Deal Or No Deal (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndddg	,sc5dnddd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Deal Or No Deal (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )

// PR3008 DEAL OR NO DEAL HALL OF FAME SCORP5         PR3008 HALL OF FAME SOUNDS11      HALL OF FAME  S.SITE
GAME( 200?, sc5dndhf	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfa	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfb	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfc	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfd	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfe	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhff	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfg	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfh	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfi	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfj	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfk	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfl	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfm	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfn	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfo	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfp	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfq	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfr	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 19)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndhfs	,sc5dndhf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Hall Of Fame (Bellfruit) (Scorpion 5) (set 20)", GAME_IS_SKELETON_MECHANICAL )

// PR3207 AWP DEAL OR NO DEAL ITS YOUR SHOW SCORP5         PR3207 ITS YOUR SHOW SOUNDS11     ITS YOUR SHOW S.SITE
GAME( 200?, sc5dndys	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal It's Your Show (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndysa	,sc5dndys,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal It's Your Show (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndysb	,sc5dndys,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal It's Your Show (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndysc	,sc5dndys,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal It's Your Show (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndysd	,sc5dndys,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal It's Your Show (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndyse	,sc5dndys,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal It's Your Show (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndysf	,sc5dndys,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal It's Your Show (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndysg	,sc5dndys,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal It's Your Show (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )

//  PR3232 AWP DEAL OR NO DEAL LETS PLAY DEAL OR NO DEAL SCORP5         PR3212 LETS PLAY DOND SOUNDS11    LETS PLAY DOND  S.SITE
GAME( 200?, sc5dndlp	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpa	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpb	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpc	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpd	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpe	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpf	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpg	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlph	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpi	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpj	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpk	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpl	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpm	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpn	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpo	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpp	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpq	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpr	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 19)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlps	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 20)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpt	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 21)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndlpu	,sc5dndlp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Let's Play Deal Or No Deal (Bellfruit) (Scorpion 5) (set 22)", GAME_IS_SKELETON_MECHANICAL )

// PR3201 AWP DEAL OR NO DEAL RED ALERT SCORP5         PR3201 DOND RED ALERT SOUNDS11    RED ALERT S.SITE
GAME( 200?, sc5dndra	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Red Alert (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndraa	,sc5dndra,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Red Alert (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrab	,sc5dndra,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Red Alert (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrac	,sc5dndra,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Red Alert (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrad	,sc5dndra,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Red Alert (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrae	,sc5dndra,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Red Alert (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndraf	,sc5dndra,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Red Alert (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrag	,sc5dndra,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Red Alert (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrah	,sc5dndra,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Red Alert (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrai	,sc5dndra,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Red Alert (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndraj	,sc5dndra,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Red Alert (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndrak	,sc5dndra,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Red Alert (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )


// PR3210 AWP DEAL OR NO DEAL THE BIG DEAL SCORP5         PR3210 THE BIG DEAL SOUNDS11      THE BIG DEAL  S.SITE
GAME( 200?, sc5dndbd	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Deal (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbda	,sc5dndbd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Deal (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbdb	,sc5dndbd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Deal (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbdc	,sc5dndbd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Deal (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbdd	,sc5dndbd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Deal (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbde	,sc5dndbd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Deal (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbdf	,sc5dndbd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Deal (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbdg	,sc5dndbd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Deal (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbdh	,sc5dndbd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Deal (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbdi	,sc5dndbd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Deal (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )


// PR3011 AWP DEAL OR NO DEAL THE BIG REDS S5         PR3011 THE BIG REDS SOUNDS11      THE BIG REDS  S.SITE
GAME( 200?, sc5dndbr	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbra	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrd	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrf	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrg	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrj	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrl	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrm	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrn	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbro	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrp	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrq	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrr	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrs	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrt	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbru	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrv	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrw	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3011) (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )
// PR3018 AWP DEAL OR NO DEAL THE BIG REDS S5         PR3011 THE BIG REDS SOUNDS11      THE BIG REDS  S.SITE
GAME( 200?, sc5dndbrb	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3018) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrc	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3018) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbre	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3018) (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrh	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3018) (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbri	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3018) (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbrk	,sc5dndbr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Big Reds (PR3018) (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )


// PR3017 AWP DEAL OR NO DEAL THE CRAZY CHAIR SCORP5         PR3017 CRAZY CHAIR SOUNDS11       CRAZY CHAIR S.SITE
GAME( 200?, sc5dndcc	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcca	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndccb	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndccc	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndccd	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcce	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndccf	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndccg	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcch	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcci	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndccj	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcck	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndccl	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndccm	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndccn	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcco	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndccp	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndccq	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndccr	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair (Bellfruit) (Scorpion 5) (set 19)", GAME_IS_SKELETON_MECHANICAL )

// PR3250 DOND THE CRAZY CHAIR         CRAZY CHAIR ARCADE  PR3250 THE CRAZY CHAIR SOUNDS11
GAME( 200?, sc5dndca	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair Arcade (PR3250) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcaa	,sc5dndca,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair Arcade (PR3250) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcab	,sc5dndca,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair Arcade (PR3250) (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcac	,sc5dndca,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair Arcade (PR3250) (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
// PR3362 DOND THE CRAZY CHAIR         CRAZY CHAIR ARCADE  PR3362 THE CRAZY CHAIR SOUNDS11
GAME( 200?, sc5dndcad	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair Arcade (PR3362) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndcae	,sc5dndcc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Crazy Chair Arcade (PR3362) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3013 AWP THE DEAL WHEEL S5         PR3202 THE DEAL WHEEL SOUNDS11    THE DEAL WHEEL  S.SITE
GAME( 200?, sc5dnddw	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Deal Wheel (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddwa	,sc5dnddw,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Deal Wheel (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddwb	,sc5dnddw,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Deal Wheel (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddwc	,sc5dnddw,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Deal Wheel (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddwd	,sc5dnddw,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Deal Wheel (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddwe	,sc5dnddw,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Deal Wheel (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddwf	,sc5dnddw,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Deal Wheel (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddwg	,sc5dnddw,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Deal Wheel (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddwh	,sc5dnddw,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Deal Wheel (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddwi	,sc5dnddw,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Deal Wheel (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )

// PR3014 AWP DEAL OR NO DEAL THE DREAM FACTORY SCORP5         PR3014 DREAM FACTORY SOUNDS11     DREAM FACTORY S.SITE
GAME( 200?, sc5dnddf	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Dream Factory (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddfa	,sc5dnddf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Dream Factory (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddfb	,sc5dnddf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Dream Factory (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddfc	,sc5dnddf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Dream Factory (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddfd	,sc5dnddf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Dream Factory (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddfe	,sc5dnddf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Dream Factory (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddff	,sc5dnddf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Dream Factory (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddfg	,sc5dnddf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Dream Factory (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddfh	,sc5dnddf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Dream Factory (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddfi	,sc5dnddf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Dream Factory (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddfj	,sc5dnddf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Dream Factory (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddfk	,sc5dnddf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Dream Factory (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddfl	,sc5dnddf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Dream Factory (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddfm	,sc5dnddf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Dream Factory (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dnddfn	,sc5dnddf,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Dream Factory (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )

// PR3220 AWP DEAL OR NO DEAL THE PERFECT GAME SCORP5         PR3220 DOND PERFECT SOUNDS11      THE PERFECT GAME  S.SITE
GAME( 200?, sc5dndpg	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpga	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgb	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgc	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgd	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpge	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgf	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgg	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgh	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgi	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgj	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgk	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgl	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgm	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgn	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgo	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgp	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgq	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgr	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 19)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgs	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 20)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgt	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 21)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpgu	,sc5dndpg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Scorpion 5) (set 22)", GAME_IS_SKELETON_MECHANICAL )

// PR3403 AWP CLASSIC DEAL OR NO DEAL THE PERFECT GAME SCORP5         PR3220 DOND PERFECT SOUNDS11      THE PERFECT GAME  S.SITE
GAME( 200?, sc5dndpl	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game Classic (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndpla	,sc5dndpl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game Classic (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndplb	,sc5dndpl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game Classic (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndplc	,sc5dndpl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game Classic (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )


// PR3003 AWP DOND THE POWER 5 SCORP5         PR3033 POWER FIVE SOUNDS11        DOND THE POWER 5  S.SITE
GAME( 200?, sc5dndtp	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpa	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpb	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpc	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpd	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpe	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpf	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpg	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtph	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpi	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpj	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpk	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpl	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpm	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpn	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpo	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpp	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpq	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpr	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 19)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtps	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 20)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpt	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 21)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtpu	,sc5dndtp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Power (Bellfruit) (Scorpion 5) (set 22)", GAME_IS_SKELETON_MECHANICAL )

// PR3036 AWP DEAL OR NO DEAL THE WALK OF WEALTH SCORP5         PR3006 WALK OF WEALTH SOUNDS11    WALK OF WEALTH  S.SITE
GAME( 200?, sc5dndww	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwa	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwb	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwc	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwd	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwe	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwf	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwg	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwh	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwi	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwj	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwk	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwl	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwm	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwn	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwo	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwp	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwwq	,sc5dndww,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )

// PR3026 AWP CLASSIC DEAL OR NO DEAL THE WALK OF WEALTH SCORP5         PR3006 WALK OF WEALTH SOUNDS11    WALK OF WEALTH  S.SITE
GAME( 200?, sc5dndwc	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth Classic (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwca	,sc5dndwc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth Classic (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwcb	,sc5dndwc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth Classic (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwcc	,sc5dndwc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth Classic (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwcd	,sc5dndwc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth Classic (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwce	,sc5dndwc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth Classic (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwcf	,sc5dndwc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth Classic (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwcg	,sc5dndwc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Walk Of Wealth Classic (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )

//  PR3304 DOND THINK RED S5         PR3304 THINK RED SOUNDS11         THINK RED S.SITE
GAME( 200?, sc5dndtr	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Think Red (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtra	,sc5dndtr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Think Red (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtrb	,sc5dndtr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Think Red (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtrc	,sc5dndtr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Think Red (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtrd	,sc5dndtr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Think Red (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtre	,sc5dndtr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Think Red (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtrf	,sc5dndtr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Think Red (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtrg	,sc5dndtr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Think Red (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtrh	,sc5dndtr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Think Red (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtri	,sc5dndtr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Think Red (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtrj	,sc5dndtr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Think Red (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndtrk	,sc5dndtr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Think Red (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )

// PR1962 AWP DEAL OR NO DEAL WHATS IN YOUR BOX SCORP5         PR1962 WHATS IN Y BOX SOUNDS11    WHATS IN YOUR BX  S.SITE
GAME( 200?, sc5dndwb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwba	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbb	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbc	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbd	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbe	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbf	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbg	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbh	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbi	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbj	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbk	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbl	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbm	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbn	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbo	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbp	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbq	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbr	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 19)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwbs	,sc5dndwb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box (Bellfruit) (Scorpion 5) (set 20)", GAME_IS_SKELETON_MECHANICAL )

// PR3071 CASINO DOND WIYB REELS         CASINO DOND ARCADE  PR3071 W IN YOUR BOX SOUNDS11
GAME( 200?, sc5dndwi	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box Casino (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwia	,sc5dndwi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box Casino (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwib	,sc5dndwi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box Casino (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwic	,sc5dndwi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box Casino (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwid	,sc5dndwi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box Casino (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwie	,sc5dndwi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box Casino (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwif	,sc5dndwi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box Casino (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndwig	,sc5dndwi,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal What's In Your Box Casino (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )

// PR1307 AWP DIAMOND MINE         PR1307 DIAM MINE SOUNDS11
GAME( 2002, sc5dmine	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Diamond Mine (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 2002, sc5dminea	,sc5dmine,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Diamond Mine (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 2002, sc5dmineb	,sc5dmine,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Diamond Mine (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 2002, sc5dminec	,sc5dmine,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Diamond Mine (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 2002, sc5dmined	,sc5dmine,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Diamond Mine (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 2002, sc5dminee	,sc5dmine,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Diamond Mine (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 2002, sc5dminef	,sc5dmine,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Diamond Mine (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 2002, sc5dmineg	,sc5dmine,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Diamond Mine (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 2002, sc5dmineh	,sc5dmine,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Diamond Mine (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 2002, sc5dminei	,sc5dmine,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Diamond Mine (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
// PR1307 AWP DIAMOND MINE         PR1307 DIAM MINE SOUNDS11         DIAMOND MINE  S.SITE
GAME( 2002, sc5dminej	,sc5dmine,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Diamond Mine (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 2002, sc5dminek	,sc5dmine,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Diamond Mine (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 2002, sc5dminel	,sc5dmine,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Diamond Mine (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )

// PR1394 AWP DOCTOR DOSH SCORP5         PR1309 DOCTOR DOSH SOUNDS11
GAME( 200?, sc5ddosh	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Doctor Dosh (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ddosha	,sc5ddosh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Doctor Dosh (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1716 AWP DOUGH HO HO S5         PR1716 DOUGH HO HO SOUNDS11       DOUGH HO HO S.SITE
GAME( 200?, sc5dhh		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Dough Ho Ho (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dhha		,sc5dhh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Dough Ho Ho (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dhhb		,sc5dhh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Dough Ho Ho (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dhhc		,sc5dhh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Dough Ho Ho (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dhhd		,sc5dhh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Dough Ho Ho (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dhhe		,sc5dhh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Dough Ho Ho (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dhhf		,sc5dhh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Dough Ho Ho (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dhhg		,sc5dhh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Dough Ho Ho (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL ) // incomplete pairing

// PR1615 AWP DOUGH SELECTA SCORP5         PR1615 DOUGH SELECTA SOUNDS11     DOUGH SELECTA S.SITE
GAME( 200?, sc5dough	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Dough Selecta (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dougha	,sc5dough,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Dough Selecta (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2118 DUCKS OF HAZZARD         DUCKSOFHAZZARDSND         DUCKS OF HAZZARD
GAME( 200?, sc5ducks	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Ducks Of Hazzard (Mazooma) (Scorpion 5)", GAME_IS_SKELETON_MECHANICAL )

// PR2313 EMMERDALE         EMMR SOUNDS         EMMERDALE
GAME( 200?, sc5emmer	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Emmerdale (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5emmera	,sc5emmer,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Emmerdale (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3213 AWP FAMILY GUY S5         PR3213 FAMILY GUY SOUNDS11        FAMILY GUY  S.SITE
GAME( 200?, sc5fguy		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fguya	,sc5fguy,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fguyb	,sc5fguy,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fguyc	,sc5fguy,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fguyd	,sc5fguy,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fguye	,sc5fguy,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Family Guy (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR1701 AWP FAT BOY SPIN SCORP5         PR1701 FAT BOY SPIN SOUNDS11      FAT BOY SPIN  S.SITE
GAME( 200?, sc5fbspn	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Fat Boy Spin (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fbspna	,sc5fbspn,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Fat Boy Spin (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2328 FULL METAL JACKPOT         FULLM SOUNDS         F METAL JACKPOT
GAME( 200?, sc5fmj		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Full Metal Jackpot (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5fmja		,sc5fmj,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Full Metal Jackpot (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2255 GLADIATOR         GLAD SOUNDS         GLADIATOR
GAME( 200?, sc5glad		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Gladiator (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5glada	,sc5glad,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Gladiator (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gladb	,sc5glad,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Gladiator (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gladc	,sc5glad,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Gladiator (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR3509 AWP GOLD DIGGER SCORP5         PR3509 GOLD DIGGER SOUNDS11       GOLD DIGGER S.SITE
GAME( 200?, sc5gd		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Digger (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gda		,sc5gd,		sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Digger (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2325 GOLD DIGGERS         GOLD SOUNDS         GOLD DIGGERS
GAME( 200?, sc5gdmz		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Gold Diggers (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gdmza	,sc5gdmz,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Gold Diggers (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1137 CLUB GOLD DIGGER         CLUB GOLD DIGGER  CLUB  PR1137 GOLDD CL SOUNDS11
GAME( 200?, sc5gdclb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Digger Club (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gdclba	,sc5gdclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Digger Club (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gdclbb	,sc5gdclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Digger Club (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gdclbc	,sc5gdclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Digger Club (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gdclbd	,sc5gdclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Digger Club (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gdclbe	,sc5gdclb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Digger Club (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR1604 AWP GOLDEN BALLS         PR1604 GOLDEN BALLS SOUNDS12      GOLDEN BALLS  S.SITE (same as the sc5 version)
GAME( 200?, sc5gball	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Golden Balls (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gballa	,sc5gball,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Golden Balls (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gballb	,sc5gball,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Golden Balls (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gballc	,sc5gball,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Golden Balls (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2208  GOLDEN GAME PLASMA         GOLDEN GAME MAZ BARX SOUNDS
GAME( 200?, sc5ggame	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Game (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ggamea	,sc5ggame,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Game (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ggameb	,sc5ggame,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Game (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ggamec	,sc5ggame,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Game (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ggamed	,sc5ggame,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Game (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )

GAME( 200?, sc5ggg		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Grand Golden Game (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL ) // PR2371 GRAND GOLDEN GAME         GRAND GOLDEN GAM  MAZ    (  GOLD X TRIPLE
GAME( 200?, sc5ggga		,sc5ggg,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Grand Golden Game (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL ) // ^^
GAME( 200?, sc5gggb		,sc5ggg,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Grand Golden Game (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL ) // PR2353 GRAND GOLDEN GAME         GRAND GOLDEN GAM  MAZ BARX SOUNDS         GOLDEN GAME
GAME( 200?, sc5gggc		,sc5ggg,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Grand Golden Game (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL ) // ^^

// PR3016 AWP THE GUNPOWDER SLOT S5         PR3016 GUNPOWDER SLOT SOUNDS11    GUNPOWDER SLOT  S.SITE
GAME( 200?, sc5gunp		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gunpowder Slot (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gunpa	,sc5gunp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gunpowder Slot (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gunpb	,sc5gunp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gunpowder Slot (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gunpc	,sc5gunp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gunpowder Slot (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gunpd	,sc5gunp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gunpowder Slot (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gunpe	,sc5gunp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gunpowder Slot (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gunpf	,sc5gunp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gunpowder Slot (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gunpg	,sc5gunp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gunpowder Slot (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gunph	,sc5gunp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gunpowder Slot (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gunpi	,sc5gunp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gunpowder Slot (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gunpj	,sc5gunp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gunpowder Slot (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gunpk	,sc5gunp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gunpowder Slot (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5gunpl	,sc5gunp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gunpowder Slot (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )


// PR1388 AWP HAPPY NOTES SCORP5         PR1306 HAPPY NOTES SOUNDS11
GAME( 200?, sc5hapnt	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Happy Notes (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hapnta	,sc5hapnt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Happy Notes (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hapntb	,sc5hapnt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Happy Notes (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hapntc	,sc5hapnt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Happy Notes (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hapntd	,sc5hapnt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Happy Notes (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hapnte	,sc5hapnt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Happy Notes (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hapntf	,sc5hapnt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Happy Notes (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hapntg	,sc5hapnt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Happy Notes (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )

// PR1402 AWP HELLS BELLS         PR1402 HELLS BELLS SOUNDS11
GAME( 200?, sc5hellb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hells Bells (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hellba	,sc5hellb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hells Bells (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1613 AWP HILLBILLIONAIRE SCORP5         PR1613 HILLBILLIONAIRE SOUNDS11   HILLBILLIONAIRE S.SITE
GAME( 200?, sc5hill		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hill Billionaire (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hilla	,sc5hill,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hill Billionaire (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hillb	,sc5hill,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hill Billionaire (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )

// PR2176 HISSING QUID         VIPA SOUNDS         HISSING QUID
GAME( 200?, sc5hiss		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Hissing Quid (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hissa	,sc5hiss,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Hissing Quid (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hissb	,sc5hiss,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Hissing Quid (Qps) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hissc	,sc5hiss,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Hissing Quid (Qps) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR1936 AWP HOT DOG SCORP5         PR1916 HOT DOG SOUNDS11         HOT DOG S.SITE
GAME( 200?, sc5hotdg	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Dog (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotdga	,sc5hotdg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Dog (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotdgb	,sc5hotdg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Dog (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotdgc	,sc5hotdg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Dog (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotdgd	,sc5hotdg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Dog (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotdge	,sc5hotdg,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Dog (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR1733 AWP HOT ROD SCORP5         PR1713 HOT ROD SOUNDS11         HOT ROD S.SITE
GAME( 200?, sc5hotrd	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Rod (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotrda	,sc5hotrd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Rod (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3211 AWP HOT SHOT SCORP5         PR3211 HOT SHOT SOUNDS11         HOT SHOT  S.SITE
GAME( 200?, sc5hotsh	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotsha	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotshb	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotshc	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotshd	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotshe	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotshf	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotshg	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotshh	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotshi	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotshj	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotshk	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotshl	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotshm	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotshn	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotsho	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotshp	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotshq	,sc5hotsh,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Shots (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )


// PR1311 HOT WAD         PR1311 HOT WAD SOUNDS11
GAME( 200?, sc5hotwd	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Wad (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotwda	,sc5hotwd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Wad (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotwdb	,sc5hotwd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Wad (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotwdc	,sc5hotwd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Wad (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotwdd	,sc5hotwd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Wad (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotwde	,sc5hotwd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Wad (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotwdf	,sc5hotwd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Wad (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5hotwdg	,sc5hotwd,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hot Wad (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )


// PR1603 AWP IM A CELEBRITY         PR1603 IM A CELEB SOUNDS11        IM A CELEBRITY  S.SITE
GAME( 200?, sc5celeb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","I'm A Celebrity (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5celeba	,sc5celeb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","I'm A Celebrity (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5celebb	,sc5celeb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","I'm A Celebrity (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5celebc	,sc5celeb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","I'm A Celebrity (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5celebd	,sc5celeb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","I'm A Celebrity (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )

// PR2555 INNER SPIN V013         INNERSPINSND            INNER SPIN
GAME( 200?, sc5inspn	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Inner Spin (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5inspna	,sc5inspn,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Inner Spin (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2366 AWP THE ITALIAN JOB S5         PR2366 THE ITALIAN JOB SOUNDS11   ITALIAN JOB S.SITE
GAME( 200?, sc5ijob		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Italian Job (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ijoba	,sc5ijob,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Italian Job (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ijobb	,sc5ijob,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Italian Job (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ijobc	,sc5ijob,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Italian Job (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ijobd	,sc5ijob,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Italian Job (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ijobe	,sc5ijob,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Italian Job (Mazooma) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ijobf	,sc5ijob,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Italian Job (Mazooma) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ijobg	,sc5ijob,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Italian Job (Mazooma) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ijobh	,sc5ijob,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Italian Job (Mazooma) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ijobi	,sc5ijob,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Italian Job (Mazooma) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )


// PR1609 JACKPOT JOKERS         PR1609 JACKPOT JOKERS SOUNDS11    JACKPOT JOKERS  S.SITE
GAME( 200?, sc5jjok		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Jackpot Jokers (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5jjoka	,sc5jjok,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Jackpot Jokers (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2376 LITTLE DEVIL         LDEVIL SOUNDS         LITTLE DEVIL
GAME( 200?, sc5ldvl		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Little Devil (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ldvla	,sc5ldvl,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Little Devil (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ldvlb	,sc5ldvl,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Little Devil (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ldvlc	,sc5ldvl,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Little Devil (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ldvld	,sc5ldvl,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Little Devil (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ldvle	,sc5ldvl,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Little Devil (Mazooma) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR1413 AWP RETURN OF THE KING         PR1413 RETURN OF THE  SOUNDS11    RETURN OF KING  S.SITE
GAME( 200?, sc5lotrr	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Lord Of The Rings - Return Of The King (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5lotrra	,sc5lotrr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Lord Of The Rings - Return Of The King (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5lotrrb	,sc5lotrr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Lord Of The Rings - Return Of The King (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5lotrrc	,sc5lotrr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Lord Of The Rings - Return Of The King (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5lotrrd	,sc5lotrr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Lord Of The Rings - Return Of The King (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5lotrre	,sc5lotrr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Lord Of The Rings - Return Of The King (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5lotrrf	,sc5lotrr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Lord Of The Rings - Return Of The King (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5lotrrg	,sc5lotrr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Lord Of The Rings - Return Of The King (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5lotrrh	,sc5lotrr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Lord Of The Rings - Return Of The King (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5lotrri	,sc5lotrr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Lord Of The Rings - Return Of The King (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )


// PR3004 AWP MANIC MINER SCORP5         PR3004 MANIC MINER SOUNDS11       MANIC MINER S.SITE
GAME( 200?, sc5manic	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manica	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manicb	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manicc	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manicd	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manice	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manicf	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manicg	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manich	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manici	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manicj	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manick	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manicl	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manicm	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manicn	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manico	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manicp	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manicq	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manicr	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 19)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manics	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 20)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manict	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 21)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manicu	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 22)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manicv	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 23)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5manicw	,sc5manic,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Manic Miner (Bellfruit) (Scorpion 5) (set 24)", GAME_IS_SKELETON_MECHANICAL )

//  PR2282 MENTALMONEYMONSTERS         MMMO SOUNDS          MONEY MONSTERS
GAME( 200?, sc5mmm		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Mental Money Monsters (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mmma		,sc5mmm,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Mental Money Monsters (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mmmb		,sc5mmm,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Mental Money Monsters (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mmmc		,sc5mmm,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Mental Money Monsters (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR0000 MONEY MADNESS         MONM SOUNDS         MONEY MADNESS
GAME( 200?, sc5mmad		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Money Madness (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mmada	,sc5mmad,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Money Madness (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mmadb	,sc5mmad,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Money Madness (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mmadc	,sc5mmad,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Money Madness (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )


// PR2395 MONEY SPINNER         MONY SOUNDS         NITH
GAME( 200?, sc5monsp	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Money Spinner (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5monspa	,sc5monsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Money Spinner (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PROJECT NUMBER PR0_0_ MONOPOLY P_S_E_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _U_A_S_U_D_ _ _ _ _ _ _ _ _ _ _ _ _ _T_I_K_P_N_ _ _ _
GAME( 200?, sc5monop	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly (Mazooma) (Scorpion 5)", GAME_IS_SKELETON_MECHANICAL ) // incomplete pairing

GAME( 200?, sc5mcas		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Casino (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL ) // PR2372 CASINO MONOPOLY         MONO SOUNDS            CASINO MONOPOLY
GAME( 200?, sc5mcasa	,sc5mcas,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Casino (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL ) // ^^
GAME( 200?, sc5mcasb	,sc5mcas,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Casino (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL ) // PR2372 CASINO MONOPOLY         CASINO MONOPOLY MAZ MONO SOUNDS         CASINO MONOPOLY
GAME( 200?, sc5mcasc	,sc5mcas,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Casino (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL ) // ^^

// PR3308 AWP MONOPOLY DOUBLE MONEY S5         PR3308 MPOLY D MONEY SOUNDS11     DOUBLE MONEY  S.SITE
GAME( 200?, sc5mdm		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Double Money (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mdma		,sc5mdm,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Double Money (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mdmb		,sc5mdm,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Double Money (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mdmc		,sc5mdm,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Double Money (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2380 MONOPOLY HERE AND NOW         MR2R SOUNDS         NITH
GAME( 200?, sc5mhn		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Here & Now (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mhna		,sc5mhn,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Here & Now (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mhnb		,sc5mhn,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Here & Now (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mhnc		,sc5mhn,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Here & Now (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mhnd		,sc5mhn,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Here & Now (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mhne		,sc5mhn,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Here & Now (Mazooma) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

//  PR2345 AWP MONOPOLY HOT PROPERTY S5         PR2345 HOT PROPERTY SOUNDS11      HOT PROPERTY  S.SITE
GAME( 200?, sc5mhp		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Hot Property (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mhpa		,sc5mhp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Hot Property (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mhpb		,sc5mhp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Hot Property (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mhpc		,sc5mhp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Hot Property (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mhpd		,sc5mhp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Hot Property (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mhpe		,sc5mhp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Hot Property (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mhpf		,sc5mhp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Hot Property (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mhpg		,sc5mhp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Hot Property (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mhph		,sc5mhp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Hot Property (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mhpi		,sc5mhp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Hot Property (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )


// PR3413 AWP MONOPOLY MONEYBAGS S5         PR3413 MONEYBAGS SOUNDS11         MONEYBAGS S.SITE
GAME( 200?, sc5mmb		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Money Bags (PR3413) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mmba		,sc5mmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Money Bags (PR3413) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mmbb		,sc5mmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Money Bags (PR3413) (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mmbc		,sc5mmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Money Bags (PR3413) (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
// PR1911 AWP MONOLOLY MONEY BAGS SCORP5         PR1911 MPOLY MONEYBAGS SOUNDS11   MONEYBAGS S.SITE
GAME( 200?, sc5mmbd		,sc5mmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Money Bags (PR1911) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mmbe		,sc5mmb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Monopoly Money Bags (PR1911) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2363 RED HOT MONOP         RED HOT MONOPOLY  MAZ MONO SOUNDS         MONOPOLY
GAME( 200?, sc5mrh		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Red Hot (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mrha		,sc5mrh,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Red Hot (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2329 MONOPOLY ROAD TO RICHES         MR2R SOUNDS          ROAD TO RICHES
GAME( 200?, sc5mr2r		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Road To Riches (PR2329) (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mr2ra	,sc5mr2r,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Road To Riches (PR2329) (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
// PR2457 ROADTORICHES         CLUBROADTORICHES  CLUB  CRTR SOUNDS         CLUB ROAD TO RICHES
GAME( 200?, sc5mr2rb	,sc5mr2r,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Road To Riches Club (PR2457) (Mazooma) (Scorpion 5)", GAME_IS_SKELETON_MECHANICAL )

//  PR2190  MONOPOLY WOW         MONOPOLY WOW  MAZ TWOW SOUNDS
GAME( 200?, sc5mww		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Wonders Of The World (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mwwa		,sc5mww,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Wonders Of The World (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mwwb		,sc5mww,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Wonders Of The World (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mwwc		,sc5mww,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Wonders Of The World (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )


// PR3002 AWP NIGHTMARE ON ELM STREET S5         PR3002 ELM STREET SOUNDS11        NIGHTMARE ELM ST  S.SITE
GAME( 200?, sc5nmare	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","A Nightmare On Elm Street (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5nmarea	,sc5nmare,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","A Nightmare On Elm Street (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5nmareb	,sc5nmare,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","A Nightmare On Elm Street (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5nmarec	,sc5nmare,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","A Nightmare On Elm Street (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR1612 PICK OF THE PACK         PR1612 PICK OF THE PACK SOUNDS11  PICK OF THE PACK  S.SITE
GAME( 2005, sc5potp		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pick Of The Pack (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 2005, sc5potpa	,sc5potp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pick Of The Pack (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2562 PINK PANTHER         PINK SOUNDS         PINK PANTHER
GAME( 200?, sc5pp		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppa		,sc5pp,		sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppb		,sc5pp,		sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppc		,sc5pp,		sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppd		,sc5pp,		sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppe		,sc5pp,		sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther (Mazooma) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppf		,sc5pp,		sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther (Mazooma) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppg		,sc5pp,		sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther (Mazooma) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )

// PR2279  PINK PANTHER CLOUSEAUS REVENGE         REVENGE QPS REVENGE SOUNDS
GAME( 200?, sc5ppcr		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma / QPS","Pink Panther Clouseau's Revenge (Mazooma / QPS) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppcrb	,sc5ppcr,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma / QPS","Pink Panther Clouseau's Revenge (Mazooma / QPS) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppcrc	,sc5ppcr,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma / QPS","Pink Panther Clouseau's Revenge (Mazooma / QPS) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppcrd	,sc5ppcr,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma / QPS","Pink Panther Clouseau's Revenge (Mazooma / QPS) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
// PR2279 CLOUSEAUS REVENGE         REVENGE SOUNDS
GAME( 200?, sc5ppcra	,sc5ppcr,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther Clouseau's Revenge (Mazooma) (Scorpion 5)", GAME_IS_SKELETON_MECHANICAL )

// PR2407 AWP PINK PANTHER CRACK THE CODE SCORP5         PR2407 CRACK THE CODE SOUNDS11    CRACK THE CODE  S.SITE
GAME( 200?, sc5ppctc	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pink Panther Crack The Code (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppctca	,sc5ppctc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pink Panther Crack The Code (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppctcb	,sc5ppctc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pink Panther Crack The Code (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppctcc	,sc5ppctc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pink Panther Crack The Code (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppctcd	,sc5ppctc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pink Panther Crack The Code (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppctce	,sc5ppctc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pink Panther Crack The Code (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppctcf	,sc5ppctc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pink Panther Crack The Code (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppctcg	,sc5ppctc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pink Panther Crack The Code (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppctch	,sc5ppctc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pink Panther Crack The Code (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )


//  PR2330 PINK PANTHER DYM         PINK PANTHER DYM  QPS DYMN SOUNDS         PINK PANTHER DYM
GAME( 200?, sc5ppdym	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma / QPS","Pink Panther Double Your Money (Mazooma / QPS) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppdyma	,sc5ppdym,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma / QPS","Pink Panther Double Your Money (Mazooma / QPS) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2303 STRIKES AGAIN         PPSA SOUNDS         STRIKES AGAIN
GAME( 200?, sc5ppsag	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther Strikes Again (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppsaga	,sc5ppsag,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther Strikes Again (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppsagb	,sc5ppsag,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther Strikes Again (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppsagc	,sc5ppsag,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther Strikes Again (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppsagd	,sc5ppsag,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther Strikes Again (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ppsage	,sc5ppsag,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther Strikes Again (Mazooma) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )


// PR1408 PONY EXPRESS         PR1408 PONY EXPRESS SOUNDS11      PONY EXPRESS  S.SITE
GAME( 200?, sc5pony		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pony Express (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ponya	,sc5pony,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pony Express (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ponyb	,sc5pony,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pony Express (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ponyc	,sc5pony,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pony Express (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ponyd	,sc5pony,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pony Express (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )

// PR2417 AWP POPEYE S5         PR2417 POPEYE SOUNDS11         POPEYE  S.SITE
GAME( 200?, sc5popey	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Popeye (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5popeya	,sc5popey,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Popeye (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5popeyb	,sc5popey,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Popeye (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5popeyc	,sc5popey,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Popeye (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR1918 AWP POTS OF GOLD SCORP5         PR1918 POTS OF GOLD SOUNDS11      POTS OF GOLD  S.SITE
GAME( 200?, sc5pog		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pots Of Gold (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5poga		,sc5pog,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pots Of Gold (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5pogb		,sc5pog,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pots Of Gold (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5pogc		,sc5pog,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pots Of Gold (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5pogd		,sc5pog,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pots Of Gold (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5poge		,sc5pog,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Pots Of Gold (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// Z050 POTOFGLD         PR000050 POTOFGLD 1         POTOFGLD  AWP
GAME( 200?, sc5potog	,0,			sc5, sc5, sc5_state, sc5, ROT0, "QPS","Pot Of Gold (QPS) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5potoga	,sc5potog,	sc5, sc5, sc5_state, sc5, ROT0, "QPS","Pot Of Gold (QPS) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5potogb	,sc5potog,	sc5, sc5, sc5_state, sc5, ROT0, "QPS","Pot Of Gold (QPS) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5potogc	,sc5potog,	sc5, sc5, sc5_state, sc5, ROT0, "QPS","Pot Of Gold (QPS) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5potogd	,sc5potog,	sc5, sc5, sc5_state, sc5, ROT0, "QPS","Pot Of Gold (QPS) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5potoge	,sc5potog,	sc5, sc5, sc5_state, sc5, ROT0, "QPS","Pot Of Gold (QPS) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5potogf	,sc5potog,	sc5, sc5, sc5_state, sc5, ROT0, "QPS","Pot Of Gold (QPS) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5potogg	,sc5potog,	sc5, sc5, sc5_state, sc5, ROT0, "QPS","Pot Of Gold (QPS) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )

// PR2272 POWER PLAY         PPLY SOUNDS
GAME( 200?, sc5pwrpl	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Power Play (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5pwrpla	,sc5pwrpl,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Power Play (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1614 AWP POWERBALL         POWERBALL S.SITE  PR1614 POWERBALL SOUNDS11
GAME( 200?, sc5pwrbl	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Powerball (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5pwrbla	,sc5pwrbl,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Powerball (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2342 QUID VICIOUS         QUIDV SOUNDS         QUID VICIOUS
GAME( 200?, sc5quidv	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Quid Vicious (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5quidva	,sc5quidv,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Quid Vicious (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5quidvb	,sc5quidv,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Quid Vicious (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5quidvc	,sc5quidv,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Quid Vicious (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5quidvd	,sc5quidv,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Quid Vicious (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5quidve	,sc5quidv,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Quid Vicious (Mazooma) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5quidvf	,sc5quidv,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Quid Vicious (Mazooma) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5quidvg	,sc5quidv,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Quid Vicious (Mazooma) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )


// PR2077 RED HOT X         SDRDX SOUNDS
GAME( 200?, sc5rhx		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Red Hot X (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
// PR2077  RED HOT X         SDRDX SOUNDS
GAME( 200?, sc5rhxa		,sc5rhx,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Red Hot X (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhxb		,sc5rhx,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Red Hot X (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhxc		,sc5rhx,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Red Hot X (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhxd		,sc5rhx,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Red Hot X (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhxe		,sc5rhx,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Red Hot X (Mazooma) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhxf		,sc5rhx,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Red Hot X (Mazooma) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )


// PR2364 CASINO RED HOT X         RED HOT X CRHX SOUNDS         RED HOT X
GAME( 200?, sc5rhxcs	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Red Hot X Casino (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rhxcsa	,sc5rhxcs,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Red Hot X Casino (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2557 RED SQUARE         REDS SOUNDS            RED SQUARE
GAME( 200?, sc5redsq	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Red Square (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5redsqa	,sc5redsq,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Red Square (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3257 CLUB RONNIE O SULLIVANS TOURNAMENT SCORP5         RONNIE OSULLIVAN  CLUB  PR3256 RONNIE O SOUNDS11         RONNIE SULLIVAN
GAME( 200?, sc5rosts	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ronnie O'Sullivan's Tournament Snooker (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rostsa	,sc5rosts,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ronnie O'Sullivan's Tournament Snooker (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rostsb	,sc5rosts,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ronnie O'Sullivan's Tournament Snooker (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rostsc	,sc5rosts,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ronnie O'Sullivan's Tournament Snooker (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rostsd	,sc5rosts,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ronnie O'Sullivan's Tournament Snooker (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rostse	,sc5rosts,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ronnie O'Sullivan's Tournament Snooker (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR2311 ROVERS RETURN         ROVERS RETURN SOUNDS         ROVERS RETURN
GAME( 200?, sc5rovrt	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Rovers Return (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rovrta	,sc5rovrt,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Rovers Return (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rovrtb	,sc5rovrt,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Rovers Return (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5rovrtc	,sc5rovrt,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Rovers Return (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2280 SHOW ME THE MONEY         SMTM SOUNDS
GAME( 200?, sc5smtm		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Show Me The Money (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5smtma	,sc5smtm,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Show Me The Money (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3013 AWP SHOW TIME S5         PR3013 SHOWTIME SOUNDS11         SHOW TIME S.SITE
GAME( 200?, sc5showt	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showta	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showtb	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showtc	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showtd	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showte	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showtf	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showtg	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showth	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showti	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showtj	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showtk	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showtl	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showtm	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showtn	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showto	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showtp	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5showtq	,sc5showt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Showtime (Bellfruit) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )

// PR1411 AWP SNAKES AND LADDERS         PR1411 SNAKES A L SOUNDS11
GAME( 200?, sc5slad		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Snakes & Ladders (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5slada	,sc5slad,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Snakes & Ladders (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5sladb	,sc5slad,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Snakes & Ladders (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5sladc	,sc5slad,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Snakes & Ladders (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
// PR1411 AWP SNAKES AND LADDERS         PR1411 SNAKES A L SOUNDS11        SNAKES N LADDERS  S.SITE
GAME( 200?, sc5sladd	,sc5slad,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Snakes & Ladders (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5slade	,sc5slad,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Snakes & Ladders (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5sladf	,sc5slad,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Snakes & Ladders (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5sladg	,sc5slad,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Snakes & Ladders (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )

// PR1901 AWP SPICE IT UP SCORP5         PR1901 SPICE IT UP SOUNDS11       SPICE IT UP S.SITE
GAME( 200?, sc5spice	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Spice It Up (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5spiceb	,sc5spice,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Spice It Up (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
// PR1921 AWP SPICE IT UP SCORP4         PR1901 SPICE IT UP SOUNDS11       SPICE IT UP S.SITE   (this header is incorrect, these are SCORP 5 sets, they use opcodes not present in the sc5 cpu and have the 'SC5' at the start of the ROM)
GAME( 200?, sc5spicea	,sc5spice,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Spice It Up (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5spicec	,sc5spice,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Spice It Up (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5spiced	,sc5spice,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Spice It Up (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5spicee	,sc5spice,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Spice It Up (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )



// PR2232 SPIN WHEN YOU'RE WINNING         SPIN SOUNDS
GAME( 200?, sc5swywm	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Spin When Your Winning (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5swywma	,sc5swywm,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Spin When Your Winning (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5swywmb	,sc5swywm,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Spin When Your Winning (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5swywmc	,sc5swywm,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Spin When Your Winning (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2176 SUMMIT UP         SUMMIT SOUNDS         SUMMIT UP   H
GAME( 200?, sc5sumit	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Summit Up (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5sumita	,sc5sumit,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Summit Up (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

//  PR2255 SUITUSIR         SUIT SOUNDS         SUITS U SIR
GAME( 200?, sc5sus		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Suits U Sir (Qps) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5susa		,sc5sus,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Suits U Sir (Qps) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5susb		,sc5sus,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Suits U Sir (Qps) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5susc		,sc5sus,	sc5, sc5, sc5_state, sc5, ROT0, "Qps","Suits U Sir (Qps) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2235 SWITCHBACK         SWBK SOUNDS         SWITCHBACK
GAME( 200?, sc5swbak	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Switch Back (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5swbaka	,sc5swbak,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Switch Back (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1714 AWP TAKE THE PIECE S5         PR1714 TAKE THE PIECE SOUNDS11    TAKETHEPIECE  S.SITE
GAME( 200?, sc5ttpie	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Take The Piece (Bellfruit) (PR1714) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ttpiea	,sc5ttpie,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Take The Piece (Bellfruit) (PR1714) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ttpieb	,sc5ttpie,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Take The Piece (Bellfruit) (PR1714) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ttpiec	,sc5ttpie,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Take The Piece (Bellfruit) (PR1714) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ttpied	,sc5ttpie,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Take The Piece (Bellfruit) (PR1714) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ttpiee	,sc5ttpie,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Take The Piece (Bellfruit) (PR1714) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ttpief	,sc5ttpie,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Take The Piece (Bellfruit) (PR1714) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ttpieg	,sc5ttpie,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Take The Piece (Bellfruit) (PR1714) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ttpieh	,sc5ttpie,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Take The Piece (Bellfruit) (PR1714) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ttpiei	,sc5ttpie,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Take The Piece (Bellfruit) (PR1714) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )

// PR3001 AWP TAKE YOUR PICK S5         PR3001 TAKE YOUR PICK SOUNDS11    TAKE YOUR PICK  S.SITE
GAME( 200?, sc5typ		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Take Your Pick (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5typa		,sc5typ,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Take Your Pick (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5typb		,sc5typ,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Take Your Pick (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5typc		,sc5typ,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Take Your Pick (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR2140  MONOPOLY X         SDMON SOUNDS  (are these really a game called Top Box, or are they Top Box roms for Monopoly?)
GAME( 200?, sc5tbox		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxa,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxb,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxc,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxd,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxe,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxf,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxg,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxh,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxi,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxj,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxk,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxl,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxm,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxn,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxo,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxp,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 17)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tboxq,	sc5tbox,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Box (Mazooma) (Scorpion 5) (set 18)", GAME_IS_SKELETON_MECHANICAL )



// PR2211 TOP OF THE SHOTS         TOTS SOUNDS         TOP OF THE SHOTS
GAME( 200?, sc5tpsht	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Of The Shots (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tpshta	,sc5tpsht,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Of The Shots (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tpshtb	,sc5tpsht,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Of The Shots (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tpshtc	,sc5tpsht,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Of The Shots (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5tpshtd	,sc5tpsht,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Top Of The Shots (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )

// PR2175 TRAIL BLAZER         TRAB SOUNDS                  TRAIL BLAZER
GAME( 200?, sc5trail	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Trailblazer (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5traila	,sc5trail,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Trailblazer (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR3010 AWP VIVA MEXICO SCORP5         PR3010 VIVA MEXICO SOUNDS11       VIVA MEXICO S.SITE
GAME( 200?, sc5vivam	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Viva Mexico (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5vivama	,sc5vivam,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Viva Mexico (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2341 WILD JACKPOTS         WILDJACK SOUNDS         WILD JACKPOTS
GAME( 200?, sc5wldjk	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Wild Jackpots (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5wldjka	,sc5wldjk,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Wild Jackpots (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR1611 AWP ANT AND DECS         PR1611 ANT AND DECS  SOUNDS11     ANT AND DECS  S.SITE
GAME( 200?, sc5adsnt	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Saturday Night Takeaway (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5adsnta	,sc5adsnt,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ant & Dec's Saturday Night Takeaway (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )


// PR1708 AWP BULLY'S PRIZE BOARD         PR1708 B PRIZE BOARD SOUNDS11     BULLYSPRIZEBOARD  S.SITE
GAME( 200?, sc5bpb		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Prize Board (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bpbb		,sc5bpb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Prize Board (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bpbd		,sc5bpb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Prize Board (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bpbe		,sc5bpb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Prize Board (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
// PR1708 AWP BULLY'S PRIZE BOARD S5         PR1708 B PRIZE BOARD SOUNDS11     BULLYSPRIZEBOARD  S.SITE
GAME( 200?, sc5bpba		,sc5bpb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Prize Board (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bpbc		,sc5bpb,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Prize Board (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR3010 AWP BULLYS STAR PRIZE SCORP5         PR3012 BULLYS STAR P SOUNDS11     BULLYS STARPRIZE  S.SITE
GAME( 200?, sc5bsp		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3010) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bspa		,sc5bsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3010) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bspb		,sc5bsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3010) (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bspc		,sc5bsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3010) (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bspd		,sc5bsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3010) (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bspe		,sc5bsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3010) (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bspf		,sc5bsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3010) (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bspg		,sc5bsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3010) (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bsph		,sc5bsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3010) (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bspi		,sc5bsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3010) (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bspl		,sc5bsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3010) (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bspm		,sc5bsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3010) (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bspn		,sc5bsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3010) (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bspo		,sc5bsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3010) (Bellfruit) (Scorpion 5) (set 16)", GAME_IS_SKELETON_MECHANICAL )
// PR3012 AWP BULLYS STAR PRIZE SCORP5         PR3012 BULLYS STAR P SOUNDS11     BULLYS STARPRIZE  S.SITE
GAME( 200?, sc5bspj		,sc5bsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3012) (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5bspk		,sc5bsp,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bully's Star Prize (PR3012) (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )


// PR1312 AWP CHAIN REACTION         PR1312 CHAIN REACT SOUNDS11
GAME( 200?, sc5chain	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Chain Reaction (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5chaina	,sc5chain,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Chain Reaction (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5chainb	,sc5chain,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Chain Reaction (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5chainc	,sc5chain,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Chain Reaction (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5chaind	,sc5chain,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Chain Reaction (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5chaine	,sc5chain,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Chain Reaction (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )

// PR1707 AWP CLOWN AROUND SCORP5         PR1707 CLOWN AROUND SOUNDS11      CLOWN AROUND  S.SITE
GAME( 200?, sc5clown	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Clown Around (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clowna	,sc5clown,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Clown Around (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clownb	,sc5clown,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Clown Around (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5clownc	,sc5clown,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Clown Around (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )

// PR1412 AWP COPS AND ROBBERS         PR1412 COPS AND ROBBERS SOUNDS11  COPS AND ROBBERS  S.SITE
GAME( 200?, sc5copsr	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5copsra	,sc5copsr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5copsrb	,sc5copsr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5copsrc	,sc5copsr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5copsrd	,sc5copsr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5copsre	,sc5copsr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5copsrf	,sc5copsr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5copsrg	,sc5copsr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5copsrh	,sc5copsr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5copsri	,sc5copsr,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )



// PR1915 AWP DEAL OR NO DEAL BEAT THE BANKER S5         PR1915 BEAT THE BANKER SOUNDS11   BEAT THE BANKER S.SITE
GAME( 200?, sc5dndbe	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbea	,sc5dndbe,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbeb	,sc5dndbe,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbec	,sc5dndbe,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbed	,sc5dndbe,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbee	,sc5dndbe,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbef	,sc5dndbe,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbeg	,sc5dndbe,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbeh	,sc5dndbe,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbei	,sc5dndbe,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbej	,sc5dndbe,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbek	,sc5dndbe,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbel	,sc5dndbe,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker (Bellfruit) (Scorpion 5) (set 13)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbem	,sc5dndbe,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker (Bellfruit) (Scorpion 5) (set 14)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndben	,sc5dndbe,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker (Bellfruit) (Scorpion 5) (set 15)", GAME_IS_SKELETON_MECHANICAL )

// PR3063 CASINO DOND CAN YOU BEAT THE BANKER         CASINO DOND ARCADE  PR3063 BEAT THE BANKER SOUNDS11
GAME( 200?, sc5ddbbc	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Casino (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ddbbca	,sc5ddbbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Casino (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ddbbcb	,sc5ddbbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Casino (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ddbbcc	,sc5ddbbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Casino (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ddbbcd	,sc5ddbbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Casino (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ddbbce	,sc5ddbbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Casino (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ddbbcf	,sc5ddbbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Casino (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5ddbbcg	,sc5ddbbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Beat The Banker Casino (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )


// PR3312 AWP DEAL OR NO DEAL BOX CLEVER SCORP5         PR3312 DOND BOXCLEVER SOUNDS11    BOX CLEVER  S.SITE
GAME( 200?, sc5dndbc	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Box Clever (Bellfruit) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbca	,sc5dndbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Box Clever (Bellfruit) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbcb	,sc5dndbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Box Clever (Bellfruit) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbcc	,sc5dndbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Box Clever (Bellfruit) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbcd	,sc5dndbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Box Clever (Bellfruit) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbce	,sc5dndbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Box Clever (Bellfruit) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbcf	,sc5dndbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Box Clever (Bellfruit) (Scorpion 5) (set 7)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbcg	,sc5dndbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Box Clever (Bellfruit) (Scorpion 5) (set 8)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbch	,sc5dndbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Box Clever (Bellfruit) (Scorpion 5) (set 9)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbci	,sc5dndbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Box Clever (Bellfruit) (Scorpion 5) (set 10)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbcj	,sc5dndbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Box Clever (Bellfruit) (Scorpion 5) (set 11)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5dndbck	,sc5dndbc,	sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Box Clever (Bellfruit) (Scorpion 5) (set 12)", GAME_IS_SKELETON_MECHANICAL )

// PR1706 AWP WHEEL OF WEALTH         PR1706 WHEEL OF WEALTH SOUNDS11   WHEEL OF WEALTH S.SITE
GAME( 200?, sc5mowow	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Wheel Of Wealth (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5mowowb	,sc5mowow,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Wheel Of Wealth (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )

// PR2166 NUN N ROSES          NANR SOUNDS         NUNS N ROSES
GAME( 200?, sc5nunsm	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Nuns 'n' Roses (Mazooma) (Scorpion 5) (set 1)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5nunsma	,sc5nunsm,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Nuns 'n' Roses (Mazooma) (Scorpion 5) (set 2)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5nunsmb	,sc5nunsm,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Nuns 'n' Roses (Mazooma) (Scorpion 5) (set 3)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5nunsmc	,sc5nunsm,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Nuns 'n' Roses (Mazooma) (Scorpion 5) (set 4)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5nunsmd	,sc5nunsm,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Nuns 'n' Roses (Mazooma) (Scorpion 5) (set 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, sc5nunsme	,sc5nunsm,	sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Nuns 'n' Roses (Mazooma) (Scorpion 5) (set 6)", GAME_IS_SKELETON_MECHANICAL )


// Adder 5
GAME( 200?, ad5bpfpm	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Bullseye Pounds For Points (Mazooma) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5btc		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bullseye Triple Club (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5cmons	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Crazy Money (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5dndpl	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Platinum (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5eyes		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Eyes Down (Mazooma) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5gldmn	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Gold Mine (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5gldwn	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Golden Winner (Mazooma) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5hir		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hi Roller (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5hircl	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Hi Roller Club (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5jckmo	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Jackpot Monopoly (Mazooma) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5mcob		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Monte Carlo Or Bust (Qps) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5ppbtb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther Break The Bank (Mazooma) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5pking	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Poker King (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5rsnw		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Random Spin 'n' Win (Mazooma) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5rspin	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Random Spinner (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5rsclb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Random Spinner Club (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5rwclb	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Random Winner Club (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5rapid	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Rapid Pay (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5rcash	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Reel Cash (Mazooma) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5rroul	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Reel Roulette (Mazooma) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5rsrm		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ronnie O'Sullivan's Rocket Money (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5rsrr		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Ronnie O'Sullivan's Rocket Ronnie (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5tornc	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Tornado Club (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5vpa		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Video Poker Ace (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5vlv		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Viva Las Vegas (Bellfruit) (Scorpion 5, Adder 5)", GAME_IS_SKELETON_MECHANICAL )

GAME( 200?, ad5crcpt	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Community Party (Bellfruit) (Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5bull		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Bullseye (Bellfruit) (Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5crsc		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers Safe Cracker (Bellfruit) (Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5dnd		,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal (Bellfruit) (Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5dndcl	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Club (Bellfruit) (Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5dnddd	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal Double Deal Or No Deal (Bellfruit) (Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5dndpg	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5evol		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Qps","Evolution (Qps) (Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5monop	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly (Mazooma) (Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5mr2r		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Road To Riches (Mazooma) (Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5mww		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Wonders Of The World (Mazooma) (Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5pp		,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Pink Panther (Mazooma) (Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5sslam	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Super Slam (Bellfruit) (Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5copsr	,0,			sc5, sc5, sc5_state, sc5, ROT0, "BFM","Cops 'n' Robbers (Bellfruit) (Adder 5)", GAME_IS_SKELETON_MECHANICAL )
GAME( 200?, ad5mowow	,0,			sc5, sc5, sc5_state, sc5, ROT0, "Mazooma","Monopoly Wheel Of Wealth (Mazooma) (Adder 5)", GAME_IS_SKELETON_MECHANICAL )
