<?php
/**
* @package Mambo Open Source
* @copyright (C) 2005 - 2006 Mambo Foundation Inc.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*
* Mambo was originally developed by Miro (www.miro.com.au) in 2000. Miro assigned the copyright in Mambo to The Mambo Foundation in 2005 to ensure
* that Mambo remained free Open Source software owned and managed by the community.
* Mambo is Free Software
*/

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

global $mosConfig_offset;

$count 				= intval( $params->def( 'count', 10 ) );
$moduleclass_sfx 	= $params->get( 'moduleclass_sfx' ); 
$now 				= date( 'Y-m-d H:i:s', time() + $mosConfig_offset * 60 * 60 );

$query = "SELECT MONTH(created) AS created_month, created, id, sectionid, title, YEAR(created) AS created_year"
. "\n FROM #__content"
. "\n WHERE ( state='-1' AND checked_out='0' AND sectionid > '0' )"
. "\n GROUP BY created_year DESC, created_month DESC LIMIT $count";
$database->setQuery( $query );
$rows = $database->loadObjectList();

if (is_array($rows)) {
?>
<ul>
<?php
foreach ( $rows as $row ) {
	$created_month 	= mosFormatDate ( $row->created, "%m" );
	$month_name 	= mosFormatDate ( $row->created, "%B" );
	$created_year 	= mosFormatDate ( $row->created, "%Y" );
	$link			= sefRelToAbs( 'index.php?option=com_content&amp;task=archivecategory&amp;year='. $created_year .'&amp;month='. $created_month .'&amp;module=1' );
	$text			= $month_name .', '. $created_year;
	?>
	<li>
	<a href="<?php echo $link; ?>">
	<?php echo $text; ?>
	</a>
	</li>
	<?php
}
?>
</ul>
<?php
}
?>
