<?php
define( '_VALID_MOS', 1 );

$base_path = '../../../../../../../';
if (!empty($_SERVER['SCRIPT_FILENAME']) && $pos = strpos($_SERVER['SCRIPT_FILENAME'], 'mambots/editors/mostlyce/jscripts/tiny_mce'))
{
  $base_path = substr($_SERVER['SCRIPT_FILENAME'], 0, $pos);
}
include ( $base_path."configuration.php" );
include_once ( $mosConfig_absolute_path."/mambots/editors/mostlyce/jscripts/tiny_mce/mostlyce_config.php" );

//From mambo.files.php
/**
* Utility function to read the files in a directory
* @param string The file system path
* @param string A filter for the names
* @param boolean Recurse search into sub-directories
* @param boolean True if to prepend the full path to the file name
* @return array
*/
function listFiles( $path, $filter='.', $recurse=false, $fullpath=false  ) {
    $arr = array();
    if (!is_dir( $path )) {
        return $arr;
    }

    // read the source directory
    $handle = opendir( $path );
    $path .= DIRECTORY_SEPARATOR;
    while ($file = readdir( $handle )) {
        $dir = $path . $file;
        $isDir = is_dir( $dir );
        if ($file <> '.' && $file <> '..') {
            if ($isDir) {
                if ($recurse) {
                    $arr2 = listFiles( $dir, $filter, $recurse, $fullpath );
                    $arr = array_merge( $arr, $arr2 );
                }
            } else {
                if (preg_match( "/$filter/", $file )) {
                    if ($fullpath) {
                        $arr[] = $path . $file;
                    } else {
                        $arr[] = $file;
                    }
                }
            }
        }
    }
    closedir( $handle );
    asort( $arr );
    return $arr;
}

$tmplRegex 	= '\.(html|htm)$';
$path = $mosConfig_absolute_path.$editor_tmpl_dir;

if( is_dir( $path ) ){
    $d = listFiles( $path, $tmplRegex );
    foreach ( $d as $file ) {
        $filepath = $path.$file;
        if (eregi($tmplRegex, $file)) {
            $temp = array(
                'name' 		=> $file,
                'path' 		=> $filepath,
                'url' 		=> str_replace( '\\', '/', $editor_tmpl_dir ) . '/' . $file,
            );
        }
        $files[] = $temp;
    }
}else{
  echo "<span style=\"color: red; font-weight: bold;\">Directory $path not found!</span>";
}

$javascript = "onChange=\"selectTmpl(this.value)\"";
$list['tmpl'] = "<select name=\"tmplFile\" $javascript style=\"width:200px\">";
$list['tmpl'] .= "<option value=\"\" selected>--Select Template--</option>";

if( !empty( $files ) ){
    foreach ( $files as $tmpl ) {
        $list['tmpl'] .= "<option value=\"".$tmpl['url']."\">".$tmpl['name']."</option>";
    }
}
$list['tmpl'] .= "</select>";

?>
<html>
<head>
<title>{$lang_htmltemplate_desc}</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate" />
<meta http-equiv="Expires" content="Fri, Oct 24 1976 00:00:00 GMT" />
<script type="text/javascript" src="../../tiny_mce.js"></script>
<style type="text/css">
.show {
  display : block;
}
.hide {
  display : none;
}
</style>
<script type="text/javascript">
<!--
// Adapted from TinyMCE Paste plugin - Ryan Demmer 18/09/2005

// Because we can't load tiny_mce_popup.js.
// Get tinyMCE window
var site_url = "<?php echo $mosConfig_live_site;?>";
var win = window.opener ? window.opener : window.dialogArguments;

var tinyMCE = null;
var tinyMCELang = null;

// Use top window if not defined
if (!win)
	win = top;

// Setup window opener
window.opener = win;

var tinyMCE = win.tinyMCE;
var tinyMCELang = win.tinyMCELang;

if (!tinyMCE)
	alert("tinyMCE object reference not found from popup.");

// Setup dir
if (tinyMCELang['lang_dir'])
	document.dir = tinyMCELang['lang_dir'];

// Setup title
var re = new RegExp('{|\\\$|}', 'g');
var title = document.title.replace(re, "");

if (typeof tinyMCELang[title] != "undefined") {
	var divElm = document.createElement("div");
	divElm.innerHTML = tinyMCELang[title];
	document.title = divElm.innerHTML;
}
// Fixes some charcode issues
function fixContent(html) {
    html = html.replace(new RegExp('<(p|hr|table|tr|td|ol|ul|object|embed|li|blockquote)', 'gi'),'\n<$1');
    html = html.replace(new RegExp('<\/(p|ol|ul|li|table|tr|td|blockquote|object)>', 'gi'),'</$1>\n');
    html = tinyMCE.regexpReplace(html, '<br />','<br />\n','gi');
    html = tinyMCE.regexpReplace(html, '\n\n','\n','gi');
    return html;
}
function insertContent() {
	if (win) {
        if(document.getElementById('htmlsrc').checked){
            if(tinyMCE.isMSIE){
                html = document.getElementById('frmData').contentWindow.document.body.innerText;
                document.getElementById('frmData').contentWindow.document.body.innerHTML = html;
            }else{
                html = document.getElementById('frmData').contentWindow.document.body.ownerDocument.createRange();
                html.selectNodeContents(document.getElementById('frmData').contentWindow.document.body);
                document.getElementById('frmData').contentWindow.document.body.innerHTML = html.toString();
            }
        }
        var html = document.getElementById("frmData").contentWindow.document.body.innerHTML;

		if (html == ''){
			window.close();
			return false;
		}
		win.TinyMCE_htmltemplate__insertContent(html);
		window.close();
	}
}

function onLoadInit() {
	document.body.innerHTML = tinyMCE.applyTemplate(document.body.innerHTML, tinyMCE.windowArgs);
	document.getElementById("frmData").contentWindow.document.designMode='on';
    document.getElementById("frmData").src = "blank.htm";
	resizeInputs();
}

var wHeight=0, wWidth=0, owHeight=0, owWidth=0;

function resizeInputs() {
	if (!tinyMCE.isMSIE) {
		wHeight = self.innerHeight - 100;
		wWidth = self.innerWidth - 25;
	}
	else {
		wHeight = document.body.clientHeight - 100;
		wWidth = document.body.clientWidth - 25;
	}

	document.getElementById('frmData').style.height = Math.abs(wHeight) + 'px';
	document.getElementById('frmData').style.width  = Math.abs(wWidth) + 'px';
}
function selectTmpl(option)
{
    var tplsrc = site_url+option;
    document.getElementById('frmData').src = tplsrc;
}
function viewsource(source)
{
  var html;
  if (source) {
    if(tinyMCE.isMSIE){
        html = document.getElementById('frmData').contentWindow.document.body.innerHTML;
        document.getElementById('frmData').contentWindow.document.body.innerText = html;
    }else{
        html = document.createTextNode(document.getElementById('frmData').contentWindow.document.body.innerHTML);
        document.getElementById('frmData').contentWindow.document.body.innerHTML = "";
        html = document.getElementById('frmData').contentWindow.document.importNode(html,false);
    	document.getElementById('frmData').contentWindow.document.body.appendChild(html);
    }
  } else {
    if(tinyMCE.isMSIE){
        html = document.getElementById('frmData').contentWindow.document.body.innerText;
        document.getElementById('frmData').contentWindow.document.body.innerHTML = html;
    }else{
        html = document.getElementById('frmData').contentWindow.document.body.ownerDocument.createRange();
        html.selectNodeContents(document.getElementById('frmData').contentWindow.document.body);
        document.getElementById('frmData').contentWindow.document.body.innerHTML = html.toString();
    }
  }
}

// Output Popup CSS class
document.write('<link href="' + tinyMCE.getParam("popups_css") + '" rel="stylesheet" type="text/css">');

//--></script>

</head>
<body scroll="no" onload="onLoadInit();" onresize="resizeInputs();">
<form name="source" onsubmit="saveContent();">
    <table border="0" cellpadding="0" cellspacing="2" align="center">
        <tr>
            <td colspan="2" class="title">{$lang_htmltemplate_desc}</td>
        </tr>
        <tr>
            <td colspan="2">{$lang_htmltemplate_title}</td>
        </tr>
        <tr>
            <td><?php echo $list['tmpl']; ?>
            <td align="left">
            <input type="checkbox" id="htmlsrc" onclick="viewsource(this.checked)" style="vertical-align:middle;">View HTML Source</input>
            </td>
        </tr>
        <tr>
            <td colspan="2">
                <iframe id="frmData" name="frmData" src="blank.htm" height="250" width="400" frameborder="0" style="font-family:'Courier New',Courier,mono; font-size:8px; background-color:#FFFFFF;" dir="ltr" wrap="soft"></iframe>
            </td>
        </tr>
        <tr>
            <td width="50%" align="left"><input type="button" id="insert" name="insert" value="{$lang_insert}" onclick="insertContent();" /></td>
            <td width="50%" align="right"><input type="button" id="cancel" value="{$lang_cancel}" onclick="window.close();" /></td>
        </tr>
    </table>
</form>
</body>
</html>
