<?php
class catalogsView extends View
{
    function render(&$renderer, &$request)
    {
        $lang = $request->get('lang');
        $language =& new mamboLanguage($lang);
        $language->load(true);
        $session =& $request->session();
        $col = isset($session['col']) ? $session['col'] : 'domain';
        $asc = isset($session['asc']) ? $session['asc'] : 1;
        $order = array();
        $files = $language->files;
        // Obtain a list of columns
        foreach ($files as $key => $row) {
            $order[$key]  = $row[$col];
        }
        array_multisort($order, $asc == 1 ? SORT_ASC : SORT_DESC, $files);
        $renderer->addvar('col', $col);
        $renderer->addvar('asc', $asc);
        $renderer->addvar('rows', $files);
        $renderer->addvar('header', sprintf(T_('Manage Translations: %s'), $lang));        
        $renderer->addvar('content', $renderer->fetch('catalogs.tpl.php'));
        $renderer->display('form.tpl.php');
    }
}
?>