/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Compression.RangeCoder;

import SevenZip.Compression.RangeCoder.Encoder;
import java.io.IOException;

public class BitEncoder {
    static final int kNumBitModelTotalBits = 11;
    static final int kBitModelTotal = 2048;
    static final int kNumMoveBits = 5;
    static final int kNumMoveReducingBits = 2;
    public static final int kNumBitPriceShiftBits = 6;
    int Prob;
    private static int[] ProbPrices = new int[512];
    static final int kNumBits = 9;

    public void Init() {
        this.Prob = 1024;
    }

    public void Encode(Encoder encoder, int n) throws IOException {
        int n2 = (encoder.Range >>> 11) * this.Prob;
        if (n == 0) {
            encoder.Range = n2;
            this.Prob += 2048 - this.Prob >> 5;
        } else {
            encoder.Low += (long)n2 & 0xFFFFFFFFL;
            encoder.Range -= n2;
            this.Prob -= this.Prob >> 5;
        }
        if ((encoder.Range & 0xFF000000) == 0) {
            encoder.Range <<= 8;
            encoder.ShiftLow();
        }
    }

    public int GetPrice(int n) {
        return ProbPrices[((this.Prob - n ^ -n) & 0x7FF) >> 2];
    }

    public int GetPrice0() {
        return ProbPrices[this.Prob >> 2];
    }

    public int GetPrice1() {
        return ProbPrices[2048 - this.Prob >> 2];
    }

    static {
        for (int i = 8; i >= 0; --i) {
            int n = 1 << 9 - i - 1;
            int n2 = 1 << 9 - i;
            for (int j = n; j < n2; ++j) {
                BitEncoder.ProbPrices[j] = (i << 6) + (n2 - j << 6 >> 9 - i - 1);
            }
        }
    }
}

