/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import lpg.runtime.ILexStream;
import lpg.runtime.IMessageHandler;
import lpg.runtime.IPrsStream;
import lpg.runtime.IntSegmentedTuple;
import lpg.runtime.ParseErrorCodes;

public class Utf8LexStream
implements ILexStream,
ParseErrorCodes {
    private static final int DEFAULT_TAB = 1;
    private static byte[] charSize;
    private int startIndex = -1;
    private int index = -1;
    private int lastIndex = -1;
    private byte[] inputBytes;
    private boolean isUTF8;
    private String fileName;
    private IntSegmentedTuple lineOffsets;
    private int tab = 1;
    private IPrsStream iPrsStream;
    private IMessageHandler errMsg = null;

    public int getCharSize(byte c) {
        return this.isUTF8 ? charSize[c & 0xFF] : 1;
    }

    public static final int getUnicodeValue(byte[] bytes, int i) {
        int code;
        block8: {
            try {
                code = bytes[i] & 0xFF;
                int size = charSize[code];
                block1 : switch (size) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        code = 0;
                        break;
                    }
                    default: {
                        code &= 255 >> size + 1;
                        for (int k = 1; k < size; ++k) {
                            byte c = bytes[i + k];
                            if ((c & 0xC0) != 128) {
                                code = 0;
                                break block1;
                            }
                            code = (code << 6) + (c & 0x3F);
                        }
                        break block8;
                    }
                }
                {
                    break block8;
                    break;
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new StringIndexOutOfBoundsException(i);
            }
        }
        return code;
    }

    public String getString(int offset, int count) {
        if (count < 0) {
            throw new StringIndexOutOfBoundsException(count);
        }
        char[] value = new char[count];
        int size = 0;
        int i = 0;
        int j = offset;
        while (i < count) {
            value[size++] = (char)this.getUnicodeValue(j);
            i += this.getCharSize(this.inputBytes[j]);
            j += this.getCharSize(this.inputBytes[j]);
        }
        return new String(value, 0, size);
    }

    public Utf8LexStream() {
        this.lineOffsets = new IntSegmentedTuple(12);
        this.setLineOffset(-1);
    }

    public Utf8LexStream(int tab) {
        this();
        this.tab = tab;
    }

    public Utf8LexStream(String fileName) throws IOException {
        this(fileName, 1);
    }

    public Utf8LexStream(String fileName, int tab) throws IOException {
        this(tab);
        try {
            File f = new File(fileName);
            FileInputStream in = new FileInputStream(f);
            byte[] buffer = new byte[(int)f.length()];
            in.read(buffer, 0, buffer.length);
            this.initialize(buffer, fileName);
        }
        catch (Exception e) {
            IOException io = new IOException();
            System.err.println(e.getMessage());
            e.printStackTrace();
            throw io;
        }
    }

    public Utf8LexStream(byte[] inputBytes, String fileName) {
        this();
        this.initialize(inputBytes, fileName);
    }

    public Utf8LexStream(IntSegmentedTuple lineOffsets, byte[] inputBytes, String fileName) {
        this.initialize(lineOffsets, inputBytes, fileName);
    }

    public Utf8LexStream(byte[] inputBytes, String fileName, int tab) {
        this(tab);
        this.initialize(inputBytes, fileName);
    }

    public Utf8LexStream(IntSegmentedTuple lineOffsets, byte[] inputBytes, String fileName, int tab) {
        this.tab = tab;
        this.initialize(lineOffsets, inputBytes, fileName);
    }

    public boolean isUtf8() {
        return this.isUTF8;
    }

    public boolean isExtendedAscii() {
        return !this.isUTF8;
    }

    public void initialize(byte[] inputBytes, String fileName) {
        this.setInputBytes(inputBytes);
        this.setFileName(fileName);
        this.computeLineOffsets();
    }

    public void initialize(IntSegmentedTuple lineOffsets, byte[] inputBytes, String fileName) {
        this.lineOffsets = lineOffsets;
        this.setInputBytes(inputBytes);
        this.setFileName(fileName);
    }

    public void computeLineOffsets() {
        this.lineOffsets.reset();
        this.setLineOffset(-1);
        for (int i = this.startIndex + 1; i < this.inputBytes.length; ++i) {
            if (this.inputBytes[i] != 10) continue;
            this.setLineOffset(i);
        }
    }

    public void setInputBytes(byte[] buffer) {
        this.inputBytes = buffer;
        this.isUTF8 = buffer.length >= 3 && (buffer[0] & 0xFF) == 239 && (buffer[1] & 0xFF) == 187 && (buffer[2] & 0xFF) == 191;
        this.index = this.startIndex = this.isUTF8 ? 2 : -1;
        this.lastIndex = this.getPrevious(buffer.length);
    }

    public byte[] getInputBytes() {
        return this.inputBytes;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setLineOffsets(IntSegmentedTuple lineOffsets) {
        this.lineOffsets = lineOffsets;
    }

    public IntSegmentedTuple getLineOffsets() {
        return this.lineOffsets;
    }

    public void setTab(int tab) {
        this.tab = tab;
    }

    public int getTab() {
        return this.tab;
    }

    public void setStreamIndex(int index) {
        this.index = index;
    }

    public int getStreamIndex() {
        return this.index;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public int getStreamLength() {
        return this.inputBytes.length;
    }

    public void setLineOffset(int i) {
        this.lineOffsets.add(i);
    }

    public int getLineOffset(int i) {
        return this.lineOffsets.get(i);
    }

    public int getLineOffsetOfLine(int line_number) {
        return this.lineOffsets.get(line_number - 1);
    }

    public void setPrsStream(IPrsStream iPrsStream) {
        this.iPrsStream = iPrsStream;
    }

    public IPrsStream getIPrsStream() {
        return this.iPrsStream;
    }

    public IPrsStream getPrsStream() {
        return this.iPrsStream;
    }

    public String[] orderedExportedSymbols() {
        return null;
    }

    public char getCharValue(int i) {
        return (char)this.getUnicodeValue(i);
    }

    public int getIntValue(int i) {
        return this.getUnicodeValue(i);
    }

    public int getUnicodeValue(int i) {
        return this.isUTF8 ? Utf8LexStream.getUnicodeValue(this.inputBytes, i) : this.inputBytes[i] & 0xFF;
    }

    public int getLineCount() {
        return this.lineOffsets.size();
    }

    public int getLineNumberOfCharAt(int i) {
        int index = this.lineOffsets.binarySearch(i);
        return index < 0 ? -index : (index == 0 ? 1 : index);
    }

    public int getColumnOfCharAt(int i) {
        int lineNo = this.getLineNumberOfCharAt(i);
        int start = this.getLineOffset(lineNo - 1);
        int tab = this.getTab();
        if (start + 1 >= this.inputBytes.length) {
            return 1;
        }
        int k = start + 1;
        while (k < i) {
            byte c = this.inputBytes[k];
            if (c == 9) {
                int offset = k - start - 1;
                start -= tab - 1 - offset % tab;
            }
            start += this.getCharSize(c) - 1;
            k = this.getNext(k);
        }
        return i - start;
    }

    public int getToken() {
        this.index = this.getNext(this.index);
        return this.index;
    }

    public int getToken(int end_token) {
        this.index = this.index < end_token ? this.getNext(this.index) : this.lastIndex;
        return this.index;
    }

    public int getKind(int i) {
        return 0;
    }

    public int getNext(int i) {
        return i <= this.startIndex ? this.startIndex + 1 : (i < this.inputBytes.length ? i + this.getCharSize(this.inputBytes[i]) : this.lastIndex);
    }

    public int getPrevious(int i) {
        int n = i = i > this.startIndex ? i - 1 : this.startIndex;
        if (this.isUTF8) {
            while (i > this.startIndex && (this.inputBytes[i] & 0xC0) == 128) {
                --i;
            }
        }
        return i;
    }

    public String getName(int i) {
        int c = this.getUnicodeValue(i);
        if (c <= 65535) {
            return "" + (char)c;
        }
        return "#x" + Integer.toHexString(i);
    }

    public String getName(int i, int k) {
        String name = "";
        for (int j = i; j <= k; ++j) {
            int c = this.getUnicodeValue(j);
            name = c <= 65535 ? name + (char)c : name + "#x" + Integer.toHexString(j);
        }
        return name;
    }

    public int peek() {
        return this.getNext(this.index);
    }

    public void reset(int i) {
        this.index = this.getPrevious(i);
    }

    public void reset() {
        this.index = this.startIndex;
    }

    public int badToken() {
        return 0;
    }

    public int getLine(int i) {
        return this.getLineNumberOfCharAt(i);
    }

    public int getColumn(int i) {
        return this.getColumnOfCharAt(i);
    }

    public int getEndLine(int i) {
        return this.getLine(i);
    }

    public int getEndColumn(int i) {
        return this.getColumnOfCharAt(i);
    }

    public boolean afterEol(int i) {
        return i < 1 ? true : this.getLineNumberOfCharAt(this.getPrevious(i)) < this.getLineNumberOfCharAt(i);
    }

    public int getFirstErrorToken(int i) {
        return this.getFirstRealToken(i);
    }

    public int getFirstRealToken(int i) {
        return i;
    }

    public int getLastErrorToken(int i) {
        return this.getLastRealToken(i);
    }

    public int getLastRealToken(int i) {
        return i;
    }

    public void setMessageHandler(IMessageHandler errMsg) {
        this.errMsg = errMsg;
    }

    public IMessageHandler getMessageHandler() {
        return this.errMsg;
    }

    public void makeToken(int startLoc, int endLoc, int kind) {
        if (this.iPrsStream != null) {
            this.iPrsStream.makeToken(startLoc, endLoc, kind);
        } else {
            this.reportLexicalError(startLoc, endLoc);
        }
    }

    public void reportLexicalError(int left_loc, int right_loc) {
        int end_loc;
        int errorCode = right_loc >= this.inputBytes.length ? 10 : (left_loc == right_loc ? 0 : 11);
        int n = end_loc = left_loc == right_loc ? right_loc : right_loc - 1;
        String tokenText = errorCode == 10 ? "End-of-file " : (errorCode == 11 ? "\"" + new String(this.inputBytes, left_loc, right_loc - left_loc) + "\" " : "\"" + (char)this.getUnicodeValue(left_loc) + "\" ");
        this.reportLexicalError(errorCode, left_loc, end_loc, 0, 0, new String[]{tokenText});
    }

    public int[] getLocation(int left_loc, int right_loc) {
        int length = (right_loc < this.inputBytes.length ? right_loc : this.inputBytes.length - 1) - left_loc + 1;
        return new int[]{left_loc, length, this.getLineNumberOfCharAt(left_loc), this.getColumnOfCharAt(left_loc), this.getLineNumberOfCharAt(right_loc), this.getColumnOfCharAt(right_loc)};
    }

    public void reportLexicalError(int errorCode, int left_loc, int right_loc, int error_left_loc, int error_right_loc, String[] errorInfo) {
        if (this.errMsg == null) {
            String locationInfo = this.getFileName() + ':' + this.getLineNumberOfCharAt(left_loc) + ':' + this.getColumnOfCharAt(left_loc) + ':' + this.getLineNumberOfCharAt(right_loc) + ':' + this.getColumnOfCharAt(right_loc) + ':' + error_left_loc + ':' + error_right_loc + ':' + errorCode + ": ";
            System.out.print("****Error: " + locationInfo);
            if (errorInfo != null) {
                for (int i = 0; i < errorInfo.length; ++i) {
                    System.out.print(errorInfo[i] + " ");
                }
            }
            System.out.println(errorMsgText[errorCode]);
        } else {
            this.errMsg.handleMessage(errorCode, this.getLocation(left_loc, right_loc), this.getLocation(error_left_loc, error_right_loc), this.getFileName(), errorInfo);
        }
    }

    public void reportError(int errorCode, int leftToken, int rightToken, String errorInfo) {
        String[] stringArray;
        if (errorInfo == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = errorInfo;
        }
        this.reportError(errorCode, leftToken, 0, rightToken, stringArray);
    }

    public void reportError(int errorCode, int leftToken, int rightToken, String[] errorInfo) {
        this.reportError(errorCode, leftToken, 0, rightToken, errorInfo);
    }

    public void reportError(int errorCode, int leftToken, int errorToken, int rightToken, String errorInfo) {
        String[] stringArray;
        if (errorInfo == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = errorInfo;
        }
        this.reportError(errorCode, leftToken, errorToken, rightToken, stringArray);
    }

    public void reportError(int errorCode, int leftToken, int errorToken, int rightToken, String[] errorInfo) {
        this.reportLexicalError(errorCode, leftToken, rightToken, errorToken, errorToken, errorInfo == null ? new String[]{} : errorInfo);
    }

    public String toString(int startOffset, int endOffset) {
        int length = endOffset - startOffset + 1;
        return endOffset >= this.inputBytes.length ? "$EOF" : (length <= 0 ? "" : this.getString(startOffset, length));
    }

    static {
        int i;
        charSize = new byte[256];
        for (i = 0; i < 128; ++i) {
            Utf8LexStream.charSize[i] = 1;
        }
        for (i = 128; i < 206; ++i) {
            Utf8LexStream.charSize[i] = 0;
        }
        for (i = 206; i < 224; ++i) {
            Utf8LexStream.charSize[i] = 2;
        }
        for (i = 224; i < 240; ++i) {
            Utf8LexStream.charSize[i] = 3;
        }
        for (i = 240; i < 248; ++i) {
            Utf8LexStream.charSize[i] = 4;
        }
        for (i = 248; i < 252; ++i) {
            Utf8LexStream.charSize[i] = 5;
        }
        for (i = 252; i < 254; ++i) {
            Utf8LexStream.charSize[i] = 6;
        }
        for (i = 254; i < 255; ++i) {
            Utf8LexStream.charSize[i] = 0;
        }
    }
}

