/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentedTuple<T>
implements List<T> {
    private int modCount = 0;
    private int top;
    private int size;
    private int log_blksize = 10;
    private int base_size = 16;
    private T[][] base;

    private void allocateMoreSpace() {
        int k = this.size >> this.log_blksize;
        if (k == this.base_size) {
            this.base_size *= 2;
            this.base = new Object[this.base_size][];
            System.arraycopy(this.base, 0, this.base, 0, k);
        }
        this.base[k] = new Object[1 << this.log_blksize];
        this.size += 1 << this.log_blksize;
    }

    public void resize() {
        this.resize(0);
    }

    public void resize(int n) {
        ++this.modCount;
        if (n > this.size) {
            do {
                this.allocateMoreSpace();
            } while (n > this.size);
        }
        this.top = n;
    }

    public void reset() {
        this.reset(0);
    }

    public void reset(int n) {
        this.top = n;
    }

    @Override
    public int size() {
        return this.top;
    }

    public boolean outOfRange(int i) {
        return i < 0 || i >= this.top;
    }

    @Override
    public T get(int i) {
        return this.base[i >> this.log_blksize][i % (1 << this.log_blksize)];
    }

    @Override
    public T set(int i, T element) {
        T t = element;
        this.base[i >> this.log_blksize][i % (1 << this.log_blksize)] = t;
        T old_value = t;
        this.base[i >> this.log_blksize][i % (1 << this.log_blksize)] = element;
        return old_value;
    }

    public int NextIndex() {
        int i;
        if ((i = this.top++) == this.size) {
            this.allocateMoreSpace();
        }
        return i;
    }

    @Override
    public boolean add(T element) {
        ++this.modCount;
        int i = this.NextIndex();
        this.base[i >> this.log_blksize][i % (1 << this.log_blksize)] = element;
        return true;
    }

    public SegmentedTuple() {
        this.base = new Object[this.base_size][];
    }

    public SegmentedTuple(int log_blksize_) {
        this.log_blksize = log_blksize_;
        this.base = new Object[this.base_size][];
    }

    public SegmentedTuple(int log_blksize_, int base_size_) {
        this.log_blksize = log_blksize_;
        this.base_size = base_size_ <= 0 ? 4 : base_size_;
        this.base = new Object[this.base_size][];
    }

    @Override
    public boolean isEmpty() {
        return this.top == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.top; ++i) {
            if (this.base[i >> this.log_blksize][i % (1 << this.log_blksize)] != o) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.top];
        for (int i = 0; i < this.top; ++i) {
            result[i] = this.base[i >> this.log_blksize][i % (1 << this.log_blksize)];
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.top) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.top);
        }
        for (int i = 0; i < this.top; ++i) {
            a[i] = this.base[i >> this.log_blksize][i % (1 << this.log_blksize)];
        }
        if (a.length > this.top) {
            a[this.top] = null;
        }
        return a;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.resize();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.top; ++i) {
            if (this.base[i >> this.log_blksize][i % (1 << this.log_blksize)] != o) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.top - 1; i >= 0; --i) {
            if (this.base[i >> this.log_blksize][i % (1 << this.log_blksize)] != o) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListItr
    extends Itr
    implements ListIterator<T> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public T previous() {
            this.checkForComodification();
            try {
                int i = this.cursor - 1;
                Object previous = SegmentedTuple.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T o) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<T> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount = SegmentedTuple.access$100(SegmentedTuple.this);

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != SegmentedTuple.this.size();
        }

        @Override
        public T next() {
            this.checkForComodification();
            try {
                Object next = SegmentedTuple.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        final void checkForComodification() {
            if (SegmentedTuple.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

