/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.demo;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.uif_lite.component.Factory;
import com.jgoodies.uif_lite.panel.SimpleInternalFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

final class TabTestTab {
    TabTestTab() {
    }

    JComponent build() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(Borders.DIALOG_BORDER);
        panel.add(this.buildHorizontalSplit());
        return panel;
    }

    private JComponent buildHorizontalSplit() {
        return Factory.createStrippedSplitPane(1, this.buildMainLeftPanel(), this.buildMainRightPanel(), 0.2f);
    }

    private JComponent buildMainLeftPanel() {
        JTabbedPane tabbedPane = new JTabbedPane(3);
        tabbedPane.putClientProperty("jgoodies.embeddedTabs", Boolean.TRUE);
        tabbedPane.addTab("Tree", Factory.createStrippedScrollPane(this.buildTree()));
        tabbedPane.addTab("Help", Factory.createStrippedScrollPane(this.buildHelp()));
        SimpleInternalFrame sif = new SimpleInternalFrame("Embedded Tabs");
        sif.setPreferredSize(new Dimension(150, 100));
        sif.add(tabbedPane);
        return sif;
    }

    private JTree buildTree() {
        JTree tree = new JTree(this.createSampleTreeModel());
        tree.putClientProperty("JTree.lineStyle", "None");
        tree.expandRow(3);
        tree.expandRow(2);
        tree.expandRow(1);
        return tree;
    }

    private JComponent buildHelp() {
        JTextArea area = new JTextArea("\n This tabbed pane uses\n embedded tabs.");
        return area;
    }

    private JComponent buildMainRightPanel() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.putClientProperty("jgoodies.noContentBorder", Boolean.TRUE);
        tabbedPane.addTab("Top", this.buildSplittedTabs(1));
        tabbedPane.addTab("Bottom", this.buildSplittedTabs(3));
        tabbedPane.addTab("Left", this.buildSplittedTabs(2));
        tabbedPane.addTab("Right", this.buildSplittedTabs(4));
        SimpleInternalFrame sif = new SimpleInternalFrame("Tabbed Pane without Content Border");
        sif.setPreferredSize(new Dimension(300, 100));
        sif.add(tabbedPane);
        return sif;
    }

    private JComponent buildSplittedTabs(int tabPlacement) {
        int orientation = tabPlacement == 1 || tabPlacement == 3 ? 1 : 0;
        JSplitPane split = Factory.createStrippedSplitPane(orientation, this.buildTabPanel(tabPlacement, 0), this.buildTabPanel(tabPlacement, 1), 0.5);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)split, "Center");
        panel.setBorder(new EmptyBorder(20, 20, 20, 20));
        return panel;
    }

    private JComponent buildTabPanel(int tabPlacement, int tabLayoutPolicy) {
        JTabbedPane tabbedPane = new JTabbedPane(tabPlacement, tabLayoutPolicy);
        String[] colors = new String[]{"Black", "White", "Red", "Green", "Blue", "Yellow"};
        for (int i = 0; i < colors.length; ++i) {
            String color = colors[i];
            JPanel filler = new JPanel(null);
            filler.setOpaque(false);
            tabbedPane.addTab(color, filler);
        }
        return tabbedPane;
    }

    private TreeModel createSampleTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Musicians");
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode("Drums");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("Elvin Jones"));
        parent.add(new DefaultMutableTreeNode("Jack DeJohnette"));
        parent.add(new DefaultMutableTreeNode("Rashied Ali"));
        parent = new DefaultMutableTreeNode("Piano");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("McCoy Tyner"));
        parent.add(new DefaultMutableTreeNode("Sun Ra"));
        parent = new DefaultMutableTreeNode("Saxophon");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("Albert Ayler"));
        parent.add(new DefaultMutableTreeNode("Archie Shepp"));
        parent.add(new DefaultMutableTreeNode("Charlie Parker"));
        parent.add(new DefaultMutableTreeNode("John Coltrane"));
        parent.add(new DefaultMutableTreeNode("Ornette Coleman"));
        parent.add(new DefaultMutableTreeNode("Pharoa Sanders"));
        parent.add(new DefaultMutableTreeNode("Sonny Rollins"));
        return new DefaultTreeModel(root);
    }
}

