/*
 * Decompiled with CFR 0.152.
 */
package primitive.collection;

import java.util.Random;
import primitive.collection.IntStatList;
import primitive.collection.ShortFunction;
import primitive.collection.ShortList;

public class ShortStatList
extends ShortList {
    public void each(ShortFunction shortFunction) {
        for (int j = 0; j != this.size(); ++j) {
            shortFunction.apply(this.get(j));
        }
    }

    public short reduce(short s2, ShortFunction shortFunction) {
        short s3 = s2;
        for (int j = 0; j != this.size(); ++j) {
            s3 = shortFunction.accumulate(s3, this.get(j));
        }
        return s3;
    }

    public short sum() {
        ShortFunction shortFunction = new ShortFunction(){

            @Override
            public short accumulate(short s2, short s3) {
                return (short)(s2 + s3);
            }
        };
        return this.reduce((short)0, shortFunction);
    }

    public ShortStats stats() {
        final ShortStats shortStats = new ShortStats();
        ShortFunction shortFunction = new ShortFunction(){

            @Override
            public void apply(short s2) {
                if (s2 < shortStats.min) {
                    shortStats.min = s2;
                }
                if (s2 > shortStats.max) {
                    shortStats.max = s2;
                }
                shortStats.sum = (short)(shortStats.sum + s2);
            }
        };
        this.each(shortFunction);
        shortStats.n = this.size();
        shortStats.avg = (double)shortStats.sum / (double)shortStats.n;
        shortFunction = new ShortFunction(){

            @Override
            public void apply(short s2) {
                shortStats.var += Math.pow(shortStats.avg - (double)s2, 2.0);
            }
        };
        this.each(shortFunction);
        shortStats.var /= (double)shortStats.n;
        shortStats.stdd = Math.pow(shortStats.var, 0.5);
        return shortStats;
    }

    static ShortStatList random(int n) {
        Random random = new Random(0L);
        ShortStatList shortStatList = new ShortStatList();
        for (int j = 0; j != n; ++j) {
            short s2 = (short)random.nextInt(32000);
            shortStatList.add(s2);
        }
        return shortStatList;
    }

    private static void p(Object object) {
        System.out.println(object);
    }

    public static void main(String[] stringArray) {
        ShortStatList shortStatList = ShortStatList.random(10);
        shortStatList.each(new ShortFunction(){

            @Override
            public void apply(short s2) {
                ShortStatList.p(s2);
            }
        });
        ShortStatList.p(shortStatList.stats());
        ShortStatList.p(shortStatList.sum());
        IntStatList intStatList = new IntStatList();
        for (int j = 1; j < 101; ++j) {
            intStatList.add(j);
        }
        ShortStatList.p(intStatList.stats());
        ShortStatList.p(intStatList.sum());
    }

    class ShortStats {
        public int n;
        public short min = Short.MAX_VALUE;
        public short max = Short.MIN_VALUE;
        public short sum;
        public double avg;
        public double stdd;
        public double var;

        ShortStats() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("n    = ");
            stringBuilder.append(this.n);
            stringBuilder.append("\n");
            stringBuilder.append("min  = ");
            stringBuilder.append(this.min);
            stringBuilder.append("\n");
            stringBuilder.append("max  = ");
            stringBuilder.append(this.max);
            stringBuilder.append("\n");
            stringBuilder.append("sum  = ");
            stringBuilder.append(this.sum);
            stringBuilder.append("\n");
            stringBuilder.append("avg  = ");
            stringBuilder.append(this.avg);
            stringBuilder.append("\n");
            stringBuilder.append("stdd = ");
            stringBuilder.append(this.stdd);
            stringBuilder.append("\n");
            stringBuilder.append("var  = ");
            stringBuilder.append(this.var);
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }
    }
}

