/*
 * Decompiled with CFR 0.152.
 */
package primitive.collection;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Random;

public class ShortList {
    private static final int DEFAULT = 1024;
    private static final double RESIZE = 1.8;
    private short[] underlyingArray;
    private int pos;

    public ShortList() {
        this.clear();
    }

    public ShortList(int n) {
        this.underlyingArray = new short[n];
    }

    public ShortList(short[] sArray) {
        this.underlyingArray = sArray;
        this.pos = sArray.length;
    }

    public boolean add(short s2) {
        this.ensureCapacity(1);
        this.underlyingArray[this.pos++] = s2;
        return true;
    }

    public void add(int n, short s2) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean addAll(ShortList shortList) {
        this.ensureCapacity(shortList.size());
        System.arraycopy(shortList.underlyingArray, 0, this.underlyingArray, this.size(), shortList.size());
        this.pos += shortList.size();
        return true;
    }

    public boolean addAll(short[] sArray) {
        return this.addAll(sArray, 0, sArray.length);
    }

    public boolean addAll(short[] sArray, int n, int n2) {
        this.ensureCapacity(n2);
        System.arraycopy(sArray, n, this.underlyingArray, this.size(), n2);
        this.pos += sArray.length;
        return true;
    }

    public boolean addAll(int n, ShortList shortList) {
        throw new UnsupportedOperationException("TBD");
    }

    public void clear() {
        if (null == this.underlyingArray || 1024 != this.underlyingArray.length) {
            this.underlyingArray = new short[1024];
        }
        this.pos = 0;
    }

    public boolean contains(short s2) {
        return this.indexOf(s2) != -1;
    }

    public boolean containsAll(ShortList shortList) {
        throw new UnsupportedOperationException("TBD");
    }

    public short get(int n) {
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.underlyingArray[n];
    }

    public int indexOf(short s2) {
        for (int j = 0; j != this.size(); ++j) {
            if (s2 != this.underlyingArray[j]) continue;
            return j;
        }
        return -1;
    }

    public int lastIndexOf(short s2) {
        for (int j = this.size() - 1; j != -1; --j) {
            if (s2 != this.underlyingArray[j]) continue;
            return j;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public Iterator iterator(int n) {
        return new Iterator(this, n);
    }

    public boolean remove(short s2) {
        throw new UnsupportedOperationException("TBD");
    }

    public short removeIdx(int n) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean removeAll(ShortList shortList) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean retainAll(ShortList shortList) {
        throw new UnsupportedOperationException("TBD");
    }

    public short set(int n, short s2) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        short s3 = this.get(n);
        this.underlyingArray[n] = s2;
        return s3;
    }

    public int size() {
        return this.pos;
    }

    public ShortList subList(int n, int n2) {
        if (n < 0 || n2 > this.size() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        short[] sArray = new short[n3];
        System.arraycopy(this.underlyingArray, n, sArray, 0, n3);
        return new ShortList(sArray);
    }

    public short[] toArray() {
        short[] sArray = new short[this.pos];
        System.arraycopy(this.underlyingArray, 0, sArray, 0, this.pos);
        return sArray;
    }

    private void ensureCapacity(int n) {
        int n2 = this.underlyingArray.length - this.pos;
        if (n2 < n) {
            this.resize(this.underlyingArray.length + n);
        }
    }

    private void resize(int n) {
        int n2 = this.max(n, (int)((double)this.underlyingArray.length * 1.8));
        short[] sArray = new short[n2];
        System.arraycopy(this.underlyingArray, 0, sArray, 0, this.pos);
        this.underlyingArray = sArray;
    }

    private int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private static void p(Object object) {
        System.out.println(object);
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        ShortList shortList = new ShortList();
        Random random = new Random(0L);
        byte[] byArray = new byte[1];
        for (int j = 0; j != 250000; ++j) {
            short s2 = (short)random.nextInt(32000);
            shortList.add(s2);
        }
        short[] sArray = shortList.toArray();
        shortList.addAll(sArray);
        ShortList.p("ok...: " + shortList.size() + " in: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int j = 0; j != 250000; ++j) {
            int n = random.nextInt();
            arrayList.add(new Integer(n));
        }
        arrayList.addAll(arrayList);
        ShortList.p("ok...: " + arrayList.size() + " in: " + (System.currentTimeMillis() - l));
    }

    class Iterator {
        private ShortList list;
        private int pos;

        public Iterator(ShortList shortList2) {
            this.list = shortList2;
        }

        public Iterator(ShortList shortList2, int n) {
            if (n < 0 || n > shortList2.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.list = shortList2;
            this.pos = n;
        }

        boolean hasNext() {
            return this.pos < this.list.size();
        }

        short next() {
            if (this.pos >= this.list.size() || this.pos < 0) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.pos++);
        }

        void remove() {
            throw new UnsupportedOperationException("TBD");
        }
    }
}

