/*
 * Decompiled with CFR 0.152.
 */
package primitive.collection;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Random;

public class LongList {
    private static final int DEFAULT = 1024;
    private static final double RESIZE = 1.8;
    private long[] underlyingArray;
    private int pos;

    public LongList() {
        this.clear();
    }

    public LongList(int n) {
        this.underlyingArray = new long[n];
    }

    public LongList(long[] lArray) {
        this.underlyingArray = lArray;
        this.pos = lArray.length;
    }

    public boolean add(long l) {
        this.ensureCapacity(1);
        this.underlyingArray[this.pos++] = l;
        return true;
    }

    public void add(int n, long l) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean addAll(LongList longList) {
        this.ensureCapacity(longList.size());
        System.arraycopy(longList.underlyingArray, 0, this.underlyingArray, this.size(), longList.size());
        this.pos += longList.size();
        return true;
    }

    public boolean addAll(long[] lArray) {
        return this.addAll(lArray, 0, lArray.length);
    }

    public boolean addAll(long[] lArray, int n, int n2) {
        this.ensureCapacity(n2);
        System.arraycopy(lArray, n, this.underlyingArray, this.size(), n2);
        this.pos += lArray.length;
        return true;
    }

    public boolean addAll(int n, LongList longList) {
        throw new UnsupportedOperationException("TBD");
    }

    public void clear() {
        if (null == this.underlyingArray || 1024 != this.underlyingArray.length) {
            this.underlyingArray = new long[1024];
        }
        this.pos = 0;
    }

    public boolean contains(long l) {
        return this.indexOf(l) != -1;
    }

    public boolean containsAll(LongList longList) {
        throw new UnsupportedOperationException("TBD");
    }

    public long get(int n) {
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.underlyingArray[n];
    }

    public int indexOf(long l) {
        for (int j = 0; j != this.size(); ++j) {
            if (l != this.underlyingArray[j]) continue;
            return j;
        }
        return -1;
    }

    public int lastIndexOf(long l) {
        for (int j = this.size() - 1; j != -1; --j) {
            if (l != this.underlyingArray[j]) continue;
            return j;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public Iterator iterator(int n) {
        return new Iterator(this, n);
    }

    public boolean remove(long l) {
        throw new UnsupportedOperationException("TBD");
    }

    public long removeIdx(int n) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean removeAll(LongList longList) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean retainAll(LongList longList) {
        throw new UnsupportedOperationException("TBD");
    }

    public long set(int n, long l) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        long l2 = this.get(n);
        this.underlyingArray[n] = l;
        return l2;
    }

    public int size() {
        return this.pos;
    }

    public LongList subList(int n, int n2) {
        if (n < 0 || n2 > this.size() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        long[] lArray = new long[n3];
        System.arraycopy(this.underlyingArray, n, lArray, 0, n3);
        return new LongList(lArray);
    }

    public long[] toArray() {
        long[] lArray = new long[this.pos];
        System.arraycopy(this.underlyingArray, 0, lArray, 0, this.pos);
        return lArray;
    }

    private void ensureCapacity(int n) {
        int n2 = this.underlyingArray.length - this.pos;
        if (n2 < n) {
            this.resize(this.underlyingArray.length + n);
        }
    }

    private void resize(int n) {
        int n2 = this.max(n, (int)((double)this.underlyingArray.length * 1.8));
        long[] lArray = new long[n2];
        System.arraycopy(this.underlyingArray, 0, lArray, 0, this.pos);
        this.underlyingArray = lArray;
    }

    private int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private static void p(Object object) {
        System.out.println(object);
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        LongList longList = new LongList();
        Random random = new Random(0L);
        byte[] byArray = new byte[1];
        for (int j = 0; j != 250000; ++j) {
            long l2 = random.nextLong();
            longList.add(l2);
        }
        long[] lArray = longList.toArray();
        longList.addAll(lArray);
        LongList.p("ok...: " + longList.size() + " in: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int j = 0; j != 250000; ++j) {
            int n = random.nextInt();
            arrayList.add(new Integer(n));
        }
        arrayList.addAll(arrayList);
        LongList.p("ok...: " + arrayList.size() + " in: " + (System.currentTimeMillis() - l));
    }

    class Iterator {
        private LongList list;
        private int pos;

        public Iterator(LongList longList2) {
            this.list = longList2;
        }

        public Iterator(LongList longList2, int n) {
            if (n < 0 || n > longList2.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.list = longList2;
            this.pos = n;
        }

        boolean hasNext() {
            return this.pos < this.list.size();
        }

        long next() {
            if (this.pos >= this.list.size() || this.pos < 0) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.pos++);
        }

        void remove() {
            throw new UnsupportedOperationException("TBD");
        }
    }
}

