/*
 * Decompiled with CFR 0.152.
 */
package primitive.collection;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Random;

public class FloatList {
    private static final int DEFAULT = 1024;
    private static final double RESIZE = 1.8;
    private float[] underlyingArray;
    private int pos;

    public FloatList() {
        this.clear();
    }

    public FloatList(int n) {
        this.underlyingArray = new float[n];
    }

    public FloatList(float[] fArray) {
        this.underlyingArray = fArray;
        this.pos = fArray.length;
    }

    public boolean add(float f) {
        this.ensureCapacity(1);
        this.underlyingArray[this.pos++] = f;
        return true;
    }

    public void add(int n, float f) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean addAll(FloatList floatList) {
        this.ensureCapacity(floatList.size());
        System.arraycopy(floatList.underlyingArray, 0, this.underlyingArray, this.size(), floatList.size());
        this.pos += floatList.size();
        return true;
    }

    public boolean addAll(float[] fArray) {
        return this.addAll(fArray, 0, fArray.length);
    }

    public boolean addAll(float[] fArray, int n, int n2) {
        this.ensureCapacity(n2);
        System.arraycopy(fArray, n, this.underlyingArray, this.size(), n2);
        this.pos += fArray.length;
        return true;
    }

    public boolean addAll(int n, FloatList floatList) {
        throw new UnsupportedOperationException("TBD");
    }

    public void clear() {
        if (null == this.underlyingArray || 1024 != this.underlyingArray.length) {
            this.underlyingArray = new float[1024];
        }
        this.pos = 0;
    }

    public boolean contains(float f) {
        return this.indexOf(f) != -1;
    }

    public boolean containsAll(FloatList floatList) {
        throw new UnsupportedOperationException("TBD");
    }

    public float get(int n) {
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.underlyingArray[n];
    }

    public int indexOf(float f) {
        for (int j = 0; j != this.size(); ++j) {
            if (f != this.underlyingArray[j]) continue;
            return j;
        }
        return -1;
    }

    public int lastIndexOf(float f) {
        for (int j = this.size() - 1; j != -1; --j) {
            if (f != this.underlyingArray[j]) continue;
            return j;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public Iterator iterator(int n) {
        return new Iterator(this, n);
    }

    public boolean remove(float f) {
        throw new UnsupportedOperationException("TBD");
    }

    public float removeIdx(int n) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean removeAll(FloatList floatList) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean retainAll(FloatList floatList) {
        throw new UnsupportedOperationException("TBD");
    }

    public float set(int n, float f) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        float f2 = this.get(n);
        this.underlyingArray[n] = f;
        return f2;
    }

    public int size() {
        return this.pos;
    }

    public FloatList subList(int n, int n2) {
        if (n < 0 || n2 > this.size() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        float[] fArray = new float[n3];
        System.arraycopy(this.underlyingArray, n, fArray, 0, n3);
        return new FloatList(fArray);
    }

    public float[] toArray() {
        float[] fArray = new float[this.pos];
        System.arraycopy(this.underlyingArray, 0, fArray, 0, this.pos);
        return fArray;
    }

    private void ensureCapacity(int n) {
        int n2 = this.underlyingArray.length - this.pos;
        if (n2 < n) {
            this.resize(this.underlyingArray.length + n);
        }
    }

    private void resize(int n) {
        int n2 = this.max(n, (int)((double)this.underlyingArray.length * 1.8));
        float[] fArray = new float[n2];
        System.arraycopy(this.underlyingArray, 0, fArray, 0, this.pos);
        this.underlyingArray = fArray;
    }

    private int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private static void p(Object object) {
        System.out.println(object);
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        FloatList floatList = new FloatList();
        Random random = new Random(0L);
        byte[] byArray = new byte[1];
        for (int j = 0; j != 250000; ++j) {
            float f = random.nextFloat();
            floatList.add(f);
        }
        float[] fArray = floatList.toArray();
        floatList.addAll(fArray);
        FloatList.p("ok...: " + floatList.size() + " in: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int j = 0; j != 250000; ++j) {
            int n = random.nextInt();
            arrayList.add(new Integer(n));
        }
        arrayList.addAll(arrayList);
        FloatList.p("ok...: " + arrayList.size() + " in: " + (System.currentTimeMillis() - l));
    }

    class Iterator {
        private FloatList list;
        private int pos;

        public Iterator(FloatList floatList2) {
            this.list = floatList2;
        }

        public Iterator(FloatList floatList2, int n) {
            if (n < 0 || n > floatList2.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.list = floatList2;
            this.pos = n;
        }

        boolean hasNext() {
            return this.pos < this.list.size();
        }

        float next() {
            if (this.pos >= this.list.size() || this.pos < 0) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.pos++);
        }

        void remove() {
            throw new UnsupportedOperationException("TBD");
        }
    }
}

