/*
 * Decompiled with CFR 0.152.
 */
package primitive.collection;

import java.util.Random;
import primitive.collection.CharFunction;
import primitive.collection.CharList;
import primitive.collection.IntStatList;

public class CharStatList
extends CharList {
    public void each(CharFunction charFunction) {
        for (int j = 0; j != this.size(); ++j) {
            charFunction.apply(this.get(j));
        }
    }

    public char reduce(char c, CharFunction charFunction) {
        char c2 = c;
        for (int j = 0; j != this.size(); ++j) {
            c2 = charFunction.accumulate(c2, this.get(j));
        }
        return c2;
    }

    public char sum() {
        CharFunction charFunction = new CharFunction(){

            @Override
            public char accumulate(char c, char c2) {
                return (char)(c + c2);
            }
        };
        return this.reduce('\u0000', charFunction);
    }

    public CharStats stats() {
        final CharStats charStats = new CharStats();
        CharFunction charFunction = new CharFunction(){

            @Override
            public void apply(char c) {
                if (c < charStats.min) {
                    charStats.min = c;
                }
                if (c > charStats.max) {
                    charStats.max = c;
                }
                charStats.sum = (char)(charStats.sum + c);
            }
        };
        this.each(charFunction);
        charStats.n = this.size();
        charStats.avg = (double)charStats.sum / (double)charStats.n;
        charFunction = new CharFunction(){

            @Override
            public void apply(char c) {
                charStats.var += Math.pow(charStats.avg - (double)c, 2.0);
            }
        };
        this.each(charFunction);
        charStats.var /= (double)charStats.n;
        charStats.stdd = Math.pow(charStats.var, 0.5);
        return charStats;
    }

    static CharStatList random(int n) {
        Random random = new Random(0L);
        CharStatList charStatList = new CharStatList();
        for (int j = 0; j != n; ++j) {
            char c = (char)random.nextInt();
            charStatList.add(c);
        }
        return charStatList;
    }

    private static void p(Object object) {
        System.out.println(object);
    }

    public static void main(String[] stringArray) {
        CharStatList charStatList = CharStatList.random(10);
        charStatList.each(new CharFunction(){

            @Override
            public void apply(char c) {
                CharStatList.p(Character.valueOf(c));
            }
        });
        CharStatList.p(charStatList.stats());
        CharStatList.p(Character.valueOf(charStatList.sum()));
        IntStatList intStatList = new IntStatList();
        for (int j = 1; j < 101; ++j) {
            intStatList.add(j);
        }
        CharStatList.p(intStatList.stats());
        CharStatList.p(intStatList.sum());
    }

    class CharStats {
        public int n;
        public char min = (char)65535;
        public char max = '\u0000';
        public char sum;
        public double avg;
        public double stdd;
        public double var;

        CharStats() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("n    = ");
            stringBuilder.append(this.n);
            stringBuilder.append("\n");
            stringBuilder.append("min  = ");
            stringBuilder.append(this.min);
            stringBuilder.append("\n");
            stringBuilder.append("max  = ");
            stringBuilder.append(this.max);
            stringBuilder.append("\n");
            stringBuilder.append("sum  = ");
            stringBuilder.append(this.sum);
            stringBuilder.append("\n");
            stringBuilder.append("avg  = ");
            stringBuilder.append(this.avg);
            stringBuilder.append("\n");
            stringBuilder.append("stdd = ");
            stringBuilder.append(this.stdd);
            stringBuilder.append("\n");
            stringBuilder.append("var  = ");
            stringBuilder.append(this.var);
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }
    }
}

