/*
 * Decompiled with CFR 0.152.
 */
package primitive.collection;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Random;

public class BooleanList {
    private static final int DEFAULT = 1024;
    private static final double RESIZE = 1.8;
    private boolean[] underlyingArray;
    private int pos;

    public BooleanList() {
        this.clear();
    }

    public BooleanList(int n) {
        this.underlyingArray = new boolean[n];
    }

    public BooleanList(boolean[] blArray) {
        this.underlyingArray = blArray;
        this.pos = blArray.length;
    }

    public boolean add(boolean bl) {
        this.ensureCapacity(1);
        this.underlyingArray[this.pos++] = bl;
        return true;
    }

    public void add(int n, boolean bl) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean addAll(BooleanList booleanList) {
        this.ensureCapacity(booleanList.size());
        System.arraycopy(booleanList.underlyingArray, 0, this.underlyingArray, this.size(), booleanList.size());
        this.pos += booleanList.size();
        return true;
    }

    public boolean addAll(boolean[] blArray) {
        return this.addAll(blArray, 0, blArray.length);
    }

    public boolean addAll(boolean[] blArray, int n, int n2) {
        this.ensureCapacity(n2);
        System.arraycopy(blArray, n, this.underlyingArray, this.size(), n2);
        this.pos += blArray.length;
        return true;
    }

    public boolean addAll(int n, BooleanList booleanList) {
        throw new UnsupportedOperationException("TBD");
    }

    public void clear() {
        if (null == this.underlyingArray || 1024 != this.underlyingArray.length) {
            this.underlyingArray = new boolean[1024];
        }
        this.pos = 0;
    }

    public boolean contains(boolean bl) {
        return this.indexOf(bl) != -1;
    }

    public boolean containsAll(BooleanList booleanList) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean get(int n) {
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.underlyingArray[n];
    }

    public int indexOf(boolean bl) {
        for (int j = 0; j != this.size(); ++j) {
            if (bl != this.underlyingArray[j]) continue;
            return j;
        }
        return -1;
    }

    public int lastIndexOf(boolean bl) {
        for (int j = this.size() - 1; j != -1; --j) {
            if (bl != this.underlyingArray[j]) continue;
            return j;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public Iterator iterator(int n) {
        return new Iterator(this, n);
    }

    public boolean remove(boolean bl) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean removeIdx(int n) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean removeAll(BooleanList booleanList) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean retainAll(BooleanList booleanList) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean set(int n, boolean bl) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        boolean bl2 = this.get(n);
        this.underlyingArray[n] = bl;
        return bl2;
    }

    public int size() {
        return this.pos;
    }

    public BooleanList subList(int n, int n2) {
        if (n < 0 || n2 > this.size() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        boolean[] blArray = new boolean[n3];
        System.arraycopy(this.underlyingArray, n, blArray, 0, n3);
        return new BooleanList(blArray);
    }

    public boolean[] toArray() {
        boolean[] blArray = new boolean[this.pos];
        System.arraycopy(this.underlyingArray, 0, blArray, 0, this.pos);
        return blArray;
    }

    private void ensureCapacity(int n) {
        int n2 = this.underlyingArray.length - this.pos;
        if (n2 < n) {
            this.resize(this.underlyingArray.length + n);
        }
    }

    private void resize(int n) {
        int n2 = this.max(n, (int)((double)this.underlyingArray.length * 1.8));
        boolean[] blArray = new boolean[n2];
        System.arraycopy(this.underlyingArray, 0, blArray, 0, this.pos);
        this.underlyingArray = blArray;
    }

    private int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private static void p(Object object) {
        System.out.println(object);
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        BooleanList booleanList = new BooleanList();
        Random random = new Random(0L);
        byte[] byArray = new byte[1];
        for (int j = 0; j != 250000; ++j) {
            boolean bl = random.nextBoolean();
            booleanList.add(bl);
        }
        boolean[] blArray = booleanList.toArray();
        booleanList.addAll(blArray);
        BooleanList.p("ok...: " + booleanList.size() + " in: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int j = 0; j != 250000; ++j) {
            int n = random.nextInt();
            arrayList.add(new Integer(n));
        }
        arrayList.addAll(arrayList);
        BooleanList.p("ok...: " + arrayList.size() + " in: " + (System.currentTimeMillis() - l));
    }

    class Iterator {
        private BooleanList list;
        private int pos;

        public Iterator(BooleanList booleanList2) {
            this.list = booleanList2;
        }

        public Iterator(BooleanList booleanList2, int n) {
            if (n < 0 || n > booleanList2.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.list = booleanList2;
            this.pos = n;
        }

        boolean hasNext() {
            return this.pos < this.list.size();
        }

        boolean next() {
            if (this.pos >= this.list.size() || this.pos < 0) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.pos++);
        }

        void remove() {
            throw new UnsupportedOperationException("TBD");
        }
    }
}

