/*
 * Decompiled with CFR 0.152.
 */
package org.ruby_http_parser;

import http_parser.HTTPException;
import http_parser.HTTPMethod;
import http_parser.lolevel.HTTPCallback;
import http_parser.lolevel.HTTPDataCallback;
import http_parser.lolevel.HTTPParser;
import http_parser.lolevel.ParserSettings;
import java.nio.ByteBuffer;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyHttpParser
extends RubyObject {
    public static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby2, RubyClass rubyClass) {
            return new RubyHttpParser(ruby2, rubyClass);
        }
    };
    private Ruby runtime;
    private http_parser.HTTPParser parser;
    private ParserSettings settings;
    private RubyClass eParserError;
    private RubyHash headers;
    private IRubyObject on_message_begin;
    private IRubyObject on_headers_complete;
    private IRubyObject on_body;
    private IRubyObject on_message_complete;
    private IRubyObject requestUrl;
    private IRubyObject requestPath;
    private IRubyObject queryString;
    private IRubyObject fragment;
    private IRubyObject header_value_type;
    private IRubyObject upgradeData;
    private IRubyObject callback_object;
    private String _current_header;
    private String _last_header;

    byte[] fetchBytes(ByteBuffer byteBuffer, int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = byteBuffer.position();
        byteBuffer.position(n);
        byteBuffer.get(byArray);
        byteBuffer.position(n3);
        return byArray;
    }

    public RubyHttpParser(Ruby ruby2, RubyClass rubyClass) {
        super(ruby2, rubyClass);
        this.runtime = ruby2;
        this.eParserError = (RubyClass)ruby2.getModule("HTTP").getClass("Parser").getConstant("Error");
        this.on_message_begin = null;
        this.on_headers_complete = null;
        this.on_body = null;
        this.on_message_complete = null;
        this.callback_object = null;
        this.header_value_type = ruby2.getModule("HTTP").getClass("Parser").getInstanceVariable("@default_header_value_type");
        this.initSettings();
        this.init();
    }

    private void initSettings() {
        this.settings = new ParserSettings();
        this.settings.on_url = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                byte[] byArray = RubyHttpParser.this.fetchBytes(byteBuffer, n, n2);
                ((RubyString)RubyHttpParser.this.requestUrl).concat(RubyHttpParser.this.runtime.newString(new String(byArray)));
                return 0;
            }
        };
        this.settings.on_path = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                byte[] byArray = RubyHttpParser.this.fetchBytes(byteBuffer, n, n2);
                ((RubyString)RubyHttpParser.this.requestPath).concat(RubyHttpParser.this.runtime.newString(new String(byArray)));
                return 0;
            }
        };
        this.settings.on_query_string = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                byte[] byArray = RubyHttpParser.this.fetchBytes(byteBuffer, n, n2);
                ((RubyString)RubyHttpParser.this.queryString).concat(RubyHttpParser.this.runtime.newString(new String(byArray)));
                return 0;
            }
        };
        this.settings.on_fragment = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                byte[] byArray = RubyHttpParser.this.fetchBytes(byteBuffer, n, n2);
                ((RubyString)RubyHttpParser.this.fragment).concat(RubyHttpParser.this.runtime.newString(new String(byArray)));
                return 0;
            }
        };
        this.settings.on_header_field = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                byte[] byArray = RubyHttpParser.this.fetchBytes(byteBuffer, n, n2);
                if (RubyHttpParser.this._current_header == null) {
                    RubyHttpParser.this._current_header = new String(byArray);
                } else {
                    RubyHttpParser.this._current_header = RubyHttpParser.this._current_header.concat(new String(byArray));
                }
                return 0;
            }
        };
        this.settings.on_header_value = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                byte[] byArray = RubyHttpParser.this.fetchBytes(byteBuffer, n, n2);
                ThreadContext threadContext = RubyHttpParser.this.headers.getRuntime().getCurrentContext();
                boolean bl = false;
                if (RubyHttpParser.this._current_header != null) {
                    bl = true;
                    RubyHttpParser.this._last_header = RubyHttpParser.this._current_header;
                    RubyHttpParser.this._current_header = null;
                }
                RubyString rubyString = RubyHttpParser.this.runtime.newString(RubyHttpParser.this._last_header);
                IRubyObject iRubyObject = RubyHttpParser.this.headers.op_aref(threadContext, rubyString);
                if (bl) {
                    if (iRubyObject.isNil()) {
                        if (RubyHttpParser.this.header_value_type == RubyHttpParser.this.runtime.newSymbol("arrays")) {
                            RubyHttpParser.this.headers.op_aset(threadContext, rubyString, RubyArray.newArrayLight(RubyHttpParser.this.runtime, (IRubyObject)RubyHttpParser.this.runtime.newString("")));
                        } else {
                            RubyHttpParser.this.headers.op_aset(threadContext, rubyString, RubyHttpParser.this.runtime.newString(""));
                        }
                    } else if (RubyHttpParser.this.header_value_type == RubyHttpParser.this.runtime.newSymbol("mixed")) {
                        if (iRubyObject instanceof RubyString) {
                            RubyHttpParser.this.headers.op_aset(threadContext, rubyString, RubyArray.newArrayLight(RubyHttpParser.this.runtime, iRubyObject, RubyHttpParser.this.runtime.newString("")));
                        } else {
                            ((RubyArray)iRubyObject).add(RubyHttpParser.this.runtime.newString(""));
                        }
                    } else if (RubyHttpParser.this.header_value_type == RubyHttpParser.this.runtime.newSymbol("arrays")) {
                        ((RubyArray)iRubyObject).add(RubyHttpParser.this.runtime.newString(""));
                    } else {
                        ((RubyString)iRubyObject).cat(", ".getBytes());
                    }
                    iRubyObject = RubyHttpParser.this.headers.op_aref(threadContext, rubyString);
                }
                if (iRubyObject instanceof RubyArray) {
                    iRubyObject = ((RubyArray)iRubyObject).entry(-1);
                }
                ((RubyString)iRubyObject).cat(byArray);
                return 0;
            }
        };
        this.settings.on_message_begin = new HTTPCallback(){

            public int cb(HTTPParser hTTPParser) {
                RubyHttpParser.this.headers = new RubyHash(RubyHttpParser.this.runtime);
                RubyHttpParser.this.requestUrl = RubyHttpParser.this.runtime.newString("");
                RubyHttpParser.this.requestPath = RubyHttpParser.this.runtime.newString("");
                RubyHttpParser.this.queryString = RubyHttpParser.this.runtime.newString("");
                RubyHttpParser.this.fragment = RubyHttpParser.this.runtime.newString("");
                RubyHttpParser.this.upgradeData = RubyHttpParser.this.runtime.newString("");
                IRubyObject iRubyObject = RubyHttpParser.this.runtime.getNil();
                if (RubyHttpParser.this.callback_object != null) {
                    if (((RubyObject)RubyHttpParser.this.callback_object).respond_to_p(RubyHttpParser.this.runtime.newSymbol("on_message_begin")).toJava(Boolean.class) == Boolean.TRUE) {
                        ThreadContext threadContext = RubyHttpParser.this.callback_object.getRuntime().getCurrentContext();
                        iRubyObject = RubyHttpParser.this.callback_object.callMethod(threadContext, "on_message_begin");
                    }
                } else if (RubyHttpParser.this.on_message_begin != null) {
                    ThreadContext threadContext = RubyHttpParser.this.on_message_begin.getRuntime().getCurrentContext();
                    iRubyObject = RubyHttpParser.this.on_message_begin.callMethod(threadContext, "call");
                }
                if (iRubyObject == RubyHttpParser.this.runtime.newSymbol("stop")) {
                    throw new StopException();
                }
                return 0;
            }
        };
        this.settings.on_message_complete = new HTTPCallback(){

            public int cb(HTTPParser hTTPParser) {
                IRubyObject iRubyObject = RubyHttpParser.this.runtime.getNil();
                if (RubyHttpParser.this.callback_object != null) {
                    if (((RubyObject)RubyHttpParser.this.callback_object).respond_to_p(RubyHttpParser.this.runtime.newSymbol("on_message_complete")).toJava(Boolean.class) == Boolean.TRUE) {
                        ThreadContext threadContext = RubyHttpParser.this.callback_object.getRuntime().getCurrentContext();
                        iRubyObject = RubyHttpParser.this.callback_object.callMethod(threadContext, "on_message_complete");
                    }
                } else if (RubyHttpParser.this.on_message_complete != null) {
                    ThreadContext threadContext = RubyHttpParser.this.on_message_complete.getRuntime().getCurrentContext();
                    iRubyObject = RubyHttpParser.this.on_message_complete.callMethod(threadContext, "call");
                }
                if (iRubyObject == RubyHttpParser.this.runtime.newSymbol("stop")) {
                    throw new StopException();
                }
                return 0;
            }
        };
        this.settings.on_headers_complete = new HTTPCallback(){

            public int cb(HTTPParser hTTPParser) {
                IRubyObject iRubyObject = RubyHttpParser.this.runtime.getNil();
                if (RubyHttpParser.this.callback_object != null) {
                    if (((RubyObject)RubyHttpParser.this.callback_object).respond_to_p(RubyHttpParser.this.runtime.newSymbol("on_headers_complete")).toJava(Boolean.class) == Boolean.TRUE) {
                        ThreadContext threadContext = RubyHttpParser.this.callback_object.getRuntime().getCurrentContext();
                        iRubyObject = RubyHttpParser.this.callback_object.callMethod(threadContext, "on_headers_complete", RubyHttpParser.this.headers);
                    }
                } else if (RubyHttpParser.this.on_headers_complete != null) {
                    ThreadContext threadContext = RubyHttpParser.this.on_headers_complete.getRuntime().getCurrentContext();
                    iRubyObject = RubyHttpParser.this.on_headers_complete.callMethod(threadContext, "call", RubyHttpParser.this.headers);
                }
                if (iRubyObject == RubyHttpParser.this.runtime.newSymbol("stop")) {
                    throw new StopException();
                }
                return 0;
            }
        };
        this.settings.on_body = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                IRubyObject iRubyObject = RubyHttpParser.this.runtime.getNil();
                byte[] byArray = RubyHttpParser.this.fetchBytes(byteBuffer, n, n2);
                if (RubyHttpParser.this.callback_object != null) {
                    if (((RubyObject)RubyHttpParser.this.callback_object).respond_to_p(RubyHttpParser.this.runtime.newSymbol("on_body")).toJava(Boolean.class) == Boolean.TRUE) {
                        ThreadContext threadContext = RubyHttpParser.this.callback_object.getRuntime().getCurrentContext();
                        iRubyObject = RubyHttpParser.this.callback_object.callMethod(threadContext, "on_body", RubyHttpParser.this.callback_object.getRuntime().newString(new String(byArray)));
                    }
                } else if (RubyHttpParser.this.on_body != null) {
                    ThreadContext threadContext = RubyHttpParser.this.on_body.getRuntime().getCurrentContext();
                    iRubyObject = RubyHttpParser.this.on_body.callMethod(threadContext, "call", RubyHttpParser.this.on_body.getRuntime().newString(new String(byArray)));
                }
                if (iRubyObject == RubyHttpParser.this.runtime.newSymbol("stop")) {
                    throw new StopException();
                }
                return 0;
            }
        };
    }

    private void init() {
        this.parser = new http_parser.HTTPParser();
        this.headers = null;
        this.requestUrl = this.runtime.getNil();
        this.requestPath = this.runtime.getNil();
        this.queryString = this.runtime.getNil();
        this.fragment = this.runtime.getNil();
        this.upgradeData = this.runtime.getNil();
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize() {
        return this;
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(IRubyObject iRubyObject) {
        this.callback_object = iRubyObject;
        return this.initialize();
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.header_value_type = iRubyObject2;
        return this.initialize(iRubyObject);
    }

    @JRubyMethod(name={"on_message_begin="})
    public IRubyObject set_on_message_begin(IRubyObject iRubyObject) {
        this.on_message_begin = iRubyObject;
        return iRubyObject;
    }

    @JRubyMethod(name={"on_headers_complete="})
    public IRubyObject set_on_headers_complete(IRubyObject iRubyObject) {
        this.on_headers_complete = iRubyObject;
        return iRubyObject;
    }

    @JRubyMethod(name={"on_body="})
    public IRubyObject set_on_body(IRubyObject iRubyObject) {
        this.on_body = iRubyObject;
        return iRubyObject;
    }

    @JRubyMethod(name={"on_message_complete="})
    public IRubyObject set_on_message_complete(IRubyObject iRubyObject) {
        this.on_message_complete = iRubyObject;
        return iRubyObject;
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject execute(IRubyObject iRubyObject) {
        RubyString rubyString = (RubyString)iRubyObject;
        ByteBuffer byteBuffer = ByteBuffer.wrap(rubyString.getBytes());
        boolean bl = false;
        try {
            this.parser.execute(this.settings, byteBuffer);
        }
        catch (HTTPException hTTPException) {
            throw new RaiseException(this.runtime, this.eParserError, hTTPException.getMessage(), true);
        }
        catch (StopException stopException) {
            bl = true;
        }
        if (this.parser.getUpgrade()) {
            byte[] byArray = this.fetchBytes(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
            ((RubyString)this.upgradeData).concat(this.runtime.newString(new String(byArray)));
        } else if (byteBuffer.hasRemaining() && !bl) {
            throw new RaiseException(this.runtime, this.eParserError, "Could not parse data entirely", true);
        }
        return RubyNumeric.int2fix(this.runtime, byteBuffer.position());
    }

    @JRubyMethod(name={"keep_alive?"})
    public IRubyObject shouldKeepAlive() {
        return this.parser.shouldKeepAlive() ? this.runtime.getTrue() : this.runtime.getFalse();
    }

    @JRubyMethod(name={"upgrade?"})
    public IRubyObject shouldUpgrade() {
        return this.parser.getUpgrade() ? this.runtime.getTrue() : this.runtime.getFalse();
    }

    @JRubyMethod(name={"http_major"})
    public IRubyObject httpMajor() {
        if (this.parser.getMajor() == 0 && this.parser.getMinor() == 0) {
            return this.runtime.getNil();
        }
        return RubyNumeric.int2fix(this.runtime, this.parser.getMajor());
    }

    @JRubyMethod(name={"http_minor"})
    public IRubyObject httpMinor() {
        if (this.parser.getMajor() == 0 && this.parser.getMinor() == 0) {
            return this.runtime.getNil();
        }
        return RubyNumeric.int2fix(this.runtime, this.parser.getMinor());
    }

    @JRubyMethod(name={"http_version"})
    public IRubyObject httpVersion() {
        if (this.parser.getMajor() == 0 && this.parser.getMinor() == 0) {
            return this.runtime.getNil();
        }
        return this.runtime.newArray(this.httpMajor(), this.httpMinor());
    }

    @JRubyMethod(name={"http_method"})
    public IRubyObject httpMethod() {
        HTTPMethod hTTPMethod = this.parser.getHTTPMethod();
        if (hTTPMethod != null) {
            return this.runtime.newString(new String(hTTPMethod.bytes));
        }
        return this.runtime.getNil();
    }

    @JRubyMethod(name={"status_code"})
    public IRubyObject statusCode() {
        int n = this.parser.getStatusCode();
        if (n != 0) {
            return RubyNumeric.int2fix(this.runtime, n);
        }
        return this.runtime.getNil();
    }

    @JRubyMethod(name={"headers"})
    public IRubyObject getHeaders() {
        return this.headers == null ? this.runtime.getNil() : this.headers;
    }

    @JRubyMethod(name={"request_url"})
    public IRubyObject getRequestUrl() {
        return this.requestUrl == null ? this.runtime.getNil() : this.requestUrl;
    }

    @JRubyMethod(name={"request_path"})
    public IRubyObject getRequestPath() {
        return this.requestPath == null ? this.runtime.getNil() : this.requestPath;
    }

    @JRubyMethod(name={"query_string"})
    public IRubyObject getQueryString() {
        return this.queryString == null ? this.runtime.getNil() : this.queryString;
    }

    @JRubyMethod(name={"fragment"})
    public IRubyObject getFragment() {
        return this.fragment == null ? this.runtime.getNil() : this.fragment;
    }

    @JRubyMethod(name={"header_value_type"})
    public IRubyObject getHeaderValueType() {
        return this.header_value_type == null ? this.runtime.getNil() : this.header_value_type;
    }

    @JRubyMethod(name={"header_value_type="})
    public IRubyObject set_header_value_type(IRubyObject iRubyObject) {
        if (iRubyObject != this.runtime.newSymbol("mixed") && iRubyObject != this.runtime.newSymbol("arrays") && iRubyObject != this.runtime.newSymbol("strings")) {
            throw this.runtime.newArgumentError("Invalid header value type");
        }
        this.header_value_type = iRubyObject;
        return iRubyObject;
    }

    @JRubyMethod(name={"upgrade_data"})
    public IRubyObject upgradeData() {
        return this.upgradeData == null ? this.runtime.getNil() : this.upgradeData;
    }

    @JRubyMethod(name={"reset!"})
    public IRubyObject reset() {
        this.init();
        return this.runtime.getTrue();
    }

    public class StopException
    extends RuntimeException {
    }
}

