/*
 * Decompiled with CFR 0.152.
 */
package org.racob.com;

import java.math.BigDecimal;
import java.util.Date;
import org.racob.com.Currency;
import org.racob.com.DateUtilities;
import org.racob.com.Dispatch;
import org.racob.com.SafeArray;
import org.racob.com.VariantUtilities;

public class Variant {
    public static final Variant DEFAULT;
    public static final Variant VT_MISSING;
    public static final Variant VT_TRUE;
    public static final Variant VT_FALSE;
    public static final short VariantEmpty = 0;
    public static final short VariantNull = 1;
    public static final short VariantShort = 2;
    public static final short VariantInt = 3;
    public static final short VariantFloat = 4;
    public static final short VariantDouble = 5;
    public static final short VariantCurrency = 6;
    public static final short VariantDate = 7;
    public static final short VariantString = 8;
    public static final short VariantDispatch = 9;
    public static final short VariantError = 10;
    public static final short VariantBoolean = 11;
    public static final short VariantVariant = 12;
    public static final short VariantObject = 13;
    public static final short VariantDecimal = 14;
    public static final short VariantByte = 17;
    public static final short VariantUnsignedShort = 18;
    public static final short VariantUnsignedLong = 19;
    public static final short VariantLongInt = 20;
    public static final short VariantUnsignedInt = 21;
    public static final short VariantPointer = 26;
    public static final short VariantTypeMask = 4095;
    public static final short VariantArray = 8192;
    public static final short VariantByref = 16384;
    public static final int DISP_E_PARAMNOTFOUND;
    private static boolean initialized;
    private short type;
    private Object value;

    private static native void initializeNative();

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            Variant.initializeNative();
        }
    }

    public Variant(Object value2, short vt) {
        this.value = value2;
        this.type = vt;
    }

    public Variant(Object value2, short type2, boolean byRef) {
        this(value2, (short)(type2 | (byRef ? 16384 : 0)));
    }

    public Variant() {
        this(null, 0, false);
    }

    public Variant(boolean in, boolean byRef) {
        this(new Boolean(in), 11, byRef);
    }

    public Variant(boolean in) {
        this(new Boolean(in), 11, false);
    }

    public Variant(byte in, boolean byRef) {
        this(new Byte(in), 17, byRef);
    }

    public Variant(byte in) {
        this(new Byte(in), 17, false);
    }

    public Variant(double in, boolean byRef) {
        this(new Double(in), 5, byRef);
    }

    public Variant(double in) {
        this(new Double(in), 5, false);
    }

    public Variant(float in, boolean byRef) {
        this(new Float(in), 4, byRef);
    }

    public Variant(float in) {
        this(new Float(in), 4, false);
    }

    public Variant(short in, boolean byRef) {
        this(new Short(in), 2, byRef);
    }

    public Variant(short in) {
        this(new Short(in), 2, false);
    }

    public Variant(int in, boolean byRef) {
        this(new Integer(in), 3, byRef);
    }

    public Variant(int in) {
        this(new Integer(in), 3, false);
    }

    public Variant(long in, boolean byRef) {
        this(new Long(in), 20, byRef);
    }

    public Variant(long in) {
        this(new Long(in), 20, false);
    }

    public Variant(BigDecimal decimal, boolean byRef) {
        this(decimal, 14, byRef);
    }

    public Variant(BigDecimal decimal) {
        this(decimal, 14, false);
    }

    public Variant(Currency currency, boolean byRef) {
        this(currency, 20, byRef);
    }

    public Variant(Currency currency) {
        this(currency, 20, false);
    }

    public Variant(Dispatch dispatch, boolean byRef) {
        this(dispatch, 9, byRef);
    }

    public Variant(Dispatch dispatch) {
        this(dispatch, 9, false);
    }

    public Variant(Date date, boolean byRef) {
        this(date, 7, byRef);
    }

    public Variant(Date date) {
        this(date, 7, false);
    }

    public Variant(SafeArray array, boolean byRef) {
        this(array, 8192, byRef);
    }

    public Variant(SafeArray array) {
        this(array, 8192, false);
    }

    public Variant(String string2, boolean byRef) {
        this(string2, 8, byRef);
    }

    public Variant(String string2) {
        this(string2, 8, false);
    }

    public Variant(Variant variant, boolean byRef) {
        this(variant, 12, byRef);
    }

    public Variant(Variant variant) {
        this(variant, 12, false);
    }

    private void illegal(String methodName, String variantName) {
        throw new IllegalStateException(methodName + "() only legal on Variants of type " + variantName + " not " + this.getvt());
    }

    public boolean isA(short testType) {
        return this.type == testType || this.type == (testType | 0x4000);
    }

    public boolean isArray() {
        return (this.type & 0x2000) != 0;
    }

    public boolean isByref() {
        return (this.type & 0x4000) != 0;
    }

    public short getvt() {
        return this.type;
    }

    public short getType() {
        return (short)(this.type & 0xFFFFBFFF);
    }

    public Object getValue() {
        return this.value;
    }

    public static Variant createDispatchVariant(int pointer2) {
        if (pointer2 == 0) {
            return null;
        }
        return new Variant(new Dispatch(pointer2));
    }

    public static Variant createDateVariant(double comDateValue) {
        return new Variant(DateUtilities.convertWindowsTimeToDate(comDateValue));
    }

    public static Variant createIntVariant(int value2) {
        return new Variant(new Integer(value2));
    }

    public Variant changeType(short in) {
        this.type = in;
        return this;
    }

    public SafeArray getArray() {
        if (!this.isArray()) {
            this.illegal("getArray", "VariantArray");
        }
        return (SafeArray)this.value;
    }

    public boolean getBoolean() {
        if (!this.isA((short)11)) {
            this.illegal("getBoolean", "VariantBoolean");
        }
        return (Boolean)this.value;
    }

    public byte getByte() {
        if (!this.isA((short)17)) {
            this.illegal("getByte", "VariantByte");
        }
        return (Byte)this.value;
    }

    public Currency getCurrency() {
        if (!this.isA((short)6)) {
            this.illegal("getCurrency", "VariantCurrency");
        }
        return (Currency)this.value;
    }

    public long getCurrencyAsLong() {
        return this.getCurrency().longValue();
    }

    public Date getDate() {
        if (!this.isA((short)7)) {
            this.illegal("getDate", "VariantDate");
        }
        return (Date)this.value;
    }

    public double getDateAsDouble() {
        return DateUtilities.convertDateToWindowsTime(this.getDate());
    }

    public BigDecimal getDecimal() {
        if (!this.isA((short)14)) {
            this.illegal("getDecimal", "VariantDecimal");
        }
        return (BigDecimal)this.value;
    }

    public Dispatch getDispatch() {
        if (!this.isA((short)9)) {
            this.illegal("getDispatch", "VariantDispatch");
        }
        return (Dispatch)this.value;
    }

    public int getDispatchPointer() {
        return this.getDispatch().pointer.get();
    }

    public double getDouble() {
        if (!this.isA((short)5)) {
            this.illegal("getDouble", "VariantDouble");
        }
        return (Double)this.value;
    }

    public int getError() {
        if (!this.isA((short)10)) {
            this.illegal("getError", "VariantError");
        }
        return (Integer)this.value;
    }

    public float getFloat() {
        if (!this.isA((short)4)) {
            this.illegal("getFloat", "VariantFloat");
        }
        return ((Float)this.value).floatValue();
    }

    public int getInt() {
        if (this.isA((short)21)) {
            return (Integer)this.value;
        }
        if (this.isA((short)3)) {
            return (Integer)this.value;
        }
        if (this.isA((short)2)) {
            return ((Short)this.value).shortValue();
        }
        this.illegal("getInt", "VariantInt");
        return -1;
    }

    @Deprecated
    public Date getJavaDate() {
        return this.getDate();
    }

    public long getLong() {
        if (!this.isA((short)20) && !this.isA((short)19)) {
            this.illegal("getLong", "VariantLongInt");
        }
        return (Long)this.value;
    }

    public SafeArray getSafeArray() {
        return (SafeArray)this.value;
    }

    @Deprecated
    public SafeArray toSafeArray(boolean something) {
        return this.getSafeArray();
    }

    public short getShort() {
        if (!this.isA((short)2) && !this.isA((short)18)) {
            this.illegal("getShort", "VariantShort");
        }
        return (Short)this.value;
    }

    public String getString() {
        if (!this.isA((short)8)) {
            this.illegal("getString", "VariantString");
        }
        return (String)this.value;
    }

    public Variant getVariant() {
        if (!this.isA((short)12) || !this.isByref()) {
            this.illegal("getVariant", "VariantVariant");
        }
        return (Variant)this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public Object toJavaObject() {
        return VariantUtilities.variantToObject(this);
    }

    public String toDebugString() {
        StringBuilder buf = new StringBuilder("Variant: ");
        switch (this.getType()) {
            case 0: {
                buf.append("Empty");
                break;
            }
            case 1: {
                buf.append("Null");
                break;
            }
            case 2: {
                buf.append("Short [" + this.value + "]");
                break;
            }
            case 3: {
                buf.append("Int [" + this.value + "]");
                break;
            }
            case 4: {
                buf.append("Float [" + this.value + "]");
                break;
            }
            case 5: {
                buf.append("Double [" + this.value + "]");
                break;
            }
            case 6: {
                buf.append("Currency [" + this.value + "]");
                break;
            }
            case 7: {
                buf.append("Date [" + this.value + "]");
                break;
            }
            case 8: {
                buf.append("String [" + this.value + "]");
                break;
            }
            case 9: {
                buf.append("Dispatch [" + this.value + "]");
                break;
            }
            case 10: {
                buf.append("Error [" + this.value + "]");
                break;
            }
            case 11: {
                buf.append("Boolean [" + this.value + "]");
                break;
            }
            case 12: {
                buf.append("Variant [" + this.value + "]");
                break;
            }
            case 13: {
                buf.append("Object [" + this.value + "]");
                break;
            }
            case 14: {
                buf.append("Decimal [" + this.value + "]");
                break;
            }
            case 17: {
                buf.append("Byte [" + this.value + "]");
                break;
            }
            case 20: {
                buf.append("LongInt [" + this.value + "]");
                break;
            }
            case 26: {
                buf.append("Pointer [" + this.value + "]");
                break;
            }
            case 4095: {
                buf.append("TypeMask [" + this.value + "]");
                break;
            }
            case 8192: {
                buf.append("Array [" + this.value + "]");
                break;
            }
            case 16384: {
                buf.append("ByRef???");
                break;
            }
            default: {
                buf.append("Uknown type: ").append(this.type);
            }
        }
        if (this.isByref()) {
            buf.append("<BYREF>");
        }
        return buf.toString();
    }

    public String toString() {
        short vt = this.getvt();
        if (vt == 0 || vt == 10 || vt == 1) {
            return "null";
        }
        if (vt == 8) {
            return this.getString();
        }
        try {
            Object foo = this.toJavaObject();
            if (foo == null) {
                return "{Java null}";
            }
            return foo.toString();
        }
        catch (RuntimeException e) {
            return "Description not available for type: " + this.getvt();
        }
    }

    static {
        Variant vtMissing;
        VT_TRUE = new Variant(true, false);
        VT_FALSE = new Variant(false, false);
        DISP_E_PARAMNOTFOUND = new Integer(-2147352572);
        Variant.initialize();
        DEFAULT = vtMissing = new Variant(DISP_E_PARAMNOTFOUND, 10, false);
        VT_MISSING = vtMissing;
    }
}

