/*
 * Decompiled with CFR 0.152.
 */
package org.racob.com;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.racob.com.ComThread;
import org.racob.com.IUnknown;
import org.racob.com.LibraryLoader;
import org.racob.com.PointerWeakReference;

public abstract class ROT {
    private static ThreadLocal<Boolean> apartmentInitialized = new ThreadLocal<Boolean>(){

        @Override
        public Boolean initialValue() {
            return FALSE;
        }
    };
    public static Map<PointerWeakReference, Boolean> objects = new ConcurrentHashMap<PointerWeakReference, Boolean>();
    private static final Boolean FALSE = new Boolean(false);
    private static final Boolean TRUE = new Boolean(true);
    private static int count = 0;
    private static final int CULL_COUNT;
    private static final int GC_COUNT;
    private static final boolean AUTO_GC;
    private static ThreadLocal<ReferenceQueue<IUnknown>> deadPool;

    public static Map<PointerWeakReference, Boolean> getThreadObjects(boolean ignored) {
        return objects;
    }

    protected static void clearObjects() {
        if (IUnknown.isDebugEnabled()) {
            IUnknown.debug("ROT: " + objects.size() + " objects to clear in this thread's ROT ");
        }
        for (PointerWeakReference reference2 : objects.keySet()) {
            IUnknown value2 = (IUnknown)reference2.get();
            if (value2 == null) continue;
            value2.safeRelease();
        }
        objects.clear();
    }

    protected static void addObject(IUnknown o) {
        if (apartmentInitialized.get() == FALSE) {
            ComThread.InitSTA(false);
            apartmentInitialized.set(TRUE);
        }
        if (!AUTO_GC) {
            return;
        }
        ReferenceQueue<IUnknown> deadObjects = deadPool.get();
        objects.put(new PointerWeakReference(o, deadObjects), FALSE);
        if (GC_COUNT != -1 && count % GC_COUNT == 0) {
            System.gc();
        }
        if (count++ % CULL_COUNT == 0) {
            int numberCulled = ROT.cullDeadPool(deadObjects, objects);
            if (IUnknown.isDebugEnabled() && numberCulled > 0) {
                IUnknown.debug("ROT: added instance of " + o.getClass().getSimpleName() + "->[+1, -" + numberCulled + "] with " + objects.size() + " remaining live objects");
            }
        }
    }

    protected static int cullDeadPool(ReferenceQueue<IUnknown> deadObjects, Map<PointerWeakReference, Boolean> liveList) {
        Reference<IUnknown> deadReference;
        int numberReleased = 0;
        while ((deadReference = deadObjects.poll()) != null) {
            ((PointerWeakReference)deadReference).safeRelease();
            liveList.remove(deadReference);
            ++numberReleased;
        }
        return numberReleased;
    }

    static {
        String cull_count = System.getProperty("org.racob.cull_count");
        if (cull_count == null) {
            cull_count = "2000";
        }
        CULL_COUNT = Integer.parseInt(cull_count);
        String gc_count = System.getProperty("org.racob.gc_count");
        if (gc_count == null) {
            gc_count = "-1";
        }
        GC_COUNT = Integer.parseInt(gc_count);
        String auto_gc = System.getProperty("org.racob.autogc");
        if (auto_gc == null) {
            auto_gc = "false";
        }
        AUTO_GC = Boolean.parseBoolean(auto_gc);
        deadPool = new ThreadLocal<ReferenceQueue<IUnknown>>(){

            @Override
            protected ReferenceQueue<IUnknown> initialValue() {
                return new ReferenceQueue<IUnknown>();
            }
        };
        LibraryLoader.loadLibrary();
    }
}

