/*
 * Decompiled with CFR 0.152.
 */
package org.racob.com;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.racob.com.IUnknown;

public final class LibraryLoader {
    public static final String RACOB_DLL_PATH = "racob.dll.path";
    public static final String RACOB_DLL_NAME = "racob.dll.name";
    public static final String RACOB_DLL_NAME_X86 = "racob.dll.name.x86";
    public static final String RACOB_DLL_NAME_X64 = "racob.dll.name.x64";
    public static final String DLL_NAME_MODIFIER_32_BIT = "x86";
    public static final String DLL_NAME_MODIFIER_64_BIT = "x64";

    public static void loadLibrary() {
        String path2;
        ResourceBundle resources = null;
        HashSet<String> keys2 = new HashSet<String>();
        try {
            resources = ResourceBundle.getBundle(LibraryLoader.class.getName(), Locale.getDefault(), LibraryLoader.class.getClassLoader());
            Enumeration<String> i2 = resources.getKeys();
            while (i2.hasMoreElements()) {
                String key2 = i2.nextElement();
                keys2.add(key2);
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if ((path2 = System.getProperty(RACOB_DLL_PATH)) == null && resources != null && keys2.contains(RACOB_DLL_PATH)) {
            path2 = (String)resources.getObject(RACOB_DLL_PATH);
        }
        if (path2 != null) {
            IUnknown.debug("Loading library " + path2 + " using System.loadLibrary ");
            System.load(path2);
        } else {
            String name2 = null;
            name2 = System.getProperty(RACOB_DLL_NAME) != null ? System.getProperty(RACOB_DLL_NAME) : (System.getProperty(RACOB_DLL_NAME_X86) != null && LibraryLoader.shouldLoad32Bit() ? System.getProperty(RACOB_DLL_NAME_X86) : (System.getProperty(RACOB_DLL_NAME_X64) != null && !LibraryLoader.shouldLoad32Bit() ? System.getProperty(RACOB_DLL_NAME_X64) : (resources != null && keys2.contains(RACOB_DLL_NAME) ? resources.getString(RACOB_DLL_NAME) : (resources != null && keys2.contains(RACOB_DLL_NAME_X86) && LibraryLoader.shouldLoad32Bit() ? resources.getString(RACOB_DLL_NAME_X86) : (resources != null && keys2.contains(RACOB_DLL_NAME_X64) && !LibraryLoader.shouldLoad32Bit() ? resources.getString(RACOB_DLL_NAME_X64) : LibraryLoader.getPreferredDLLName())))));
            IUnknown.debug("Loading library " + name2 + " using System.loadLibrary ");
            System.loadLibrary(name2);
        }
    }

    public static String getPreferredDLLName() {
        if (LibraryLoader.shouldLoad32Bit()) {
            return "racob-x86";
        }
        return "racob-x64";
    }

    protected static boolean shouldLoad32Bit() {
        String bits = System.getProperty("sun.arch.data.model", "?");
        if (bits.equals("32")) {
            return true;
        }
        if (bits.equals("64")) {
            return false;
        }
        String arch = System.getProperty("java.vm.name", "?");
        return arch.toLowerCase().indexOf("64-bit") < 0;
    }
}

