/*
 * Decompiled with CFR 0.152.
 */
package org.racob.activeX;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.racob.com.InvocationProxy;
import org.racob.com.Variant;
import org.racob.com.VariantUtilities;

public class ActiveXInvocationProxy
extends InvocationProxy {
    @Override
    public Variant invoke(String methodName, Variant[] targetParameters) {
        Variant mVariantToBeReturned = null;
        if (this.mTargetObject == null) {
            return null;
        }
        Class<?> targetClass = this.mTargetObject.getClass();
        if (methodName == null) {
            throw new IllegalArgumentException("InvocationProxy: missing method name");
        }
        if (targetParameters == null) {
            throw new IllegalArgumentException("InvocationProxy: missing Variant parameters");
        }
        try {
            Object[] parametersAsJavaObjects = this.getParametersAsJavaObjects(targetParameters);
            Class[] parametersAsJavaClasses = this.getParametersAsJavaClasses(parametersAsJavaObjects);
            Method targetMethod = targetClass.getMethod(methodName, parametersAsJavaClasses);
            if (targetMethod != null) {
                Object mReturnedByInvocation = null;
                mReturnedByInvocation = targetMethod.invoke(this.mTargetObject, parametersAsJavaObjects);
                mVariantToBeReturned = mReturnedByInvocation == null ? null : (!(mReturnedByInvocation instanceof Variant) ? VariantUtilities.objectToVariant(mReturnedByInvocation) : (Variant)mReturnedByInvocation);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            IllegalArgumentException oneWeShouldToss = new IllegalArgumentException("Unable to map parameters for method " + methodName + ": " + e.toString());
            oneWeShouldToss.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return mVariantToBeReturned;
    }

    private Class[] getParametersAsJavaClasses(Object[] parametersAsJavaObjects) {
        if (parametersAsJavaObjects == null) {
            throw new IllegalArgumentException("This only works with an array of parameters");
        }
        int numParameters = parametersAsJavaObjects.length;
        Class[] parametersAsJavaClasses = new Class[numParameters];
        for (int parameterIndex = 0; parameterIndex < numParameters; ++parameterIndex) {
            Class<?> oneParameterClass;
            Object oneParameterObject = parametersAsJavaObjects[parameterIndex];
            parametersAsJavaClasses[parameterIndex] = oneParameterObject == null ? null : (oneParameterClass = oneParameterObject.getClass());
        }
        return parametersAsJavaClasses;
    }

    private Object[] getParametersAsJavaObjects(Variant[] targetParameters) {
        if (targetParameters == null) {
            throw new IllegalArgumentException("This only works with an array of parameters");
        }
        int numParameters = targetParameters.length;
        Object[] parametersAsJavaObjects = new Object[numParameters];
        for (int parameterIndex = 0; parameterIndex < numParameters; ++parameterIndex) {
            Variant oneParameterObject = targetParameters[parameterIndex];
            if (oneParameterObject == null) {
                parametersAsJavaObjects[parameterIndex] = null;
                continue;
            }
            try {
                parametersAsJavaObjects[parameterIndex] = oneParameterObject.toJavaObject();
                continue;
            }
            catch (RuntimeException nie) {
                throw new IllegalArgumentException("Can't convert parameter " + parameterIndex + " type " + oneParameterObject.getvt() + " to java object: " + nie.getMessage());
            }
        }
        return parametersAsJavaObjects;
    }
}

