/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.unpacker;

import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.msgpack.packer.Unconverter;
import org.msgpack.type.Value;
import org.msgpack.unpacker.AbstractUnpacker;

public class UnpackerIterator
implements Iterator<Value> {
    private final AbstractUnpacker u;
    private final Unconverter uc;
    private IOException exception;

    public UnpackerIterator(AbstractUnpacker u) {
        this.u = u;
        this.uc = new Unconverter(u.msgpack);
    }

    @Override
    public boolean hasNext() {
        if (this.uc.getResult() != null) {
            return true;
        }
        try {
            this.u.readValue(this.uc);
        }
        catch (EOFException ex) {
            return false;
        }
        catch (IOException ex) {
            this.exception = ex;
            return false;
        }
        return this.uc.getResult() != null;
    }

    @Override
    public Value next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Value v = this.uc.getResult();
        this.uc.resetResult();
        return v;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public IOException getException() {
        return this.exception;
    }
}

