/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.type;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.msgpack.packer.Packer;
import org.msgpack.type.AbstractMapValue;
import org.msgpack.type.MapValue;
import org.msgpack.type.Value;

class SequentialMapValueImpl
extends AbstractMapValue {
    private static SequentialMapValueImpl emptyInstance = new SequentialMapValueImpl(new Value[0], true);
    private Value[] array;

    public static MapValue getEmptyInstance() {
        return emptyInstance;
    }

    @Override
    public Value[] getKeyValueArray() {
        return this.array;
    }

    SequentialMapValueImpl(Value[] array, boolean gift) {
        if (array.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        if (gift) {
            this.array = array;
        } else {
            this.array = new Value[array.length];
            System.arraycopy(array, 0, this.array, 0, array.length);
        }
    }

    @Override
    public Value get(Object key2) {
        if (key2 == null) {
            return null;
        }
        for (int i2 = this.array.length - 2; i2 >= 0; i2 -= 2) {
            if (!this.array[i2].equals(key2)) continue;
            return this.array[i2 + 1];
        }
        return null;
    }

    @Override
    public Set<Map.Entry<Value, Value>> entrySet() {
        return new EntrySet(this.array);
    }

    @Override
    public Set<Value> keySet() {
        return new KeySet(this.array);
    }

    @Override
    public Collection<Value> values() {
        return new ValueCollection(this.array);
    }

    @Override
    public void writeTo(Packer pk) throws IOException {
        pk.writeMapBegin(this.array.length / 2);
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            this.array[i2].writeTo(pk);
        }
        pk.writeMapEnd();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value v = (Value)o;
        if (!v.isMapValue()) {
            return false;
        }
        MapValue om = v.asMapValue();
        if (om.size() != this.array.length / 2) {
            return false;
        }
        try {
            for (int i2 = 0; i2 < this.array.length; i2 += 2) {
                Value value2 = this.array[i2 + 1];
                Value key2 = this.array[i2];
                if (value2.equals(om.get(key2))) continue;
                return false;
            }
        }
        catch (ClassCastException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (int i2 = 0; i2 < this.array.length; i2 += 2) {
            h += this.array[i2].hashCode() ^ this.array[i2 + 1].hashCode();
        }
        return h;
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (this.array.length == 0) {
            return sb.append("{}");
        }
        sb.append("{");
        sb.append(this.array[0]);
        sb.append(":");
        sb.append(this.array[1]);
        for (int i2 = 2; i2 < this.array.length; i2 += 2) {
            sb.append(",");
            this.array[i2].toString(sb);
            sb.append(":");
            this.array[i2 + 1].toString(sb);
        }
        sb.append("}");
        return sb;
    }

    private static class ValueIterator
    implements Iterator<Value> {
        private Value[] array;
        private int pos;

        ValueIterator(Value[] array, int offset2) {
            this.array = array;
            this.pos = offset2;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.array.length;
        }

        @Override
        public Value next() {
            if (this.pos >= this.array.length) {
                throw new NoSuchElementException();
            }
            Value v = this.array[this.pos];
            this.pos += 2;
            return v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ValueCollection
    extends AbstractCollection<Value> {
        private Value[] array;

        ValueCollection(Value[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length / 2;
        }

        @Override
        public Iterator<Value> iterator() {
            return new ValueIterator(this.array, 1);
        }
    }

    private static class KeySet
    extends AbstractSet<Value> {
        private Value[] array;

        KeySet(Value[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length / 2;
        }

        @Override
        public Iterator<Value> iterator() {
            return new ValueIterator(this.array, 0);
        }
    }

    private static class EntrySetIterator
    implements Iterator<Map.Entry<Value, Value>> {
        private Value[] array;
        private int pos;

        EntrySetIterator(Value[] array) {
            this.array = array;
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.array.length;
        }

        @Override
        public Map.Entry<Value, Value> next() {
            if (this.pos >= this.array.length) {
                throw new NoSuchElementException();
            }
            AbstractMap.SimpleImmutableEntry<Value, Value> pair = new AbstractMap.SimpleImmutableEntry<Value, Value>(this.array[this.pos], this.array[this.pos + 1]);
            this.pos += 2;
            return pair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class EntrySet
    extends AbstractSet<Map.Entry<Value, Value>> {
        private Value[] array;

        EntrySet(Value[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length / 2;
        }

        @Override
        public Iterator<Map.Entry<Value, Value>> iterator() {
            return new EntrySetIterator(this.array);
        }
    }
}

