/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.type;

import java.io.IOException;
import java.util.ListIterator;
import org.msgpack.packer.Packer;
import org.msgpack.type.AbstractArrayValue;
import org.msgpack.type.ArrayValue;
import org.msgpack.type.Value;

class ArrayValueImpl
extends AbstractArrayValue {
    private static ArrayValueImpl emptyInstance = new ArrayValueImpl(new Value[0], true);
    private Value[] array;

    public static ArrayValue getEmptyInstance() {
        return emptyInstance;
    }

    @Override
    public Value[] getElementArray() {
        return this.array;
    }

    ArrayValueImpl(Value[] array, boolean gift) {
        if (gift) {
            this.array = array;
        } else {
            this.array = new Value[array.length];
            System.arraycopy(array, 0, this.array, 0, array.length);
        }
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public Value get(int index2) {
        if (index2 < 0 || this.array.length <= index2) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index2];
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            if (!this.array[i2].equals(o)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            return -1;
        }
        for (int i2 = this.array.length - 1; i2 >= 0; --i2) {
            if (!this.array[i2].equals(o)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public void writeTo(Packer pk) throws IOException {
        pk.writeArrayBegin(this.array.length);
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            this.array[i2].writeTo(pk);
        }
        pk.writeArrayEnd();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value v = (Value)o;
        if (!v.isArrayValue()) {
            return false;
        }
        if (v.getClass() == ArrayValueImpl.class) {
            return this.equals((ArrayValueImpl)v);
        }
        ListIterator oi = v.asArrayValue().listIterator();
        int i2 = 0;
        while (i2 < this.array.length) {
            if (oi.hasNext() && this.array[i2].equals(oi.next())) continue;
            return false;
        }
        return !oi.hasNext();
    }

    private boolean equals(ArrayValueImpl o) {
        if (this.array.length != o.array.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            if (this.array[i2].equals(o.array[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 1;
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            Value obj = this.array[i2];
            h = 31 * h + obj.hashCode();
        }
        return h;
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (this.array.length == 0) {
            return sb.append("[]");
        }
        sb.append("[");
        sb.append(this.array[0]);
        for (int i2 = 1; i2 < this.array.length; ++i2) {
            sb.append(",");
            this.array[i2].toString(sb);
        }
        sb.append("]");
        return sb;
    }
}

