/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.template.FieldOption;
import org.msgpack.template.Template;
import org.msgpack.template.TemplateRegistry;
import org.msgpack.template.builder.AbstractTemplateBuilder;
import org.msgpack.template.builder.BuildContext;
import org.msgpack.template.builder.DefaultBuildContext;
import org.msgpack.template.builder.FieldEntry;

public class JavassistTemplateBuilder
extends AbstractTemplateBuilder {
    private static Logger LOG = Logger.getLogger(JavassistTemplateBuilder.class.getName());
    protected ClassPool pool = new ClassPool();
    protected int seqId = 0;

    public JavassistTemplateBuilder(TemplateRegistry registry) {
        super(registry);
        boolean appended = false;
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                this.pool.appendClassPath(new LoaderClassPath(cl));
                appended = true;
            }
        }
        catch (SecurityException e) {
            LOG.fine("Cannot append a search path of context classloader");
            e.printStackTrace();
        }
        try {
            ClassLoader cl2 = this.getClass().getClassLoader();
            if (cl2 != null && cl2 != cl) {
                this.pool.appendClassPath(new LoaderClassPath(cl2));
                appended = true;
            }
        }
        catch (SecurityException e) {
            LOG.fine("Cannot append a search path of classloader");
            e.printStackTrace();
        }
        if (!appended) {
            this.pool.appendSystemPath();
        }
    }

    @Override
    public boolean matchType(Type targetType, boolean hasAnnotation) {
        Class targetClass = (Class)targetType;
        boolean matched2 = JavassistTemplateBuilder.matchAtClassTemplateBuilder(targetClass, hasAnnotation);
        if (matched2 && LOG.isLoggable(Level.FINE)) {
            LOG.fine("matched type: " + targetClass.getName());
        }
        return matched2;
    }

    public void addClassLoader(ClassLoader cl) {
        this.pool.appendClassPath(new LoaderClassPath(cl));
    }

    protected CtClass makeCtClass(String className) {
        return this.pool.makeClass(className);
    }

    protected CtClass getCtClass(String className) throws NotFoundException {
        return this.pool.get(className);
    }

    protected int nextSeqId() {
        return this.seqId++;
    }

    protected BuildContext createBuildContext() {
        return new DefaultBuildContext(this);
    }

    @Override
    public <T> Template<T> buildTemplate(Class<T> targetClass, FieldEntry[] entries2) {
        Template[] tmpls = this.toTemplate(entries2);
        BuildContext bc = this.createBuildContext();
        return bc.buildTemplate(targetClass, entries2, tmpls);
    }

    private Template<?>[] toTemplate(FieldEntry[] from) {
        Template[] tmpls = new Template[from.length];
        for (int i2 = 0; i2 < from.length; ++i2) {
            Template tmpl;
            FieldEntry e = from[i2];
            tmpls[i2] = !e.isAvailable() ? null : (tmpl = this.registry.lookup(e.getGenericType()));
        }
        return tmpls;
    }

    @Override
    public void writeTemplate(Type targetType, String directoryName) {
        Class targetClass = (Class)targetType;
        this.checkClassValidation(targetClass);
        FieldOption implicitOption = this.getFieldOption(targetClass);
        FieldEntry[] entries2 = this.toFieldEntries(targetClass, implicitOption);
        this.writeTemplate(targetClass, entries2, directoryName);
    }

    private void writeTemplate(Class<?> targetClass, FieldEntry[] entries2, String directoryName) {
        Template[] tmpls = this.toTemplate(entries2);
        BuildContext bc = this.createBuildContext();
        bc.writeTemplate(targetClass, entries2, tmpls, directoryName);
    }

    @Override
    public <T> Template<T> loadTemplate(Type targetType) {
        Class targetClass = (Class)targetType;
        try {
            String tmplName = targetClass.getName() + "_$$_Template";
            ClassLoader cl = targetClass.getClassLoader();
            if (cl == null) {
                return null;
            }
            cl.loadClass(tmplName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        FieldOption implicitOption = this.getFieldOption(targetClass);
        FieldEntry[] entries2 = this.toFieldEntries(targetClass, implicitOption);
        Template[] tmpls = this.toTemplate(entries2);
        BuildContext bc = this.createBuildContext();
        return bc.loadTemplate(targetClass, entries2, tmpls);
    }

    public static abstract class JavassistTemplate<T>
    extends AbstractTemplate<T> {
        public Class<T> targetClass;
        public Template<?>[] templates;

        public JavassistTemplate(Class<T> targetClass, Template<?>[] templates) {
            this.targetClass = targetClass;
            this.templates = templates;
        }
    }
}

