/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import java.lang.reflect.Array;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.template.Template;
import org.msgpack.unpacker.Unpacker;

public class ObjectArrayTemplate
extends AbstractTemplate {
    protected Class componentClass;
    protected Template componentTemplate;

    public ObjectArrayTemplate(Class componentClass, Template componentTemplate) {
        this.componentClass = componentClass;
        this.componentTemplate = componentTemplate;
    }

    @Override
    public void write(Packer packer, Object v, boolean required) throws IOException {
        if (v == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            packer.writeNil();
            return;
        }
        if (!(v instanceof Object[]) || !this.componentClass.isAssignableFrom(v.getClass().getComponentType())) {
            throw new MessageTypeException();
        }
        Object[] array = (Object[])v;
        int length2 = array.length;
        packer.writeArrayBegin(length2);
        for (int i2 = 0; i2 < length2; ++i2) {
            this.componentTemplate.write(packer, array[i2], required);
        }
        packer.writeArrayEnd();
    }

    @Override
    public Object read(Unpacker unpacker, Object to, boolean required) throws IOException {
        if (!required && unpacker.trySkipNil()) {
            return null;
        }
        int length2 = unpacker.readArrayBegin();
        Object[] array = (Object[])Array.newInstance(this.componentClass, length2);
        for (int i2 = 0; i2 < length2; ++i2) {
            array[i2] = this.componentTemplate.read(unpacker, null, required);
        }
        unpacker.readArrayEnd();
        return array;
    }
}

