/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.unpacker.Unpacker;

public class LongArrayTemplate
extends AbstractTemplate<long[]> {
    static final LongArrayTemplate instance = new LongArrayTemplate();

    private LongArrayTemplate() {
    }

    @Override
    public void write(Packer pk, long[] target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.writeArrayBegin(target.length);
        for (long a : target) {
            pk.write(a);
        }
        pk.writeArrayEnd();
    }

    @Override
    public long[] read(Unpacker u, long[] to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readArrayBegin();
        if (to == null || to.length != n) {
            to = new long[n];
        }
        for (int i2 = 0; i2 < n; ++i2) {
            to[i2] = u.readLong();
        }
        u.readArrayEnd();
        return to;
    }

    public static LongArrayTemplate getInstance() {
        return instance;
    }
}

