/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.packer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.msgpack.MessagePack;
import org.msgpack.MessageTypeException;
import org.msgpack.io.Output;
import org.msgpack.io.StreamOutput;
import org.msgpack.packer.AbstractPacker;
import org.msgpack.packer.Packer;
import org.msgpack.packer.PackerStack;

public class MessagePackPacker
extends AbstractPacker {
    protected final Output out;
    private PackerStack stack = new PackerStack();

    public MessagePackPacker(MessagePack msgpack, OutputStream stream) {
        this(msgpack, new StreamOutput(stream));
    }

    protected MessagePackPacker(MessagePack msgpack, Output out) {
        super(msgpack);
        this.out = out;
    }

    @Override
    protected void writeByte(byte d) throws IOException {
        if (d < -32) {
            this.out.writeByteAndByte((byte)-48, d);
        } else {
            this.out.writeByte(d);
        }
        this.stack.reduceCount();
    }

    @Override
    protected void writeShort(short d) throws IOException {
        if (d < -32) {
            if (d < -128) {
                this.out.writeByteAndShort((byte)-47, d);
            } else {
                this.out.writeByteAndByte((byte)-48, (byte)d);
            }
        } else if (d < 128) {
            this.out.writeByte((byte)d);
        } else if (d < 256) {
            this.out.writeByteAndByte((byte)-52, (byte)d);
        } else {
            this.out.writeByteAndShort((byte)-51, d);
        }
        this.stack.reduceCount();
    }

    @Override
    protected void writeInt(int d) throws IOException {
        if (d < -32) {
            if (d < Short.MIN_VALUE) {
                this.out.writeByteAndInt((byte)-46, d);
            } else if (d < -128) {
                this.out.writeByteAndShort((byte)-47, (short)d);
            } else {
                this.out.writeByteAndByte((byte)-48, (byte)d);
            }
        } else if (d < 128) {
            this.out.writeByte((byte)d);
        } else if (d < 256) {
            this.out.writeByteAndByte((byte)-52, (byte)d);
        } else if (d < 65536) {
            this.out.writeByteAndShort((byte)-51, (short)d);
        } else {
            this.out.writeByteAndInt((byte)-50, d);
        }
        this.stack.reduceCount();
    }

    @Override
    protected void writeLong(long d) throws IOException {
        if (d < -32L) {
            if (d < -32768L) {
                if (d < Integer.MIN_VALUE) {
                    this.out.writeByteAndLong((byte)-45, d);
                } else {
                    this.out.writeByteAndInt((byte)-46, (int)d);
                }
            } else if (d < -128L) {
                this.out.writeByteAndShort((byte)-47, (short)d);
            } else {
                this.out.writeByteAndByte((byte)-48, (byte)d);
            }
        } else if (d < 128L) {
            this.out.writeByte((byte)d);
        } else if (d < 65536L) {
            if (d < 256L) {
                this.out.writeByteAndByte((byte)-52, (byte)d);
            } else {
                this.out.writeByteAndShort((byte)-51, (short)d);
            }
        } else if (d < 0x100000000L) {
            this.out.writeByteAndInt((byte)-50, (int)d);
        } else {
            this.out.writeByteAndLong((byte)-49, d);
        }
        this.stack.reduceCount();
    }

    @Override
    protected void writeBigInteger(BigInteger d) throws IOException {
        if (d.bitLength() <= 63) {
            this.writeLong(d.longValue());
            this.stack.reduceCount();
        } else if (d.bitLength() == 64 && d.signum() == 1) {
            this.out.writeByteAndLong((byte)-49, d.longValue());
            this.stack.reduceCount();
        } else {
            throw new MessageTypeException("MessagePack can't serialize BigInteger larger than (2^64)-1");
        }
    }

    @Override
    protected void writeFloat(float d) throws IOException {
        this.out.writeByteAndFloat((byte)-54, d);
        this.stack.reduceCount();
    }

    @Override
    protected void writeDouble(double d) throws IOException {
        this.out.writeByteAndDouble((byte)-53, d);
        this.stack.reduceCount();
    }

    @Override
    protected void writeBoolean(boolean d) throws IOException {
        if (d) {
            this.out.writeByte((byte)-61);
        } else {
            this.out.writeByte((byte)-62);
        }
        this.stack.reduceCount();
    }

    @Override
    protected void writeByteArray(byte[] b, int off, int len) throws IOException {
        if (len < 32) {
            this.out.writeByte((byte)(0xA0 | len));
        } else if (len < 65536) {
            this.out.writeByteAndShort((byte)-38, (short)len);
        } else {
            this.out.writeByteAndInt((byte)-37, len);
        }
        this.out.write(b, off, len);
        this.stack.reduceCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeByteBuffer(ByteBuffer bb) throws IOException {
        int len = bb.remaining();
        if (len < 32) {
            this.out.writeByte((byte)(0xA0 | len));
        } else if (len < 65536) {
            this.out.writeByteAndShort((byte)-38, (short)len);
        } else {
            this.out.writeByteAndInt((byte)-37, len);
        }
        int pos2 = bb.position();
        try {
            this.out.write(bb);
        }
        finally {
            bb.position(pos2);
        }
        this.stack.reduceCount();
    }

    @Override
    protected void writeString(String s2) throws IOException {
        byte[] b;
        try {
            b = s2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new MessageTypeException(ex);
        }
        this.writeByteArray(b, 0, b.length);
        this.stack.reduceCount();
    }

    @Override
    public Packer writeNil() throws IOException {
        this.out.writeByte((byte)-64);
        this.stack.reduceCount();
        return this;
    }

    @Override
    public Packer writeArrayBegin(int size2) throws IOException {
        if (size2 < 16) {
            this.out.writeByte((byte)(0x90 | size2));
        } else if (size2 < 65536) {
            this.out.writeByteAndShort((byte)-36, (short)size2);
        } else {
            this.out.writeByteAndInt((byte)-35, size2);
        }
        this.stack.reduceCount();
        this.stack.pushArray(size2);
        return this;
    }

    @Override
    public Packer writeArrayEnd(boolean check2) throws IOException {
        if (!this.stack.topIsArray()) {
            throw new MessageTypeException("writeArrayEnd() is called but writeArrayBegin() is not called");
        }
        int remain = this.stack.getTopCount();
        if (remain > 0) {
            if (check2) {
                throw new MessageTypeException("writeArrayEnd(check=true) is called but the array is not end: " + remain);
            }
            for (int i2 = 0; i2 < remain; ++i2) {
                this.writeNil();
            }
        }
        this.stack.pop();
        return this;
    }

    @Override
    public Packer writeMapBegin(int size2) throws IOException {
        if (size2 < 16) {
            this.out.writeByte((byte)(0x80 | size2));
        } else if (size2 < 65536) {
            this.out.writeByteAndShort((byte)-34, (short)size2);
        } else {
            this.out.writeByteAndInt((byte)-33, size2);
        }
        this.stack.reduceCount();
        this.stack.pushMap(size2);
        return this;
    }

    @Override
    public Packer writeMapEnd(boolean check2) throws IOException {
        if (!this.stack.topIsMap()) {
            throw new MessageTypeException("writeMapEnd() is called but writeMapBegin() is not called");
        }
        int remain = this.stack.getTopCount();
        if (remain > 0) {
            if (check2) {
                throw new MessageTypeException("writeMapEnd(check=true) is called but the map is not end: " + remain);
            }
            for (int i2 = 0; i2 < remain; ++i2) {
                this.writeNil();
            }
        }
        this.stack.pop();
        return this;
    }

    public void reset() {
        this.stack.clear();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

