/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import org.jruby.Ruby;
import org.jruby.util.io.EncodingOption;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

public class IOOptions
implements Cloneable {
    private ModeFlags modeFlags;
    private EncodingOption encodingOption;

    public IOOptions(ModeFlags modeFlags, EncodingOption encodingOption) {
        assert (encodingOption != null);
        this.modeFlags = modeFlags;
        this.encodingOption = encodingOption;
    }

    public IOOptions(Ruby runtime, String modeString) throws InvalidValueException {
        int length2 = modeString.length();
        if (length2 == 0) {
            throw new InvalidValueException();
        }
        int colonIndex = modeString.indexOf(58);
        if (colonIndex == -1) {
            this.modeFlags = new ModeFlags(modeString);
            this.encodingOption = EncodingOption.getEncodingNoOption(runtime, this.modeFlags);
        } else {
            this.modeFlags = new ModeFlags(modeString.substring(0, colonIndex));
            this.encodingOption = EncodingOption.getEncodingOptionFromString(runtime, modeString.substring(colonIndex + 1));
        }
    }

    public ModeFlags getModeFlags() {
        return this.modeFlags;
    }

    public void setModeFlags(ModeFlags modeFlags) {
        this.modeFlags = modeFlags;
    }

    public EncodingOption getEncodingOption() {
        return this.encodingOption;
    }

    public void setEncodingOption(EncodingOption encodingOption) {
        assert (encodingOption != null);
        this.encodingOption = encodingOption;
    }

    public String toString() {
        return "[ModeFlags: " + this.modeFlags + ", EncodingOption: " + this.encodingOption;
    }
}

