/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import com.headius.invokebinder.Binder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import org.jruby.runtime.invokedynamic.Signature;
import org.jruby.runtime.invokedynamic.SmartHandle;

public class SmartBinder {
    private final Signature signature;
    private final Binder binder;

    private SmartBinder(Signature signature, Binder binder) {
        this.signature = signature;
        this.binder = binder;
    }

    public static SmartBinder from(Signature inbound) {
        return new SmartBinder(inbound, Binder.from(inbound.methodType()));
    }

    public SmartBinder fold(String newName, MethodHandle folder) {
        return new SmartBinder(this.signature.prependArg(newName, (Class)folder.type().returnType()), this.binder.fold(folder));
    }

    public SmartBinder permute(Signature target) {
        return new SmartBinder(target, this.binder.permute(this.signature.to(target)));
    }

    public SmartBinder permute(String ... targetNames) {
        return this.permute(this.signature.permute(targetNames));
    }

    public SmartBinder insert(int index2, String name2, Object value2) {
        return new SmartBinder(this.signature.insertArg(index2, name2, value2.getClass()), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, boolean value2) {
        return new SmartBinder(this.signature.insertArg(index2, name2, Boolean.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, byte value2) {
        return new SmartBinder(this.signature.insertArg(index2, name2, Byte.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, short value2) {
        return new SmartBinder(this.signature.insertArg(index2, name2, Short.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, char value2) {
        return new SmartBinder(this.signature.insertArg(index2, name2, Character.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, int value2) {
        return new SmartBinder(this.signature.insertArg(index2, name2, Integer.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, long value2) {
        return new SmartBinder(this.signature.insertArg(index2, name2, Long.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, float value2) {
        return new SmartBinder(this.signature.insertArg(index2, name2, Float.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String name2, double value2) {
        return new SmartBinder(this.signature.insertArg(index2, name2, Double.TYPE), this.binder.insert(index2, value2));
    }

    public SmartBinder insert(int index2, String[] names2, Class[] types, Object ... values2) {
        return new SmartBinder(this.signature.insertArgs(index2, names2, types), this.binder.insert(index2, types, values2));
    }

    public SmartBinder cast(Signature target) {
        return new SmartBinder(target, this.binder.cast(target.methodType()));
    }

    public SmartBinder cast(Class returnType, Class ... argTypes) {
        return new SmartBinder(new Signature(returnType, argTypes, this.signature.argNames()), this.binder.cast(returnType, argTypes));
    }

    public SmartHandle invokeVirtualQuiet(MethodHandles.Lookup lookup, String name2) {
        return new SmartHandle(this.signature, this.binder.invokeVirtualQuiet(lookup, name2));
    }

    public SmartHandle invoke(MethodHandle target) {
        return new SmartHandle(this.signature, this.binder.invoke(target));
    }
}

