/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class Signature {
    private final MethodType methodType;
    private final String[] argNames;

    Signature(Class retval) {
        this(MethodType.methodType(retval), new String[0]);
    }

    Signature(Class retval, Class[] argTypes, String ... argNames) {
        this(MethodType.methodType(retval, argTypes), argNames);
    }

    Signature(MethodType methodType, String ... argNames) {
        assert (methodType.parameterCount() == argNames.length) : "arg name count " + argNames.length + " does not match parameter count " + methodType.parameterCount();
        this.methodType = methodType;
        this.argNames = argNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        for (int i2 = 0; i2 < this.argNames.length; ++i2) {
            sb.append(((Class)this.methodType.parameterType(i2)).getSimpleName()).append(' ').append(this.argNames[i2]);
            if (i2 + 1 >= this.argNames.length) continue;
            sb.append(", ");
        }
        sb.append(")").append(((Class)this.methodType.returnType()).getSimpleName());
        return sb.toString();
    }

    public static Signature returning(Class retval) {
        Signature sig = new Signature(retval);
        return sig;
    }

    public Signature asFold(Class retval) {
        return new Signature(this.methodType.changeReturnType(retval), this.argNames);
    }

    public Signature appendArg(String name2, Class type2) {
        String[] newArgNames = new String[this.argNames.length + 1];
        System.arraycopy(this.argNames, 0, newArgNames, 0, this.argNames.length);
        newArgNames[this.argNames.length] = name2;
        MethodType newMethodType = this.methodType.appendParameterTypes(type2);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature prependArg(String name2, Class type2) {
        String[] newArgNames = new String[this.argNames.length + 1];
        System.arraycopy(this.argNames, 0, newArgNames, 1, this.argNames.length);
        newArgNames[0] = name2;
        MethodType newMethodType = this.methodType.insertParameterTypes(0, type2);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature insertArg(int index2, String name2, Class type2) {
        return this.insertArgs(index2, new String[]{name2}, new Class[]{type2});
    }

    public Signature insertArgs(int index2, String[] names2, Class[] types) {
        assert (names2.length == types.length) : "names and types must be of the same length";
        String[] newArgNames = new String[this.argNames.length + names2.length];
        System.arraycopy(names2, 0, newArgNames, index2, names2.length);
        if (index2 != 0) {
            System.arraycopy(this.argNames, 0, newArgNames, 0, index2);
        }
        if (this.argNames.length - index2 != 0) {
            System.arraycopy(this.argNames, index2, newArgNames, index2 + names2.length, this.argNames.length - index2);
        }
        MethodType newMethodType = this.methodType.insertParameterTypes(0, types);
        return new Signature(newMethodType, newArgNames);
    }

    public MethodType methodType() {
        return this.methodType;
    }

    public String[] argNames() {
        return this.argNames;
    }

    public Signature permute(String ... permuteArgs) {
        ArrayList<TypeDescriptor.OfField> types = new ArrayList<TypeDescriptor.OfField>(this.argNames.length);
        ArrayList<String> names2 = new ArrayList<String>(this.argNames.length);
        for (String permuteArg : permuteArgs) {
            Pattern pattern = Pattern.compile(permuteArg);
            boolean found = false;
            for (int argOffset = 0; argOffset < this.argNames.length; ++argOffset) {
                String arg2 = this.argNames[argOffset];
                if (!pattern.matcher(arg2).find()) continue;
                found = true;
                types.add(this.methodType.parameterType(argOffset));
                names2.add(this.argNames[argOffset]);
            }
        }
        return new Signature(MethodType.methodType(this.methodType.returnType(), types.toArray(new Class[0])), names2.toArray(new String[0]));
    }

    public MethodHandle permuteTo(MethodHandle target, String ... permuteArgs) {
        return MethodHandles.permuteArguments(target, this.methodType, this.to(this.permute(permuteArgs)));
    }

    public int[] to(Signature other) {
        return this.nonMatchingTo(other.argNames);
    }

    public int[] to(String ... otherArgPatterns) {
        return this.to(this.permute(otherArgPatterns));
    }

    public int[] nonMatchingTo(String ... otherArgNames) {
        int[] offsets2 = new int[otherArgNames.length];
        int i2 = 0;
        for (String arg2 : otherArgNames) {
            int pos2 = -1;
            for (int offset2 = 0; offset2 < this.argNames.length; ++offset2) {
                if (!this.argNames[offset2].equals(arg2)) continue;
                pos2 = offset2;
                break;
            }
            assert (pos2 >= 0) : "argument not found: \"" + arg2 + "\"";
            offsets2[i2++] = pos2;
        }
        return offsets2;
    }
}

