/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.runtime;

import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRReturnJump;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.jruby.util.unsafe.UnsafeFactory;

public class IRRuntimeHelpers {
    private static final Logger LOG = LoggerFactory.getLogger("IRRuntimeHelpers");

    public static boolean inProfileMode() {
        return RubyInstanceConfig.IR_PROFILE;
    }

    public static boolean isDebug() {
        return RubyInstanceConfig.IR_DEBUG;
    }

    public static boolean inNonMethodBodyLambda(IRScope scope, Block.Type blockType) {
        return blockType == Block.Type.LAMBDA && !scope.getStaticScope().isArgumentScope();
    }

    public static boolean inLambda(Block.Type blockType) {
        return blockType == Block.Type.LAMBDA;
    }

    public static boolean inProc(Block.Type blockType) {
        return blockType == Block.Type.PROC;
    }

    public static void initiateNonLocalReturn(ThreadContext context, IRScope scope, IRMethod methodToReturnFrom, IRubyObject returnValue) {
        if (scope instanceof IRClosure) {
            if (methodToReturnFrom == null) {
                if (context.getThread() == context.runtime.getThreadService().getMainThread()) {
                    throw IRException.RETURN_LocalJumpError.getException(context.runtime);
                }
                throw context.runtime.newThreadError("return can't jump across threads");
            }
            if (!context.scopeExistsOnCallStack(methodToReturnFrom.getStaticScope())) {
                if (IRRuntimeHelpers.isDebug()) {
                    LOG.info("in scope: " + scope + ", raising unexpected return local jump error", new Object[0]);
                }
                throw IRException.RETURN_LocalJumpError.getException(context.runtime);
            }
        }
        throw IRReturnJump.create(methodToReturnFrom, returnValue);
    }

    public static IRubyObject handleNonlocalReturn(IRScope scope, Object rjExc, Block.Type blockType) throws RuntimeException {
        if (!(rjExc instanceof IRReturnJump)) {
            UnsafeFactory.getUnsafe().throwException((Throwable)rjExc);
            return null;
        }
        IRReturnJump rj = (IRReturnJump)rjExc;
        if (IRRuntimeHelpers.inNonMethodBodyLambda(scope, blockType) || rj.methodToReturnFrom == scope) {
            return (IRubyObject)rj.returnValue;
        }
        throw rj;
    }

    public static IRubyObject initiateBreak(ThreadContext context, IRScope scope, IRScope scopeToReturnTo, IRubyObject breakValue, Block.Type blockType) throws RuntimeException {
        if (IRRuntimeHelpers.inLambda(blockType)) {
            return breakValue;
        }
        if (!(scope instanceof IRClosure)) {
            throw IRException.BREAK_LocalJumpError.getException(context.runtime);
        }
        IRBreakJump bj = IRBreakJump.create(scopeToReturnTo, breakValue);
        if (scope instanceof IREvalScript) {
            bj.breakInEval = true;
        }
        throw bj;
    }

    public static void catchUncaughtBreakInLambdas(ThreadContext context, IRScope scope, Object exc, Block.Type blockType) throws RuntimeException {
        if (exc instanceof IRBreakJump && IRRuntimeHelpers.inNonMethodBodyLambda(scope, blockType)) {
            throw IRException.BREAK_LocalJumpError.getException(context.getRuntime());
        }
        UnsafeFactory.getUnsafe().throwException((Throwable)exc);
    }

    public static IRubyObject handlePropagatedBreak(ThreadContext context, IRScope scope, Object bjExc, Block.Type blockType) throws RuntimeException {
        if (!(bjExc instanceof IRBreakJump)) {
            throw (RuntimeException)bjExc;
        }
        IRBreakJump bj = (IRBreakJump)bjExc;
        if (bj.breakInEval) {
            if (!(scope instanceof IRClosure)) {
                throw IRException.BREAK_LocalJumpError.getException(context.getRuntime());
            }
            bj.breakInEval = false;
            throw bj;
        }
        if (bj.scopeToReturnTo == scope) {
            return bj.breakValue;
        }
        throw bj;
    }
}

