/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions.defined;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.defined.DefinedObjectNameInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ClassVarIsDefinedInstr
extends DefinedObjectNameInstr {
    public ClassVarIsDefinedInstr(Variable result2, Operand module, StringLiteral name2) {
        super(Operation.CLASS_VAR_IS_DEFINED, result2, new Operand[]{module, name2});
    }

    @Override
    public Instr cloneForInlining(InlinerInfo inlinerInfo) {
        return new ClassVarIsDefinedInstr((Variable)this.getResult().cloneForInlining(inlinerInfo), this.getObject().cloneForInlining(inlinerInfo), (StringLiteral)this.getName().cloneForInlining(inlinerInfo));
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        IRubyObject attached;
        String name2;
        Ruby runtime = context.runtime;
        RubyModule cm = (RubyModule)this.getObject().retrieve(context, self, currDynScope, temp);
        boolean defined = cm.isClassVarDefined(name2 = this.getName().string);
        if (!defined && cm.isSingleton() && (attached = ((MetaClass)cm).getAttached()) instanceof RubyModule) {
            defined = ((RubyModule)attached).isClassVarDefined(name2);
        }
        return runtime.newBoolean(defined);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ClassVarIsDefinedInstr(this);
    }
}

