/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class DefineModuleInstr
extends Instr
implements ResultInstr {
    private final IRModuleBody newIRModuleBody;
    private Operand container;
    private Variable result;

    public DefineModuleInstr(Variable result2, IRModuleBody newIRModuleBody, Operand container) {
        super(Operation.DEF_MODULE);
        assert (result2 != null) : "DefineModuleInstr result is null";
        this.newIRModuleBody = newIRModuleBody;
        this.container = container;
        this.result = result2;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.container};
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.container = this.container.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.newIRModuleBody.getName() + ", " + this.container + ", " + this.newIRModuleBody.getFileName() + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new DefineModuleInstr(ii.getRenamedVariable(this.result), this.newIRModuleBody, this.container.cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        Object rubyContainer = this.container.retrieve(context, self, currDynScope, temp);
        if (!(rubyContainer instanceof RubyModule)) {
            throw context.runtime.newTypeError("no outer class/module");
        }
        RubyModule newRubyModule = ((RubyModule)rubyContainer).defineOrGetModuleUnder(this.newIRModuleBody.getName());
        this.newIRModuleBody.getStaticScope().setModule(newRubyModule);
        return new InterpretedIRMethod(this.newIRModuleBody, Visibility.PUBLIC, newRubyModule);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.DefineModuleInstr(this);
    }

    public IRModuleBody getNewIRModuleBody() {
        return this.newIRModuleBody;
    }

    public Operand getContainer() {
        return this.container;
    }
}

