/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRScope;
import org.jruby.ir.Operation;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.dataflow.FlowGraphNode;
import org.jruby.ir.dataflow.analyses.LoadLocalVarPlacementProblem;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.LoadLocalVarInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.util.Edge;

public class LoadLocalVarPlacementNode
extends FlowGraphNode {
    Set<LocalVariable> inRequiredLoads;
    Set<LocalVariable> outRequiredLoads;

    public LoadLocalVarPlacementNode(DataFlowProblem prob, BasicBlock n) {
        super(prob, n);
    }

    @Override
    public void init() {
        this.inRequiredLoads = new HashSet<LocalVariable>();
        this.outRequiredLoads = new HashSet<LocalVariable>();
    }

    @Override
    public void buildDataFlowVars(Instr i2) {
    }

    @Override
    public void initSolnForNode() {
        if (this.basicBlock == this.problem.getScope().cfg().getExitBB()) {
            this.inRequiredLoads = ((LoadLocalVarPlacementProblem)this.problem).getLoadsOnScopeExit();
        }
    }

    @Override
    public void compute_MEET(Edge e, BasicBlock source2, FlowGraphNode pred2) {
        LoadLocalVarPlacementNode n = (LoadLocalVarPlacementNode)pred2;
        this.inRequiredLoads.addAll(n.outRequiredLoads);
    }

    @Override
    public boolean applyTransferFunction() {
        IRScope scope = this.problem.getScope();
        boolean scopeBindingHasEscaped = scope.bindingHasEscaped();
        HashSet<LocalVariable> reqdLoads = new HashSet<LocalVariable>(this.inRequiredLoads);
        List<Instr> instrs = this.basicBlock.getInstrs();
        ListIterator<Instr> it = instrs.listIterator(instrs.size());
        while (it.hasPrevious()) {
            Instr i2 = it.previous();
            if (i2 instanceof ResultInstr) {
                reqdLoads.remove(((ResultInstr)((Object)i2)).getResult());
            }
            if (i2 instanceof CallBase) {
                CallBase call2 = (CallBase)i2;
                Operand o = call2.getClosureArg(null);
                if (o != null && o instanceof WrappedIRClosure) {
                    IRClosure cl = ((WrappedIRClosure)o).getClosure();
                    HashSet<LocalVariable> newReqdLoads = new HashSet<LocalVariable>(reqdLoads);
                    for (LocalVariable v : reqdLoads) {
                        if (!cl.definesLocalVariable(v)) continue;
                        newReqdLoads.remove(v);
                    }
                    reqdLoads = newReqdLoads;
                }
                if (scopeBindingHasEscaped || call2.targetRequiresCallersBinding()) {
                    reqdLoads.clear();
                } else {
                    HashSet<LocalVariable> newReqdLoads = new HashSet<LocalVariable>(reqdLoads);
                    for (LocalVariable v : reqdLoads) {
                        if (scope.definesLocalVariable(v)) continue;
                        newReqdLoads.remove(v);
                    }
                    reqdLoads = newReqdLoads;
                }
            } else if (scopeBindingHasEscaped && i2.getOperation() == Operation.PUT_GLOBAL_VAR) {
                reqdLoads.clear();
            }
            if (i2.getOperation() == Operation.BINDING_STORE) {
                LocalVariable lv = ((StoreLocalVarInstr)i2).getLocalVar();
                if (lv.isSelf()) continue;
                reqdLoads.add(lv);
                continue;
            }
            for (Variable x : i2.getUsedVariables()) {
                if (!(x instanceof LocalVariable) || ((LocalVariable)x).isSelf()) continue;
                reqdLoads.add((LocalVariable)x);
            }
        }
        if (this.basicBlock == this.problem.getScope().cfg().getEntryBB() || this.basicBlock.isRescueEntry()) {
            reqdLoads.clear();
        }
        if (((Object)this.outRequiredLoads).equals(reqdLoads)) {
            return false;
        }
        this.outRequiredLoads = reqdLoads;
        return true;
    }

    public String toString() {
        return "";
    }

    private TemporaryVariable getLocalVarReplacement(LocalVariable v, IRScope scope, Map<Operand, Operand> varRenameMap) {
        TemporaryVariable value2 = (TemporaryVariable)varRenameMap.get(v);
        if (value2 == null) {
            value2 = scope.getNewTemporaryVariable("%t_" + v.getName());
            varRenameMap.put(v, value2);
        }
        return value2;
    }

    public void addLoads(Map<Operand, Operand> varRenameMap) {
        LoadLocalVarPlacementProblem blp = (LoadLocalVarPlacementProblem)this.problem;
        IRScope scope = blp.getScope();
        boolean isEvalScript = scope instanceof IREvalScript;
        boolean scopeBindingHasEscaped = scope.bindingHasEscaped();
        List<Instr> instrs = this.basicBlock.getInstrs();
        ListIterator<Instr> it = instrs.listIterator(instrs.size());
        HashSet<LocalVariable> reqdLoads = new HashSet<LocalVariable>(this.inRequiredLoads);
        while (it.hasPrevious()) {
            Instr i2 = it.previous();
            if (i2 instanceof ResultInstr) {
                reqdLoads.remove(((ResultInstr)((Object)i2)).getResult());
            }
            if (i2 instanceof CallBase) {
                CallBase call2 = (CallBase)i2;
                Operand operand = call2.getClosureArg(null);
                if (operand != null && operand instanceof WrappedIRClosure) {
                    IRClosure cl = ((WrappedIRClosure)operand).getClosure();
                    HashSet<LocalVariable> newReqdLoads = new HashSet<LocalVariable>(reqdLoads);
                    it.next();
                    for (LocalVariable v : reqdLoads) {
                        if (!cl.definesLocalVariable(v)) continue;
                        it.add(new LoadLocalVarInstr(scope, this.getLocalVarReplacement(v, scope, varRenameMap), v));
                        it.previous();
                        newReqdLoads.remove(v);
                    }
                    it.previous();
                    reqdLoads = newReqdLoads;
                }
                if (scopeBindingHasEscaped || call2.targetRequiresCallersBinding()) {
                    it.next();
                    for (LocalVariable v : reqdLoads) {
                        it.add(new LoadLocalVarInstr(scope, this.getLocalVarReplacement(v, scope, varRenameMap), v));
                        it.previous();
                    }
                    it.previous();
                    reqdLoads.clear();
                } else {
                    HashSet<LocalVariable> newReqdLoads = new HashSet<LocalVariable>(reqdLoads);
                    it.next();
                    for (LocalVariable v : reqdLoads) {
                        if (scope.definesLocalVariable(v)) continue;
                        it.add(new LoadLocalVarInstr(scope, this.getLocalVarReplacement(v, scope, varRenameMap), v));
                        it.previous();
                        newReqdLoads.remove(v);
                    }
                    it.previous();
                    reqdLoads = newReqdLoads;
                }
            } else if (scopeBindingHasEscaped && i2.getOperation() == Operation.PUT_GLOBAL_VAR) {
                it.next();
                for (LocalVariable localVariable : reqdLoads) {
                    it.add(new LoadLocalVarInstr(scope, this.getLocalVarReplacement(localVariable, scope, varRenameMap), localVariable));
                    it.previous();
                }
                it.previous();
                reqdLoads.clear();
            }
            if (i2.getOperation() == Operation.BINDING_STORE) {
                LocalVariable lv = ((StoreLocalVarInstr)i2).getLocalVar();
                if (lv.isSelf()) continue;
                reqdLoads.add(lv);
                this.getLocalVarReplacement(lv, scope, varRenameMap);
                continue;
            }
            for (Variable variable : i2.getUsedVariables()) {
                LocalVariable lv;
                if (!(variable instanceof LocalVariable) || (lv = (LocalVariable)variable).isSelf()) continue;
                reqdLoads.add(lv);
                this.getLocalVarReplacement(lv, scope, varRenameMap);
            }
        }
        if (this.basicBlock.isRescueEntry()) {
            for (LocalVariable v : reqdLoads) {
                it.add(new LoadLocalVarInstr(scope, this.getLocalVarReplacement(v, scope, varRenameMap), v));
            }
        }
        if (scope instanceof IRClosure && this.basicBlock == this.problem.getScope().cfg().getEntryBB()) {
            for (LocalVariable v : reqdLoads) {
                if (!scope.usesLocalVariable(v) && !scope.definesLocalVariable(v) || !isEvalScript && v instanceof ClosureLocalVariable && scope == ((ClosureLocalVariable)v).definingScope) continue;
                it.add(new LoadLocalVarInstr(scope, this.getLocalVarReplacement(v, scope, varRenameMap), v));
            }
        }
    }
}

