/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.EncodingNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LambdaNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MultipleAsgn19Node;
import org.jruby.ast.Node;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.YieldNode;
import org.jruby.compiler.NotCompilableException;
import org.jruby.ir.IRBuilder;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.BEQInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.ReceiveClosureInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.instructions.defined.BackrefIsMatchDataInstr;
import org.jruby.ir.instructions.ruby19.BuildLambdaInstr;
import org.jruby.ir.instructions.ruby19.GetEncodingInstr;
import org.jruby.ir.instructions.ruby19.ReceiveOptArgInstr19;
import org.jruby.ir.instructions.ruby19.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ruby19.ReceiveRestArgInstr19;
import org.jruby.ir.operands.CompoundArray;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.MethAddr;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.NthRef;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;

public class IRBuilder19
extends IRBuilder {
    public IRBuilder19(IRManager manager) {
        super(manager);
    }

    @Override
    public boolean is1_9() {
        return true;
    }

    @Override
    protected Operand buildVersionSpecificNodes(Node node, IRScope s2) {
        switch (node.getNodeType()) {
            case ENCODINGNODE: {
                return this.buildEncoding((EncodingNode)node, s2);
            }
            case MULTIPLEASGN19NODE: {
                return this.buildMultipleAsgn19((MultipleAsgn19Node)node, s2);
            }
            case LAMBDANODE: {
                return this.buildLambda((LambdaNode)node, s2);
            }
        }
        throw new NotCompilableException("Unknown node encountered in builder: " + node.getClass());
    }

    @Override
    protected LocalVariable getBlockArgVariable(IRScope s2, String name2, int depth) {
        IRClosure cl = (IRClosure)s2;
        if (cl.isForLoopBody()) {
            return cl.getLocalVariable(name2, depth);
        }
        throw new NotCompilableException("Cannot ask for block-arg variable in 1.9 mode");
    }

    @Override
    public void buildVersionSpecificBlockArgsAssignment(Node node, IRScope s2, Operand argsArray, int argIndex, boolean isMasgnRoot, boolean isClosureArg, boolean isSplat) {
        IRClosure cl = (IRClosure)s2;
        if (!cl.isForLoopBody()) {
            throw new NotCompilableException("Should not have come here for block args assignment in 1.9 mode: " + node);
        }
        switch (node.getNodeType()) {
            case MULTIPLEASGN19NODE: {
                ListNode sourceArray = ((MultipleAsgn19Node)node).getPre();
                int i2 = 0;
                for (Node an : sourceArray.childNodes()) {
                    this.buildBlockArgsAssignment(an, s2, null, i2, false, false, false);
                    ++i2;
                }
                break;
            }
            default: {
                throw new NotCompilableException("Can't build assignment node: " + node);
            }
        }
    }

    protected LocalVariable getArgVariable(IRScope s2, String name2, int depth) {
        return s2.isForLoopBody() ? s2.getLocalVariable(name2, depth) : s2.getNewLocalVariable(name2, 0);
    }

    private void addArgReceiveInstr(IRScope s2, Variable v, int argIndex, boolean post, int numPreReqd, int numPostRead) {
        if (post) {
            s2.addInstr(new ReceivePostReqdArgInstr(v, argIndex, numPreReqd, numPostRead));
        } else {
            s2.addInstr(new ReceivePreReqdArgInstr(v, argIndex));
        }
    }

    public void receiveRequiredArg(Node node, IRScope s2, int argIndex, boolean post, int numPreReqd, int numPostRead) {
        switch (node.getNodeType()) {
            case ARGUMENTNODE: {
                ArgumentNode a = (ArgumentNode)node;
                String argName = a.getName();
                if (s2 instanceof IRMethod) {
                    ((IRMethod)s2).addArgDesc("req", argName);
                }
                this.addArgReceiveInstr(s2, s2.getNewLocalVariable(argName, 0), argIndex, post, numPreReqd, numPostRead);
                break;
            }
            case MULTIPLEASGN19NODE: {
                MultipleAsgn19Node childNode = (MultipleAsgn19Node)node;
                TemporaryVariable v = s2.getNewTemporaryVariable();
                this.addArgReceiveInstr(s2, v, argIndex, post, numPreReqd, numPostRead);
                if (s2 instanceof IRMethod) {
                    ((IRMethod)s2).addArgDesc("rest", "");
                }
                s2.addInstr(new ToAryInstr(v, v, this.manager.getFalse()));
                this.buildMultipleAsgn19Assignment(childNode, s2, v, null);
                break;
            }
            default: {
                throw new NotCompilableException("Can't build assignment node: " + node);
            }
        }
    }

    private void receiveClosureArg(BlockArgNode blockVarNode, IRScope s2) {
        LocalVariable blockVar = null;
        if (blockVarNode != null) {
            String blockArgName = blockVarNode.getName();
            blockVar = s2.getNewLocalVariable(blockArgName, 0);
            if (s2 instanceof IRMethod) {
                ((IRMethod)s2).addArgDesc("block", blockArgName);
            }
            s2.addInstr(new ReceiveClosureInstr(blockVar));
        }
        LocalVariable implicitBlockArg = s2.getImplicitBlockArg();
        if (blockVar == null) {
            s2.addInstr(new ReceiveClosureInstr(implicitBlockArg));
        } else {
            s2.addInstr(new CopyInstr(implicitBlockArg, blockVar));
        }
    }

    public void receiveArgs(ArgsNode argsNode, IRScope s2) {
        int numPreReqd = argsNode.getPreCount();
        int numPostReqd = argsNode.getPostCount();
        int required = argsNode.getRequiredArgsCount();
        int opt = argsNode.getOptionalArgsCount();
        int rest2 = argsNode.getRestArg();
        s2.getStaticScope().setArities(required, opt, rest2);
        if (s2 instanceof IRMethod) {
            s2.addInstr(new CheckArityInstr(required, opt, rest2));
        }
        int argIndex = 0;
        ListNode preArgs = argsNode.getPre();
        int i2 = 0;
        while (i2 < numPreReqd) {
            this.receiveRequiredArg(preArgs.get(i2), s2, argIndex, false, -1, -1);
            ++i2;
            ++argIndex;
        }
        opt = opt > 0 ? opt : 0;
        int n = rest2 = rest2 > -1 ? 1 : 0;
        if (opt > 0) {
            ListNode optArgs = argsNode.getOptArgs();
            int j = 0;
            while (j < opt) {
                Label l = s2.getNewLabel();
                OptArgNode n2 = (OptArgNode)optArgs.get(j);
                String argName = n2.getName();
                LocalVariable av = s2.getNewLocalVariable(argName, 0);
                if (s2 instanceof IRMethod) {
                    ((IRMethod)s2).addArgDesc("opt", argName);
                }
                s2.addInstr(new ReceiveOptArgInstr19(av, argIndex, required + j + 1));
                s2.addInstr(BNEInstr.create(av, UndefinedValue.UNDEFINED, l));
                this.build(n2.getValue(), s2);
                s2.addInstr(new LabelInstr(l));
                ++j;
                ++argIndex;
            }
        }
        if (rest2 > 0) {
            String argName = argsNode.getRestArgNode().getName();
            if (s2 instanceof IRMethod) {
                ((IRMethod)s2).addArgDesc("rest", argName == null ? "" : argName);
            }
            argName = argName == null || argName.equals("") ? "%_arg_array" : argName;
            s2.addInstr(new ReceiveRestArgInstr19(s2.getNewLocalVariable(argName, 0), argIndex, required, opt));
            ++argIndex;
        }
        ListNode postArgs = argsNode.getPost();
        for (int i3 = 0; i3 < numPostReqd; ++i3) {
            this.receiveRequiredArg(postArgs.get(i3), s2, i3, true, numPreReqd, numPostReqd);
        }
        BlockArgNode blockArg = argsNode.getBlock();
        if (s2 instanceof IRMethod || blockArg != null) {
            this.receiveClosureArg(blockArg, s2);
        }
    }

    @Override
    public void receiveBlockArgs(IterNode node, IRScope s2) {
        Node args2 = node.getVarNode();
        if (args2 instanceof ArgsNode) {
            ((IRClosure)s2).setParameterList(RuntimeHelpers.encodeParameterList((ArgsNode)args2).split(";"));
            this.receiveArgs((ArgsNode)args2, s2);
        } else {
            this.buildBlockArgsAssignment(args2, s2, null, 0, false, false, false);
        }
    }

    @Override
    public void receiveBlockClosureArg(Node node, IRScope s2) {
    }

    @Override
    public void receiveMethodArgs(ArgsNode argsNode, IRScope s2) {
        this.receiveArgs(argsNode, s2);
    }

    protected void receiveArg(IRScope s2, Variable v, Operand argsArray, int argIndex, boolean isSplat) {
    }

    public void buildArgsMasgn(Node node, IRScope s2, Operand argsArray, boolean isMasgnRoot, int preArgsCount, int postArgsCount, int index2, boolean isSplat) {
        switch (node.getNodeType()) {
            case DASGNNODE: {
                DAsgnNode dynamicAsgn = (DAsgnNode)node;
                LocalVariable v = this.getArgVariable(s2, dynamicAsgn.getName(), dynamicAsgn.getDepth());
                if (isSplat) {
                    s2.addInstr(new RestArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                    break;
                }
                s2.addInstr(new ReqdArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                LocalVariable v = this.getArgVariable(s2, localVariable.getName(), localVariable.getDepth());
                if (isSplat) {
                    s2.addInstr(new RestArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                    break;
                }
                s2.addInstr(new ReqdArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                break;
            }
            case MULTIPLEASGN19NODE: {
                Object oldArgs = null;
                MultipleAsgn19Node childNode = (MultipleAsgn19Node)node;
                if (!isMasgnRoot) {
                    TemporaryVariable v = s2.getNewTemporaryVariable();
                    if (isSplat) {
                        s2.addInstr(new RestArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                    } else {
                        s2.addInstr(new ReqdArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                    }
                    s2.addInstr(new ToAryInstr(v, v, this.manager.getFalse()));
                    argsArray = v;
                }
                this.buildMultipleAsgn19Assignment(childNode, s2, argsArray, null);
                break;
            }
            default: {
                throw new NotCompilableException("Shouldn't get here: " + node);
            }
        }
    }

    public void buildMultipleAsgn19Assignment(MultipleAsgn19Node multipleAsgnNode, IRScope s2, Operand argsArray, Operand values2) {
        ListNode masgnPost;
        TemporaryVariable rhsVal;
        ListNode masgnPre = multipleAsgnNode.getPre();
        int i2 = 0;
        if (masgnPre != null) {
            for (Node an : masgnPre.childNodes()) {
                if (values2 == null) {
                    this.buildArgsMasgn(an, s2, argsArray, false, -1, -1, i2, false);
                } else {
                    rhsVal = s2.getNewTemporaryVariable();
                    s2.addInstr(new ReqdArgMultipleAsgnInstr(rhsVal, values2, i2));
                    this.buildAssignment(an, s2, rhsVal);
                }
                ++i2;
            }
        }
        Node restNode = multipleAsgnNode.getRest();
        int postArgsCount = multipleAsgnNode.getPostCount();
        if (restNode != null && !(restNode instanceof StarNode)) {
            if (values2 == null) {
                this.buildArgsMasgn(restNode, s2, argsArray, false, i2, postArgsCount, 0, true);
            } else {
                rhsVal = s2.getNewTemporaryVariable();
                s2.addInstr(new RestArgMultipleAsgnInstr(rhsVal, values2, i2, postArgsCount, 0));
                this.buildAssignment(restNode, s2, rhsVal);
            }
        }
        if ((masgnPost = multipleAsgnNode.getPost()) != null) {
            int j = 0;
            for (Node an : masgnPost.childNodes()) {
                if (values2 == null) {
                    this.buildArgsMasgn(an, s2, argsArray, false, i2, postArgsCount, j, false);
                } else {
                    TemporaryVariable rhsVal2 = s2.getNewTemporaryVariable();
                    s2.addInstr(new ReqdArgMultipleAsgnInstr(rhsVal2, values2, i2, postArgsCount, j));
                    this.buildAssignment(an, s2, rhsVal2);
                }
                ++j;
            }
        }
    }

    @Override
    public void buildVersionSpecificAssignment(Node node, IRScope s2, Variable v) {
        switch (node.getNodeType()) {
            case MULTIPLEASGN19NODE: {
                s2.addInstr(new ToAryInstr(v, v, this.manager.getFalse()));
                this.buildMultipleAsgn19Assignment((MultipleAsgn19Node)node, s2, null, v);
                break;
            }
            default: {
                throw new NotCompilableException("Can't build assignment node: " + node);
            }
        }
    }

    @Override
    public Operand buildArgsPush(ArgsPushNode node, IRScope s2) {
        Operand v1 = this.build(node.getFirstNode(), s2);
        Operand v2 = this.build(node.getSecondNode(), s2);
        return new CompoundArray(v1, v2, true);
    }

    public Operand buildEncoding(EncodingNode node, IRScope s2) {
        TemporaryVariable ret = s2.getNewTemporaryVariable();
        s2.addInstr(new GetEncodingInstr(ret, node.getEncoding()));
        return ret;
    }

    public Operand buildLambda(LambdaNode node, IRScope s2) {
        Nil closureRetVal;
        IRClosure closure = new IRClosure(this.manager, s2, false, node.getPosition().getStartLine(), node.getScope(), Arity.procArityOf(node.getArgs()), node.getArgumentType(), true);
        s2.addClosure(closure);
        IRBuilder closureBuilder = IRBuilder19.createIRBuilder(this.manager, this.is1_9());
        closure.addInstr(new ReceiveSelfInstr(this.getSelf(closure)));
        closureBuilder.receiveBlockArgs(node, closure);
        closureBuilder.receiveBlockClosureArg(node.getBlockVarNode(), closure);
        Operand operand = closureRetVal = node.getBody() == null ? this.manager.getNil() : closureBuilder.build(node.getBody(), closure);
        if (closureRetVal != U_NIL) {
            closure.addInstr(new ReturnInstr(closureRetVal));
        }
        TemporaryVariable lambda2 = s2.getNewTemporaryVariable();
        s2.addInstr(new BuildLambdaInstr(lambda2, closure, node.getPosition()));
        return lambda2;
    }

    @Override
    public Operand buildYield(YieldNode node, IRScope s2) {
        boolean unwrap = true;
        Node argNode = node.getArgsNode();
        if (argNode != null && argNode instanceof ArrayNode && ((ArrayNode)argNode).size() == 1) {
            argNode = ((ArrayNode)argNode).getLast();
            unwrap = false;
        }
        TemporaryVariable ret = s2.getNewTemporaryVariable();
        s2.addInstr(new YieldInstr(ret, s2.getImplicitBlockArg(), this.build(argNode, s2), unwrap));
        return ret;
    }

    public Operand buildMultipleAsgn19(MultipleAsgn19Node multipleAsgnNode, IRScope s2) {
        Operand values2 = this.build(multipleAsgnNode.getValueNode(), s2);
        Variable ret = this.getValueInTemporaryVariable(s2, values2);
        s2.addInstr(new ToAryInstr(ret, ret, this.manager.getFalse()));
        this.buildMultipleAsgn19Assignment(multipleAsgnNode, s2, null, ret);
        return ret;
    }

    @Override
    public Operand buildVersionSpecificGetDefinitionIR(Node node, IRScope s2) {
        switch (node.getNodeType()) {
            case ORNODE: 
            case ANDNODE: {
                return new StringLiteral("expression");
            }
            case MULTIPLEASGN19NODE: {
                return new StringLiteral("assignment");
            }
            case DVARNODE: {
                return new StringLiteral("local-variable");
            }
            case BACKREFNODE: {
                return this.buildDefinitionCheck(s2, new BackrefIsMatchDataInstr(s2.getNewTemporaryVariable()), "global-variable");
            }
            case DREGEXPNODE: 
            case DSTRNODE: {
                Operand v = super.buildVersionSpecificGetDefinitionIR(node, s2);
                Label doneLabel = s2.getNewLabel();
                Variable tmpVar = this.getValueInTemporaryVariable(s2, v);
                s2.addInstr(BNEInstr.create(tmpVar, this.manager.getNil(), doneLabel));
                s2.addInstr(new CopyInstr(tmpVar, new StringLiteral("expression")));
                s2.addInstr(new LabelInstr(doneLabel));
                return tmpVar;
            }
            case NOTNODE: {
                Operand v = this.buildGetDefinitionBase(((NotNode)node).getConditionNode(), s2);
                Label doneLabel = s2.getNewLabel();
                Variable tmpVar = this.getValueInTemporaryVariable(s2, v);
                s2.addInstr(BEQInstr.create(tmpVar, this.manager.getNil(), doneLabel));
                s2.addInstr(new CopyInstr(tmpVar, new StringLiteral("method")));
                s2.addInstr(new LabelInstr(doneLabel));
                return tmpVar;
            }
            case NTHREFNODE: {
                int n = ((NthRefNode)node).getMatchNumber();
                Label undefLabel = s2.getNewLabel();
                TemporaryVariable tmpVar = s2.getNewTemporaryVariable();
                s2.addInstr(new BackrefIsMatchDataInstr(tmpVar));
                s2.addInstr(BEQInstr.create(tmpVar, this.manager.getFalse(), undefLabel));
                s2.addInstr(CallInstr.create(tmpVar, new MethAddr("nil?"), new NthRef(n), NO_ARGS, null));
                s2.addInstr(BEQInstr.create(tmpVar, this.manager.getTrue(), undefLabel));
                return this.buildDefnCheckIfThenPaths(s2, undefLabel, new StringLiteral("global-variable"));
            }
        }
        return this.buildGenericGetDefinitionIR(node, s2);
    }
}

