/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.util.List;
import org.jruby.ext.openssl.x509store.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class X509Object
implements Comparable<X509Object> {
    public static int indexBySubject(List<? extends X509Object> h, int type2, Name name2) {
        int ix = 0;
        for (X509Object x509Object : h) {
            if (type2 != x509Object.type() || !x509Object.isName(name2)) continue;
            return ix;
        }
        return -1;
    }

    public static X509Object retrieveBySubject(List<? extends X509Object> h, int type2, Name name2) {
        for (X509Object x509Object : h) {
            if (type2 != x509Object.type() || !x509Object.isName(name2)) continue;
            return x509Object;
        }
        return null;
    }

    public static X509Object retrieveMatch(List<? extends X509Object> h, X509Object x) {
        for (X509Object x509Object : h) {
            if (!x509Object.matches(x)) continue;
            return x509Object;
        }
        return null;
    }

    public boolean isName(Name nm) {
        return false;
    }

    public boolean matches(X509Object o) {
        return false;
    }

    public abstract int type();

    @Override
    public int compareTo(X509Object other) {
        return this.type() - other.type();
    }
}

