/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RC2CBCParameter;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.impl.PKCS10Request;
import org.jruby.ext.openssl.impl.PKey;
import org.jruby.ext.openssl.x509store.X509Aux;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;

public class PEMInputOutput {
    public static final String BEF = "-----";
    public static final String AFT = "-----";
    public static final String BEF_G = "-----BEGIN ";
    public static final String BEF_E = "-----END ";
    public static final String PEM_STRING_X509_OLD = "X509 CERTIFICATE";
    public static final String PEM_STRING_X509 = "CERTIFICATE";
    public static final String PEM_STRING_X509_PAIR = "CERTIFICATE PAIR";
    public static final String PEM_STRING_X509_TRUSTED = "TRUSTED CERTIFICATE";
    public static final String PEM_STRING_X509_REQ_OLD = "NEW CERTIFICATE REQUEST";
    public static final String PEM_STRING_X509_REQ = "CERTIFICATE REQUEST";
    public static final String PEM_STRING_X509_CRL = "X509 CRL";
    public static final String PEM_STRING_EVP_PKEY = "ANY PRIVATE KEY";
    public static final String PEM_STRING_PUBLIC = "PUBLIC KEY";
    public static final String PEM_STRING_RSA = "RSA PRIVATE KEY";
    public static final String PEM_STRING_RSA_PUBLIC = "RSA PUBLIC KEY";
    public static final String PEM_STRING_DSA = "DSA PRIVATE KEY";
    public static final String PEM_STRING_DSA_PUBLIC = "DSA PUBLIC KEY";
    public static final String PEM_STRING_PKCS7 = "PKCS7";
    public static final String PEM_STRING_PKCS8 = "ENCRYPTED PRIVATE KEY";
    public static final String PEM_STRING_PKCS8INF = "PRIVATE KEY";
    public static final String PEM_STRING_DHPARAMS = "DH PARAMETERS";
    public static final String PEM_STRING_SSL_SESSION = "SSL SESSION PARAMETERS";
    public static final String PEM_STRING_DSAPARAMS = "DSA PARAMETERS";
    public static final String PEM_STRING_ECDSA_PUBLIC = "ECDSA PUBLIC KEY";
    public static final String PEM_STRING_ECPARAMETERS = "EC PARAMETERS";
    public static final String PEM_STRING_ECPRIVATEKEY = "EC PRIVATE KEY";
    private static final Pattern DH_PARAM_PATTERN = Pattern.compile("(-----BEGIN DH PARAMETERS-----)(.*)(-----END DH PARAMETERS-----)", 8);
    private static final int DH_PARAM_GROUP = 2;
    private static SecureRandom random;

    private static BufferedReader makeBuffered(Reader in) {
        if (in instanceof BufferedReader) {
            return (BufferedReader)in;
        }
        return new BufferedReader(in);
    }

    private static BufferedWriter makeBuffered(Writer out) {
        if (out instanceof BufferedWriter) {
            return (BufferedWriter)out;
        }
        return new BufferedWriter(out);
    }

    public static Object readPEM(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN PUBLIC KEY") != -1) {
                try {
                    return PEMInputOutput.readPublicKey(_in, "-----END PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating public key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN DSA PRIVATE KEY") != -1) {
                try {
                    return PEMInputOutput.readKeyPair(_in, f, "DSA", "-----END DSA PRIVATE KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating DSA private key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN RSA PUBLIC KEY") != -1) {
                try {
                    return PEMInputOutput.readPublicKey(_in, "-----END RSA PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA public key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readAuxCertificate(_in, "-----END X509 CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readAuxCertificate(_in, "-----END CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN TRUSTED CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readAuxCertificate(_in, "-----END TRUSTED CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN X509 CRL") != -1) {
                try {
                    return PEMInputOutput.readCRL(_in, "-----END X509 CRL");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 CRL: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE REQUEST") == -1) continue;
            try {
                return PEMInputOutput.readCertificateRequest(_in, "-----END CERTIFICATE REQUEST");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 REQ: " + e.toString());
            }
        }
        return null;
    }

    public static byte[] readX509PEM(Reader in) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readBytes(_in, "-----END X509 CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem reading PEM X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readBytes(_in, "-----END CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem reading PEM X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN TRUSTED CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readBytes(_in, "-----END TRUSTED CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem reading PEM X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN X509 CRL") != -1) {
                try {
                    return PEMInputOutput.readBytes(_in, "-----END X509 CRL");
                }
                catch (Exception e) {
                    throw new IOException("problem reading PEM X509 CRL: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE REQUEST") == -1) continue;
            try {
                return PEMInputOutput.readBytes(_in, "-----END CERTIFICATE REQUEST");
            }
            catch (Exception e) {
                throw new IOException("problem reading PEM X509 REQ: " + e.toString());
            }
        }
        return null;
    }

    public static KeyPair readPrivateKey(Reader in, char[] password) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN RSA PRIVATE KEY") != -1) {
                try {
                    return PEMInputOutput.readKeyPair(_in, password, "RSA", "-----END RSA PRIVATE KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA private key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN DSA PRIVATE KEY") != -1) {
                try {
                    return PEMInputOutput.readKeyPair(_in, password, "DSA", "-----END DSA PRIVATE KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating DSA private key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN EC PRIVATE KEY") != -1) {
                throw new IOException("EC private key not supported");
            }
            if (line.indexOf("-----BEGIN PRIVATE KEY") != -1) {
                try {
                    byte[] bytes2 = PEMInputOutput.readBytes(_in, "-----END PRIVATE KEY");
                    PrivateKeyInfo info = PrivateKeyInfo.getInstance(bytes2);
                    String type2 = PEMInputOutput.getPrivateKeyTypeFromObjectId(info.getPrivateKeyAlgorithm().getAlgorithm());
                    return PKey.readPrivateKey(((ASN1Object)info.parsePrivateKey()).getEncoded("DER"), type2);
                }
                catch (Exception e) {
                    throw new IOException("problem creating private key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN ENCRYPTED PRIVATE KEY") == -1) continue;
            try {
                byte[] bytes3 = PEMInputOutput.readBytes(_in, "-----END ENCRYPTED PRIVATE KEY");
                EncryptedPrivateKeyInfo eIn = EncryptedPrivateKeyInfo.getInstance(bytes3);
                AlgorithmIdentifier algId = eIn.getEncryptionAlgorithm();
                PrivateKey privKey = algId.getAlgorithm().toString().equals("1.2.840.113549.1.5.13") ? PEMInputOutput.derivePrivateKeyPBES2(eIn, algId, password) : PEMInputOutput.derivePrivateKeyPBES1(eIn, algId, password);
                return new KeyPair(null, privKey);
            }
            catch (Exception e) {
                throw new IOException("problem creating private key: " + e.toString());
            }
        }
        return null;
    }

    private static PrivateKey derivePrivateKeyPBES1(EncryptedPrivateKeyInfo eIn, AlgorithmIdentifier algId, char[] password) throws GeneralSecurityException, IOException {
        PKCS12PBEParams pkcs12Params = PKCS12PBEParams.getInstance(algId.getParameters());
        PBEKeySpec pbeSpec = new PBEKeySpec(password);
        PBEParameterSpec pbeParams = new PBEParameterSpec(pkcs12Params.getIV(), pkcs12Params.getIterations().intValue());
        String algorithm = ASN1Registry.o2a(algId.getAlgorithm());
        algorithm = algorithm.split("-")[0];
        SecretKeyFactory secKeyFact = SecretKeyFactory.getInstance(algorithm);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, (Key)secKeyFact.generateSecret(pbeSpec), pbeParams);
        PrivateKeyInfo pInfo = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(cipher.doFinal(eIn.getEncryptedData())));
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pInfo.getEncoded());
        String keyFactAlg = ASN1Registry.o2a(pInfo.getPrivateKeyAlgorithm().getAlgorithm());
        KeyFactory keyFact = keyFactAlg.startsWith("dsa") ? KeyFactory.getInstance("DSA") : KeyFactory.getInstance("RSA");
        return keyFact.generatePrivate(keySpec);
    }

    private static PrivateKey derivePrivateKeyPBES2(EncryptedPrivateKeyInfo eIn, AlgorithmIdentifier algId, char[] password) throws GeneralSecurityException, InvalidCipherTextException {
        PaddedBufferedBlockCipher cipher;
        PBES2Parameters pbeParams = new PBES2Parameters((ASN1Sequence)algId.getParameters());
        CipherParameters cipherParams = PEMInputOutput.extractPBES2CipherParams(password, pbeParams);
        EncryptionScheme scheme = pbeParams.getEncryptionScheme();
        if (scheme.getAlgorithm().equals(PKCSObjectIdentifiers.RC2_CBC)) {
            RC2CBCParameter rc2Params = RC2CBCParameter.getInstance((ASN1Sequence)scheme.getObject());
            byte[] iv = rc2Params.getIV();
            ParametersWithIV param = new ParametersWithIV(cipherParams, iv);
            cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new RC2Engine()));
            ((BufferedBlockCipher)cipher).init(false, param);
        } else {
            byte[] iv = ((ASN1OctetString)scheme.getObject()).getOctets();
            ParametersWithIV param = new ParametersWithIV(cipherParams, iv);
            cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()));
            ((BufferedBlockCipher)cipher).init(false, param);
        }
        byte[] data2 = eIn.getEncryptedData();
        byte[] out = new byte[((BufferedBlockCipher)cipher).getOutputSize(data2.length)];
        int len = ((BufferedBlockCipher)cipher).processBytes(data2, 0, data2.length, out, 0);
        len += ((BufferedBlockCipher)cipher).doFinal(out, len);
        byte[] pkcs8 = new byte[len];
        System.arraycopy(out, 0, pkcs8, 0, len);
        KeyFactory fact = KeyFactory.getInstance("RSA");
        return fact.generatePrivate(new PKCS8EncodedKeySpec(pkcs8));
    }

    private static CipherParameters extractPBES2CipherParams(char[] password, PBES2Parameters pbeParams) {
        PBKDF2Params pbkdfParams = PBKDF2Params.getInstance(pbeParams.getKeyDerivationFunc().getParameters());
        int keySize = 192;
        if (pbkdfParams.getKeyLength() != null) {
            keySize = pbkdfParams.getKeyLength().intValue() * 8;
        }
        int iterationCount = pbkdfParams.getIterationCount().intValue();
        byte[] salt = pbkdfParams.getSalt();
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator();
        generator.init(PBEParametersGenerator.PKCS5PasswordToBytes(password), salt, iterationCount);
        return ((PBEParametersGenerator)generator).generateDerivedParameters(keySize);
    }

    public static PublicKey readPubKey(Reader in) throws IOException {
        PublicKey pubKey = PEMInputOutput.readRSAPubKey(in);
        if (pubKey == null) {
            pubKey = PEMInputOutput.readDSAPubKey(in);
        }
        return pubKey;
    }

    public static DSAPublicKey readDSAPubKey(Reader in) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN DSA PUBLIC KEY") == -1) continue;
            try {
                return (DSAPublicKey)PEMInputOutput.readPublicKey(_in, "DSA", "-----END DSA PUBLIC KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating DSA public key: " + e.toString());
            }
        }
        return null;
    }

    public static DSAPublicKey readDSAPublicKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN PUBLIC KEY") == -1) continue;
            try {
                return (DSAPublicKey)PEMInputOutput.readPublicKey(_in, "DSA", "-----END PUBLIC KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating DSA public key: " + e.toString());
            }
        }
        return null;
    }

    public static KeyPair readDSAPrivateKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN DSA PRIVATE KEY") == -1) continue;
            try {
                return PEMInputOutput.readKeyPair(_in, f, "DSA", "-----END DSA PRIVATE KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating DSA private key: " + e.toString());
            }
        }
        return null;
    }

    public static RSAPublicKey readRSAPubKey(Reader in) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN PUBLIC KEY") != -1) {
                try {
                    return PEMInputOutput.readRSAPublicKey(_in, "-----END PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA public key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN RSA PUBLIC KEY") == -1) continue;
            try {
                return PEMInputOutput.readRSAPublicKey(_in, "-----END RSA PUBLIC KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating RSA public key: " + e.toString());
            }
        }
        return null;
    }

    public static RSAPublicKey readRSAPublicKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN PUBLIC KEY") != -1) {
                try {
                    return (RSAPublicKey)PEMInputOutput.readPublicKey(_in, "RSA", "-----END PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA public key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN RSA PUBLIC KEY") == -1) continue;
            try {
                return (RSAPublicKey)PEMInputOutput.readPublicKey(_in, "RSA", "-----END RSA PUBLIC KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating RSA public key: " + e.toString());
            }
        }
        return null;
    }

    public static KeyPair readRSAPrivateKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN RSA PRIVATE KEY") == -1) continue;
            try {
                return PEMInputOutput.readKeyPair(_in, f, "RSA", "-----END RSA PRIVATE KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating RSA private key: " + e.toString());
            }
        }
        return null;
    }

    public static CMSSignedData readPKCS7(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN PKCS7") == -1) continue;
            try {
                return PEMInputOutput.readPKCS7(_in, f, "-----END PKCS7");
            }
            catch (Exception e) {
                throw new IOException("problem creating PKCS7: " + e.toString());
            }
        }
        return null;
    }

    public static X509AuxCertificate readX509Certificate(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                try {
                    return new X509AuxCertificate(PEMInputOutput.readCertificate(_in, "-----END X509 CERTIFICATE"));
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE") != -1) {
                try {
                    return new X509AuxCertificate(PEMInputOutput.readCertificate(_in, "-----END CERTIFICATE"));
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN TRUSTED CERTIFICATE") == -1) continue;
            try {
                return new X509AuxCertificate(PEMInputOutput.readCertificate(_in, "-----END TRUSTED CERTIFICATE"));
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 certificate: " + e.toString());
            }
        }
        return null;
    }

    public static X509AuxCertificate readX509Aux(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readAuxCertificate(_in, "-----END X509 CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readAuxCertificate(_in, "-----END CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN TRUSTED CERTIFICATE") == -1) continue;
            try {
                return PEMInputOutput.readAuxCertificate(_in, "-----END TRUSTED CERTIFICATE");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 Aux certificate: " + e.toString());
            }
        }
        return null;
    }

    public static X509CRL readX509CRL(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN X509 CRL") == -1) continue;
            try {
                return PEMInputOutput.readCRL(_in, "-----END X509 CRL");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 CRL: " + e.toString());
            }
        }
        return null;
    }

    public static PKCS10Request readX509Request(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN CERTIFICATE REQUEST") == -1) continue;
            try {
                return PEMInputOutput.readCertificateRequest(_in, "-----END CERTIFICATE REQUEST");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 REQ: " + e.toString());
            }
        }
        return null;
    }

    public static DHParameterSpec readDHParameters(Reader _in) throws IOException {
        Matcher m;
        String line;
        BufferedReader in = PEMInputOutput.makeBuffered(_in);
        StringBuilder buf = new StringBuilder();
        while ((line = in.readLine()) != null) {
            if (line.indexOf("-----BEGIN DH PARAMETERS") < 0) continue;
            do {
                buf.append(line.trim());
            } while (line.indexOf("-----END DH PARAMETERS") < 0 && (line = in.readLine()) != null);
        }
        if ((m = DH_PARAM_PATTERN.matcher(buf.toString())).find()) {
            try {
                byte[] decoded = Base64.decode(m.group(2));
                return PKey.readDHParameter(decoded);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private static byte[] getEncoded(Key key2) {
        if (key2 != null) {
            return key2.getEncoded();
        }
        return new byte[]{48, 0};
    }

    private static byte[] getEncoded(ASN1Encodable obj) throws IOException {
        if (obj != null) {
            return obj.toASN1Primitive().getEncoded();
        }
        return new byte[]{48, 0};
    }

    private static byte[] getEncoded(CMSSignedData obj) throws IOException {
        if (obj != null) {
            return obj.getEncoded();
        }
        return new byte[]{48, 0};
    }

    private static byte[] getEncoded(X509Certificate cert) throws IOException {
        if (cert != null) {
            try {
                return cert.getEncoded();
            }
            catch (GeneralSecurityException gse) {
                throw new IOException("problem with encoding object in write_X509");
            }
        }
        return new byte[]{48, 0};
    }

    private static byte[] getEncoded(X509CRL crl) throws IOException {
        if (crl != null) {
            try {
                return crl.getEncoded();
            }
            catch (GeneralSecurityException gse) {
                throw new IOException("problem with encoding object in write_X509_CRL");
            }
        }
        return new byte[]{48, 0};
    }

    public static void writeDSAPublicKey(Writer _out, DSAPublicKey obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN DSA PUBLIC KEY-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END DSA PUBLIC KEY-----");
        out.newLine();
        out.flush();
    }

    public static void writeRSAPublicKey(Writer _out, RSAPublicKey obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN RSA PUBLIC KEY-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END RSA PUBLIC KEY-----");
        out.newLine();
        out.flush();
    }

    public static void writePKCS7(Writer _out, ContentInfo obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN PKCS7-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END PKCS7-----");
        out.newLine();
        out.flush();
    }

    public static void writePKCS7(Writer _out, CMSSignedData obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN PKCS7-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END PKCS7-----");
        out.newLine();
        out.flush();
    }

    public static void writePKCS7(Writer _out, byte[] encoded) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        out.write("-----BEGIN PKCS7-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoded);
        out.write("-----END PKCS7-----");
        out.newLine();
        out.flush();
    }

    public static void writeX509Certificate(Writer _out, X509Certificate obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN CERTIFICATE-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END CERTIFICATE-----");
        out.newLine();
        out.flush();
    }

    public static void writeX509Aux(Writer _out, X509AuxCertificate obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = null;
        try {
            if (obj.getAux() == null) {
                encoding2 = obj.getEncoded();
            } else {
                ASN1EncodableVector a2;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] ymp = obj.getEncoded();
                baos.write(ymp, 0, ymp.length);
                X509Aux aux = obj.getAux();
                ASN1EncodableVector a1 = new ASN1EncodableVector();
                if (aux.trust.size() > 0) {
                    a2 = new ASN1EncodableVector();
                    for (String trust2 : aux.trust) {
                        a2.add(new ASN1ObjectIdentifier(trust2));
                    }
                    a1.add(new DLSequence(a2));
                }
                if (aux.reject.size() > 0) {
                    a2 = new ASN1EncodableVector();
                    for (String reject2 : aux.reject) {
                        a2.add(new ASN1ObjectIdentifier(reject2));
                    }
                    a1.add(new DERTaggedObject(0, new DLSequence(a2)));
                }
                if (aux.alias != null) {
                    a1.add(new DERUTF8String(aux.alias));
                }
                if (aux.keyid != null) {
                    a1.add(new DEROctetString(aux.keyid));
                }
                if (aux.other.size() > 0) {
                    a2 = new ASN1EncodableVector();
                    for (ASN1Primitive other : aux.other) {
                        a2.add(other);
                    }
                    a1.add(new DERTaggedObject(1, new DLSequence(a2)));
                }
                ymp = new DLSequence(a1).getEncoded();
                baos.write(ymp, 0, ymp.length);
                encoding2 = baos.toByteArray();
            }
        }
        catch (CertificateEncodingException e) {
            throw new IOException("problem with encoding object in write_X509_AUX");
        }
        out.write("-----BEGIN TRUSTED CERTIFICATE-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END TRUSTED CERTIFICATE-----");
        out.newLine();
        out.flush();
    }

    public static void writeX509CRL(Writer _out, X509CRL obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN X509 CRL-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END X509 CRL-----");
        out.newLine();
        out.flush();
    }

    public static void writeX509Request(Writer _out, PKCS10Request obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = PEMInputOutput.getEncoded(obj.toASN1Structure());
        out.write("-----BEGIN CERTIFICATE REQUEST-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END CERTIFICATE REQUEST-----");
        out.newLine();
        out.flush();
    }

    public static void writeDSAPrivateKey(Writer _out, DSAPrivateKey obj, CipherSpec cipher, char[] passwd2) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        PrivateKeyInfo info = new PrivateKeyInfo((ASN1Sequence)new ASN1InputStream(PEMInputOutput.getEncoded(obj)).readObject());
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        DSAParameter p2 = DSAParameter.getInstance(info.getPrivateKeyAlgorithm().getParameters());
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(0));
        v.add(new ASN1Integer(p2.getP()));
        v.add(new ASN1Integer(p2.getQ()));
        v.add(new ASN1Integer(p2.getG()));
        BigInteger x = obj.getX();
        BigInteger y = p2.getG().modPow(x, p2.getP());
        v.add(new ASN1Integer(y));
        v.add(new ASN1Integer(x));
        aOut.writeObject(new DLSequence(v));
        byte[] encoding2 = bOut.toByteArray();
        if (cipher != null && passwd2 != null) {
            PEMInputOutput.writePemEncrypted(out, PEM_STRING_DSA, encoding2, cipher, passwd2);
        } else {
            PEMInputOutput.writePemPlain(out, PEM_STRING_DSA, encoding2);
        }
    }

    public static void writeRSAPrivateKey(Writer _out, RSAPrivateCrtKey obj, CipherSpec cipher, char[] passwd2) throws IOException {
        assert (obj != null);
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        RSAPrivateKey keyStruct = new RSAPrivateKey(obj.getModulus(), obj.getPublicExponent(), obj.getPrivateExponent(), obj.getPrimeP(), obj.getPrimeQ(), obj.getPrimeExponentP(), obj.getPrimeExponentQ(), obj.getCrtCoefficient());
        if (cipher != null && passwd2 != null) {
            PEMInputOutput.writePemEncrypted(out, PEM_STRING_RSA, keyStruct.getEncoded(), cipher, passwd2);
        } else {
            PEMInputOutput.writePemPlain(out, PEM_STRING_RSA, keyStruct.getEncoded());
        }
    }

    private static void writePemPlain(BufferedWriter out, String pemHeader, byte[] encoding2) throws IOException {
        out.write(BEF_G + pemHeader + "-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write(BEF_E + pemHeader + "-----");
        out.newLine();
        out.flush();
    }

    private static void writePemEncrypted(BufferedWriter out, String pemHeader, byte[] encoding2, CipherSpec cipher, char[] passwd2) throws IOException {
        Cipher c = cipher.getCipher();
        byte[] iv = new byte[c.getBlockSize()];
        random.nextBytes(iv);
        byte[] salt = new byte[8];
        System.arraycopy(iv, 0, salt, 0, 8);
        OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
        pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes(passwd2), salt);
        KeyParameter param = (KeyParameter)pGen.generateDerivedParameters(cipher.getKeyLenInBits());
        SecretKeySpec secretKey = new SecretKeySpec(param.getKey(), Cipher.Algorithm.getAlgorithmBase(c));
        byte[] encData = null;
        try {
            c.init(1, (Key)secretKey, new IvParameterSpec(iv));
            encData = c.doFinal(encoding2);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException("exception using cipher: " + gse.toString());
        }
        out.write(BEF_G + pemHeader + "-----");
        out.newLine();
        out.write("Proc-Type: 4,ENCRYPTED");
        out.newLine();
        out.write("DEK-Info: " + cipher.getOsslName() + ",");
        PEMInputOutput.writeHexEncoded(out, iv);
        out.newLine();
        out.newLine();
        PEMInputOutput.writeEncoded(out, encData);
        out.write(BEF_E + pemHeader + "-----");
        out.flush();
    }

    public static void writeDHParameters(Writer _out, DHParameterSpec params2) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        ASN1EncodableVector v = new ASN1EncodableVector();
        BigInteger value2 = params2.getP();
        if (value2 != null) {
            v.add(new ASN1Integer(value2));
        }
        if ((value2 = params2.getG()) != null) {
            v.add(new ASN1Integer(value2));
        }
        aOut.writeObject(new DLSequence(v));
        byte[] encoding2 = bOut.toByteArray();
        out.write("-----BEGIN DH PARAMETERS-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END DH PARAMETERS-----");
        out.newLine();
        out.flush();
    }

    private static String getPrivateKeyTypeFromObjectId(ASN1ObjectIdentifier oid) {
        if (ASN1Registry.obj2nid(oid) == 6) {
            return "RSA";
        }
        return "DSA";
    }

    private static byte[] readBytes(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        return Base64.decode(buf.toString());
    }

    private static RSAPublicKey readRSAPublicKey(BufferedReader in, String endMarker) throws IOException {
        ASN1Primitive asnObject = new ASN1InputStream(PEMInputOutput.readBytes(in, endMarker)).readObject();
        ASN1Sequence sequence = (ASN1Sequence)asnObject;
        org.bouncycastle.asn1.pkcs.RSAPublicKey rsaPubStructure = org.bouncycastle.asn1.pkcs.RSAPublicKey.getInstance(sequence);
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(rsaPubStructure.getModulus(), rsaPubStructure.getPublicExponent());
        try {
            KeyFactory keyFact = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)keyFact.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        return null;
    }

    private static PublicKey readPublicKey(byte[] input, String alg, String endMarker) throws IOException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(input);
        try {
            KeyFactory keyFact = KeyFactory.getInstance(alg);
            PublicKey pubKey = keyFact.generatePublic(keySpec);
            return pubKey;
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        return null;
    }

    private static PublicKey readPublicKey(BufferedReader in, String alg, String endMarker) throws IOException {
        return PEMInputOutput.readPublicKey(PEMInputOutput.readBytes(in, endMarker), alg, endMarker);
    }

    private static PublicKey readPublicKey(BufferedReader in, String endMarker) throws IOException {
        byte[] input = PEMInputOutput.readBytes(in, endMarker);
        String[] algs = new String[]{"RSA", "DSA"};
        for (int i2 = 0; i2 < algs.length; ++i2) {
            PublicKey key2 = PEMInputOutput.readPublicKey(input, algs[i2], endMarker);
            if (key2 == null) continue;
            return key2;
        }
        return null;
    }

    private static KeyPair readKeyPair(BufferedReader _in, char[] passwd2, String type2, String endMarker) throws Exception {
        boolean isEncrypted = false;
        String line = null;
        String dekInfo = null;
        StringBuilder buf = new StringBuilder();
        while ((line = _in.readLine()) != null) {
            if (line.startsWith("Proc-Type: 4,ENCRYPTED")) {
                isEncrypted = true;
                continue;
            }
            if (line.startsWith("DEK-Info:")) {
                dekInfo = line.substring(10);
                continue;
            }
            if (line.indexOf(endMarker) != -1) break;
            buf.append(line.trim());
        }
        byte[] keyBytes = null;
        byte[] decoded = Base64.decode(buf.toString());
        keyBytes = isEncrypted ? PEMInputOutput.decrypt(decoded, dekInfo, passwd2) : decoded;
        return PKey.readPrivateKey(keyBytes, type2);
    }

    private static byte[] decrypt(byte[] decoded, String dekInfo, char[] passwd2) throws IOException, GeneralSecurityException {
        if (passwd2 == null) {
            throw new IOException("Password is null, but a password is required");
        }
        StringTokenizer tknz = new StringTokenizer(dekInfo, ",");
        String algorithm = tknz.nextToken();
        byte[] iv = Hex.decode(tknz.nextToken());
        if (!Cipher.CipherModule.isSupportedCipher(algorithm)) {
            throw new IOException("Unknown algorithm: " + algorithm);
        }
        String[] cipher = Cipher.Algorithm.osslToJsse(algorithm);
        String realName = cipher[3];
        int[] lengths = Cipher.Algorithm.osslKeyIvLength(algorithm);
        int keyLen = lengths[0];
        int ivLen = lengths[1];
        if (iv.length != ivLen) {
            throw new IOException("Illegal IV length");
        }
        byte[] salt = new byte[8];
        System.arraycopy(iv, 0, salt, 0, 8);
        OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
        pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes(passwd2), salt);
        KeyParameter param = (KeyParameter)pGen.generateDerivedParameters(keyLen * 8);
        SecretKeySpec secretKey = new SecretKeySpec(param.getKey(), realName);
        Cipher c = Cipher.getInstance(realName);
        c.init(2, (Key)secretKey, new IvParameterSpec(iv));
        return c.doFinal(decoded);
    }

    private static X509Certificate readCertificate(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bIn = new ByteArrayInputStream(Base64.decode(buf.toString()));
            return (X509Certificate)certFact.generateCertificate(bIn);
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private static X509AuxCertificate readAuxCertificate(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        ASN1InputStream try1 = new ASN1InputStream(Base64.decode(buf.toString()));
        ByteArrayInputStream bIn = new ByteArrayInputStream(try1.readObject().getEncoded());
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            X509Certificate bCert = (X509Certificate)certFact.generateCertificate(bIn);
            ASN1Sequence aux = (ASN1Sequence)try1.readObject();
            X509Aux ax = null;
            if (aux != null) {
                int i2;
                ax = new X509Aux();
                int ix = 0;
                if (aux.size() > ix && aux.getObjectAt(ix) instanceof ASN1Sequence) {
                    ASN1Sequence trust2 = (ASN1Sequence)aux.getObjectAt(ix++);
                    for (i2 = 0; i2 < trust2.size(); ++i2) {
                        ax.trust.add(((ASN1ObjectIdentifier)trust2.getObjectAt(i2)).getId());
                    }
                }
                if (aux.size() > ix && aux.getObjectAt(ix) instanceof ASN1TaggedObject && ((ASN1TaggedObject)aux.getObjectAt(ix)).getTagNo() == 0) {
                    ASN1Sequence reject2 = (ASN1Sequence)((ASN1TaggedObject)aux.getObjectAt(ix++)).getObject();
                    for (i2 = 0; i2 < reject2.size(); ++i2) {
                        ax.reject.add(((ASN1ObjectIdentifier)reject2.getObjectAt(i2)).getId());
                    }
                }
                if (aux.size() > ix && aux.getObjectAt(ix) instanceof DERUTF8String) {
                    ax.alias = ((DERUTF8String)aux.getObjectAt(ix++)).getString();
                }
                if (aux.size() > ix && aux.getObjectAt(ix) instanceof DEROctetString) {
                    ax.keyid = ((DEROctetString)aux.getObjectAt(ix++)).getOctets();
                }
                if (aux.size() > ix && aux.getObjectAt(ix) instanceof ASN1TaggedObject && ((ASN1TaggedObject)aux.getObjectAt(ix)).getTagNo() == 1) {
                    ASN1Sequence other = (ASN1Sequence)((ASN1TaggedObject)aux.getObjectAt(ix++)).getObject();
                    for (i2 = 0; i2 < other.size(); ++i2) {
                        ax.other.add((ASN1Primitive)other.getObjectAt(i2));
                    }
                }
            }
            return new X509AuxCertificate(bCert, ax);
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private static X509CRL readCRL(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bIn = new ByteArrayInputStream(Base64.decode(buf.toString()));
            return (X509CRL)certFact.generateCRL(bIn);
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private static PKCS10Request readCertificateRequest(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        try {
            return new PKCS10Request(Base64.decode(buf.toString()));
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private static void writeHexEncoded(BufferedWriter out, byte[] bytes2) throws IOException {
        bytes2 = Hex.encode(bytes2);
        for (int i2 = 0; i2 != bytes2.length; ++i2) {
            out.write((char)bytes2[i2]);
        }
    }

    private static void writeEncoded(BufferedWriter out, byte[] bytes2) throws IOException {
        char[] buf = new char[64];
        bytes2 = Base64.encode(bytes2);
        for (int i2 = 0; i2 < bytes2.length; i2 += buf.length) {
            int index2;
            for (index2 = 0; index2 != buf.length && i2 + index2 < bytes2.length; ++index2) {
                buf[index2] = (char)bytes2[i2 + index2];
            }
            out.write(buf, 0, index2);
            out.newLine();
        }
    }

    private static CMSSignedData readPKCS7(BufferedReader in, char[] p2, String endMarker) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            line = line.trim();
            buf.append(line.trim());
            Base64.decode(buf.substring(0, buf.length() / 4 * 4), bOut);
            buf.delete(0, buf.length() / 4 * 4);
        }
        if (buf.length() != 0) {
            throw new RuntimeException("base64 data appears to be truncated");
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        try {
            ASN1InputStream aIn = new ASN1InputStream(bOut.toByteArray());
            return new CMSSignedData(ContentInfo.getInstance(aIn.readObject()));
        }
        catch (Exception e) {
            throw new IOException("problem parsing PKCS7 object: " + e.toString());
        }
    }

    static {
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception e) {
            random = null;
        }
    }
}

