/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.security.cert.X509CRL;
import java.util.Collection;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.impl.Digest;
import org.jruby.ext.openssl.impl.Encrypt;
import org.jruby.ext.openssl.impl.Envelope;
import org.jruby.ext.openssl.impl.PKCS7;
import org.jruby.ext.openssl.impl.PKCS7DataData;
import org.jruby.ext.openssl.impl.PKCS7DataDigest;
import org.jruby.ext.openssl.impl.PKCS7DataEncrypted;
import org.jruby.ext.openssl.impl.PKCS7DataEnveloped;
import org.jruby.ext.openssl.impl.PKCS7DataSigned;
import org.jruby.ext.openssl.impl.PKCS7DataSignedAndEnveloped;
import org.jruby.ext.openssl.impl.PKCS7Exception;
import org.jruby.ext.openssl.impl.RecipInfo;
import org.jruby.ext.openssl.impl.SignEnvelope;
import org.jruby.ext.openssl.impl.Signed;
import org.jruby.ext.openssl.impl.SignerInfoWithPkey;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PKCS7Data {
    public abstract int getType();

    public Object ctrl(int cmd, Object v, Object ignored) throws PKCS7Exception {
        switch (cmd) {
            case 1: {
                throw new PKCS7Exception(104, 104);
            }
            case 2: {
                throw new PKCS7Exception(104, 104);
            }
        }
        throw new PKCS7Exception(104, 110);
    }

    public Envelope getEnveloped() {
        return null;
    }

    public SignEnvelope getSignedAndEnveloped() {
        return null;
    }

    public Digest getDigest() {
        return null;
    }

    public Encrypt getEncrypted() {
        return null;
    }

    public ASN1Encodable getOther() {
        return null;
    }

    public void setSign(Signed sign2) {
    }

    public Signed getSign() {
        return null;
    }

    public void setData(ASN1OctetString data2) {
    }

    public ASN1OctetString getData() {
        return null;
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isEncrypted() {
        return false;
    }

    public boolean isEnveloped() {
        return false;
    }

    public boolean isSignedAndEnveloped() {
        return false;
    }

    public boolean isData() {
        return false;
    }

    public boolean isDigest() {
        return false;
    }

    public boolean isOther() {
        return false;
    }

    public void setCipher(CipherSpec cipher) throws PKCS7Exception {
        throw new PKCS7Exception(108, 113);
    }

    public void addRecipientInfo(RecipInfo ri) throws PKCS7Exception {
        throw new PKCS7Exception(102, 113);
    }

    public void addSigner(SignerInfoWithPkey psi) throws PKCS7Exception {
        throw new PKCS7Exception(103, 113);
    }

    public void setContent(PKCS7 p7) throws PKCS7Exception {
        throw new PKCS7Exception(109, 113);
    }

    public Collection<SignerInfoWithPkey> getSignerInfo() {
        return null;
    }

    public void addCertificate(X509AuxCertificate cert) throws PKCS7Exception {
        throw new PKCS7Exception(100, 113);
    }

    public void addCRL(X509CRL crl) throws PKCS7Exception {
        throw new PKCS7Exception(101, 113);
    }

    public static PKCS7Data fromASN1(Integer nid, ASN1Encodable content) throws PKCS7Exception {
        switch (nid) {
            case 21: {
                return PKCS7DataData.fromASN1(content);
            }
            case 22: {
                return PKCS7DataSigned.fromASN1(content);
            }
            case 23: {
                return PKCS7DataEnveloped.fromASN1(content);
            }
            case 24: {
                return PKCS7DataSignedAndEnveloped.fromASN1(content);
            }
            case 25: {
                return PKCS7DataDigest.fromASN1(content);
            }
            case 26: {
                return PKCS7DataEncrypted.fromASN1(content);
            }
        }
        throw new UnsupportedOperationException("can't handle PKCS#7 with content type " + ASN1Registry.nid2ln(nid));
    }

    public ASN1Encodable asASN1() {
        throw new UnsupportedOperationException("can't ASN1 PKCS#7 with content type " + ASN1Registry.nid2ln(this.getType()));
    }
}

