/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyObjectAdapter;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509Store;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.StoreContext;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Utils;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class X509StoreCtx
extends RubyObject {
    private static final long serialVersionUID = 2029690161026120504L;
    private static ObjectAllocator X509STORECTX_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509StoreCtx(runtime, klass);
        }
    };
    private static RubyObjectAdapter api = JavaEmbedUtils.newObjectAdapter();
    private StoreContext ctx;
    private RubyClass cX509Cert;

    public static void createX509StoreCtx(Ruby runtime, RubyModule mX509) {
        RubyClass cX509StoreContext = mX509.defineClassUnder("StoreContext", runtime.getObject(), X509STORECTX_ALLOCATOR);
        cX509StoreContext.defineAnnotatedMethods(X509StoreCtx.class);
    }

    public X509StoreCtx(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
        this.ctx = new StoreContext();
        this.cX509Cert = Utils.getClassFromPath(runtime, "OpenSSL::X509::Certificate");
    }

    X509StoreCtx(Ruby runtime, RubyClass type2, StoreContext ctx) {
        super(runtime, type2);
        this.ctx = ctx;
        this.cX509Cert = Utils.getClassFromPath(runtime, "OpenSSL::X509::Certificate");
    }

    @JRubyMethod(name={"initialize"}, rest=true, frame=true)
    public IRubyObject _initialize(IRubyObject[] args2, Block block) {
        IRubyObject cert = this.getRuntime().getNil();
        IRubyObject chain = this.getRuntime().getNil();
        X509AuxCertificate x509 = null;
        ArrayList<X509AuxCertificate> x509s = new ArrayList<X509AuxCertificate>();
        if (Arity.checkArgumentCount(this.getRuntime(), args2, 1, 3) > 1) {
            cert = args2[1];
        }
        if (args2.length > 2) {
            chain = args2[2];
        }
        IRubyObject store = args2[0];
        Store x509st = ((X509Store)store).getStore();
        if (!cert.isNil()) {
            x509 = ((X509Cert)cert).getAuxCert();
        }
        if (!chain.isNil()) {
            x509s = new ArrayList();
            for (IRubyObject obj : ((RubyArray)chain).toJavaArray()) {
                x509s.add(((X509Cert)obj).getAuxCert());
            }
        }
        if (this.ctx.init(x509st, x509, x509s) != 1) {
            throw X509StoreCtx.newStoreError(this.getRuntime(), null);
        }
        IRubyObject t = api.getInstanceVariable(store, "@time");
        if (!t.isNil()) {
            this.set_time(t);
        }
        api.setInstanceVariable(this, "@verify_callback", api.getInstanceVariable(store, "@verify_callback"));
        api.setInstanceVariable(this, "@cert", cert);
        return this;
    }

    @JRubyMethod
    public IRubyObject verify() {
        this.ctx.setExtraData(1, this.getInstanceVariable("@verify_callback"));
        try {
            int result2 = this.ctx.verifyCertificate();
            return result2 != 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        catch (Exception e) {
            throw X509StoreCtx.newStoreError(this.getRuntime(), e.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject chain() {
        List<X509AuxCertificate> chain = this.ctx.getChain();
        if (chain == null) {
            return this.getRuntime().getNil();
        }
        ArrayList<IRubyObject> ary = new ArrayList<IRubyObject>();
        try {
            for (X509AuxCertificate x509 : chain) {
                ary.add(this.cX509Cert.callMethod(this.getRuntime().getCurrentContext(), "new", (IRubyObject)RubyString.newString(this.getRuntime(), x509.getEncoded())));
            }
        }
        catch (CertificateEncodingException cee) {
            throw X509StoreCtx.newStoreError(this.getRuntime(), cee.getMessage());
        }
        return this.getRuntime().newArray(ary);
    }

    @JRubyMethod
    public IRubyObject error() {
        return this.getRuntime().newFixnum(this.ctx.getError());
    }

    @JRubyMethod(name={"error="})
    public IRubyObject set_error(IRubyObject arg2) {
        this.ctx.setError(RubyNumeric.fix2int(arg2));
        return arg2;
    }

    @JRubyMethod
    public IRubyObject error_string() {
        int err = this.ctx.getError();
        return this.getRuntime().newString(X509Utils.verifyCertificateErrorString(err));
    }

    @JRubyMethod
    public IRubyObject error_depth() {
        System.err.println("WARNING: unimplemented method called: StoreContext#error_depth");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject current_cert() {
        Ruby rt = this.getRuntime();
        X509AuxCertificate x509 = this.ctx.getCurrentCertificate();
        try {
            return this.cX509Cert.callMethod(rt.getCurrentContext(), "new", (IRubyObject)RubyString.newString(rt, x509.getEncoded()));
        }
        catch (CertificateEncodingException cee) {
            throw X509StoreCtx.newStoreError(this.getRuntime(), cee.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject current_crl() {
        System.err.println("WARNING: unimplemented method called: StoreContext#current_crl");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject cleanup() {
        System.err.println("WARNING: unimplemented method called: StoreContext#cleanup");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"flags="})
    public IRubyObject set_flags(IRubyObject arg2) {
        System.err.println("WARNING: unimplemented method called: StoreContext#set_flags");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"purpose="})
    public IRubyObject set_purpose(IRubyObject arg2) {
        System.err.println("WARNING: unimplemented method called: StoreContext#set_purpose");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"trust="})
    public IRubyObject set_trust(IRubyObject arg2) {
        System.err.println("WARNING: unimplemented method called: StoreContext#set_trust");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"time="})
    public IRubyObject set_time(IRubyObject arg2) {
        this.ctx.setTime(0L, ((RubyTime)arg2).getJavaDate());
        return arg2;
    }

    private static RaiseException newStoreError(Ruby runtime, String message2) {
        return Utils.newError(runtime, "OpenSSL::X509::StoreError", message2);
    }
}

