/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.StringWriter;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Attribute;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.impl.PKCS10Request;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request
extends RubyObject {
    private static final long serialVersionUID = -5551557929791764918L;
    private static ObjectAllocator REQUEST_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new Request(runtime, klass);
        }
    };
    private IRubyObject subject;
    private IRubyObject public_key;
    private List<IRubyObject> attrs = new ArrayList<IRubyObject>();
    private PKCS10Request req = new PKCS10Request((X500Name)null, (PublicKey)null, null);

    public static void createRequest(Ruby runtime, RubyModule mX509) {
        RubyClass cRequest = mX509.defineClassUnder("Request", runtime.getObject(), REQUEST_ALLOCATOR);
        RubyClass openSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        mX509.defineClassUnder("RequestError", openSSLError, openSSLError.getAllocator());
        cRequest.defineAnnotatedMethods(Request.class);
    }

    public Request(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(name={"initialize"}, frame=true, rest=true)
    public IRubyObject _initialize(IRubyObject[] args2, Block block) {
        if (Arity.checkArgumentCount(this.getRuntime(), args2, 0, 1) == 0) {
            return this;
        }
        try {
            this.req = new PKCS10Request(OpenSSLImpl.readX509PEM(args2[0]));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw Request.newX509ReqError(this.getRuntime(), "invalid certificate request data");
        }
        String algo = null;
        byte[] enc = null;
        try {
            PublicKey pkey = this.req.getPublicKey();
            algo = pkey.getAlgorithm();
            enc = pkey.getEncoded();
        }
        catch (IOException e) {
            throw Request.newX509ReqError(this.getRuntime(), e.getMessage());
        }
        if ("RSA".equalsIgnoreCase(algo)) {
            this.public_key = Utils.newRubyInstance(this.getRuntime(), "OpenSSL::PKey::RSA", RubyString.newString(this.getRuntime(), enc));
        } else if ("DSA".equalsIgnoreCase(algo)) {
            this.public_key = Utils.newRubyInstance(this.getRuntime(), "OpenSSL::PKey::DSA", RubyString.newString(this.getRuntime(), enc));
        } else {
            throw this.getRuntime().newLoadError("not implemented algo for public key: " + algo);
        }
        this.subject = this.makeRubyName(this.req.getSubject());
        this.attrs = new ArrayList<IRubyObject>(this.req.getAttributes().length);
        try {
            for (org.bouncycastle.asn1.pkcs.Attribute attr2 : this.req.getAttributes()) {
                this.attrs.add(this.makeRubyAttr(attr2.getAttrType(), attr2.getAttrValues()));
            }
        }
        catch (IOException ex) {
            throw Request.newX509ReqError(this.getRuntime(), ex.getMessage());
        }
        return this;
    }

    private IRubyObject makeRubyAttr(ASN1ObjectIdentifier type2, ASN1Set values2) throws IOException {
        RubyString rubyType = this.getRuntime().newString(ASN1.getSymLookup(this.getRuntime()).get(type2));
        IRubyObject rubyValue = ASN1.decode(this.getRuntime().getClassFromPath("OpenSSL::ASN1"), RubyString.newString(this.getRuntime(), values2.getEncoded()));
        return Utils.newRubyInstance(this.getRuntime(), "OpenSSL::X509::Attribute", new IRubyObject[]{rubyType, rubyValue});
    }

    private IRubyObject makeRubyName(X500Name name2) {
        if (name2 == null) {
            return this.getRuntime().getNil();
        }
        IRubyObject newName = Utils.newRubyInstance(this.getRuntime(), "OpenSSL::X509::Name");
        for (RDN rdn : name2.getRDNs()) {
            for (AttributeTypeAndValue tv : rdn.getTypesAndValues()) {
                ASN1ObjectIdentifier oid = tv.getType();
                String val = null;
                if (tv.getValue() instanceof ASN1String) {
                    val = ((ASN1String)((Object)tv.getValue())).getString();
                }
                RubyFixnum typef = this.getRuntime().newFixnum(ASN1.idForClass(tv.getValue().getClass()));
                ((X509Name)newName).addEntry(oid, val, typef);
            }
        }
        return newName;
    }

    @Override
    @JRubyMethod
    public IRubyObject initialize_copy(IRubyObject obj) {
        System.err.println("WARNING: unimplemented method called: init_copy");
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        this.subject = this.getRuntime().getNil();
        this.public_key = this.getRuntime().getNil();
        return this;
    }

    @JRubyMethod(name={"to_pem", "to_s"})
    public IRubyObject to_pem() {
        StringWriter w = new StringWriter();
        try {
            PEMInputOutput.writeX509Request(w, this.req);
            RubyString rubyString = this.getRuntime().newString(w.toString());
            return rubyString;
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        finally {
            try {
                w.close();
            }
            catch (Exception e) {}
        }
    }

    @JRubyMethod
    public IRubyObject to_der() {
        try {
            return RubyString.newString(this.getRuntime(), this.req.toASN1Structure().getEncoded());
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
    }

    @JRubyMethod
    public IRubyObject to_text() {
        System.err.println("WARNING: unimplemented method called: to_text");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject version() {
        return this.getRuntime().newFixnum(this.req.getVersion());
    }

    @JRubyMethod(name={"version="})
    public IRubyObject set_version(IRubyObject val) {
        return val;
    }

    @JRubyMethod
    public IRubyObject subject() {
        return this.subject;
    }

    private static X500Name x500Name(IRubyObject name2) {
        return ((X509Name)name2).getX500Name();
    }

    @JRubyMethod(name={"subject="})
    public IRubyObject set_subject(IRubyObject val) {
        if (val != this.subject) {
            this.req.setSubject(Request.x500Name(val));
            this.subject = val;
        }
        return val;
    }

    @JRubyMethod
    public IRubyObject signature_algorithm() {
        System.err.println("WARNING: unimplemented method called: signature_algorithm");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject public_key() {
        return this.public_key;
    }

    @JRubyMethod(name={"public_key="})
    public IRubyObject set_public_key(IRubyObject val) {
        if (val != this.subject) {
            this.req.setPublicKey(((PKey)val).getPublicKey());
            this.public_key = val;
        }
        return val;
    }

    @JRubyMethod
    public IRubyObject sign(IRubyObject key2, IRubyObject digest2) {
        String digName;
        String digAlg;
        PublicKey publicKey = ((PKey)this.public_key).getPublicKey();
        PrivateKey privateKey = ((PKey)key2).getPrivateKey();
        String keyAlg = publicKey.getAlgorithm();
        if (PKCS10Request.algorithmMismatch(keyAlg, digAlg = ((Digest)digest2).getShortAlgorithm(), digName = ((Digest)digest2).name().toString())) {
            throw Request.newX509ReqError(this.getRuntime(), null);
        }
        String sigAlgStr = digAlg + "WITH" + keyAlg;
        this.req = new PKCS10Request(Request.x500Name(this.subject), publicKey, this.makeAttrList(this.attrs));
        try {
            this.req.sign(privateKey, digAlg);
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
        return this;
    }

    private List<org.bouncycastle.asn1.pkcs.Attribute> makeAttrList(List<IRubyObject> list2) {
        ArrayList<org.bouncycastle.asn1.pkcs.Attribute> realList = new ArrayList<org.bouncycastle.asn1.pkcs.Attribute>(list2.size());
        for (IRubyObject attr2 : list2) {
            realList.add(this.makeAttr(attr2));
        }
        return realList;
    }

    private org.bouncycastle.asn1.pkcs.Attribute makeAttr(IRubyObject attr2) {
        return org.bouncycastle.asn1.pkcs.Attribute.getInstance(((Attribute)attr2).toASN1());
    }

    @JRubyMethod
    public IRubyObject verify(IRubyObject key2) {
        try {
            PublicKey publicKey = ((PKey)key2.callMethod(this.getRuntime().getCurrentContext(), "public_key")).getPublicKey();
            return this.req.verify(publicKey) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        catch (InvalidKeyException e) {
            throw Request.newX509ReqError(this.getRuntime(), e.getMessage());
        }
        catch (Exception e) {
            return this.getRuntime().getFalse();
        }
    }

    @JRubyMethod
    public IRubyObject attributes() {
        return this.getRuntime().newArray(this.attrs);
    }

    @JRubyMethod(name={"attributes="})
    public IRubyObject set_attributes(IRubyObject val) {
        this.attrs.clear();
        this.attrs.addAll(((RubyArray)val).getList());
        if (this.req != null) {
            this.req.setAttributes(this.makeAttrList(this.attrs));
        }
        return val;
    }

    @JRubyMethod
    public IRubyObject add_attribute(IRubyObject val) {
        this.attrs.add(val);
        if (this.req != null) {
            this.req.addAttribute(this.makeAttr(val));
        }
        return val;
    }

    private static RaiseException newX509ReqError(Ruby runtime, String message2) {
        return Utils.newError(runtime, "OpenSSL::X509::RequestError", message2);
    }
}

