/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DLSequence;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class Attribute
extends RubyObject {
    private static final long serialVersionUID = 5569940260019783275L;
    private static ObjectAllocator ATTRIBUTE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new Attribute(runtime, klass);
        }
    };
    private IRubyObject oid;
    private IRubyObject value;

    public static void createAttribute(Ruby runtime, RubyModule mX509) {
        RubyClass cAttribute = mX509.defineClassUnder("Attribute", runtime.getObject(), ATTRIBUTE_ALLOCATOR);
        RubyClass openSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        mX509.defineClassUnder("AttributeError", openSSLError, openSSLError.getAllocator());
        cAttribute.defineAnnotatedMethods(Attribute.class);
    }

    public Attribute(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    private ASN1ObjectIdentifier getObjectIdentifier(String nameOrOid) {
        ASN1ObjectIdentifier val1 = ASN1.getOIDLookup(this.getRuntime()).get(nameOrOid.toLowerCase());
        if (null != val1) {
            return val1;
        }
        ASN1ObjectIdentifier val2 = new ASN1ObjectIdentifier(nameOrOid);
        return val2;
    }

    ASN1Primitive toASN1() {
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        v1.add(this.getObjectIdentifier(this.oid.toString()));
        if (this.value instanceof ASN1.ASN1Constructive) {
            v1.add(((ASN1.ASN1Constructive)this.value).toASN1());
        } else {
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            v2.add(((ASN1.ASN1Data)this.value).toASN1());
            v1.add(new DERSet(v2));
        }
        return new DLSequence(v1);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1)
    public IRubyObject _initialize(IRubyObject[] str) {
        if (Arity.checkArgumentCount(this.getRuntime(), str, 1, 2) == 1) {
            IRubyObject _oid = OpenSSLImpl.to_der_if_possible(str[0]);
            this.set_oid(_oid);
            return this;
        }
        this.set_oid(str[0]);
        this.set_value(str[1]);
        return this;
    }

    @JRubyMethod
    public IRubyObject to_der() {
        System.err.println("WARNING: unimplemented method called: attr#to_der");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject oid() {
        return this.oid;
    }

    @JRubyMethod(name={"oid="})
    public IRubyObject set_oid(IRubyObject val) {
        this.oid = val;
        return val;
    }

    @JRubyMethod
    public IRubyObject value() {
        return this.value;
    }

    @JRubyMethod(name={"value="})
    public IRubyObject set_value(IRubyObject val) {
        IRubyObject tmp = OpenSSLImpl.to_der_if_possible(val);
        this.value = ASN1.decode(this.getRuntime().getClassFromPath("OpenSSL::ASN1"), tmp);
        return val;
    }
}

