/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyMatchData;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.DefinedMessage;

public class NthRefNode
extends Node {
    private final int matchNumber;
    private final DefinedMessage definedMessage;

    public NthRefNode(ISourcePosition position, int matchNumber) {
        super(position);
        this.matchNumber = matchNumber;
        this.definedMessage = DefinedMessage.byText("$" + matchNumber);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.NTHREFNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitNthRefNode(this);
    }

    public int getMatchNumber() {
        return this.matchNumber;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return RubyRegexp.nth_match(this.matchNumber, context.getCurrentScope().getBackRef(runtime));
    }

    @Override
    public RubyString definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject backref = context.getCurrentScope().getBackRef(runtime);
        if (backref instanceof RubyMatchData && !((RubyMatchData)backref).group(this.matchNumber).isNil()) {
            if (!context.runtime.is1_9()) {
                return runtime.getDefinedMessage(this.definedMessage);
            }
            return runtime.getDefinedMessage(DefinedMessage.GLOBAL_VARIABLE);
        }
        return null;
    }
}

