/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.DefinedMessage;

public class DVarNode
extends Node
implements INameNode {
    private String name;
    private int location;

    public DVarNode(ISourcePosition position, int location, String name2) {
        super(position);
        this.location = location;
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.DVARNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitDVarNode(this);
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject obj = context.getCurrentScope().getValue(this.getIndex(), this.getDepth());
        return obj == null ? runtime.getNil() : obj;
    }

    @Override
    public RubyString definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyString definition = runtime.getDefinedMessage(DefinedMessage.LOCAL_VARIABLE);
        if (!context.runtime.is1_9()) {
            definition = runtime.getDefinedMessage(DefinedMessage.LOCAL_VARIABLE_IN_BLOCK);
        }
        return definition;
    }
}

