/*
 * Decompiled with CFR 0.152.
 */
package org.jbson;

import java.util.LinkedList;
import java.util.List;
import org.bson.BSONCallback;
import org.bson.types.ObjectId;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyBSONCallback
implements BSONCallback {
    private RubyHash _root;
    private RubyModule _rbclsOrderedHash;
    private RubyModule _rbclsObjectId;
    private RubyModule _rbclsBinary;
    private RubyModule _rbclsMinKey;
    private RubyModule _rbclsMaxKey;
    private RubyModule _rbclsTimestamp;
    private RubyModule _rbclsCode;
    private final LinkedList<RubyObject> _stack = new LinkedList();
    private final LinkedList<String> _nameStack = new LinkedList();
    private Ruby _runtime;

    public RubyBSONCallback(Ruby ruby2) {
        this._runtime = ruby2;
        this._rbclsOrderedHash = ruby2.getClassFromPath("BSON::OrderedHash");
        this._rbclsBinary = ruby2.getClassFromPath("BSON::Binary");
        this._rbclsCode = ruby2.getClassFromPath("BSON::Code");
        this._rbclsMinKey = ruby2.getClassFromPath("BSON::MinKey");
        this._rbclsMaxKey = ruby2.getClassFromPath("BSON::MaxKey");
        this._rbclsTimestamp = ruby2.getClassFromPath("BSON::Timestamp");
        this._rbclsObjectId = ruby2.getClassFromPath("BSON::ObjectId");
    }

    @Override
    public BSONCallback createBSONCallback() {
        return new RubyBSONCallback(this._runtime);
    }

    @Override
    public void reset() {
        this._root = null;
        this._stack.clear();
        this._nameStack.clear();
    }

    public RubyHash createHash() {
        return (RubyHash)JavaEmbedUtils.invokeMethod(this._runtime, this._rbclsOrderedHash, "new", new Object[0], Object.class);
    }

    public RubyArray createArray() {
        return RubyArray.newArray(this._runtime);
    }

    public RubyObject create(boolean bl, List<String> list2) {
        if (bl) {
            return this.createArray();
        }
        return this.createHash();
    }

    @Override
    public void objectStart() {
        if (this._stack.size() > 0) {
            throw new IllegalStateException("Error! An illegal state ocurred.");
        }
        this._root = this.createHash();
        this._stack.add(this._root);
    }

    @Override
    public void objectStart(boolean bl) {
        this.objectStart();
    }

    @Override
    public void objectStart(String string2) {
        RubyHash rubyHash = this.createHash();
        this._nameStack.addLast(string2);
        RubyObject rubyObject = this._stack.getLast();
        if (rubyObject instanceof RubyHash) {
            this.writeRubyHash(string2, (RubyHash)rubyObject, rubyHash);
        } else {
            this.writeRubyArray(string2, (RubyArray)rubyObject, rubyHash);
        }
        this._stack.addLast(rubyHash);
    }

    public void writeRubyHash(String string2, RubyHash rubyHash, IRubyObject iRubyObject) {
        RubyString rubyString = this._runtime.newString(string2);
        JavaEmbedUtils.invokeMethod(this._runtime, rubyHash, "[]=", new Object[]{rubyString, iRubyObject}, Object.class);
    }

    public void writeRubyArray(String string2, RubyArray rubyArray, IRubyObject iRubyObject) {
        Long l = Long.parseLong(string2);
        rubyArray.store(l, iRubyObject);
    }

    @Override
    public void arrayStart(String string2) {
        RubyArray rubyArray = this.createArray();
        RubyObject rubyObject = this._stack.getLast();
        this._nameStack.addLast(string2);
        if (rubyObject instanceof RubyHash) {
            this.writeRubyHash(string2, (RubyHash)rubyObject, rubyArray);
        } else {
            this.writeRubyArray(string2, (RubyArray)rubyObject, rubyArray);
        }
        this._stack.addLast(rubyArray);
    }

    @Override
    public RubyObject objectDone() {
        RubyObject rubyObject = this._stack.removeLast();
        if (this._nameStack.size() > 0) {
            this._nameStack.removeLast();
        } else if (this._stack.size() > 0) {
            throw new IllegalStateException("Error! An illegal state ocurred.");
        }
        return rubyObject;
    }

    @Override
    public void arrayStart() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RubyObject arrayDone() {
        return this.objectDone();
    }

    @Override
    public void gotNull(String string2) {
        this._put(string2, (RubyObject)this._runtime.getNil());
    }

    @Override
    @Deprecated
    public void gotUndefined(String string2) {
    }

    @Override
    public void gotUUID(String string2, long l, long l2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void gotCode(String string2, String string3) {
        RubyString rubyString = this._runtime.newString(string3);
        Object object = JavaEmbedUtils.invokeMethod(this._runtime, this._rbclsCode, "new", new Object[]{rubyString}, Object.class);
        this._put(string2, (RubyObject)object);
    }

    @Override
    public void gotCodeWScope(String string2, String string3, Object object) {
        RubyString rubyString = this._runtime.newString(string3);
        Object object2 = JavaEmbedUtils.invokeMethod(this._runtime, this._rbclsCode, "new", new Object[]{rubyString, (RubyHash)object}, Object.class);
        this._put(string2, (RubyObject)object2);
    }

    @Override
    public void gotMinKey(String string2) {
        Object object = JavaEmbedUtils.invokeMethod(this._runtime, this._rbclsMinKey, "new", new Object[0], Object.class);
        this._put(string2, (RubyObject)object);
    }

    @Override
    public void gotMaxKey(String string2) {
        Object object = JavaEmbedUtils.invokeMethod(this._runtime, this._rbclsMaxKey, "new", new Object[0], Object.class);
        this._put(string2, (RubyObject)object);
    }

    @Override
    public void gotBoolean(String string2, boolean bl) {
        RubyBoolean rubyBoolean = RubyBoolean.newBoolean(this._runtime, bl);
        this._put(string2, rubyBoolean);
    }

    @Override
    public void gotDouble(String string2, double d) {
        RubyFloat rubyFloat = new RubyFloat(this._runtime, d);
        this._put(string2, rubyFloat);
    }

    @Override
    public void gotInt(String string2, int n) {
        RubyFixnum rubyFixnum = new RubyFixnum(this._runtime, (long)n);
        this._put(string2, rubyFixnum);
    }

    @Override
    public void gotLong(String string2, long l) {
        RubyFixnum rubyFixnum = new RubyFixnum(this._runtime, l);
        this._put(string2, rubyFixnum);
    }

    @Override
    public void gotDate(String string2, long l) {
        RubyTime rubyTime = RubyTime.newTime(this._runtime, l).gmtime();
        this._put(string2, rubyTime);
    }

    @Override
    public void gotRegex(String string2, String string3, String string4) {
        boolean bl = false;
        RegexpOptions regexpOptions = new RegexpOptions();
        ByteList byteList = new ByteList(string3.getBytes());
        if (string4.contains("i")) {
            regexpOptions.setIgnorecase(true);
        }
        if (string4.contains("m")) {
            regexpOptions.setMultiline(true);
        }
        if (string4.contains("s")) {
            regexpOptions.setMultiline(true);
        }
        if (string4.contains("x")) {
            regexpOptions.setExtended(true);
        }
        this._put(string2, RubyRegexp.newRegexp(this._runtime, byteList, regexpOptions));
    }

    @Override
    public void gotString(String string2, String string3) {
        RubyString rubyString = RubyString.newString(this._runtime, string3);
        this._put(string2, rubyString);
    }

    @Override
    public void gotSymbol(String string2, String string3) {
        ByteList byteList = new ByteList(string3.getBytes());
        RubySymbol rubySymbol = this._runtime.getSymbolTable().getSymbol(byteList);
        this._put(string2, rubySymbol);
    }

    @Override
    public void gotTimestamp(String string2, int n, int n2) {
        RubyFixnum rubyFixnum = RubyFixnum.newFixnum(this._runtime, n);
        RubyFixnum rubyFixnum2 = RubyFixnum.newFixnum(this._runtime, n2);
        Object[] objectArray = new RubyObject[]{rubyFixnum, rubyFixnum2};
        Object object = JavaEmbedUtils.invokeMethod(this._runtime, this._rbclsTimestamp, "new", objectArray, Object.class);
        this._put(string2, (RubyObject)object);
    }

    @Override
    public void gotObjectId(String string2, ObjectId objectId) {
        byte[] byArray = objectId.toByteArray();
        RubyArray rubyArray = RubyArray.newArray(this._runtime, 12);
        for (int j = 0; j < byArray.length; ++j) {
            rubyArray.store(j, this._runtime.newFixnum(byArray[j] & 0xFF));
        }
        Object[] objectArray = new Object[]{rubyArray};
        Object object = JavaEmbedUtils.invokeMethod(this._runtime, this._rbclsObjectId, "new", objectArray, Object.class);
        this._put(string2, (RubyObject)object);
    }

    @Override
    @Deprecated
    public void gotDBRef(String string2, String string3, ObjectId objectId) {
        throw new UnsupportedOperationException();
    }

    private RubyArray ja2ra(byte[] byArray) {
        RubyArray rubyArray = RubyArray.newArray(this._runtime, byArray.length);
        for (int j = 0; j < byArray.length; ++j) {
            rubyArray.store(j, this._runtime.newFixnum(byArray[j]));
        }
        return rubyArray;
    }

    @Override
    @Deprecated
    public void gotBinaryArray(String string2, byte[] byArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void gotBinary(String string2, byte by, byte[] byArray) {
        RubyArray rubyArray = this.ja2ra(byArray);
        Object[] objectArray = new Object[]{rubyArray, RubyFixnum.newFixnum(this._runtime, Math.abs(by))};
        Object object = JavaEmbedUtils.invokeMethod(this._runtime, this._rbclsBinary, "new", objectArray, Object.class);
        this._put(string2, (RubyObject)object);
    }

    protected void _put(String string2, RubyObject rubyObject) {
        RubyObject rubyObject2 = this.cur();
        if (rubyObject2 instanceof RubyArray) {
            RubyArray rubyArray = (RubyArray)rubyObject2;
            Long l = Long.parseLong(string2);
            rubyArray.store(l, rubyObject);
        } else {
            RubyString rubyString = RubyString.newString(this._runtime, string2);
            JavaEmbedUtils.invokeMethod(this._runtime, rubyObject2, "[]=", new Object[]{rubyString, rubyObject}, Object.class);
        }
    }

    protected RubyObject cur() {
        return this._stack.getLast();
    }

    @Override
    public Object get() {
        return this._root;
    }

    protected void setRoot(RubyHash rubyHash) {
        this._root = rubyHash;
    }

    protected boolean isStackEmpty() {
        return this._stack.size() < 1;
    }
}

