/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.PlainTransportFuture;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportFuture;
import org.elasticsearch.transport.TransportInfo;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.TransportStats;

public class TransportService
extends AbstractLifecycleComponent<TransportService> {
    private final Transport transport;
    private final ThreadPool threadPool;
    volatile ImmutableMap<String, TransportRequestHandler> serverHandlers = ImmutableMap.of();
    final Object serverHandlersMutex = new Object();
    final ConcurrentMapLong<RequestHolder> clientHandlers = ConcurrentCollections.newConcurrentMapLong();
    final AtomicLong requestIds = new AtomicLong();
    final CopyOnWriteArrayList<TransportConnectionListener> connectionListeners = new CopyOnWriteArrayList();
    final Map<Long, TimeoutInfoHolder> timeoutInfoHandlers = Collections.synchronizedMap(new LinkedHashMap<Long, TimeoutInfoHolder>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    });
    private boolean throwConnectException = false;
    private final Adapter adapter = new Adapter();

    public TransportService(Transport transport, ThreadPool threadPool) {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS, transport, threadPool);
    }

    @Inject
    public TransportService(Settings settings, Transport transport, ThreadPool threadPool) {
        super(settings);
        this.transport = transport;
        this.threadPool = threadPool;
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        this.adapter.rxMetric.clear();
        this.adapter.txMetric.clear();
        this.transport.transportServiceAdapter(this.adapter);
        this.transport.start();
        if (this.transport.boundAddress() != null && this.logger.isInfoEnabled()) {
            this.logger.info("{}", this.transport.boundAddress());
        }
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.transport.stop();
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        this.transport.close();
    }

    public boolean addressSupported(Class<? extends TransportAddress> address2) {
        return this.transport.addressSupported(address2);
    }

    public TransportInfo info() {
        return new TransportInfo(this.boundAddress());
    }

    public TransportStats stats() {
        return new TransportStats(this.transport.serverOpen(), this.adapter.rxMetric.count(), this.adapter.rxMetric.sum(), this.adapter.txMetric.count(), this.adapter.txMetric.sum());
    }

    public BoundTransportAddress boundAddress() {
        return this.transport.boundAddress();
    }

    public boolean nodeConnected(DiscoveryNode node) {
        return this.transport.nodeConnected(node);
    }

    public void connectToNode(DiscoveryNode node) throws ConnectTransportException {
        this.transport.connectToNode(node);
    }

    public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
        this.transport.connectToNodeLight(node);
    }

    public void disconnectFromNode(DiscoveryNode node) {
        this.transport.disconnectFromNode(node);
    }

    public void addConnectionListener(TransportConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(TransportConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public void throwConnectException(boolean throwConnectException) {
        this.throwConnectException = throwConnectException;
    }

    public <T extends TransportResponse> TransportFuture<T> submitRequest(DiscoveryNode node, String action, TransportRequest request, TransportResponseHandler<T> handler) throws TransportException {
        return this.submitRequest(node, action, request, TransportRequestOptions.EMPTY, handler);
    }

    public <T extends TransportResponse> TransportFuture<T> submitRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options2, TransportResponseHandler<T> handler) throws TransportException {
        PlainTransportFuture<T> futureHandler = new PlainTransportFuture<T>(handler);
        this.sendRequest(node, action, request, options2, futureHandler);
        return futureHandler;
    }

    public <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportResponseHandler<T> handler) throws TransportException {
        this.sendRequest(node, action, request, TransportRequestOptions.EMPTY, handler);
    }

    public <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options2, final TransportResponseHandler<T> handler) throws TransportException {
        long requestId = this.newRequestId();
        TimeoutHandler timeoutHandler = null;
        try {
            if (options2.timeout() != null) {
                timeoutHandler = new TimeoutHandler(requestId);
                timeoutHandler.future = this.threadPool.schedule(options2.timeout(), "generic", timeoutHandler);
            }
            this.clientHandlers.put(requestId, new RequestHolder<T>(handler, node, action, timeoutHandler));
            this.transport.sendRequest(node, requestId, action, request, options2);
        }
        catch (Exception e) {
            this.clientHandlers.remove(requestId);
            if (timeoutHandler != null) {
                timeoutHandler.future.cancel(false);
            }
            if (this.throwConnectException && e instanceof ConnectTransportException) {
                throw (ConnectTransportException)e;
            }
            final SendRequestTransportException sendRequestException = new SendRequestTransportException(node, action, e);
            this.threadPool.executor("generic").execute(new Runnable(){

                @Override
                public void run() {
                    handler.handleException(sendRequestException);
                }
            });
        }
    }

    private long newRequestId() {
        return this.requestIds.getAndIncrement();
    }

    public TransportAddress[] addressesFromString(String address2) throws Exception {
        return this.transport.addressesFromString(address2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHandler(String action, TransportRequestHandler handler) {
        Object object = this.serverHandlersMutex;
        synchronized (object) {
            TransportRequestHandler handlerReplaced = this.serverHandlers.get(action);
            this.serverHandlers = MapBuilder.newMapBuilder(this.serverHandlers).put(action, handler).immutableMap();
            if (handlerReplaced != null) {
                this.logger.warn("Registered two transport handlers for action {}, handlers: {}, {}", action, handler, handlerReplaced);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(String action) {
        Object object = this.serverHandlersMutex;
        synchronized (object) {
            this.serverHandlers = MapBuilder.newMapBuilder(this.serverHandlers).remove(action).immutableMap();
        }
    }

    static class RequestHolder<T extends TransportResponse> {
        private final TransportResponseHandler<T> handler;
        private final DiscoveryNode node;
        private final String action;
        private final TimeoutHandler timeout;

        RequestHolder(TransportResponseHandler<T> handler, DiscoveryNode node, String action, TimeoutHandler timeout2) {
            this.handler = handler;
            this.node = node;
            this.action = action;
            this.timeout = timeout2;
        }

        public TransportResponseHandler<T> handler() {
            return this.handler;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public String action() {
            return this.action;
        }

        public void cancel() {
            if (this.timeout != null) {
                this.timeout.future.cancel(false);
            }
        }
    }

    static class TimeoutInfoHolder {
        private final DiscoveryNode node;
        private final String action;
        private final long sentTime;
        private final long timeoutTime;

        TimeoutInfoHolder(DiscoveryNode node, String action, long sentTime, long timeoutTime) {
            this.node = node;
            this.action = action;
            this.sentTime = sentTime;
            this.timeoutTime = timeoutTime;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public String action() {
            return this.action;
        }

        public long sentTime() {
            return this.sentTime;
        }

        public long timeoutTime() {
            return this.timeoutTime;
        }
    }

    class TimeoutHandler
    implements Runnable {
        private final long requestId;
        private final long sentTime = System.currentTimeMillis();
        ScheduledFuture future;

        TimeoutHandler(long requestId) {
            this.requestId = requestId;
        }

        public long sentTime() {
            return this.sentTime;
        }

        @Override
        public void run() {
            if (this.future.isCancelled()) {
                return;
            }
            RequestHolder holder = TransportService.this.clientHandlers.remove(this.requestId);
            if (holder != null) {
                long timeoutTime = System.currentTimeMillis();
                TransportService.this.timeoutInfoHandlers.put(this.requestId, new TimeoutInfoHolder(holder.node(), holder.action(), this.sentTime, timeoutTime));
                holder.handler().handleException(new ReceiveTimeoutTransportException(holder.node(), holder.action(), "request_id [" + this.requestId + "] timed out after [" + (timeoutTime - this.sentTime) + "ms]"));
            }
        }
    }

    class Adapter
    implements TransportServiceAdapter {
        final MeanMetric rxMetric = new MeanMetric();
        final MeanMetric txMetric = new MeanMetric();

        Adapter() {
        }

        @Override
        public void received(long size2) {
            this.rxMetric.inc(size2);
        }

        @Override
        public void sent(long size2) {
            this.txMetric.inc(size2);
        }

        @Override
        public TransportRequestHandler handler(String action) {
            return TransportService.this.serverHandlers.get(action);
        }

        @Override
        public TransportResponseHandler remove(long requestId) {
            RequestHolder holder = TransportService.this.clientHandlers.remove(requestId);
            if (holder == null) {
                TimeoutInfoHolder timeoutInfoHolder = TransportService.this.timeoutInfoHandlers.remove(requestId);
                if (timeoutInfoHolder != null) {
                    long time = System.currentTimeMillis();
                    TransportService.this.logger.warn("Received response for a request that has timed out, sent [{}ms] ago, timed out [{}ms] ago, action [{}], node [{}], id [{}]", time - timeoutInfoHolder.sentTime(), time - timeoutInfoHolder.timeoutTime(), timeoutInfoHolder.action(), timeoutInfoHolder.node(), requestId);
                } else {
                    TransportService.this.logger.warn("Transport response handler not found of id [{}]", requestId);
                }
                return null;
            }
            holder.cancel();
            return holder.handler();
        }

        @Override
        public void raiseNodeConnected(final DiscoveryNode node) {
            TransportService.this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    for (TransportConnectionListener connectionListener : TransportService.this.connectionListeners) {
                        connectionListener.onNodeConnected(node);
                    }
                }
            });
        }

        @Override
        public void raiseNodeDisconnected(final DiscoveryNode node) {
            if (TransportService.this.lifecycle.stoppedOrClosed()) {
                return;
            }
            TransportService.this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    for (TransportConnectionListener transportConnectionListener : TransportService.this.connectionListeners) {
                        transportConnectionListener.onNodeDisconnected(node);
                    }
                    for (Map.Entry entry : TransportService.this.clientHandlers.entrySet()) {
                        RequestHolder holderToNotify;
                        RequestHolder holder = (RequestHolder)entry.getValue();
                        if (!holder.node().equals(node) || (holderToNotify = (RequestHolder)TransportService.this.clientHandlers.remove(entry.getKey())) == null) continue;
                        TransportService.this.threadPool.generic().execute(new Runnable(){

                            @Override
                            public void run() {
                                holderToNotify.handler().handleException(new NodeDisconnectedException(node, holderToNotify.action()));
                            }
                        });
                    }
                }
            });
        }
    }
}

