/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.unit.TimeValue;

public class TransportRequestOptions {
    public static final TransportRequestOptions EMPTY = TransportRequestOptions.options();
    private TimeValue timeout;
    private boolean compress;
    private Type type = Type.MED;

    public static TransportRequestOptions options() {
        return new TransportRequestOptions();
    }

    public TransportRequestOptions withTimeout(long timeout2) {
        return this.withTimeout(TimeValue.timeValueMillis(timeout2));
    }

    public TransportRequestOptions withTimeout(TimeValue timeout2) {
        this.timeout = timeout2;
        return this;
    }

    public TransportRequestOptions withCompress(boolean compress) {
        this.compress = compress;
        return this;
    }

    public TransportRequestOptions withType(Type type2) {
        this.type = type2;
        return this;
    }

    public TransportRequestOptions withHighType() {
        this.type = Type.HIGH;
        return this;
    }

    public TransportRequestOptions withMedType() {
        this.type = Type.MED;
        return this;
    }

    public TransportRequestOptions withLowType() {
        this.type = Type.LOW;
        return this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public boolean compress() {
        return this.compress;
    }

    public Type type() {
        return this.type;
    }

    public static enum Type {
        LOW,
        MED,
        HIGH;


        public static Type fromString(String type2) {
            if ("low".equalsIgnoreCase(type2)) {
                return LOW;
            }
            if ("med".equalsIgnoreCase(type2)) {
                return MED;
            }
            if ("high".equalsIgnoreCase(type2)) {
                return HIGH;
            }
            throw new ElasticSearchIllegalArgumentException("failed to match transport type for [" + type2 + "]");
        }
    }
}

