/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.search.geo.GeoDistance;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class GeoDistanceSortBuilder
extends SortBuilder {
    final String fieldName;
    private double lat;
    private double lon;
    private String geohash;
    private GeoDistance geoDistance;
    private DistanceUnit unit;
    private SortOrder order;

    public GeoDistanceSortBuilder(String fieldName) {
        this.fieldName = fieldName;
    }

    public GeoDistanceSortBuilder point(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        return this;
    }

    public GeoDistanceSortBuilder geohash(String geohash) {
        this.geohash = geohash;
        return this;
    }

    public GeoDistanceSortBuilder geoDistance(GeoDistance geoDistance) {
        this.geoDistance = geoDistance;
        return this;
    }

    public GeoDistanceSortBuilder unit(DistanceUnit unit) {
        this.unit = unit;
        return this;
    }

    @Override
    public GeoDistanceSortBuilder order(SortOrder order2) {
        this.order = order2;
        return this;
    }

    @Override
    public SortBuilder missing(Object missing) {
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("_geo_distance");
        if (this.geohash != null) {
            builder.field(this.fieldName, this.geohash);
        } else {
            builder.startArray(this.fieldName).value(this.lon).value(this.lat).endArray();
        }
        if (this.unit != null) {
            builder.field("unit", (Object)this.unit);
        }
        if (this.geoDistance != null) {
            builder.field("distance_type", this.geoDistance.name().toLowerCase());
        }
        if (this.order == SortOrder.DESC) {
            builder.field("reverse", true);
        }
        builder.endObject();
        return builder;
    }
}

